/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.DBMSSTORE;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MYSQL
extends DBMSSTORE {
    private static WAdminResource bundle = WAdminResource.getBundle(MYSQL.class);
    private static final String IMPLICIT_UPDATE = "IMPLICIT";
    private static final String PASSTHRU_UPDATE = "PASSTHRU";
    private static final String BY_UPDATE = "BY";
    private static final String KEY_UPDATE = "KEY";

    public MYSQL() {
        this.setAddKeyDelimiter(",");
        this.setExcludeCOwnFromIndexCreate(false);
    }

    @Override
    public void dropSingleIndex(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = MYSQL.getTableName(this.getDataLocation(cgReq, true, true));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        boolean quoting = cgReq.getQuoting();
        if (quoting) {
            cgReq.addSourceCode("drop index \"%trim(%bquote(&etls_indexName))\" on ").addSourceCode(tableName).addSourceCode("\n");
        } else {
            cgReq.addSourceCode("drop index &etls_indexName on ").addSourceCode(tableName).addSourceCode("\n");
        }
    }

    @Override
    public void queryIndexes(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableNameQ = MYSQL.getTableName(this.getDataLocation(cgReq, true, true));
        if (tableNameQ == null || tableNameQ.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.indent().addSourceCode("from \n").indent().addSourceCode("( \n").addSourceCode(" select distinct index_name as idxname, \n").addSourceCode("        table_name as tabname \n").indent().addSourceCode(" from connection to ").addSourceCode(this.getNickname()).addSourceCode("\n").indent().addSourceCode(" (DBMS::Indexes (\"\", \"\", ");
        cgReq.addSourceCode(tableNameQ);
        cgReq.addSourceCode(")) \n").unIndent().unIndent().addSourceCode(");\n").unIndent().unIndent();
    }

    @Override
    public void genMatchingRowsPrelim(CodegenRequest cgReq) {
        cgReq.addSourceCode("\n").genPercentPutStatement(bundle.getString("DBMSSTORE.KeyNeededForMatching.note.sasmacro.notrans")).addSourceCode("\n");
    }

    @Override
    public void update(CodegenRequest cgReq) throws MdException, RemoteException {
        AssociationList columnList;
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.Update.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.Update.note.sasmacro.notrans")).addSourceCode("\n");
        String tableName = this.getDataLocation(cgReq);
        StringBuffer gen_opts = this.getDSOptions();
        if (gen_opts.length() > 0) {
            gen_opts.insert(0, " (").append(")");
        }
        if ((columnList = this.m_table.getColumns()).size() <= 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnsDefined.msg.txt"));
        }
        String updateType = this.m_TLO.getUpdateType();
        if (updateType.equalsIgnoreCase(IMPLICIT_UPDATE)) {
            int i;
            String whereMTTab1 = "                    ";
            String whereMTTab2 = whereMTTab1 + "     ";
            StringBuffer whereMT = new StringBuffer(whereMTTab1 + "where");
            StringBuffer whereT = new StringBuffer("where");
            StringBuffer setStatement = new StringBuffer("set");
            Vector keyList = this.m_TLO.getKeyList();
            if (keyList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            ArrayList<String> keyColumnsList = new ArrayList<String>();
            ArrayList<String> columnNamesList = new ArrayList<String>();
            String colList = cgReq.makeColumnList((List)columnList, false, "    ", false, ",", "");
            for (i = 0; i < columnList.size(); ++i) {
                Column col = (Column)columnList.get(i);
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                String columnName = colCG.getColumnName(cgReq, false);
                int index = keyList.indexOf(col.getSASColumnName());
                if (index < 0) {
                    columnNamesList.add(columnName);
                    continue;
                }
                keyColumnsList.add(columnName);
            }
            if (keyColumnsList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            for (i = 0; i < keyColumnsList.size(); ++i) {
                String key = (String)keyColumnsList.get(i);
                if (i > 0) {
                    whereMT.append(" and \n" + whereMTTab2);
                }
                whereMT.append(" m." + key + "=t." + key);
                if (i > 0) {
                    whereT.append(" and \n        ");
                }
                whereT.append(" " + key + " in (select distinct " + key + " from &etls_lastTable)");
            }
            for (i = 0; i < columnNamesList.size(); ++i) {
                String columnName = (String)columnNamesList.get(i);
                if (i > 0) {
                    setStatement.append(",\n      ");
                }
                setStatement.append(" " + columnName + " = (select " + columnName + " from &etls_lastTable as t \n" + whereMT + ")");
            }
            cgReq.addSourceCode("proc sql; \n\n").indent().addCommentLine(bundle.getString("DBMSSTORE.UpdateRecords.msg.notrans")).addSourceCode("update ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" as m\n").indent().addSourceCode(setStatement.toString()).addSourceCode("\n").indent().addSourceCode(whereT).addSourceCode("\n").unIndent().unIndent().addSourceCode(";\n\n").addCommentLine(bundle.getString("DBMSSTORE.CreateTempTable.msg.notrans")).addSourceCode("create table newRecords as \n").indent().addSourceCode("select * \n").indent().addSourceCode("from &etls_lastTable as t \n").indent().addSourceCode("where not exists \n").addSourceCode("   (select * from ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" as m \n").addSourceCode(whereMT.toString()).addSourceCode(")\n").unIndent().unIndent().unIndent().addSourceCode("; \n\n").addCommentLine(bundle.getString("DBMSSTORE.InsertRecords.msg.notrans")).addSourceCode("insert into ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" \n").addSourceCode("   (").addSourceCode(colList).addSourceCode(")\n").indent().addSourceCode("select \n").addSourceCode(cgReq.getDefaultIndent()).addSourceCode(" ").addSourceCode(colList).addSourceCode("\n").indent().addSourceCode("from newRecords \n").unIndent().unIndent().addSourceCode("; \n\n").addCommentLine(bundle.getString("DBMSSTORE.DeleteTempTable.msg.notrans")).addSourceCode("drop table newRecords; \n\n").unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc");
        } else if (updateType.equalsIgnoreCase(PASSTHRU_UPDATE)) {
            int i;
            String intTable;
            String tableNamePT = this.getDataLocation(cgReq, true, true);
            String libref = MYSQL.getLibref(tableName);
            String librefPT = MYSQL.getLibref(tableNamePT);
            String fullIntTable = intTable = cgReq.getUniqueWorkTableName();
            if (!librefPT.equals("")) {
                fullIntTable = librefPT + "." + fullIntTable;
            }
            StringBuffer whereMT = new StringBuffer("      where");
            StringBuffer setStatement = new StringBuffer("");
            Vector keyList = this.m_TLO.getKeyList();
            if (keyList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            ArrayList<String> keyColumnsList = new ArrayList<String>();
            ArrayList<String> columnNamesList = new ArrayList<String>();
            String colList = cgReq.makeColumnList((List)columnList, false, "      ", this.m_passthru, ",", "");
            for (i = 0; i < columnList.size(); ++i) {
                Column col = (Column)columnList.get(i);
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                String columnName = colCG.getColumnName(cgReq, false);
                int index = keyList.indexOf(col.getSASColumnName());
                if (index < 0) {
                    columnNamesList.add(columnName);
                    continue;
                }
                keyColumnsList.add(columnName);
            }
            if (keyColumnsList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            for (i = 0; i < keyColumnsList.size(); ++i) {
                String key = (String)keyColumnsList.get(i);
                if (i > 0) {
                    whereMT.append(" and \n           ");
                }
                whereMT.append(" " + tableName + "." + key + " = " + intTable + "." + key);
            }
            for (i = 0; i < columnNamesList.size(); ++i) {
                String columnName = (String)columnNamesList.get(i);
                if (i > 0) {
                    setStatement.append(",\n          ");
                }
                setStatement.append(" " + columnName + " = " + intTable + "." + columnName);
            }
            cgReq.addSourceCode("proc sql; \n\n").indent();
            this.genConnect(cgReq);
            cgReq.addSourceCode("\n").addCommentLine(bundle.getString("DBMSSTORE.CreateTempTable2.msg.notrans")).addSourceCode("create table ").addSourceCode(libref).addSourceCode(".").addSourceCode(intTable).addSourceCode(" (bulkload=YES) as \n").indent().addSourceCode("select * from &etls_lastTable \n").unIndent().addSourceCode("  ; \n\n").addCommentLine(bundle.getString("DBMSSTORE.UpdateRecords.msg.notrans"));
            this.genExecuteBegin(cgReq, "");
            cgReq.addSourceCode("update ").addSourceCode(tableNamePT).addSourceCode(gen_opts.toString()).addSourceCode(" as m \n").indent().addSourceCode("set").addSourceCode(setStatement.toString()).addSourceCode("\n").addSourceCode(whereMT.toString()).addSourceCode("\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.DeleteRows.msg.notrans")).addSourceCode("delete from ").addSourceCode(fullIntTable).addSourceCode("\n").addSourceCode(whereMT.toString()).addSourceCode("\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.InsertRecords.msg.notrans")).addSourceCode("insert into ").addSourceCode(tableNamePT).addSourceCode(gen_opts.toString()).addSourceCode(" \n").addSourceCode("   (").addSourceCode(colList).addSourceCode(")\n").indent().addSourceCode("select \n").indent().addSourceCode(colList).addSourceCode(" \n").unIndent().addSourceCode("from ").addSourceCode(fullIntTable).addSourceCode(" \n\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.DeleteTempTable.msg.notrans")).addSourceCode("drop table ").addSourceCode(fullIntTable).addSourceCode(" \n");
            this.genExecuteEnd(cgReq, "  ");
            this.genExecuteCommit(cgReq, "  ");
            this.genDisconnect(cgReq);
            cgReq.addSourceCode("\n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
        } else if (updateType.equalsIgnoreCase(BY_UPDATE)) {
            Vector keyList;
            boolean noMiss = this.m_TLO.getNoMissingCheck();
            String option = "";
            if (noMiss) {
                option = "updatemode = nomissingcheck \n";
            }
            if ((keyList = this.m_TLO.getKeyList()).size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            StringBuffer byList = new StringBuffer();
            if (cgReq.getQuoting()) {
                for (int i = 0; i < keyList.size(); ++i) {
                    String byColumn = (String)keyList.get(i);
                    byList.append("\"" + byColumn + "\"n ");
                }
            } else {
                byList.append(cgReq.makeColumnList(keyList, "   "));
            }
            boolean resetLibname = this.genRereadExposure(cgReq);
            cgReq.addSourceCode("data " + tableName + gen_opts.toString() + "; \n\n").indent().addSourceCode("modify " + tableName + "\n").addSourceCode("       &etls_lastTable");
            if (option.length() > 0) {
                cgReq.addSourceCode("\n       " + option);
            }
            cgReq.addSourceCode("; \n\n").addSourceCode("by " + byList.toString() + ";\n\n").addCommentLine(bundle.getString("DBMSSTORE.RecordDoesNotExist.msg.notrans")).addSourceCode("if %sysrc(_DSENMR) eq _iorc_ then \n").indent().addSourceCode("output; \n\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.RecordExists.msg.notrans")).addSourceCode("else if %sysrc(_SOK) eq _iorc_ then \n").indent().addSourceCode("replace; \n\n").unIndent().addSourceCode("_iorc_ = 0; \n").addSourceCode("_error_ = 0; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
            this.genLibname(cgReq, resetLibname);
        } else if (updateType.equalsIgnoreCase(KEY_UPDATE)) {
            String index = DBMSNamesUtil.getQuotedString((String)this.m_TLO.getIndex(), (DataTable)this.m_table);
            AssociationList indexList = this.m_table.getIndexes();
            if (index == null || index.length() == 0 || indexList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoIndexSelected.msg.txt"));
            }
            ArrayList<String> ixColumns = new ArrayList<String>();
            for (int i = 0; i < indexList.size(); ++i) {
                Index ix = (Index)indexList.get(i);
                String ixName = ix.getName();
                if (!ixName.equalsIgnoreCase(index)) continue;
                AssociationList columnsList = ix.getColumns();
                for (int j = 0; j < columnsList.size(); ++j) {
                    String colName = ((Column)columnsList.get(j)).getSASColumnName();
                    ixColumns.add(colName);
                }
                break;
            }
            String unique = "";
            if (this.m_TLO.getUnique()) {
                unique = " / unique";
            }
            StringBuffer rename = new StringBuffer("(rename=(");
            StringBuffer assign = new StringBuffer("");
            int counter = 0;
            for (int i = 0; i < columnList.size(); ++i) {
                Column col = (Column)columnList.get(i);
                String sasColumnName = col.getSASColumnName();
                if (ixColumns.indexOf(sasColumnName) >= 0) continue;
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                String columnName = colCG.getColumnName(cgReq, false);
                String tempColumnName = columnName.startsWith("\"") ? columnName.replaceFirst("\"", "\"etls_") : (columnName.startsWith("'") ? columnName.replaceFirst("'", "'etls_") : "etls_" + columnName);
                if (counter > 0) {
                    rename.append("\n             ");
                }
                rename.append(columnName + " = " + tempColumnName);
                assign.append(columnName + " = " + tempColumnName + ";\n");
                ++counter;
            }
            rename.append("))");
            boolean resetLibname = this.genRereadExposure(cgReq);
            cgReq.addSourceCode("data " + tableName + gen_opts.toString() + "; \n\n").indent().addSourceCode("set &etls_lastTable \n").indent().indent().addSourceCode(" " + rename.toString() + "\n").unIndent().unIndent().addSourceCode("; \n\n").addSourceCode("modify " + tableName + gen_opts.toString() + "\n").addSourceCode("       key = " + index + unique + ";\n\n").addSourceCode("if %sysrc(_DSENMR) eq _iorc_ or \n").addSourceCode("   %sysrc(_DSENOM) eq _iorc_ or \n").addSourceCode("   %sysrc(_DSEMTR) eq _iorc_ or \n").addSourceCode("   %sysrc(_SOK) eq _iorc_ then \n").addSourceCode("do; \n").indent().addSourceCode(assign + "\n").addCommentLine(bundle.getString("DBMSSTORE.RecordExists.msg.notrans")).addSourceCode("if %sysrc(_SOK) eq _iorc_ then \n").indent().addSourceCode("replace; \n\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.RecordDoesNotExist.msg.notrans")).addSourceCode("else \n").indent().addSourceCode("output; \n").unIndent().unIndent().addSourceCode("end; \n\n").addSourceCode("_iorc_ = 0; \n").addSourceCode("_error_ = 0; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
            this.genLibname(cgReq, resetLibname);
        }
    }

    @Override
    public void drop(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.DropTable.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.DropTable.note.sasmacro.notrans"));
        String tableName = this.getDataLocation(cgReq);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("proc sql; \n").indent().addSourceCode("drop table ").addSourceCode(tableName).addSourceCode("; \n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc").addSourceCode("%let etls_tableExist = 0;\n\n");
    }
}

