/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.UniqueKey;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class IndexCG
extends CodeGenRoot {
    private static WAdminResource bundle = WAdminResource.getBundle(IndexCG.class);

    public String getIndexName(CodegenRequest cgReq) throws MdException, RemoteException {
        return this.getIndexName(cgReq, false);
    }

    public String getIndexName(CodegenRequest cgReq, boolean passthru) throws MdException, RemoteException {
        Index index = (Index)this.getMetadataClass();
        String name = index.getName();
        if (name == null || name.trim().length() <= 0) {
            throw new CodegenException(bundle.getString("IndexCG.MissingIndexName.msg.txt"));
        }
        PhysicalTable table = index.getOwningPhysicalTable();
        if (table == null) {
            throw new CodegenException(bundle.getString("IndexCG.MissingIndexTable.msg.txt"));
        }
        name = DBMSNamesUtil.getQuotedIndexName((Index)index, (boolean)cgReq.getQuoting(), (boolean)passthru);
        return name;
    }

    public UniqueKey getPrimaryKeyUsingIndex() throws MdException, RemoteException {
        Index index = (Index)this.getMetadataClass();
        PhysicalTable pTable = index.getOwningPhysicalTable();
        int keySize = pTable.getUniqueKeys().size();
        UniqueKey key = null;
        for (int i = 0; i < keySize; ++i) {
            UniqueKey tempKey = (UniqueKey)pTable.getUniqueKeys().get(i);
            if (tempKey.getIsPrimary() != 1 || tempKey.getKeyedColumns().size() != index.getColumns().size()) continue;
            for (int j = 0; j < tempKey.getKeyedColumns().size(); ++j) {
                Column col = (Column)tempKey.getKeyedColumns().get(j);
                if (col == (Column)index.getColumns().get(j)) continue;
                return null;
            }
            key = tempKey;
        }
        return key;
    }
}

