/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ExternalTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class FileWriterCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(FileWriterCodegen.class);
    private static final String FILE_OPTION = "FileOptions";

    public static void codegen(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        DataTable sourceTable = cgReq.getSourceTable(classifierMap);
        ExternalTable targetTable = cgReq.getTargetExternalTable(classifierMap);
        ExternalTableCG targetTableCG = (ExternalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)classifierMap);
        OP.setUsePropertySet(true);
        String fileOptions = OP.getSpecificOptionValue(FILE_OPTION);
        targetTableCG.getModel().setFileOptions(fileOptions);
        AutoExtract.columnMapping(classifierMap, cgReq, true, (DataTable)targetTable, "work.mapped");
        cgReq.addSourceCode(targetTableCG.getLoaderDataStep());
        cgReq.genRCSetCall("&syserr");
        if (cgReq.getJobStatus()) {
            cgReq.addCommentLine(bundle.getString("FileWriterCodegen.JobStatus.txt"));
            cgReq.addSourceCode("%let etls_recordsBefore = 0; \n");
            if (sourceTable instanceof PhysicalTable) {
                cgReq.addSourceCode("\n").genGetNumRows((PhysicalTable)sourceTable, "etls_recordsAfter");
            } else {
                cgReq.addSourceCode("%let etls_recordsAfter = 0; \n");
            }
            String file = targetTable.getOwningFile().getFileName();
            if (file.length() > 32) {
                file = file.substring(file.length() - 32);
            }
            file = cgReq.getEscapedMacroValue(file);
            cgReq.addSourceCode("%let etls_table = %nrquote(").addSourceCode(file).addSourceCode(");\n");
            cgReq.addSourceCode("%let etls_lib = ;\n\n");
        }
        FileWriterCodegen.genCodeConditionCheck(cgReq, classifierMap);
    }

    public static void genCodeConditionCheck(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        TransformationStep oStep = (TransformationStep)classifierMap.getSteps(false).get(0);
        AssociationList alTriggeredEvents = oStep.getTriggeredEvents();
        if (alTriggeredEvents.isEmpty()) {
            return;
        }
        cgReq.addCommentLine(bundle.getString("FileWriterCodegen.RCCheck.msg.txt"));
        cgReq.addSourceCode("%macro etls_writerCheck; \n\n").indent();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event lEvent = (Event)alTriggeredEvents.get(iEvent);
            String eventRole = lEvent.getEventRole();
            if (!eventRole.equals("Condition1") && !eventRole.equals("Condition2") && !eventRole.equals("Condition3")) continue;
            String lEventCondition = lEvent.getCondition().trim();
            cgReq.addSourceCode(lEventCondition + "\n");
            cgReq.addSourceCode("%do; \n\n").indent();
            if (lEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            PropertySet lTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(lEvent, true);
            AssociationList lTrueProperties = lTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < lTrueProperties.size(); ++iAction) {
                Property oAction = (Property)lTrueProperties.get(iAction);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)oStep));
            }
            cgReq.unIndent().addSourceCode("%end; \n\n");
        }
        cgReq.unIndent().addSourceCode("%mend etls_writerCheck; \n").addSourceCode("%etls_writerCheck; \n\n");
    }
}

