/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.TextStoreCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Text;
import java.rmi.RemoteException;

public class FeatureMapCG
extends CodeGenRoot {
    private static final String ONE_TO_ONE_ROLE = "ONETOONE";

    @Override
    public void codeGen(CodegenRequest cgReq) throws MdException, RemoteException {
        FeatureMap featureMap = (FeatureMap)this.getMetadataClass();
        if (cgReq.onContextList(featureMap.getFQID())) {
            return;
        }
        cgReq.addContextList(featureMap.getFQID());
        this.codeGenSelfOnly(cgReq);
    }

    @Override
    public void codeGenSelfOnly(CodegenRequest cgReq) throws MdException, RemoteException {
        String code = this.makeAsStatement(cgReq);
        if (code.length() > 0) {
            cgReq.addSourceCode("      ").addSourceCode(code);
        }
    }

    public String makeAsStatement(CodegenRequest cgReq) throws MdException, RemoteException {
        StringBuffer asStatement = new StringBuffer();
        FeatureMap featureMap = (FeatureMap)this.getMetadataClass();
        Text source = featureMap.getSourceCode();
        AssociationList targetList = featureMap.getFeatureTargets();
        if (targetList.size() <= 0) {
            return "";
        }
        Column targetColumn = (Column)targetList.get(0);
        ColumnCG targetColumnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)targetColumn);
        if (source != null) {
            TextStoreCG sourceCG = (TextStoreCG)CodeGenUtil.getCodeGenClass((CMetadata)source);
            String text = sourceCG.makeExpression(cgReq, (AbstractTransformation)featureMap);
            asStatement.append(text).append(" as ").append(targetColumnCG.getColumnName(cgReq));
            String attrib = targetColumnCG.getSelectAttrib(cgReq, false, true);
            asStatement.append(attrib);
        } else if (featureMap.getTransformRole().equals(ONE_TO_ONE_ROLE) || source == null) {
            AssociationList sourceList = featureMap.getFeatureSources();
            if (sourceList.size() <= 0) {
                return "";
            }
            Column sourceColumn = (Column)sourceList.get(0);
            ColumnCG sourceColumnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceColumn);
            if (sourceColumn.getSASColumnName().equals(targetColumn.getSASColumnName())) {
                asStatement.append(targetColumnCG.getColumnName(cgReq));
            } else {
                asStatement.append(sourceColumnCG.getColumnName(cgReq) + " as " + targetColumnCG.getColumnName(cgReq));
            }
            int sourceLength = sourceColumn.getSASColumnLength();
            String sourceFormat = sourceColumnCG.getColumnFormat(cgReq);
            String sourceInformat = sourceColumnCG.getColumnInformat(cgReq);
            int targetLength = targetColumn.getSASColumnLength();
            String targetFormat = targetColumnCG.getColumnFormat(cgReq);
            String targetInformat = targetColumnCG.getColumnInformat(cgReq);
            if (targetLength != sourceLength && targetLength > 0) {
                asStatement.append(" length = ").append(String.valueOf(targetLength));
            }
            if (!targetFormat.equalsIgnoreCase(sourceFormat) && targetFormat.length() > 0) {
                asStatement.append(" format = ").append(targetFormat);
            }
            if (!targetInformat.equalsIgnoreCase(sourceInformat) && targetInformat.length() > 0) {
                asStatement.append(" informat = ").append(targetInformat);
            }
        }
        return asStatement.toString();
    }

    public String makeAsssignmentStatement(CodegenRequest cgReq) throws MdException, RemoteException {
        StringBuffer asgnStatement = new StringBuffer();
        FeatureMap featureMap = (FeatureMap)this.getMetadataClass();
        Text source = featureMap.getSourceCode();
        AssociationList targetList = featureMap.getFeatureTargets();
        if (targetList.size() <= 0) {
            return "";
        }
        Column targetColumn = (Column)targetList.get(0);
        ColumnCG targetColumnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)targetColumn);
        String targetColumnName = targetColumnCG.getColumnName(cgReq);
        String attrib = targetColumnCG.getColumnAttrib(cgReq, false, true);
        asgnStatement.append(attrib).append("; \n");
        if (source != null) {
            TextStoreCG sourceCG = (TextStoreCG)CodeGenUtil.getCodeGenClass((CMetadata)source);
            String text = sourceCG.makeExpression(cgReq, (AbstractTransformation)featureMap);
            asgnStatement.append(targetColumnName).append(" = ").append(text).append("; \n");
        } else if (featureMap.getTransformRole().equals(ONE_TO_ONE_ROLE) || source == null) {
            AssociationList sourceList = featureMap.getFeatureSources();
            if (sourceList.size() <= 0) {
                return "";
            }
            Column sourceColumn = (Column)sourceList.get(0);
            ColumnCG sourceColumnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceColumn);
            String sourceColumnName = sourceColumnCG.getColumnName(cgReq);
            asgnStatement.append(targetColumnName).append(" = ").append(sourceColumnName).append(";\n");
        }
        return asgnStatement.toString();
    }
}

