/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.Deployment;
import com.sas.codegen.IndexCG;
import com.sas.codegen.PhysicalTableCG;
import com.sas.codegen.TableLoaderModel;
import com.sas.codegen.TableLoaderOptions;
import com.sas.codegen.WorkTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.UniqueKey;
import com.sas.metadata.remote.WorkTable;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DBMSSTORE
extends WorkTableCG {
    private static WAdminResource bundle = WAdminResource.getBundle(DBMSSTORE.class);
    protected String ClusWord_0;
    protected String m_Nick;
    protected ClassifierMap m_classifierMap;
    protected TableLoaderOptions m_TLO;
    protected TableLoaderModel m_TLM;
    protected boolean m_mapFlag = false;
    protected boolean m_passthru = true;
    protected String m_idxNameLength = "200";
    protected boolean m_indexSupport = true;
    protected boolean m_constraintSupport = true;
    protected boolean m_randomAccessSupport = true;
    protected boolean m_upsertSupport = false;
    protected boolean m_notNullIsConstraint = false;
    protected String m_constraintTypesDroppable = "";
    protected String m_addKeyDelimiter = "";
    protected boolean m_repeatAddKeyCommand = true;
    protected boolean m_addOneKeyPerExecute = false;
    private static final String MODIFY = "Modify";
    private static final String IMPLICIT_UPDATE = "IMPLICIT";
    private static final String PASSTHRU_UPDATE = "PASSTHRU";
    private static final String BY_UPDATE = "BY";
    private static final String KEY_UPDATE = "KEY";
    private static final String APPEND_OPTION = "APPEND";
    protected static final String NEWROWSTABLE = "etls_newrecords";
    private static final String MODIFY_UPDATE_CONDITION = "%sysrc(_SOK) eq _iorc_";
    private static final String MODIFY_NEW_CONDITION = "%sysrc(_DSENMR) eq _iorc_ or \n   %sysrc(_DSENOM) eq _iorc_ or \n   %sysrc(_DSEMTR) eq _iorc_";
    private static final String TEMP_INDEX_TABLE_NAME = "etls_CIList";
    private static final String IC_CREATE_COMMAND = "add";
    public static final String DEFAULT_TABLE_ALIAS_KEYWORD = " as ";
    protected String m_tableAliasKeyword = " as ";

    public DBMSSTORE() {
        this.setClusterWord("CLUSTER");
    }

    @Override
    public void load(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        this.m_classifierMap = classifierMap;
        this.m_table = (PhysicalTable)this.getMetadataClass();
        this.setNickname(cgReq);
        this.m_TLO = new TableLoaderOptions(this.m_classifierMap);
        String loadType = this.m_TLO.getLoadType();
        boolean dropIndex = this.m_TLO.getDropIndex();
        boolean truncate = this.m_TLO.getTruncate();
        cgReq.addSourceCode("%global etls_tableExist;\n").addSourceCode("%global etls_numIndex;\n").addSourceCode("%global etls_lastTable;\n").addSourceCode("%let etls_tableExist = -1; \n").addSourceCode("%let etls_numIndex = -1; \n").addSourceCode("%let etls_lastTable = &SYSLAST; \n\n");
        if (!(loadType.equalsIgnoreCase("Update") || loadType.equalsIgnoreCase("Append") || loadType.equalsIgnoreCase("Refresh"))) {
            throw new CodegenException(bundle.formatString("DBMSSTORE.BadLoadTechnique.msg.txt", (Object)loadType));
        }
        try {
            cgReq.genAdditionalSystemOptions((AbstractTransformation)classifierMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.DefineMacro.msg.notrans")).addSourceCode("%macro etls_loader;\n\n").indent();
        AssociationList lInputs = classifierMap.getClassifierSources();
        int numSources = lInputs.size();
        boolean append = this.m_TLO.stringToBoolean(this.m_TLO.getSpecificOptionValue(APPEND_OPTION));
        if (numSources > 1 && !append) {
            throw new CodegenException(bundle.getString("DBMSSTORE.MultipleInputs.msg.txt"));
        }
        String dsOptions = "";
        if (numSources == 1) {
            DataTableCG sourceTableCG = cgReq.getSourceTableCG(classifierMap);
            dsOptions = sourceTableCG.getSourceTableOptions(false);
            if (dsOptions.length() > 0) {
                cgReq.addSourceCode("%let SYSOPT = %nrquote(").addSourceCode(dsOptions).addSourceCode(");\n\n");
            } else {
                cgReq.addSourceCode("%let SYSOPT = ;\n\n");
            }
        } else {
            cgReq.addSourceCode("%let SYSOPT = ;\n\n");
        }
        String preserveCase = cgReq.getGlobalData("Case");
        String specialChar = cgReq.getGlobalData("SpecChar");
        AssociationList lCols = this.m_table.getColumns();
        boolean hasLoadTime = false;
        String loadColName = this.m_TLO.getLoadTimeSASColumnName();
        boolean loadColOption = true;
        if (loadColName.trim().equals("")) {
            loadColOption = false;
        }
        for (int i = 0; i < lCols.size(); ++i) {
            Column col = (Column)lCols.get(i);
            String name = col.getSASColumnName();
            if ((!preserveCase.equals("Y") || !name.equals(loadColName)) && (preserveCase.equals("Y") || !name.equalsIgnoreCase(loadColName))) continue;
            String type = col.getSASColumnType();
            if (type.equalsIgnoreCase("N")) {
                hasLoadTime = true;
                break;
            }
            throw new CodegenException(bundle.formatString("DBMSSTORE.InvalidColumnType.msg.txt", (Object)loadColName));
        }
        if (!hasLoadTime && loadColOption) {
            throw new CodegenException(bundle.formatString("DBMSSTORE.InvalidColumnName.msg.txt", (Object)loadColName));
        }
        if (numSources > 0 && hasLoadTime || numSources > 1 && append) {
            if (hasLoadTime) {
                cgReq.addSectionComment(bundle.getString("DBMSSTORE.SetLoadTime.msg.notrans"));
            }
            String dsname = cgReq.getUniqueWorkTableName();
            cgReq.genTableDelete(dsname).addSourceCode("data work.").addSourceCode(dsname).addSourceCode(" / view=work.").addSourceCode(dsname).addSourceCode(";\n").indent().addSourceCode("set ");
            if (numSources == 1) {
                cgReq.addSourceCode("&SYSLAST (&SYSOPT)");
            } else if (append) {
                for (int i = 0; i < numSources; ++i) {
                    PhysicalTable sourceTable = (PhysicalTable)lInputs.get(i);
                    PhysicalTableCG sourceTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
                    dsname = sourceTableCG.getDataLocation(cgReq);
                    cgReq.addSourceCode(dsname + "\n    ");
                }
            }
            cgReq.addSourceCode(";\n");
            if (hasLoadTime) {
                if (preserveCase.equals("Y") || specialChar.equals("Y")) {
                    loadColName = DBMSNamesUtil.getQuotedString((String)loadColName, (boolean)false);
                }
                String dtFormat = cgReq.isJobDateFormatNLS((AbstractTransformation)this.m_classifierMap) ? "nldatm32." : "datetime20.";
                cgReq.addSourceCode("\n").addSourceCode(loadColName).addSourceCode(" = input(\"&SYSDATE9 &SYSTIME\",DATETIME20.);\n\n").addSourceCode("if _n_ eq 1 then \n").indent().addSourceCode("put 'NOTE: ").addSourceCode(bundle.getString("DBMSSTORE.LoadtimeNote.msg.notrans")).addSourceCode(" ' ").addSourceCode(loadColName).addSourceCode(" ").addSourceCode(dtFormat).addSourceCode(";\n").unIndent();
            }
            cgReq.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").addSourceCode("%let SYSLAST = work.").addSourceCode(dsname).addSourceCode(";\n").addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            if (dsOptions.length() > 0) {
                cgReq.addSourceCode("%let SYSOPT = ;\n\n");
            } else {
                cgReq.addSourceCode("\n");
            }
        }
        this.exist(cgReq);
        if (loadType.equalsIgnoreCase("Update")) {
            this.create(cgReq);
            this.columnMapping(cgReq);
            this.createIndexes(cgReq);
            this.update(cgReq);
            this.genCodeConditionCheck(cgReq, "Condition4");
        } else {
            if (!loadType.equalsIgnoreCase("Append") || dropIndex) {
                cgReq.addSourceCode("%if (&etls_tableExist gt 0) %then \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.TableExists.msg.notrans")).addSourceCode("\n").indent();
                if (dropIndex && !loadType.equalsIgnoreCase("Refresh") || dropIndex && truncate) {
                    this.dropIndexes(cgReq);
                }
                if (loadType.equalsIgnoreCase("Refresh")) {
                    if (truncate) {
                        this.truncate(cgReq);
                        this.genCodeConditionCheck(cgReq, "Condition8");
                    } else {
                        this.drop(cgReq);
                        this.genCodeConditionCheck(cgReq, "Condition6");
                    }
                }
                cgReq.unIndent().addSourceCode("%end;  ").addCommentLine(bundle.getString("DBMSSTORE.TableExists.msg.notrans")).addSourceCode("\n");
            }
            this.create(cgReq);
            this.columnMapping(cgReq);
            this.append(cgReq);
            this.genCodeConditionCheck(cgReq, "Condition4");
            this.createIndexes(cgReq);
        }
        if (this.m_mapFlag) {
            cgReq.genTableDelete("work.mapped");
        }
        cgReq.unIndent().addSourceCode("%mend etls_loader;\n").addSourceCode("%etls_loader;\n\n");
        this.genCodeConditionCheck(cgReq, "Condition1");
        this.genCodeConditionCheck(cgReq, "Condition2");
        this.genCodeConditionCheck(cgReq, "Condition3");
    }

    public void load2(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        boolean createIndexes;
        this.m_classifierMap = classifierMap;
        this.m_table = (PhysicalTable)this.getMetadataClass();
        this.setNickname(cgReq);
        this.m_TLM = new TableLoaderModel(this.m_classifierMap);
        String loadType = this.m_TLM.getLoadStyleValue();
        this.m_TLO = new TableLoaderOptions(this.m_classifierMap);
        cgReq.addSourceCode("%global etls_tableExist;\n").addSourceCode("%global etls_numIndex;\n").addSourceCode("%global etls_lastTable;\n").addSourceCode("%let etls_tableExist = -1; \n").addSourceCode("%let etls_numIndex = -1; \n").addSourceCode("%let etls_lastTable = &SYSLAST; \n\n");
        try {
            cgReq.genAdditionalSystemOptions((AbstractTransformation)classifierMap);
        }
        catch (MdException mdException) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.DefineMacro.msg.notrans")).addSourceCode("\n");
        this.genParmsInSASLog(cgReq, this.m_TLM);
        cgReq.addSourceCode("%macro etls_loader;\n\n").indent();
        AssociationList lInputs = classifierMap.getClassifierSources();
        int numSources = lInputs.size();
        String dsOptions = "";
        if (numSources == 1) {
            DataTableCG sourceTableCG = cgReq.getSourceTableCG(classifierMap);
            dsOptions = sourceTableCG.getSourceTableOptions(false);
            if (dsOptions.length() > 0) {
                cgReq.addSourceCode("%let SYSOPT = %nrquote(").addSourceCode(dsOptions).addSourceCode(");\n\n");
            } else {
                cgReq.addSourceCode("%let SYSOPT = ;\n\n");
            }
        } else {
            cgReq.addSourceCode("%let SYSOPT = ;\n\n");
        }
        String preserveCase = cgReq.getGlobalData("Case");
        String specialChar = cgReq.getGlobalData("SpecChar");
        AssociationList lCols = this.m_table.getColumns();
        boolean hasLoadTime = false;
        String loadColName = this.m_TLM.getLoadTimeSASColumnName();
        boolean loadColOption = true;
        if (loadColName.trim().equals("")) {
            loadColOption = false;
        }
        for (int i = 0; i < lCols.size(); ++i) {
            Column col = (Column)lCols.get(i);
            String name = col.getSASColumnName();
            if ((!preserveCase.equals("Y") || !name.equals(loadColName)) && (preserveCase.equals("Y") || !name.equalsIgnoreCase(loadColName))) continue;
            String type = col.getSASColumnType();
            if (type.equalsIgnoreCase("N")) {
                hasLoadTime = true;
                break;
            }
            throw new CodegenException(bundle.formatString("DBMSSTORE.InvalidColumnType.msg.txt", (Object)loadColName));
        }
        if (!hasLoadTime && loadColOption) {
            throw new CodegenException(bundle.formatString("DBMSSTORE.InvalidColumnName.msg.txt", (Object)loadColName));
        }
        if (numSources > 0 && hasLoadTime || numSources > 1) {
            if (hasLoadTime) {
                cgReq.addSectionComment(bundle.getString("DBMSSTORE.SetLoadTime.msg.notrans"));
            }
            String dsname = cgReq.getUniqueWorkTableName();
            cgReq.genTableDelete(dsname).addSourceCode("data work.").addSourceCode(dsname).addSourceCode(" / view=work.").addSourceCode(dsname).addSourceCode(";\n").indent().addSourceCode("set ");
            if (numSources == 1) {
                cgReq.addSourceCode("&SYSLAST (&SYSOPT)");
            } else {
                for (int i = 0; i < numSources; ++i) {
                    PhysicalTable sourceTable = (PhysicalTable)lInputs.get(i);
                    PhysicalTableCG sourceTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
                    dsname = sourceTableCG.getDataLocation(cgReq);
                    cgReq.addSourceCode(dsname + "\n    ");
                }
            }
            cgReq.addSourceCode(";\n");
            if (hasLoadTime) {
                if (preserveCase.equals("Y") || specialChar.equals("Y")) {
                    loadColName = DBMSNamesUtil.getQuotedString((String)loadColName, (boolean)false);
                }
                String dtFormat = cgReq.isJobDateFormatNLS((AbstractTransformation)this.m_classifierMap) ? "nldatm32." : "datetime20.";
                cgReq.addSourceCode("\n").addSourceCode(loadColName).addSourceCode(" = input(\"&SYSDATE9 &SYSTIME\",DATETIME20.);\n\n").addSourceCode("if _n_ eq 1 then \n").indent().addSourceCode("put 'NOTE: ").addSourceCode(bundle.getString("DBMSSTORE.LoadtimeNote.msg.notrans")).addSourceCode(" ' ").addSourceCode(loadColName).addSourceCode(" ").addSourceCode(dtFormat).addSourceCode(";\n").unIndent();
            }
            cgReq.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").addSourceCode("%let SYSLAST = work.").addSourceCode(dsname).addSourceCode(";\n").addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            if (dsOptions.length() > 0) {
                cgReq.addSourceCode("%let SYSOPT = ;\n\n");
            } else {
                cgReq.addSourceCode("\n");
            }
        }
        cgReq.genJobStatusUpdateBefore(this.m_table);
        boolean assignUnmappedEqMissing = !loadType.equalsIgnoreCase("Update") || this.m_TLM.getMatchingRowsValue().indexOf(MODIFY) < 0 || this.m_TLM.getUnmappedEqMissingInUpdate();
        this.columnMapping(cgReq, assignUnmappedEqMissing);
        this.exist(cgReq);
        boolean createConstraints = this.getConstraintSupport() && !this.m_TLM.getConstraintBeforeValue().equals("OFF") && !this.m_TLM.getConstraintBeforeValue().equals("ASIS");
        boolean bl = createIndexes = this.getIndexSupport() && !(this.m_TLM.getIndexBeforeValue().equals("OFF") | this.m_TLM.getIndexBeforeValue().equals("ASIS"));
        if (loadType.equalsIgnoreCase("Update")) {
            cgReq.addSourceCode("%let etls_hasUpdateIndex=0; \n\n");
        }
        if (!this.m_TLM.isReplacingTable()) {
            this.create(cgReq, true, createConstraints, createIndexes);
        }
        boolean needNewRowsTable = false;
        Index modifingIndex = null;
        if (loadType.equalsIgnoreCase("Update")) {
            if (!this.m_TLM.getNewRowsValue().equals("ModifyUsingIndex")) {
                int indexSize = this.m_table.getIndexes().size();
                for (int i = 0; i < indexSize; ++i) {
                    Index index = (Index)this.m_table.getIndexes().get(i);
                    AssociationList colList = null;
                    colList = this.m_table instanceof WorkTable ? index.getColumns() : index.getColumns(true);
                    if (this.m_TLM.getSelectedMatchColumns().size() != colList.size()) continue;
                    int columnSize = colList.size();
                    boolean matchFound = true;
                    for (int j = 0; j < columnSize; ++j) {
                        if (colList.get(j) == this.m_TLM.getSelectedMatchColumns().get(j)) continue;
                        matchFound = false;
                        break;
                    }
                    if (!matchFound) continue;
                    modifingIndex = index;
                    break;
                }
            } else {
                modifingIndex = this.m_TLM.getModifyUsingIndex();
            }
            if (this.m_TLM.getMatchingRowsValue().indexOf(MODIFY) >= 0 || this.m_TLM.getNewRowsValue().indexOf(MODIFY) >= 0) {
                this.updateCIPreLoad(cgReq, true, modifingIndex);
                this.loadWithMod(cgReq);
            } else if (this.m_TLM.getMatchingRowsValue().equals("Upsert") || this.m_TLM.getNewRowsValue().equals("Upsert")) {
                this.updateCIPreLoad(cgReq, true, modifingIndex);
                this.loadWithUpsert(cgReq);
            } else {
                this.updateCIPreLoad(cgReq, true, modifingIndex);
                boolean skippingNewRows = this.m_TLM.getNewRowsValue().equals("Skip");
                boolean needSet = this.m_TLM.getMatchingRowsValue().equals("SQLSet");
                if (!skippingNewRows) {
                    needNewRowsTable = true;
                }
                cgReq.genGetNumRows(this.getDataLocation(cgReq), "etls_targetHasRows", true, "1").addSourceCode("\n%if (&etls_targetHasRows) %then \n").addSourceCode("%do;  /* if has rows */ \n").indent();
                this.loadWithSQLMatching(cgReq, needSet, needNewRowsTable);
                cgReq.unIndent().addSourceCode("%end; /* if has rows */ \n\n");
                if (skippingNewRows) {
                    cgReq.addSourceCode("%else \n").addSourceCode("%do; /* else no rows */ \n").indent();
                    this.loadWithAppend(cgReq);
                    cgReq.addSourceCode("%put NOTE: Empty base table was initialized with input from this run.; \n").addSourceCode("%put NOTE: With Skip-New option, new records will be ignored in subsequent runs.; \n");
                    cgReq.unIndent().addSourceCode("%end;  /* else no rows */ \n\n");
                }
            }
        } else if (this.m_TLM.getLoadStyleValue().equalsIgnoreCase("Replace")) {
            String replaceType = this.m_TLM.getReplaceType();
            if ((replaceType.equalsIgnoreCase("Delete") || replaceType.equalsIgnoreCase("Truncate")) && this.getDeleteAllRowsSupport()) {
                cgReq.addSourceCode("%else \n").addSourceCode("%do;  /* else table exists */ \n").indent();
                this.deleteAllRows(cgReq, replaceType.equals("Truncate"));
                this.genCodeConditionCheck(cgReq, "Condition8");
                cgReq.unIndent().addSourceCode("%end; /* else table exists */ \n\n");
                this.updateCIPreLoad(cgReq, false);
            } else {
                this.replaceTableCIPreLoad(cgReq);
                this.drop(cgReq);
                this.genCodeConditionCheck(cgReq, "Condition6");
                this.create(cgReq, false, createConstraints, createIndexes);
            }
        } else {
            this.updateCIPreLoad(cgReq, true);
        }
        if (this.m_TLM.getNewRowsValue().equals("InsertSQL")) {
            this.loadWithSQLInsert(cgReq);
        } else if (this.m_TLM.getNewRowsValue().equals("AppendProc")) {
            this.loadWithAppend(cgReq);
        }
        this.updateCIPostLoad(cgReq, modifingIndex);
        if (needNewRowsTable) {
            cgReq.genTableDelete("work.etls_newrecords");
        }
        if (this.m_mapFlag) {
            cgReq.genTableDelete("work.mapped");
        }
        cgReq.genJobStatusUpdateAfter(this.m_table);
        cgReq.unIndent().addSourceCode("%mend etls_loader;\n").addSourceCode("%etls_loader;\n\n");
        this.genCodeConditionCheck(cgReq, "Condition1");
        this.genCodeConditionCheck(cgReq, "Condition2");
        this.genCodeConditionCheck(cgReq, "Condition3");
    }

    private void updateCIPreLoad(CodegenRequest cgReq, boolean wrapInElseLogic) throws MdException, RemoteException {
        this.updateCIPreLoad(cgReq, wrapInElseLogic, null);
    }

    public void updateCIPreLoad(CodegenRequest cgReq, boolean wrapInElseLogic, Index indexToKeep) throws MdException, RemoteException {
        if (this.m_TLM.isSyncCIPreLoadNeeded()) {
            boolean conditionalOK;
            boolean bl = conditionalOK = !this.m_TLM.isSyncCIPostLoadNeeded();
            if (conditionalOK) {
                if (wrapInElseLogic) {
                    cgReq.addSourceCode("%else \n");
                } else {
                    cgReq.addSourceCode("%if (&etls_tableExist = 1) %then \n");
                }
                cgReq.addSourceCode("%do;  /* table exists */ \n\n").indent();
            }
            if (this.syncCISetup(cgReq, indexToKeep)) {
                this.syncCIPreLoad(cgReq);
            }
            if (conditionalOK) {
                cgReq.unIndent().addSourceCode("%end;  /* table exists */ \n\n");
            }
        } else if (this.m_TLM.isConstraintEnabled() && this.m_TLM.getConstraintBeforeValue().equals("OFF") || this.m_TLM.isIndexEnabled() && this.m_TLM.getIndexBeforeValue().equals("OFF")) {
            if (wrapInElseLogic) {
                cgReq.addSourceCode("%else \n");
            } else {
                cgReq.addSourceCode("%if (&etls_tableExist = 1) %then \n");
            }
            cgReq.addSourceCode("%do;  /* table exists */ \n\n").indent();
            this.dropCI(cgReq, this.m_TLM.isConstraintEnabled() && this.m_TLM.getConstraintBeforeValue().equals("OFF"), this.m_TLM.isIndexEnabled() && this.m_TLM.getIndexBeforeValue().equals("OFF"), indexToKeep);
            cgReq.unIndent().addSourceCode("%end;  /* table exists */ \n\n");
        }
    }

    public void dropCI(CodegenRequest cgReq, boolean dropC, boolean dropI, Index indexToKeep) throws MdException, RemoteException {
        if (dropC) {
            this.dropConstraints(cgReq);
        }
        if (dropI) {
            this.dropIndexes(cgReq, indexToKeep);
        }
    }

    public void updateCIPostLoad(CodegenRequest cgReq, Index indexToKeep) throws MdException, RemoteException {
        if (!this.m_TLM.isCIPostLoadNeeded()) {
            return;
        }
        if (this.m_TLM.isSyncCIPostLoadNeeded()) {
            boolean macroCreated = true;
            if (!this.m_TLM.isSyncCIPreLoadNeeded()) {
                macroCreated = this.syncCISetup(cgReq, indexToKeep);
            }
            if (macroCreated) {
                this.syncCIPostLoad(cgReq, indexToKeep);
            }
        } else {
            boolean addPctIfLogic;
            String iActionNeeded = this.m_TLM.getPostLoadIActionNeeded();
            String cActionNeeded = this.m_TLM.getPostLoadCActionNeeded();
            if (!iActionNeeded.equals("")) {
                boolean bl = addPctIfLogic = this.m_TLM.isIndexAfterInit() && !this.m_TLM.isReplacingTable();
                if (addPctIfLogic) {
                    cgReq.addSourceCode("%if not &etls_tableExist %then \n").addSourceCode("%do; \n").indent();
                }
                if (iActionNeeded.equals("DROP")) {
                    this.dropIndexes(cgReq, null);
                } else if (iActionNeeded.equals("CREATE")) {
                    List indexList = this.getIndexesToCreate();
                    if (indexToKeep != null && this.m_TLM.getIndexBeforeValue().equals("OFF")) {
                        for (int i = indexList.size() - 1; i >= 0; --i) {
                            Index ind = (Index)indexList.get(i);
                            if (!ind.getFQID().equals(indexToKeep.getFQID())) continue;
                            indexList.remove(i);
                        }
                    }
                    this.createIndexes2(cgReq, indexList);
                }
                if (addPctIfLogic) {
                    cgReq.unIndent().addSourceCode("%end; \n");
                }
            }
            if (!cActionNeeded.equals("")) {
                boolean bl = addPctIfLogic = this.m_TLM.isConstraintAfterInit() && !this.m_TLM.isReplacingTable();
                if (addPctIfLogic) {
                    cgReq.addSourceCode("%if not &etls_tableExist %then \n").addSourceCode("%do; \n").indent();
                }
                if (cActionNeeded.equals("DROP")) {
                    this.dropConstraints(cgReq);
                } else if (cActionNeeded.equals("CREATE")) {
                    this.createConstraints(cgReq);
                }
                if (addPctIfLogic) {
                    cgReq.unIndent().addSourceCode("%end; \n");
                }
            }
        }
    }

    public void deleteAllRows(CodegenRequest cgReq, boolean useTruncate) throws MdException, RemoteException {
        if (!useTruncate || !this.getTruncateSupport()) {
            cgReq.addSectionComment(bundle.getString("DBMSSTORE.DeleteAllRows.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.DeleteAllRows.note.sasmacro.notrans"));
        } else {
            cgReq.addSectionComment(bundle.getString("DBMSSTORE.Truncate.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.Truncate.note.sasmacro.notrans"));
        }
        cgReq.addSourceCode("proc sql;\n").indent();
        this.genConnect(cgReq);
        cgReq.addSourceCode("reset noprint; \n\n");
        this.genExecuteBegin(cgReq, "");
        if (!useTruncate || !this.getTruncateSupport()) {
            this.genDeleteAll2(cgReq);
        } else {
            this.genTruncate(cgReq);
        }
        this.genExecuteEnd(cgReq, "");
        this.genExecuteCommit(cgReq, "");
        this.genDisconnect(cgReq);
        cgReq.unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
    }

    public String getSQLInsertOptions() {
        return "";
    }

    public void genMatchingRowsPrelim(CodegenRequest cgReq) {
    }

    public void loadWithSQLMatching(CodegenRequest cgReq, boolean allowUpdates, boolean needNewRowsTable) throws MdException, RemoteException {
        int i;
        String tableName = this.getDataLocation(cgReq);
        AssociationList columnList = this.m_table.getColumns();
        StringBuffer gen_opts = this.getDSOptions(true);
        String whereMTTab1 = "                    ";
        String whereMTTab2 = whereMTTab1 + "     ";
        StringBuffer whereMT = new StringBuffer(whereMTTab1 + "where");
        StringBuffer whereT = new StringBuffer("where");
        StringBuffer setStatement = new StringBuffer("set");
        List keyModelList = this.m_TLM.getSelectedMatchColumns();
        if (keyModelList.size() <= 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
        }
        ArrayList<String> keyColumnsXList = new ArrayList<String>();
        ArrayList<String> keyColNamesCGList = new ArrayList<String>();
        ArrayList<String> nonKeyColNamesCGList = new ArrayList<String>();
        ArrayList<String> nonKeyColTypesList = new ArrayList<String>();
        for (int j = 0; j < keyModelList.size(); ++j) {
            String colName = ((Column)keyModelList.get(j)).getSASColumnName();
            keyColumnsXList.add(colName);
        }
        for (i = 0; i < columnList.size(); ++i) {
            Column col = (Column)columnList.get(i);
            ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
            String columnNameCG = colCG.getColumnName(cgReq, false);
            int index = keyColumnsXList.indexOf(col.getSASColumnName());
            if (index < 0) {
                nonKeyColNamesCGList.add(columnNameCG);
                nonKeyColTypesList.add(col.getSASColumnType());
                continue;
            }
            keyColNamesCGList.add(columnNameCG);
        }
        if (keyColNamesCGList.size() <= 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
        }
        for (i = 0; i < keyColNamesCGList.size(); ++i) {
            String key = (String)keyColNamesCGList.get(i);
            if (i > 0) {
                whereMT.append(" and \n" + whereMTTab2);
            }
            whereMT.append(" m." + key + "=t." + key);
            if (i > 0) {
                whereT.append(" and \n        ");
            }
            whereT.append(" " + key + " in (select distinct " + key + " from &etls_lastTable)");
        }
        if (allowUpdates) {
            this.genMatchingRowsPrelim(cgReq);
        }
        cgReq.addSourceCode("proc sql ").addSourceCode(this.getSQLInsertOptions()).addSourceCode("; \n").indent();
        if (allowUpdates) {
            List listUnmapped = AutoExtract.getTargetColsNotMapped(false);
            boolean skipUnmapped = !this.m_TLM.getUnmappedEqMissingInUpdate();
            for (int i2 = 0; i2 < nonKeyColNamesCGList.size(); ++i2) {
                String columnName = (String)nonKeyColNamesCGList.get(i2);
                if (skipUnmapped && listUnmapped.indexOf(columnName) >= 0) continue;
                String columnExpression = columnName;
                if (!setStatement.toString().equals("set")) {
                    setStatement.append(",\n      ");
                }
                if (!this.m_TLM.getNoMissingCheck()) {
                    columnExpression = "case when t." + columnName + "=" + (((String)nonKeyColTypesList.get(i2)).equalsIgnoreCase("C") ? "\"\"" : ".") + " then m." + columnName + " else t." + columnName + " end";
                }
                setStatement.append(" " + columnName + " = (select " + columnExpression + " from &etls_lastTable as t \n" + whereMT + ")");
            }
            cgReq.addCommentLine(bundle.getString("DBMSSTORE.UpdateRecords.msg.notrans")).addSourceCode("update ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" as m\n").indent().addSourceCode(setStatement.toString()).addSourceCode("\n").indent().addSourceCode(whereT).addSourceCode("\n").unIndent().unIndent().addSourceCode(";\n\n");
        }
        if (needNewRowsTable) {
            cgReq.addCommentLine(bundle.getString("DBMSSTORE.CreateTempTable.msg.notrans")).addSourceCode("create table etls_newrecords as \n").indent().addSourceCode("select * \n").indent().addSourceCode("from &etls_lastTable as t \n").indent().addSourceCode("where not exists \n").addSourceCode("   (select * from ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" as m \n").addSourceCode(whereMT.toString()).addSourceCode(")\n").unIndent().unIndent().unIndent().addSourceCode("; \n\n").unIndent().addSourceCode("quit;\n\n").addSourceCode("%let etls_lastTable = &SYSLAST;\n\n").addSourceCode("%let SYSOPT = ; \n\n");
        } else {
            cgReq.unIndent().addSourceCode("quit;\n\n");
        }
        cgReq.genRCSetCall("&sqlrc");
    }

    public void loadWithSQLInsert(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq);
        AssociationList columnList = this.m_table.getColumns();
        StringBuffer gen_opts = this.getDSOptions(false);
        String colList = cgReq.makeColumnList((List)columnList, false, "    ", false, ",", "");
        String inputTable = "&etls_lastTable";
        cgReq.addSourceCode("proc sql ").addSourceCode(this.getSQLInsertOptions()).addSourceCode("; \n\n").indent().addCommentLine(bundle.getString("DBMSSTORE.InsertRecords.msg.notrans"));
        cgReq.addSourceCode("insert into ").addSourceCode(tableName).addSourceCode(" \n").indent().addSourceCode("(");
        if (gen_opts.toString().trim().length() > 0) {
            cgReq.addSourceCode(gen_opts.toString() + ", \n  ");
        }
        cgReq.addSourceCode(colList).addSourceCode(")\n").addSourceCode("select \n").addSourceCode(cgReq.getDefaultIndent()).addSourceCode(" ").addSourceCode(colList).addSourceCode("\n").indent().addSourceCode("from " + inputTable + " \n").unIndent().unIndent().addSourceCode("; \n\n");
        cgReq.unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc");
    }

    public void loadWithAppend(CodegenRequest cgReq) throws MdException, RemoteException {
        this.append(cgReq, false);
        this.genCodeConditionCheck(cgReq, "Condition4");
    }

    public void loadWithMod(CodegenRequest cgReq) throws MdException, RemoteException {
        boolean allowNew;
        String tableName = this.getDataLocation(cgReq);
        StringBuffer gen_opts = this.getDSOptions(true);
        AssociationList columnList = this.m_table.getColumns();
        boolean allowUpdates = !this.m_TLM.getMatchingRowsValue().equals("Skip");
        boolean bl = allowNew = !this.m_TLM.getNewRowsValue().equals("Skip");
        if (this.m_TLM.getMatchingRowsValue().equals("ModifyByColumn") || this.m_TLM.getNewRowsValue().equals("ModifyByColumn")) {
            List keyList;
            boolean noMiss = this.m_TLM.getNoMissingCheck();
            String option = "";
            if (noMiss) {
                option = "updatemode = nomissingcheck \n";
            }
            if ((keyList = this.m_TLM.getSelectedMatchColumns()).size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            String byList = cgReq.makeColumnList(keyList, "   ");
            if (allowUpdates) {
                this.genMatchingRowsPrelim(cgReq);
            }
            boolean resetLibname = this.genRereadExposure(cgReq);
            cgReq.addSourceCode("data " + tableName + "; \n\n").indent().addSourceCode("modify " + tableName + gen_opts.toString() + " \n").addSourceCode("       &etls_lastTable");
            if (option.length() > 0) {
                cgReq.addSourceCode("\n       " + option);
            }
            cgReq.addSourceCode("; \n\n").addSourceCode("by " + byList + ";\n\n");
            if (allowNew) {
                cgReq.addCommentLine(bundle.getString("DBMSSTORE.RecordDoesNotExist.msg.notrans")).addSourceCode("if %sysrc(_DSENMR) eq _iorc_ then \n").indent().addSourceCode("output; \n\n").unIndent();
            }
            if (allowUpdates) {
                cgReq.addCommentLine(bundle.getString("DBMSSTORE.RecordExists.msg.notrans"));
                if (allowNew) {
                    cgReq.addSourceCode("else ");
                }
                cgReq.addSourceCode("if %sysrc(_SOK) eq _iorc_ then \n").indent().addSourceCode("replace; \n\n").unIndent();
            }
            cgReq.addSourceCode("_iorc_ = 0; \n").addSourceCode("_error_ = 0; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
            this.genLibname(cgReq, resetLibname);
        } else if (this.m_TLM.getMatchingRowsValue().equals("ModifyUsingIndex") || this.m_TLM.getNewRowsValue().equals("ModifyUsingIndex")) {
            String indexName = "";
            Index modifyIndex = this.m_TLM.getModifyUsingIndex();
            if (modifyIndex != null) {
                indexName = modifyIndex.getName();
            }
            AssociationList indexList = this.m_table.getIndexes();
            if (indexName == null || indexName.length() == 0 || indexList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoIndexSelected.msg.txt"));
            }
            ArrayList<String> ixColumns = new ArrayList<String>();
            AssociationList columnsList = modifyIndex.getColumns(false);
            int size = columnsList.size();
            for (int j = 0; j < size; ++j) {
                String colName = ((Column)columnsList.get(j)).getSASColumnName();
                ixColumns.add(colName);
            }
            StringBuffer rename = new StringBuffer("(rename=(");
            StringBuffer assign = new StringBuffer("");
            StringBuffer unAssign = new StringBuffer("");
            int counter = 0;
            List listUnmapped = AutoExtract.getTargetColsNotMapped(false);
            for (int i = 0; i < columnList.size(); ++i) {
                Column col = (Column)columnList.get(i);
                String sasColumnName = col.getSASColumnName();
                if (ixColumns.indexOf(sasColumnName) >= 0) continue;
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                String columnName = colCG.getColumnName(cgReq, false);
                if (this.m_TLM.getMatchingRowsValue().indexOf(MODIFY) >= 0 && !this.m_TLM.getUnmappedEqMissingInUpdate() && listUnmapped.indexOf(columnName) >= 0) continue;
                String tempColumnName = "etls_temp" + String.valueOf(counter);
                if (counter > 0) {
                    rename.append("\n          ");
                }
                rename.append(columnName + " = " + tempColumnName);
                if (!this.m_TLM.getNoMissingCheck() && allowUpdates) {
                    assign.append("if " + tempColumnName + " ne " + (col.getSASColumnType().equalsIgnoreCase("C") ? "\"\"" : ".") + " then ");
                }
                assign.append(columnName + " = " + tempColumnName + ";\n");
                if (!this.m_TLM.getNoMissingCheck()) {
                    unAssign.append(columnName + " = " + (col.getSASColumnType().equalsIgnoreCase("C") ? "\"\"" : ".") + ";\n");
                }
                ++counter;
            }
            rename.append("))");
            boolean resetLibname = this.genRereadExposure(cgReq);
            cgReq.addSourceCode("data " + tableName + "; \n\n").indent().addSourceCode("set &etls_lastTable \n").indent().indent().addSourceCode(" " + rename.toString() + "\n").unIndent().unIndent().addSourceCode("; \n\n");
            this.genModIndexStatement(cgReq, tableName, modifyIndex, this.m_TLM.getIndexUniqueValue());
            cgReq.addSourceCode("if ").addSourceCode(allowNew ? MODIFY_NEW_CONDITION : MODIFY_UPDATE_CONDITION).addSourceCode(allowNew && allowUpdates ? " or \n   %sysrc(_SOK) eq _iorc_" : "").addSourceCode(" then  \n").addSourceCode("do; \n").indent().addSourceCode(assign);
            if (allowNew && allowUpdates) {
                cgReq.addSourceCode("\n").addCommentLine(bundle.getString("DBMSSTORE.RecordExists.msg.notrans")).addSourceCode("if %sysrc(_SOK) eq _iorc_ then \n").indent();
            }
            if (allowUpdates) {
                cgReq.addSourceCode("replace; \n");
                if (allowNew) {
                    cgReq.unIndent().addSourceCode("\n").addCommentLine(bundle.getString("DBMSSTORE.RecordDoesNotExist.msg.notrans")).addSourceCode("else \n").indent();
                }
            }
            if (allowNew) {
                cgReq.addSourceCode("output; \n\n");
                if (allowUpdates) {
                    cgReq.unIndent();
                }
            }
            if (unAssign.length() != 0) {
                cgReq.addSourceCode(unAssign);
            }
            cgReq.unIndent().addSourceCode("end; \n\n").addSourceCode("_iorc_ = 0; \n").addSourceCode("_error_ = 0; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
            this.genLibname(cgReq, resetLibname);
        }
        this.genCodeConditionCheck(cgReq, "Condition4");
    }

    public void loadWithUpsert(CodegenRequest cgReq) throws MdException, RemoteException {
    }

    public void genModIndexStatement(CodegenRequest cgReq, String tableName, Index modifyIndex, boolean unique) throws MdException, RemoteException {
        AssociationList indexColumns = modifyIndex.getColumns();
        cgReq.addSourceCode("modify ").addSourceCode(tableName).addSourceCode("\n").addSourceCode("(").addSourceCode(this.getDSOptions(false)).addSourceCode("\n").indent().addSourceCode("cntllev = rec \n").addSourceCode("dbkey = ");
        if (indexColumns.size() > 1) {
            cgReq.addSourceCode("(");
        }
        cgReq.addSourceCode(cgReq.makeColumnList((List)indexColumns, "   "));
        if (indexColumns.size() > 1) {
            cgReq.addSourceCode(")");
        }
        cgReq.addSourceCode("\n").unIndent().addSourceCode(") key = dbkey");
        if (unique) {
            cgReq.addSourceCode(" / unique");
        }
        cgReq.addSourceCode(";\n\n");
    }

    public void append(CodegenRequest cgReq) throws MdException, RemoteException {
        this.append(cgReq, true);
    }

    public void append(CodegenRequest cgReq, boolean genJobStatus) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.Append.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.Append.note.sasmacro.notrans")).addSourceCode("\n");
        String tableName = this.getDataLocation(cgReq);
        StringBuffer gen_opts = this.getDSOptions();
        if (gen_opts.length() > 0) {
            gen_opts.insert(0, " (").append(")");
        }
        if (genJobStatus) {
            cgReq.genJobStatusUpdateBefore(this.m_table);
        }
        cgReq.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" \n").addSourceCode("            data = &etls_lastTable (&SYSOPT) force; \n").addSourceCode("run; \n\n").genRCSetCall("&syserr");
        if (genJobStatus) {
            cgReq.genJobStatusUpdateAfter(this.m_table);
        }
    }

    public void create(CodegenRequest cgReq) throws MdException, RemoteException {
        this.create(cgReq, true, false, false);
    }

    public void create(CodegenRequest cgReq, boolean useMacroLogic, boolean createColumnConstraints, boolean createIndexes) throws MdException, RemoteException {
        this.create(cgReq, useMacroLogic, createColumnConstraints, createIndexes, true);
    }

    public void create(CodegenRequest cgReq, boolean useMacroLogic, boolean createColumnConstraints, boolean createIndexes, boolean doTableCreateCodeCondition) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.Create.msg.notrans"));
        if (useMacroLogic) {
            cgReq.addSourceCode("%if (&etls_tableExist eq 0) %then \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.TableDoesNotExist.msg.notrans")).addSourceCode("\n").indent().genPercentPutStatement(bundle.getString("DBMSSTORE.Create.note.sasmacro.notrans")).addSourceCode("\n");
        }
        StringBuffer gen_opts = new StringBuffer();
        String label = this.getDataTableLabel();
        if (label.length() > 0) {
            gen_opts.append(cgReq.getLabelStatement(label)).append("\n         ");
        }
        gen_opts.append(this.getDSOptions());
        String dbnullOptions = this.getDBNULL(cgReq);
        if (dbnullOptions.length() > 1) {
            if (gen_opts.length() > 0) {
                gen_opts.append("\n         ");
            }
            gen_opts.append(dbnullOptions);
        }
        String optString = "";
        if (gen_opts.length() > 0) {
            optString = "\n        (" + gen_opts.toString().trim() + ")";
        }
        cgReq.addSourceCode("data ").addSourceCode(this.getDataLocation(cgReq)).addSourceCode(optString).addSourceCode(";\n").indent();
        this.genscols(cgReq);
        cgReq.addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        if (createIndexes) {
            this.createIndexes2(cgReq);
        }
        if (createColumnConstraints) {
            this.createConstraints(cgReq);
        }
        if (doTableCreateCodeCondition) {
            this.genCodeConditionCheck(cgReq, "Condition5");
        }
        if (useMacroLogic) {
            cgReq.unIndent().addSourceCode("%end;  ").addCommentLine(bundle.getString("DBMSSTORE.TableDoesNotExist.msg.notrans")).addSourceCode("\n");
        }
    }

    public String getDBNULL(CodegenRequest cgReq) throws MdException, RemoteException {
        StringBuffer sOpts = new StringBuffer();
        AssociationList cols = this.m_table.getColumns();
        if (cols.size() > 0) {
            sOpts.append("dbnull = (");
        }
        for (int i = 0; i < cols.size(); ++i) {
            Column col = (Column)cols.get(i);
            ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
            sOpts.append("\n                   ");
            if (col.getIsNullable() > 0) {
                sOpts.append(colCG.getColumnName(cgReq) + " = YES");
                continue;
            }
            sOpts.append(colCG.getColumnName(cgReq) + " = NO");
        }
        if (sOpts.length() > 0) {
            sOpts.append(")");
        }
        return sOpts.toString();
    }

    public void update(CodegenRequest cgReq) throws MdException, RemoteException {
        AssociationList columnList;
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.Update.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.Update.note.sasmacro.notrans")).addSourceCode("\n");
        String tableName = this.getDataLocation(cgReq);
        StringBuffer gen_opts = this.getDSOptions();
        if (gen_opts.length() > 0) {
            gen_opts.insert(0, " (").append(")");
        }
        if ((columnList = this.m_table.getColumns()).size() <= 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnsDefined.msg.txt"));
        }
        String updateType = this.m_TLO.getUpdateType();
        if (updateType.equalsIgnoreCase(IMPLICIT_UPDATE)) {
            int i;
            String whereMTTab1 = "                    ";
            String whereMTTab2 = whereMTTab1 + "     ";
            StringBuffer whereMT = new StringBuffer(whereMTTab1 + "where");
            StringBuffer whereT = new StringBuffer("where");
            StringBuffer setStatement = new StringBuffer("set");
            Vector keyList = this.m_TLO.getKeyList();
            if (keyList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            ArrayList<String> keyColumnsList = new ArrayList<String>();
            ArrayList<String> columnNamesList = new ArrayList<String>();
            String colList = cgReq.makeColumnList((List)columnList, false, "    ", false, ",", "");
            for (i = 0; i < columnList.size(); ++i) {
                Column col = (Column)columnList.get(i);
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                String columnName = colCG.getColumnName(cgReq, false);
                int index = keyList.indexOf(col.getSASColumnName());
                if (index < 0) {
                    columnNamesList.add(columnName);
                    continue;
                }
                keyColumnsList.add(columnName);
            }
            if (keyColumnsList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            for (i = 0; i < keyColumnsList.size(); ++i) {
                String key = (String)keyColumnsList.get(i);
                if (i > 0) {
                    whereMT.append(" and \n" + whereMTTab2);
                }
                whereMT.append(" m." + key + "=t." + key);
                if (i > 0) {
                    whereT.append(" and \n        ");
                }
                whereT.append(" " + key + " in (select distinct " + key + " from &etls_lastTable)");
            }
            for (i = 0; i < columnNamesList.size(); ++i) {
                String columnName = (String)columnNamesList.get(i);
                if (i > 0) {
                    setStatement.append(",\n      ");
                }
                setStatement.append(" " + columnName + " = (select " + columnName + " from &etls_lastTable as t \n" + whereMT + ")");
            }
            cgReq.genJobStatusUpdateBefore(this.m_table).addSourceCode("proc sql; \n\n").indent().addCommentLine(bundle.getString("DBMSSTORE.UpdateRecords.msg.notrans")).addSourceCode("update ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" as m\n").indent().addSourceCode(setStatement.toString()).addSourceCode("\n").indent().addSourceCode(whereT).addSourceCode("\n").unIndent().unIndent().addSourceCode(";\n\n").addCommentLine(bundle.getString("DBMSSTORE.CreateTempTable.msg.notrans")).addSourceCode("create table newRecords as \n").indent().addSourceCode("select * \n").indent().addSourceCode("from &etls_lastTable as t \n").indent().addSourceCode("where not exists \n").addSourceCode("   (select * from ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" as m \n").addSourceCode(whereMT.toString()).addSourceCode(")\n").unIndent().unIndent().unIndent().addSourceCode("; \n\n").addCommentLine(bundle.getString("DBMSSTORE.InsertRecords.msg.notrans")).addSourceCode("insert into ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" \n").addSourceCode("   (").addSourceCode(colList).addSourceCode(")\n").indent().addSourceCode("select \n").addSourceCode(cgReq.getDefaultIndent()).addSourceCode(" ").addSourceCode(colList).addSourceCode("\n").indent().addSourceCode("from newRecords \n").unIndent().unIndent().addSourceCode("; \n\n").addCommentLine(bundle.getString("DBMSSTORE.DeleteTempTable.msg.notrans")).addSourceCode("drop table newRecords; \n\n").unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc").genJobStatusUpdateAfter(this.m_table);
        } else if (updateType.equalsIgnoreCase(PASSTHRU_UPDATE)) {
            int i;
            String intTable;
            String tableNamePT = this.getDataLocation(cgReq, true, true);
            String libref = DBMSSTORE.getLibref(tableName);
            String librefPT = DBMSSTORE.getLibref(tableNamePT);
            String fullIntTable = intTable = cgReq.getUniqueWorkTableName();
            if (!librefPT.equals("")) {
                fullIntTable = librefPT + "." + fullIntTable;
            }
            StringBuffer whereMT = new StringBuffer("      where");
            StringBuffer setStatement = new StringBuffer("");
            Vector keyList = this.m_TLO.getKeyList();
            if (keyList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            ArrayList<String> keyColumnsList = new ArrayList<String>();
            ArrayList<String> columnNamesList = new ArrayList<String>();
            String colList = cgReq.makeColumnList((List)columnList, false, "      ", this.m_passthru, ",", "");
            for (i = 0; i < columnList.size(); ++i) {
                Column col = (Column)columnList.get(i);
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                String columnName = colCG.getColumnName(cgReq, false);
                int index = keyList.indexOf(col.getSASColumnName());
                if (index < 0) {
                    columnNamesList.add(columnName);
                    continue;
                }
                keyColumnsList.add(columnName);
            }
            if (keyColumnsList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            for (i = 0; i < keyColumnsList.size(); ++i) {
                String key = (String)keyColumnsList.get(i);
                if (i > 0) {
                    whereMT.append(" and \n           ");
                }
                whereMT.append(" " + tableName + "." + key + " = " + intTable + "." + key);
            }
            for (i = 0; i < columnNamesList.size(); ++i) {
                String columnName = (String)columnNamesList.get(i);
                if (i > 0) {
                    setStatement.append(",\n          ");
                }
                setStatement.append(" " + columnName + " = " + intTable + "." + columnName);
            }
            cgReq.genJobStatusUpdateBefore(this.m_table).addSourceCode("proc sql; \n\n").indent();
            this.genConnect(cgReq);
            cgReq.addSourceCode("\n").addCommentLine(bundle.getString("DBMSSTORE.CreateTempTable2.msg.notrans")).addSourceCode("create table ").addSourceCode(libref).addSourceCode(".").addSourceCode(intTable).addSourceCode(" (bulkload=YES) as \n").indent().addSourceCode("select * from &etls_lastTable \n").unIndent().addSourceCode("  ; \n\n").addCommentLine(bundle.getString("DBMSSTORE.UpdateRecords.msg.notrans"));
            this.genExecuteBegin(cgReq, "");
            cgReq.addSourceCode("update ").addSourceCode(tableNamePT).addSourceCode(gen_opts.toString()).addSourceCode(" as m \n").indent().addSourceCode("set").addSourceCode(setStatement.toString()).addSourceCode("\n").addSourceCode(whereMT.toString()).addSourceCode("\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.DeleteRows.msg.notrans")).addSourceCode("delete from ").addSourceCode(fullIntTable).addSourceCode("\n").addSourceCode(whereMT.toString()).addSourceCode("\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.InsertRecords.msg.notrans")).addSourceCode("insert into ").addSourceCode(tableNamePT).addSourceCode(gen_opts.toString()).addSourceCode(" \n").addSourceCode("   (").addSourceCode(colList).addSourceCode(")\n").indent().addSourceCode("select \n").indent().addSourceCode(colList).addSourceCode(" \n").unIndent().addSourceCode("from ").addSourceCode(fullIntTable).addSourceCode(" \n\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.DeleteTempTable.msg.notrans")).addSourceCode("drop table ").addSourceCode(fullIntTable).addSourceCode(" \n");
            this.genExecuteEnd(cgReq, "  ");
            this.genExecuteCommit(cgReq, "  ");
            this.genDisconnect(cgReq);
            cgReq.addSourceCode("\n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc").genJobStatusUpdateAfter(this.m_table);
        } else if (updateType.equalsIgnoreCase(BY_UPDATE)) {
            Vector keyList;
            boolean noMiss = this.m_TLO.getNoMissingCheck();
            String option = "";
            if (noMiss) {
                option = "updatemode = nomissingcheck \n";
            }
            if ((keyList = this.m_TLO.getKeyList()).size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoKeysSelected.msg.txt"));
            }
            String byList = cgReq.makeColumnList(keyList, "   ");
            boolean resetLibname = this.genRereadExposure(cgReq);
            cgReq.genJobStatusUpdateBefore(this.m_table).addSourceCode("data " + tableName + gen_opts.toString() + "; \n\n").indent().addSourceCode("modify " + tableName + gen_opts.toString() + " \n").addSourceCode("       &etls_lastTable");
            if (option.length() > 0) {
                cgReq.addSourceCode("\n       " + option);
            }
            cgReq.addSourceCode("; \n\n").addSourceCode("by " + byList + ";\n\n").addCommentLine(bundle.getString("DBMSSTORE.RecordDoesNotExist.msg.notrans")).addSourceCode("if %sysrc(_DSENMR) eq _iorc_ then \n").indent().addSourceCode("output; \n\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.RecordExists.msg.notrans")).addSourceCode("else if %sysrc(_SOK) eq _iorc_ then \n").indent().addSourceCode("replace; \n\n").unIndent().addSourceCode("_iorc_ = 0; \n").addSourceCode("_error_ = 0; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr").genJobStatusUpdateAfter(this.m_table);
            this.genLibname(cgReq, resetLibname);
        } else if (updateType.equalsIgnoreCase(KEY_UPDATE)) {
            String index = DBMSNamesUtil.getQuotedString((String)this.m_TLO.getIndex(), (DataTable)this.m_table);
            AssociationList indexList = this.m_table.getIndexes();
            if (index == null || index.length() == 0 || indexList.size() <= 0) {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoIndexSelected.msg.txt"));
            }
            ArrayList<String> ixColumns = new ArrayList<String>();
            for (int i = 0; i < indexList.size(); ++i) {
                Index ix = (Index)indexList.get(i);
                String ixName = ix.getName();
                if (!ixName.equalsIgnoreCase(index)) continue;
                AssociationList columnsList = ix.getColumns();
                for (int j = 0; j < columnsList.size(); ++j) {
                    String colName = ((Column)columnsList.get(j)).getSASColumnName();
                    ixColumns.add(colName);
                }
                break;
            }
            String unique = "";
            if (this.m_TLO.getUnique()) {
                unique = " / unique";
            }
            StringBuffer rename = new StringBuffer("(rename=(");
            StringBuffer assign = new StringBuffer("");
            int counter = 0;
            for (int i = 0; i < columnList.size(); ++i) {
                Column col = (Column)columnList.get(i);
                String sasColumnName = col.getSASColumnName();
                if (ixColumns.indexOf(sasColumnName) >= 0) continue;
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                String columnName = colCG.getColumnName(cgReq, false);
                String tempColumnName = "etls_temp" + String.valueOf(counter);
                if (counter > 0) {
                    rename.append("\n          ");
                }
                rename.append(columnName + " = " + tempColumnName);
                assign.append(columnName + " = " + tempColumnName + ";\n");
                ++counter;
            }
            rename.append("))");
            boolean resetLibname = this.genRereadExposure(cgReq);
            cgReq.genJobStatusUpdateBefore(this.m_table).addSourceCode("data " + tableName + gen_opts.toString() + "; \n\n").indent().addSourceCode("set &etls_lastTable \n").indent().indent().addSourceCode(" " + rename.toString() + "\n").unIndent().unIndent().addSourceCode("; \n\n").addSourceCode("modify " + tableName + gen_opts.toString() + "\n").addSourceCode("       key = " + index + unique + ";\n\n").addSourceCode("if %sysrc(_DSENMR) eq _iorc_ or \n").addSourceCode("   %sysrc(_DSENOM) eq _iorc_ or \n").addSourceCode("   %sysrc(_DSEMTR) eq _iorc_ or \n").addSourceCode("   %sysrc(_SOK) eq _iorc_ then \n").addSourceCode("do; \n").indent().addSourceCode(assign + "\n").addCommentLine(bundle.getString("DBMSSTORE.RecordExists.msg.notrans")).addSourceCode("if %sysrc(_SOK) eq _iorc_ then \n").indent().addSourceCode("replace; \n\n").unIndent().addCommentLine(bundle.getString("DBMSSTORE.RecordDoesNotExist.msg.notrans")).addSourceCode("else \n").indent().addSourceCode("output; \n").unIndent().unIndent().addSourceCode("end; \n\n").addSourceCode("_iorc_ = 0; \n").addSourceCode("_error_ = 0; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr").genJobStatusUpdateAfter(this.m_table);
            this.genLibname(cgReq, resetLibname);
        }
    }

    public boolean genRereadExposure(CodegenRequest cgReq) throws MdException, RemoteException {
        SASLibrary iLib = this.getBestDeployment(cgReq).getLibrary();
        String code = LibraryUtil.getAccessPath((SASLibrary)iLib);
        if (iLib.getIsPreassigned() == 0 && code.toUpperCase().replaceAll(" ", "").indexOf("REREAD_EXPOSURE=YES") < 0) {
            cgReq.addSourceCode("\n").addCommentLine(bundle.getString("DBMSSTORE.UpdateModifyWarning.msg.notrans"));
            StringBuffer codeBuffer = new StringBuffer();
            codeBuffer.append(code);
            int val = codeBuffer.lastIndexOf(";");
            codeBuffer.insert(val, " REREAD_EXPOSURE=YES");
            cgReq.addSourceCode(codeBuffer.toString()).addSourceCode("\n\n");
            return true;
        }
        if (iLib.getIsPreassigned() == 1) {
            return false;
        }
        return false;
    }

    public void genLibname(CodegenRequest cgReq, boolean resetLibname) throws MdException, RemoteException {
        if (resetLibname) {
            SASLibrary iLib = this.getBestDeployment(cgReq).getLibrary();
            String code = LibraryUtil.getAccessPath((SASLibrary)iLib);
            cgReq.addSourceCode(code + "\n");
        }
    }

    public void genGetNumRows(CodegenRequest cgReq, String tableName, String macroVariable) {
        cgReq.addSourceCode("%let ").addSourceCode(macroVariable).addSourceCode(" = 0;\n");
        cgReq.addSourceCode("%macro etls_recordCheck; \n").indent();
        cgReq.genTableExist(tableName, "BOTH", "etls_recCheckExist");
        cgReq.addSourceCode("%if (&etls_recCheckExist) %then\n").addSourceCode("%do;\n").indent();
        cgReq.addSourceCode("proc sql noprint;\n");
        cgReq.indent();
        cgReq.addSourceCode("select count(*) into :").addSourceCode(macroVariable).addSourceCode(" from ").addSourceCode(tableName).addSourceCode(";\n");
        cgReq.unIndent();
        cgReq.addSourceCode("quit;\n");
        cgReq.unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%mend etls_recordCheck;\n").addSourceCode("%etls_recordCheck;\n\n");
    }

    public void truncate(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.Truncate.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.Truncate.note.sasmacro.notrans")).addSourceCode("\n");
        cgReq.addSourceCode("proc sql;\n").indent();
        this.genConnect(cgReq);
        cgReq.addSourceCode("reset noprint; \n\n");
        this.genExecuteBegin(cgReq, "");
        this.genDeleteAll(cgReq);
        this.genExecuteEnd(cgReq, "");
        this.genExecuteCommit(cgReq, "");
        this.genDisconnect(cgReq);
        cgReq.addSourceCode("\n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
    }

    public void columnMapping(CodegenRequest cgReq) throws MdException, RemoteException {
        this.columnMapping(cgReq, true);
    }

    public void columnMapping(CodegenRequest cgReq, boolean assignUnmappedEqMissing) throws MdException, RemoteException {
        this.m_mapFlag = AutoExtract.columnMapping(this.m_classifierMap, cgReq, "&etls_lastTable", "&SYSOPT", true, assignUnmappedEqMissing);
        if (this.m_mapFlag) {
            cgReq.addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            cgReq.addSourceCode("%let SYSOPT = ; \n\n");
        }
    }

    public boolean hasConstraints() throws MdException, RemoteException {
        this.setMetadata();
        boolean hasConstraints = false;
        if (this.m_table != null) {
            List notNullColumns = this.getNotNullCols();
            hasConstraints = this.getNotNullIsConstraint() && !notNullColumns.isEmpty() || !this.m_table.getForeignKeys().isEmpty() || !this.m_table.getUniqueKeys().isEmpty();
        }
        return hasConstraints;
    }

    public List getNotNullCols() throws MdException, RemoteException {
        ArrayList<Column> notNullColumns = new ArrayList<Column>();
        AssociationList cols = this.m_table.getColumns();
        for (int i = 0; i < cols.size(); ++i) {
            Column col = (Column)cols.get(i);
            if (col.getIsNullable() != 0) continue;
            notNullColumns.add(col);
        }
        return notNullColumns;
    }

    public void createConstraints(CodegenRequest cgReq) throws MdException, RemoteException {
        AssociationList foreignKeys = this.m_table.getForeignKeys();
        List uniqueKeys = this.getUniqueKeysToCreate();
        if (!foreignKeys.isEmpty() || !uniqueKeys.isEmpty()) {
            String tabname = this.getDataLocation(cgReq, true, true);
            cgReq.addSectionComment(bundle.getString("DBMSSTORE.CreateConstraint.msg.notrans"));
            cgReq.genPercentPutStatement(bundle.getString("DBMSSTORE.CreateConstraint.note.sasmacro.notrans"));
            cgReq.addSourceCode("proc sql;\n");
            cgReq.indent();
            this.genConnect(cgReq);
            cgReq.addSourceCode("reset noprint; \n\n");
            String delimiter = "";
            String addCommand = IC_CREATE_COMMAND;
            int foreignKeysSize = foreignKeys.size();
            for (int i = 0; i < foreignKeysSize; ++i) {
                ForeignKey key = (ForeignKey)foreignKeys.get(i);
                PhysicalTableCG primKeyTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)key.getPartnerUniqueKey().getTable());
                primKeyTableCG.accessPath(cgReq);
            }
            boolean firstKey = true;
            StringBuffer executeAlterCode = new StringBuffer();
            executeAlterCode.append(this.getExecuteBegin("").toString()).append("   ").append("alter table " + tabname);
            for (int i = 0; i < foreignKeysSize; ++i) {
                if (this.m_addOneKeyPerExecute || firstKey) {
                    cgReq.addSourceCode(executeAlterCode).indent(2);
                }
                ForeignKey key = (ForeignKey)foreignKeys.get(i);
                cgReq.addSourceCode(delimiter + "\n").addSourceCode(this.createSingleFKey(cgReq, key, addCommand));
                if (this.m_addOneKeyPerExecute) {
                    cgReq.addSourceCode("\n").unIndent();
                    this.genExecuteEnd(cgReq, "");
                    this.genExecuteCommit(cgReq, "");
                }
                delimiter = this.m_addKeyDelimiter;
                addCommand = this.m_repeatAddKeyCommand ? IC_CREATE_COMMAND : "   ";
                firstKey = false;
            }
            int uniqueSize = uniqueKeys.size();
            for (int i = 0; i < uniqueSize; ++i) {
                if (this.m_addOneKeyPerExecute || firstKey) {
                    cgReq.addSourceCode(executeAlterCode);
                    cgReq.indent(2);
                }
                UniqueKey key = (UniqueKey)uniqueKeys.get(i);
                String colList = cgReq.makeColumnList((List)key.getKeyedColumns(), true, cgReq.getCurrentIndent() + " ", this.m_passthru, ",", "");
                cgReq.addSourceCode(delimiter + "\n").addSourceCode(addCommand + " ");
                if (key.getIsPrimary() == 0) {
                    cgReq.addSourceCode("unique ");
                } else {
                    cgReq.addSourceCode("primary key ");
                }
                cgReq.addSourceCode("(").addSourceCode(colList).addSourceCode(")");
                if (this.m_addOneKeyPerExecute) {
                    cgReq.addSourceCode("\n").unIndent();
                    this.genExecuteEnd(cgReq, "");
                    this.genExecuteCommit(cgReq, "");
                }
                delimiter = this.m_addKeyDelimiter;
                addCommand = this.m_repeatAddKeyCommand ? IC_CREATE_COMMAND : "   ";
                firstKey = false;
            }
            if (!this.m_addOneKeyPerExecute) {
                cgReq.addSourceCode("\n").unIndent();
                this.genExecuteEnd(cgReq, "");
                this.genExecuteCommit(cgReq, "");
            }
            this.genDisconnect(cgReq);
            cgReq.unIndent();
            cgReq.addSourceCode("quit;\n\n");
            cgReq.genRCSetCall("&sqlrc");
        }
    }

    public String createSingleFKey(CodegenRequest cgReq, ForeignKey key, String addCommand) throws MdException, RemoteException {
        StringBuffer code = new StringBuffer("");
        PhysicalTableCG primKeyTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)key.getPartnerUniqueKey().getTable());
        String primKeyTableName = primKeyTableCG.getDataLocation(cgReq, true, true);
        String colList = cgReq.makeColumnList((List)key.getKeyedColumns(), true, cgReq.getCurrentIndent() + "   ", this.m_passthru, ",", "");
        code.append(addCommand + " ").append("foreign key (").append(colList).append(") references ").append(primKeyTableName);
        return code.toString();
    }

    public void dropConstraints(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.DropConstraint.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.DropConstraint.note.sasmacro.notrans"));
        String tableName = TEMP_INDEX_TABLE_NAME;
        cgReq.genTableDelete(tableName);
        cgReq.addSourceCode("proc sql; \n\n").indent();
        this.genConnect(cgReq);
        cgReq.addSourceCode("reset noprint; \n\n");
        cgReq.addSourceCode("create table etls_CIList as \n").indent().addSourceCode("select consttype length=20, \n").addSourceCode("       constname length=" + this.m_idxNameLength + " \n").unIndent();
        this.queryConstraints(cgReq);
        cgReq.addSourceCode("%let etls_numConst = &sqlObs; \n");
        cgReq.addSourceCode("\n%let etls_deleteList= etls_CIList; \n");
        cgReq.addSourceCode("\n").genPercentPutStatement(bundle.getString("DBMSSTORE.NumberConstraints.msg.sasmacro.notrans")).addSourceCode("\n").addSourceCode("%do etls_ConstCount = 1 %to &etls_numConst; \n\n").indent().addSourceCode("select constname, consttype into :etls_constName , :etls_constType \n").indent().addSourceCode("from &etls_deleteList \n").addSourceCode("        (firstobs = &etls_ConstCount \n").addSourceCode("         obs = &etls_ConstCount); \n\n").unIndent().genPercentPutStatement(bundle.getString("DBMSSTORE.DropSingleConstraint.msg.sasmacro.notrans"), "NOTE:", false).addSourceCode("\n");
        this.dropSingleConstraint(cgReq);
        this.genExecuteCommit(cgReq, "");
        cgReq.addSourceCode("\n").unIndent().addSourceCode("%end;  ").addCommentLine(bundle.getString("DBMSSTORE.ConstraintDoLoop.msg.notrans"));
        this.genDisconnect(cgReq);
        cgReq.addSourceCode("\n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
        cgReq.genTableDelete("etls_CIList etls_CIList2");
    }

    public void createIndexes(CodegenRequest cgReq) throws MdException, RemoteException {
        AssociationList index = this.m_table.getIndexes();
        if (index.size() > 0) {
            cgReq.addSourceCode("\n");
            cgReq.addSectionComment(bundle.getString("DBMSSTORE.CreateIndex.msg.notrans"));
            cgReq.addSourceCode("%if ((&etls_tableExist eq 0) or \n").addSourceCode("     (&etls_numIndex ne -1)) %then \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.NewIndex.msg.notrans")).addSourceCode("\n").indent();
            this.createIndexes2(cgReq, (List)index);
            cgReq.unIndent().addSourceCode("%end;  ").addCommentLine(bundle.getString("DBMSSTORE.NewIndex.msg.notrans")).addSourceCode("\n");
        }
    }

    public void createIndexAndConstraintsConditionally(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSourceCode("%if (&etls_tableExist eq 0) %then\n").addSourceCode("%do;\n").indent();
        this.createIndexes2(cgReq);
        this.createConstraints(cgReq);
        cgReq.unIndent().addSourceCode("%end;\n");
    }

    public void createIndexes2(CodegenRequest cgReq) throws MdException, RemoteException {
        this.createIndexes2(cgReq, this.getIndexesToCreate());
    }

    public void createIndexes2(CodegenRequest cgReq, List indexList) throws MdException, RemoteException {
        if (indexList.size() > 0) {
            cgReq.addSectionComment(bundle.getString("DBMSSTORE.CreateIndex.msg.notrans"));
            cgReq.genPercentPutStatement(bundle.getString("DBMSSTORE.CreateIndex.note.sasmacro.notrans")).addSourceCode("proc sql; \n").indent();
            this.genConnect(cgReq);
            cgReq.addSourceCode("reset noprint; \n");
            for (int i = 0; i < indexList.size(); ++i) {
                this.genExecuteBegin(cgReq, "");
                Index i_index = (Index)indexList.get(i);
                this.genSingleIndex(cgReq, i_index);
                String opts = this.getPostIndexOptions(i_index);
                if (opts.length() > 0) {
                    cgReq.indent().addSourceCode(opts + "\n").unIndent();
                }
                this.genExecuteEnd(cgReq, "");
                this.genExecuteCommit(cgReq, "");
            }
            this.genDisconnect(cgReq);
            cgReq.unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
        }
    }

    public void drop(CodegenRequest cgReq) throws MdException, RemoteException {
        this.drop(cgReq, true);
    }

    public void drop(CodegenRequest cgReq, boolean setExistMacro) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.DropTable.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.DropTable.note.sasmacro.notrans"));
        String tableName = this.getDataLocation(cgReq);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        String libname = DBMSSTORE.getLibref(tableName);
        String dsname = DBMSSTORE.getTableName(tableName);
        cgReq.addSourceCode("proc datasets lib = " + libname + " nolist nodetails;\n").indent().addSourceCode("  delete " + dsname + ";\n").unIndent().addSourceCode("quit;\n\n").genRCSetCall("&syserr");
        if (setExistMacro) {
            cgReq.addSourceCode("%let etls_tableExist = 0;\n\n");
        }
    }

    public void dropIndexes(CodegenRequest cgReq) throws MdException, RemoteException {
        this.dropIndexes(cgReq, null);
    }

    public void dropIndexes(CodegenRequest cgReq, Index keepIndex) throws MdException, RemoteException {
        String keepIndexName = "";
        if (keepIndex != null) {
            keepIndexName = keepIndex.getName();
        }
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.DropIndex.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.DropIndex.note.sasmacro.notrans"));
        String tableName = TEMP_INDEX_TABLE_NAME;
        cgReq.genTableDelete(tableName);
        cgReq.addSourceCode("proc sql; \n\n").indent();
        this.genConnect(cgReq);
        cgReq.addSourceCode("reset noprint; \n\n");
        cgReq.addSourceCode("create table etls_CIList as \n").indent().addSourceCode("select tabname length=100, \n").addSourceCode("       idxname length=" + this.m_idxNameLength + " \n").unIndent();
        this.queryIndexes(cgReq);
        cgReq.addSourceCode("%let etls_numIndex = &sqlObs; \n");
        cgReq.addSourceCode("\n%let etls_deleteList= etls_CIList; \n");
        if (keepIndexName != "") {
            cgReq.addSourceCode("select '1' into: etls_hasUpdateIndex \n").indent().addSourceCode("from &etls_deleteList \n").indent().addSourceCode("where upcase(idxname) = \"" + keepIndexName.toUpperCase() + "\"; \n\n").unIndent().unIndent();
            cgReq.addSourceCode("/* Exclude from delete list the index needed in upcoming step */ \n").addSourceCode("%if &etls_hasUpdateIndex %then \n").addSourceCode("%do; \n").indent().addSourceCode("create table &etls_deleteList.2 as \n").indent().addSourceCode("select * \n").indent().addSourceCode("from &etls_deleteList \n").addSourceCode("where upcase(idxname) ne \"" + keepIndexName.toUpperCase() + "\"; \n").unIndent().unIndent().addSourceCode("%let etls_numIndex = &sqlObs; \n").addSourceCode("%let etls_deleteList= &etls_deleteList.2; \n");
            cgReq.unIndent().addSourceCode("%end; \n");
        }
        cgReq.addSourceCode("\n").genPercentPutStatement(bundle.getString("DBMSSTORE.NumberIndexes.msg.sasmacro.notrans")).addSourceCode("\n").addSourceCode("%do etls_indexCount = 1 %to &etls_numIndex; \n\n").indent().addSourceCode("select idxname, tabname into :etls_indexName , :etls_indexTable \n").indent().addSourceCode("from &etls_deleteList \n").addSourceCode("        (firstobs = &etls_indexCount \n").addSourceCode("         obs = &etls_indexCount); \n\n").unIndent().genPercentPutStatement(bundle.getString("DBMSSTORE.DropSingleIndex.msg.sasmacro.notrans"), "NOTE:", false).addSourceCode("\n");
        this.genExecuteBegin(cgReq, "");
        this.dropSingleIndex(cgReq);
        this.genExecuteEnd(cgReq, "");
        this.genExecuteCommit(cgReq, "");
        cgReq.addSourceCode("\n").unIndent().addSourceCode("%end;  ").addCommentLine(bundle.getString("DBMSSTORE.IndexDoLoop.msg.notrans"));
        this.genDisconnect(cgReq);
        cgReq.addSourceCode("\n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
        cgReq.genTableDelete("etls_CIList etls_CIList2");
    }

    public boolean syncCISetup(CodegenRequest cgReq, Index indexToKeep) throws MdException, RemoteException {
        return true;
    }

    public void syncCIPreLoad(CodegenRequest cgReq) throws MdException, RemoteException {
        boolean cOFFBefore = this.m_TLM.isConstraintEnabled() && this.m_TLM.getConstraintBeforeValue().equals("OFF");
        boolean cONBefore = this.m_TLM.isConstraintEnabled() && this.m_TLM.getConstraintBeforeValue().equals("ON");
        boolean iOFFBefore = this.m_TLM.isIndexEnabled() && this.m_TLM.getIndexBeforeValue().equals("OFF");
        boolean iONBefore = this.m_TLM.isIndexEnabled() && this.m_TLM.getIndexBeforeValue().equals("ON");
        this.dropCI(cgReq, cONBefore || cOFFBefore, iONBefore || iOFFBefore, null);
        if (iONBefore) {
            this.createIndexes2(cgReq);
        }
        if (cONBefore) {
            this.createConstraints(cgReq);
        }
    }

    public void syncCIPostLoad(CodegenRequest cgReq, Index indexToKeep) throws MdException, RemoteException {
        boolean cOFFBefore = this.m_TLM.isConstraintEnabled() && this.m_TLM.getConstraintBeforeValue().equals("OFF");
        boolean cONAfter = this.m_TLM.isConstraintEnabled() && this.m_TLM.getConstraintAfterValue().equals("ON");
        boolean cOFFAfter = this.m_TLM.isConstraintEnabled() && this.m_TLM.getConstraintAfterValue().equals("OFF");
        boolean iOFFBefore = this.m_TLM.isIndexEnabled() && this.m_TLM.getIndexBeforeValue().equals("OFF");
        boolean iONAfter = this.m_TLM.isIndexEnabled() && this.m_TLM.getIndexAfterValue().equals("ON");
        boolean iOFFAfter = this.m_TLM.isIndexEnabled() && this.m_TLM.getIndexAfterValue().equals("OFF");
        this.dropCI(cgReq, cONAfter && !cOFFBefore || cOFFAfter, iONAfter && !iOFFBefore || iOFFAfter, null);
        if (iONAfter) {
            this.createIndexes2(cgReq);
        }
        if (cONAfter) {
            this.createConstraints(cgReq);
        }
    }

    public void dropSingleIndex2(CodegenRequest cgReq, Index index) throws MdException, RemoteException {
        IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)index);
        String indexName = indexCG.getIndexName(cgReq, true);
        cgReq.addSourceCode("drop index ").addSourceCode(indexName).addSourceCode(" \n");
    }

    public void replaceTableCIPreLoad(CodegenRequest cgReq) throws MdException, RemoteException {
    }

    public void dropSingleConstraint(CodegenRequest cgReq) throws MdException, RemoteException {
    }

    public void dropSingleIndex(CodegenRequest cgReq) throws MdException, RemoteException {
        boolean quoting = cgReq.getQuoting();
        if (quoting) {
            cgReq.addSourceCode("drop index \"%trim(%bquote(&etls_indexName))\" \n");
        } else {
            cgReq.addSourceCode("drop index &etls_indexName \n");
        }
    }

    public void exist(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq);
        cgReq.addCommentLine(bundle.getString("DBMSSTORE.Exist.msg.notrans"));
        cgReq.genTableExist(tableName, "BOTH", "etls_tableExist");
    }

    public String getAdditionalConnectionOptions(SASLibrary iMeta, String dbmsOptions) {
        return "";
    }

    public StringBuffer getConnect(CodegenRequest cgReq) {
        SASCodeGeneration sasCode = new SASCodeGeneration();
        String dbmsOptions = "";
        String dbmsOptionsExtra = "";
        String login = "";
        try {
            Deployment bestDep = this.getBestDeployment(cgReq);
            SASLibrary library = bestDep.getLibrary();
            if (library == null) {
                return sasCode.getSourceBuffer();
            }
            dbmsOptions = LibraryUtil.getConnectionOptions((SASLibrary)library);
            dbmsOptionsExtra = this.getAdditionalConnectionOptions(library, dbmsOptions);
        }
        catch (MdException e) {
            throw new CodegenException(bundle.formatString("DBMSSTORE.NoConnectionInfo.msg.txt", (Object)e.getMessage()));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (this.m_Nick == null) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        if (dbmsOptions.length() > 0) {
            sasCode.addSourceCode(dbmsOptions + "\n");
        }
        if (dbmsOptionsExtra.length() > 0) {
            sasCode.addSourceCode(dbmsOptionsExtra + "\n");
        }
        sasCode.addSourceCode(login);
        return sasCode.getSourceBuffer();
    }

    public void genConnect(CodegenRequest cgReq) {
        StringBuffer code = this.getConnect(cgReq);
        if (code != null) {
            cgReq.addSourceCode("connect to " + this.m_Nick + "\n").addSourceCode("( \n").indent();
            cgReq.addSourceCode(code);
            cgReq.addSourceCode("\n").unIndent().addSourceCode("); \n\n");
        }
    }

    public void genBeginSelectAllFromConnect(CodegenRequest cgReq) {
        if (this.m_Nick == null) {
            cgReq.throwException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        if (this.m_Nick.length() > 0) {
            cgReq.addSourceCode("select * from connection to ").addSourceCode(this.m_Nick).addSourceCode("\n(\n").indent();
        }
    }

    public void genBeginSelectAllFromConnect(CodegenRequest cgReq, StringBuffer columnCode) throws MdException, RemoteException {
        if (this.m_Nick == null) {
            cgReq.throwException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        if (this.m_Nick.length() > 0) {
            cgReq.addSourceCode("select\n").indent().addSourceCode(columnCode).unIndent().addSourceCode("\nfrom connection to ").addSourceCode(this.m_Nick).addSourceCode("\n(\n").indent();
        }
    }

    public void genEndSelectAllFromConnect(CodegenRequest cgReq) {
        if (this.m_Nick == null) {
            cgReq.throwException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        if (this.m_Nick.length() > 0) {
            cgReq.addSourceCode("\n);\n").unIndent();
            cgReq.addSourceCode("\n").genRCSetCall("&sqlrc");
        }
    }

    public void genDisconnect(CodegenRequest cgReq) {
        if (this.m_Nick == null) {
            cgReq.throwException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
            return;
        }
        cgReq.addSourceCode("disconnect from " + this.m_Nick + "; \n\n");
    }

    public void genExecuteBegin(CodegenRequest cgReq, String prefix) {
        cgReq.addSourceCode(this.getExecuteBegin(prefix).toString()).indent();
    }

    public StringBuffer getExecuteBegin(String prefix) {
        StringBuffer code = new StringBuffer();
        code.append(prefix + "execute \n").append(prefix + "( \n");
        return code;
    }

    public void genExecuteEnd(CodegenRequest cgReq, String prefix) {
        if (this.m_Nick == null) {
            cgReq.throwException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
            return;
        }
        cgReq.unIndent().addSourceCode(prefix + ") by " + this.m_Nick + "; \n\n");
        cgReq.genRCSetCall("&sqlrc");
    }

    public String getDataTableLabel() {
        return "";
    }

    public void genDeleteAll(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq, true, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("delete from " + tableName + "\n");
    }

    public void genDeleteAll2(CodegenRequest cgReq) throws MdException, RemoteException {
        this.genDeleteAll(cgReq);
    }

    public void genTruncate(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq, true, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("truncate table " + tableName + "\n");
    }

    public void genscols(CodegenRequest cgReq) throws MdException, RemoteException {
        AssociationList columnlist = this.m_table.getColumns();
        if (columnlist.size() > 0) {
            for (int i = 0; i < columnlist.size(); ++i) {
                Column column = (Column)columnlist.elementAt(i);
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
                String attrib = colCG.getColumnAttrib(cgReq);
                cgReq.addSourceCode(attrib);
            }
        } else {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnsDefined.msg.txt"));
        }
    }

    public void genSingleIndex(CodegenRequest cgReq, Index index) throws MdException, RemoteException {
        String preOpts = this.getPreIndexOptions(index);
        String tableOpts = this.getIndexTableOptions(cgReq, index);
        String idxname = this.getIndexName(cgReq, index);
        cgReq.addSourceCode("create ");
        if (preOpts.length() > 0) {
            cgReq.addSourceCode(preOpts.trim() + " ");
        }
        String tableName = this.getDataLocation(cgReq, this.m_passthru, true);
        cgReq.addSourceCode("index " + idxname + "\n").indent().addSourceCode("on " + tableName + "\n").indent().addSourceCode("  (");
        if (tableOpts.length() > 0) {
            cgReq.addSourceCode(tableOpts + "\n   ");
        }
        AssociationList lColumns = null;
        lColumns = index.getOwningPhysicalTable().getCMetadataType().equalsIgnoreCase("PhysicalTable") ? index.getColumns(true) : index.getColumns();
        if (lColumns.isEmpty()) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnsOnIndex.msg.txt"));
        }
        String columns = cgReq.makeColumnList((List)lColumns, true, "   ", this.m_passthru, ",", "");
        cgReq.addSourceCode(columns).addSourceCode(") \n").unIndent().unIndent();
    }

    public void genCodeConditionCheck(CodegenRequest cgReq, String conditionType) throws MdException, RemoteException {
        if (this.m_classifierMap == null) {
            return;
        }
        TransformationStep oStep = (TransformationStep)this.m_classifierMap.getSteps(false).get(0);
        AssociationList alTriggeredEvents = oStep.getTriggeredEvents();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event lEvent = (Event)alTriggeredEvents.get(iEvent);
            if (!lEvent.getEventRole().equals(conditionType)) continue;
            if (conditionType.equals("Condition4")) {
                cgReq.addCommentLine(bundle.getString("DBMSSTORE.CodeConditionCheck.msg.notrans"));
                this.genGetNumRows(cgReq, "&etls_lastTable", "send");
            }
            cgReq.addCommentLine(bundle.getString("DBMSSTORE.CodeConditionLoader.msg.notrans"));
            cgReq.addSourceCode("%macro etls_loaderCheck; \n").indent();
            String lEventCondition = lEvent.getCondition().trim();
            cgReq.addSourceCode(lEventCondition + "\n");
            cgReq.addSourceCode("%do; \n").indent();
            if (lEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            PropertySet lTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(lEvent, true);
            AssociationList lTrueProperties = lTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < lTrueProperties.size(); ++iAction) {
                Property oAction = (Property)lTrueProperties.get(iAction);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (DataTable)this.m_table, this.getBestDeployment(cgReq).getLibrary().getName(), (AbstractTransformation)oStep).trim());
            }
            cgReq.addSourceCode("\n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%mend etls_loaderCheck; \n").addSourceCode("%etls_loaderCheck; \n\n");
        }
    }

    public String getIndexColumnName(CodegenRequest cgReq, Column column) throws MdException, RemoteException {
        ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
        String colName = colCG.getColumnName(cgReq, true);
        if (colName == null || colName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnName.msg.txt"));
        }
        return colName;
    }

    public String getIndexName(CodegenRequest cgReq, Index index) throws MdException, RemoteException {
        IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)index);
        String indexName = indexCG.getIndexName(cgReq, true);
        if (indexName == null || indexName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.IndexNameUndefined.msg.txt"));
        }
        return indexName;
    }

    public void genExecuteCommit(CodegenRequest cgReq, String prefix) {
        cgReq.addSourceCode(prefix);
    }

    public String getIndexTableOptions(CodegenRequest cgReq, Index i_index) {
        return "";
    }

    public String getPreIndexOptions(Index i_index) {
        int unique = 0;
        try {
            unique = i_index.getIsUnique();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        int clustered = 0;
        try {
            clustered = i_index.getIsClustered();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        StringBuffer preopts = new StringBuffer("");
        if (unique != 0) {
            preopts.append("UNIQUE ");
        }
        if (clustered != 0) {
            preopts.append(this.ClusWord_0);
        }
        return preopts.toString();
    }

    public String getPostIndexOptions(Index i_index) {
        StringBuffer opts = new StringBuffer("");
        try {
            AssociationList optlist = i_index.getProperties();
            for (int j = 0; j < optlist.size(); ++j) {
                Property option = (Property)optlist.elementAt(j);
                if (j > 0) {
                    opts.append(" ");
                }
                opts.append(option.getName() + " = \"" + option.getDefaultValue() + "\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return opts.toString();
    }

    public void queryConstraints(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = DBMSSTORE.getTableName(this.getDataLocation(cgReq, true, true));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        String schema = this.getSchemaName(cgReq, true);
        cgReq.indent().addSourceCode("from \n").indent().addSourceCode("( \n").addSourceCode(" select 'P' as constType, 'NA' as constName \n").indent().addSourceCode(" from connection to ").addSourceCode(this.getNickname()).addSourceCode("\n").indent().addSourceCode(" (DBMS::PrimaryKeys (\"\", " + schema + ", " + tableName + ")) \n").unIndent().unIndent().addSourceCode(");\n").unIndent().unIndent();
    }

    public void queryIndexes(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = DBMSSTORE.getTableName(this.getDataLocation(cgReq, true, true));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        String schema = this.getSchemaName(cgReq, true);
        cgReq.indent().addSourceCode("from \n").indent().addSourceCode("( \n").addSourceCode(" select distinct index_name as idxname, \n").addSourceCode("        table_name as tabname \n").indent().addSourceCode(" from connection to ").addSourceCode(this.getNickname()).addSourceCode("\n").indent().addSourceCode(" (DBMS::Indexes (\"\", " + schema + ", " + tableName + ")) \n").unIndent().unIndent().addSourceCode(");\n").unIndent().unIndent();
    }

    public StringBuffer getDSOptions() {
        return this.getDSOptions(false);
    }

    public StringBuffer getDSOptions(boolean addParens) {
        StringBuffer options = new StringBuffer();
        try {
            String ttOpts;
            String dtOpts;
            if (this.m_TLO != null && (dtOpts = this.m_TLO.getDataTableOptions()) != null && dtOpts.trim().length() > 0) {
                options.append(dtOpts.trim());
            }
            if ((ttOpts = this.getTargetTableOptions()) != null && ttOpts.trim().length() > 0) {
                if (options.length() > 0) {
                    options.append(" ");
                }
                options.append(ttOpts.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (addParens && options.length() > 0) {
            options.insert(0, " (").append(")");
        }
        return options;
    }

    public void setClusterWord(String word) {
        this.ClusWord_0 = word;
    }

    public String getConstraintTypesDroppable() throws MdException, RemoteException {
        return this.m_constraintTypesDroppable;
    }

    public boolean getNotNullIsConstraint() throws MdException, RemoteException {
        return this.m_notNullIsConstraint;
    }

    public void setConstraintTypesDroppable(String punf) {
        this.m_constraintTypesDroppable = punf;
    }

    public void setAddKeyDelimiter(String delim) {
        this.m_addKeyDelimiter = delim;
    }

    public void setRepeatAddKeyCommand(boolean repeat) {
        this.m_repeatAddKeyCommand = repeat;
    }

    public void setAddOneKeyPerExecute(boolean onePerExecute) {
        this.m_addOneKeyPerExecute = onePerExecute;
    }

    public void setNotNullIsConstraint(boolean isConstraint) {
        this.m_notNullIsConstraint = isConstraint;
    }

    public void setNickname(CodegenRequest cgReq) {
        Deployment bestDep = this.getBestDeployment(cgReq);
        SASLibrary library = bestDep.getLibrary();
        if (library != null) {
            try {
                this.m_Nick = library.getEngine();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public void setMetadata() {
        this.m_table = (PhysicalTable)this.getMetadataClass();
    }

    public String getNickname() {
        return this.m_Nick;
    }

    public void setClassifierMap(ClassifierMap classifierMap) {
        this.m_classifierMap = classifierMap;
    }

    public void setTLO(ClassifierMap classifierMap) throws MdException, RemoteException {
        this.m_TLO = new TableLoaderOptions(classifierMap);
    }

    public boolean getDeleteAllRowsSupport() {
        return true;
    }

    public boolean getTruncateSupport() throws MdException, RemoteException {
        return true;
    }

    public boolean getIndexSupport() {
        return this.m_indexSupport;
    }

    public void setIndexSupport(boolean supported) {
        this.m_indexSupport = supported;
    }

    public boolean getConstraintSupport() {
        return this.m_constraintSupport;
    }

    public void setConstraintSupport(boolean supported) {
        this.m_constraintSupport = supported;
    }

    public boolean getPassThroughSupport() {
        return true;
    }

    public void setRandomAccessSupport(boolean supported) {
        this.m_randomAccessSupport = supported;
    }

    public boolean getRandomAccessSupport() {
        return this.m_randomAccessSupport;
    }

    public boolean getUpsertSupport() {
        return this.m_upsertSupport;
    }

    public void setUpsertSupport(boolean supported) {
        this.m_upsertSupport = supported;
    }

    public void setTableAliasKeyword(String keyword) {
        this.m_tableAliasKeyword = keyword;
    }

    public String getTableAliasKeyword(boolean passthru) {
        if (passthru) {
            return this.m_tableAliasKeyword;
        }
        return DEFAULT_TABLE_ALIAS_KEYWORD;
    }

    public void genParmsInSASLog(CodegenRequest cgReq, TableLoaderModel model) throws MdException, RemoteException {
        String loadType = model.getLoadStyleValue();
        cgReq.addSourceCode("/* --------------------------------------------------------------\n").indent().addSourceCode("Load Technique Selection: " + loadType);
        if (loadType.equalsIgnoreCase("Update")) {
            cgReq.addSourceCode(" - Matching=" + model.getMatchingRowsValue()).addSourceCode(", New=" + model.getNewRowsValue() + "\n").addSourceCode("Blanks may replace non-blanks: " + model.getNoMissingCheck());
        } else if (loadType.equalsIgnoreCase("Replace")) {
            cgReq.addSourceCode(" - " + model.getReplaceType());
        } else {
            cgReq.addSourceCode(" - " + model.getNewRowsValue());
        }
        cgReq.addSourceCode("\n").addSourceCode("Constraint and index action selections: " + model.getCIActionsSelected(",", true) + "\n");
        cgReq.addSourceCode("Advanced options selections... \n").addSourceCode("   Reapply pre-existing constraints when replacing SAS tables: " + model.getReapplyCInReplaceDS(true) + "\n").addSourceCode("   Set unmapped to missing on updates: " + model.getUnmappedEqMissingInUpdate(true) + " \n").unIndent().addSourceCode("   -------------------------------------------------------------- */\n ");
    }
}

