/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class ColumnCG
extends CodeGenRoot {
    private static WAdminResource bundle = WAdminResource.getBundle(ColumnCG.class);

    public String getColumnName(CodegenRequest cgReq) throws MdException, RemoteException {
        return this.getColumnName(cgReq, false);
    }

    public String getColumnName(CodegenRequest cgReq, boolean passthru) throws MdException, RemoteException {
        Column column = (Column)this.getMetadataClass();
        String name = column.getSASColumnName();
        if (name == null || name.trim().length() == 0) {
            throw new CodegenException(bundle.getString("ColumnCG.MissingColumnName.msg.txt"));
        }
        name = DBMSNamesUtil.getQuotedColumnName((Column)column, (boolean)cgReq.getQuoting(), (boolean)passthru);
        return name;
    }

    public String getColumnFormat(CodegenRequest cgReq) throws MdException, RemoteException {
        Column column = (Column)this.getMetadataClass();
        String type = column.getSASColumnType();
        String format = column.getSASFormat();
        format = cgReq.getSASCodeGeneration().makeFormatName(format, true, type);
        return format;
    }

    public String getColumnInformat(CodegenRequest cgReq) throws MdException, RemoteException {
        Column column = (Column)this.getMetadataClass();
        String type = column.getSASColumnType();
        String informat = column.getSASInformat();
        informat = cgReq.getSASCodeGeneration().makeFormatName(informat, false, type);
        return informat;
    }

    public String getColumnNamePrev(CodegenRequest cgReq, boolean passthru) throws MdException, RemoteException {
        Column column = (Column)this.getMetadataClass();
        String name = column.getSASColumnName();
        String prev_specChar = cgReq.getGlobalData("prevCase");
        String prev_preserveCase = cgReq.getGlobalData("prevSpecChar");
        String specChar = cgReq.getGlobalData("Case");
        String preserveCase = cgReq.getGlobalData("SpecChar");
        if (name == null || name.trim().length() == 0) {
            throw new CodegenException(bundle.getString("ColumnCG.MissingColumnName.msg.txt"));
        }
        if (specChar.equalsIgnoreCase("Y") || preserveCase.equalsIgnoreCase("Y") || prev_specChar.equalsIgnoreCase("Y") || prev_preserveCase.equalsIgnoreCase("Y")) {
            name = DBMSNamesUtil.getQuotedString((String)name, (boolean)passthru);
        }
        return name;
    }

    public String getColumnAttrib(CodegenRequest cgReq) throws MdException, RemoteException {
        return this.getColumnAttrib(cgReq, true, true);
    }

    public String getColumnAttrib(CodegenRequest cgReq, boolean needLabel, boolean needFormats) throws MdException, RemoteException {
        return this.getAttrib(cgReq, true, needLabel, needFormats);
    }

    public String getSelectAttrib(CodegenRequest cgReq, boolean needLabel, boolean needFormats) throws MdException, RemoteException {
        return this.getAttrib(cgReq, false, needLabel, needFormats);
    }

    public String getAttrib(CodegenRequest cgReq, boolean isDataStep, boolean needLabel, boolean needFormats) throws MdException, RemoteException {
        Column column = (Column)this.getMetadataClass();
        return cgReq.getSASCodeGeneration().getAttrib(column, isDataStep, false, needLabel, needFormats, cgReq.getQuoting());
    }

    public String makeFormatName(CodegenRequest cgReq, String fmtName, String type) throws MdException, RemoteException {
        return cgReq.getSASCodeGeneration().makeFormatName(fmtName, type);
    }
}

