/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenInterface;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.ExternalTableCG;
import com.sas.codegen.Loader;
import com.sas.codegen.PhysicalTableCG;
import com.sas.codegen.SASLibraryCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformVersionInterface;
import com.sas.workspace.AppServer;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.TransformUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.metadata.EFIDataModel;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodegenRequest {
    private static WAdminResource bundle = WAdminResource.getBundle(CodegenRequest.class);
    private CMetadata m_Metadata;
    private StringBuffer m_GeneratedSource;
    private CodegenWaitThread m_CodegenWait;
    private boolean m_CodegenFinished;
    private boolean m_synchRequest;
    private HashMap m_mapGeneratedParallelMacros;
    private int m_status;
    private int m_scope;
    private String m_errorMsg;
    private SASCodeGeneration m_SASCodeGen;
    private HashMap m_ObjectList;
    private Set m_ContextList;
    private HashMap m_libraryContextList;
    private AppServer m_Server;
    private WsAppServer m_WsAppServer;
    private List m_hostList;
    private ServerContext m_host;
    private HashMap m_globalData;
    private int m_numIndents = 0;
    private String m_indentString = "";
    private boolean m_JCLCode = false;
    private HashMap m_commentLabelMap;
    private AbstractTransformation m_currentTransformation;
    private CodeGenUtil m_codegenCache;
    private boolean m_parallelOn = false;
    private int m_parallelNestLevels = -1;
    private boolean m_pipingOn = false;
    private Stack m_currentParallelTaskStack;
    private int m_processNumber = -1;
    private HashMap m_workTablesMap;
    private HashMap m_loopMap;
    private boolean m_unIndentJobCode = true;
    private ParametersInterface m_parametersInterface = null;
    private boolean m_generateParameterDefaults = true;
    private List m_lstXMLTableStreamFQIDs = null;
    private HashMap m_remoteMacroVariables;
    private boolean m_inRemoteSubmit = false;
    private HashMap m_jobStatus;
    private Stack m_currentJob;
    private Stack m_currentLoop;
    private boolean m_throwExceptions = true;
    private boolean m_bGenerateDebugSetting = true;
    public String m_serverID;
    private static final int BUFFER_SIZE = 6144;
    public static final int GENSelfOnly = 0;
    public static final int GENAll = 1;
    public static final boolean SYNCHRONOUS = true;
    public static final boolean ASYNCHRONOUS = false;
    public static final String CASE = "Case";
    public static final String SPECIAL_CHAR = "SpecChar";
    public static final String VALID_VARNAME = "ValidVarName";
    public static final String PREVIOUS_CASE = "prevCase";
    public static final String PREVIOUS_SPECIAL_CHAR = "prevSpecChar";
    public static final String TRANSFER_STEP = "TransferStep";
    public static final String CONTENTS_STEP = "ContentsStep";
    public static final String MACRO_VARS = "Macro Variables";
    public static final String PROCESS_STATS = "Process Stats";
    public static final String JOB_STATUS = "JobStatus";
    public static final String GLOBAL_YES = "Y";
    public static final String GLOBAL_NO = "N";
    public static final String GLOBAL_ANY = "ANY";
    public static final String GLOBAL_V7 = "V7";
    public static final String GLOBAL_ALL = "ALL";
    private static final String JOB_DIVIDER = "*";
    private static final String STEP_DIVIDER = "=";
    private static final String ERROR_DIVIDER = "!";
    private static final String SECTION_MARKER = "-";
    private static final int UNINDENT_ALL = 100;
    private static final String JCL_INDENT = " ";
    public static final String INDENT = "   ";
    public static final int LINE_LENGTH = 78;
    public static final String NOTE_LABEL = "NOTE:";
    public static final String WARNING_LABEL = "WARNING:";
    public static final String ERROR_LABEL = "ERROR:";
    private static final String JOB_KEY = "JOB";
    private static final String REPOS_KEY = "REPOS";
    private static final String VERSION_KEY = "VERSION";
    private static final String SERVER_KEY = "SERVER";
    private static final String GEN_ON_KEY = "GENON";
    private static final String GEN_BY_KEY = "GENBY";
    private static final String STEP_KEY = "STEP";
    private static final String TRANSFORM_KEY = "TRANSFORM";
    private static final String ERROR_TYPE_KEY = "ERRORTYPE";
    private static final String DESC_KEY = "DESC";
    private static final String USER_KEY = "USER";
    private static final String SOURCE_KEY = "SOURCE";
    private static final String SOURCES_KEY = "SOURCES";
    private static final String TARGET_KEY = "TARGET";
    private static final String TARGETS_KEY = "TARGETS";
    private static final String HIDE_KEYWORD = ":HIDE";
    public static final int CODEGEN_OK = 0;
    public static final int CODEGEN_FAILED = -1;
    public static final String WORK_LIBREF = "work";
    public static final String PARALLEL_WORK_LIBREF = "etlswork";
    public static final String PREPROCESS = "PreProcess";
    public static final String POSTPROCESS = "PostProcess";
    public static final String SYSTEM_OPTIONS = "SystemOptions";
    public static final String DATA_TYPE = "DATA";
    public static final String VIEW_TYPE = "VIEW";
    public static final String DATA_AND_VIEW_TYPE = "BOTH";
    public static final String DEFAULT_LOADTIME = "_LOADTM";
    public static final String LOADER_CLASS = "com.sas.wadmin.visuals.SASLoader";
    public static final String LOADER_CLASS_2 = "com.sas.wadmin.transforms.loader.TableLoader";
    public static final String SPDS_LOADER_CLASS = "com.sas.wadmin.visuals.SPDSLoader";
    public static final String SCD_LOADER_CLASS = "com.sas.wadmin.transforms.sasscd.visuals.SCDType2";
    public static final String KED_LOADER_CLASS = "com.sas.wadmin.transforms.sasscd.visuals.KeyEffectiveDate";
    public static final String TRANSFER_CLASS = "com.sas.wadmin.visuals.SASDataTransfer";
    public static final String TRANSFER_ROLE = "TransferStep";
    public static final String CONTENTS_ROLE = "Contents";
    public static final String CONTENTS_PACKAGE = "com.sas.wadmin.transforms.contentreaders";
    public static final String CLASS_PROPERTY = "CLASS";
    public static final int MAXIMUM_INT = -1;
    public boolean m_cancelCodegen;
    public static final int CODEGENCOMMENT_LOGICALSTEP = 1;
    public static final int CODEGENCOMMENT_SUBSTEP = 0;
    public static final int CODEGENCOMMENT_JOB = 1;

    public CodegenRequest(CMetadata myMetadata, AppServer myAppServer, int scope, boolean synchRequest) {
        this(myMetadata, myAppServer, scope, synchRequest, null);
    }

    public CodegenRequest(CMetadata myMetadata, AppServer myAppServer, int scope, boolean synchRequest, ParametersInterface parmInterface) {
        this.m_Server = myAppServer;
        this.m_WsAppServer = null;
        this.m_parametersInterface = parmInterface;
        this.setup(myMetadata, scope, synchRequest);
    }

    public CodegenRequest(CMetadata myMetadata, WsAppServer myAppServer, int scope, boolean synchRequest) {
        this(myMetadata, myAppServer, scope, synchRequest, null);
    }

    public CodegenRequest(CMetadata myMetadata, WsAppServer myAppServer, int scope, boolean synchRequest, ParametersInterface parmInterface) {
        this.m_Server = null;
        this.m_WsAppServer = myAppServer;
        this.m_parametersInterface = parmInterface;
        this.setup(myMetadata, scope, synchRequest);
    }

    private void setup(CMetadata myMetadata, int scope, boolean synchRequest) {
        this.m_scope = scope;
        this.m_synchRequest = synchRequest;
        this.m_GeneratedSource = new StringBuffer(6144);
        this.m_ContextList = new HashSet();
        this.m_libraryContextList = new HashMap();
        this.m_ObjectList = new HashMap();
        this.m_codegenCache = new CodeGenUtil();
        this.m_hostList = new ArrayList();
        this.m_globalData = new HashMap();
        this.m_workTablesMap = new HashMap();
        this.m_loopMap = new HashMap();
        this.m_remoteMacroVariables = new HashMap();
        this.m_mapGeneratedParallelMacros = new HashMap();
        this.m_jobStatus = new HashMap();
        this.m_currentJob = new Stack();
        this.m_currentLoop = new Stack();
        this.m_Metadata = myMetadata;
        this.m_SASCodeGen = new SASCodeGeneration();
        this.m_currentParallelTaskStack = new Stack();
        this.m_JCLCode = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.GenerateJCL", false);
        if (this.m_WsAppServer != null) {
            this.setCurrentServer((DeployedComponent)this.m_WsAppServer.getServerContext(), true);
        } else if (this.m_Server != null) {
            this.setCurrentServer((DeployedComponent)this.m_Server.getServerContext(), true);
        }
        this.createCommentLabelMap();
    }

    public String getUniqueWorkTableName(int offset) {
        String workTableName = TransformUtil.createWorkTableName((int)offset);
        while (this.m_workTablesMap.containsKey(workTableName)) {
            workTableName = TransformUtil.createWorkTableName((int)offset++);
        }
        this.m_workTablesMap.put(workTableName, workTableName);
        return workTableName;
    }

    public void genParameterDefaultValueCode(Root mdObject) throws MdException, RemoteException {
        if (this.m_parametersInterface != null && this.m_generateParameterDefaults) {
            this.m_parametersInterface.setMetadata(mdObject);
            if (this.m_parametersInterface.isParameterizedObject() && !this.m_parametersInterface.isGeneratedTransform()) {
                this.addRemoteMacroVariables(this.m_parametersInterface.getParameterDefinitions());
                this.addSourceCode(this.getParameterDefaultValueCode(mdObject));
            }
        }
    }

    public StringBuffer getParameterDefaultValueCode(Root mdObject) throws MdException, RemoteException {
        StringBuffer code = new StringBuffer();
        if (this.m_parametersInterface != null && this.m_generateParameterDefaults) {
            this.m_parametersInterface.setMetadata(mdObject);
            if (!this.m_parametersInterface.isParameterizedObject() || !this.m_parametersInterface.isGeneratedTransform()) {
                // empty if block
            }
        }
        return code;
    }

    public boolean isGeneratingDebugSetting() {
        return this.m_bGenerateDebugSetting;
    }

    public void setGeneratingDebugSetting(boolean bGenerateDebugSetting) {
        this.m_bGenerateDebugSetting = bGenerateDebugSetting;
    }

    public boolean getGenerateParameterDefaultSetting() {
        return this.m_generateParameterDefaults;
    }

    public void setGenerateParameterDefaultSetting(boolean genDefaults) {
        this.m_generateParameterDefaults = genDefaults;
    }

    public List getXMLTableStreams() {
        return this.m_lstXMLTableStreamFQIDs;
    }

    public void setThrowExceptions(boolean throwExc) {
        this.m_throwExceptions = throwExc;
    }

    public boolean isThrowingExceptions() {
        return this.m_throwExceptions;
    }

    public void throwException(String message) throws CodegenException {
        if (this.m_throwExceptions) {
            throw new CodegenException(message);
        }
        this.addCommentLine(message).addSourceCode("\n");
    }

    public void setXMLTableStreams(List xmlTableStreams) {
        this.m_lstXMLTableStreamFQIDs = xmlTableStreams;
    }

    public boolean isTableAStream(DataTable table) {
        try {
            return this.m_lstXMLTableStreamFQIDs != null && this.m_lstXMLTableStreamFQIDs.contains(table.getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public String getUniqueLoopHandleName() {
        Random generator = new Random();
        String loopname = "L" + Integer.toString(generator.nextInt(100)) + "_";
        while (this.m_loopMap.containsKey(loopname)) {
            loopname = "L" + Integer.toString(generator.nextInt(100)) + "_";
        }
        this.m_loopMap.put(loopname, loopname);
        return loopname;
    }

    public String getUniqueWorkTableName() {
        return this.getUniqueWorkTableName(0);
    }

    public String getErrorMessage() {
        return this.m_errorMsg;
    }

    public int getRC() {
        return this.m_status;
    }

    public AppServer getAppServer() {
        return this.m_Server;
    }

    public WsAppServer getWsAppServer() {
        return this.m_WsAppServer;
    }

    public String getAppServerID() {
        return this.m_serverID;
    }

    public ServerContext getAppServerContext() {
        if (this.m_WsAppServer != null) {
            try {
                this.m_WsAppServer.getServerName();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            return this.m_WsAppServer.getServerContext();
        }
        if (this.m_Server != null) {
            return this.m_Server.getServerContext();
        }
        return null;
    }

    public boolean isJobDateFormatNLS(AbstractTransformation mObject) throws MdException, RemoteException {
        return this.m_SASCodeGen.isJobDateFormatNLS(mObject);
    }

    public boolean getParallelMacroStatus(ServerContext server) {
        return this.m_mapGeneratedParallelMacros.get(server) != null && !this.m_inRemoteSubmit;
    }

    public void addContextList(String id) {
        if (!this.m_ContextList.contains(id)) {
            this.m_ContextList.add(id);
        }
    }

    public boolean onContextList(String id) {
        return this.m_ContextList.contains(id);
    }

    public List getLibraryContextList(String task) {
        if (this.m_libraryContextList.containsKey(task)) {
            return (List)this.m_libraryContextList.get(task);
        }
        ArrayList contextList = new ArrayList();
        this.m_libraryContextList.put(task, contextList);
        return contextList;
    }

    public void setLibraryContextList(List newList, String task) {
        if (newList != null) {
            this.m_libraryContextList.clear();
            this.m_libraryContextList.put(task, newList);
        }
    }

    public void addLibraryContext(String ID) {
        List contextList = this.getLibraryContextList(this.getCurrentParallelTask());
        if (!contextList.contains(ID)) {
            contextList.add(ID);
        }
    }

    public boolean onLibraryContextList(String ID) {
        List contextList = (List)this.m_libraryContextList.get(this.getCurrentParallelTask());
        if (contextList == null) {
            return false;
        }
        return contextList.contains(ID);
    }

    public void doCodegen() {
        if (this.m_Server == null && this.m_WsAppServer == null) {
            this.setIndent(0);
            this.addErrorComment(bundle.getString("CodegenRequest.NoAppServer.msg.txt"), bundle.getString("CodegenRequest.NoAppServer.title.txt"));
            this.addSourceCode("\n");
            this.addCommentLine(bundle.getString("CodegenRequest.CodegenAborted.msg.txt"));
            this.postCompletion(-1);
        } else {
            try {
                this.m_serverID = this.getAppServerContext().getFQID();
                this.m_codegenCache.clearCodeGenCache();
                if (this.m_synchRequest) {
                    this.doTheCodegen();
                } else {
                    this.m_CodegenWait = new CodegenWaitThread(this);
                    this.m_CodegenWait.start();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTheCodegen() {
        int statusCode = 0;
        this.setCurrentServer((DeployedComponent)this.getAppServerContext());
        try {
            MdObjectStore cgStore = Workspace.getMdFactory().createObjectStore(this.m_Metadata.getObjectStore());
            try {
                CMetadata iNewObj = Workspace.getMdFactory().createComplexMetadataObject(cgStore, null, this.m_Metadata.getName(), this.m_Metadata.getCMetadataType(), this.m_Metadata.getFQID());
                CodeGenInterface iObj = CodeGenUtil.getCodeGenClass(iNewObj);
                if (this.m_scope == 1) {
                    iObj.codeGen(this);
                } else {
                    iObj.codeGenSelfOnly(this);
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                if (e instanceof CodegenException) {
                    this.addErrorComment(e.getMessage(), bundle.getString("CodegenRequest.CodegenError.title.txt"));
                } else {
                    this.addErrorComment(e.getMessage() + "\n", bundle.getString("CodegenRequest.MetadataError.msg.txt"));
                }
                this.addCommentLine(bundle.getString("CodegenRequest.CodegenAborted.msg.txt"));
                statusCode = -1;
            }
            finally {
                this.postCompletion(statusCode);
                cgStore.dispose();
                try {
                    this.m_ContextList.clear();
                    this.m_libraryContextList.clear();
                    this.m_ObjectList.clear();
                    this.m_codegenCache.clearCodeGenCache();
                }
                catch (Exception ge) {
                    System.err.println(ge.getMessage());
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public synchronized int waitForCompletion() {
        try {
            while (!this.m_CodegenFinished) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            this.m_status = 1;
        }
        return this.m_status;
    }

    public synchronized void postCompletion(int status) {
        this.m_status = status;
        this.m_CodegenFinished = true;
        this.m_globalData.clear();
        this.notifyAll();
    }

    public void removeObjectFromCache(CMetadata meta) {
        this.m_codegenCache.removeObjectFromCache(meta);
    }

    public void cleanUpWorkLibraries() {
        HashMap cache = this.m_codegenCache.getCodeGenCache();
        Iterator it = cache.keySet().iterator();
        while (it.hasNext()) {
            SASLibraryCG libCG;
            RelationalSchema rSchema;
            Object cgObject = cache.get(it.next());
            if (!(cgObject instanceof SASLibraryCG) || !((rSchema = (RelationalSchema)(libCG = (SASLibraryCG)cgObject).getMetadataClass()) instanceof SASLibrary)) continue;
            SASLibrary lib = (SASLibrary)rSchema;
            try {
                MdObjectStore store = (MdObjectStore)lib.getObjectStore();
                if (lib == null || store == null || store.getDetailObjectMap() == null || !lib.getLibref().equalsIgnoreCase(WORK_LIBREF) || lib.getIsPreassigned() != 1) continue;
                cache.remove(it);
                store.removeElementFromStore((CMetadata)lib, false);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public CodegenRequest clearSourceCode() {
        return this.clearSourceCode(true);
    }

    public CodegenRequest clearSourceCode(boolean cleanCache) {
        this.m_GeneratedSource = new StringBuffer();
        this.m_numIndents = 0;
        this.m_indentString = "";
        if (cleanCache) {
            this.m_libraryContextList = new HashMap();
            this.m_codegenCache.clearCodeGenCache();
            this.m_globalData.clear();
        }
        return this;
    }

    public void cleanupCodeGen() {
        if (this.m_Metadata != null) {
            try {
                this.deleteMetadataObject(this.m_Metadata.getFQID());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        this.m_Metadata = null;
        this.m_hostList = null;
        this.m_Server = null;
        this.m_WsAppServer = null;
        this.clearSourceCode();
    }

    public void deleteMetadataObject(String strFQID) {
        this.m_ObjectList.remove(strFQID);
    }

    public ServerContext getCurrentServer() {
        return this.m_host;
    }

    public void setCurrentServer(DeployedComponent iServer) {
        this.setCurrentServer(iServer, false);
    }

    public void setCurrentServer(DeployedComponent iServer, boolean updateServerID) {
        this.m_host = (ServerContext)iServer;
        if (updateServerID) {
            if (this.m_host != null) {
                try {
                    this.m_serverID = this.m_host.getFQID();
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            } else {
                this.m_serverID = null;
            }
        }
    }

    public void setHost(WsAppServer wsAppServer) {
        this.setCurrentServer((DeployedComponent)wsAppServer.getServerContext(), true);
        this.m_WsAppServer = wsAppServer;
    }

    public String getGlobalData(String globalVar) {
        String retVal = (String)this.m_globalData.get(globalVar);
        if (retVal == null) {
            retVal = globalVar.equalsIgnoreCase(CASE) ? GLOBAL_NO : (globalVar.equalsIgnoreCase(SPECIAL_CHAR) ? GLOBAL_NO : (globalVar.equalsIgnoreCase(VALID_VARNAME) ? GLOBAL_V7 : ""));
        }
        return retVal;
    }

    public void setGlobalData(String globalVar, String globalValue) {
        this.m_globalData.put(globalVar, globalValue);
    }

    public void removeGlobalData(String globalVar) {
        this.m_globalData.remove(globalVar);
    }

    public boolean getQuoting() {
        String specChar = this.getGlobalData(CASE);
        String preserveCase = this.getGlobalData(SPECIAL_CHAR);
        return specChar.equalsIgnoreCase(GLOBAL_YES) || preserveCase.equalsIgnoreCase(GLOBAL_YES);
    }

    public boolean getCase() {
        String specChar = this.getGlobalData(CASE);
        return specChar.equalsIgnoreCase(GLOBAL_YES);
    }

    public void setCurrentTransformation(AbstractTransformation transform) {
        this.m_currentTransformation = transform;
    }

    public AbstractTransformation getCurrentTransformation() {
        return this.m_currentTransformation;
    }

    public SASCodeGeneration getSASCodeGeneration() {
        return this.m_SASCodeGen;
    }

    public void setParallel(boolean parallelOn) {
        this.m_parallelOn = parallelOn;
    }

    public boolean isParallelOn() {
        return this.m_parallelOn;
    }

    public void setPiping(boolean pipingOn) {
        this.m_pipingOn = pipingOn;
    }

    public boolean isPipingOn() {
        return this.m_pipingOn;
    }

    public void setParallelNestLevels(int nestLevels) {
        this.m_parallelNestLevels = nestLevels;
    }

    public int getParallelNestLevels() {
        return this.m_parallelNestLevels;
    }

    public void setCurrentParallelTask(String task) {
        if (task.length() == 0) {
            this.m_currentParallelTaskStack.pop();
        } else {
            this.m_currentParallelTaskStack.push(task);
        }
    }

    public String getCurrentParallelTask() {
        if (this.m_currentParallelTaskStack.isEmpty()) {
            return "";
        }
        return (String)this.m_currentParallelTaskStack.peek();
    }

    public int getProcessNumber() {
        return this.m_processNumber;
    }

    public void setProcessNumber(int processNumber) {
        this.m_processNumber = processNumber;
    }

    public int incrementProcessNumber() {
        ++this.m_processNumber;
        return this.m_processNumber;
    }

    public CodegenRequest addSourceCode(String sourceText) {
        if (sourceText != null) {
            if (this.m_JCLCode && this.m_GeneratedSource.length() == 0 && !sourceText.startsWith("\n")) {
                this.m_GeneratedSource.append(JCL_INDENT);
            }
            if (this.m_indentString.length() > 0) {
                sourceText = sourceText.replaceAll("\n", "\n" + this.m_indentString);
            }
            this.m_GeneratedSource.append(sourceText);
        }
        return this;
    }

    public CodegenRequest addSourceCode(StringBuffer sourceText) {
        if (sourceText != null) {
            String source = sourceText.toString();
            this.addSourceCode(source);
        }
        return this;
    }

    public String getSource() {
        return this.m_GeneratedSource.toString();
    }

    public StringBuffer getSourceBuffer() {
        return this.m_GeneratedSource;
    }

    public CodegenRequest addCommentLine(String msg) {
        this.addSourceCode(this.m_SASCodeGen.makeComment(msg));
        return this;
    }

    public String makeCommentLine(String msg) {
        return this.m_SASCodeGen.makeComment(msg);
    }

    public CodegenRequest addJobComment(Job job) {
        if (this.m_unIndentJobCode) {
            this.unIndent(100);
        }
        String divider = this.repeat(JOB_DIVIDER, 75);
        this.addSourceCode("/*").addSourceCode(divider).addSourceCode(" \n");
        this.genCommentLine((String)this.m_commentLabelMap.get(JOB_KEY), (CMetadata)job);
        try {
            String description = job.getDesc();
            this.genCommentLine((String)this.m_commentLabelMap.get(DESC_KEY), description, "");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.genCommentLine();
        CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
        this.genCommentLine((String)this.m_commentLabelMap.get(REPOS_KEY), repos);
        ServerContext server = this.getCurrentServer();
        this.genCommentLine((String)this.m_commentLabelMap.get(SERVER_KEY), (CMetadata)server);
        this.genCommentUserWrittenLine((AbstractTransformation)job, (String)this.m_commentLabelMap.get(USER_KEY));
        this.genCommentLine();
        this.genCommentTableLine(job, (String)this.m_commentLabelMap.get(SOURCE_KEY), (String)this.m_commentLabelMap.get(SOURCES_KEY), (String)this.m_commentLabelMap.get(TARGET_KEY), (String)this.m_commentLabelMap.get(TARGETS_KEY));
        String date = DateFormat.getDateTimeInstance(0, 0).format(Calendar.getInstance().getTime());
        this.genCommentLine((String)this.m_commentLabelMap.get(GEN_ON_KEY), date, "");
        this.genCommentLine((String)this.m_commentLabelMap.get(GEN_BY_KEY), Workspace.getWorkspace().getUsername(), "");
        String version = Double.toString(Workspace.getWorkspace().getApplicationVersionNumber());
        if (version != null && version.length() > 0) {
            this.genCommentLine((String)this.m_commentLabelMap.get(VERSION_KEY), version, "");
        }
        this.genCommentNotesLine((AbstractTransformation)job, divider);
        try {
            if (job.getIsActive() <= 0) {
                this.genCommentNotActive(divider);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("/ \n\n");
        return this;
    }

    public CodegenRequest addProcessComment(Transformation transformation, String name) {
        if (this.m_unIndentJobCode) {
            this.unIndent(100);
        }
        String divider = this.repeat(STEP_DIVIDER, 74);
        this.addSourceCode("/*").addSourceCode(divider).addSourceCode("* \n");
        try {
            this.genCommentLine("", name, transformation.getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.genCommentUserWrittenLine((AbstractTransformation)transformation, (String)this.m_commentLabelMap.get(USER_KEY), true);
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n\n");
        return this;
    }

    public CodegenRequest addStepComment(TransformationStep step) {
        String divider = this.repeat(STEP_DIVIDER, 74);
        this.addSourceCode("/*").addSourceCode(divider).addSourceCode("* \n");
        this.genCommentStepLines(step);
        try {
            String description = step.getDesc();
            this.genCommentLine((String)this.m_commentLabelMap.get(DESC_KEY), description, "");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        List tableList = this.getCommentTableLists(step);
        List sourceList = (List)tableList.get(0);
        List targetList = (List)tableList.get(1);
        if (!sourceList.isEmpty() || !targetList.isEmpty()) {
            this.genCommentLine();
            this.genCommentTableLine(sourceList, (String)this.m_commentLabelMap.get(SOURCE_KEY), (String)this.m_commentLabelMap.get(SOURCES_KEY));
            this.genCommentTableLine(targetList, (String)this.m_commentLabelMap.get(TARGET_KEY), (String)this.m_commentLabelMap.get(TARGETS_KEY));
        }
        ClassifierMap classifierMap = null;
        try {
            AssociationList cmList = step.getTransformations();
            if (!cmList.isEmpty()) {
                classifierMap = (ClassifierMap)cmList.get(0);
            }
            if (step.getIsUserDefined() == 1) {
                this.genCommentUserWrittenLine((AbstractTransformation)step, (String)this.m_commentLabelMap.get(USER_KEY));
            } else if (classifierMap != null && classifierMap.getIsUserDefined() == 1) {
                this.genCommentUserWrittenLine((AbstractTransformation)classifierMap, (String)this.m_commentLabelMap.get(USER_KEY));
            }
        }
        catch (MdException cmList) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.genCommentNotesLine((AbstractTransformation)step, divider + JOB_DIVIDER);
        try {
            if (step.getIsActive() <= 0 || classifierMap != null && classifierMap.getIsActive() <= 0) {
                this.genCommentNotActive(divider + JOB_DIVIDER);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n\n");
        return this;
    }

    public CodegenRequest addErrorComment(String msg, String name) {
        if (msg == null) {
            msg = "";
        }
        if (name == null) {
            name = "";
        }
        String divider = this.repeat(ERROR_DIVIDER, 74);
        if (this.m_unIndentJobCode) {
            this.unIndent(100);
        }
        this.addSourceCode("\n").addSourceCode("/*").addSourceCode(divider).addSourceCode("* \n");
        this.genCommentLine(bundle.getString("CodegenRequest.CodegenError.msg.txt"), "", "");
        this.genCommentLine();
        if (this.m_currentTransformation != null) {
            try {
                String metaType = this.m_currentTransformation.getCMetadataType();
                if (metaType.equals("Job")) {
                    this.genCommentLine((String)this.m_commentLabelMap.get(JOB_KEY), (CMetadata)this.m_currentTransformation);
                    this.genCommentLine();
                } else if (metaType.equals("TransformationStep")) {
                    this.genCommentStepLines((TransformationStep)this.m_currentTransformation);
                    this.genCommentLine();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        this.genCommentLine((String)this.m_commentLabelMap.get(ERROR_TYPE_KEY), name, "");
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("* \n");
        this.genCommentLine();
        this.genCommentLine("", msg, "");
        this.genCommentLine();
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n\n");
        if (this.m_currentTransformation == null) {
            this.m_errorMsg = msg;
        } else {
            try {
                this.m_errorMsg = this.m_currentTransformation.getName() + ": " + msg;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return this;
    }

    public CodegenRequest addSectionComment(String msg) {
        return this.addSourceCode(this.getSectionComment(msg));
    }

    public StringBuffer getSectionComment(String msg) {
        StringBuffer comment = new StringBuffer();
        String marker = this.repeat(SECTION_MARKER, 4);
        int lineLength = 78 - (6 + 2 * marker.length() + this.m_indentString.length());
        List lineList = this.splitString(msg, lineLength, true);
        for (int i = 0; i < lineList.size(); ++i) {
            String line = (String)lineList.get(i);
            comment.append("/*").append(marker).append(JCL_INDENT).append(line).append(JCL_INDENT).append(marker).append("*/ \n");
        }
        return comment;
    }

    public CodegenRequest addUWCStartComment() {
        this.addSectionComment(bundle.getString("CodegenRequest.StartUWC.msg.txt")).addSourceCode("\n");
        return this;
    }

    public CodegenRequest addUWCEndComment() {
        this.addSourceCode("\n").addSectionComment(bundle.getString("CodegenRequest.EndUWC.msg.txt"));
        return this;
    }

    private void genCommentTableLine(Job job, String sourceLabel, String sourcesLabel, String targetLabel, String targetsLabel) {
        ArrayList<DataTable> sourceList = new ArrayList<DataTable>();
        ArrayList targetList = new ArrayList();
        try {
            AssociationList activityList = job.getJobActivities();
            for (int i = 0; i < activityList.size(); ++i) {
                TransformationActivity activity = (TransformationActivity)activityList.get(i);
                AssociationList stepList = activity.getSteps();
                for (int j = 0; j < stepList.size(); ++j) {
                    int k;
                    TransformationStep step = (TransformationStep)stepList.get(j);
                    List tempTableList = this.getCommentTableLists(step);
                    List tempSourceList = (List)tempTableList.get(0);
                    List tempTargetList = (List)tempTableList.get(1);
                    for (k = 0; k < tempSourceList.size(); ++k) {
                        DataTable table;
                        Object obj = tempSourceList.get(k);
                        if (!(obj instanceof DataTable) || (table = (DataTable)obj).getCMetadataType().equals("WorkTable")) continue;
                        sourceList.add(table);
                    }
                    for (k = 0; k < tempTargetList.size(); ++k) {
                        Object table = tempTargetList.get(k);
                        if (!(table instanceof PhysicalTable) || ((PhysicalTable)table).getCMetadataType().equals("WorkTable")) continue;
                        targetList.add(table);
                    }
                }
            }
        }
        catch (MdException e) {
            return;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.genCommentTableLine(sourceList, sourceLabel, sourcesLabel);
        this.genCommentTableLine(targetList, targetLabel, targetsLabel);
        if (sourceList.size() > 0 || targetList.size() > 0) {
            this.genCommentLine();
        }
    }

    private List getCommentTableLists(TransformationStep step) {
        ArrayList tableList = new ArrayList();
        ArrayList sourceList = new ArrayList();
        ArrayList targetList = new ArrayList();
        tableList.add(0, sourceList);
        tableList.add(1, targetList);
        try {
            AssociationList cmList = step.getTransformations();
            for (int i = 0; i < cmList.size(); ++i) {
                if (!(cmList.get(i) instanceof ClassifierMap)) continue;
                ClassifierMap classifierMap = (ClassifierMap)cmList.get(i);
                AssociationList sourceAL = classifierMap.getClassifierSources();
                for (int j = 0; j < sourceAL.size(); ++j) {
                    if (sourceList.contains(sourceAL.get(0))) continue;
                    sourceList.addAll(sourceAL);
                }
                AssociationList targetAL = classifierMap.getClassifierTargets();
                targetList.addAll(targetAL);
            }
        }
        catch (MdException cmList) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return tableList;
    }

    private void genCommentTableLine(List tableList, String singularLabel, String pluralLabel) {
        try {
            if (tableList.size() <= 0) {
                return;
            }
            String label = singularLabel;
            if (tableList.size() > 1) {
                label = pluralLabel;
            }
            String blankLabel = this.repeat(JCL_INDENT, label.length());
            for (int i = 0; i < tableList.size(); ++i) {
                String metadataName;
                String tableName;
                DataTableCG tableCG;
                Object obj = tableList.get(i);
                if (!(obj instanceof DataTable)) continue;
                DataTable table = (DataTable)obj;
                if (table.getCMetadataType().equals("ExternalTable")) {
                    tableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
                    tableName = tableCG.getDataLocation(this, false, false);
                    if (tableName.length() == 0) {
                        File file = ((ExternalTable)table).getOwningFile();
                        tableName = file != null ? file.getFileName() : "";
                    }
                } else if (table.getTablePackages().isEmpty()) {
                    tableName = table instanceof PhysicalTable ? ((PhysicalTable)table).getSASTableName() : table.getTableName();
                    if (!this.getGlobalData(CONTENTS_STEP).equals(GLOBAL_YES)) {
                        tableName = "work." + tableName;
                    }
                } else {
                    tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
                    tableName = ((PhysicalTableCG)tableCG).getDataLocation(this, false, false);
                }
                String name = metadataName = table.getName();
                if (tableName.length() > 0 && !tableName.equals(metadataName)) {
                    name = name + " - " + tableName;
                }
                String id = "";
                if (!table.isNewObject()) {
                    id = table.getFQID();
                }
                if (i == 0) {
                    this.genCommentLine(label, name, id);
                    continue;
                }
                this.genCommentLine(blankLabel, name, id);
            }
        }
        catch (MdException label) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void genCommentUserWrittenLine(AbstractTransformation object, String label) {
        this.genCommentUserWrittenLine(object, label, false);
    }

    private void genCommentUserWrittenLine(AbstractTransformation object, String label, boolean isUserDefined) {
        block10: {
            try {
                if (object.getIsUserDefined() != 1 && !isUserDefined) break block10;
                try {
                    Text text = object.getSourceCode();
                    if (text == null) {
                        return;
                    }
                    this.genCommentLine();
                    if (text.getCMetadataType().equals("File")) {
                        this.genCommentLine(label, ((File)text).getFileName(), "");
                    } else if (text.getCMetadataType().equals("TextStore")) {
                        this.genCommentLine(label, (CMetadata)text);
                    } else {
                        this.genCommentLine(label, "", "");
                    }
                    if (text.getDesc().length() > 0) {
                        this.genCommentLine(this.repeat(JCL_INDENT, label.length()), text.getDesc(), "");
                    }
                }
                catch (MdException text) {}
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    private void genCommentNotesLine(AbstractTransformation object, String divider) {
        try {
            AssociationList noteList = object.getNotes();
            ArrayList<String> notes = new ArrayList<String>();
            for (int i = 0; i < noteList.size(); ++i) {
                TextStore text = (TextStore)noteList.get(i);
                final StringBuffer textString = new StringBuffer();
                HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){

                    @Override
                    public void handleText(char[] data, int pos) {
                        textString.append(data);
                    }
                };
                try {
                    StringReader reader = new StringReader(text.getStoredText());
                    new ParserDelegator().parse(reader, callback, false);
                }
                catch (IOException reader) {
                    // empty catch block
                }
                List tempNotes = this.splitString(textString.toString(), 71, true);
                if (i > 0 && textString.length() > 0) {
                    notes.add(JCL_INDENT);
                }
                notes.add(text.getName());
                notes.addAll(tempNotes);
            }
            if (notes.size() > 0) {
                this.addSourceCode(" *").addSourceCode(divider).addSourceCode("\n");
                this.genCommentLine(bundle.getString("CodegenRequest.CommentLabel.Notes.txt"));
                this.genCommentLine(notes);
            }
        }
        catch (MdException noteList) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void genCommentNotActive(String divider) {
        this.addSourceCode(" *").addSourceCode(divider).addSourceCode("\n");
        this.genCommentLine();
        this.genCommentLine(bundle.getString("CodegenRequest.DoNotGenerate.msg.txt"));
        this.genCommentLine();
    }

    private void genCommentStepLines(TransformationStep step) {
        this.genCommentLine((String)this.m_commentLabelMap.get(STEP_KEY), (CMetadata)step);
        try {
            StringBuffer transformName = new StringBuffer();
            AssociationList transforms = step.getTransformations();
            TransformInterface tranInt = CodeGenUtil.getPluginInterface((CMetadata)step);
            if (tranInt != null) {
                transformName.append(tranInt.getName());
            } else if (transforms.size() > 1 || transforms.size() == 0) {
                transformName.append(step.getTransformRole().replaceAll(HIDE_KEYWORD, ""));
            } else {
                Transformation transform = (Transformation)transforms.get(0);
                transformName.append(transform.getName());
            }
            if (transformName.length() <= 0) {
                return;
            }
            if (tranInt != null && tranInt instanceof TransformVersionInterface) {
                transformName.append(" (").append(bundle.getString("CodegenRequest.Version.txt")).append(JCL_INDENT).append(((TransformVersionInterface)tranInt).getVersionNumber()).append(")");
            }
            this.genCommentLine((String)this.m_commentLabelMap.get(TRANSFORM_KEY), transformName.toString(), "");
        }
        catch (MdException transformName) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void genCommentLine() {
        this.genCommentLine("", "", "");
    }

    private void genCommentLine(String label, CMetadata object) {
        if (object == null) {
            return;
        }
        try {
            if (object.isNewObject()) {
                this.genCommentLine(label, object.getName(), "");
            } else {
                this.genCommentLine(label, object.getName(), object.getFQID());
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void genCommentLine(String label, String name, String ID) {
        this.addSourceCode(this.m_SASCodeGen.getCommentLine(label, name, ID));
    }

    private void genCommentLine(String line) {
        List lines = this.splitString(line, 72, false);
        this.genCommentLine(lines);
    }

    private void genCommentLine(List lines) {
        for (int i = 0; i < lines.size(); ++i) {
            String singleLine = (String)lines.get(i);
            int pad = 78 - (6 + singleLine.length());
            String blanks = this.repeat(JCL_INDENT, pad);
            this.addSourceCode(" * ").addSourceCode(singleLine).addSourceCode(blanks).addSourceCode(" * \n");
        }
    }

    private void createCommentLabelMap() {
        this.m_commentLabelMap = new HashMap();
        this.m_commentLabelMap.put(JOB_KEY, bundle.getString("CodegenRequest.CommentLabel.Job.txt"));
        this.m_commentLabelMap.put(REPOS_KEY, bundle.getString("CodegenRequest.CommentLabel.Repository.txt"));
        this.m_commentLabelMap.put(VERSION_KEY, bundle.getString("CodegenRequest.CommentLabel.Version.txt"));
        this.m_commentLabelMap.put(SERVER_KEY, bundle.getString("CodegenRequest.CommentLabel.Server.txt"));
        this.m_commentLabelMap.put(GEN_ON_KEY, bundle.getString("CodegenRequest.CommentLabel.GeneratedOn.txt"));
        this.m_commentLabelMap.put(GEN_BY_KEY, bundle.getString("CodegenRequest.CommentLabel.GeneratedBy.txt"));
        this.m_commentLabelMap.put(ERROR_TYPE_KEY, bundle.getString("CodegenRequest.CommentLabel.ErrorType.txt"));
        this.m_commentLabelMap.put(STEP_KEY, bundle.getString("CodegenRequest.CommentLabel.Step.txt"));
        this.m_commentLabelMap.put(TRANSFORM_KEY, bundle.getString("CodegenRequest.CommentLabel.Transform.txt"));
        this.m_commentLabelMap.put(DESC_KEY, bundle.getString("CodegenRequest.CommentLabel.Description.txt"));
        this.m_commentLabelMap.put(USER_KEY, bundle.getString("CodegenRequest.CommentLabel.UserWritten.txt"));
        this.m_commentLabelMap.put(SOURCE_KEY, bundle.getString("CodegenRequest.CommentLabel.SourceTable.txt"));
        this.m_commentLabelMap.put(SOURCES_KEY, bundle.getString("CodegenRequest.CommentLabel.SourceTables.txt"));
        this.m_commentLabelMap.put(TARGET_KEY, bundle.getString("CodegenRequest.CommentLabel.TargetTable.txt"));
        this.m_commentLabelMap.put(TARGETS_KEY, bundle.getString("CodegenRequest.CommentLabel.TargetTables.txt"));
        Collection valueCollection = this.m_commentLabelMap.values();
        List values = new ArrayList();
        values.addAll(valueCollection);
        values = this.padStrings(values);
        Set keySet = this.m_commentLabelMap.keySet();
        Iterator iterator = keySet.iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.m_commentLabelMap.put(key, values.get(counter));
            ++counter;
        }
    }

    public CodegenRequest indent() {
        return this.indent(1);
    }

    public CodegenRequest indent(int numIndents) {
        this.addSourceCode(INDENT);
        numIndents = this.m_numIndents + numIndents;
        this.setIndent(numIndents);
        return this;
    }

    public CodegenRequest setIndent(int numIndents) {
        this.m_numIndents = numIndents;
        StringBuffer indents = new StringBuffer();
        for (int i = 0; i < this.m_numIndents; ++i) {
            indents.append(INDENT);
        }
        if (this.m_JCLCode) {
            indents.append(JCL_INDENT);
        }
        this.m_indentString = indents.toString();
        return this;
    }

    public CodegenRequest unIndent() {
        return this.unIndent(1);
    }

    public CodegenRequest unIndent(int numIndents) {
        String temp;
        if ((numIndents = this.m_numIndents - numIndents) < 0) {
            numIndents = 0;
        }
        this.setIndent(numIndents);
        int length = this.m_GeneratedSource.length();
        if (length > INDENT.length() && (temp = this.m_GeneratedSource.substring(length - INDENT.length())).equals(INDENT)) {
            this.m_GeneratedSource.delete(length - INDENT.length(), length);
        }
        return this;
    }

    private String repeat(String repeatString, int numRepeats) {
        return this.m_SASCodeGen.repeat(repeatString, numRepeats);
    }

    public List splitString(String string, int lineLength, boolean pad) {
        return this.m_SASCodeGen.splitString(string, lineLength, pad);
    }

    public String splitString(String string, int lineLength, boolean pad, String spacesToIndentNextLines, boolean quoteEachLine) {
        return this.m_SASCodeGen.splitString(string, lineLength, pad, spacesToIndentNextLines, quoteEachLine);
    }

    private List padStrings(List list) {
        return this.m_SASCodeGen.padStrings(list);
    }

    public CodegenRequest genGetNumRows(String tableName) {
        return this.genGetNumRows(tableName, "etls_numRows", true);
    }

    public CodegenRequest genGetNumRows(String tableName, String macroVariable) {
        return this.genGetNumRows(tableName, macroVariable, true);
    }

    public CodegenRequest genGetNumRows(String tableName, boolean hasDeletedRows) {
        return this.genGetNumRows(tableName, "etls_numRows", hasDeletedRows);
    }

    public CodegenRequest genGetNumRows(String tableName, String macroVariable, boolean hasDeletedRows) {
        return this.genGetNumRows(tableName, macroVariable, hasDeletedRows, GLOBAL_ALL);
    }

    public CodegenRequest genGetNumRows(String tableName, String macroVariable, boolean hasDeletedRows, String maxRowsToCount) {
        return this.genGetNumRows(tableName, macroVariable, hasDeletedRows, maxRowsToCount, "");
    }

    public CodegenRequest genGetNumRows(String tableName, String macroVariable, boolean hasDeletedRows, String maxRowsToCount, String whereClause) {
        this.addSourceCode("%let ").addSourceCode(macroVariable).addSourceCode(" = 0; \n");
        this.addSourceCode("%macro etls_recordCheck; \n").indent();
        this.genTableExist(tableName, DATA_AND_VIEW_TYPE, "etls_recCheckExist");
        this.addSourceCode("%if (&etls_recCheckExist) %then\n");
        this.addSourceCode("%do;\n");
        this.indent();
        this.genNoSyntaxCheck().addSourceCode("\n");
        if (!whereClause.equals("")) {
            whereClause = " where=(" + whereClause + ")";
        }
        if (!maxRowsToCount.equals(GLOBAL_ALL)) {
            this.addSourceCode("data _null_; \n").indent();
            if (maxRowsToCount.equals("1")) {
                this.addSourceCode("set ").addSourceCode(tableName).addSourceCode("(").addSourceCode(whereClause).addSourceCode(" obs=1 ); \n").addSourceCode("call symput(\"").addSourceCode(macroVariable).addSourceCode("\",'1'); \n");
            } else {
                this.addSourceCode("do until(_ptr=").addSourceCode(maxRowsToCount).addSourceCode(" or _eof); \n").indent().addSourceCode("set ").addSourceCode(tableName).addSourceCode("(").addSourceCode(whereClause).addSourceCode(")").addSourceCode(" end = _eof; \n").addSourceCode("etls_ptr+1; \n").unIndent().addSourceCode("end; \n").addSourceCode("call symput(\"").addSourceCode(macroVariable).addSourceCode("\",trim(left(put(etls_ptr,16.))) ); \n").addSourceCode("stop; \n");
            }
            this.unIndent().addSourceCode("run; \n");
        } else if (hasDeletedRows) {
            this.addSourceCode("proc contents data = ").addSourceCode(tableName).addSourceCode(" out = ").addSourceCode(WORK_LIBREF).addSourceCode(".etls_contents(keep = nobs) noprint; \n").addSourceCode("run; \n\n").addSourceCode("data _null_; \n").indent().addSourceCode("set ").addSourceCode(WORK_LIBREF).addSourceCode(".etls_contents (obs = 1); \n").addSourceCode("call symput(\"").addSourceCode(macroVariable).addSourceCode("\", left(put(nobs,32.))); \n").unIndent().addSourceCode("run;\n\n").genTableDelete("work.etls_contents");
        } else {
            this.addSourceCode("data _null_; \n\n").indent().addSourceCode("call symput(\"").addSourceCode(macroVariable).addSourceCode("\", left(put(nobs,32.))); \n").addSourceCode("stop; \n").addSourceCode("set ").addSourceCode(tableName).addSourceCode(" nobs = nobs;\n\n").unIndent().addSourceCode("run; \n");
        }
        this.genResetSyntaxCheck();
        this.unIndent();
        this.addSourceCode("%end;\n");
        this.unIndent();
        this.addSourceCode("%mend etls_recordCheck;\n");
        this.addSourceCode("%etls_recordCheck;\n\n");
        return this;
    }

    public CodegenRequest genNoSyntaxCheck() {
        return this.addSourceCode(this.m_SASCodeGen.getNoSyntaxCheck());
    }

    public CodegenRequest genResetSyntaxCheck() {
        return this.addSourceCode(this.m_SASCodeGen.getResetSyntaxCheck());
    }

    public CodegenRequest genGetParameterNamesMacro() {
        this.addSourceCode("%macro etls_getParameterNames(parameterTable=, parameterVariableMacro=, startingColumnNumber=1);\n").indent().addSourceCode("%let &parameterVariableMacro = ;\n").addSourceCode("%let dsid = %sysfunc(open(&parameterTable));\n").addSourceCode("%if (&dsid gt 0) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%do i=&startingColumnNumber %to %sysfunc(attrn(&dsid,nvars)); \n").indent().addSourceCode("%let &parameterVariableMacro = &&&parameterVariableMacro %sysfunc(varname(&dsid,&i)); \n").unIndent().addSourceCode("%end; \n").addSourceCode("%let dsid = %sysfunc(close(&dsid)); \n").unIndent().addSourceCode("%end; \n").addSourceCode("%else \n").indent().addSourceCode("%put %sysfunc(sysmsg()); \n").unIndent().genRCSetCall("&syserr", false).unIndent().addSourceCode("%mend etls_getParameterNames; \n\n");
        return this;
    }

    public CodegenRequest genGetParametersMacro() {
        this.addSourceCode("%macro etls_getParameters(parameterTable=, row=, startingColumnNumber=1 ").addSourceCode(", handleName=");
        this.addSourceCode("); \n").indent().addSourceCode("data _null_; \n").indent().addSourceCode("length vname $256 vtype $1 value $3200; \n").addSourceCode("dsid = open(\"&parameterTable\"); \n").addSourceCode("if (dsid > 0) then \n").addSourceCode("do; \n").indent().addSourceCode("do _i = 1 to &row; \n").indent().addSourceCode("fetchrc = fetch(dsid); \n").unIndent().addSourceCode("end; \n").addSourceCode("do _i=&startingColumnNumber to attrn(dsid,'nvars'); \n").indent().addSourceCode("vname = varname(dsid,_i); \n").addSourceCode("vtype = vartype(dsid,_i); \n").addSourceCode("if (fetchrc = 0) then \n").addSourceCode("do; \n").indent().addSourceCode("if (vtype = 'C') then \n").addSourceCode("do; \n").indent().addSourceCode("value = getvarc(dsid,_i); \n").addSourceCode("value = tranwrd(value,\"%\",\"%%\"); \n").addSourceCode("value = tranwrd(value,\"(\",\"%(\"); \n").addSourceCode("value = tranwrd(value,\")\",\"%)\"); \n").addSourceCode("value = tranwrd(value,'\"','%\"'); \n").unIndent().addSourceCode("end; \n").addSourceCode("else \n").indent().addSourceCode("value = left(put(getvarn(dsid,_i),best32.)); \n").unIndent().unIndent().addSourceCode("end; /* fetchrc = 0 */ \n");
        this.addSourceCode("\nput ;\n").addSourceCode("if indexc(trimn(value),\"+-*/<>=^~;, '()&%\",'\"')>0 then \n").addSourceCode("do; \n").indent().addSourceCode("value='%nrstr('||trim(value)||')'; \n").addSourceCode("put \"").addSourceCode(NOTE_LABEL).addSourceCode(JCL_INDENT).addSourceCode(bundle.getString("CodegenRequest.GetParametersMacro.SpecialCharacters.txt")).addSourceCode(" %nrbquote(%)UNQUOTE(&\" vname+(-1)').';\n").unIndent().addSourceCode("end; \n");
        this.addSourceCode("%if %str(&handlename) ne %str() %then \n").addSourceCode("%do; \n").indent().addSourceCode("value = '%syslput '||trim(vname)||'= '||trim(value)||\" / remote = &handleName;\"; \n").unIndent().addSourceCode("%end; \n").addSourceCode("%else \n").addSourceCode("%do; \n").indent().addSourceCode("value = '%let '||trim(vname)||'= '||trim(value)||';'; \n").unIndent().addSourceCode("%end; \n");
        this.addSourceCode("\nput \"").addSourceCode(NOTE_LABEL).addSourceCode(JCL_INDENT).addSourceCode(bundle.formatString("CodegenRequest.GetParametersMacro.DebugMacro.txt", (Object)"vname", (Object)"\"")).addSourceCode("\" value ;\n").addSourceCode("call execute(value); \n").unIndent().addSourceCode("end; /* do i= */ \n").addSourceCode("dsid = close(dsid); \n").unIndent().addSourceCode("end; /* dsid > 0 */ \n").addSourceCode("else \n").addSourceCode("do; \n").indent().genPutStatement(bundle.formatString("CodegenRequest.GetParametersMacro.ParameterTableDoesNotExist.txt", (Object)"&parameterTable"), ERROR_LABEL, true).addSourceCode("abort; \n").unIndent().addSourceCode("end; \n").addSourceCode("stop; \n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr", false).unIndent().addSourceCode("%mend etls_getParameters; \n\n");
        return this;
    }

    public CodegenRequest genGetNumRows(PhysicalTable table, String macroVariable) throws MdException, RemoteException {
        return this.genGetNumRows(table, macroVariable, GLOBAL_ALL, "");
    }

    public CodegenRequest genGetNumRows(PhysicalTable table, String macroVariable, String maxRowsToCount) throws MdException, RemoteException {
        return this.genGetNumRows(table, macroVariable, maxRowsToCount, "");
    }

    public CodegenRequest genGetNumRows(PhysicalTable table, String macroVariable, String maxRowsToCount, String whereClause) throws MdException, RemoteException {
        PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        String tableName = tableCG.getDataLocation(this, false, true);
        String libRef = PhysicalTableCG.getLibref(tableName);
        tableName = PhysicalTableCG.getTableName(tableName);
        String vvnOption = "";
        boolean needQuotes = DBMSNamesPropertyHandler.needQuotes((DataTable)table);
        if (needQuotes) {
            if (!this.getQuoting()) {
                tableName = DBMSNamesUtil.getQuotedString((String)tableName, (boolean)false);
            }
            if (!(vvnOption = this.getGlobalData(VALID_VARNAME)).equals(GLOBAL_ANY)) {
                this.addSourceCode("%let etls_vvnOption = %sysfunc(getOption(VALIDVARNAME)); \n").addSourceCode("options validVarname = ANY; \n\n");
            }
        }
        tableName = libRef + "." + tableName;
        if (!maxRowsToCount.equals(GLOBAL_ALL)) {
            this.genGetNumRows(tableName, macroVariable, false, maxRowsToCount, whereClause);
        } else if (table.getCMetadataType().equals("PhysicalTable")) {
            Loader tempLoader = new Loader(this, table);
            tempLoader.getDBMSSTORE().genGetNumRows(this, tableName, macroVariable);
        } else if (table.getCMetadataType().equals("WorkTable")) {
            this.genGetNumRows(tableName, macroVariable, false, maxRowsToCount, whereClause);
        }
        if (needQuotes && !vvnOption.equals(GLOBAL_ANY)) {
            this.addSourceCode("options validVarname = &etls_vvnOption;\n");
        }
        return this;
    }

    public CodegenRequest genGetColumnExists(DataTable table, Column lookupColumn, String dsidMacroVariable, String lookupVarNumberMacroVariable) throws MdException, RemoteException {
        String columnName = lookupColumn.getSASColumnName();
        String unquotedColumnName = columnName.replaceAll("\"", "\"\"");
        DataTableCG lookupTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        String tableName = lookupTableCG.getDataLocation(this, false, false);
        String unquotedTableName = tableName.replaceAll("\"", "\"\"");
        this.addSourceCode("data _null_; \n\n").indent().addSourceCode("dsid = open(\"" + unquotedTableName + "\"); \n").addSourceCode("call symput(\"").addSourceCode(dsidMacroVariable).addSourceCode("\", compress(put(dsid, 10.))); \n\n").addSourceCode("if (dsid gt 0) then \n").addSourceCode("do; \n").indent().addSourceCode("varnum = varnum(dsid, \"").addSourceCode(unquotedColumnName).addSourceCode("\"); \n").addSourceCode("call symput(\"").addSourceCode(lookupVarNumberMacroVariable).addSourceCode("\", compress(put(varnum, 10.))); \n").addSourceCode("dsid = close(dsid); \n").unIndent().addSourceCode("end; \n\n").unIndent().addSourceCode("run; \n\n");
        return this;
    }

    public CodegenRequest genTableExist(String tableName, String typeOfTable, String macroVariable) {
        String macroVarTrim = macroVariable.trim();
        if (typeOfTable.equals(DATA_AND_VIEW_TYPE)) {
            this.addSourceCode("%let ").addSourceCode(macroVarTrim).addSourceCode(" = %eval(%sysfunc(exist(").addSourceCode(tableName).addSourceCode(", ").addSourceCode(DATA_TYPE).addSourceCode(")) or \n ").addSourceCode("     ").addSourceCode("%sysfunc(exist(").addSourceCode(tableName).addSourceCode(", ").addSourceCode(VIEW_TYPE).addSourceCode("))); \n\n");
        } else {
            this.addSourceCode("%let ").addSourceCode(macroVarTrim).addSourceCode(" = %sysfunc(exist(").addSourceCode(tableName).addSourceCode(", ").addSourceCode(typeOfTable).addSourceCode("));\n\n");
        }
        return this;
    }

    public CodegenRequest genGetDate(String macroVariable, String format) {
        this.addSourceCode("%let ").addSourceCode(macroVariable).addSourceCode(" = %sysfunc(date()");
        if (format.length() > 0) {
            this.addSourceCode(", ").addSourceCode(format);
        }
        this.addSourceCode("); \n\n");
        return this;
    }

    public CodegenRequest genGetDateTime(String macroVariable, String format) {
        this.addSourceCode("%let ").addSourceCode(macroVariable).addSourceCode(" = %sysfunc(datetime()");
        if (format.length() > 0) {
            this.addSourceCode(", ").addSourceCode(format);
        }
        this.addSourceCode("); \n\n");
        return this;
    }

    public String makeColumnList(List columnList, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias) throws MdException, RemoteException {
        return this.m_SASCodeGen.makeColumnList(columnList, oneColumnPerLine, spacesToIndentNextLines, passthru, delimiter, tableAlias, this.getQuoting(), this.m_indentString);
    }

    public String makeColumnList(List columnList, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias, boolean groupBy, boolean orderBy) throws MdException, RemoteException {
        return this.m_SASCodeGen.makeColumnList(columnList, oneColumnPerLine, spacesToIndentNextLines, passthru, delimiter, tableAlias, this.getQuoting(), this.m_indentString, groupBy, orderBy);
    }

    public String makeColumnList(DataTable table, String spacesToIndentNextLines) throws MdException, RemoteException {
        return this.m_SASCodeGen.makeColumnList(table, spacesToIndentNextLines, this.getQuoting(), this.m_indentString);
    }

    public String makeColumnList(DataTable table, boolean oneColumnPerLine, String spacesToIndentNextLines, boolean passthru, String delimiter, String tableAlias) throws MdException, RemoteException {
        return this.m_SASCodeGen.makeColumnList(table, oneColumnPerLine, spacesToIndentNextLines, passthru, delimiter, tableAlias, this.getQuoting(), this.m_indentString);
    }

    public String makeColumnList(List columnList, String spacesToIndentNextLines) throws MdException, RemoteException {
        return this.makeColumnList(columnList, false, spacesToIndentNextLines, false, JCL_INDENT, "");
    }

    public String makeByStatement(Select select) throws MdException, RemoteException {
        OrderByClause orderBy = select.getOrderByForSelect();
        if (orderBy == null) {
            return null;
        }
        AssociationList columnList = orderBy.getColumns();
        if (columnList.size() <= 0) {
            return null;
        }
        String spacesToIndentNextLines = INDENT;
        StringBuffer byString = new StringBuffer("by");
        int currentLineLength = spacesToIndentNextLines.length() + this.m_indentString.length();
        for (int i = 0; i < columnList.size(); ++i) {
            Column column = (Column)columnList.get(i);
            ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)column);
            String columnName = columnCG.getColumnName(this);
            String sortOrder = column.getSortOrder();
            sortOrder = !sortOrder.equalsIgnoreCase("DESCENDING") ? "" : sortOrder.toLowerCase() + JCL_INDENT;
            if (currentLineLength + columnName.length() + sortOrder.length() > 78) {
                byString.append("\n").append(spacesToIndentNextLines);
                currentLineLength = spacesToIndentNextLines.length() + this.m_indentString.length();
            }
            currentLineLength += columnName.length() + sortOrder.length() + 1;
            byString.append(JCL_INDENT).append(sortOrder).append(columnName);
        }
        return byString.toString();
    }

    public DataTable getSourceTable(ClassifierMap classifierMap) throws MdException, RemoteException {
        AssociationList sourceList = classifierMap.getClassifierSources();
        if (sourceList.size() <= 0) {
            throw new CodegenException(bundle.getString("PROCESS.NoInputs.msg.txt"));
        }
        Object obj = sourceList.get(0);
        if (obj instanceof DataTable) {
            return (DataTable)obj;
        }
        return null;
    }

    public DataTable getTargetTable(ClassifierMap classifierMap) throws MdException, RemoteException {
        AssociationList targetList = classifierMap.getClassifierTargets();
        if (targetList.size() <= 0) {
            throw new CodegenException(bundle.getString("PROCESS.NoOutputs.msg.txt"));
        }
        Object obj = targetList.get(0);
        if (obj instanceof DataTable) {
            return (DataTable)obj;
        }
        return null;
    }

    public ExternalTable getTargetExternalTable(ClassifierMap classifierMap) throws MdException, RemoteException {
        AssociationList targetList = classifierMap.getClassifierTargets();
        if (targetList.size() <= 0) {
            throw new CodegenException(bundle.getString("PROCESS.NoOutputs.msg.txt"));
        }
        Object obj = targetList.get(0);
        if (!(obj instanceof DataTable)) {
            throw new CodegenException(bundle.getString("PROCESS.NoPhysicalTableTarget.msg.txt"));
        }
        DataTable table = (DataTable)obj;
        if (!(table instanceof ExternalTable)) {
            throw new CodegenException(bundle.getString("PROCESS.NoPhysicalTableTarget.msg.txt"));
        }
        ExternalTable targetTable = (ExternalTable)table;
        return targetTable;
    }

    public DataTableCG getTableCG(DataTable table) throws MdException, RemoteException {
        if (table == null) {
            return null;
        }
        DataTableCG tableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        return tableCG;
    }

    public DataTableCG getTargetTableCG(ClassifierMap classifierMap) throws MdException, RemoteException {
        DataTable table = this.getTargetTable(classifierMap);
        return this.getTableCG(table);
    }

    public DataTableCG getSourceTableCG(ClassifierMap classifierMap) throws MdException, RemoteException {
        DataTable table = this.getSourceTable(classifierMap);
        return this.getTableCG(table);
    }

    public void checkSourceAndTarget(ClassifierMap classifierMap) throws MdException, RemoteException {
        if (classifierMap == null) {
            throw new CodegenException(bundle.getString("PROCESS.NoClassifierMap.msg.txt"));
        }
        AssociationList sourceList = classifierMap.getClassifierSources();
        if (sourceList.size() <= 0) {
            throw new CodegenException(bundle.getString("PROCESS.NoInputs.msg.txt"));
        }
        AssociationList targetList = classifierMap.getClassifierTargets();
        if (targetList.size() <= 0) {
            throw new CodegenException(bundle.getString("PROCESS.NoOutputs.msg.txt"));
        }
    }

    public void checkTargetsForSPDSTable(ClassifierMap classifierMap) throws MdException, RemoteException {
        PhysicalTable table;
        String DBMSName;
        if (classifierMap == null) {
            throw new CodegenException(bundle.getString("PROCESS.NoClassifierMap.msg.txt"));
        }
        AssociationList targetList = classifierMap.getClassifierTargets();
        Object obj = targetList.get(0);
        if (obj instanceof DataTable && !"SASSPDS".equals(DBMSName = TransformUtil.getDBMSProductName((PhysicalTable)(table = (PhysicalTable)targetList.get(0))))) {
            throw new CodegenException(bundle.getString("PROCESS.NoSPDSTableTarget.msg.txt"));
        }
    }

    public void checkTargetsForExternalTable(ClassifierMap classifierMap) throws MdException, RemoteException {
        if (classifierMap == null) {
            throw new CodegenException(bundle.getString("PROCESS.NoClassifierMap.msg.txt"));
        }
        AssociationList targetList = classifierMap.getClassifierTargets();
        for (int i = 0; i < targetList.size(); ++i) {
            DataTable table;
            Object obj = targetList.get(0);
            if (!(obj instanceof DataTable) || !((table = (DataTable)targetList.get(i)) instanceof ExternalTable)) continue;
            throw new CodegenException(bundle.getString("PROCESS.NoExternalTableTarget.msg.txt"));
        }
    }

    public void checkSourcesForExternalTable(ClassifierMap classifierMap) throws MdException, RemoteException {
        if (classifierMap == null) {
            throw new CodegenException(bundle.getString("PROCESS.NoClassifierMap.msg.txt"));
        }
        AssociationList sourceList = classifierMap.getClassifierSources();
        for (int i = 0; i < sourceList.size(); ++i) {
            DataTableCG tableCG;
            String tableName;
            DataTable table;
            Object obj = sourceList.get(i);
            if (!(obj instanceof DataTable) || !((table = (DataTable)obj) instanceof ExternalTable) || (tableName = (tableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table)).getDataLocation(this)).length() != 0 || EFIDataModel.isLegacyEFIObject((ExternalTable)((ExternalTable)table))) continue;
            throw new CodegenException(bundle.getString("PROCESS.NoExternalTableSource.msg.txt"));
        }
    }

    public String getDefaultIndent() {
        return INDENT;
    }

    public String getCurrentIndent() {
        return this.m_indentString;
    }

    public CodegenRequest genRCSetCall(String errorVariable) {
        return this.genRCSetCall(errorVariable, true);
    }

    public boolean getGenerateRCSetCalls() {
        return this.m_SASCodeGen.getGenerateRCSetCalls();
    }

    public void setGenerateRCSetCalls(boolean gen) {
        this.m_SASCodeGen.setGenerateRCSetCalls(gen);
    }

    public CodegenRequest genRCSetCall(String errorVariable, boolean addBlankLine) {
        this.addSourceCode(this.m_SASCodeGen.getRCSetCall(errorVariable, addBlankLine));
        return this;
    }

    public CodegenRequest genRCSetDSCall(String errorVariable, boolean addBlankLine) {
        this.addSourceCode(this.m_SASCodeGen.getRCSetDSCall(errorVariable, addBlankLine));
        return this;
    }

    public CodegenRequest genReturnCodeSetup() {
        this.addSourceCode(this.m_SASCodeGen.getReturnCodeSetup());
        return this;
    }

    public CodegenRequest genReturnCodeMacro() {
        this.addSourceCode(this.m_SASCodeGen.getRCSetMacro());
        return this;
    }

    public CodegenRequest genReturnCodeRemoteSetup(String remoteName) {
        return this.addSourceCode(this.m_SASCodeGen.getReturnCodeRemoteSetup(remoteName));
    }

    public CodegenRequest genReturnCodeRemoteEnding() {
        return this.addSourceCode(this.m_SASCodeGen.getReturnCodeRemoteEnding());
    }

    public void addRemoteMacroVariables(List parameterList) {
        for (int i = 0; i < parameterList.size(); ++i) {
            this.addRemoteMacroVariable(((PromptDefinitionInterface)parameterList.get(i)).getPromptName());
        }
    }

    public void addRemoteMacroVariable(String macro) {
        this.addRemoteMacroVariable(macro, macro);
    }

    public void addRemoteMacroVariable(String macroKey, String macroName) {
        this.m_remoteMacroVariables.put(macroKey.toUpperCase(), macroName);
    }

    public void clearRemoteMacroVariables() {
        this.m_remoteMacroVariables.clear();
    }

    public CodegenRequest genRemoteMacroVariablesSetup(String remoteName) {
        this.genRemoteMacroVariablesSetup(remoteName, false);
        return this;
    }

    public CodegenRequest genRemoteMacroVariablesSetup(String remoteName, boolean blankLine) {
        this.addSourceCode(this.m_SASCodeGen.getRemoteMacroVariablesSetup(new ArrayList(this.m_remoteMacroVariables.values()), remoteName, blankLine));
        return this;
    }

    public StringBuffer getRemoteMacroVariablesSetup(String remoteName, boolean blankLine) {
        return this.m_SASCodeGen.getRemoteMacroVariablesSetup(new ArrayList(this.m_remoteMacroVariables.values()), remoteName, blankLine);
    }

    public List getRemoteMacroVariables() {
        return new ArrayList(this.m_remoteMacroVariables.values());
    }

    public HashMap getRemoteMacroVariablesMap() {
        return this.m_remoteMacroVariables;
    }

    public CodegenRequest genSascmdOption() {
        this.addSourceCode(this.m_SASCodeGen.getSascmdOption());
        return this;
    }

    public CodegenRequest genParallelMacros(ServerContext server, boolean generateCommentHeaders) {
        if (!this.getParallelMacroStatus(server)) {
            this.setGenerateCommentHeaderOnParallelMacros(generateCommentHeaders);
            this.addSourceCode(this.m_SASCodeGen.getParallelMacros(this.m_host));
            this.m_mapGeneratedParallelMacros.put(server, server);
        }
        return this;
    }

    public CodegenRequest genSignonMacro() {
        this.addSourceCode(this.m_SASCodeGen.getSignonMacro(this.m_host));
        return this;
    }

    public CodegenRequest genSignoffMacro() {
        this.addSourceCode(this.m_SASCodeGen.getSignoffMacro());
        return this;
    }

    public CodegenRequest genParallelGetHandleMacro() {
        this.addSourceCode(this.m_SASCodeGen.getParallelGetHandleMacro());
        return this;
    }

    public CodegenRequest genParallelFreeHandleMacro() {
        this.addSourceCode(this.m_SASCodeGen.getParallelFreeHandleMacro());
        return this;
    }

    public CodegenRequest genParallelCreateHandleMacro() {
        this.addSourceCode(this.m_SASCodeGen.getParallelCreateHandleMacro());
        return this;
    }

    public CodegenRequest genParallelServerConnectedMacro() {
        this.addSourceCode(this.m_SASCodeGen.getParallelServerConnectedMacro());
        return this;
    }

    public CodegenRequest genParallelWaitForMacro() {
        this.addSourceCode(this.m_SASCodeGen.getParallelWaitForMacro());
        return this;
    }

    public CodegenRequest genTableDelete(DataTable table) throws MdException, RemoteException {
        if (table == null) {
            return this;
        }
        DataTableCG iTabCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        String tabName = iTabCG.getDataLocation(this);
        if ((tabName == null || tabName.length() == 0) && table instanceof ExternalTable) {
            throw new CodegenException(bundle.getString("PROCESS.ExternalTableNotValid.msg.txt"));
        }
        this.genTableDelete(tabName);
        return this;
    }

    public CodegenRequest genTableDelete(String tableName) {
        String lib = PhysicalTableCG.getLibref(tableName);
        if (lib.length() <= 0) {
            lib = WORK_LIBREF;
        }
        String dsName = PhysicalTableCG.getTableName(tableName);
        this.addSourceCode("proc datasets lib = ").addSourceCode(lib).addSourceCode(" nolist nowarn memtype = (data view);\n");
        this.indent();
        this.addSourceCode("delete ").addSourceCode(dsName).addSourceCode(";\n");
        this.unIndent();
        this.addSourceCode("quit;\n\n");
        return this;
    }

    public CodegenRequest genTableDelete(String tableName, String tableType) {
        String lib = PhysicalTableCG.getLibref(tableName);
        if (lib.length() <= 0) {
            lib = WORK_LIBREF;
        }
        String dsName = PhysicalTableCG.getTableName(tableName);
        this.addSourceCode("proc datasets lib=").addSourceCode(lib).addSourceCode(" nolist nowarn memtype = ").addSourceCode(tableType).addSourceCode(";\n");
        this.indent();
        this.addSourceCode("delete ").addSourceCode(dsName).addSourceCode(";\n");
        this.unIndent();
        this.addSourceCode("quit;\n\n");
        return this;
    }

    public CodegenRequest genTableDelete(List tableList) throws MdException, RemoteException {
        if (tableList == null || tableList.size() <= 0) {
            return this;
        }
        ArrayList tables = new ArrayList(tableList);
        while (tables.size() > 0) {
            int i;
            ArrayList<String> sameLibTables = new ArrayList<String>();
            String lib = "";
            boolean firstRec = true;
            for (i = 0; i < tables.size(); ++i) {
                Object obj = tables.get(i);
                String tableName = "";
                if (obj instanceof String) {
                    tableName = (String)obj;
                } else if (obj instanceof DataTable) {
                    DataTable table = (DataTable)obj;
                    DataTableCG tableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
                    tableName = tableCG.getDataLocation(this);
                    if (tableName.length() == 0 && table instanceof ExternalTable) {
                        throw new CodegenException(bundle.getString("PROCESS.ExternalTableNotValid.msg.txt"));
                    }
                } else {
                    tables.remove(i);
                    --i;
                    continue;
                }
                String libref = PhysicalTableCG.getLibref(tableName);
                if (libref.length() <= 0) {
                    libref = WORK_LIBREF;
                }
                if (firstRec) {
                    lib = libref;
                    sameLibTables.add(tableName);
                    tables.remove(i);
                    --i;
                    firstRec = false;
                    continue;
                }
                if (!lib.equalsIgnoreCase(libref)) continue;
                sameLibTables.add(tableName);
                tables.remove(i);
                --i;
            }
            this.addSourceCode("proc datasets lib=").addSourceCode(lib).addSourceCode(" nolist nowarn memtype = (data view);\n");
            this.indent();
            for (i = 0; i < sameLibTables.size(); ++i) {
                String tableName = (String)sameLibTables.get(i);
                String dsName = PhysicalTableCG.getTableName(tableName);
                this.addSourceCode("delete ").addSourceCode(dsName).addSourceCode(";\n");
            }
            this.unIndent();
            this.addSourceCode("quit;\n\n");
        }
        return this;
    }

    public CodegenRequest genPutStatement(String msg) {
        this.genPutStatement(msg, NOTE_LABEL);
        return this;
    }

    public CodegenRequest genPutStatement(String msg, String label) {
        this.genPutStatement(msg, label, false);
        return this;
    }

    public CodegenRequest genPutStatement(String msg, String label, boolean splitLabel) {
        this.genPutStatement(msg, label, "", splitLabel);
        return this;
    }

    public CodegenRequest genPutStatement(String msg, String label, String sasvar, boolean splitLabel) {
        this.addSourceCode(this.m_SASCodeGen.getPutStatement(msg, label, sasvar, splitLabel));
        return this;
    }

    public CodegenRequest genPercentPutStatement(String msg) {
        return this.genPercentPutStatement(msg, NOTE_LABEL);
    }

    public CodegenRequest genPercentPutStatement(String msg, String label) {
        return this.genPercentPutStatement(msg, label, true);
    }

    public CodegenRequest genPercentPutStatement(String msg, String label, boolean usePercentStr) {
        return this.addSourceCode(this.m_SASCodeGen.getPercentPutStatement(msg, label, usePercentStr));
    }

    public CodegenRequest genSystemOptions(AbstractTransformation trans) throws MdException, RemoteException {
        return this.genAdditionalSystemOptions(trans, SYSTEM_OPTIONS);
    }

    public CodegenRequest genSystemOptions(AbstractTransformation trans, String propertyName) throws MdException, RemoteException {
        return this.genAdditionalSystemOptions(trans, propertyName);
    }

    public CodegenRequest genSystemOptions(String systemOptions) throws MdException, RemoteException {
        if (systemOptions.length() > 0) {
            this.addCommentLine(bundle.getString("CodegenRequest.SystemOptions.msg.txt"));
            this.addSourceCode("options ").addSourceCode(systemOptions).addSourceCode("; \n\n");
        }
        return this;
    }

    public CodegenRequest genAdditionalSystemOptions(AbstractTransformation trans) throws MdException, RemoteException {
        return this.genAdditionalSystemOptions(trans, SYSTEM_OPTIONS);
    }

    public CodegenRequest genAdditionalSystemOptions(AbstractTransformation trans, String propertyName) throws MdException, RemoteException {
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)trans);
        String systemOptions = OP.getSpecificOptionValue(propertyName);
        if (systemOptions.length() > 0) {
            this.genSystemOptions(systemOptions);
        }
        return this;
    }

    public CodegenRequest genCreateProcessStatTable(Job job, TransformationStep step, String startTime, String endTime, String returnCode) {
        try {
            String jobName = job.getName().replaceAll("\"", "\"\"");
            String taskName = this.getCurrentParallelTask();
            String type = step != null ? bundle.getString("CodegenRequest.ProcessStats.Step.txt") : (taskName != null && taskName.length() > 0 ? bundle.getString("CodegenRequest.ProcessStats.Task.txt") : bundle.getString("CodegenRequest.ProcessStats.Job.txt"));
            String comment = bundle.getString("CodegenRequest.ProcessStats." + type + ".comment.txt");
            String stepName = "";
            String stepID = "";
            String stepType = "";
            if (step != null) {
                stepName = step.getName().replaceAll("\"", "\"\"");
                stepID = step.getFQID();
                stepType = step.getTransformRole();
            }
            if (taskName.length() == 0 && stepName.length() == 0 && !type.equals(bundle.getString("CodegenRequest.ProcessStats.Job.txt"))) {
                taskName = bundle.getString("CodegenRequest.ProcessStats.Primary.txt");
            }
            this.addCommentLine(comment).addSourceCode("data ").addSourceCode(PARALLEL_WORK_LIBREF).addSourceCode(".etls_ProcessStats_").addSourceCode(String.valueOf(this.m_processNumber)).addSourceCode("; \n").indent().addSourceCode("jobTime = \"&etls_startTime\"dt; \n").addSourceCode("job = \"").addSourceCode(jobName).addSourceCode("\"; \n").addSourceCode("jobID = \"").addSourceCode(job.getFQID()).addSourceCode("\"; \n").addSourceCode("task = \"").addSourceCode(taskName).addSourceCode("\"; \n").addSourceCode("step = \"").addSourceCode(stepName).addSourceCode("\"; \n").addSourceCode("stepID = \"").addSourceCode(stepID).addSourceCode("\"; \n").addSourceCode("stepType = \"").addSourceCode(stepType).addSourceCode("\"; \n").addSourceCode("recordType = \"").addSourceCode(type).addSourceCode("\"; \n").addSourceCode("recordNumber = ").addSourceCode(String.valueOf(this.m_processNumber)).addSourceCode("; \n").addSourceCode("startTime = ").addSourceCode(startTime).addSourceCode("; \n").addSourceCode("endTime = ").addSourceCode(endTime).addSourceCode("; \n").addSourceCode("processTime = endTime - startTime; \n").addSourceCode("returnCode = ").addSourceCode(returnCode).addSourceCode("; \n").unIndent().addSourceCode("run; \n\n");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this;
    }

    public String makeDownload(DataTable table) throws MdException, RemoteException {
        if (table == null) {
            return "";
        }
        StringBuffer code = new StringBuffer();
        DataTableCG tableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        code.append("proc download data = ").append(tableCG.getDataLocation(this)).append("\n");
        code.append("              out  = ").append(tableCG.getDataLocation(this, true)).append(";\n");
        code.append("run;\n");
        return code.toString();
    }

    public String makeDownload(String tableName) throws MdException, RemoteException {
        if (tableName == null || tableName.length() < 0) {
            return "";
        }
        StringBuffer code = new StringBuffer();
        code.append("proc download data = ").append(tableName).append("\n");
        code.append("              out  = ").append(tableName).append(";\n");
        code.append("run;\n");
        return code.toString();
    }

    public CodegenRequest genDownload(DataTable table) throws MdException, RemoteException {
        this.addSourceCode(this.makeDownload(table));
        return this;
    }

    public CodegenRequest genDownload(String tableName) throws MdException, RemoteException {
        this.addSourceCode(this.makeDownload(tableName));
        return this;
    }

    public String makeUpload(DataTable table) throws MdException, RemoteException {
        if (table == null) {
            return "";
        }
        StringBuffer code = new StringBuffer();
        DataTableCG tableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        code.append("proc upload data = ").append(tableCG.getDataLocation(this)).append("\n");
        code.append("            out  = ").append(tableCG.getDataLocation(this, true)).append(";\n");
        code.append("run;\n");
        return code.toString();
    }

    public String makeUpload(String tableName) throws MdException, RemoteException {
        if (tableName == null || tableName.length() < 0) {
            return "";
        }
        StringBuffer code = new StringBuffer();
        code.append("proc upload data = ").append(tableName).append("\n");
        code.append("            out  = ").append(tableName).append(";\n");
        code.append("run;\n");
        return code.toString();
    }

    public CodegenRequest genUpload(DataTable table) throws MdException, RemoteException {
        this.addSourceCode(this.makeUpload(table));
        return this;
    }

    public CodegenRequest genUpload(String tableName) throws MdException, RemoteException {
        this.addSourceCode(this.makeUpload(tableName));
        return this;
    }

    public TransformationStep getPreviousSysLast(TransformationStep currentStep) throws MdException, RemoteException {
        AssociationList nextPredList;
        AssociationList nextSuccList;
        if (currentStep instanceof SyncStep && ((SyncStep)currentStep).getTransformations().size() == 0) {
            AssociationList nextPredList2;
            AssociationList nextSuccList2 = currentStep.getSuccessorDependencies();
            if (!nextSuccList2.isEmpty() && !(nextPredList2 = ((StepPrecedence)nextSuccList2.get(0)).getPredecessors()).isEmpty()) {
                TransformationStep returningStep;
                TransformationStep nextPredTS = (TransformationStep)nextPredList2.get(0);
                if (nextSuccList2.size() > 0 && (returningStep = this.getPreviousSysLast(nextPredTS)) != null) {
                    currentStep = returningStep;
                }
            }
        } else if (currentStep.getTransformations() != null && currentStep.getTransformations().size() > 0 && currentStep.getTransformations().get(0) instanceof Job && !(nextSuccList = currentStep.getSuccessorDependencies()).isEmpty() && !(nextPredList = ((StepPrecedence)nextSuccList.get(0)).getPredecessors()).isEmpty()) {
            TransformationStep returningStep;
            TransformationStep nextPredTS = (TransformationStep)nextPredList.get(0);
            if (nextSuccList.size() > 0 && (returningStep = this.getPreviousSysLast(nextPredTS)) != null) {
                currentStep = returningStep;
            }
        }
        if (currentStep.getTransformations() != null && currentStep.getTransformations().size() > 0) {
            return currentStep;
        }
        return null;
    }

    public CodegenRequest genSyslast(ClassifierMap classifierMap) throws MdException, RemoteException {
        AssociationList tableList;
        AssociationList predList;
        if (classifierMap.getSteps(false).size() <= 0) {
            throw new CodegenException(bundle.getString("PROCESS.NoTransformationSteps.msg.txt"));
        }
        TransformationStep iStep = (TransformationStep)classifierMap.getSteps(false).get(0);
        boolean makeSyslast = true;
        AssociationList succList = iStep.getSuccessorDependencies();
        if (succList.size() > 0 && !(predList = ((StepPrecedence)succList.get(0)).getPredecessors(false)).isEmpty()) {
            TransformationStep predTS = (TransformationStep)predList.get(0);
            ClassifierMap predCM = null;
            if (predTS instanceof SyncStep && ((SyncStep)predTS).getTransformations().size() == 0) {
                TransformationStep nextPredTS = this.getPreviousSysLast(predTS);
                if (nextPredTS != null) {
                    predCM = (ClassifierMap)nextPredTS.getTransformations().get(0);
                }
            } else {
                predCM = (ClassifierMap)predTS.getTransformations().get(0);
            }
            OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)predCM);
            makeSyslast = OP.stringToBoolean(OP.getSpecificOptionValue("SYSLAST"), true);
        }
        if (makeSyslast && (tableList = classifierMap.getClassifierSources()).size() == 1) {
            Object obj = tableList.get(0);
            if (!(obj instanceof DataTable)) {
                return this;
            }
            DataTable table = (DataTable)obj;
            DataTableCG tableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
            String tableName = tableCG.getDataLocation(this);
            if (tableName == null || tableName.length() == 0) {
                return this;
            }
            this.addSourceCode("%let SYSLAST = %nrquote(" + tableCG.getDataLocation(this) + "); \n\n");
        }
        return this;
    }

    public CodegenRequest genUWC(AbstractTransformation trans) throws MdException, RemoteException {
        return this.genUWC(trans, false);
    }

    public CodegenRequest genUWC(AbstractTransformation trans, boolean step) throws MdException, RemoteException {
        Text code = trans.getSourceCode();
        boolean addDescComment = false;
        String processComment = "";
        if (step) {
            if (trans.getTransformRole().equalsIgnoreCase(PREPROCESS)) {
                processComment = bundle.getString("CodegenRequest.PreProcessStep.msg.txt");
            } else if (trans.getTransformRole().equalsIgnoreCase(POSTPROCESS)) {
                processComment = bundle.getString("CodegenRequest.PostProcessStep.msg.txt");
            } else {
                addDescComment = true;
            }
        } else if (trans.getTransformRole().equalsIgnoreCase(PREPROCESS)) {
            processComment = bundle.getString("CodegenRequest.PreProcess.msg.txt");
        } else if (trans.getTransformRole().equalsIgnoreCase(POSTPROCESS)) {
            processComment = bundle.getString("CodegenRequest.PostProcess.msg.txt");
        } else {
            addDescComment = true;
        }
        if (!addDescComment) {
            this.addProcessComment((Transformation)trans, processComment);
        }
        return this.genUWC(code, addDescComment, true);
    }

    public CodegenRequest genUWC(Text code, boolean addDescComment, boolean addRCSet) throws MdException, RemoteException {
        String description;
        if (code == null) {
            throw new CodegenException(bundle.getString("PROCESS.NoSourceCode.msg.txt"));
        }
        CodeGenInterface codeCG = CodeGenUtil.getCodeGenClass((CMetadata)code);
        this.addUWCStartComment();
        if (addDescComment && (description = code.getDesc()).length() > 0) {
            this.addCommentLine(code.getName() + ": " + description);
        }
        codeCG.codeGen(this);
        this.addUWCEndComment();
        this.addSourceCode("\n");
        if (addRCSet) {
            this.genRCSetCall("&syserr", false);
            this.genRCSetCall("&sqlrc");
        }
        return this;
    }

    public static String makeAbortJobCode(String returnCode) {
        StringBuffer code = new StringBuffer();
        code.append("/* ").append(bundle.formatString("CodegenRequest.AbortJob.comment.txt", (Object)returnCode)).append(" */ \n").append("data _null_; \n").append(INDENT).append("abort return ").append(returnCode).append("; \n").append("run; \n\n");
        return code.toString();
    }

    public CodegenRequest genAbortJob(String returnCode) {
        String code = CodegenRequest.makeAbortJobCode(returnCode);
        this.addSourceCode(code);
        return this;
    }

    public StringBuffer getLabelStatement(String desc) {
        return this.m_SASCodeGen.getLabelStatement(desc);
    }

    public StringBuffer getLabelStatement(Column col) {
        StringBuffer desc = new StringBuffer();
        try {
            desc.append(this.getLabelStatement(col.getDesc()));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return desc;
    }

    public CodegenRequest genLabelStatement(String desc) {
        return this.addSourceCode(this.getLabelStatement(desc));
    }

    public CodegenRequest genLabelStatement(Column col) {
        return this.addSourceCode(this.getLabelStatement(col));
    }

    public CodegenRequest genJobStatusUpdateBefore(PhysicalTable table) throws MdException, RemoteException {
        if (!this.getJobStatus()) {
            return this;
        }
        PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        String tableDSName = tableCG.getDataLocation(this);
        String lib = this.getEscapedMacroValue(tableCG.getLibrary(this).getName());
        this.addCommentLine(bundle.getString("CodegenRequest.JobStatus.txt"));
        Loader tempLoader = new Loader(this, table);
        tempLoader.getDBMSSTORE().genGetNumRows(this, tableDSName, "etls_recordsBefore");
        this.addSourceCode("%let etls_table = %nrquote(").addSourceCode(table.getName()).addSourceCode(");\n");
        this.addSourceCode("%let etls_lib   = %nrquote(").addSourceCode(lib).addSourceCode(");\n\n");
        return this;
    }

    public CodegenRequest genJobStatusUpdateAfter(PhysicalTable table) throws MdException, RemoteException {
        if (!this.getJobStatus()) {
            return this;
        }
        PhysicalTableCG tableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
        String tableDSName = tableCG.getDataLocation(this);
        this.addCommentLine(bundle.getString("CodegenRequest.JobStatus.txt"));
        Loader tempLoader = new Loader(this, table);
        tempLoader.getDBMSSTORE().genGetNumRows(this, tableDSName, "etls_recordsAfter");
        return this;
    }

    public String getEscapedMacroValue(String string) {
        return this.m_SASCodeGen.escapeMacroValue(string);
    }

    public boolean wasCancelRequested() {
        return this.m_cancelCodegen;
    }

    public void cancelCodeGen() {
        this.m_cancelCodegen = true;
    }

    public CMetadata createMetadataObject(String strName, String strType, String strFQID) {
        CMetadata cMetaObject = null;
        HashMap hm = this.m_ObjectList;
        CMetadata tempHashObject = (CMetadata)hm.get(strFQID);
        try {
            if (tempHashObject != null && tempHashObject.getFQID().equals(strFQID)) {
                return tempHashObject;
            }
            try {
                if (strType.equals("Dimension")) {
                    Class<?> LoadedClass = Class.forName("com.sas.metadata.W" + strType);
                    cMetaObject = (CMetadata)LoadedClass.newInstance();
                } else {
                    Class<?> LoadedClass = Class.forName("com.sas.metadata.impl." + strType + "Impl");
                    cMetaObject = (CMetadata)LoadedClass.newInstance();
                }
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
            if (cMetaObject != null) {
                cMetaObject.setName(strName);
                cMetaObject.setFQID(strFQID);
                cMetaObject.setCMetadataType(strType);
                hm.put(strFQID, cMetaObject);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return cMetaObject;
    }

    public void getMetadataAll(CMetadata metaObject, Vector inSimpleAttr, Vector inComplexObject, Vector inXMLTemplate, Vector[] outComplexObjects, int iOptions) {
        int iLengthinSimpleAttr = 0;
        int iLengthinComplexObject = 0;
        try {
            String strTemplate;
            int i;
            if (inSimpleAttr != null) {
                iLengthinSimpleAttr = inSimpleAttr.size();
            }
            if (inComplexObject != null) {
                iLengthinComplexObject = inComplexObject.size();
            }
            StringBuffer bufXML = new StringBuffer();
            String strType = metaObject.getCMetadataType();
            bufXML.append("<" + strType + " ID=\"" + metaObject.getFQID() + "\" ");
            for (i = 0; i < iLengthinSimpleAttr; ++i) {
                bufXML.append(inSimpleAttr.elementAt(i) + "=\"\" ");
            }
            bufXML.append(">");
            if (iLengthinComplexObject > 0) {
                for (i = 0; i < iLengthinComplexObject; ++i) {
                    bufXML.append("<" + inComplexObject.elementAt(i) + "/>");
                    outComplexObjects[i] = new Vector(1);
                }
            }
            bufXML.append("</" + strType + ">");
            String inXML = bufXML.toString();
            int iLengthinTemplate = inXMLTemplate.size();
            if (iLengthinTemplate > 0) {
                StringBuffer strBuffer = new StringBuffer();
                strBuffer.append("<TEMPLATES>");
                for (i = 0; i < iLengthinTemplate; ++i) {
                    strBuffer.append(inXMLTemplate.elementAt(i));
                }
                strBuffer.append("</TEMPLATES>");
                strTemplate = strBuffer.toString();
            } else {
                strTemplate = "";
            }
            StringHolder outXML = new StringHolder();
            MdOMRConnection work = Workspace.getMdFactory().getConnection();
            try {
                work.getCMRHandle().GetMetadata(inXML, outXML, "SAS", iOptions, strTemplate);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
            String outXMLString = outXML.value;
            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(outXMLString);
            Node firstNode = doc.getFirstChild();
            this.populateObject(metaObject, firstNode.getAttributes(), firstNode.getChildNodes(), outComplexObjects);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            throw new CodegenException(bundle.getString("CodegenRequest.MetadataError.msg.txt"));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void populateObject(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, Vector[] outComplexObjects) {
        this.doSimple(metaObject, simpleNodeMap);
        Vector outComplexNames = new Vector();
        this.doComplex(complexNodeList, outComplexNames, outComplexObjects);
        this.setComplex(metaObject, outComplexNames, outComplexObjects);
    }

    private void doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap) {
        int iLengthinSimpleAttr = thisNodeMap.getLength();
        for (int i = 0; i < iLengthinSimpleAttr; ++i) {
            Class[] classes = new Class[]{String.class, Integer.TYPE};
            String attr = thisNodeMap.item(i).getNodeName();
            if (attr.equalsIgnoreCase("ID")) continue;
            try {
                String strTemp = "set" + attr;
                Method method = thisObject.getClass().getMethod(strTemp, classes);
                Object[] args = new Object[]{thisNodeMap.item(i).getNodeValue(), new Integer(2)};
                try {
                    method.invoke((Object)thisObject, args);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            catch (NoSuchMethodException e) {
                Workspace.getDefaultLogger().warn((Object)("Cannot set attribute " + thisNodeMap.item(i).getNodeName() + " on object instance of " + thisObject.getClass().getName()));
            }
        }
    }

    private void doComplex(NodeList thisNodeList, Vector outComplexNames, Vector[] outComplexObjects) {
        String name = null;
        String id = null;
        int count = 0;
        int numChildLists = thisNodeList.getLength();
        for (int k = 0; k < numChildLists; ++k) {
            NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            outComplexObjects[++count - 1] = new Vector(length);
            outComplexNames.add(thisNodeList.item(k).getNodeName());
            for (int i = 0; i < length; ++i) {
                NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                String strType = myChildNodeList.item(i).getNodeName();
                try {
                    name = childNodeMap2.getNamedItem("Name").getNodeValue();
                }
                catch (Exception e) {
                    name = null;
                }
                id = childNodeMap2.getNamedItem("Id").getNodeValue();
                if (name == null) {
                    name = id;
                }
                CMetadata complexObject = this.createMetadataObject(name, strType, id);
                outComplexObjects[count - 1].add(complexObject);
                Vector[] childComplexObjects = new Vector[myChildNodeList.item(i).getChildNodes().getLength()];
                this.populateObject(complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), childComplexObjects);
            }
        }
    }

    private void setComplex(CMetadata metaObject, Vector outComplexNames, Vector[] outComplexObjects) {
        for (int i = 0; i < outComplexNames.size(); ++i) {
            Class[] classes = new Class[]{AssociationList.class};
            String AssocName = outComplexNames.elementAt(i).toString();
            AssociationList complexAssoc = new AssociationList(AssocName, (Collection)outComplexObjects[i]);
            try {
                String strTemp = "set" + AssocName;
                if (!strTemp.endsWith("s")) {
                    strTemp = strTemp + "s";
                }
                Method method = metaObject.getClass().getMethod(strTemp, classes);
                Object[] args = new Object[]{complexAssoc};
                try {
                    method.invoke((Object)metaObject, args);
                    complexAssoc.setState(1);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            catch (NoSuchMethodException e) {
                Workspace.getDefaultLogger().warn((Object)("Cannot set association " + AssocName + " on object instance of " + metaObject.getClass().getName()));
            }
        }
    }

    public void removeServer(DeployedComponent iServer) {
        try {
            for (int i = 0; i < this.m_hostList.size(); ++i) {
                CMetadata iHost = (CMetadata)this.m_hostList.get(i);
                if (!iHost.getFQID().equals(iServer.getFQID())) continue;
                this.m_hostList.remove(i);
                break;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void addSingleLineComment(String msg) {
        this.addCommentLine(msg);
    }

    public CodegenRequest addComment(String msg, String name, int seq) {
        if (seq == 1) {
            this.addSectionComment(name + ": " + msg);
            return this;
        }
        msg = msg.replaceAll("\n", "\n *              ");
        String divider = seq == 0 ? "******************************************************************" : (seq == 1 ? "------------------------------------------------------------------" : "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        this.addSourceCode("/*").addSourceCode(divider).addSourceCode(" \n").addSourceCode(" * ").addSourceCode(bundle.getString("CodegenRequest.Name.msg.txt")).addSourceCode(JCL_INDENT).addSourceCode(name).addSourceCode(" \n").addSourceCode(" * ").addSourceCode(bundle.getString("CodegenRequest.Description.msg.txt")).addSourceCode(JCL_INDENT).addSourceCode(msg).addSourceCode(" \n").addSourceCode(" * ").addSourceCode(bundle.getString("CodegenRequest.Generated.msg.txt")).addSourceCode(JCL_INDENT).addSourceCode(Calendar.getInstance().getTime().toString()).addSourceCode(" \n").addSourceCode(" *").addSourceCode(divider).addSourceCode("*/ \n");
        return this;
    }

    public void setUnIndentJobCode(boolean unindentJobCode) {
        this.m_unIndentJobCode = unindentJobCode;
    }

    public void addSource(String sourceText) {
        if (sourceText != null) {
            if (this.m_indentString.length() > 0) {
                sourceText = sourceText.replaceAll("\n", "\n" + this.m_indentString);
            }
            this.m_GeneratedSource.append(sourceText);
        }
    }

    public void addSource(StringBuffer sourceText) {
        if (sourceText != null) {
            String source = sourceText.toString();
            this.addSource(source);
        }
    }

    public void addComment(String msg) {
        this.addSourceCode(this.m_SASCodeGen.makeComment(msg));
    }

    public void resetValidVarName() {
        this.removeGlobalData(CASE);
        this.removeGlobalData(SPECIAL_CHAR);
        this.removeGlobalData(VALID_VARNAME);
    }

    public void genValidVarName(List tableList1, List tableList2) throws MdException, RemoteException {
        this.genValidVarName(tableList1, tableList2, true);
    }

    public void genValidVarName(List tableList1, List tableList2, boolean generateSource) throws MdException, RemoteException {
        String o_Case = this.getGlobalData(CASE);
        String o_SpecChar = this.getGlobalData(SPECIAL_CHAR);
        String o_VVN = this.getGlobalData(VALID_VARNAME);
        String n_Case = GLOBAL_NO;
        String n_SpecChar = GLOBAL_NO;
        int allwork = 0;
        boolean anySpecChar = false;
        boolean anyCase = false;
        for (int j = 1; j < 3; ++j) {
            List tableList;
            if (j == 1) {
                tableList = tableList1;
            } else {
                if (anySpecChar && anyCase || tableList2.equals(null)) break;
                tableList = tableList2;
            }
            for (int i = 0; i < tableList.size() && tableList.get(i) instanceof DataTable; ++i) {
                DataTable table = (DataTable)tableList.get(i);
                if (table instanceof ExternalTable) {
                    ExternalTableCG tableCG = (ExternalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
                    EFIDataModel model = tableCG.getModel();
                    if (model.isSpecialCharactersInColumnNamesEnabled()) {
                        anySpecChar = true;
                        anyCase = true;
                    } else if (model.isCaseSensitiveColumnNamesEnabled()) {
                        anyCase = true;
                    }
                } else {
                    String preserveCase;
                    String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)table, (String)this.getGlobalData(SPECIAL_CHAR));
                    if (specChar.equals(GLOBAL_YES)) {
                        anySpecChar = true;
                    }
                    if ((preserveCase = DBMSNamesPropertyHandler.getCasePropertyValue((Root)table, (String)this.getGlobalData(CASE))).equals(GLOBAL_YES)) {
                        anyCase = true;
                    }
                }
                if (j != 2) continue;
                allwork = 0;
            }
        }
        if (tableList2.size() == allwork) {
            for (int i = 0; i < tableList2.size(); ++i) {
                DataTable targetTable = (DataTable)tableList2.get(i);
                AssociationList CMList = targetTable.getSourceClassifierMaps(false);
                for (int j = 0; j < CMList.size(); ++j) {
                    ClassifierMap CM = (ClassifierMap)CMList.get(j);
                    AssociationList targetList = CM.getClassifierTargets();
                    for (int k = 0; k < targetList.size(); ++k) {
                        String Case;
                        DataTable table = (DataTable)targetList.get(k);
                        if (table instanceof ExternalTable) {
                            ExternalTableCG tableCG = (ExternalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
                            EFIDataModel model = tableCG.getModel();
                            if (model.isSpecialCharactersInColumnNamesEnabled()) {
                                anySpecChar = true;
                                anyCase = true;
                                continue;
                            }
                            if (!model.isCaseSensitiveColumnNamesEnabled()) continue;
                            anyCase = true;
                            continue;
                        }
                        String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)table, (String)this.getGlobalData(SPECIAL_CHAR));
                        if (specChar.equals(GLOBAL_YES)) {
                            anySpecChar = true;
                        }
                        if (!(Case = DBMSNamesPropertyHandler.getCasePropertyValue((Root)table, (String)this.getGlobalData(CASE))).equals(GLOBAL_YES)) continue;
                        anyCase = true;
                    }
                }
            }
        }
        if (anySpecChar) {
            n_SpecChar = GLOBAL_YES;
        }
        if (anyCase) {
            n_Case = GLOBAL_YES;
        }
        if (!n_Case.equals(o_Case)) {
            this.setGlobalData(CASE, n_Case);
            this.setGlobalData(PREVIOUS_CASE, o_Case);
        }
        if (!n_SpecChar.equals(o_SpecChar)) {
            this.setGlobalData(SPECIAL_CHAR, n_SpecChar);
            this.setGlobalData(PREVIOUS_SPECIAL_CHAR, o_SpecChar);
            if (n_SpecChar.equals(GLOBAL_YES) && !o_VVN.equals(GLOBAL_ANY)) {
                this.setGlobalData(VALID_VARNAME, GLOBAL_ANY);
                if (generateSource) {
                    this.addSourceCode("options VALIDVARNAME = ANY; \n\n");
                }
            } else if (n_SpecChar.equals(GLOBAL_NO) && !o_VVN.equals(GLOBAL_ANY)) {
                this.setGlobalData(VALID_VARNAME, GLOBAL_V7);
                if (generateSource) {
                    this.addSourceCode("options VALIDVARNAME = V7; \n\n");
                }
            }
        }
    }

    public void setGenerateCommentHeaderOnParallelMacros(boolean value) {
        this.m_SASCodeGen.setGenerateCommentsOnParallelMacros(value);
    }

    public void setInRemoteSubmit(boolean value) {
        this.m_inRemoteSubmit = value;
    }

    public void setJobStatus(Job job) {
        this.m_jobStatus.put(job, job);
    }

    public boolean getJobStatus() {
        return !this.m_currentJob.isEmpty() && this.m_jobStatus.get(this.m_currentJob.peek()) != null;
    }

    public void setCurrentJob(Job job) {
        this.m_currentJob.push(job);
    }

    public void endCurrentJob() {
        if (!this.m_currentJob.isEmpty()) {
            this.m_currentJob.pop();
        }
    }

    public void setCurrentLoop(String loopControlName) {
        this.m_currentLoop.push(loopControlName);
    }

    public void endCurrentLoop() {
        if (!this.m_currentLoop.isEmpty()) {
            this.m_currentLoop.pop();
        }
    }

    public int getLoopCount() {
        return this.m_currentLoop.size();
    }

    class CodegenWaitThread
    extends Thread {
        protected CodegenRequest m_CodegenRequest;

        protected CodegenWaitThread(CodegenRequest cgReq) {
            this.m_CodegenRequest = cgReq;
        }

        @Override
        public void run() {
            try {
                this.m_CodegenRequest.doTheCodegen();
            }
            catch (Exception ge) {
                System.err.println("Error returned from doCodegen: " + ge.getMessage());
                return;
            }
        }
    }
}

