/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenInterface;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.WorkTableCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformLoaderInterface;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.TransformUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.HashMap;

public class CodeGenUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(CodeGenUtil.class);
    private static final int CACHE_SIZE = 50;
    static HashMap m_cache = new HashMap(50);
    private static final String CLASS_NAME = "CLASS";
    private static final String DEFAULT_DBMS = "SAS";
    public static final String FILE_WRITER_CLASS = "com.sas.wadmin.visuals.FileWriter";
    public static final String FILE_READER_CLASS = "com.sas.wadmin.visuals.FileReader";

    public static CodeGenInterface getCodeGenClass(CMetadata meta) throws MdException, RemoteException {
        return CodeGenUtil.getCodeGenClass(meta, false);
    }

    public static CodeGenInterface getCodeGenClass(CMetadata meta, boolean ignoreCache) throws MdException, RemoteException {
        CodeGenInterface cgInterface = null;
        cgInterface = (CodeGenInterface)m_cache.get(meta.getFQID());
        if (ignoreCache || cgInterface == null || cgInterface.getMetadataClass() == null || cgInterface.getMetadataClass().getFQID() == null) {
            String metadataClassname = null;
            Class<?>[] metadataInterfaces = meta.getClass().getInterfaces();
            for (int i = 0; i < metadataInterfaces.length; ++i) {
                Class<?> metaInterface = metadataInterfaces[i];
                String packageName = metaInterface.getPackage().getName();
                if (!packageName.equals("com.sas.metadata.remote")) continue;
                metadataClassname = metaInterface.getName();
                break;
            }
            metadataClassname = metadataClassname.substring(metadataClassname.lastIndexOf(".") + 1);
            String codeGenClassname = null;
            boolean setDBMS = false;
            if (metadataClassname.equals("PhysicalTable") || metadataClassname.equals("WorkTable")) {
                codeGenClassname = CodeGenUtil.getDBMSProductName((PhysicalTable)meta).toUpperCase();
                setDBMS = true;
                try {
                    Class<?> LoadedClass = Class.forName("com.sas.codegen." + codeGenClassname);
                    cgInterface = (CodeGenInterface)LoadedClass.newInstance();
                }
                catch (Exception ce) {
                    codeGenClassname = metadataClassname + "CG";
                }
            } else {
                codeGenClassname = metadataClassname.equals("ClassifierMap") || metadataClassname.equals("Select") || metadataClassname.equals("Join") ? "ClassifierMapCG" : (metadataClassname.equals("ServerContext") ? "DeployedComponentCG" : metadataClassname + "CG");
            }
            boolean flag = false;
            while (!flag) {
                try {
                    Class<?> LoadedClass = Class.forName("com.sas.codegen." + codeGenClassname);
                    cgInterface = (CodeGenInterface)LoadedClass.newInstance();
                    flag = true;
                }
                catch (ClassNotFoundException ce) {
                    if (setDBMS) {
                        throw new CodegenException(bundle.formatString("CodeGenUtil.UnknownDBMS.msg.txt", (Object)codeGenClassname));
                    }
                    throw new CodegenException(bundle.formatString("CodeGenUtil.UnknownObject.msg.txt", (Object)codeGenClassname));
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
        }
        cgInterface.setMetadataClass(meta);
        if (!ignoreCache) {
            m_cache.put(meta.getFQID(), cgInterface);
        }
        return cgInterface;
    }

    public static CodeGenInterface getCodeGenTable(PhysicalTable table, String dbmsType) throws MdException, RemoteException {
        CodeGenInterface cgInterface = null;
        String metadataClassname = null;
        Class<?>[] metadataInterfaces = table.getClass().getInterfaces();
        for (int i = 0; i < metadataInterfaces.length; ++i) {
            Class<?> metaInterface = metadataInterfaces[i];
            String packageName = metaInterface.getPackage().getName();
            if (!packageName.equals("com.sas.metadata.remote")) continue;
            metadataClassname = metaInterface.getName();
            break;
        }
        metadataClassname = metadataClassname.substring(metadataClassname.lastIndexOf(".") + 1);
        String codeGenClassname = null;
        codeGenClassname = dbmsType == null || dbmsType.length() == 0 ? CodeGenUtil.getDBMSProductName(table).toUpperCase() : dbmsType;
        try {
            Class<?> LoadedClass = Class.forName("com.sas.codegen." + codeGenClassname);
            cgInterface = (CodeGenInterface)LoadedClass.newInstance();
        }
        catch (Exception ce) {
            codeGenClassname = metadataClassname + "CG";
        }
        boolean flag = false;
        while (!flag) {
            try {
                Class<?> LoadedClass = Class.forName("com.sas.codegen." + codeGenClassname);
                cgInterface = (CodeGenInterface)LoadedClass.newInstance();
                flag = true;
            }
            catch (ClassNotFoundException ce) {
                throw new CodegenException(bundle.formatString("CodeGenUtil.UnknownDBMS.msg.txt", (Object)codeGenClassname));
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        cgInterface.setMetadataClass((CMetadata)table);
        return cgInterface;
    }

    public static String getPluginClass(CMetadata meta) throws MdException, RemoteException {
        String className = null;
        TransformationStep step = CodeGenUtil.getTransformationStep(meta);
        if (step == null) {
            return className;
        }
        AssociationList props = step.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            Property iProp = (Property)props.get(i);
            if (!iProp.getPropertyName().equalsIgnoreCase(CLASS_NAME)) continue;
            className = iProp.getDefaultValue();
            break;
        }
        return className;
    }

    public static TransformationStep getTransformationStep(CMetadata meta) throws MdException, RemoteException {
        TransformationStep step = null;
        if (meta instanceof Event) {
            step = (TransformationStep)((Event)meta).getTriggeringTransforms(false).get(0);
        } else if (meta instanceof TransformationStep) {
            step = (TransformationStep)meta;
        } else if (meta instanceof ClassifierMap) {
            step = (TransformationStep)((ClassifierMap)meta).getSteps(false).get(0);
        }
        return step;
    }

    public static TransformInterface getPluginInterface(CMetadata meta) throws MdException, RemoteException {
        TransformInterface tInterface = null;
        String classname = CodeGenUtil.getPluginClass(meta);
        if (classname != null && classname.length() > 0) {
            TransformManager mgr = TransformManager.getInstance();
            if (mgr == null) {
                mgr = TransformManager.createInstance();
            }
            tInterface = mgr.getTransform(classname);
        }
        return tInterface;
    }

    public static TransformInterface getPluginInterface(String className) throws MdException, RemoteException {
        TransformInterface tInterface = null;
        if (className != null && className.length() > 0) {
            tInterface = TransformManager.getInstance().getTransform(className);
        }
        return tInterface;
    }

    public static String getPluginClassPropertyRole(CMetadata meta) throws MdException, RemoteException {
        TransformationStep step = meta instanceof Event ? (TransformationStep)((Event)meta).getTriggeringTransforms(false).get(0) : (TransformationStep)((ClassifierMap)meta).getSteps(false).get(0);
        AssociationList props = step.getProperties();
        String rolename = null;
        for (int i = 0; i < props.size(); ++i) {
            Property iProp = (Property)props.get(i);
            if (!iProp.getPropertyName().equalsIgnoreCase(CLASS_NAME)) continue;
            rolename = iProp.getPropertyRole();
            break;
        }
        return rolename;
    }

    public void clearCodeGenCache() {
        m_cache.clear();
    }

    public HashMap getCodeGenCache() {
        return m_cache;
    }

    public void removeObjectFromCache(CMetadata meta) {
        try {
            m_cache.remove(meta.getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static String getDBMSProductName(PhysicalTable table) throws MdException, RemoteException {
        String DBMSName = TransformUtil.getClientDBMSProductName((PhysicalTable)table);
        if (DBMSName == null || DBMSName.length() <= 0) {
            return DEFAULT_DBMS;
        }
        return DBMSName;
    }

    public static boolean isLoaderTransformation(CMetadata meta) throws MdException, RemoteException {
        return CodeGenUtil.isLoaderTransformation(meta, true);
    }

    public static boolean isLoaderTransformation(CMetadata meta, boolean considerAllTransforms) throws MdException, RemoteException {
        String className = CodeGenUtil.getPluginClass(meta);
        TransformInterface transform = CodeGenUtil.getPluginInterface(className);
        boolean isLoader = false;
        ClassifierMap cMap = null;
        if (meta instanceof ClassifierMap) {
            cMap = (ClassifierMap)meta;
        } else if (meta instanceof TransformationStep && !((TransformationStep)meta).getTransformations().isEmpty()) {
            cMap = (ClassifierMap)((TransformationStep)meta).getTransformations().get(0);
        }
        if (className != null && className.length() > 0 && !FILE_WRITER_CLASS.equalsIgnoreCase(className)) {
            if (transform instanceof TransformLoaderInterface) {
                isLoader = true;
            } else if (cMap != null && considerAllTransforms) {
                int numTargets = cMap.getClassifierTargets().size();
                for (int i = 0; i < numTargets; ++i) {
                    Classifier table = (Classifier)cMap.getClassifierTargets().get(i);
                    if (!(table instanceof PhysicalTable) || !table.getCMetadataType().equals("PhysicalTable")) continue;
                    isLoader = true;
                    break;
                }
            }
        }
        return isLoader;
    }

    public static SASLibrary getLibrary(DataTable table) {
        SASLibrary lib = null;
        try {
            RelationalSchema tableContainer = table.getTablePackage();
            if (tableContainer != null) {
                DatabaseSchema dbSchema;
                if (tableContainer instanceof SASLibrary) {
                    lib = (SASLibrary)tableContainer;
                } else if (tableContainer instanceof DatabaseSchema && !(dbSchema = (DatabaseSchema)tableContainer).getUsedByPackages().isEmpty() && dbSchema.getUsedByPackages().get(0) instanceof SASLibrary) {
                    lib = (SASLibrary)dbSchema.getUsedByPackages().get(0);
                }
            }
        }
        catch (MdException tableContainer) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return lib;
    }

    public static StringBuffer genMetadataMacrosAndOptions(CMetadata metaObject, ServerContext appServer, boolean makeMetauser) throws MdException, RemoteException {
        SASCodeGeneration sasCode = new SASCodeGeneration();
        return sasCode.getMetadataMacrosAndOptions(metaObject, appServer, makeMetauser, null, null);
    }

    public static StringBuffer genMetadataMacrosAndOptions(CMetadata metaObject, ServerContext appServer, boolean makeMetauser, String metauser, String metapass) throws MdException, RemoteException {
        SASCodeGeneration sasCode = new SASCodeGeneration();
        return sasCode.getMetadataMacrosAndOptions(metaObject, appServer, makeMetauser, metauser, metapass);
    }

    public static StringBuffer genDownload(CodegenRequest cgReq, DataTable iTab) throws MdException, RemoteException {
        if (iTab instanceof ExternalTable) {
            throw new CodegenException(bundle.getString("PROCESS.NoExternalTableSource.msg.txt"));
        }
        StringBuffer sCode = new StringBuffer();
        DataTableCG iTabCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)iTab);
        sCode.append("Proc Download data=" + iTabCG.getDataLocation(cgReq) + "\n");
        sCode.append("out=" + iTabCG.getDataLocation(cgReq, true) + ";\n");
        sCode.append("run;\n");
        return sCode;
    }

    public static StringBuffer genUpload(CodegenRequest cgReq, DataTable iTab) throws MdException, RemoteException {
        if (iTab instanceof ExternalTable) {
            throw new CodegenException(bundle.getString("PROCESS.NoExternalTableSource.msg.txt"));
        }
        StringBuffer sCode = new StringBuffer();
        DataTableCG iTabCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)iTab);
        sCode.append("Proc Upload data=" + iTabCG.getDataLocation(cgReq) + "\n");
        sCode.append("out=" + iTabCG.getDataLocation(cgReq, true) + ";\n");
        sCode.append("run;\n");
        return sCode;
    }

    public static void genSyslast(CodegenRequest cgReq, ClassifierMap iObj) throws MdException, RemoteException {
        AssociationList tableList;
        if (iObj.getSteps(false).size() <= 0) {
            throw new CodegenException(bundle.getString("PROCESS.NoTransformationSteps.msg.txt"));
        }
        TransformationStep iStep = (TransformationStep)iObj.getSteps(false).get(0);
        boolean makeSyslast = true;
        AssociationList succList = iStep.getSuccessorDependencies();
        if (succList.size() > 0) {
            AssociationList predList = ((StepPrecedence)succList.get(0)).getPredecessors();
            TransformationStep predTS = (TransformationStep)predList.get(0);
            ClassifierMap predCM = null;
            if (predTS instanceof SyncStep && ((SyncStep)predTS).getTransformations().size() == 0) {
                AssociationList nextSuccList = predTS.getSuccessorDependencies();
                if (nextSuccList.size() > 0) {
                    AssociationList nextPredList = ((StepPrecedence)nextSuccList.get(0)).getPredecessors();
                    TransformationStep nextPredTS = (TransformationStep)nextPredList.get(0);
                    predCM = (ClassifierMap)nextPredTS.getTransformations().get(0);
                }
            } else {
                predCM = (ClassifierMap)predTS.getTransformations().get(0);
            }
            OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)predCM);
            makeSyslast = OP.stringToBoolean(OP.getSpecificOptionValue("SYSLAST"), true);
        }
        if (makeSyslast && (tableList = iObj.getClassifierSources()).size() == 1) {
            DataTable table = (DataTable)tableList.get(0);
            DataTableCG tableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
            String tableName = tableCG.getDataLocation(cgReq);
            if (tableName == null || tableName.length() == 0 && !(table instanceof ExternalTable)) {
                throw new CodegenException(bundle.getString("PROCESS.NoExternalTableSource.msg.txt"));
            }
            cgReq.addSourceCode("\n%let SYSLAST=%nrquote(" + tableCG.getDataLocation(cgReq) + "); \n\n");
        }
    }

    public static void genTableDelete(CodegenRequest cgReq, DataTable iTab) throws MdException, RemoteException {
        if (iTab instanceof WorkTable) {
            WorkTableCG iTabCG = (WorkTableCG)CodeGenUtil.getCodeGenClass((CMetadata)iTab);
            String tabName = iTabCG.getDataLocation(cgReq);
            CodeGenUtil.genTableDelete(cgReq, tabName);
        }
    }

    public static void genTableDelete(CodegenRequest cgReq, String tableName) {
        String dsName;
        String lib;
        if (tableName.indexOf(46) == -1) {
            lib = "WORK";
            dsName = tableName;
        } else {
            lib = tableName.substring(0, tableName.indexOf(46));
            dsName = tableName.substring(tableName.indexOf(46) + 1);
        }
        cgReq.addSourceCode("%put NOTE: " + bundle.formatString("CodeGenUtil.Deleting.msg.sasmacro.notrans", (Object)lib, (Object)dsName) + ";\n");
        cgReq.addSourceCode("proc datasets lib=" + lib + " nolist nowarn memtype=(data view);\n  delete " + dsName + ";\nquit;\n\n");
    }
}

