/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class Append {
    private static WAdminResource bundle = WAdminResource.getBundle(Append.class);
    private static final String TABLE_EXIST_CONDITION = "Condition9";

    private Append() {
    }

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        int i;
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.checkTargetsForExternalTable(classifierMap);
        cgReq.checkSourcesForExternalTable(classifierMap);
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        DataTable targetTable = cgReq.getTargetTable(classifierMap);
        cgReq.genTableDelete(targetTable);
        TransformationStep oStep = (TransformationStep)classifierMap.getSteps(false).get(0);
        PhysicalTableCG targetTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
        boolean createView = targetTableCG.isView(oStep);
        String targetTableName = targetTableCG.getDataLocation(cgReq);
        AssociationList alTriggeredEvents = oStep.getTriggeredEvents();
        boolean eventsEnabled = false;
        if (alTriggeredEvents.size() > 0) {
            eventsEnabled = true;
        }
        ArrayList<String> datasetNames = new ArrayList<String>();
        AssociationList sourceTables = classifierMap.getClassifierSources();
        for (i = 0; i < sourceTables.size(); ++i) {
            boolean columnMapped;
            DataTable sourceTable = (DataTable)sourceTables.get(i);
            DataTableCG sourceTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
            String sourceTableName = sourceTableCG.getDataLocation(cgReq);
            String sourceLibname = PhysicalTableCG.getLibref(sourceTableName);
            String workTableName = "work." + cgReq.getUniqueWorkTableName(i);
            if (eventsEnabled) {
                Append.genCodeConditionCheck(cgReq, alTriggeredEvents, sourceLibname, sourceTable, oStep);
            }
            if (columnMapped = AutoExtract.columnMapping(classifierMap, cgReq, workTableName, sourceTable)) {
                datasetNames.add(workTableName);
                continue;
            }
            datasetNames.add(sourceTableName);
        }
        cgReq.addSourceCode("data ").addSourceCode(targetTableName);
        if (createView) {
            cgReq.addSourceCode(" / view=").addSourceCode(targetTableName);
        }
        cgReq.addSourceCode(";\n").indent().addSourceCode("set ");
        for (i = 0; i < datasetNames.size(); ++i) {
            if (i > 0) {
                cgReq.addSourceCode("\n    ");
            }
            cgReq.addSourceCode((String)datasetNames.get(i));
        }
        cgReq.addSourceCode(";\n");
        String targetKeepList = cgReq.makeColumnList(targetTable, "       ");
        if (targetKeepList.length() > 0) {
            cgReq.addSourceCode("keep ").addSourceCode(targetKeepList.toString()).addSourceCode("; \n");
        }
        cgReq.unIndent().addSourceCode("run;\n\n");
        cgReq.genRCSetCall("&syserr");
    }

    private static void genCodeConditionCheck(CodegenRequest cgReq, AssociationList triggeredEvents, String sourceLibref, DataTable sourceTable, TransformationStep step) throws MdException, RemoteException {
        DataTableCG sourceTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
        String tableName = sourceTableCG.getDataLocation(cgReq);
        for (int i = 0; i < triggeredEvents.size(); ++i) {
            Event event = (Event)triggeredEvents.get(i);
            if (!event.getEventRole().equals(TABLE_EXIST_CONDITION)) continue;
            cgReq.addCommentLine(bundle.getString("Append.EventMacroDesc.txt"));
            cgReq.addSourceCode("%macro etls_tableExists; \n\n").indent();
            cgReq.genTableExist(tableName, "BOTH", "dbxrc");
            String eventCondition = event.getCondition();
            cgReq.addSourceCode(eventCondition.trim()).addSourceCode("\n").addSourceCode("%do; \n\n").indent();
            if (event.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            PropertySet truePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(event, true);
            AssociationList trueProperties = truePropertySet.getSetProperties();
            for (int j = 0; j < trueProperties.size(); ++j) {
                Property actionProperty = (Property)trueProperties.get(j);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(actionProperty, sourceTable, sourceLibref, (AbstractTransformation)step));
            }
            cgReq.unIndent().addSourceCode("%end; \n\n").unIndent().addSourceCode("%mend etls_tableExists; \n").addSourceCode("%etls_tableExists; \n\n");
        }
    }
}

