/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.resource;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.resource.FileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class JavaIOFileSystem
implements FileSystem {
    protected SSNResource _bundle = new SSNResource(this.getClass());
    protected SSNResource _enBundle = SSNResource.EnglishResource(this.getClass());
    protected static SSNResource BUNDLE = new SSNResource(JavaIOFileSystem.class);
    protected static SSNResource EN_BUNDLE = SSNResource.EnglishResource(JavaIOFileSystem.class);
    protected Logger log = (Logger)LogManager.getLogger((String)this.getClass().getName());

    @Override
    public boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    @Override
    public boolean mkdirs(String path) {
        return new File(path).mkdirs();
    }

    @Override
    public String getAbsolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    @Override
    public String getCanonicalPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    @Override
    public String separator() {
        return File.separator;
    }

    @Override
    public String append(String path, String ... node) {
        return this.append(path, new Vector<String>(Arrays.asList(node)));
    }

    @Override
    public String append(String path, AbstractList<String> nodes) {
        File retval = path != null ? new File(path) : null;
        for (String nodeItem : nodes) {
            if (nodeItem == null) continue;
            retval = new File(retval, nodeItem);
        }
        return retval.getAbsolutePath();
    }

    @Override
    public String getParent(String path) {
        return new File(path).getParent();
    }

    public static InputStream inputStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new InstallException(2, null, BUNDLE.messageString("FileSystem.FilesystemError", path), EN_BUNDLE.messageString("FileSystem.FilesystemError", path), e);
        }
    }

    public static OutputStream outputStream(String path) {
        try {
            return new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new InstallException(2, null, BUNDLE.messageString("FileSystem.FilesystemError", path), EN_BUNDLE.messageString("FileSystem.FilesystemError", path), e);
        }
    }

    @Override
    public InputStream getInputStream(String path) {
        return JavaIOFileSystem.inputStream(path);
    }

    @Override
    public OutputStream getOutputStream(String path) {
        return JavaIOFileSystem.outputStream(path);
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public boolean isFile(String path) {
        return new File(path).isFile();
    }

    @Override
    public String[] getChildren(String path) {
        return new File(path).list();
    }

    public SSNResource getBundle() {
        return this._bundle;
    }

    public void setBundle(SSNResource bundle) {
        this._bundle = bundle;
    }

    public SSNResource getEnBundle() {
        return this._enBundle;
    }

    public void setEnBundle(SSNResource enBundle) {
        this._enBundle = enBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String sourceFile, String destFile) throws IOException {
        int operatingSystem = TaskHelper.getOS(true);
        if (operatingSystem == 8 || operatingSystem == 4) {
            InputStream is = null;
            OutputStream os = null;
            is = JavaIOFileSystem.inputStream(sourceFile);
            os = JavaIOFileSystem.outputStream(destFile);
            try {
                JavaIOFileSystem.copyStreamInternal(is, os);
            }
            finally {
                is.close();
                os.close();
            }
        }
        FileChannel srcChannel = null;
        FileChannel dstChannel = null;
        FileOutputStream outputStream = null;
        try {
            srcChannel = ((FileInputStream)JavaIOFileSystem.inputStream(sourceFile)).getChannel();
            outputStream = new FileOutputStream(destFile);
            dstChannel = outputStream.getChannel();
            try {
                if (dstChannel != null && srcChannel != null) {
                    dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (srcChannel != null) {
                    srcChannel.close();
                }
                if (dstChannel != null) {
                    dstChannel.close();
                }
            }
        }
        catch (FileNotFoundException f) {
            LogManager.getLogger((String)JavaIOFileSystem.class.getName()).error(f.getMessage() + ": " + sourceFile);
            f.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        new File(destFile).setLastModified(new File(sourceFile).lastModified());
    }

    private static void copyStreamInternal(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[65536];
        int bytesRead = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
    }

    @Override
    public void copyFile(String sourceFile, String destFile) throws IOException {
        JavaIOFileSystem.copy(sourceFile, destFile);
    }

    @Override
    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.copyFile(sourceFile.getAbsolutePath(), destFile.getAbsolutePath());
    }

    @Override
    public void copyStream(InputStream is, OutputStream os) throws IOException {
        JavaIOFileSystem.copyStreamInternal(is, os);
    }
}

