/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.zos;

import com.sas.tools.installs.it.Controller;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class DynamicAllocate {
    protected static Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.zos.DynamicAllocate");
    private static final String ALLOC = "/zos/alloc.rexx";
    private static final String CNTL = "cntl";
    private static final String EMPTY = "";
    private static final String DATACLAS = "dataclas";
    private static final String MGMTCLAS = "mgmtclas";
    private static final String STORCLAS = "storclas";
    private static final String VOL = "vol";
    private static final String UNIT = "unit";
    private static final String FORMAT = "%s(%s)";
    private String cmdAlloc;

    public DynamicAllocate(Controller controller) {
        String runLocation = controller.getInstallAppLocation();
        this.setCmdAlloc(runLocation.concat(ALLOC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateDataset(String dsn, String sc, String mc, String dc, String vol, String diskunit) {
        log.debug(String.format("Entered with dsn='%s', sc='%s', mc='%s', dc='%s', vol='%s', diskunit='%s',", dsn, sc, mc, dc, vol, diskunit));
        boolean rc = false;
        String storclas = null == sc ? EMPTY : String.format(FORMAT, STORCLAS, sc);
        String mgmtclas = null == mc ? EMPTY : String.format(FORMAT, MGMTCLAS, mc);
        String dataclas = null == dc ? EMPTY : String.format(FORMAT, DATACLAS, dc);
        String volser = null == vol ? EMPTY : String.format(FORMAT, VOL, vol);
        String unit = null == diskunit ? EMPTY : String.format(FORMAT, UNIT, diskunit);
        String[] cmdArray = new String[]{this.getCmdAlloc(), CNTL, dsn, storclas, mgmtclas, dataclas, volser, unit};
        Process p = null;
        log.info("Executing command: " + this.arrayAsString(cmdArray));
        ProcessBuilder pb = new ProcessBuilder(cmdArray);
        pb.redirectErrorStream(true);
        try {
            p = pb.start();
            this.logResult(p);
            p.waitFor();
            rc = p.exitValue() == 0;
        }
        catch (IOException ioEx) {
            this.logAllocFailure(dsn, ioEx);
        }
        catch (InterruptedException iEx) {
            this.logAllocFailure(dsn, iEx);
        }
        finally {
            if (null != p) {
                p.destroy();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logResult(Process p) throws IOException {
        log.info("<==================== START OF ALLOC OUTPUT ====================>");
        try (BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            while ((line = output.readLine()) != null) {
                log.info(line);
            }
        }
        log.info("<===================== END OF ALLOC OUTPUT =====================>");
    }

    private void logAllocFailure(String dsn, Exception ex) {
        log.warn(String.format("Dataset allocation failed for '%s'", dsn), (Throwable)ex);
    }

    private String arrayAsString(String[] array) {
        StringBuffer result = new StringBuffer();
        for (String s : array) {
            result.append(s + " ");
        }
        return result.toString();
    }

    private void setCmdAlloc(String cmd) {
        this.cmdAlloc = cmd;
    }

    private String getCmdAlloc() {
        return this.cmdAlloc;
    }
}

