/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.vjr;

import com.sas.tools.installs.it.vjr.InvalidSASVersionException;
import com.sas.tools.installs.it.vjr.SASVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class VJRList {
    private static final Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.vjr.Vjrlist");
    public static final String VJR_LIST_NAME = "vjrlist";
    private Integer version = null;
    private final HashSet<SASVersion> pluginList = new HashSet();

    public int size() {
        return this.pluginList.size();
    }

    public void addPluginVersion(SASVersion sasVersion) {
        this.pluginList.add(sasVersion);
    }

    public Set<SASVersion> getPluginSet() {
        return this.pluginList;
    }

    public void write(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("Vjrlist cannot write to null File!");
        }
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            this.write(fos);
        }
    }

    public static VJRList read(File file) throws IOException, InvalidSASVersionException {
        if (file == null) {
            throw new NullPointerException("Vjrlist cannot read from null File!");
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("Vjrlist cannot read a non-existent file: " + file);
        }
        VJRList ret = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            ret = VJRList.read(fis);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static VJRList read(InputStream inputStream) throws IOException, InvalidSASVersionException {
        VJRList vjrlist = new VJRList();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String line = null;
        VjrlistPart lastPart = null;
        String name = null;
        String version = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            String[] parts = line.split("=", 2);
            if (parts.length != 2) {
                throw new IllegalStateException("Invalid vjrlist line " + line);
            }
            String property = parts[0].trim();
            String value = parts[1].trim();
            VjrlistPart part = VjrlistPart.parse(property);
            if (vjrlist.version != null) {
                if (part == VjrlistPart.NAME) {
                    if (lastPart == VjrlistPart.NAME) {
                        throw new IllegalStateException("name= not valid here: " + (Object)((Object)lastPart));
                    }
                    if (name != null && version != null) {
                        vjrlist.pluginList.add(new SASVersion(name + "_" + version));
                    }
                    name = value;
                    version = null;
                } else {
                    if (part != VjrlistPart.VERSION) {
                        log.error("Found part " + (Object)((Object)part));
                        throw new IllegalStateException("Unexpected vjrlist entry part on " + line);
                    }
                    if (lastPart != VjrlistPart.NAME) {
                        throw new IllegalStateException("version= not valid here: " + (Object)((Object)lastPart));
                    }
                    version = value;
                }
            } else {
                if (part != VjrlistPart.PICKLIST_VERSION) {
                    log.error("Expected part " + (Object)((Object)VjrlistPart.PICKLIST_VERSION) + ", found " + (Object)((Object)part));
                    throw new IllegalStateException("Expecting vjrlist version in " + line);
                }
                if (!value.equals("1")) {
                    throw new IllegalArgumentException("Unsupported vjrlist version " + value);
                }
                vjrlist.version = 1;
            }
            lastPart = part;
        }
        if (name != null && version != null) {
            vjrlist.pluginList.add(new SASVersion(name + "_" + version));
        }
        return vjrlist;
    }

    protected String toPicklistString(SASVersion sasVersion) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("name");
        pw.print("=");
        pw.println(sasVersion.getPluginName());
        pw.print("version");
        pw.print("=");
        pw.print(sasVersion.getVersion());
        return sw.toString();
    }

    public void write(OutputStream outputStream) throws UnsupportedEncodingException {
        if (this.version == null) {
            this.version = new Integer(1);
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        pw.print("PickList-Version");
        pw.print("=");
        pw.println(this.version);
        for (SASVersion sasVersion : this.pluginList) {
            pw.println("");
            pw.println(this.toPicklistString(sasVersion));
        }
        pw.flush();
    }

    private static enum VjrlistPart {
        PICKLIST_VERSION,
        NAME,
        VERSION,
        OPTIONAL;

        public static final String PICKLIST_VERSION_PROPERTY = "PickList-Version";
        public static final String NAME_V1_PROPERTY = "name";
        public static final String VERSION_V1_PROPERTY = "version";
        public static final String OPTIONAL_V1_PROPERTY = "optional";

        public static VjrlistPart parse(String property) {
            VjrlistPart part;
            if (property.equals(NAME_V1_PROPERTY)) {
                part = NAME;
            } else if (property.equals(VERSION_V1_PROPERTY)) {
                part = VERSION;
            } else if (property.equals(OPTIONAL_V1_PROPERTY)) {
                part = OPTIONAL;
            } else if (property.equals(PICKLIST_VERSION_PROPERTY)) {
                part = PICKLIST_VERSION;
            } else {
                throw new IllegalArgumentException("Unknown picklist part: " + property);
            }
            return part;
        }
    }
}

