/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.vjr;

import com.sas.tools.installs.it.UnicodeInputStream;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.vjr.VJRConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileListData
implements VJRConstants {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_SIZE = "size";
    public static final String ATTRIBUTE_TIME = "time";
    public static final String ATTRIBUTE_CHECKSUM = "checksum";
    public static final String ATTRIBUTE_ALTSKU = "alt_sku";
    private final String ROOT_ELEM = "filelist";
    private final String SKUPKG_ELEM = "skupkg";
    private final String SKUDAT_ELEM = "skudat";
    private final String FILE_ELEM = "file";
    private File m_file = null;
    private Document m_doc = null;
    private Element m_root = null;
    private DirList m_skupkgList = null;
    private DirList m_skudatList = null;

    public FileListData(String file) throws IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public FileListData(File file) throws IOException, ParserConfigurationException, SAXException {
        this.m_file = file;
        this.m_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file));
        this.m_root = this.m_doc.getDocumentElement();
        if (this.m_root != null && "filelist".equals(this.m_root.getTagName())) {
            NodeList nodes = this.m_root.getElementsByTagName("skupkg");
            if (nodes != null && nodes.getLength() > 0) {
                this.m_skupkgList = new DirList((Element)nodes.item(0));
            }
            if ((nodes = this.m_root.getElementsByTagName("skudat")) != null && nodes.getLength() > 0) {
                this.m_skudatList = new DirList((Element)nodes.item(0));
            }
        }
    }

    public DirList getSkuDatDirList() {
        return this.m_skudatList;
    }

    public DirList getSkuPkgDirList() {
        return this.m_skupkgList;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getAttribute(String name) {
        return this.m_root.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() throws IOException, TransformerException {
        boolean retVal = false;
        if ((this.m_file.getParentFile().isDirectory() || this.m_file.getParentFile().mkdirs()) && !this.m_file.isFile()) {
            this.m_file.createNewFile();
        }
        if (this.m_file.isFile()) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(this.m_file);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource(this.m_doc), new StreamResult(stream));
                retVal = true;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        retVal = false;
                    }
                }
            }
            Utils.removeBlankLines(this.m_file);
        }
        return retVal;
    }

    public class DirList {
        private Element m_skudirElem = null;
        private Map<String, SkuFile> m_skuFiles = new HashMap<String, SkuFile>();

        public DirList(Element skudirElem) {
            this.m_skudirElem = skudirElem;
            NodeList nodes = FileListData.this.m_root.getElementsByTagName("file");
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    SkuFile skuFile = new SkuFile((Element)nodes.item(i));
                    String name = skuFile.getAttribute(FileListData.ATTRIBUTE_NAME);
                    if (name == null) continue;
                    this.m_skuFiles.put(name, skuFile);
                }
            }
        }

        public String getAttribute(String name) {
            return this.m_skudirElem.getAttribute(name);
        }

        public SkuFile getSkuFile(String name) {
            return this.m_skuFiles.get(name);
        }

        public Set<String> getSkuFileNames() {
            return this.m_skuFiles.keySet();
        }

        public Collection<SkuFile> getSkuFiles() {
            return this.m_skuFiles.values();
        }

        public SkuFile removeSkuFileByName(String name) {
            SkuFile skuFile = this.m_skuFiles.remove(name);
            if (skuFile != null) {
                this.m_skudirElem.removeChild(skuFile.m_skufileElem);
            }
            return skuFile;
        }

        public SkuFile getExistingOrCreateSkuFile(String name) {
            SkuFile skuFile = this.getSkuFile(name);
            if (skuFile == null) {
                skuFile = new SkuFile(name);
                this.m_skudirElem.appendChild(skuFile.m_skufileElem);
            }
            return skuFile;
        }

        public class SkuFile {
            private Element m_skufileElem = null;

            protected SkuFile(String filename) {
                this.m_skufileElem = FileListData.this.m_doc.createElement("file");
                this.setAttribute(FileListData.ATTRIBUTE_NAME, filename);
            }

            protected SkuFile(Element skufileElem) {
                this.m_skufileElem = skufileElem;
            }

            public void setAttribute(String name, String value) {
                this.m_skufileElem.setAttribute(name, value);
            }

            public String getAttribute(String name) {
                return this.m_skufileElem.getAttribute(name);
            }
        }
    }
}

