/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.schema.install.gen.FileList;
import com.sas.tools.installs.it.schema.install.gen.RunApplication;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.LogLineWriter;
import com.sas.tools.installs.it.tasks.NullWriter;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.resource.InputStreamConsumer;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.Level;

public class RunApplicationTask
extends InstallationTask {
    protected String _application;
    protected String _args;
    protected boolean _postOutputAsProgress = true;
    protected boolean _runAtPostProcess = false;

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void preExecute() throws Exception {
        StringBuffer logString = new StringBuffer(this.getEnBundle().messageString("ExecuteExternalApplication.PreExecuteBegin", this.getApplication()));
        StringBuffer notification = new StringBuffer(this.getBundle().messageString("ExecuteExternalApplication.PreExecuteBegin", this.getApplication()));
        if (this.getArgs() != null) {
            logString.append(this.getEnBundle().messageString("ExecuteExternalApplication.PreExecuteEnd") + this.getArgs());
            notification.append(this.getBundle().messageString("ExecuteExternalApplication.PreExecuteEnd") + this.getArgs());
        }
        this.notifySetup(notification.toString(), logString.toString());
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
    }

    @Override
    public void execute() {
        if (this.isUndo()) {
            return;
        }
        if (this.runAtPostProcess()) {
            String key = this.getController().getAltSku().concat(this.getClass().getName());
            this.getController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(true, this.getClass().getName(), "postInstall"));
            this.getController().getPostProcessingQueue().add(new ProcessingTask(this, this.getClass(), "postInstall"));
            this.log.info("RunApplication for \"" + this.getApplication() + "\" added to post processing queue.");
            this.log.info("The application will be run at the end of the install processing.");
        } else {
            this.log.info("execute() - else");
            this.launchApplication();
        }
    }

    public int launchApplication() throws InstallException {
        int returnCode = -1;
        if (this.executeOnCurrentHost()) {
            if (this.userCheck()) {
                File moveTargetDest;
                Vector<String> args = new Vector<String>();
                args.add(this.getApplication());
                args.addAll(Arrays.asList(this.getArgs().split("\\s+")));
                if (TaskHelper.getOS() != 1 && TaskHelper.getOS() != 8 && this.getApplication().endsWith("/mv") && (moveTargetDest = this.getMoveTargetDest(args)) != null && moveTargetDest.exists()) {
                    this.log.info("Destination already exists, mv command will not be performed: " + args.toString());
                    return 0;
                }
                FileList fileList = this.getFileList();
                if (fileList != null) {
                    List<String> files = this.getFileList().getFile();
                    for (String name : files) {
                        Vector<String> cmdArgs = new Vector<String>(args);
                        cmdArgs.add(this.resolveProperty(name));
                        this.executeProcess(cmdArgs);
                    }
                } else {
                    returnCode = this.executeProcess(args);
                }
            } else {
                this.log.info("Could not execute " + this.getApplication() + " because the action requires the user to be " + this.getAsUser());
                return -1;
            }
        }
        return returnCode;
    }

    public int postInstall() throws InstallException {
        return this.launchApplication();
    }

    private File getMoveTargetDest(Vector<String> args) {
        File dest = null;
        if (args.size() == 3) {
            dest = new File(args.lastElement());
        }
        return dest;
    }

    private boolean userCheck() {
        this.log.debug("RunApplication running " + this.getApplication() + " as " + this.getAsUser());
        if (this.getAsUser() != null) {
            String username = System.getProperty("user.name");
            return username != null && username.equalsIgnoreCase(this.getAsUser());
        }
        return true;
    }

    public int executeProcess(Vector<String> cmdArgs) {
        Writer stdErrWriter;
        Writer stdOutWriter;
        ProcessBuilder pb = new ProcessBuilder(cmdArgs);
        String workingDir = this.getWorkingDir();
        int returnCode = -1;
        Process process = null;
        if (workingDir != null) {
            pb.directory(new File(workingDir));
        } else {
            workingDir = "(current: " + System.getProperty("user.dir") + ")";
        }
        if (this.isPostOutputAsProgress()) {
            stdOutWriter = new LogLineWriter(this.log, Level.INFO, "info: ");
            stdErrWriter = new LogLineWriter(this.log, Level.ERROR, "error: ");
        } else {
            stdOutWriter = new NullWriter();
            stdErrWriter = new NullWriter();
        }
        try {
            process = pb.start();
            if ("pcfilesrv".equalsIgnoreCase(this.getController().getProperty("12ByteCode"))) {
                Thread.sleep(10000L);
            }
            InputStreamConsumer stdoutConsumer = new InputStreamConsumer(process.getInputStream(), stdOutWriter);
            InputStreamConsumer stderrConsumer = new InputStreamConsumer(process.getErrorStream(), stdErrWriter);
            stdoutConsumer.start();
            stderrConsumer.start();
            this.notifyProgressStart("Executing " + this.getApplication() + " from working directory " + workingDir);
            returnCode = process.waitFor();
        }
        catch (Exception e) {
            throw new InstallException(1, this, null, "Could not execute " + this.getApplication() + " with args " + cmdArgs.toArray().toString(), e);
        }
        finally {
            try {
                stdOutWriter.close();
                stdErrWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (returnCode != 0) {
            if ((returnCode == 1056 || returnCode == 1062) && this.getApplication().indexOf("sc.exe") > 1) {
                if (returnCode == 1056) {
                    this.log.info("Service was already started. Return code is " + returnCode);
                } else if (returnCode == 1062) {
                    this.log.info("Service was already stopped. Return code is " + returnCode);
                }
                returnCode = 0;
            } else {
                throw new InstallException(1, this, null, this.getApplication() + " with args " + this.getArgs() + " exited with non-zero return code:  " + returnCode, null);
            }
        }
        this.notifyProgressComplete("Successfully Executed " + this.getApplication());
        return returnCode;
    }

    private String getApplication() {
        return this.resolveProperty(((RunApplication)this.getData()).getName());
    }

    private String getArgs() {
        return this.resolveProperty(((RunApplication)this.getData()).getArgs());
    }

    private String getAsUser() {
        return ((RunApplication)this.getData()).getAsUser();
    }

    private boolean isPostOutputAsProgress() {
        return ((RunApplication)this.getData()).isPostOutput();
    }

    private FileList getFileList() {
        return ((RunApplication)this.getData()).getFileList();
    }

    private String getWorkingDir() {
        String workingDir = ((RunApplication)this.getData()).getWorkingDirectory();
        if (workingDir != null) {
            workingDir = this.resolveProperty(workingDir);
        }
        return workingDir;
    }

    private boolean runAtPostProcess() {
        return ((RunApplication)this.getData()).isRunAtPostProcess();
    }

    @Override
    public String descriptionForLog() {
        return null;
    }
}

