/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.schema.install.gen.RegisterFonts;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.resource.FileSystem;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegisterFontsTask
extends InstallationTask
implements InstallationProgressListener {
    private static final String FONT_BACKUP_PATH = "SystemFonts/backup";
    private static final String REGISTER_FONTS_LOG = "RegisterFonts.log";
    private static final String WINDOWS_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
    private static final String FONT_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Fonts";
    private static final String TASK_NAME = "RegisterFonts";
    private static final String REGISTRY_FILE = "regstry.sas7bitm";
    public static boolean diskSpaceMessaged = false;
    private final Set<com.sas.tools.installs.it.schema.install.gen.Font> installed = new HashSet<com.sas.tools.installs.it.schema.install.gen.Font>();
    private final Set<com.sas.tools.installs.it.schema.install.gen.Font> registeredSystem = new HashSet<com.sas.tools.installs.it.schema.install.gen.Font>();
    private final Set<com.sas.tools.installs.it.schema.install.gen.Font> registeredJava = new HashSet<com.sas.tools.installs.it.schema.install.gen.Font>();
    private static Set<File> registeredSAS = new HashSet<File>();
    private final Set<EntryData> registryEntryData = new HashSet<EntryData>();

    public RegisterFontsTask() {
        NotificationHandler.defaultHandler().addProgressListener(this);
    }

    public RegisterFontsTask(Controller controller) {
        super(controller);
    }

    @Override
    public void preExecute() throws Exception {
        for (com.sas.tools.installs.it.schema.install.gen.Font f : this.getFonts()) {
            if (f.getPath() != null) continue;
            throw new InstallException(2, this, this.getBundle().messageString("RegisterFonts.FontPathRequired", TASK_NAME), this.getEnBundle().messageString("RegisterFonts.FontPathRequired", TASK_NAME), null);
        }
        File keyFile = new File(Utils.joinPath(this.getController().getProperty("ProductHome"), FONT_BACKUP_PATH), "batang.ttc");
        if (!diskSpaceMessaged) {
            if (!keyFile.exists()) {
                EntryData data = new EntryData(keyFile.getAbsolutePath());
                data.setSize(new Long(410000000L));
                this.notifySetup("Added", data, null);
                this.notifySetup("Checked", data, null);
            }
            diskSpaceMessaged = true;
        }
        try {
            this.unserializeFonts();
        }
        catch (Exception e) {
            this.log.warn("An error occurred while unserializing registerFonts.ser file");
        }
        super.preExecute();
    }

    @Override
    public void execute() {
    }

    @Override
    public void postExecute() {
        for (com.sas.tools.installs.it.schema.install.gen.Font f : this.getFonts()) {
            if (this.isUndo()) continue;
            File sourceFont = this.getPath(f);
            if (sourceFont.exists()) {
                if (TaskHelper.isWindows()) {
                    if (!Utils.getMd5sum(sourceFont.getPath()).equals(Utils.getMd5sum(this.getDestination(f).getPath()))) {
                        this.copy(f, this.getDestination(f));
                    }
                    this.registerSystemFont(f);
                    if (registeredSAS.size() == 0) {
                        if (Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
                            String key = this.getController().getAltSku().concat(this.getClass().getName());
                            this.getController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(true, this.getClass().getName(), "postProcessing"));
                            this.getController().getPostProcessingQueue().add(new ProcessingTask(this, this.getClass(), "postProcessing"));
                        } else {
                            this.postProcessing();
                        }
                    }
                    registeredSAS.add(sourceFont);
                    try {
                        this.serializeFonts();
                    }
                    catch (Exception e) {
                        this.log.warn("An error occurred while serializing registerFonts.ser file");
                    }
                    continue;
                }
                if (TaskHelper.isUnix()) {
                    this.registerJavaFont(f, this.getJavaDestination(f));
                    continue;
                }
                this.log.info("No font registration performed on " + TaskHelper.getOS_Suffix());
                continue;
            }
            this.log.warn("Font file is missing therefore font will not be registered: " + sourceFont);
        }
    }

    @Override
    public void retry() {
        for (com.sas.tools.installs.it.schema.install.gen.Font f : this.getFonts()) {
            if (TaskHelper.isWindows()) {
                File path;
                if (!this.installed.contains(f)) {
                    this.installFont(f, this.getDestination(f));
                }
                if (!this.registeredSystem.contains(f)) {
                    this.registerSystemFont(f);
                }
                if (this.registeredSystem.contains(path = this.getPath(f))) continue;
                registeredSAS.add(path);
                continue;
            }
            if (!TaskHelper.isUnix() || this.registeredJava.contains(f)) continue;
            this.registerJavaFont(f, this.getJavaDestination(f));
        }
    }

    @Override
    public void rollback() {
        EntryData fontEntryData;
        for (com.sas.tools.installs.it.schema.install.gen.Font f : new HashSet<com.sas.tools.installs.it.schema.install.gen.Font>(this.registeredSystem)) {
            this.unregisterSystemFont(f);
            fontEntryData = this.getFontEntryData(this.getDestination(f));
            fontEntryData.notifyRestoreForTask(this);
            fontEntryData.performRestoreForTask(this);
            this.registerSystemFont(f);
        }
        for (com.sas.tools.installs.it.schema.install.gen.Font f : new HashSet<com.sas.tools.installs.it.schema.install.gen.Font>(this.registeredJava)) {
            fontEntryData = this.getFontEntryData(this.getJavaDestination(f));
            fontEntryData.notifyRestoreForTask(this);
            fontEntryData.performRestoreForTask(this);
        }
        registeredSAS.clear();
    }

    @Override
    public String descriptionForLog() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.getFonts().size(); ++i) {
            com.sas.tools.installs.it.schema.install.gen.Font f = this.getFonts().get(i);
            params.put("font path " + i, f.getPath());
            params.put("font face " + i, f.getFace());
        }
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    public static String getTaskName() {
        return TASK_NAME;
    }

    protected void copy(com.sas.tools.installs.it.schema.install.gen.Font f, File destinationFont) {
        this.backupFont(f, destinationFont);
        this.installFont(f, destinationFont);
    }

    private void backupFont(com.sas.tools.installs.it.schema.install.gen.Font f, File destinationFont) {
        EntryData fontEntryData = this.getFontEntryData(destinationFont);
        if (!destinationFont.exists()) {
            if (this.getFace(f) == null) {
                this.log.info(this.getEnBundle().messageString("RegisterFonts.FontFaceRequired", TASK_NAME));
                this.log.info("The font will work for this session, but may not work after reboot");
            }
            this.notifySetup("Added", fontEntryData, null);
        } else if (!destinationFont.getName().endsWith(".fon")) {
            File backupDir = new File(this.getController().getProperty("ProductHome"), FONT_BACKUP_PATH);
            File backupFont = new File(backupDir, destinationFont.getName());
            this.copyFile(destinationFont, backupFont);
            this.notifySetup("Changed", fontEntryData, null);
        }
    }

    private File getPath(com.sas.tools.installs.it.schema.install.gen.Font f) {
        return new File(Utils.fixPathSlashes(this.resolveProperty(f.getPath())));
    }

    protected String getFace(com.sas.tools.installs.it.schema.install.gen.Font f) {
        String face = null;
        String path = this.getPath(f).getAbsolutePath();
        try {
            if (path.endsWith(".fon")) {
                Pattern p = Pattern.compile("sas([^.]+)\\.fon$");
                Matcher m = p.matcher(path);
                if (m.find()) {
                    String codepage = m.group(1);
                    face = "1252".equals(codepage) ? "Sasfont 1252 Character Set" : "Sasfont Codepage " + codepage;
                }
            } else {
                File file = new File(path);
                Font font = Font.createFont(0, file);
                face = font.getFontName();
            }
        }
        catch (Exception e) {
            this.log.error("Could not read " + path + " to determine font face name", (Throwable)e);
        }
        return face;
    }

    private void installFont(com.sas.tools.installs.it.schema.install.gen.Font f, File destinationFont) {
        boolean lockedFont = false;
        File sourceFont = this.getPath(f);
        if (destinationFont.exists()) {
            this.unregisterSystemFont(f);
        }
        try {
            this.log.info("Attempting to copy " + sourceFont + " to " + destinationFont);
            this.getFS().copyFile(sourceFont, destinationFont);
            this.log.info("The font file was successfully copied");
            this.installed.add(f);
        }
        catch (IOException e) {
            lockedFont = true;
            this.log.info(destinationFont + " is locked: " + e.getMessage());
        }
        if (lockedFont && TaskHelper.isWindows()) {
            String DATE_FORMAT_NOW = "yyyy-MM-dd-HH.mm.ss";
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
            File destFont = new File(destinationFont.getParentFile(), destinationFont.getName() + "-" + sdf.format(cal.getTime()) + ".tmp");
            try {
                this.log.info("Attempting to copy " + sourceFont + " to temporary file " + destFont);
                this.getFS().copyFile(sourceFont, destFont);
                this.log.info("The font file was successfully copied to a temporary file");
                this.installed.add(f);
            }
            catch (IOException e) {
                this.log.info("Failed to copy to temporary file", (Throwable)e);
                throw new InstallException(1, this, this.getBundle().messageString("RegisterFonts.CanNotCopyFile", sourceFont, destFont), this.getEnBundle().messageString("RegisterFonts.CanNotCopyFile", sourceFont, destFont), e);
            }
            if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)SASWinAPI.libNames)) {
                String missingLib = JNIUtils.getJniLib((HashMap)SASWinAPI.libNames);
                throw new InstallException(1, null, this.getBundle().messageString("Controller.MissingJNILib", missingLib), this.getEnBundle().messageString("Controller.MissingJNILib", missingLib), null);
            }
            if (SASWinAPI.MoveFileEx((String)destFont.getAbsolutePath(), (String)destinationFont.getAbsolutePath(), (int)5)) {
                this.log.info("The font file " + destinationFont.getAbsolutePath() + " is locked and the new font will be replaced when the system is rebooted");
            } else {
                this.log.info("The font file " + destinationFont.getAbsolutePath() + " is locked and the new font will have to be installed manually. The font to install is located at " + sourceFont.getAbsolutePath());
            }
        }
    }

    private void registerSystemFont(com.sas.tools.installs.it.schema.install.gen.Font f) {
        String face;
        if (!TaskHelper.isWindows()) {
            return;
        }
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)SASWinAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib((HashMap)SASWinAPI.libNames);
            throw new InstallException(1, this, this.getBundle().messageString("Controller.MissingJNILib", missingLib), this.getEnBundle().messageString("Controller.MissingJNILib", missingLib), null);
        }
        String sysPath = this.getDestination(f).getAbsolutePath();
        boolean rc = SASWinAPI.registerFont((String)sysPath);
        this.log.info("registerFont returned " + rc);
        if (rc) {
            this.registeredSystem.add(f);
        }
        if ((face = this.getFace(f)) != null) {
            try {
                WinRegAPI.SetRegValue((int)8, (String)FONT_KEY, (String)face, (String)this.getDestination(f).getName(), (int)109);
                this.log.info("register font face returned " + rc);
            }
            catch (Exception e) {
                throw new InstallException(1, this, this.getBundle().messageString("RegisterFonts.CanNotRegisterFace", face, sysPath), this.getEnBundle().messageString("RegisterFonts.CanNotRegisterFace", face, sysPath), e);
            }
        } else {
            throw new InstallException(2, this, this.getBundle().messageString("RegisterFonts.CanNotDetermineFace", sysPath), this.getEnBundle().messageString("RegisterFonts.CanNotDetermineFace", sysPath), null);
        }
    }

    private void unregisterSystemFont(com.sas.tools.installs.it.schema.install.gen.Font f) {
        if (!TaskHelper.isWindows()) {
            return;
        }
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)SASWinAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib((HashMap)SASWinAPI.libNames);
            throw new InstallException(1, this, this.getBundle().messageString("Controller.MissingJNILib", missingLib), this.getEnBundle().messageString("Controller.MissingJNILib", missingLib), null);
        }
        boolean rc = SASWinAPI.unregisterFont((String)this.getDestination(f).getAbsolutePath());
        if (rc) {
            this.registeredSystem.remove(f);
        }
        this.log.info("unregisterFont returned " + rc);
    }

    protected void registerJavaFont(com.sas.tools.installs.it.schema.install.gen.Font f, File destinationFont) {
        String libFonts = this.getJRELibFonts();
        if (Utils.canWriteToPath(libFonts)) {
            if (!Utils.getMd5sum(this.getPath(f)).equals(Utils.getMd5sum(this.getJavaDestination(f).getPath()))) {
                this.copy(f, destinationFont);
            }
            if (destinationFont.exists()) {
                this.registeredJava.add(f);
            }
        } else {
            this.log.error("Can not write to " + libFonts + ", so can not copy Java fonts");
        }
    }

    public int postProcessing() {
        int returnCode = 0;
        if (registeredSAS.size() > 0) {
            returnCode = this.registerSASFonts();
        }
        return returnCode;
    }

    private int registerSASFonts() {
        int returnCode = 0;
        TreeSet<File> fontPaths = new TreeSet<File>();
        for (File path : registeredSAS) {
            if (path.getName().endsWith(".fon")) continue;
            fontPaths.add(path.getParentFile());
        }
        File fontsScript = null;
        try {
            fontsScript = this.writeFontScript(fontPaths);
        }
        catch (FileNotFoundException e) {
            this.log.error(this.getEnBundle().messageString("RegisterFonts.ScriptWriteFailure", fontsScript), (Throwable)e);
            return -1;
        }
        for (String lang : this.getSASConfigLanguages()) {
            ProcessBuilder pb = null;
            if (TaskHelper.isWindows() && this.getSASExe().exists()) {
                List<String> args = this.getSASBatchArgs(fontsScript, REGISTER_FONTS_LOG);
                args.add("-config");
                args.add(this.getSASConfigFile(lang).getPath());
                pb = new ProcessBuilder(args);
                File registryFile = this.getRegistryFile(lang);
                if (registryFile.isFile()) {
                    this.registryEntryData.add(new EntryData(registryFile));
                }
            }
            if (pb != null) {
                this.log.info("Starting registration of fonts with SAS for " + lang);
                int rc = 0;
                try {
                    rc = InstallationTask.executeProcess(pb, this.log);
                    if (rc != 0) {
                        returnCode = rc;
                    }
                    for (EntryData data : this.registryEntryData) {
                        data.flushMd5();
                        this.notifySetup("Changed", data, null);
                        this.notifyProgressComplete("Changed", data);
                    }
                }
                catch (Exception e) {
                    this.log.error(this.getEnBundle().messageString("InstallationTask.OperationFailedEx", pb.command()), (Throwable)e);
                    returnCode = -1;
                }
                this.processSASOutput(rc, this.getSASLog(REGISTER_FONTS_LOG));
                continue;
            }
            this.log.info("Could not invoke SAS to register fonts.");
            this.log.info("Manual registration can be accomplised by running " + fontsScript + " in SAS");
        }
        if (this.getSASExe().exists() && returnCode == 0) {
            fontsScript.delete();
            File dir = new File(this.getInstallMisc().toString());
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                String fileDelete;
                File file;
                if (!files[i].endsWith(".sas7bcat") && !files[i].endsWith(".sas7bitm") || (file = new File(fileDelete = this.getInstallMisc().toString() + File.separator + files[i])) == null || !file.exists()) continue;
                file.delete();
            }
        }
        return returnCode;
    }

    private File writeFontScript(Set<File> fontPaths) throws FileNotFoundException {
        File installMisc = new File(RegisterFontsTask.getSASHome(), "InstallMisc");
        File fontsScript = new File(installMisc, "RegisterFonts.sas");
        String proc_fontreg = "proc fontreg mode=all usesashelp msglevel=normal;";
        String fontpath = "fontpath \"{0}\";";
        String run = "run;";
        PrintWriter pw = new PrintWriter(fontsScript);
        pw.println("proc fontreg mode=all usesashelp msglevel=normal;");
        pw.println(MessageFormat.format("fontpath \"{0}\";", this.getSystemFontDirectory()));
        pw.println("run;");
        for (File originalPath : fontPaths) {
            pw.println("proc fontreg mode=all usesashelp msglevel=normal;");
            pw.println(MessageFormat.format("fontpath \"{0}\";", originalPath));
            pw.println("run;");
        }
        pw.close();
        return fontsScript;
    }

    private Set<String> getSASConfigLanguages() {
        HashSet<String> langs = new HashSet<String>();
        String sasRoot = this.getSASFoundationRoot();
        File nlsFolder = new File(this.getFS().append(sasRoot, "nls"));
        if (nlsFolder.isDirectory()) {
            for (File langDir : nlsFolder.listFiles()) {
                String lang;
                if (!langDir.isDirectory() || "u8".equals(lang = langDir.getName()) || "dbcs".equals(lang)) continue;
                langs.add(lang);
            }
        }
        return langs;
    }

    private File getRegistryFile(String language) {
        File registryFile = null;
        String sasRoot = this.getSASFoundationRoot();
        if (TaskHelper.isWindows()) {
            registryFile = "en".equals(language) ? new File(this.getFS().append(sasRoot, "core", "sashelp", REGISTRY_FILE)) : new File(this.getFS().append(sasRoot, "nls", language, "sashelp", REGISTRY_FILE));
        } else if (TaskHelper.isUnix()) {
            registryFile = new File(this.getFS().append(sasRoot, "nls", language, "sascfg", REGISTRY_FILE));
        }
        return registryFile;
    }

    private File getDestination(com.sas.tools.installs.it.schema.install.gen.Font f) {
        return new File(this.getSystemFontDirectory(), this.getPath(f).getName());
    }

    private File getJavaDestination(com.sas.tools.installs.it.schema.install.gen.Font f) {
        return new File(this.getJRELibFonts(), this.getPath(f).getName());
    }

    private EntryData getFontEntryData(File destinationFont) {
        EntryData fontEntryData = new EntryData(destinationFont);
        fontEntryData.setNew(!destinationFont.exists());
        return fontEntryData;
    }

    private List<com.sas.tools.installs.it.schema.install.gen.Font> getFonts() {
        return ((RegisterFonts)this.getData()).getFonts().getFont();
    }

    private File getSystemFontDirectory() {
        return new File(this.getSystemDirectory(), "Fonts");
    }

    private File getSystemDirectory() {
        return new File(this.getController().getProperty("WINDIR"));
    }

    private String getJRELibFonts() {
        return new File(this.getController().getProperty("JREHOME"), "lib/fonts").getAbsolutePath();
    }

    private FileSystem getFS() {
        return this.getController().getFS();
    }

    @Override
    public void bytesMoved(long numBytes) {
    }

    @Override
    public void installCompletedAction() {
    }

    @Override
    public void installStartedAction() {
    }

    @Override
    public void progressBeginningAction(String action, EntryData metaData) {
    }

    @Override
    public void progressBeginningAction(String description) {
    }

    @Override
    public void progressCompleteAction(String action, EntryData metaData) {
        if (("Added".equals(action) || "Changed".equals(action)) && metaData.getName().endsWith("REGISTRY_FILE")) {
            this.registryEntryData.add(metaData);
        }
    }

    @Override
    public void progressCompleteAction(String description) {
    }

    @Override
    public void progressFailedAction(String action, EntryData metaData) {
    }

    @Override
    public void taskStartedAction(InstallationTask task) {
    }

    private void unserializeFonts() throws IOException, ClassNotFoundException {
        if (Controller.installProperties.getProperty("sdw.resume.chain") == "TRUE") {
            FileInputStream fileInput = new FileInputStream(Utils.joinPath(Controller.installProperties.getProperty("sdw.log.path"), "registerFonts.ser"));
            ObjectInputStream in = new ObjectInputStream(fileInput);
            registeredSAS = (Set)in.readObject();
            in.close();
            fileInput.close();
        }
    }

    private void serializeFonts() throws IOException {
        FileOutputStream fileOutput = new FileOutputStream(Utils.joinPath(Controller.installProperties.getProperty("sdw.log.path"), "registerFonts.ser"));
        ObjectOutputStream out = new ObjectOutputStream(fileOutput);
        out.writeObject(registeredSAS);
        out.close();
        fileOutput.close();
    }
}

