/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.schema.install.gen.ModifyIni;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ModifyIniTask
extends InstallationTask {
    protected Map<String, Map<String, String>> ini;

    @Override
    public void preExecute() throws Exception {
        if (TaskHelper.getOS() != 8) {
            if (this.getIniFile() == null) {
                throw new InstallException(1, this, this.getBundle().messageString("IniModify.IniFileRequired"), "iniFile is a required attribute for the iniModify task", null);
            }
            if (this.getModificationXml() == null) {
                throw new InstallException(2, this, this.getBundle().messageString("IniModify.ModificationXmlRequired"), "modificationXml is a required attribute for the iniModify task", null);
            }
            if (!this.getController().getFS().exists(this.getModificationXml())) {
                throw new InstallException(2, this, this.getBundle().messageString("IniModify.ModificationXmlMustExist", this.getModificationXml()), "modification XML file must exist", null);
            }
            super.preExecute();
        }
    }

    @Override
    public void execute() throws InstallException {
        if (TaskHelper.getOS() != 8) {
            if (this.getController().getFS().exists(this.getIniFile())) {
                try {
                    this.parseIni(this.getIniFile());
                    XMLReader parser = XMLReaderFactory.createXMLReader();
                    InputStream is = this.getController().getFS().getInputStream(this.getModificationXml());
                    IniXmlHandler handler = new IniXmlHandler();
                    parser.setContentHandler(handler);
                    parser.parse(new InputSource(new InputStreamReader(is)));
                }
                catch (Exception e) {
                    throw new InstallException(2, this, this.getBundle().messageString("IniModify.CanNotReadFile", this.getModificationXml()), "Can not read file", e);
                }
                try {
                    BufferedWriter bw = this.getWriter();
                    for (String section : this.getIni().keySet()) {
                        if (section != null) {
                            bw.append("[" + section + "]");
                            bw.newLine();
                        }
                        for (String key : this.getIni().get(section).keySet()) {
                            String val = this.getIni().get(section).get(key);
                            if ("MASTERPROP".equalsIgnoreCase(key)) {
                                val = val.replace("@SASHOME@", System.getProperty("SASHome"));
                            }
                            bw.append(key + "=" + val);
                            bw.newLine();
                        }
                        bw.newLine();
                    }
                    bw.flush();
                }
                catch (Exception e) {
                    throw new InstallException(1, this, this.getBundle().messageString("IniModify.CanNotWriteFile", this.getModificationXml()), "Can not write file", e);
                }
            }
            throw new InstallException(1, this, this.getBundle().messageString("IniModify.IniFileMustExist", this.getIniFile()), "ini file must exist", null);
        }
    }

    protected void parseIni(String path) throws IOException {
        String line;
        String section = null;
        InputStream is = this.getController().getFS().getInputStream(path);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Pattern sectionRegex = Pattern.compile("^\\[([^]]+)\\]");
        Pattern keyValueRegex = Pattern.compile("^\\s*([^=]+)=(.*)$");
        LinkedHashMap<String, String> props = null;
        this.ini = new LinkedHashMap<String, Map<String, String>>();
        while ((line = br.readLine()) != null) {
            Matcher sectionMatch = sectionRegex.matcher(line);
            Matcher keyValueMatch = keyValueRegex.matcher(line);
            if (sectionMatch.matches()) {
                if (props != null) {
                    this.ini.put(section, props);
                }
                section = sectionMatch.group(1);
                props = null;
                continue;
            }
            if (!keyValueMatch.matches()) continue;
            if (props == null) {
                props = new LinkedHashMap<String, String>();
            }
            props.put(keyValueMatch.group(1), keyValueMatch.group(2));
        }
        if (props != null) {
            this.ini.put(section, props);
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    @Override
    public String descriptionForLog() {
        HashMap<String, String> params = new HashMap<String, String>();
        return TaskHelper.getDescriptionForLog("IniModifyTask", params);
    }

    public String getIniFile() {
        return ((ModifyIni)this.getData()).getIniFile();
    }

    public String getModificationXml() {
        return this.getController().getPackageDir() + File.separator + ((ModifyIni)this.getData()).getModificationXml();
    }

    public Map<String, Map<String, String>> getIni() {
        return this.ini;
    }

    protected BufferedWriter getWriter() throws IOException {
        return new BufferedWriter(new FileWriter(this.getIniFile()));
    }

    private final class IniXmlHandler
    extends DefaultHandler {
        private static final String INI_MODIFY = "iniModify";
        private static final String SECTION = "section";
        private static final String NAME = "name";
        private static final String REMOVE = "remove";
        private static final String TRUE = "true";
        private static final String SEQUENCE = "sequence";
        private String section = null;
        private String key = null;
        private StringBuilder buffer = new StringBuilder();
        private Set<String> removedSections = new HashSet<String>();

        private IniXmlHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            boolean remove = false;
            if (SECTION.equals(name)) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (NAME.equals(attributes.getLocalName(i))) {
                        this.section = attributes.getValue(i);
                        continue;
                    }
                    if (!REMOVE.equals(attributes.getLocalName(i)) || !TRUE.equals(attributes.getValue(i))) continue;
                    remove = true;
                }
                if (remove) {
                    ModifyIniTask.this.ini.remove(this.section);
                    this.removedSections.add(this.section);
                }
            } else if (!INI_MODIFY.equals(name)) {
                this.key = name;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (SEQUENCE.equals(attributes.getLocalName(i))) {
                        this.key = this.key + "_" + attributes.getValue(i);
                        continue;
                    }
                    if (!REMOVE.equals(attributes.getLocalName(i)) || !TRUE.equals(attributes.getValue(i))) continue;
                    remove = true;
                }
                if (remove) {
                    ModifyIniTask.this.ini.get(this.section).remove(this.key);
                    this.key = null;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (SECTION.equals(name)) {
                this.section = null;
            } else if (!INI_MODIFY.equals(name) && this.key != null && !this.removedSections.contains(this.section)) {
                Map<String, String> props = ModifyIniTask.this.ini.get(this.section);
                if (props == null) {
                    props = new LinkedHashMap<String, String>();
                    ModifyIniTask.this.ini.put(this.section, props);
                }
                String temp = this.buffer.toString();
                temp.replace("\\", File.separator);
                temp.replace("/", File.separator);
                temp.replace(";", File.pathSeparator);
                temp.replace(":", File.pathSeparator);
                props.put(this.key, temp);
                this.buffer.setLength(0);
                this.key = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.key != null) {
                this.buffer.append(ch, start, length);
            }
        }
    }
}

