/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.ExtractArchive;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class ExtractArchiveTask
extends InstallationTask {
    File productHomeDir = null;
    File backupDir = null;

    @Override
    public String descriptionForLog() {
        return null;
    }

    @Override
    public void preExecute() {
        String destination = ((ExtractArchive)this.getData()).getHome();
        this.productHomeDir = new File(this.resolveProperty(destination));
        this.backupDir = this.getBackupDir();
    }

    @Override
    public void execute() throws InstallException {
        block8: {
            String archiveFilename = ((ExtractArchive)this.getData()).getFilename();
            File archiveFile = new File(this.getController().getCurrentContext().getPayloadDir(), archiveFilename);
            this.backupFiles();
            if (((ExtractArchive)this.getData()).isCleandir()) {
                this.cleanTargetDir();
            }
            this.log.info("Extracting archive " + archiveFile.getAbsolutePath() + " to " + this.productHomeDir.getAbsolutePath());
            try {
                if (!archiveFile.exists()) {
                    String msg = "Archive file does not exist: " + archiveFile.getAbsolutePath();
                    throw new InstallException(2, this, msg, msg, null);
                }
                if (archiveFilename.endsWith(".tgz")) {
                    TaskHelper.extractTaz(archiveFile.getAbsolutePath(), this.productHomeDir.getAbsolutePath());
                    break block8;
                }
                if (archiveFilename.endsWith(".zip")) {
                    TaskHelper.extractZip(archiveFile, this.productHomeDir.getAbsolutePath());
                    break block8;
                }
                String msg = "Archive type not recognized for the archive file: " + archiveFile.getAbsolutePath();
                throw new InstallException(2, this, msg, msg, null);
            }
            catch (InstallException e) {
                String msg = "Error extracting: " + archiveFile.getAbsolutePath() + " to " + this.productHomeDir;
                throw new InstallException(2, this, msg, msg, e);
            }
        }
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
        try {
            FileUtils.copyDirectory((File)this.backupDir, (File)this.productHomeDir, (boolean)true);
        }
        catch (IOException e) {
            String msg = "Error rolling back: " + this.backupDir.getAbsolutePath() + " to: " + this.productHomeDir.getAbsolutePath();
            throw new InstallException(2, this, msg, msg, e);
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    private File getBackupDir() {
        File backupDir = null;
        String DATE_FORMAT_NOW = "yyyy-MM-dd-HH.mm.ss";
        Date backupDate = Calendar.getInstance().getTime();
        String backupFormat = "'backup.'yyyy-MM-dd-HH.mm.ss";
        SimpleDateFormat sdf = new SimpleDateFormat(backupFormat);
        String backupSubDir = sdf.format(backupDate);
        String overrideBackupDir = ((ExtractArchive)this.getData()).getBackupdir();
        backupDir = overrideBackupDir != null && !overrideBackupDir.equals("") ? new File(this.resolveProperty(overrideBackupDir), backupSubDir) : new File(this.getController().getBackupRootDirectory(), backupSubDir);
        return backupDir;
    }

    private void backupFiles() throws InstallException {
        this.log.info("Backing up files from: " + this.productHomeDir.getAbsolutePath() + " to: " + this.backupDir);
        try {
            File[] files = this.productHomeDir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        String dirname = files[i].getName();
                        if (dirname.equalsIgnoreCase("installs")) continue;
                        FileUtils.copyDirectory((File)files[i], (File)this.backupDir, (boolean)true);
                        continue;
                    }
                    files[i].delete();
                }
            }
        }
        catch (IOException e) {
            String msg = "Error backing up: " + this.productHomeDir.getAbsolutePath() + " to: " + this.backupDir.getAbsolutePath();
            throw new InstallException(2, this, msg, msg, e);
        }
    }

    private void cleanTargetDir() throws InstallException {
        this.log.info("Cleaning target directory: " + this.productHomeDir.getAbsolutePath());
        try {
            File[] files = this.productHomeDir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        if (files[i].getName().equalsIgnoreCase("installs")) continue;
                        Utils.deleteFolder(files[i]);
                        continue;
                    }
                    files[i].delete();
                }
            }
        }
        catch (Exception e) {
            String msg = "Error deleteing files and directories from: " + this.productHomeDir.getAbsolutePath();
            throw new InstallException(2, this, msg, msg, e);
        }
    }
}

