/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.shortcut.ShortcutAPI;
import com.sas.tools.deployjni.shortcut.ShortcutException;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.CreateWindowsShortcut;
import com.sas.tools.installs.it.tasks.EditSASConfigTask;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.util.HashMap;

public class CreateWindowsShortcutTask
extends InstallationTask {
    public static final String ITANIUM_LIBRARY_NAME = "JNIWinItaniumShortcut.dll";
    public static final String INTEL_LIBRARY_NAME = "WinCreateShortcut.dll";
    public static final String SAS_WOW_FLAG = "*SASPLATFORM*";
    public static final String SAS_WOW_TAG = "(32) ";
    public static final boolean WINDOWS_OS = TaskHelper.getOS() == 1;
    protected String _folderName;
    protected boolean _createForAllUsers = true;
    protected String _displayName;
    protected String _targetName;
    protected String _arguments;
    protected String _startDirectoryName;
    protected String _shortcutIconFile;
    protected boolean _delete = false;
    protected boolean _changesMade = false;

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void execute() throws InstallException {
        block10: {
            if (!WINDOWS_OS) {
                this.log.info("Skipping execute for CreateWindowsShortcutTask running on non-Windows OS");
                return;
            }
            this.log.debug("Loading JNI libs from " + JNIUtils.JNI_LIB_BASE);
            if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)ShortcutAPI.libNames)) {
                String missingLib = JNIUtils.getJniLib((HashMap)ShortcutAPI.libNames);
                throw new InstallException(2, null, this._bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
            }
            if (this.isUndo()) {
                this.rollback();
                return;
            }
            if (((CreateWindowsShortcut)this.getData()).isDelete()) {
                try {
                    ShortcutAPI.deleteShortcut((String)this.getFolderName(), (String)this.getDisplayName(), (boolean)true);
                }
                catch (ShortcutException e) {
                    this.log.info("Windows shortcut could not be deleted, likely because it does not exist:" + Utils.joinPath(this.getFolderName(), this.getDisplayName()));
                }
            } else if (this.getController().getProperty("ProductLanguage").equalsIgnoreCase("xx") || this.getController().getProperty("ProductLanguage").equalsIgnoreCase("en") || this.getFolderName().contains("Additional Languages") || this.getController().getProperty("ProductLanguage").equalsIgnoreCase(EditSASConfigTask.localeToLang2(Controller.installProperties.getProperty("sashome.locale.name")))) {
                try {
                    ShortcutAPI.createShortcut((String)this.getFolderName(), (!this.isSingleUser() ? 1 : 0) != 0, (String)this.getDisplayName(), (String)this.getTargetName(), (String)this.getArguments(), (String)this.getStartDirectoryName(), (String)this.getShortcutIconFile());
                }
                catch (ShortcutException e) {
                    this.log.error("Unable to create shortcut:\n\tFolder Name:  " + this.getFolderName() + "\n\tAll Users?:  " + !this.isSingleUser() + "\n\tDisplay Name:  " + this.getDisplayName() + "\n\tTarget Name:  " + this.getTargetName() + "\n\tArguments:  " + this.getArguments() + "\n\tStart Directory Name:  " + ((CreateWindowsShortcut)this.getData()).getStartDirectoryName() + "\n\tIcon File: " + this.getShortcutIconFile());
                    this.log.error((Object)e);
                    if (Controller.silent) break block10;
                    this.getController().getView().displayConfirmationMessage("Unable to create " + this.getDisplayName() + " shortcut ", 2);
                }
            }
        }
    }

    public String shortcutDisplay() {
        StringBuffer shortcutDisplay = null;
        shortcutDisplay = this.getFolderName() != null ? new StringBuffer(Utils.joinPath(this.getFolderName(), this.getDisplayName())) : new StringBuffer(this.getDisplayName());
        if (this.getTargetName() != null) {
            shortcutDisplay.append(" -> " + this.getTargetName());
        }
        if (this.getArguments() != null) {
            shortcutDisplay.append(" " + this.getArguments());
        }
        if (((CreateWindowsShortcut)this.getData()).getStartDirectoryName() != null) {
            shortcutDisplay.append(" (start directory: " + ((CreateWindowsShortcut)this.getData()).getStartDirectoryName() + ")");
        }
        return shortcutDisplay.toString();
    }

    @Override
    public void preExecute() throws Exception {
        if (!WINDOWS_OS) {
            this.log.info("Skipping preExecute for CreateWindowsShortcutTask running on non-Windows OS");
            return;
        }
        this.setFolderName(((CreateWindowsShortcut)this.getData()).getFolderName());
        this.setDisplayName(((CreateWindowsShortcut)this.getData()).getDisplayName());
        this.setTargetName(((CreateWindowsShortcut)this.getData()).getTargetName());
        this.setArguments(((CreateWindowsShortcut)this.getData()).getArguments());
        this.setShortcutIconFile(((CreateWindowsShortcut)this.getData()).getShortcutIconFile());
        this.setStartDirectoryName(((CreateWindowsShortcut)this.getData()).getStartDirectoryName());
        if (this.isUndo()) {
            if (((CreateWindowsShortcut)this.getData()).isDelete()) {
                this.notifySetup(this.getBundle().messageString("WindowsShortcut.Restoring", this.shortcutDisplay()), this.getEnBundle().messageString("WindowsShortcut.Restoring", this.shortcutDisplay()));
            } else {
                this.notifySetup(this.getBundle().messageString("WindowsShortcut.Removing", this.shortcutDisplay()), this.getEnBundle().messageString("WindowsShortcut.Removing", this.shortcutDisplay()));
            }
        } else if (((CreateWindowsShortcut)this.getData()).isDelete()) {
            this.notifySetup(this.getBundle().messageString("WindowsShortcut.Removing", this.shortcutDisplay()), this.getEnBundle().messageString("WindowsShortcut.Removing", this.shortcutDisplay()));
        } else {
            this.notifySetup(this.getBundle().messageString("WindowsShortcut.Adding", this.shortcutDisplay()), this.getEnBundle().messageString("WindowsShortcut.Adding", this.shortcutDisplay()));
        }
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() {
        if (!this.isUndo() && !this.isChangesMade()) {
            return;
        }
        if (!WINDOWS_OS) {
            this.log.info("Skipping rollback for CreateWindowsShortcutTask running on non-Windows OS");
            return;
        }
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)ShortcutAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib((HashMap)ShortcutAPI.libNames);
            throw new InstallException(2, null, this._bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        if (!((CreateWindowsShortcut)this.getData()).isDelete()) {
            try {
                ShortcutAPI.deleteShortcut((String)this.getFolderName(), (String)this.getDisplayName(), (boolean)true);
            }
            catch (ShortcutException e) {
                this.log.info("ShortcutAPI.deleteShortcut returned " + e.getErrorType());
                if (e.getErrorType() == 3) {
                    this.log.info("Shortcut not found, deleteShortcut returned shortcutDoesntExist for shortcut with folder name " + this.getFolderName() + " and display name " + this.getDisplayName());
                }
                this.log.error("Error removing shortcut file for shortcut with folder name " + this.getFolderName() + " and display name " + this.getDisplayName(), (Throwable)e);
            }
        }
    }

    public static String getJniLib() {
        String jniFile = "";
        String osArch = System.getProperty("os.arch");
        boolean itanium = osArch.length() >= 4 && osArch.substring(0, 4).equalsIgnoreCase("ia64");
        switch (Utilities.getOS()) {
            case 1: {
                if (itanium) {
                    jniFile = ITANIUM_LIBRARY_NAME;
                    break;
                }
                jniFile = INTEL_LIBRARY_NAME;
                break;
            }
        }
        return jniFile;
    }

    public String getFolderName() {
        return this._folderName;
    }

    public void setFolderName(String folderName) {
        String fn = this.resolveProperty(folderName);
        if (fn != null && fn.indexOf(SAS_WOW_FLAG) >= 0) {
            int pos1 = fn.indexOf(SAS_WOW_FLAG);
            int pos2 = pos1 + SAS_WOW_FLAG.length();
            fn = TaskHelper.getOS_Suffix().equals("wx6") && this.getController().getProperty("Host").equalsIgnoreCase("win") ? fn.substring(0, pos1) + SAS_WOW_TAG + fn.substring(pos2, fn.length()) : fn.substring(0, pos1) + fn.substring(pos2, fn.length());
            this._folderName = fn;
        } else {
            this._folderName = this.resolveProperty(folderName);
        }
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        String dn = this.resolveProperty(displayName);
        if (dn != null && dn.indexOf(SAS_WOW_FLAG) >= 0) {
            int pos1 = dn.indexOf(SAS_WOW_FLAG);
            int pos2 = pos1 + SAS_WOW_FLAG.length();
            dn = TaskHelper.getOS_Suffix().equals("wx6") && this.getController().getProperty("Host").equalsIgnoreCase("win") ? dn.substring(0, pos1) + SAS_WOW_TAG + dn.substring(pos2, dn.length()) : dn.substring(0, pos1) + dn.substring(pos2, dn.length());
            this._displayName = dn;
        } else {
            this._displayName = this.resolveProperty(displayName);
        }
    }

    public String getTargetName() {
        return this._targetName;
    }

    public void setTargetName(String targetName) {
        this._targetName = targetName = this.resolveProperty(targetName);
    }

    public String getArguments() {
        return this._arguments;
    }

    public void setArguments(String arguments) {
        this._arguments = arguments = this.resolveProperty(arguments);
    }

    public String getStartDirectoryName() {
        return this._startDirectoryName;
    }

    public void setStartDirectoryName(String startDirectoryName) {
        this._startDirectoryName = startDirectoryName = this.resolveProperty(startDirectoryName);
    }

    public String getShortcutIconFile() {
        return this._shortcutIconFile;
    }

    public void setShortcutIconFile(String iconFile) {
        this._shortcutIconFile = iconFile == null ? "" : this.resolveProperty(iconFile);
    }

    @Override
    public String descriptionForLog() {
        return null;
    }

    private boolean isSingleUser() {
        return ((CreateWindowsShortcut)this.getData()).isCreateForSingleUser();
    }

    public boolean isChangesMade() {
        return this._changesMade;
    }

    public void setChangesMade(boolean changesMade) {
        this._changesMade = changesMade;
    }
}

