/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;

public class ConfigurePerfMonTask
extends InstallationTask {
    WindowsRegistry _winRegLog = null;
    protected static ConfigurePerfMonTask _configurePerfMonTask = null;

    public ConfigurePerfMonTask() {
        if (TaskHelper.getOS() != 1) {
            this.log.info("Error: This Windows only task is running on " + TaskHelper.getOS());
            return;
        }
        _configurePerfMonTask = this;
        this._winRegLog = new WindowsRegistry();
    }

    @Override
    public String descriptionForLog() {
        return "SAS Performance Monitor";
    }

    @Override
    public void preExecute() throws Exception {
        this.log.debug("in SASPerfMon preExecute");
        if (TaskHelper.getOS() != 1) {
            this.log.info("preExecute: Error: This Windows only task is running on " + TaskHelper.getOS());
            return;
        }
        this._winRegLog.setUninstallLog(this.getController().metadataBackupDirectory(), "ConfigurePerfMon");
        if (this.isUndo()) {
            this.log.debug("preExecute:  isUndo is true");
            return;
        }
        this.notifySetup("Installing SAS Performance Monitor");
        this.log.debug("in SASPerfMon preExecute");
    }

    @Override
    public void execute() throws InstallException {
        if (TaskHelper.getOS() != 1) {
            this.log.info("execute: Error: This Windows only task is running on " + TaskHelper.getOS());
            return;
        }
        this.log.debug("in SASPerfMon execute");
        int hKey = 8;
        if (this.isUndo()) {
            this.log.debug("isUndo:  Calling perfMonUnlodCtr()");
            this.perfMonUnlodCtr();
            this.log.debug("isUndo:  Calling uninstallRegistryKeys()");
            this._winRegLog.uninstallRegistryKeys();
            return;
        }
        String subKey = "SYSTEM\\CurrentControlSet\\Services\\SAS";
        if (!this._winRegLog.keyExists(hKey, subKey)) {
            this._winRegLog.createKey(hKey, subKey);
        }
        if (!this._winRegLog.keyExists(hKey, subKey = subKey.concat("\\Performance"))) {
            this._winRegLog.createKey(hKey, subKey);
        }
        String valueName = "Library";
        String value = "sasperf.dll";
        this._winRegLog.setValue(hKey, subKey, valueName, value, 109);
        valueName = "Open";
        value = "OpenSASPerformanceData";
        this._winRegLog.setValue(hKey, subKey, valueName, value, 109);
        valueName = "Collect";
        value = "CollectSASPerformanceData";
        this._winRegLog.setValue(hKey, subKey, valueName, value, 109);
        valueName = "Close";
        value = "CloseSASPerformanceData";
        this._winRegLog.setValue(hKey, subKey, valueName, value, 109);
        this.log.debug("execute:  Calling perfMonLodCtr()");
        if (!this.perfMonLodCtr()) {
            this.log.info("execute: Could not install performance counters");
        }
    }

    @Override
    public void postExecute() throws Exception {
        if (TaskHelper.getOS() != 1) {
            this.log.info("postExecute: Error: This Windows only task is running on " + TaskHelper.getOS());
            return;
        }
        this.log.debug("in PerfMon postExecute");
        this._winRegLog.writeUninstallData();
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
        if (TaskHelper.getOS() != 1) {
            this.log.info("rollback: Error: This Windows only task is running on " + TaskHelper.getOS());
            return;
        }
        this.log.debug("rollback:  Calling perfMonUnlodCtr()");
        this.perfMonUnlodCtr();
        this.log.debug("rollback:  Calling uninstallRegistryKeys()");
        this._winRegLog.uninstallRegistryKeys();
    }

    protected boolean perfMonLodCtr() {
        String command = "";
        String sasCtrsIni = this.resolveProperty("${ProductHome}\\core\\sasmisc\\deployment\\sasctrs.ini");
        sasCtrsIni = SASWinAPI.GetShortPath((String)sasCtrsIni);
        String sasCtrsH = this.resolveProperty("${ProductHome}\\core\\sasmisc\\deployment\\sasctr.h");
        if (new File(sasCtrsH = SASWinAPI.GetShortPath((String)sasCtrsH)).exists() && new File(sasCtrsH).exists()) {
            command = this.resolveProperty("${WINSYSDIR}\\lodctr.exe " + sasCtrsIni);
            this.log.info("perfMonLodCtr Execute: " + command);
            TaskHelper.executeCommand(command);
            return true;
        }
        return false;
    }

    protected void perfMonUnlodCtr() {
        String command = "";
        command = this.resolveProperty("${WINSYSDIR}\\unlodctr.exe sas");
        this.log.info("perfMonUnlodCtr Execute: " + command);
        TaskHelper.executeCommand(command, false);
    }
}

