/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class ConfigureExcelAccfTask
extends InstallationTask {
    private String productVersionExcelaccf = "";
    WindowsRegistry _winRegLog = new WindowsRegistry();
    private String msOfficeLocation = null;
    private String strLibrary = this.getBundle().messageString("ConfigureExcelAccfTask.LibraryName");
    public static char quote = (char)34;
    static final String fmXlaFileName = "SAS Financial Management Functions.xla";
    protected static Logger log = (Logger)LogManager.getLogger(ConfigureExcelAccfTask.class);

    public ConfigureExcelAccfTask() {
        if (this.strLibrary == null || this.strLibrary == "") {
            this.strLibrary = this.getEnBundle().messageString("ConfigureExcelAccfTask.LibraryName");
        }
    }

    @Override
    public String descriptionForLog() {
        return "Financial Mgmt Add-in Excel";
    }

    @Override
    public void preExecute() throws Exception {
        String[] versions;
        String excelaccfVersion = "";
        excelaccfVersion = this.getController().getProperty("ProductVersion");
        this.productVersionExcelaccf = this.productVersionExcelaccf + excelaccfVersion.charAt(0);
        this.productVersionExcelaccf = this.productVersionExcelaccf + excelaccfVersion.charAt(2);
        String missingLib = "";
        for (String version : versions = new String[]{"16.0", "15.0", "14.0", "12.0"}) {
            this.msOfficeLocation = this.getMsOfficeLocation(version);
            if (this.msOfficeLocation != null && !this.msOfficeLocation.equals("")) break;
        }
        if (this.isUndo()) {
            this.rollback();
            return;
        }
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)WinRegAPI.libNames)) {
            missingLib = JNIUtils.getJniLib((HashMap)WinRegAPI.libNames);
            throw new InstallException(2, null, this._bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        this.notifySetup("Installing ExcelAccf");
    }

    private String getMsOfficeLocation(String version) {
        String subExcelKey = "SOFTWARE\\Microsoft\\Office\\" + version + "\\Excel\\InstallRoot";
        String valueName = "Path";
        int hKey = 8;
        if (WinRegAPI.isWindowsRegistryKey64((int)8, (String)subExcelKey)) {
            return WinRegAPI.getWinRegValueWow64((int)hKey, (String)subExcelKey, (String)valueName);
        }
        if (WinRegAPI.isWindowsRegistryKey32((int)8, (String)subExcelKey)) {
            return WinRegAPI.getWinRegValue32((int)hKey, (String)subExcelKey, (String)valueName);
        }
        return null;
    }

    @Override
    public void execute() throws InstallException {
        if (this.isUndo()) {
            return;
        }
        log.info("Configuring SAS Financial Mgmt Add-in Excel");
        String command = "";
        boolean otherRegAsmRunning = false;
        command = this.resolveProperty(quote + "${ProductHome}\\FMRegisterUtility.exe" + quote + " INSTALL" + this.productVersionExcelaccf);
        command = command.concat(" SILENT");
        try {
            if (Utils.isRegAsmRunning()) {
                otherRegAsmRunning = true;
            }
        }
        catch (Exception e) {
            Controller.logStackTrace(e);
        }
        String returnString = TaskHelper.executeCommand(command);
        log.info(returnString);
        String srcFile = Controller.defaultController().getProperty("ProductHome") + File.separator + fmXlaFileName;
        String tarFile = this.msOfficeLocation + "\\" + this.strLibrary + File.separator + fmXlaFileName;
        try {
            this.getController().getFS().copyFile(srcFile, tarFile);
        }
        catch (IOException e) {
            throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.CopyFileError", srcFile, tarFile), this.getEnBundle().messageString("InstallationTask.CopyFileError", srcFile, tarFile), e);
        }
        File sUninstallFile = new File(tarFile);
        if (sUninstallFile.exists()) {
            this.deleteAtUninstall(sUninstallFile, this.getTarget());
        }
        ConfigureExcelAccfTask.removeExistingOPENvalue();
        String fileToLoad = null;
        fileToLoad = this.msOfficeLocation + this.strLibrary + File.separator + fmXlaFileName;
        File f = new File(fileToLoad);
        if (f.exists()) {
            command = this.resolveProperty(quote + "${ProductHome}\\ExcelAddInTool.exe" + quote + " enable@" + quote + fileToLoad + quote);
            log.info("Executing " + command);
            try {
                Runtime.getRuntime().exec(command);
                Utils.isProcessStillRunning("ExcelAddInTool.exe");
            }
            catch (IOException e) {
                Controller.logStackTrace(e);
            }
        }
        try {
            if (otherRegAsmRunning) {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ee) {
                    Controller.logStackTrace(ee);
                }
            } else {
                Utils.isProcessStillRunning("RegAsm.exe");
            }
        }
        catch (Exception e) {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ee) {
                Controller.logStackTrace(ee);
            }
        }
    }

    private static void removeExistingOPENvalue() {
        String subKey = "Software\\Microsoft\\Office\\";
        String[] officeVersions = new String[]{"12.0", "14.0", "15.0"};
        String officeVersionNumber = "";
        int hKey = 4;
        WindowsRegistry winReg = new WindowsRegistry();
        for (int i = 0; i < officeVersions.length; ++i) {
            boolean bRemoved = false;
            officeVersionNumber = officeVersions[i];
            String fullKey = subKey + officeVersionNumber + "\\Excel\\Options";
            String[] childrenValues = WinRegAPI.valuesForKey((int)hKey, (String)fullKey, (boolean)false);
            ArrayList<String> openList = new ArrayList<String>();
            if (childrenValues == null || childrenValues.length <= 0) continue;
            for (int j = 0; j < childrenValues.length; ++j) {
                String childVal = childrenValues[j];
                if (childVal.indexOf("OPEN") != 0) continue;
                openList.add(childVal);
            }
            String[] openChildren = openList.toArray(new String[openList.size()]);
            if (openChildren == null || openChildren.length <= 0) continue;
            for (int k = 0; k < openChildren.length; ++k) {
                String currentValue = winReg.getValue(hKey, fullKey, openChildren[k]);
                if (currentValue == null || currentValue.indexOf(fmXlaFileName) <= 0) continue;
                log.info("The currentValue of " + openChildren[k] + " is " + currentValue);
                bRemoved = winReg.deleteValue(hKey, fullKey, openChildren[k]);
                if (!bRemoved) continue;
                log.info("SAS FM Windows Registry value " + openChildren[k] + "  " + currentValue + " is successfully removed.");
            }
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
        String command;
        String fileToUnload = null;
        fileToUnload = this.msOfficeLocation + this.strLibrary + File.separator + fmXlaFileName;
        File f = new File(fileToUnload);
        if (f.exists()) {
            command = this.resolveProperty(quote + "${ProductHome}\\ExcelAddInTool.exe" + quote + " disable@" + quote + fileToUnload + quote);
            log.info("Executing " + command);
            try {
                Runtime.getRuntime().exec(command);
                Utils.isProcessStillRunning("ExcelAddInTool.exe");
            }
            catch (IOException e) {
                Controller.logStackTrace(e);
            }
        }
        command = this.resolveProperty(quote + "${ProductHome}\\FMRegisterUtility.exe" + quote + " UNINSTALL" + this.productVersionExcelaccf);
        command = command.concat(" SILENT");
        log.info("Executing " + command);
        TaskHelper.executeCommand(command);
    }
}

