/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.tasks.InstallationTask;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

public class ConfigureABMClientTask
extends InstallationTask {
    private static ConfigureABMClientTask _configureABMClientTask = null;
    protected String _serverFile = "";

    public ConfigureABMClientTask() {
        _configureABMClientTask = this;
    }

    @Override
    public String descriptionForLog() {
        return "Activity-Based Mgmt Client";
    }

    @Override
    public void preExecute() throws Exception {
        if (this.isUndo()) {
            return;
        }
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)WinRegAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib((HashMap)WinRegAPI.libNames);
            throw new InstallException(2, null, this._bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        this.notifySetup("Installing ABMClient");
        this.log.debug("in ABMClient preExecute");
    }

    @Override
    public void execute() throws InstallException {
        if (this.isUndo()) {
            this.rollback();
            return;
        }
        this.log.info("Configuring Activity-Based Mgmt Client");
        try {
            File script = new File(this.resolveProperty("${ProductHome}\\environments.ini"));
            String line = null;
            FileWriter writer = new FileWriter(script);
            line = "[ENVIRONMENT]";
            line = line + "\n";
            line = line + "Location=".concat(Controller.installProperties.getProperty("soltnsoffint.servers.file")).concat("\\SASLogon\\sas-environment.xml");
            this.log.info("ABMClient: " + line);
            writer.write(line);
            writer.close();
            this.deleteAtUninstall(script, this.getTarget());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.warn("Error writing environment.ini file ");
        }
        this.log.info("Created environment.ini file");
    }

    @Override
    public void postExecute() throws Exception {
        this.log.debug("in ABMClient postExecute");
    }

    @Override
    public void retry() throws InstallException {
        this.log.debug("in ABMClient retry");
    }

    @Override
    public void rollback() throws InstallException {
        this.log.debug("in ABMClient rollback");
        if (!this.isUndo()) {
            // empty if block
        }
    }
}

