/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ClearVjrCacheTask
extends InstallationTask {
    private static final String CLEAR_VJR_CLASS = "com.sas.app.NonAPI";
    private static final String CLEAR_VJR_ARG = "-install";
    private String jar;

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void preExecute() {
    }

    @Override
    public void retry() throws InstallException {
        this.log.info("Attempting to retry ClearVJRCacheTask");
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
    }

    @Override
    public void execute() throws InstallException {
        File javaExe = new File(System.getProperty("JREHOME"), "bin");
        javaExe = new File(javaExe, "java");
        String jreLoc = javaExe.getAbsolutePath();
        if (!new File(this.getJar()).exists()) {
            this.log.info(this.getEnBundle().messageString("ClearVJRCache.NoJar", this.getJar()));
            return;
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(jreLoc, "-cp", this.getJar(), CLEAR_VJR_CLASS, CLEAR_VJR_ARG));
        ProcessBuilder pb = new ProcessBuilder(command);
        this.log.info("executing process with the following params:  " + command);
        try {
            Process conf = pb.start();
            conf.waitFor();
            if (conf.exitValue() != 0) {
                throw new InstallException(1, this, this.getBundle().messageString("ClearVJRCache.OperationFailedRC", conf.exitValue()), this.getEnBundle().messageString("ClearVJRCache.OperationFailedRC", conf.exitValue()), null);
            }
        }
        catch (Exception e) {
            throw new InstallException(1, this, this.getBundle().messageString("ClearVJRCache.OperationFailed"), this.getEnBundle().messageString("ClearVJRCache.OperationFailed", this.getJar()), null);
        }
    }

    private String getJar() {
        return this.jar;
    }

    @Override
    public String descriptionForLog() {
        HashMap<String, String> params = new HashMap<String, String>();
        return TaskHelper.getDescriptionForLog("ClearVJRCacheTask", params);
    }

    protected void setJar(String jar) {
        this.jar = jar;
    }
}

