/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.resource.FileSystem;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BuildSASRegistryTask
extends InstallationTask
implements InstallationProgressListener {
    protected Logger log = (Logger)LogManager.getLogger((String)this.getClass().getName());
    private static boolean postProcessingInitialized = false;
    private static boolean rebuildRequired = true;
    private static final String REGISTRY_FILE = "regstry.sas7bitm";
    private static final String SASXREG_EXT = "sasxreg";
    private static final String INST_REG_LOC = "install/registry";
    private final FileFilter sasXRegFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.exists() && f.getName().endsWith(BuildSASRegistryTask.SASXREG_EXT);
        }
    };
    private static String sasRoot = null;

    @Override
    public String descriptionForLog() {
        return null;
    }

    public int executeAtEnd() {
        this.log.info("POSTPROCESS: BuildSASRegistryTask called");
        sasRoot = this.getSASFoundationRoot();
        try {
            if (rebuildRequired) {
                Collection<JobFile> sasJobs = this.createNLSJobs();
                for (JobFile sasJobFile : sasJobs) {
                    File sasRegistryFile = sasJobFile.getRegistryFile();
                    EntryData metadata = new EntryData(sasRegistryFile);
                    boolean regFileExists = sasRegistryFile.exists();
                    String action = regFileExists ? "Changed" : "Added";
                    this.notifySetup(action, metadata, null);
                    int rc = this.runRegistryBuild(sasJobFile.getSasJobName(), this.getSASConfigFile(sasJobFile.getLanguage()), sasJobFile.getLanguage());
                    if (rc == 0 || rc == 1) {
                        File tmpRegFile = new File(this.getWorkArea(), REGISTRY_FILE);
                        String backupPath = this.getController().getBackupDestination(sasRegistryFile.getAbsolutePath(), true);
                        this.backupFile(sasRegistryFile, backupPath);
                        if (Utils.moveFile(tmpRegFile, sasRegistryFile)) {
                            this.deleteAtUninstall(sasRegistryFile, this.getTarget());
                        }
                        if (metadata.getDestination().exists()) {
                            metadata.flushMd5();
                            this.notifyProgressComplete(action, metadata);
                            sasJobFile.getSasJobName().delete();
                            File dir = new File(this.getInstallMisc().toString());
                            String[] files = dir.list();
                            for (int i = 0; i < files.length; ++i) {
                                String fileDelete;
                                File file;
                                if (!files[i].endsWith(".sas7bcat") && !files[i].endsWith(".sas7bitm") || (file = new File(fileDelete = this.getInstallMisc().toString() + File.separator + files[i])) == null || !file.exists()) continue;
                                file.delete();
                            }
                        }
                    }
                    if (rc < 2) continue;
                    this.notifyProgressFailure(action, metadata);
                }
            } else {
                this.log.info("No updated SAS Registry content detected. Registry rebuild NOT required.");
            }
        }
        catch (InstallException e) {
            Controller.logStackTrace(e);
            this.log.error("Unable to update the SAS Registry");
            return -1;
        }
        return 0;
    }

    @Override
    public void execute() {
        NotificationHandler.defaultHandler().addProgressListener(this);
        if (Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
            if (!postProcessingInitialized) {
                String key = Controller.defaultController().getAltSku().concat(this.getClass().getName());
                Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(true, this.getClass().getName(), "executeAtEnd"));
                Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this, this.getClass(), "executeAtEnd"));
                postProcessingInitialized = true;
            }
        } else {
            this.executeAtEnd();
        }
    }

    private Collection<JobFile> createNLSJobs() {
        ArrayList<JobFile> sasJobs = new ArrayList<JobFile>();
        File tempArea = this.createWorkArea();
        String sasJobSetup = "LIBNAME reglib \"" + tempArea + "\" ACCESS=TEMP;\nPROC REGISTRY SETSASUSER='reglib.regstry'; RUN;\n\n";
        Map<String, File> commonRegistryFiles = this.findCommonRegistryFiles();
        LinkedHashSet<String> commonRegistryNames = new LinkedHashSet<String>(this.readBaseRegistryOrder());
        commonRegistryNames.addAll(commonRegistryFiles.keySet());
        LinkedHashMap<String, File[]> allLangsRegistryFiles = new LinkedHashMap<String, File[]>();
        allLangsRegistryFiles.put("en", new File[0]);
        allLangsRegistryFiles.putAll(this.findAllNlsRegistryFiles());
        for (String lang : allLangsRegistryFiles.keySet()) {
            HashMap<String, File> langRegistryFiles = new HashMap<String, File>();
            for (File nlsFile : (File[])allLangsRegistryFiles.get(lang)) {
                langRegistryFiles.put(nlsFile.getName(), nlsFile);
            }
            HashSet<File> importedFiles = new HashSet<File>();
            ArrayList<String> importStatements = new ArrayList<String>();
            importStatements.add(sasJobSetup);
            for (String commonFileName : commonRegistryNames) {
                File overriddenFile = (File)langRegistryFiles.get(commonFileName);
                File commonFile = commonRegistryFiles.get(commonFileName);
                if (overriddenFile != null && overriddenFile.exists()) {
                    importedFiles.add(overriddenFile);
                    importStatements.add("proc registry import=\"" + overriddenFile + "\"; run;");
                    continue;
                }
                if (commonFile == null || !commonFile.exists()) continue;
                importedFiles.add(commonFile);
                importStatements.add("proc registry import=\"" + commonFile + "\"; run;");
            }
            for (File nlsRegistry : (File[])allLangsRegistryFiles.get(lang)) {
                if (importedFiles.contains(nlsRegistry)) continue;
                importedFiles.add(nlsRegistry);
                importStatements.add("proc registry import=\"" + nlsRegistry + "\"; run;");
            }
            sasJobs.add(new JobFile(this.createJobFile(lang, importStatements), lang));
        }
        return sasJobs;
    }

    private File createJobFile(String lang, List<String> importStatements) {
        File nlsJob = this.getNlsJob(lang);
        this.log.info("SAS Registry job: " + nlsJob.getAbsolutePath());
        if (nlsJob != null && nlsJob.exists()) {
            Utils.removeFile(nlsJob);
        }
        this.writeFile(nlsJob, importStatements);
        return nlsJob;
    }

    private File getNlsJob(String lang) {
        return new File(this.getWorkArea(), "sasregbld_" + lang + ".sas");
    }

    private void writeFile(File sasFile, List<String> statement) {
        try {
            FileWriter writer = new FileWriter(sasFile);
            for (String importStatement : statement) {
                writer.write(importStatement + "\n");
            }
            writer.write("\n");
            writer.close();
        }
        catch (IOException e) {
            throw new InstallException(1, this, this.getBundle().messageString("BuildSASRegistry.WriteJob", sasFile), this.getEnBundle().messageString("BuildSASRegistry.WriteJob", sasFile), e);
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    @Override
    public void preExecute() throws Exception {
    }

    private Map<String, File> findCommonRegistryFiles() {
        TreeMap<String, File> common = new TreeMap<String, File>();
        File commonDir = null;
        if (TaskHelper.isWindows()) {
            commonDir = new File(this.getFS().append(sasRoot, "core", "sasinst", "registry"));
        } else if (TaskHelper.isUnix()) {
            commonDir = new File(this.getFS().append(sasRoot, "install", "registry", "en"));
        }
        if (commonDir != null) {
            for (File f : commonDir.listFiles(this.sasXRegFilter)) {
                common.put(f.getName(), f);
            }
        }
        return common;
    }

    private Map<String, File[]> findAllNlsRegistryFiles() {
        HashMap<String, File[]> nlsRegistryFiles;
        block4: {
            File regDir;
            block3: {
                nlsRegistryFiles = new HashMap<String, File[]>();
                if (!TaskHelper.isWindows()) break block3;
                File nlsFolder = new File(this.getFS().append(sasRoot, "nls"));
                if (!nlsFolder.isDirectory()) break block4;
                for (File langDir : nlsFolder.listFiles()) {
                    File langRegistryDir;
                    if (!langDir.isDirectory() || !(langRegistryDir = new File(langDir, "sasinst\\registry")).isDirectory()) continue;
                    File[] registryFiles = langRegistryDir.listFiles(this.sasXRegFilter);
                    nlsRegistryFiles.put(langDir.getName(), registryFiles);
                }
                break block4;
            }
            if (TaskHelper.isUnix() && (regDir = new File(this.getFS().append(sasRoot, INST_REG_LOC))).isDirectory()) {
                for (File langDir : regDir.listFiles()) {
                    if (!langDir.isDirectory() || langDir.getName().equals("en") || langDir.getName().equals("tmp")) continue;
                    File[] registryFiles = langDir.listFiles(this.sasXRegFilter);
                    nlsRegistryFiles.put(langDir.getName(), registryFiles);
                }
            }
        }
        return nlsRegistryFiles;
    }

    @Override
    public void bytesMoved(long numBytes) {
    }

    @Override
    public void installStartedAction() {
    }

    @Override
    public void installCompletedAction() {
    }

    @Override
    public void progressBeginningAction(String action, EntryData metaData) {
    }

    @Override
    public void progressBeginningAction(String description) {
    }

    @Override
    public void progressCompleteAction(String action, EntryData metaData) {
    }

    @Override
    public void progressCompleteAction(String description) {
    }

    @Override
    public void progressFailedAction(String action, EntryData metaData) {
    }

    @Override
    public void taskStartedAction(InstallationTask task) {
    }

    private File getWorkArea() {
        if (TaskHelper.isWindows()) {
            return new File(this.getFS().append(sasRoot, "core", "sasinst", "registry"));
        }
        if (TaskHelper.isUnix()) {
            return new File(this.getFS().append(sasRoot, "install", "registry"));
        }
        throw new IllegalStateException("No work area defined for " + TaskHelper.getOS_Suffix());
    }

    private File createWorkArea() {
        File tempWorkDir = this.getWorkArea();
        if (!tempWorkDir.isDirectory()) {
            tempWorkDir.mkdir();
        }
        return tempWorkDir;
    }

    private Set<String> readBaseRegistryOrder() {
        TreeSet<String> sasregordNames = new TreeSet<String>();
        File sasregordDir = null;
        if (TaskHelper.isWindows()) {
            sasregordDir = new File(this.getFS().append(sasRoot, "core", "sasinst", "sasregord"));
        } else if (TaskHelper.isUnix()) {
            sasregordDir = new File(this.getFS().append(sasRoot, "install", "sasregord"));
        }
        File sasregord = new File(sasregordDir, "base_en.sasregord");
        if (sasregord.isFile()) {
            Element root;
            try {
                root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(sasregord).getDocumentElement();
            }
            catch (Exception e) {
                throw new InstallException(3, this, this.getBundle().messageString("BuildSASRegistry.SasregordParse", sasregord), this.getEnBundle().messageString("BuildSASRegistry.SasregordParse", sasregord), e);
            }
            NodeList files = root.getChildNodes();
            Element file = null;
            if (files.getLength() > 0) {
                for (int i = 0; i < files.getLength(); ++i) {
                    if (files.item(i).getNodeType() != 1) continue;
                    file = (Element)files.item(i);
                    sasregordNames.add(file.getAttribute("name").toLowerCase());
                }
            }
        } else {
            this.log.warn("Cannot find registry order file " + sasregord);
        }
        return Collections.unmodifiableSet(sasregordNames);
    }

    private List<String> getArgs(File sasFile, File cfgFile, String lang) {
        ArrayList<String> args = new ArrayList<String>();
        if (TaskHelper.isUnix()) {
            args.add(sasRoot + "/bin/sas_" + lang);
            args.add("-nodms");
            args.add("-noterminal");
            args.add("-set");
            args.add("sasroot");
            args.add(sasRoot);
            args.add("-sasuser");
            args.add(this.getWorkArea().getPath());
            args.add("-msg");
            args.add(sasRoot + "/sasmsg");
            args.add("-work");
            args.add(this.getWorkArea().getPath());
            args.add("-log");
            args.add(this.getLog());
            args.add("-filelocks");
            args.add("none");
            args.add("-nonews");
            args.add("-nonotes");
            args.add("-nodate");
            args.add("-nostimer");
            args.add("-ls");
            args.add("78");
            args.add("-filesync");
            args.add("host");
            args.add("-ps");
            args.add("60");
            args.add("-setinit");
            args.add("-noautoexec");
            args.add(sasFile.toString());
        } else if (TaskHelper.isWindows()) {
            args.add(this.getFS().append(sasRoot, "sas.exe"));
            args.add("\"" + sasFile.toString() + "\"");
            args.add("-setinit");
            args.add("-config");
            args.add("\"" + cfgFile + "\"");
            args.add("-print");
            args.add("\"" + this.getWorkArea() + File.separator + "rebuildSASReg.lst\"");
            args.add("-log");
            args.add("\"" + this.getLog() + "\"");
            args.add("-sasuser");
            args.add("\"" + this.getInstallMisc() + "\"");
            args.add("-icon");
            args.add("-nosplash");
            args.add("-nonotes");
            args.add("-noprngetlist");
            args.add("-unbuflog");
            args.add("-noautoexec");
            args.add("-noterminal");
            args.add("-filesync");
            args.add("HOST");
        }
        return args;
    }

    protected String getLog() {
        if (TaskHelper.isUnix()) {
            return this.getWorkArea() + File.separator + "rebuildSASReg.log";
        }
        return this.getWorkArea() + File.separator + "rebuildSASReg.log";
    }

    private int runRegistryBuild(File sasFile, File cfgFile, String lang) {
        int rc = 0;
        ProcessBuilder pb = null;
        if (TaskHelper.isUnix() || TaskHelper.isWindows()) {
            pb = new ProcessBuilder(this.getArgs(sasFile, cfgFile, lang));
            this.log.info("Starting application of building registry.");
            try {
                rc = InstallationTask.executeProcess(pb, this.log);
            }
            catch (Exception e) {
                throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.OperationFailedEx", pb.command()), this.getEnBundle().messageString("InstallationTask.OperationFailedEx", pb.command()), e);
            }
            this.processSASOutput(rc, this.getLog());
            if (rc == 1) {
                this.log.info("There were warning(s) in the SAS log while building the SAS Registry,  please see the SAS log content above for more details");
            } else if (rc == 2) {
                this.log.error("There were error(s) in the SAS log while building the SAS Registry, please see the SAS log content above for more details");
            }
        }
        return rc;
    }

    protected void backupFile(File backupFname, String backupPath) {
        File backupFileE = new File(backupPath);
        if (backupFname == null || !backupFname.exists()) {
            this.log.info("File Not Found:" + backupFname + " so no backup performed.");
            return;
        }
        try {
            this.getFS().copyFile(backupFname, backupFileE);
        }
        catch (IOException e) {
            throw new InstallException(1, this, this.getBundle().messageString("InstallationTask.FileMoveError", backupFname, backupFileE), "Failure moving " + backupFname + " to " + backupFileE + " for backup purposes", e);
        }
    }

    private FileSystem getFS() {
        return this.getController().getFS();
    }

    public static void setPostProcessingInitialized(boolean postProcessingInitialized) {
        BuildSASRegistryTask.postProcessingInitialized = postProcessingInitialized;
    }

    class JobFile {
        private final File sasJobName;
        private final String language;

        public JobFile(File sasJobName, String language) {
            this.sasJobName = sasJobName;
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public File getSasJobName() {
            return this.sasJobName;
        }

        public File getRegistryFile() {
            File registryFile = null;
            if (TaskHelper.isWindows()) {
                registryFile = "en".equals(this.language) ? new File(BuildSASRegistryTask.this.getFS().append(sasRoot, "core", "sashelp", BuildSASRegistryTask.REGISTRY_FILE)) : new File(BuildSASRegistryTask.this.getFS().append(sasRoot, "nls", this.language, "sashelp", BuildSASRegistryTask.REGISTRY_FILE));
            } else if (TaskHelper.isUnix()) {
                registryFile = new File(BuildSASRegistryTask.this.getFS().append(sasRoot, "nls", this.language, "sascfg", BuildSASRegistryTask.REGISTRY_FILE));
            }
            return registryFile;
        }
    }
}

