/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.SSNResource;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class BuildHelpIndexTask
extends InstallationTask
implements InstallationProgressListener {
    private final String UNIX_HELP_PATH = "X11/native_help";
    private final String WINDOWS_HELP_PATH = "core" + File.separator + "help";
    private final String UNIX_DOCSETUP_PATH = "utilities/bin/tkdocsetup";
    private final String WINDOWS_DOCSETUP_PATH = "docsetup";
    private String sas_foundation = null;
    private static final String TASK_NAME = "helpCacheRebuild";
    private static List<String> _command = new ArrayList<String>();
    private static boolean _updateCache = false;
    protected static Logger ClassLog = (Logger)LogManager.getLogger(BuildHelpIndexTask.class);
    protected static SSNResource ClassBundle = new SSNResource(BuildHelpIndexTask.class);
    protected static SSNResource ClassENBundle = SSNResource.EnglishResource(BuildHelpIndexTask.class);
    private static BuildHelpIndexTask globalBuildHelpIndex = null;
    protected static List<File> _deleteDirsList = new ArrayList<File>();

    public BuildHelpIndexTask() {
        NotificationHandler.defaultHandler().addProgressListener(this);
        if (globalBuildHelpIndex == null) {
            globalBuildHelpIndex = this;
        }
        if (Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
            String key = Controller.defaultController().getAltSku().concat(this.getClass().getName());
            Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(this.getClass().getName(), "postProcess"));
            Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this.getClass(), "postProcess"));
        } else {
            try {
                this.setController(Controller.defaultController());
                BuildHelpIndexTask.postProcess();
            }
            catch (Exception e) {
                Controller.logStackTrace(e);
            }
        }
    }

    @Override
    public void notifySetup(String action, EntryData metaData, String message) {
        if (message != null) {
            this.fileLog.info(message);
        }
        NotificationHandler.defaultHandler().fireSetupNotification(action, metaData, message);
    }

    @Override
    public void execute() throws InstallException {
    }

    @Override
    public void preExecute() {
    }

    public static int postProcess() throws Exception {
        return globalBuildHelpIndex.executeAtEnd();
    }

    public int executeAtEnd() throws Exception {
        this.setCommandArguments();
        String cachePath = null;
        String logDir = null;
        String sasRoot = Controller.defaultController().getProperty("home_base");
        if (TaskHelper.isUnix()) {
            logDir = this.getInstallLogs().getPath();
            cachePath = sasRoot + File.separator + "X11/native_help";
        } else {
            logDir = this.getInstallLogs().getPath();
            cachePath = sasRoot + File.separator + this.WINDOWS_HELP_PATH;
            _updateCache = true;
        }
        File cachePathDir = new File(cachePath);
        if (_updateCache) {
            new File(logDir).mkdirs();
            ClassLog.info("Preparing to run " + _command);
            ProcessBuilder pb = new ProcessBuilder(_command);
            this.notifySetup("Preparing to change all index files in the help cache path.");
            pb.directory(new File(sasRoot));
            try {
                BuildHelpIndexTask.executeProcess(pb, ClassLog);
                for (String f : cachePathDir.list()) {
                    EntryData helpCacheDirList;
                    File helpContentDir = new File(cachePath + File.separator + f, "helpnav.hlp");
                    this.log.info("Passing directory " + helpContentDir + " for validation.");
                    if (!helpContentDir.exists() || !(helpCacheDirList = new EntryData(helpContentDir)).getDestination().isDirectory()) continue;
                    this.notifyProgressComplete("Changed", helpCacheDirList);
                }
            }
            catch (Exception e) {
                ClassLog.error(ClassBundle.messageString("HelpCacheRebuild.OperationFailed") + pb.command());
                return -1;
            }
            String helpDir = new String(this.getSASFoundationRoot() + File.separator + "core" + File.separator + "help");
            File fileToDelete = new File(helpDir, "en\\common.hlp\\en_index.txt");
            if (fileToDelete.exists()) {
                this.deleteAtUninstall(fileToDelete, this.getTarget());
                this.deleteAtUninstall(fileToDelete.getParentFile(), this.getTarget());
            }
            for (File dirToDelete : _deleteDirsList) {
                if (!dirToDelete.exists()) continue;
                this.deleteAtUninstall(dirToDelete, this.getTarget());
            }
        } else {
            ClassLog.info("No help content changed, so no need to update cache.");
        }
        return 0;
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
        _command = null;
    }

    private List<String> setCommandArguments() {
        String helpPath = null;
        String tempLogDir = null;
        String docsetupPath = null;
        if (TaskHelper.isWindows()) {
            helpPath = this.WINDOWS_HELP_PATH;
            docsetupPath = "docsetup";
        } else {
            helpPath = "X11/native_help";
            docsetupPath = "utilities/bin/tkdocsetup";
        }
        tempLogDir = this.getInstallLogs().getPath();
        this.sas_foundation = Controller.defaultController().getProperty("home_base");
        File docsetup = new File(this.sas_foundation + File.separator + docsetupPath);
        File nativeHelpDir = new File(this.sas_foundation + File.separator + helpPath);
        File nlsDir = new File(this.sas_foundation + File.separator + "nls");
        String[] helpLangs = nativeHelpDir.list();
        File logDir = new File(tempLogDir);
        File logFile = BuildHelpIndexTask.getLogFile(logDir);
        _command.add(docsetup.getAbsolutePath());
        _command.add("-log");
        _command.add(logFile.getAbsolutePath());
        _command.add("-buildindex");
        for (int i = 0; i < helpLangs.length; ++i) {
            String helpLang = helpLangs[i];
            File nlsLang = new File(nlsDir + File.separator + helpLang);
            if (!nlsLang.isDirectory()) continue;
            _command.add("-lang");
            _command.add(helpLang);
        }
        _command.add("-path");
        _command.add(nativeHelpDir.getAbsolutePath());
        _command.add("-navigation");
        _command.add("helpnav");
        _command.add("-output");
        _command.add(nativeHelpDir.getAbsolutePath());
        _command.add("-v");
        return _command;
    }

    protected static File getLogFile(File logDir) {
        File logFile;
        String prefix = "docsetup_";
        String date = BuildHelpIndexTask.getLogDate();
        Formatter seqFormat = new Formatter();
        int seq = 0;
        do {
            logFile = new File(logDir, prefix + date + "." + seqFormat.format("%03d", seq));
            ++seq;
        } while (logFile.exists());
        seqFormat.close();
        return logFile;
    }

    private static String getLogDate() {
        SimpleDateFormat ymd = new SimpleDateFormat("yyMMdd");
        String date = ymd.format(Calendar.getInstance().getTime());
        return date;
    }

    @Override
    public String descriptionForLog() {
        HashMap<String, String> params = new HashMap<String, String>();
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    public static String getTaskName() {
        return TASK_NAME;
    }

    @Override
    public void bytesMoved(long numBytes) {
    }

    @Override
    public void installStartedAction() {
    }

    @Override
    public void installCompletedAction() {
    }

    @Override
    public void progressBeginningAction(String action, EntryData metaData) {
    }

    @Override
    public void progressBeginningAction(String description) {
    }

    @Override
    public void progressCompleteAction(String action, EntryData metaData) {
        this.sas_foundation = Controller.defaultController().getProperty("home_base");
        if (!_updateCache) {
            if (TaskHelper.isUnix()) {
                String unix_help_cache_path = this.sas_foundation + File.separator + "X11/native_help";
                if (metaData.getDestination().getAbsolutePath().startsWith(unix_help_cache_path)) {
                    _updateCache = true;
                    this.log.info("Detected installation/modification of Unix native help files at " + unix_help_cache_path);
                }
            } else {
                String windows_help_cache_path = this.sas_foundation + File.separator + this.WINDOWS_HELP_PATH;
                this.log.info((Object)metaData.getDestination().getAbsolutePath().startsWith(windows_help_cache_path));
                if (metaData.getDestination().getAbsolutePath().startsWith(windows_help_cache_path)) {
                    _updateCache = true;
                    this.log.info("Detected installation/modification of Windows component help files at " + windows_help_cache_path);
                }
            }
        }
    }

    @Override
    public void progressCompleteAction(String description) {
    }

    @Override
    public void progressFailedAction(String action, EntryData metaData) {
    }

    @Override
    public void taskStartedAction(InstallationTask task) {
    }
}

