/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.listener.InstallationSetupListener;
import com.sas.tools.installs.it.listener.RollbackProgressListener;
import com.sas.tools.installs.it.schema.install.BatchRegistration;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.schema.metadata.gen.EntryType;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class BatchRegistrationTask
extends InstallationTask
implements InstallationProgressListener,
RollbackProgressListener,
InstallationSetupListener {
    public static final String REGISTER = "register";
    public static final String UNREGISTER = "unregister";
    private static final String EXE = ".exe";
    private static Set<String> _unregisteredFiles = new HashSet<String>();

    public BatchRegistrationTask() {
        NotificationHandler.defaultHandler().addProgressListener(this);
        NotificationHandler.defaultHandler().addRollbackProgressListener(this);
        NotificationHandler.defaultHandler().addSetupListener(this);
    }

    @Override
    public void preExecute() {
        this.notifySetup("Registering relevant installed files in the Windows Registry");
    }

    @Override
    public void postExecute() {
        this.notifyProgressComplete(this.getBundle().messageString("BatchRegister.RegistrationComplete"));
    }

    public void registerAction(String action, EntryData entry) {
        this.registerAction(action, Arrays.asList(entry));
    }

    public void registerAction(String action, List<? extends EntryType> entries) {
        int returnCode = 0;
        for (EntryType entryType : entries) {
            returnCode = 0;
            String name = entryType.getName();
            if (name == null) {
                this.log.warn("File to register is a null value, skipping self-registration: " + name);
                continue;
            }
            if ("9.4".equals(this.getController().getProperty("ProductVersion")) && "base".equalsIgnoreCase(this.getController().getProperty("12ByteCode")) && "0".equals(this.getController().getProperty("MaintVersion")) && (this.getController().getProperty("host").equalsIgnoreCase("win") || this.getController().getProperty("host").equalsIgnoreCase("wx6")) && name.contains("sas.exe")) {
                this.log.info("NOTE: Version: " + this.getController().getProperty("ProductVersion") + ", Product: " + this.getController().getProperty("ProductName") + ", Maintenance: " + this.getController().getProperty("MaintVersion") + ", Host: " + this.getController().getProperty("host") + ", OS_SUFFIX_WIN:" + "win" + ", OS_SUFFIX_WX6:" + "wx6" + ", Name: " + name + " has been removed from Batch Registration");
                continue;
            }
            String fileToRegister = this.resolveProperty(name);
            if (this.isUndo() && _unregisteredFiles.contains(fileToRegister)) {
                this.log.info(fileToRegister + " has already been unregistered, skipping.");
                continue;
            }
            List<String> execCommand = this.getExecCommand(action, (EntryData)entryType);
            returnCode = this.registerAction(action, fileToRegister, execCommand);
            if (returnCode != 0) {
                if (REGISTER.equalsIgnoreCase(action)) {
                    throw new InstallException(3, this, this.getBundle().messageString("BatchRegister.NonZeroExitValueOnRegistration", returnCode, fileToRegister), this.getEnBundle().messageString("BatchRegister.NonZeroExitValueOnRegistration", returnCode, fileToRegister), null);
                }
                this.log.warn(this.getBundle().messageString("BatchRegister.NonZeroExitValueOnUnregistration", returnCode, fileToRegister));
            }
            if (this.isUndo()) {
                _unregisteredFiles.add(fileToRegister);
            }
            if (!name.contains("LoggingService.dll") || !TaskHelper.getOS_Suffix().equalsIgnoreCase("wx6")) continue;
            EntryData data = new EntryData();
            data.setName(entryType.getName());
            data.setRegisterTool("${WINDIR}\\Microsoft.NET\\Framework64\\v4.0.30319\\RegAsm.exe");
            data.setRegisterParams("/tlb /codebase");
            data.setUnregisterParams("/u");
            data.setRegister(true);
            execCommand = this.getExecCommand(action, data);
            returnCode = this.registerAction(action, fileToRegister, execCommand);
            if (returnCode != 0) {
                if (REGISTER.equalsIgnoreCase(action)) {
                    throw new InstallException(3, this, this.getBundle().messageString("BatchRegister.NonZeroExitValueOnRegistration", returnCode, fileToRegister), this.getEnBundle().messageString("BatchRegister.NonZeroExitValueOnRegistration", returnCode, fileToRegister), null);
                }
                this.log.warn(this.getBundle().messageString("BatchRegister.NonZeroExitValueOnUnregistration", returnCode, fileToRegister));
            }
            EntryData entry = new EntryData(Utils.joinPath(this.getController().getProperty("ProductHome"), "LoggingService.tlb"));
            this.notifySetup("Changed", entry, "Getting new checksum value for modified LoggingService.tlb file.");
            this.notifyProgressComplete("Changed", entry);
        }
    }

    private int registerAction(String action, String fileToRegister, List<String> execCommand) {
        ProcessBuilder pb = new ProcessBuilder(execCommand);
        File productHome = new File(this.getController().getProperty("ProductHome"));
        pb.directory(productHome);
        try {
            this.log.info("attempting to " + action + " " + fileToRegister + " by executing " + execCommand);
            if (pb.directory() != null) {
                this.log.info("from " + pb.directory().getAbsolutePath());
            }
            Process p = pb.start();
            String line = null;
            BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = error.readLine()) != null) {
                this.log.info("\tstderr:" + line);
            }
            error.close();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                System.out.println("\tstdout:  " + line);
            }
            input.close();
            p.waitFor();
            int returnCode = p.exitValue();
            this.log.info(action + " complete with exit value " + returnCode);
            return returnCode;
        }
        catch (Exception e) {
            throw new InstallException(3, this, this.getBundle().messageString("BatchRegister.RegistrationError", action), this.getEnBundle().messageString("BatchRegister.RegistrationError", action), e);
        }
    }

    private void saveEntry(EntryData entryData) {
        EntryData uninstallEntryData = new EntryData();
        String path = entryData.getDestination().getAbsolutePath();
        String producthome = this.getController().getProperty("ProductHome");
        String sashome = this.getController().getProperty("SASHome");
        if (path.startsWith(producthome)) {
            path = path.replace(producthome, "${ProductHome}");
        } else if (path.startsWith(sashome)) {
            path = path.replace(sashome, "${SASHome}");
        }
        uninstallEntryData.setName(path);
        uninstallEntryData.setRegisterParams(entryData.getRegisterParams());
        uninstallEntryData.setUnregisterParams(entryData.getUnregisterParams());
        uninstallEntryData.setRegisterTool(entryData.getRegisterTool());
        this.getTaskEntryData().add(uninstallEntryData);
    }

    private List<EntryType> getTaskEntryData() {
        return ((BatchRegistration)this.getData()).getEntryData();
    }

    protected List<String> getExecCommand(String action, EntryData entryData) {
        String tool = entryData.getRegisterTool();
        String name = entryData.getName();
        if (tool == null || tool.equalsIgnoreCase("")) {
            throw new InstallException(3, this, this.getBundle().messageString("BatchRegister.RegistrationError", action), this.getBundle().messageString("BatchRegister.RegistrationError", action), null);
        }
        tool = "\"" + this.resolveProperty(tool) + "\"";
        String execParams = action.equals(REGISTER) ? entryData.getRegisterParams() : entryData.getUnregisterParams();
        execParams = this.resolveProperty(execParams);
        ArrayList<String> execCommand = new ArrayList<String>(Arrays.asList(tool));
        if (execParams != null) {
            StringTokenizer tokens = new StringTokenizer(execParams, " ");
            while (tokens.hasMoreTokens()) {
                execCommand.add(tokens.nextToken());
            }
        }
        if (!name.toLowerCase().endsWith(EXE)) {
            String path = this.resolveProperty(name);
            execCommand.add("\"" + path + "\"");
        }
        return execCommand;
    }

    @Override
    public void rollbackProgressBeginningAction(String action, EntryData metaData) {
        File destinationFile = metaData.getDestination();
        if (destinationFile.exists() && metaData.isRegister().booleanValue() && metaData.getDestination().exists()) {
            this.registerAction(UNREGISTER, metaData);
        }
    }

    @Override
    public void progressBeginningAction(String action, EntryData metaData) {
        if (!action.equals("Added") && metaData.isRegister().booleanValue() && metaData.getDestination().exists()) {
            this.registerAction(UNREGISTER, metaData);
        }
    }

    @Override
    public void progressFailedAction(String action, EntryData metaData) {
    }

    @Override
    public void rollbackProgressCompleteAction(String action, EntryData metaData) {
        this.progressCompleteAction(action, metaData);
    }

    @Override
    public void progressCompleteAction(String action, EntryData metaData) {
    }

    @Override
    public void progressBeginningAction(String description) {
    }

    @Override
    public void progressCompleteAction(String description) {
    }

    @Override
    public String descriptionForLog() {
        return "BatchRegister";
    }

    @Override
    public void rollbackBytesMoved(long numBytes) {
    }

    @Override
    public void rollbackFailure(String description) {
    }

    @Override
    public void rollbackProgressBeginningAction(String description) {
    }

    @Override
    public void rollbackProgressCompleteAction(String description) {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    @Override
    public void bytesMoved(long numBytes) {
    }

    @Override
    public void allRollbackCompleteAction() {
    }

    @Override
    public void execute() throws InstallException {
        if (!this.isUndo()) {
            this.registerAction(REGISTER, this.getTaskEntryData());
        } else {
            this.registerAction(UNREGISTER, this.getTaskEntryData());
        }
    }

    @Override
    public void installStartedAction() {
    }

    @Override
    public void installCompletedAction() {
    }

    @Override
    public void taskStartedAction(InstallationTask task) {
    }

    @Override
    public InstallationTask.UninstallTarget getUninstallTarget() {
        return InstallationTask.UninstallTarget.PREINSTALL;
    }

    @Override
    public void setupAction(String action, EntryData metaData) {
        if ("Checked".equals(action) && metaData != null && metaData.isRegister().booleanValue()) {
            this.log.info("File to register: " + metaData.getDestination());
            this.saveEntry(metaData);
        }
    }

    @Override
    public void setupAction(String description) {
    }
}

