/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.ApplySASLicense;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.MvsextractTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.resource.SID;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;

public class ApplySASLicenseTask
extends InstallationTask {
    private static final String SETINIT_LOG = "setinit.log";
    private static final String TASK_NAME = "applyLicence";
    private static boolean postProcessingInitialized = false;

    @Override
    public void preExecute() {
    }

    public int postInstall() {
        int returnCode = 0;
        if (Controller.defaultController().getProperty("SID") == null) {
            this.log.info("License file was not provided, skipping ApplySASLicenseTask");
            return returnCode;
        }
        if (TaskHelper.isUnix()) {
            new File(this.getController().getFS().append(Controller.defaultController().getProperty("ProductHome"), new String[0]) + File.separator + "install" + File.separator + "admin" + File.separator + "tmp").mkdirs();
        }
        this.log.info("Starting extraction of SAS license");
        File licenseSetinit = ApplySASLicenseTask.extractLicenseSetinit();
        File licenseTarget = this.getLicenseTarget();
        if (licenseTarget != null) {
            if (licenseTarget.exists() && !licenseTarget.delete()) {
                this.log.warn("Failed to update SAS License file under SAS root location.");
            }
            this.copyFile(licenseSetinit, licenseTarget);
        }
        ProcessBuilder pb = null;
        if (TaskHelper.isUnix() || TaskHelper.isWindows()) {
            List<String> sasArgs = this.getSASBatchArgs(licenseSetinit, SETINIT_LOG);
            sasArgs.add(1, "-setinit");
            if (TaskHelper.isWindows()) {
                sasArgs.add("-config");
                sasArgs.add(Utils.joinPath(this.getSASFoundationRoot(), "nls\\en\\sasv9.cfg"));
            } else if (TaskHelper.isUnix()) {
                sasArgs.add("-config");
                sasArgs.add(this.getSASFoundationRoot() + "/sasv9.cfg");
            }
            pb = new ProcessBuilder(sasArgs);
            this.log.info("Starting application of SAS license");
            File coreFile = new File(this.getCorePath());
            EntryData metadata = new EntryData(coreFile);
            this.notifySetup("Changed", metadata, null);
            try {
                returnCode = InstallationTask.executeProcess(pb, this.log);
                this.notifyProgressComplete("Changed", metadata);
            }
            catch (Exception e) {
                this.log.error("Failed to run SAS to apply the SAS License file." + e.getMessage());
                return -1;
            }
            this.processSASOutput(returnCode, this.getSASLog(SETINIT_LOG));
            if (returnCode == 1) {
                this.log.info("There were warning(s) in the SAS log while applying the SAS license,  please see the SAS log content above for more details");
            } else if (returnCode == 2) {
                this.log.error("There were error(s) in the SAS log while applying the SAS license, please see the SAS log content above for more details");
            }
        }
        return returnCode;
    }

    private File getLicenseTarget() {
        File licenseTarget = null;
        if (TaskHelper.isUnix()) {
            licenseTarget = new File(this.getSASFoundationRoot(), "setinit.sas");
        } else if (TaskHelper.isWindows()) {
            licenseTarget = new File(this.getSASFoundationRoot(), "core\\sasinst\\setinit.sss");
        }
        return licenseTarget;
    }

    private String getCorePath() {
        String corePath = this.getController().getFS().append(this.getSASFoundationRoot(), new String[0]);
        if (TaskHelper.isWindows()) {
            corePath = this.getController().getFS().append(corePath, "core");
        }
        return this.getController().getFS().append(corePath, "sashelp", "core.sas7bcat");
    }

    public static File extractLicenseSetinit() {
        File license;
        Controller controller = Controller.defaultController();
        try {
            SID sid = new SID(controller.getFS().getInputStream(controller.getProperty("SID")));
            SID.SetinitFile setinit = sid.getSetinit();
            File installMisc = new File(ApplySASLicenseTask.getSASHome(), "InstallMisc");
            license = new File(installMisc, "setinit." + UUID.randomUUID() + ".sas");
            if (TaskHelper.getOS_Suffix() == "mvs") {
                if ("TRUE".equalsIgnoreCase(MvsextractTask.getHostProperty("job.submit"))) {
                    license.deleteOnExit();
                }
            } else {
                license.deleteOnExit();
            }
            LogManager.getLogger((String)"ApplySASLicenseTask").info("Extracting license to temp file " + license);
            controller.setProperty(ApplySASLicenseTask.getTaskName() + ".setinitPath", license.getPath());
            setinit.extract(ApplySASLicenseTask.getWriter(license));
        }
        catch (IOException e) {
            throw new InstallException(1, null, new SSNResource(ApplySASLicenseTask.class).messageString("ApplySASLicense.ExtractFailed"), SSNResource.EnglishResource(ApplySASLicense.class).messageString("ApplySASLicense.ExtractFailed"), e);
        }
        return license;
    }

    @Override
    public String descriptionForLog() {
        HashMap<String, String> params = new HashMap<String, String>();
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    protected static Writer getWriter(File license) throws IOException {
        return new FileWriter(license);
    }

    public static String getTaskName() {
        return TASK_NAME;
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void execute() throws InstallException {
        if (Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
            if (!postProcessingInitialized) {
                String key = this.getController().getAltSku().concat(this.getClass().getName());
                this.getController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(true, this.getClass().getName(), "postInstall", ProcessingTaskInfo.Priority.HIGHEST));
                this.getController().getPostProcessingQueue().add(new ProcessingTask(this, this.getClass(), "postInstall", ProcessingTask.Priority.HIGHEST));
            }
            postProcessingInitialized = true;
        } else {
            int post = this.postInstall();
            if (post != 0) {
                throw new InstallException(3, this, this.getBundle().messageString("ApplySASLicense.ReturnCode", post), this.getEnBundle().messageString("ApplySASLicense.ReturnCode", post), null);
            }
        }
        this.deleteAtUninstall(this.getLicenseTarget(), this.getTarget());
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void rollback() throws InstallException {
    }

    public static void setPostProcessingInitialized(boolean postProcessingInitialized) {
        ApplySASLicenseTask.postProcessingInitialized = postProcessingInitialized;
    }
}

