/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.schema.install.gen.ApplyPatchname;
import com.sas.tools.installs.it.schema.install.gen.FileList;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ApplyPatchnameTask
extends InstallationTask {
    protected String _application;
    protected String _args;
    protected String _parameters;
    protected List<String> _fileList;
    protected boolean _postOutputAsProgress = true;
    private static final String APPLICATION = "/utilities/bin/patchname";
    private static HashMap<String, Long> _timestamps = new HashMap();
    private static final String TASK_NAME = "applypatchname";

    @Override
    public void execute() throws InstallException {
        ApplyPatchname data = (ApplyPatchname)this.getData();
        FileList fileList = data.getFileList();
        for (String file : fileList.getFile()) {
            File f = new File(this.resolveProperty(file));
            long timestamp = f.lastModified();
            this.log.debug("Storing " + f.getName() + " with timestamp of " + timestamp + "(" + DateFormat.getDateInstance().format(new Date(timestamp)) + ")");
            _timestamps.put(f.getName(), timestamp);
        }
    }

    @Override
    public void preExecute() throws Exception {
        StringBuffer logString = new StringBuffer(this.getEnBundle().messageString("ExecuteExternalApplication.PreExecuteBegin", this.getApplication()));
        StringBuffer notification = new StringBuffer(this.getBundle().messageString("ExecuteExternalApplication.PreExecuteBegin", this.getApplication()));
        if (this.getArgs() != null) {
            logString.append(this.getEnBundle().messageString("ExecuteExternalApplication.PreExecuteEnd") + this.getArgs());
            notification.append(this.getBundle().messageString("ExecuteExternalApplication.PreExecuteEnd") + this.getArgs());
        }
        if (this.getParameters() != null) {
            logString.append(this.getEnBundle().messageString("ExecuteExternalApplication.PreExecuteEnd") + this.getParameters());
            notification.append(this.getBundle().messageString("ExecuteExternalApplication.PreExecuteEnd") + this.getParameters());
        }
        this.notifySetup(notification.toString(), logString.toString());
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
    }

    @Override
    public void postExecute() throws InstallException {
        if (this.isUndo()) {
            return;
        }
        Vector<String> args = new Vector<String>();
        args.add(this.getApplication());
        if (this.getArgs() != null && this.getArgs().length() > 0) {
            args.addAll(Arrays.asList(this.getArgs().split("\\s+")));
        }
        ApplyPatchname data = (ApplyPatchname)this.getData();
        FileList fileList = data.getFileList();
        for (String file : fileList.getFile()) {
            int returnCode;
            EntryData metadata;
            File f;
            block21: {
                file = this.resolveProperty(file);
                f = new File(file);
                metadata = new EntryData(f);
                this.notifySetup("Changed", metadata, null);
                Vector<String> cmdArgs = new Vector<String>(args);
                Vector<String> testArgs = new Vector<String>(args);
                cmdArgs.add(this.resolveProperty(file));
                testArgs.add(this.resolveProperty(file));
                cmdArgs.add(this.getParameters());
                for (String s : cmdArgs) {
                    this.log.debug("Command Arg: " + s);
                }
                if (this.isFileAlreadyPatched(testArgs, file, this.getParameters())) {
                    this.log.info("The file " + file + " has already been patched.");
                    this.notifyProgressComplete("Skipped");
                    continue;
                }
                ProcessBuilder pb = new ProcessBuilder(cmdArgs);
                Process process = null;
                try {
                    process = pb.start();
                }
                catch (Exception e) {
                    throw new InstallException(1, this, null, "Could not execute " + this.getApplication() + " with args " + this.getArgs() + " and paramters " + this.getParameters() + "on file " + file, e);
                }
                returnCode = -1;
                this.notifyProgressStart("Executing " + cmdArgs.toString());
                if (this.isPostOutputAsProgress()) {
                    BufferedReader confStdOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    block12: while (true) {
                        try {
                            line = confStdOut.readLine();
                        }
                        catch (IOException e) {
                            this.log.error("Error reading output of " + this.getApplication() + e.getMessage());
                        }
                        if (line != null) {
                            this.notifyProgressComplete(line);
                        }
                        try {
                            returnCode = process.exitValue();
                            break block21;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            try {
                                while (true) {
                                    if ((line = confStdOut.readLine()) == null) continue block12;
                                    this.notifyProgressComplete(line);
                                }
                            }
                            catch (IOException iOException) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                boolean childFinished = false;
                while (!childFinished) {
                    try {
                        returnCode = process.waitFor();
                        childFinished = true;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.log.debug("Restoring " + f.getName() + " to timestamp of " + _timestamps.get(f.getName()) + "(" + DateFormat.getDateInstance().format(new Date(_timestamps.get(f.getName()))) + ")");
            f.setLastModified(_timestamps.get(f.getName()));
            if (returnCode != 0) {
                throw new InstallException(1, this, null, this.getApplication() + " with args " + this.getArgs() + " exited with non-zero return code:  " + returnCode, null);
            }
            this.notifyProgressComplete("Successfully Executed " + this.getApplication());
            this.notifyProgressComplete("Changed", metadata);
        }
    }

    public String getArgs() {
        return ((ApplyPatchname)this.getData()).getArgs();
    }

    public String getParameters() {
        return this.resolveProperty(((ApplyPatchname)this.getData()).getParameters());
    }

    public boolean isPostOutputAsProgress() {
        return ((ApplyPatchname)this.getData()).isPostOutput();
    }

    public String getApplication() {
        return Controller.defaultController().getProperty("ProductHome") + APPLICATION;
    }

    @Override
    public String descriptionForLog() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("args", this.getArgs());
        params.put("parameters", this.getParameters());
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    private boolean isFileAlreadyPatched(Vector<String> args, String sourceFileName, String targetPath) {
        boolean bAlreadyPatched = false;
        String checkedPath = "";
        ProcessBuilder pb = new ProcessBuilder(args);
        Process process = null;
        try {
            process = pb.start();
            this.notifyProgressStart("Executing " + args.toString());
            BufferedReader confStdOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            line = confStdOut.readLine();
            if (line != null) {
                String delims = "[=]";
                String[] tokens = line.split(delims);
                for (int i = 0; i < tokens.length; ++i) {
                    if (tokens[i].startsWith("/")) {
                        checkedPath = tokens[i];
                    }
                    if (!checkedPath.equals(targetPath)) continue;
                    bAlreadyPatched = true;
                }
            }
        }
        catch (Exception e) {
            throw new InstallException(1, this, null, "Could not execute " + this.getApplication() + " with args " + this.getArgs() + " and paramters " + this.getParameters() + "on file " + sourceFileName, e);
        }
        return bAlreadyPatched;
    }
}

