/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.RegistryAccess;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.tasks.MvsextractTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.SSNResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SASController {
    private SSNResource _bundle;
    private SSNResource _enBundle;
    private RegistryAccess _access;
    protected static Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.SASController");
    protected Controller _controller;
    private final Set<String> _langsForProduct = new HashSet<String>();
    public static String UNINSTALL_XML = "uninstall.xml";
    protected boolean _mvsWithNoDeploymentRegistry = false;
    public static final String SHAREDFILES = "SHAREDFILES";
    public static final String SHAREDFILES32 = "SHAREDFILES32";
    public static final String SC_CONSUMER = "SHAREDCOMPONENTCONSUMER";
    protected static Map<String, String> NewlyInstalledProductVersions = new HashMap<String, String>();
    protected static Map<String, Vector<String>> NewlyInstalledProductLangs = new HashMap<String, Vector<String>>();

    public SASController() {
        this.setBundle(new SSNResource(SASController.class));
        this.setEnBundle(SSNResource.EnglishResource(SASController.class));
        if ("true".equalsIgnoreCase(System.getProperty("IgnoreDeploymentRegistry"))) {
            this._mvsWithNoDeploymentRegistry = true;
        }
    }

    public SASController(Controller controller) {
        this();
        this.setController(controller);
    }

    public void initialize() throws Exception {
        if (this._mvsWithNoDeploymentRegistry) {
            return;
        }
        String sasHome = null;
        if (TaskHelper.getOS() == 1) {
            sasHome = this.getController().getProperty(SHAREDFILES);
        }
        if (System.getProperty("SASHome") == null) {
            log.error("No SASHome parameter specified upon startup.  Aborting.");
            try {
                this.getController().getView().improperConfiguration(this.getBundle().messageString("Controller.WrongSASHome", ""), null);
            }
            catch (Exception e) {
                log.error("Problem calling improperConfiguration on view", (Throwable)e);
                if (this.getController().isHotfix()) {
                    System.exit(-3);
                }
                throw new InstallException(1, null, this.getBundle().messageString("Controller.WrongSASHome", ""), "No SASHome parameter specified upon startup.  Aborting.", null);
            }
        } else {
            sasHome = System.getProperty("SASHome");
            if (!sasHome.endsWith(File.separator)) {
                sasHome = sasHome + File.separator;
            }
            if (!"0".equals(this.getController().getProperty("MaintVersion")) && !new File(sasHome).exists()) {
                log.error("The SASHome parameter given (" + sasHome + ") does not exist.  Aborting.");
                try {
                    this.getController().getView().improperConfiguration(this.getBundle().messageString("Controller.WrongSASHome", sasHome), null);
                }
                catch (Exception e) {
                    log.error("Problem calling improperConfiguration on view", (Throwable)e);
                    if (this.getController().isHotfix()) {
                        System.exit(-3);
                    }
                    throw new InstallException(1, null, this.getBundle().messageString("Controller.WrongSASHome", sasHome), "The SASHome parameter given (" + sasHome + ") does not exist.  Aborting.", null);
                }
            }
        }
        log.info("Current SAS Home: " + sasHome);
    }

    public String getProductHome(String twelveByte, String version) {
        log.info("SASController:getProductHome() - looking for product home for " + twelveByte + ":" + version);
        if (this.getController().getProperty("ProductHome") != null) {
            return System.getProperty("SASHome") + File.separator + this.getController().getProperty("ProductHome");
        }
        if (this.getController().getProperty("MaintVersion").equals("0")) {
            return System.getProperty("SASHome") + File.separator + twelveByte;
        }
        return this.getProductInstallLocation(true, twelveByte, version, this.getController().getProperty("host"));
    }

    public void initializeWindowsProperties() {
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)SASWinAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib((HashMap)SASWinAPI.libNames);
            throw new InstallException(1, null, this.getBundle().messageString("Controller.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        this.getController().setPropertyForAltSku("WINDIR", System.getenv("WINDIR"), null);
        log.info("set WINDIR property to " + this.getController().getProperty("WINDIR"));
        this.getController().setPropertyForAltSku("WINSYSDIR", SASWinAPI.getSystemDirectory(), null);
        log.info("set WINSYSDIR property to " + this.getController().getProperty("WINSYSDIR"));
        if (SASWinAPI.isWow64() || TaskHelper.getOS_Suffix() == "wx6") {
            this.getController().setPropertyForAltSku("WINSYSDIR32", this.getController().getFS().append(System.getenv("WINDIR"), "SysWow64"), null);
            this.getController().setPropertyForAltSku("WINSYSDIR64", this.getController().getFS().append(System.getenv("WINDIR"), "System32"), null);
            this.getController().setPropertyForAltSku("CommonProgramFiles32", System.getenv("CommonProgramFiles(x86)"), null);
            this.getController().setPropertyForAltSku("CommonProgramFiles", System.getenv("CommonProgramFiles"), null);
            log.info("(Wow64)set CommonProgramFiles32 property to " + this.getController().getProperty("CommonProgramFiles32"));
            log.info("(Wow64)set CommonProgramFiles property to " + this.getController().getProperty("CommonProgramFiles"));
        } else {
            this.getController().setPropertyForAltSku("WINSYSDIR32", this.getController().getFS().append(System.getenv("WINDIR"), "System32"), null);
            this.getController().setPropertyForAltSku("WINSYSDIR64", this.getController().getFS().append(System.getenv("WINDIR"), "System32"), null);
            this.getController().setPropertyForAltSku("CommonProgramFiles32", System.getenv("CommonProgramFiles(x86)"), null);
            this.getController().setPropertyForAltSku("CommonProgramFiles", System.getenv("CommonProgramFiles"), null);
            log.info("set CommonProgramFiles32 property to " + this.getController().getProperty("CommonProgramFiles32"));
            log.info("set CommonProgramFiles property to " + this.getController().getProperty("CommonProgramFiles"));
        }
        log.info("set WINSYSDIR32 property to " + this.getController().getProperty("WINSYSDIR32"));
        log.info("set WINSYSDIR64 property to " + this.getController().getProperty("WINSYSDIR64"));
    }

    protected void setupWindowsSharedFiles() {
        String sharedFilesLoc = null;
        WindowsRegistry winReg = new WindowsRegistry();
        sharedFilesLoc = winReg.getValue(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "");
        if (sharedFilesLoc == null || sharedFilesLoc.equals("")) {
            sharedFilesLoc = System.getProperty("SASHome");
            winReg.setValue(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "", sharedFilesLoc, 109);
        }
        this.getController().setPropertyForAltSku(SHAREDFILES, sharedFilesLoc, null);
        if (TaskHelper.getOS_Suffix().equals("wx6")) {
            sharedFilesLoc = null;
            winReg.setBitMode(32);
            sharedFilesLoc = winReg.getValue(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "");
            if (sharedFilesLoc == null || sharedFilesLoc.equals("")) {
                sharedFilesLoc = this.getController().getFS().append(System.getProperty("SASHome"), "x86");
                winReg.setValue(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "", sharedFilesLoc, 109);
            }
            this.getController().setPropertyForAltSku(SHAREDFILES32, sharedFilesLoc, null);
            log.info("SAS Shared Files 32-bit location: " + this.getController().getProperty(SHAREDFILES32));
            log.info("SAS Shared Files 64-bit location: " + this.getController().getProperty(SHAREDFILES));
        } else {
            this.getController().setPropertyForAltSku(SHAREDFILES32, this.getController().getProperty(SHAREDFILES), null);
            log.info("SAS Shared Files location: " + this.getController().getProperty(SHAREDFILES));
        }
    }

    protected void saveWindowsSharedFiles() {
        String sharedFilesLoc = this.getController().getProperty(SHAREDFILES);
        WindowsRegistry winReg = new WindowsRegistry();
        this.getController().setPropertyForAltSku(SHAREDFILES, sharedFilesLoc, null);
        if (!(this.getController().isHotfix() || this.getController().isUninstall() || this.getController().isMaintenance() || this.getController().isSrwonly())) {
            winReg.setValue(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "", sharedFilesLoc, 109);
        }
        if (TaskHelper.getOS_Suffix().equals("wx6")) {
            winReg.setBitMode(32);
            sharedFilesLoc = this.getController().getFS().append(sharedFilesLoc, "x86");
            this.getController().setPropertyForAltSku(SHAREDFILES32, sharedFilesLoc, null);
            if (!(this.getController().isHotfix() || this.getController().isUninstall() || this.getController().isMaintenance() || this.getController().isSrwonly())) {
                winReg.setValue(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "", sharedFilesLoc, 109);
            }
        }
    }

    public void findWindowsSharedFiles() {
        File sharedFileLocDir;
        String sharedFilesLoc = null;
        WindowsRegistry winReg = new WindowsRegistry();
        sharedFilesLoc = winReg.getValue(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "");
        if (sharedFilesLoc != null && !sharedFilesLoc.equals("") && !(sharedFileLocDir = new File(sharedFilesLoc)).exists()) {
            String subKey = "SOFTWARE\\SAS Institute Inc.\\Common Data";
            log.info("SAS Windows Registry Key " + subKey + " is no longer used. Removing the left over registry key.");
            this.cleanupLeftoverWindowsRegKeyTree();
            return;
        }
        if (sharedFilesLoc == null || sharedFilesLoc.equals("")) {
            sharedFilesLoc = System.getProperty("SASHome");
        }
        this.getController().setPropertyForAltSku(SHAREDFILES, sharedFilesLoc, null);
        if (TaskHelper.getOS_Suffix().equals("wx6")) {
            sharedFilesLoc = null;
            winReg.setBitMode(32);
            sharedFilesLoc = winReg.getValue(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "");
            if (sharedFilesLoc == null || sharedFilesLoc.equals("")) {
                sharedFilesLoc = this.getController().getFS().append(System.getProperty("SASHome"), "x86");
            }
            this.getController().setPropertyForAltSku(SHAREDFILES32, sharedFilesLoc, null);
            log.info("SAS Shared Files 32-bit location: " + this.getController().getProperty(SHAREDFILES32));
            log.info("SAS Shared Files 64-bit location: " + this.getController().getProperty(SHAREDFILES));
        } else {
            this.getController().setPropertyForAltSku(SHAREDFILES32, this.getController().getProperty(SHAREDFILES), null);
            log.info("SAS Shared Files location: " + this.getController().getProperty(SHAREDFILES));
        }
    }

    private void cleanupLeftoverWindowsRegKeyTree() {
        int hKey = 8;
        String subKey = "SOFTWARE\\SAS Institute Inc.\\Common Data";
        boolean bRemoved = WinRegAPI.DelRegTree((int)hKey, (String)subKey, (boolean)true);
        if (bRemoved) {
            log.info("64 bit of the SAS Windows Registry Key is successfully removed.");
        } else {
            log.info("64 bit of the SAS Windows Registry Key is not removed.");
        }
        bRemoved = WinRegAPI.DelRegTree((int)hKey, (String)subKey, (boolean)false);
        if (bRemoved) {
            log.info("32 bit of the SAS Windows Registry Key is successfully removed.");
        } else {
            log.info("32 bit of the SAS Windows Registry Key is not removed.");
        }
    }

    public void initializeCommonProperties() {
        log.info("initializing common properties:  SHAREDFILES, WINSYSDIR, JREHOME");
        String sDataLoc = Controller.installProperties.getProperty("data.loc");
        log.info("Install location is set to " + sDataLoc);
        String jreLocation = null;
        jreLocation = TaskHelper.getOS() == 8 && Controller.installProperties.getProperty("deployment.jre.home") != null ? Controller.installProperties.getProperty("deployment.jre.home") : Controller.installProperties.getProperty("jre.home");
        log.info("JRE location is set to " + jreLocation);
        File javaBin = new File(jreLocation, "bin");
        File java = new File(javaBin, "java");
        if (TaskHelper.getOS() == 1) {
            java = new File(javaBin, "java.exe");
        }
        this.getController().setPropertyForAltSku("JAVAEXE", java.getAbsolutePath(), null);
        log.info("set JAVAEXE property to " + this.getController().getProperty("JAVAEXE"));
        File javaExe = new File(this.getController().getProperty("JAVAEXE"));
        File jreHome = javaExe.getParentFile().getParentFile();
        this.getController().setPropertyForAltSku("JREHOME", jreHome.getAbsolutePath(), null);
        System.setProperty("JREHOME", jreHome.getAbsolutePath());
        log.info("set JREHOME property to " + this.getController().getProperty("JREHOME"));
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
        String dateTimeStamp = dtf.format(Calendar.getInstance().getTime());
        this.getController().setProperty("os.timestamp", dateTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preExecute(int buildFileIndex) throws Exception {
        boolean retval = true;
        log.info("preexecute in sascontroller");
        if (this.getController().isHotfix() && !this.getController().isMaintenanceVersionCheckingSkipped()) {
            try {
                this.getAccess().open();
                this.getInstallLocation(false);
                this.loadInstalledLangsForProduct(false);
                if (!Controller.uninstall_mode) {
                    if (!this.hasProductVersion()) {
                        this.getController().getCurrentContext().setUninstallableReason(this.getBundle().messageString("SASController.MissingProductVersion"));
                        log.info("skipping processing of " + this.getController().getAltSkus().get(buildFileIndex) + " because no version of this product is installed");
                        retval = false;
                    } else if (!this.hasProductVersionOnHost()) {
                        this.getController().getCurrentContext().setUninstallableReason(this.getBundle().messageString("SASController.WrongHost"));
                        log.info("skipping processing of " + this.getController().getAltSkus().get(buildFileIndex) + " because no version of this product is installed on this host");
                        retval = false;
                    } else if (!this.hasRequiredProductVersion(false)) {
                        this.getController().getCurrentContext().setUninstallableReason(this.getBundle().messageString("SASController.MissingRequiredProductVersion", this.getController().getProperty("ProductVersion")));
                        log.info("skipping processing of " + this.getController().getAltSkus().get(buildFileIndex) + " because the required product version is not installed");
                        retval = false;
                    }
                    if (this.getController().isMvsMVAHotfix()) {
                        String hotfixEncoding = this.getController().getProperty("ProductLanguage");
                        if (!(hotfixEncoding.equalsIgnoreCase("ne") || hotfixEncoding.equalsIgnoreCase("xx") || hotfixEncoding.equalsIgnoreCase(MvsextractTask.UserParams.get("ORDERENCODING")))) {
                            this.getController().getCurrentContext().setUninstallableReason("<br>");
                            log.debug("skipping processing of " + this.getController().getAltSkus().get(buildFileIndex) + " because the encoding doesn't match the user's installed encoding");
                            boolean bl = false;
                            return bl;
                        }
                        this.getController().setLanguageCheckSkipped(true);
                    } else if (!retval || this.getController().isLanguageCheckSkipped()) {
                        log.info("Language checking skipped");
                    } else if (!this.isLangForProductInstalled(this.getController().getProperty("ProductLanguage"))) {
                        this.getController().getCurrentContext().setUninstallableReason(this.getBundle().messageString("SASController.LanguageNotInstalled", this.getBundle().messageString("Common.LangCode" + this.getController().getProperty("ProductLanguage").toUpperCase() + ".txt")) + "<br>");
                        log.info("skipping processing of " + this.getController().getAltSkus().get(buildFileIndex) + " because the target language is not installed");
                        retval = false;
                    }
                    if (!retval || this.getController().isMaintenanceVersionCheckingSkipped()) {
                        log.info("Version checking skipped");
                    } else {
                        if (!this.hasRequiredMaintenanceLevel(false)) {
                            this.getController().getCurrentContext().setUninstallableReason(this.getBundle().messageString("Controller.MissingRequiredMaintenance", this.getMaintLevel(false)));
                            log.info("skipping processing of " + this.getController().getAltSkus().get(buildFileIndex) + " because the target maintenance level is not installed");
                            retval = false;
                        }
                        if (this.maintenanceAlreadyExists(false)) {
                            this.getController().getCurrentContext().setUninstallableReason(this.getBundle().messageString("Controller.InstallationUnnecessary"));
                            log.info("skipping processing of " + this.getController().getAltSkus().get(buildFileIndex) + " because this maintenance package has already been applied");
                            retval = false;
                        }
                    }
                }
            }
            finally {
                this.getAccess().close();
            }
        }
        this.initializeCommonProperties();
        if (TaskHelper.getOS() == 1) {
            this.initializeWindowsProperties();
        }
        log.info("Product code: " + this.getController().getProperty("12ByteCode").toLowerCase());
        log.info("Platform: " + this.getController().getProperty("host"));
        log.info("Target language: " + this.getController().getProperty("ProductLanguage"));
        log.info("Hot Fix: " + this.getController().getProperty("HotFixVersion"));
        log.info("Hot Fix minimum version: " + this.getController().getProperty("MinimumMaintVersion"));
        log.info("Hot Fix maximum version: " + this.getController().getProperty("MaximumMaintVersion") + ("true".equals(this.getController().getProperty("MaximumMaintExclusive")) ? " (exclusive)" : ""));
        log.info("Maintenance Version: " + this.getController().getProperty("MaintVersion"));
        log.info("Required installed product version: " + this.getController().getProperty("ProductVersion"));
        if (this.getController().getProperty("12ByteCode") == null) {
            log.error("No 12ByteCode parameter specified upon startup.  Aborting.");
            this.getController().getView().improperConfiguration(this.getBundle().messageString("Controller.Missing12Byte"), null);
            return false;
        }
        if (this.getController().isProductVersionCheckingBypassed()) {
            log.info("Version Checking Bypassed... Skipping product deployment registry checks");
            return true;
        }
        if (this.getController().getProperty("ProductVersion") == null || this.getController().getProperty("ProductVersion").length() == 0) {
            log.info("New product install of " + this.getController().getProperty("12ByteCode"));
            if (this.getController().isZosHost() && this.getController().getProperty("HostMultiPlatform") == null) {
                NewlyInstalledProductVersions.put(this.getController().getProperty("12ByteCode"), this.getController().getProperty("ProductVersion"));
                Vector<String> langs = NewlyInstalledProductLangs.get(this.getController().getProperty("12ByteCode"));
                if (langs == null) {
                    langs = new Vector();
                }
                langs.add(this.getController().getProperty("ProductLanguage"));
                NewlyInstalledProductLangs.put(this.getController().getProperty("12ByteCode"), langs);
            }
            return true;
        }
        if (this.getController().getProperty("HotFixVersion") != null) {
            log.info("Hotfix version to apply: " + this.getController().getProperty("HotFixVersion"));
        } else if (!this.getController().getProperty("MaintVersion").equals("")) {
            log.info("Maintenance version to apply: " + this.getController().getProperty("MaintVersion"));
        }
        if ((this.getController().getProperty("HotFixVersion") == null || this.getController().getProperty("HotFixVersion").equals("0")) && this.getController().getProperty("MaintVersion").equals("0")) {
            log.info("New product to install: " + this.getController().getProperty("12ByteCode"));
            return true;
        }
        return retval;
    }

    public String getWinRegKeyValueForTargetedHost(int regHive, String regKey, String regName, String host) {
        String value = null;
        if (!JNIUtils.libraryLoaded((String)JNIUtils.JNI_LIB_BASE, (HashMap)WinRegAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib((HashMap)SASWinAPI.libNames);
            throw new InstallException(1, null, this.getBundle().messageString("Controller.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        value = (TaskHelper.getOS_Suffix().equals("wx6") || TaskHelper.getOS_Suffix().equals("w64")) && host.equalsIgnoreCase("win") ? WinRegAPI.getWinRegValue32((int)regHive, (String)regKey, (String)regName) : WinRegAPI.getWindowsRegistryValue((int)regHive, (String)regKey, (String)regName);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProductInstallLocation(boolean needToOpenRegistry, String twelveByte, String version, String host) {
        if (needToOpenRegistry) {
            this.getAccess().open();
        }
        try {
            String installLocation = null;
            String string = installLocation = this.getAccess().getInstallLoc(twelveByte, version, host);
            return string;
        }
        finally {
            if (needToOpenRegistry) {
                this.getAccess().close();
            }
        }
    }

    public String getInstallLocation(boolean needToOpenRegistry) {
        return this.getProductInstallLocation(needToOpenRegistry, this.getController().getProperty("12ByteCode").toLowerCase(), this.getController().getProperty("ProductVersion"), this.getController().getProperty("host"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInstallLocation(boolean needToOpenRegistry, String productCode, String requiredProductVersion, String host) {
        if (needToOpenRegistry) {
            this.getAccess().open();
        }
        try {
            String installLocation = null;
            String string = installLocation = this.getAccess().getInstallLoc(productCode, requiredProductVersion, host);
            return string;
        }
        finally {
            if (needToOpenRegistry) {
                this.getAccess().close();
            }
        }
    }

    public Vector<String> getRemovableHotfixes(String hotfixID, String twelveByte, String version, String host) {
        Vector<String> retval = new Vector<String>();
        Vector<String> allMaints = null;
        String maintLevel = null;
        if (host == null) {
            allMaints = new Vector<String>(Arrays.asList(this.getAccess().getMaintVersions(twelveByte.toLowerCase(), version)));
            maintLevel = this.getAccess().getMaintLevel(twelveByte.toLowerCase(), version);
        } else {
            allMaints = new Vector<String>(Arrays.asList(this.getAccess().getMaintVersions(twelveByte.toLowerCase(), version, host)));
            maintLevel = this.getAccess().getMaintLevel(twelveByte.toLowerCase(), version, host);
        }
        boolean currentMaintReached = false;
        boolean currentHotfixReached = false;
        for (String maint : allMaints) {
            if (!maint.equals(maintLevel) && !currentMaintReached) continue;
            if (!currentMaintReached) {
                currentMaintReached = true;
                continue;
            }
            if (!maint.equals(hotfixID) && !currentHotfixReached) continue;
            if (!currentHotfixReached) {
                currentHotfixReached = true;
                retval.add(hotfixID);
                continue;
            }
            retval.add(maint);
        }
        return retval;
    }

    public File getUninstallXML() {
        return new File(new File(System.getProperty("SASHome"), "InstallMisc"), UNINSTALL_XML);
    }

    public String uninstallStringForHotfix(String hotfixID) throws Exception {
        File uninstallData = this.getUninstallXML();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = null;
        if (uninstallData.isFile()) {
            document = builder.parse(uninstallData);
            String xpathString = "//hotfix[@id='" + hotfixID + "']";
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            Element target = (Element)xPath.evaluate(xpathString, document, XPathConstants.NODE);
            if (target == null) {
                return null;
            }
            return target.getTextContent();
        }
        return null;
    }

    private boolean hasProductVersion() {
        boolean hasProductVersion = false;
        String product = this.getController().getProperty("12ByteCode").toLowerCase();
        String[] hosts = this.getAccess().getInstallHosts();
        for (int i = 0; hosts != null && i < hosts.length; ++i) {
            String[] versions = this.getAccess().getInstallVersions(product, hosts[i]);
            if (versions == null || versions.length <= 0) continue;
            hasProductVersion = true;
            log.info("Found " + product + " on " + hosts[i]);
        }
        return hasProductVersion;
    }

    private boolean hasProductVersionOnHost() {
        String[] versions = this.getAccess().getInstallVersions(this.getController().getProperty("12ByteCode").toLowerCase(), this.getController().getProperty("host"));
        return versions != null && versions.length > 0;
    }

    public boolean hasRequiredProductVersion(boolean needToOpenRegistry) {
        String installLocation = this.getInstallLocation(needToOpenRegistry);
        if (installLocation != null) {
            log.info("Product install location: " + installLocation);
            log.info("Required product version is installed");
            return true;
        }
        String newlyInstalledVersion = NewlyInstalledProductVersions.get(this.getController().getProperty("12ByteCode"));
        if (this.getController().getProperty("ProductVersion").equals(newlyInstalledVersion)) {
            log.info("Product install location (being newly installed in this pass): " + installLocation);
            log.info("Required product version is present, maintenance will be installed");
            return true;
        }
        log.info("Required product version " + this.getController().getProperty("ProductVersion") + " is not installed");
        return false;
    }

    public boolean hasRequiredMaintenanceLevel(boolean needToOpenRegistry) {
        if (needToOpenRegistry) {
            this.getAccess().open();
        }
        String actualMaintLevel = null;
        try {
            actualMaintLevel = this.getAccess().getMaintLevel(this.getController().getProperty("12ByteCode").toLowerCase(), this.getController().getProperty("ProductVersion"), this.getController().getProperty("host"));
        }
        finally {
            if (needToOpenRegistry) {
                this.getAccess().close();
            }
        }
        if (actualMaintLevel == null) {
            log.info("Installed maintenance version is not defined");
            return false;
        }
        log.info("Installed maintenance version: " + actualMaintLevel);
        boolean verCompatible = true;
        if (this.getController().isHotfix()) {
            verCompatible = verCompatible && this.hasRequiredMaintenanceForHotfix(actualMaintLevel);
        }
        return verCompatible;
    }

    private boolean hasRequiredMaintenanceForHotfix(String actualMaintLevel) {
        boolean verCompatible = true;
        Integer actual = Integer.valueOf(actualMaintLevel);
        String minMaintVer = this.getController().getProperty("MinimumMaintVersion");
        String maxMaintVer = this.getController().getProperty("MaximumMaintVersion");
        if (minMaintVer != null) {
            boolean bl = verCompatible = verCompatible && actual >= Integer.valueOf(minMaintVer);
        }
        if (maxMaintVer != null) {
            boolean exclusive = "true".equals(this.getController().getProperty("MaximumMaintExclusive"));
            verCompatible = exclusive ? verCompatible && actual < Integer.valueOf(maxMaintVer) : verCompatible && actual <= Integer.valueOf(maxMaintVer);
        }
        return verCompatible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maintenanceAlreadyExists(boolean needToOpenRegistry) {
        block7: {
            if (!this.getController().isHotfix()) break block7;
            String maintVersionString = this.getController().getProperty("HotFixVersion");
            if (needToOpenRegistry) {
                this.getAccess().open();
            }
            String maintDisplayName = null;
            boolean isInstalled = false;
            try {
                maintDisplayName = this.getAccess().getMaintDisplayName(this.getController().getProperty("12ByteCode").toLowerCase(), this.getController().getProperty("ProductVersion"), this.getController().getProperty("host"), maintVersionString);
                boolean bl = isInstalled = maintDisplayName != null && maintDisplayName.length() > 0;
            }
            catch (Throwable throwable) {
                boolean bl = isInstalled = maintDisplayName != null && maintDisplayName.length() > 0;
                if (isInstalled) {
                    log.info("Maintenance " + maintDisplayName + " is already installed");
                }
                if (needToOpenRegistry) {
                    this.getAccess().close();
                }
                throw throwable;
            }
            if (isInstalled) {
                log.info("Maintenance " + maintDisplayName + " is already installed");
            }
            if (needToOpenRegistry) {
                this.getAccess().close();
            }
            return isInstalled;
        }
        return true;
    }

    public String getMaintLevel(boolean needToOpenRegistry) {
        if (needToOpenRegistry) {
            this.getAccess().open();
        }
        try {
            String string = this.getAccess().getMaintLevel(this.getController().getProperty("12ByteCode").toLowerCase(), this.getController().getProperty("ProductVersion"), this.getController().getProperty("host"));
            return string;
        }
        finally {
            if (needToOpenRegistry) {
                this.getAccess().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInstallLanguages(boolean needToOpenRegistry) {
        if (needToOpenRegistry) {
            this.getAccess().open();
        }
        try {
            String[] registryLangs = this.getAccess().getInstallLanguages(this.getController().getProperty("12ByteCode").toLowerCase(), this.getController().getProperty("ProductVersion"), this.getController().getProperty("host"));
            Vector<String> langs = NewlyInstalledProductLangs.get(this.getController().getProperty("12ByteCode"));
            if (langs != null) {
                String[] retval = new String[langs.size() + registryLangs.length];
                System.arraycopy(registryLangs, 0, retval, 0, registryLangs.length);
                int counter = 0;
                String[] stringArray = langs.iterator();
                while (stringArray.hasNext()) {
                    String lang;
                    retval[registryLangs.length + counter] = lang = stringArray.next();
                }
                stringArray = retval;
                return stringArray;
            }
            String[] stringArray = registryLangs;
            return stringArray;
        }
        finally {
            if (needToOpenRegistry) {
                this.getAccess().close();
            }
        }
    }

    protected void loadInstalledLangsForProduct(boolean needToOpenRegistry) {
        this._langsForProduct.addAll(Arrays.asList(this.getInstallLanguages(needToOpenRegistry)));
    }

    public Set<String> getInstalledLangsForProduct() {
        return this._langsForProduct;
    }

    public boolean isLangForProductInstalled(String lang) {
        if (lang.equalsIgnoreCase("xx")) {
            log.info("Language code is xx indicating the update is for any or all languages");
            return true;
        }
        if (this.getInstalledLangsForProduct().isEmpty()) {
            log.info("List of installed languages not present");
            return true;
        }
        log.info("List of installed languages: " + this.getInstalledLangsForProduct().toString());
        if (this.getInstalledLangsForProduct().contains(lang)) {
            log.info("Required product language is installed");
            return true;
        }
        log.warn("Required product language is not installed");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMaintenanceRegistryUpdateScript(String maintDisplayName, String maintVersionString) throws Exception {
        String msg;
        File registryData = new File(new File(System.getProperty("SASHome"), "InstallMisc"), "DepRegUpdateData.xml");
        log.info("writing registry update instructions to " + registryData.getAbsolutePath() + " rather than updating the registry programmatically");
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = null;
        Element deploymentRegistry = null;
        if (registryData.isFile()) {
            document = builder.parse(registryData);
            deploymentRegistry = document.getDocumentElement();
        } else {
            String view = System.getProperty("MajorRelease");
            document = builder.newDocument();
            deploymentRegistry = document.createElement("deploymentRegistry");
            if (view != null) {
                deploymentRegistry.setAttribute("view", view);
            }
            document.appendChild(deploymentRegistry);
        }
        Element execute = document.createElement("execute");
        String installLocation = this.getController().getInstallLocation();
        String productCode = this.getController().getProperty("12ByteCode").toLowerCase();
        String version = this.getController().getProperty("ProductVersion");
        String host = this.getController().getProperty("host");
        String versionToRemove = null;
        String altSkuType = this.getController().getProperty("AltSkuType").toLowerCase();
        if (altSkuType.equals("full") && Controller.uninstall_mode && !this.getController().isHotfix()) {
            try {
                this.getAccess().open();
                String[] maintVersions = this.getAccess().getMaintVersions(productCode, version, host);
                if (maintVersions == null || maintVersions.length == 1) {
                    versionToRemove = version;
                }
            }
            catch (Exception e) {
                log.error("Deployment registry failure", (Throwable)e);
            }
            finally {
                this.getAccess().close();
            }
        }
        if (versionToRemove != null) {
            msg = String.format("The product %s %s %s is the only full maintenance sku installed for this product and will be removed.", productCode, version, host);
            log.info(msg);
            execute = document.createElement("execute");
            execute.setAttribute("method", "removeInstall");
            execute.setAttribute("param1", productCode);
            execute.setAttribute("param2", versionToRemove);
            execute.setAttribute("param3", host);
            deploymentRegistry.appendChild(execute);
        } else {
            execute.setAttribute("method", "setMaintDisplayName");
            execute.setAttribute("param1", productCode);
            execute.setAttribute("param2", version);
            execute.setAttribute("param3", host);
            execute.setAttribute("param4", maintVersionString);
            execute.setAttribute("param5", maintDisplayName);
            deploymentRegistry.appendChild(execute);
            if (this.getController().isMaintenance()) {
                execute = document.createElement("execute");
                execute.setAttribute("method", "setMaintLevel");
                execute.setAttribute("param1", productCode);
                execute.setAttribute("param2", version);
                execute.setAttribute("param3", host);
                execute.setAttribute("param4", this.getController().getProperty("MaintVersion"));
                deploymentRegistry.appendChild(execute);
            }
            if (this.getController().isLanguageCheckSkipped() && !this.getInstalledLangsForProduct().isEmpty()) {
                execute = document.createElement("execute");
                execute.setAttribute("method", "addInstallLanguage");
                execute.setAttribute("param1", productCode);
                execute.setAttribute("param2", version);
                execute.setAttribute("param3", host);
                execute.setAttribute("param4", this.getController().getProperty("ProductLanguage"));
                deploymentRegistry.appendChild(execute);
            }
            if (!this.getController().isHotfix()) {
                execute = document.createElement("execute");
                execute.setAttribute("method", "setInstallStatus");
                execute.setAttribute("param1", productCode);
                execute.setAttribute("param2", version);
                execute.setAttribute("param3", host);
                execute.setAttribute("param4", "0");
                execute.setAttribute("param5", "");
                execute.setAttribute("param6", "");
                deploymentRegistry.appendChild(execute);
                execute = document.createElement("execute");
                execute.setAttribute("method", "setInstallLogFile");
                execute.setAttribute("param1", productCode);
                execute.setAttribute("param2", version);
                execute.setAttribute("param3", host);
                execute.setAttribute("param4", this.getController().getLogPath().getPath());
                deploymentRegistry.appendChild(execute);
                execute = document.createElement("execute");
                execute.setAttribute("method", "setInstallLoc");
                execute.setAttribute("param1", productCode);
                execute.setAttribute("param2", version);
                execute.setAttribute("param3", host);
                execute.setAttribute("param4", installLocation);
                deploymentRegistry.appendChild(execute);
                execute = document.createElement("execute");
                execute.setAttribute("method", "setInstallFamily");
                execute.setAttribute("param1", productCode);
                execute.setAttribute("param2", version);
                execute.setAttribute("param3", host);
                execute.setAttribute("param4", "9.4");
                deploymentRegistry.appendChild(execute);
                try {
                    this.getAccess().open();
                    versionToRemove = this.versionToReplace(productCode, version, host, installLocation, this.getAccess());
                    if (versionToRemove != null) {
                        msg = String.format("The product %s version %s for host %s will be replaced by version %s.", productCode, versionToRemove, host, version);
                        log.info(msg);
                        execute = document.createElement("execute");
                        execute.setAttribute("method", "removeInstall");
                        execute.setAttribute("param1", productCode);
                        execute.setAttribute("param2", versionToRemove);
                        execute.setAttribute("param3", host);
                        deploymentRegistry.appendChild(execute);
                    }
                }
                catch (Exception e) {
                    log.error("Deployment registry failure", (Throwable)e);
                }
                finally {
                    this.getAccess().close();
                }
            }
        }
        OutputStream os = null;
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            os = new FileOutputStream(registryData);
            tr.transform(new DOMSource(document), new StreamResult(os));
        }
        catch (Exception e) {
            throw new InstallException(1, null, this.getBundle().messageString("SASController.FileCreationFailure", registryData.getAbsolutePath()), this.getEnBundle().messageString("SASController.FileCreationFailure", registryData.getAbsolutePath()), e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.removeBlankLines(registryData);
        log.info("Wrote deployment registry update instructions:  " + registryData.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewInstallRegistryUpdateScript() throws Exception {
        File registryData = new File(new File(System.getProperty("SASHome"), "InstallMisc"), "DepRegUpdateData.xml");
        log.info("writing registry update instructions to " + registryData.getAbsolutePath() + " rather than updating the registry programmatically");
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = null;
        Element deploymentRegistry = null;
        if (registryData.isFile()) {
            document = builder.parse(registryData);
            deploymentRegistry = document.getDocumentElement();
        } else {
            String view = System.getProperty("MajorRelease");
            document = builder.newDocument();
            deploymentRegistry = document.createElement("deploymentRegistry");
            if (view != null) {
                deploymentRegistry.setAttribute("view", view);
            }
            document.appendChild(deploymentRegistry);
        }
        String productCode = this.getController().getProperty("12ByteCode").toLowerCase();
        String version = this.getController().getProperty("ProductVersion");
        String host = this.getController().getProperty("host");
        String installLocation = this.getController().getInstallLocation();
        Element execute = document.createElement("execute");
        execute.setAttribute("method", "setInstallStatus");
        execute.setAttribute("param1", productCode);
        execute.setAttribute("param2", version);
        execute.setAttribute("param3", host);
        execute.setAttribute("param4", "0");
        deploymentRegistry.appendChild(execute);
        execute = document.createElement("execute");
        execute.setAttribute("method", "setInstallLoc");
        execute.setAttribute("param1", productCode);
        execute.setAttribute("param2", version);
        execute.setAttribute("param3", host);
        execute.setAttribute("param4", installLocation);
        deploymentRegistry.appendChild(execute);
        execute = document.createElement("execute");
        execute.setAttribute("method", "setInstallLogFile");
        execute.setAttribute("param1", productCode);
        execute.setAttribute("param2", version);
        execute.setAttribute("param3", host);
        execute.setAttribute("param4", this.getController().getLogPath().getPath());
        deploymentRegistry.appendChild(execute);
        execute = document.createElement("execute");
        execute.setAttribute("method", "setInstallFamily");
        execute.setAttribute("param1", productCode);
        execute.setAttribute("param2", version);
        execute.setAttribute("param3", host);
        execute.setAttribute("param4", "9.4");
        deploymentRegistry.appendChild(execute);
        String maintVer = "0";
        execute = document.createElement("execute");
        execute.setAttribute("method", "setMaintDisplayName");
        execute.setAttribute("param1", productCode);
        execute.setAttribute("param2", version);
        execute.setAttribute("param3", host);
        execute.setAttribute("param4", "0");
        execute.setAttribute("param5", version);
        deploymentRegistry.appendChild(execute);
        execute = document.createElement("execute");
        execute.setAttribute("method", "setMaintLevel");
        execute.setAttribute("param1", productCode);
        execute.setAttribute("param2", version);
        execute.setAttribute("param3", host);
        execute.setAttribute("param4", "0");
        deploymentRegistry.appendChild(execute);
        execute = document.createElement("execute");
        execute.setAttribute("method", "addInstallLanguage");
        execute.setAttribute("param1", productCode);
        execute.setAttribute("param2", version);
        execute.setAttribute("param3", host);
        execute.setAttribute("param4", this.getController().getProperty("ProductLanguage"));
        deploymentRegistry.appendChild(execute);
        try {
            this.getAccess().open();
            String versionToRemove = this.versionToReplace(productCode, version, host, installLocation, this.getAccess());
            if (versionToRemove != null) {
                String msg = String.format("The product %s version %s for host %s will be replaced by version %s.", productCode, versionToRemove, host, version);
                log.info(msg);
                execute = document.createElement("execute");
                execute.setAttribute("method", "removeInstall");
                execute.setAttribute("param1", productCode);
                execute.setAttribute("param2", versionToRemove);
                execute.setAttribute("param3", host);
                deploymentRegistry.appendChild(execute);
            }
        }
        catch (Exception e) {
            log.error("Deployment registry failure", (Throwable)e);
        }
        finally {
            this.getAccess().close();
        }
        OutputStream os = null;
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            os = new FileOutputStream(registryData);
            tr.transform(new DOMSource(document), new StreamResult(os));
        }
        catch (Exception e) {
            throw new InstallException(1, null, this.getBundle().messageString("SASController.FileCreationFailure", registryData.getAbsolutePath()), this.getEnBundle().messageString("SASController.FileCreationFailure", registryData.getAbsolutePath()), e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                log.error("Exception closing " + registryData, (Throwable)e);
            }
        }
        Utils.removeBlankLines(registryData);
        log.info("Wrote deployment registry update instructions:  " + registryData.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaintenanceDeploymentRegistry(String maintDisplayName, String maintVersionString) {
        try {
            String product = this.getController().getProperty("12ByteCode").toLowerCase();
            String reqVersion = this.getController().getProperty("ProductVersion");
            String host = this.getController().getProperty("host");
            String language = this.getController().getProperty("ProductLanguage");
            String installLocation = this.getController().getInstallLocation();
            this.getAccess().open();
            if (Controller.uninstall_mode) {
                String action = "failed to remove";
                String lastMaint = this.getAccess().getMaintLastApplied(product, reqVersion, host);
                if (!maintVersionString.equals(lastMaint)) {
                    if (this.getAccess().setMaintDisplayName(product, reqVersion, host, maintVersionString, "")) {
                        action = "disabled";
                    }
                } else if (this.getAccess().removeMaint(product, reqVersion, host, maintVersionString)) {
                    action = "removed";
                }
                log.info(action + " maintenance entry with the following values from the deployment  registry:\n\t12 Byte=>" + product + "\n\tProduct Version=>" + reqVersion + "\n\tHost=>" + host + "\n\tMaintenance Version=>" + maintVersionString);
                String[] maintVersions = this.getAccess().getMaintVersions(product, reqVersion, host);
                if (maintVersions == null || maintVersions.length == 0) {
                    this.getAccess().removeInstall(product, reqVersion, host);
                }
            } else {
                String versionToRemove;
                this.getAccess().setInstallLoc(product, reqVersion, host, this.getController().getInstallLocation());
                this.getAccess().setInstallFamily(product, reqVersion, host, "9.4");
                this.getAccess().setMaintDisplayName(product, reqVersion, host, maintVersionString, maintDisplayName);
                log.info("set maintenance display name to " + maintDisplayName + " for entry with the following values from the deployment registry:\n\t12 Byte=>" + product + "\n\tProduct Version=>" + reqVersion + "\n\tHost=>" + host + "\n\tMaintenance Version=>" + maintVersionString);
                if (this.getController().isMaintenance()) {
                    String maintVersion = this.getController().getProperty("MaintVersion");
                    this.getAccess().setMaintLevel(product, reqVersion, host, maintVersion);
                    log.info("set maintenance level to " + maintVersion + " for entry with the  following values from the deployment registry:\n\t12 Byte=>" + product + "\n\tProduct Version=>" + reqVersion + "\n\tHost=>" + host);
                }
                String uninstallPath = new File(this.getController().metadataBackupDirectory(), this.getController().getProperty("Install Filename")).getAbsolutePath();
                if ("xx".equalsIgnoreCase(language)) {
                    this.getAccess().setMaintUninstallLoc(product, reqVersion, host, maintVersionString, uninstallPath);
                } else {
                    this.getAccess().setMaintUninstallLoc(product, reqVersion, host, maintVersionString, language, uninstallPath);
                    if (this.getController().isLanguageCheckSkipped() && !this.getInstalledLangsForProduct().isEmpty()) {
                        this.getAccess().addInstallLanguage(product, reqVersion, host, language);
                    }
                }
                log.info("set maintenance uninstall location to " + uninstallPath + " for entry with the following values from the deployment registry:\n\t\n\t12 Byte=>" + product + "\n\tProduct Version=>" + reqVersion + "\n\tHost=>" + host + "\n\tMaintenance Version=>" + maintVersionString);
                if (!this.getController().isHotfix() && (versionToRemove = this.versionToReplace(product, reqVersion, host, installLocation, this.getAccess())) != null) {
                    String msg = String.format("The product %s version %s for host %s will be removed", product, versionToRemove, host);
                    log.info(msg);
                    this.getAccess().removeInstall(product, versionToRemove, host);
                }
            }
            String altSkuType = this.getController().getProperty("AltSkuType").toLowerCase();
            if (!this.getController().isHotfix() && (altSkuType.equals("maint") || altSkuType.equals("full")) && !Controller.uninstall_mode) {
                this.getAccess().setInstallStatus(product, reqVersion, host, "0", "", "");
                this.getAccess().setInstallLogFile(product, reqVersion, host, this.getController().getDefaultLog().getPath());
            }
        }
        finally {
            this.getAccess().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNewInstallDeploymentRegistry() {
        try {
            this.getAccess().open();
            String product = this.getController().getProperty("12ByteCode").toLowerCase();
            String version = this.getController().getProperty("ProductVersion");
            String language = this.getController().getProperty("ProductLanguage");
            String host = this.getController().getProperty("host");
            if (Controller.uninstall_mode) {
                this.getAccess().removeInstall(product, version, host);
                log.info("removed product entry with the following values from the deployment registry:\n\t12 Byte=>" + product + "\n\tProduct Version=>" + version + "\n\tHost=>" + host);
            } else {
                String lang = this.getController().getProperty("ProductLanguage");
                String maintVer = "0";
                String installLocation = this.getController().getInstallLocation();
                this.getAccess().setInstallStatus(product, version, host, "0");
                this.getAccess().setInstallLoc(product, version, host, installLocation);
                this.getAccess().setInstallLogFile(product, version, host, this.getController().getDefaultLog().getPath());
                this.getAccess().setInstallFamily(product, version, host, "9.4");
                this.getAccess().setMaintDisplayName(product, version, host, "0", version);
                this.getAccess().setMaintLevel(product, version, host, "0");
                String uninstallPath = new File(this.getController().metadataBackupDirectory(), this.getController().getProperty("Install Filename")).getAbsolutePath();
                if ("xx".equalsIgnoreCase(language)) {
                    this.getAccess().setMaintUninstallLoc(product, version, host, "0", uninstallPath);
                } else {
                    this.getAccess().setMaintUninstallLoc(product, version, host, "0", language, uninstallPath);
                    this.getAccess().addInstallLanguage(product, version, host, lang);
                }
                String versionToRemove = this.versionToReplace(product, version, host, installLocation, this.getAccess());
                if (versionToRemove != null) {
                    String msg = String.format("The product %s version %s for host %s will be replaced by version %s.", product, versionToRemove, host, version);
                    log.info(msg);
                    this.getAccess().removeInstall(product, versionToRemove, host);
                }
            }
        }
        catch (Exception e) {
            log.error("Deployment registry failure", (Throwable)e);
        }
        finally {
            this.getAccess().close();
        }
    }

    private boolean doPathsEqual(String path1, String path2) {
        File file1 = new File(path1);
        File file2 = new File(path2);
        if (file1.equals(file2)) {
            return true;
        }
        try {
            File canonicalFile1 = file1.getCanonicalFile();
            File canonicalFile2 = file2.getCanonicalFile();
            return canonicalFile1.equals(canonicalFile2);
        }
        catch (Exception e) {
            String msg = String.format("Unable to determine the canonical paths for %s and %s.", path1, path2);
            log.warn(msg, (Throwable)e);
            return false;
        }
    }

    private String versionToReplace(String product, String versionToInstall, String host, String currentLocation, RegistryAccess registryAccess) {
        String[] versions = this.getAccess().getInstallVersions(product, host);
        if (versions == null) {
            String msg = String.format("Versions for '%s' '%s' not found, at least one version expected.", product, host);
            log.warn(msg);
            return null;
        }
        for (String version : versions) {
            String existingLocation;
            boolean compareResult;
            if (version.equals(versionToInstall) || !(compareResult = this.doPathsEqual(existingLocation = this.getAccess().getInstallLoc(product, version, host), currentLocation))) continue;
            return version;
        }
        return null;
    }

    public void updateRegistry() throws Exception {
        boolean newInstall;
        if (this._mvsWithNoDeploymentRegistry) {
            log.info("no deployment registry to update... returning");
            return;
        }
        String maintDisplayName = this.getController().getProperty("maintDisplayName");
        String maintVersionString = null;
        if (maintDisplayName == null) {
            if (this.getController().isMaintenance()) {
                maintVersionString = this.getController().getProperty("MaintVersion");
                maintDisplayName = this.getController().getProperty("CustomerFacingVersion");
            } else if (this.getController().isHotfix()) {
                maintVersionString = this.getController().getProperty("HotFixVersion");
                maintDisplayName = "Hotfix " + maintVersionString;
            }
        }
        boolean bl = newInstall = !this.getController().isHotfix() && !this.getController().isMaintenance();
        if (this.getController().isRegistryUpdateByScript()) {
            if (newInstall) {
                this.createNewInstallRegistryUpdateScript();
            } else {
                this.createMaintenanceRegistryUpdateScript(maintDisplayName, maintVersionString);
            }
        } else if (newInstall) {
            this.updateNewInstallDeploymentRegistry();
        } else {
            this.updateMaintenanceDeploymentRegistry(maintDisplayName, maintVersionString);
        }
    }

    protected List<String> calculatedUninstallCommand() {
        ArrayList<String> command = new ArrayList<String>();
        File metadataDir = new File(this.getController().metadataBackupDirectory());
        File buildFile = new File(metadataDir, this.getController().getProperty("Install Filename"));
        String productXMLFilename = new File(this.getController().getProductDataPath()).getName();
        File productXML = new File(metadataDir, productXMLFilename);
        command.add("-sashome");
        command.add(this.getController().getProperty("SASHome"));
        command.add("-file");
        command.add(buildFile.getPath());
        command.add("-productdata");
        command.add(productXML.getPath());
        command.add("-packageDir");
        command.add(metadataDir.getPath());
        command.add("-target");
        command.add("preuninstall,preinstall,uninstall,install,postinstall,postuninstall");
        return command;
    }

    protected Element createUninstallRootNode(String uninstallDataPath) throws Exception {
        Element products = null;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = null;
        if (this.getController().getFS().isFile(uninstallDataPath)) {
            document = builder.parse(this.getController().getFS().getInputStream(uninstallDataPath));
            NodeList propertyNodes = document.getElementsByTagName("productsbyhost");
            products = (Element)propertyNodes.item(0);
        } else if (!Controller.uninstall_mode) {
            document = builder.newDocument();
            products = document.createElement("productsbyhost");
            document.appendChild(products);
        }
        return products;
    }

    protected Element getHostElement(Element productsByHost, String host) {
        Element element = null;
        NodeList hostList = productsByHost.getElementsByTagName("host");
        Element hostNode = null;
        if (hostList.getLength() > 0) {
            for (int i = 0; i < hostList.getLength(); ++i) {
                element = (Element)hostList.item(i);
                if (!element.getAttribute("id").equals(host)) continue;
                hostNode = element;
            }
        }
        if (hostNode == null) {
            hostNode = productsByHost.getOwnerDocument().createElement("host");
            hostNode.setAttribute("id", host);
            productsByHost.appendChild(hostNode);
        }
        return hostNode;
    }

    protected Element getProductElement(Element host, String twelveByte) {
        Element element = null;
        NodeList productList = host.getElementsByTagName("product");
        Element productNode = null;
        if (productList.getLength() > 0) {
            for (int i = 0; i < productList.getLength(); ++i) {
                element = (Element)productList.item(i);
                if (!element.getAttribute("twelveByte").equals(twelveByte)) continue;
                productNode = element;
            }
        }
        if (productNode == null) {
            productNode = host.getOwnerDocument().createElement("product");
            productNode.setAttribute("twelveByte", twelveByte);
            host.appendChild(productNode);
        }
        return productNode;
    }

    protected Element getVersionElement(Element product, String requiredVersion) {
        NodeList versionList = product.getElementsByTagName("version");
        Element versionNode = null;
        Element element = null;
        if (versionList.getLength() > 0) {
            for (int i = 0; i < versionList.getLength(); ++i) {
                element = (Element)versionList.item(i);
                if (!element.getAttribute("id").equals(requiredVersion)) continue;
                versionNode = element;
            }
        }
        if (versionNode == null) {
            versionNode = product.getOwnerDocument().createElement("version");
            versionNode.setAttribute("id", requiredVersion);
            product.appendChild(versionNode);
            log.info("added version entry for " + requiredVersion + " to uninstall metadata");
        }
        return versionNode;
    }

    protected Element getMaintenanceElement(Element versionNode, String maintVersion) {
        NodeList maintList = versionNode.getElementsByTagName("maintenance");
        Element maintNode = null;
        Element element = null;
        if (maintList.getLength() > 0) {
            for (int i = 0; i < maintList.getLength(); ++i) {
                element = (Element)maintList.item(i);
                if (!element.getAttribute("id").equals(maintVersion)) continue;
                maintNode = element;
            }
        }
        if (maintNode == null) {
            maintNode = versionNode.getOwnerDocument().createElement("maintenance");
            maintNode.setAttribute("id", maintVersion);
            versionNode.appendChild(maintNode);
            log.info("added maintenance entry for " + maintVersion + " to uninstall metadata");
        }
        return maintNode;
    }

    protected Element getHotfixElement(Element maintNode, String hotfixVersion, String language) {
        Element element = null;
        NodeList hotfixList = maintNode.getElementsByTagName("hotfix");
        if (hotfixList.getLength() > 0) {
            for (int i = 0; i < hotfixList.getLength(); ++i) {
                element = (Element)hotfixList.item(i);
                if (!element.getAttribute("id").equals(hotfixVersion) || !element.getAttribute("ProductLanguage").equals(language)) continue;
                maintNode.removeChild(element);
                log.info("removed hotfix entry for " + hotfixVersion + " from uninstall metadata");
            }
        }
        Element hotfixElement = null;
        if (!Controller.uninstall_mode) {
            hotfixElement = maintNode.getOwnerDocument().createElement("hotfix");
            hotfixElement.setAttribute("id", hotfixVersion);
            hotfixElement.setAttribute("ProductLanguage", language);
            maintNode.appendChild(hotfixElement);
            log.info("added hotfix entry for " + hotfixVersion + " to uninstall metadata");
        }
        return hotfixElement;
    }

    private void createRollbackNode(Element hotfixNode, List<String> uninstallCommand) {
        NodeList children = hotfixNode.getElementsByTagName("rollback");
        for (int i = 0; i < children.getLength(); ++i) {
            hotfixNode.removeChild(children.item(i));
        }
        Element uninstallNode = hotfixNode.getOwnerDocument().createElement("rollback");
        for (String arg : uninstallCommand) {
            Element argNode = hotfixNode.getOwnerDocument().createElement("arg");
            argNode.setTextContent(arg);
            uninstallNode.appendChild(argNode);
        }
        hotfixNode.appendChild(uninstallNode);
    }

    protected void updateUninstallData() throws Exception {
        String uninstallDataPath = this.getController().getFS().append(System.getProperty("SASHome"), "InstallMisc", UNINSTALL_XML);
        File uninstallData = new File(uninstallDataPath);
        Element products = this.createUninstallRootNode(uninstallDataPath);
        if (this.getController().isHotfix()) {
            String host = this.getController().getProperty("host");
            String twelveByte = this.getController().getProperty("12ByteCode");
            String version = this.getController().getProperty("ProductVersion");
            if (version == null || version.equals("")) {
                version = this.getController().getProperty("ProductVersion");
            }
            String maintVersion = this.getController().getProperty("MaintVersion");
            String hotfixVersion = this.getController().getProperty("HotFixVersion");
            String language = this.getController().getProperty("ProductLanguage");
            Element hostNode = this.getHostElement(products, host);
            Element productNode = this.getProductElement(hostNode, twelveByte);
            Element versionNode = this.getVersionElement(productNode, version);
            Element maintNode = this.getMaintenanceElement(versionNode, maintVersion);
            Element hotfixNode = this.getHotfixElement(maintNode, hotfixVersion, language);
            if (!Controller.uninstall_mode) {
                List<String> uninstallCommand = this.calculatedUninstallCommand();
                this.createRollbackNode(hotfixNode, uninstallCommand);
                log.info("added uninstall command " + uninstallCommand + " for " + hotfixNode.getNodeName() + " to " + uninstallData.getAbsolutePath());
            }
            this.serializeUninstallMetadata(products.getOwnerDocument(), uninstallData);
        }
    }

    public void postExecute() throws Exception {
        if (!"true".equals(this.getController().getProperty("sysreqpackage")) && Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
            this.updateRegistry();
            if (!this.getController().getProperty("CreateBackupLoc").equals("true")) {
                return;
            }
            this.updateUninstallData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeUninstallMetadata(Document document, File output) throws Exception {
        OutputStream out = null;
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            out = this.getController().getFS().getOutputStream(output.getPath());
            tr.transform(new DOMSource(document), new StreamResult(out));
        }
        catch (Exception e) {
            this.getController().getView().applicationFailure(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Utils.removeBlankLines(output);
        log.info("Wrote updated uninstall metadata:  " + output.getAbsolutePath());
    }

    public void recordInstallFailure() {
        if (this.getController().isHotfix()) {
            return;
        }
        try {
            this.getAccess().open(false);
            this.getAccess().setInstallStatus(this.getController().getProperty("12ByteCode").toLowerCase(), this.getController().getProperty("ProductVersion"), this.getController().getProperty("host"), "-16", "", "");
            this.getAccess().setInstallLogFile(this.getController().getProperty("12ByteCode").toLowerCase(), this.getController().getProperty("ProductVersion"), this.getController().getProperty("host"), this.getController().getDefaultLog().getPath());
        }
        catch (Exception e) {
            log.error("Deployment registry failure", (Throwable)e);
        }
        finally {
            this.getAccess().close();
        }
    }

    protected SSNResource getBundle() {
        return this._bundle;
    }

    protected void setBundle(SSNResource bundle) {
        this._bundle = bundle;
    }

    public RegistryAccess getAccess() {
        if (this._access == null && System.getProperty("SASHome") != null) {
            String jarLocation = new File(System.getProperty("SASHome"), "deploymntreg").getAbsolutePath();
            File jarFile = new File(jarLocation, "sas.tools.deploymntreg.jar");
            try {
                this._access = new RegistryAccess(jarFile);
            }
            catch (Exception e) {
                throw new InstallException(1, null, this.getBundle().messageString("SASController.DeploymentRegistryLoadFailure", jarFile.getAbsolutePath()), this.getEnBundle().messageString("SASController.DeploymentRegistryLoadFailure", jarFile.getAbsolutePath()), e);
            }
        }
        return this._access;
    }

    protected void setAccess(RegistryAccess access) {
        this._access = access;
    }

    protected Controller getController() {
        return this._controller;
    }

    protected void setController(Controller controller) {
        this._controller = controller;
    }

    public SSNResource getEnBundle() {
        return this._enBundle;
    }

    public void setEnBundle(SSNResource enBundle) {
        this._enBundle = enBundle;
    }
}

