/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class RegistryAccess {
    private final Class deployAPI;
    private final String registryRoot;
    private Boolean opened = Boolean.FALSE;
    protected static Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.installs.it.RegistryAccess");

    public RegistryAccess(String jarFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        this(new File(jarFile));
    }

    public RegistryAccess(File jarFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        String pathToJarDir;
        if (!jarFile.exists()) {
            throw new FileNotFoundException();
        }
        if (!jarFile.canRead()) {
            throw new IOException();
        }
        ClassLoader loader = this.loader(jarFile);
        this.deployAPI = loader.loadClass("com.sas.deploymntreg.DeployAPI");
        this.registryRoot = pathToJarDir = jarFile.getParent();
    }

    public ClassLoader loader(File drJar) throws MalformedURLException {
        return new URLClassLoader(new URL[]{drJar.toURI().toURL()});
    }

    public void setProperty(String key, String value) {
        new Method("setProperty", new String[]{this.registryRoot, key, value}).execute();
    }

    public String getProperty(String key, String defaultValue) {
        return (String)new Method("getProperty", new String[]{this.registryRoot, key, defaultValue}).execute();
    }

    public String getProperty(String key) {
        return (String)new Method("getProperty", new String[]{this.registryRoot, key}).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(boolean logFailure) {
        String view = Controller.installProperties.getProperty("deployment.registry.view") != null ? Controller.installProperties.getProperty("deployment.registry.view") : System.getProperty("MajorRelease");
        try {
            Boolean bl = this.opened;
            synchronized (bl) {
                if (!this.opened.booleanValue()) {
                    this.opened = view == null ? (Boolean)new Method("open", new String[]{this.registryRoot}).execute() : (Boolean)new Method("openView", new String[]{view, this.registryRoot}).execute();
                }
            }
        }
        catch (Exception e) {
            Controller.log.error("Tried to call close() from registry jar, but got exception: ");
            Controller.logStackTrace(e);
        }
        if (!this.opened.booleanValue() && logFailure) {
            if (view == null) {
                log.info("open(" + this.registryRoot + ") returned false");
            } else {
                log.info("openView(" + view + ", " + this.registryRoot + ") returned false");
            }
        }
        return this.opened;
    }

    public boolean open() {
        return this.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean logFailure) {
        try {
            Boolean bl = this.opened;
            synchronized (bl) {
                if (this.opened.booleanValue()) {
                    this.opened = (Boolean)new Method("close", new String[0]).execute() == false;
                }
            }
        }
        catch (Exception e) {
            Controller.log.error("Tried to call close() from registry jar, but got exception: ");
            Controller.logStackTrace(e);
        }
        if (this.opened.booleanValue() && logFailure) {
            log.info("close() returned false");
        }
        return this.opened == false;
    }

    public boolean close() {
        return this.close(true);
    }

    public boolean setSASHome(String sashome) {
        return (Boolean)new Method("setSASHome", new String[]{sashome}).execute();
    }

    public String getSASHome() {
        return (String)new Method("getSASHome", new String[0]).execute();
    }

    public boolean setInstallUser(String user) {
        return (Boolean)new Method("setInstallUser", new String[]{user}).execute();
    }

    public String getInstallUser() {
        return (String)new Method("getInstallUser", new String[0]).execute();
    }

    public boolean updateInstallTime(String product, String version, String host) {
        return (Boolean)new Method("updateInstallTime", new String[]{product, version, host}).execute();
    }

    public boolean updateInstallTime(String product, String version) {
        return (Boolean)new Method("updateInstallTime", new String[]{product, version}).execute();
    }

    public String getInstallTime(String product, String version, String host) {
        return (String)new Method("getInstallTime", new String[]{product, version, host}).execute();
    }

    public String getInstallTime(String product, String version) {
        return (String)new Method("getInstallTime", new String[]{product, version}).execute();
    }

    public boolean setInstallOrderNum(String product, String version, String host, String order) {
        return (Boolean)new Method("setInstallOrderNum", new String[]{product, version, host, order}).execute();
    }

    public boolean setInstallOrderNum(String product, String version, String order) {
        return (Boolean)new Method("setInstallOrderNum", new String[]{product, version, order}).execute();
    }

    public String getInstallOrderNum(String product, String version, String host) {
        return (String)new Method("getInstallOrderNum", new String[]{product, version, host}).execute();
    }

    public String getInstallOrderNum(String product, String version) {
        return (String)new Method("getInstallOrderNum", new String[]{product, version}).execute();
    }

    public boolean setInstallSetnumid(String product, String version, String host, String setnumid) {
        return (Boolean)new Method("setInstallSetnumid", new String[]{product, version, host, setnumid}).execute();
    }

    public boolean setInstallSetnumid(String product, String version, String setnumid) {
        return (Boolean)new Method("setInstallSetnumid", new String[]{product, version, setnumid}).execute();
    }

    public String getInstallSetnumid(String product, String version, String host) {
        return (String)new Method("getInstallSetnumid", new String[]{product, version, host}).execute();
    }

    public String getInstallSetnumid(String product, String version) {
        return (String)new Method("getInstallSetnumid", new String[]{product, version}).execute();
    }

    public boolean setInstallDisplayName(String product, String version, String host, String name) {
        return (Boolean)new Method("setInstallDisplayName", new String[]{product, version, host, name}).execute();
    }

    public boolean setInstallDisplayName(String product, String version, String name) {
        return (Boolean)new Method("setInstallDisplayName", new String[]{product, version, name}).execute();
    }

    public String getInstallDisplayName(String product, String version, String host) {
        return (String)new Method("getInstallDisplayName", new String[]{product, version, host}).execute();
    }

    public String getInstallDisplayName(String product, String version) {
        return (String)new Method("getInstallDisplayName", new String[]{product, version}).execute();
    }

    public boolean setInstallLoc(String product, String version, String host, String path) {
        if (host == null) {
            return this.setInstallLoc(product, version, path);
        }
        return (Boolean)new Method("setInstallLoc", new String[]{product, version, host, path}).execute();
    }

    public boolean setInstallLoc(String product, String version, String path) {
        return (Boolean)new Method("setInstallLoc", new String[]{product, version, path}).execute();
    }

    public String getInstallLoc(String product, String version, String host) {
        if (host == null) {
            return this.getInstallLoc(product, version);
        }
        return (String)new Method("getInstallLoc", new String[]{product, version, host}).execute();
    }

    public String getInstallLoc(String product, String version) {
        return (String)new Method("getInstallLoc", new String[]{product, version}).execute();
    }

    public boolean setInstallKeyFile(String product, String version, String host, String keyFile) {
        return (Boolean)new Method("setInstallKeyFile", new String[]{product, version, host, keyFile}).execute();
    }

    public boolean setInstallKeyFile(String product, String version, String keyFile) {
        return (Boolean)new Method("setInstallKeyFile", new String[]{product, version, keyFile}).execute();
    }

    public String getInstallKeyFile(String product, String version, String host) {
        return (String)new Method("getInstallKeyFile", new String[]{product, version, host}).execute();
    }

    public boolean addInstallLanguage(String product, String version, String host, String languageCode) {
        return (Boolean)new Method("addInstallLanguage", new String[]{product, version, host, languageCode}).execute();
    }

    public boolean addInstallLanguage(String product, String version, String languageCode) {
        return (Boolean)new Method("addInstallLanguage", new String[]{product, version, languageCode}).execute();
    }

    public String getInstallKeyFile(String product, String version) {
        return (String)new Method("getInstallKeyFile", new String[]{product, version}).execute();
    }

    public boolean setInstallLogFile(String product, String version, String host, String logFile) {
        if (host == null) {
            return this.setInstallLogFile(product, version, logFile);
        }
        return (Boolean)new Method("setInstallLogFile", new String[]{product, version, host, logFile}).execute();
    }

    public boolean setInstallLogFile(String product, String version, String logFile) {
        return (Boolean)new Method("setInstallLogFile", new String[]{product, version, logFile}).execute();
    }

    public String getInstallLogFile(String product, String version, String host) {
        return (String)new Method("getInstallLogFile", new String[]{product, version, host}).execute();
    }

    public String getInstallLogFile(String product, String version) {
        return (String)new Method("getInstallLogFile", new String[]{product, version}).execute();
    }

    public boolean setInstallGUID(String product, String version, String host, String guid) {
        return (Boolean)new Method("setInstallGUID", new String[]{product, version, host, guid}).execute();
    }

    public boolean setInstallGUID(String product, String version, String guid) {
        return (Boolean)new Method("setInstallGUID", new String[]{product, version, guid}).execute();
    }

    public String getInstallGUID(String product, String version, String host) {
        return (String)new Method("getInstallGUID", new String[]{product, version, host}).execute();
    }

    public String getInstallFamily(String product, String version) {
        return (String)new Method("getInstallFamily", new String[]{product, version}).execute();
    }

    public String getInstallFamily(String product, String version, String host) {
        if (host == null) {
            return this.getInstallFamily(product, version);
        }
        return (String)new Method("getInstallFamily", new String[]{product, version, host}).execute();
    }

    public boolean setInstallFamily(String product, String version, String family) {
        return (Boolean)new Method("setInstallFamily", new String[]{product, version, family}).execute();
    }

    public boolean setInstallFamily(String product, String version, String host, String family) {
        if (host == null) {
            return (Boolean)new Method("setInstallFamily", new String[]{product, version, family}).execute();
        }
        return (Boolean)new Method("setInstallFamily", new String[]{product, version, host, family}).execute();
    }

    public String getInstallGUID(String product, String version) {
        return (String)new Method("getInstallGUID", new String[]{product, version}).execute();
    }

    public boolean setInstallStatus(String product, String version, String host, String status) {
        if (host == null) {
            return this.setInstallStatus(product, version, status);
        }
        return (Boolean)new Method("setInstallStatus", new String[]{product, version, host, status}).execute();
    }

    public boolean setInstallStatus(String product, String version, String status) {
        return (Boolean)new Method("setInstallStatus", new String[]{product, version, status}).execute();
    }

    public boolean setInstallStatus(String product, String version, String host, String status, String dlgMsg, String logMsg) {
        if (host == null) {
            return this.setInstallStatus(product, version, status, dlgMsg, logMsg);
        }
        return (Boolean)new Method("setInstallStatus", new String[]{product, version, host, status, dlgMsg, logMsg}).execute();
    }

    public boolean setInstallStatus(String product, String version, String status, String dlgMsg, String logMsg) {
        return (Boolean)new Method("setInstallStatus", new String[]{product, version, status, dlgMsg, logMsg}).execute();
    }

    public String getInstallStatus(String product, String version, String host) {
        return (String)new Method("getInstallStatus", new String[]{product, version, host}).execute();
    }

    public String getInstallStatus(String product, String version) {
        return (String)new Method("getInstallStatus", new String[]{product, version}).execute();
    }

    public String getInstallStatusDlgMsg(String product, String version, String host) {
        return (String)new Method("getInstallStatusDlgMsg", new String[]{product, version, host}).execute();
    }

    public String getInstallStatusDlgMsg(String product, String version) {
        return (String)new Method("getInstallStatusDlgMsg", new String[]{product, version}).execute();
    }

    public String getInstallStatusLogMsg(String product, String version, String host) {
        return (String)new Method("getInstallStatusLogMsg", new String[]{product, version, host}).execute();
    }

    public String getInstallStatusLogMsg(String product, String version) {
        return (String)new Method("getInstallStatusLogMsg", new String[]{product, version}).execute();
    }

    public boolean setInstallServicePack(String product, String version, String host, String servicePack) {
        return (Boolean)new Method("setInstallServicePack", new String[]{product, version, host, servicePack}).execute();
    }

    public boolean setInstallServicePack(String product, String version, String servicePack) {
        return (Boolean)new Method("setInstallServicePack", new String[]{product, version, servicePack}).execute();
    }

    public String getInstallServicePack(String product, String version, String host) {
        return (String)new Method("getInstallServicePack", new String[]{product, version, host}).execute();
    }

    public String getInstallServicePack(String product, String version) {
        return (String)new Method("getInstallServicePack", new String[]{product, version}).execute();
    }

    public boolean setInstallVJRConsumer(String product, String version, String host, Boolean consumer) {
        return (Boolean)new Method("setInstallVJRConsumer", new String[]{product, version, host, consumer.toString()}).execute();
    }

    public boolean setInstallVJRConsumer(String product, String version, Boolean consumer) {
        return (Boolean)new Method("setInstallVJRConsumer", new String[]{product, version, consumer.toString()}).execute();
    }

    public boolean setInstallVJRConsumer(String product, String version, String host, String consumer) {
        return (Boolean)new Method("setInstallVJRConsumer", new String[]{product, version, host, consumer}).execute();
    }

    public boolean setInstallVJRConsumer(String product, String version, String consumer) {
        return (Boolean)new Method("setInstallVJRConsumer", new String[]{product, version, consumer}).execute();
    }

    public boolean getInstallVJRConsumer(String product, String version, String host) {
        return (Boolean)new Method("getInstallVJRConsumer", new String[]{product, version, host}).execute();
    }

    public boolean getInstallVJRConsumer(String product, String version) {
        return (Boolean)new Method("getInstallVJRConsumer", new String[]{product, version}).execute();
    }

    public String getMaintDisplayName(String product, String version, String host, String maintVer) {
        if (host == null) {
            return this.getMaintDisplayName(product, version, maintVer);
        }
        return (String)new Method("getMaintDisplayName", new String[]{product, version, host, maintVer}).execute();
    }

    public String getMaintDisplayName(String product, String version, String maintVer) {
        return (String)new Method("getMaintDisplayName", new String[]{product, version, maintVer}).execute();
    }

    public boolean setMaintDisplayName(String product, String version, String host, String maintVer, String displayName) {
        if (host == null) {
            return this.setMaintDisplayName(product, version, maintVer, displayName);
        }
        return (Boolean)new Method("setMaintDisplayName", new String[]{product, version, host, maintVer, displayName}).execute();
    }

    public boolean setMaintDisplayName(String product, String version, String maintVer, String displayName) {
        return (Boolean)new Method("setMaintDisplayName", new String[]{product, version, maintVer, displayName}).execute();
    }

    public String getMaintUninstallLoc(String product, String version, String host, String maintVer) {
        if (host == null) {
            return this.getMaintUninstallLoc(product, version, maintVer);
        }
        return (String)new Method("getMaintUninstallLoc", new String[]{product, version, host, maintVer}).execute();
    }

    public String getMaintUninstallLoc(String product, String version, String maintVer) {
        return (String)new Method("getMaintUninstallLoc", new String[]{product, version, maintVer}).execute();
    }

    public String getMaintUninstallLocByLang(String product, String version, String host, String maintVer, String language) {
        if (host == null) {
            return this.getMaintUninstallLocByLang(product, version, maintVer, language);
        }
        return (String)new Method("getMaintUninstallLoc", new String[]{product, version, host, maintVer, language}).execute();
    }

    public String getMaintUninstallLocByLang(String product, String version, String maintVer, String language) {
        return (String)new Method("getMaintUninstallLoc", new String[]{product, version, maintVer, language}).execute();
    }

    public boolean setMaintUninstallLoc(String product, String version, String host, String maintVer, String language, String path) {
        return (Boolean)new Method("setMaintUninstallLoc", new String[]{product, version, host, maintVer, language, path}).execute();
    }

    public boolean setMaintUninstallLoc(String product, String version, String host, String maintVer, String path) {
        if (host == null) {
            return this.setMaintUninstallLoc(product, version, maintVer, path);
        }
        return (Boolean)new Method("setMaintUninstallLoc", new String[]{product, version, host, maintVer, path}).execute();
    }

    public boolean setMaintUninstallLoc(String product, String version, String maintVer, String path) {
        return (Boolean)new Method("setMaintUninstallLoc", new String[]{product, version, maintVer, path}).execute();
    }

    public boolean removeInstall(String product, String version, String host) {
        if (host == null) {
            return this.removeInstall(product, version);
        }
        return (Boolean)new Method("removeInstall", new String[]{product, version, host}).execute();
    }

    public boolean removeInstall(String product, String version) {
        return (Boolean)new Method("removeInstall", new String[]{product, version}).execute();
    }

    public String[] getInstallHosts() {
        return (String[])new Method("getInstallHosts", new String[0]).execute();
    }

    public String[] getInstallCodes(String host) {
        return (String[])new Method("getInstallCodes", new String[]{host}).execute();
    }

    public String[] getInstallCodes() {
        return (String[])new Method("getInstallCodes", new String[0]).execute();
    }

    public String[] getInstallVersions(String product, String host) {
        return (String[])new Method("getInstallVersions", new String[]{product, host}).execute();
    }

    public String[] getInstallVersions(String product) {
        return (String[])new Method("getInstallVersions", new String[]{product}).execute();
    }

    public boolean setConfigLoc(String configDir, String path) {
        return (Boolean)new Method("setConfigLoc", new String[]{configDir, path}).execute();
    }

    public String getConfigLoc(String configDir) {
        return (String)new Method("getConfigLoc", new String[]{configDir}).execute();
    }

    public boolean setConfigOrderNum(String configDir, String order) {
        return (Boolean)new Method("setConfigOrderNum", new String[]{configDir, order}).execute();
    }

    public String getConfigOrderNum(String configDir) {
        return (String)new Method("getConfigOrderNum", new String[]{configDir}).execute();
    }

    public boolean setConfigPlanFile(String configDir, String planFile) {
        return (Boolean)new Method("setConfigPlanFile", new String[]{configDir, planFile}).execute();
    }

    public String getConfigPlanFile(String configDir) {
        return (String)new Method("getConfigPlanFile", new String[]{configDir}).execute();
    }

    public boolean setConfigPropFile(String configDir, String propFile) {
        return (Boolean)new Method("setConfigPropFile", new String[]{configDir, propFile}).execute();
    }

    public String getConfigPropFile(String configDir) {
        return (String)new Method("getConfigPropFile", new String[]{configDir}).execute();
    }

    public boolean setMaintLevel(String product, String version, String host, String maintVer) {
        if (host == null) {
            return this.setMaintLevel(product, version, maintVer);
        }
        return (Boolean)new Method("setMaintLevel", new String[]{product, version, host, maintVer}).execute();
    }

    public boolean setMaintLevel(String product, String version, String maintVer) {
        return (Boolean)new Method("setMaintLevel", new String[]{product, version, maintVer}).execute();
    }

    public String getMaintLevel(String product, String version, String host) {
        if (host == null) {
            return this.getMaintLevel(product, version);
        }
        return (String)new Method("getMaintLevel", new String[]{product, version, host}).execute();
    }

    public String getMaintLevel(String product, String version) {
        return (String)new Method("getMaintLevel", new String[]{product, version}).execute();
    }

    public String[] getInstallLanguages(String product, String version, String host) {
        if (host == null) {
            return this.getInstallLanguages(product, version);
        }
        return (String[])new Method("getInstallLanguages", new String[]{product, version, host}).execute();
    }

    public String[] getInstallLanguages(String product, String version) {
        return (String[])new Method("getInstallLanguages", new String[]{product, version}).execute();
    }

    public String getMaintLastApplied(String product, String version, String host) {
        return (String)new Method("getMaintLastApplied", new String[]{product, version, host}).execute();
    }

    public boolean removeMaint(String product, String version, String host, String maintVer) {
        return (Boolean)new Method("removeMaint", new String[]{product, version, host, maintVer}).execute();
    }

    public String[] getMaintVersions(String product, String version, String host) {
        return (String[])new Method("getMaintVersions", new String[]{product, version, host}).execute();
    }

    public String[] getMaintVersions(String product, String version) {
        return (String[])new Method("getMaintVersions", new String[]{product, version}).execute();
    }

    public boolean removeConfig(String configDir) {
        return (Boolean)new Method("removeConfig", new String[]{configDir}).execute();
    }

    private class Method {
        private String method;
        private final Vector parameters = new Vector();

        public Method(String method, String[] parameters) {
            this.setMethod(method);
            for (int i = 0; i < parameters.length; ++i) {
                this.addParameter(parameters[i]);
            }
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void addParameter(Object parameter) {
            this.parameters.add(parameter);
        }

        public Object execute() {
            Object result = null;
            if (RegistryAccess.this.deployAPI != null) {
                Object[] obj = null;
                Class[] types = null;
                if (this.parameters.size() > 0) {
                    obj = new Object[this.parameters.size()];
                    types = new Class[this.parameters.size()];
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        Object temp = this.parameters.get(i);
                        if (temp == null) continue;
                        obj[i] = temp;
                        types[i] = temp.getClass();
                    }
                }
                try {
                    result = RegistryAccess.this.deployAPI.getMethod(this.method, types).invoke(null, obj);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            return result;
        }
    }
}

