/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

class PropsParser {
    private Hashtable m_sectionHash = new Hashtable();
    private boolean m_iniFile = false;

    public PropsParser(boolean iniFile) {
        this.m_iniFile = iniFile;
    }

    public void load(File file, PrintWriter debugFile) throws FileNotFoundException, IOException {
        String line = null;
        String section = "";
        Hashtable<String, String> valueHash = (Hashtable<String, String>)this.m_sectionHash.get(section);
        if (valueHash == null) {
            valueHash = new Hashtable<String, String>();
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            line = in.readLine();
            if (debugFile != null && line != null) {
                debugFile.println("From file: " + file.getName());
            }
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    if (this.m_iniFile && line.startsWith("[")) {
                        if (section.length() > 0) {
                            this.m_sectionHash.put(section.toLowerCase(Locale.ENGLISH), valueHash);
                        }
                        section = line.substring(1, line.length() - 1);
                        valueHash = new Hashtable();
                    } else if (line.indexOf("=") > -1) {
                        int equalIndex = line.indexOf("=");
                        String name = line.substring(0, equalIndex).toLowerCase(Locale.ENGLISH).trim();
                        String value = line.substring(equalIndex + 1).trim();
                        valueHash.put(name, value);
                        if (debugFile != null) {
                            debugFile.println("   " + line);
                        }
                    }
                }
                line = in.readLine();
            }
            this.m_sectionHash.put(section.toLowerCase(Locale.ENGLISH), valueHash);
            in.close();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void save(String fullFilePath, boolean upperCase) throws IOException {
        PrintWriter outputFile = null;
        String sectionKey = null;
        String valueKey = null;
        String value = null;
        Hashtable valueHash = null;
        Enumeration sectionsKeys = this.m_sectionHash.keys();
        while (sectionsKeys.hasMoreElements()) {
            if (outputFile == null) {
                outputFile = new PrintWriter(new BufferedWriter(new FileWriter(fullFilePath)));
            }
            sectionKey = (String)sectionsKeys.nextElement();
            if (this.m_iniFile) {
                outputFile.println("[" + sectionKey + "]");
            }
            if ((valueHash = (Hashtable)this.m_sectionHash.get(sectionKey)) == null) continue;
            Enumeration valueKeys = valueHash.keys();
            while (valueKeys.hasMoreElements()) {
                valueKey = (String)valueKeys.nextElement();
                value = (String)valueHash.get(valueKey);
                if (value == null) continue;
                if (upperCase) {
                    outputFile.println(valueKey.toUpperCase(Locale.ENGLISH) + "=" + value);
                    continue;
                }
                outputFile.println(valueKey + "=" + value);
            }
        }
        if (outputFile != null) {
            outputFile.close();
        }
    }

    public Enumeration getNames() {
        return this.getNames("");
    }

    public Enumeration getNames(String section) {
        Hashtable valueHash = (Hashtable)this.m_sectionHash.get(section.toLowerCase(Locale.ENGLISH));
        return valueHash.keys();
    }

    public String getProperty(String name, String defaultValue) {
        return this.getINIValue("", name, defaultValue);
    }

    public void setProperty(String name, String value) {
        this.setINIValue("", name, value);
    }

    public String getINIValue(String section, String name, String defaultValue) {
        String value = null;
        Hashtable valueHash = (Hashtable)this.m_sectionHash.get(section.toLowerCase(Locale.ENGLISH));
        if (valueHash != null) {
            value = (String)valueHash.get(name.toLowerCase(Locale.ENGLISH));
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void setINIValue(String section, String name, String value) {
        Hashtable<String, String> valueHash = (Hashtable<String, String>)this.m_sectionHash.get(section.toLowerCase(Locale.ENGLISH));
        if (valueHash == null) {
            valueHash = new Hashtable<String, String>();
        }
        valueHash.put(name.toLowerCase(Locale.ENGLISH), value);
        this.m_sectionHash.put(section, valueHash);
    }
}

