/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.PerfLog;
import com.sas.tools.installs.it.schema.install.gen.HostList;
import com.sas.tools.installs.it.schema.install.gen.InstallType;
import com.sas.tools.installs.it.schema.install.gen.Target;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.view.SSNResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class PerfLogDelegateTask
extends InstallationTask {
    private InstallationTask realTask = null;

    public PerfLogDelegateTask(InstallationTask realTask) {
        if (realTask == null) {
            throw new NullPointerException("Cannot initialize PerfLogDelegateTask with a null InstallationTask!");
        }
        this.realTask = realTask;
    }

    @Override
    public String descriptionForLog() {
        return this.realTask.descriptionForLog();
    }

    private void logTaskEntry(String method) {
        PerfLog.getInstance().newEntry(this.realTask, method, this.realTask.getSubType(), this.realTask.getProdCodeFromAltSku(), this.realTask.getAltsku());
    }

    @Override
    public void execute() throws InstallException {
        try {
            this.logTaskEntry("execute");
            this.realTask.execute();
        }
        finally {
            PerfLog.getInstance().finishLastEntry();
        }
    }

    @Override
    public void retry() throws InstallException {
        try {
            this.logTaskEntry("retry");
            this.realTask.retry();
        }
        finally {
            PerfLog.getInstance().finishLastEntry();
        }
    }

    @Override
    public void rollback() throws InstallException {
        try {
            this.logTaskEntry("rollback");
            this.realTask.rollback();
        }
        finally {
            PerfLog.getInstance().finishLastEntry();
        }
    }

    @Override
    public void postExecute() throws Exception {
        try {
            this.logTaskEntry("postExecute");
            this.realTask.postExecute();
        }
        finally {
            PerfLog.getInstance().finishLastEntry();
        }
    }

    @Override
    public String getSubType() {
        return this.realTask.getSubType();
    }

    @Override
    public void setData(InstallType data) {
        this.realTask.setData(data);
    }

    @Override
    public InstallType getData() {
        return this.realTask.getData();
    }

    @Override
    public void setTarget(Target target) {
        this.realTask.setTarget(target);
    }

    @Override
    public String getAltsku() {
        return this.realTask.getAltsku();
    }

    @Override
    public String getProdCodeFromAltSku() {
        return this.realTask.getProdCodeFromAltSku();
    }

    @Override
    public void setAltSku(String altsku) {
        this.realTask.setAltSku(altsku);
    }

    @Override
    public String resolveProperty(String value) {
        return this.realTask.resolveProperty(value);
    }

    @Override
    public String resolveShortPaths(String value) {
        return this.realTask.resolveShortPaths(value);
    }

    @Override
    public void takeAttributesFromMap(HashMap<String, String> parameters) {
        this.realTask.takeAttributesFromMap(parameters);
    }

    @Override
    public void preExecute() throws Exception {
        try {
            this.logTaskEntry("preExecute");
            this.realTask.preExecute();
        }
        finally {
            PerfLog.getInstance().finishLastEntry();
        }
    }

    @Override
    public boolean executeOnCurrentHost() {
        return this.realTask.executeOnCurrentHost();
    }

    @Override
    public void notifySetup(String action, EntryData metaData, String message) {
        this.realTask.notifySetup(action, metaData, message);
    }

    @Override
    public void notifySetup(String description, String logDescription) {
        this.realTask.notifySetup(description, logDescription);
    }

    @Override
    public void notifySetup(String description) {
        this.realTask.notifySetup(description);
    }

    @Override
    public void notifyProgressComplete(String description) {
        this.realTask.notifyProgressComplete(description);
    }

    @Override
    public void notifyRollbackProgressComplete(String description) {
        this.realTask.notifyRollbackProgressComplete(description);
    }

    @Override
    public void notifyProgressComplete(String action, EntryData metaData) {
        this.realTask.notifyProgressComplete(action, metaData);
    }

    @Override
    public NotificationHandler getNotifier() {
        return this.realTask.getNotifier();
    }

    @Override
    public void notifyRollbackProgressComplete(String action, EntryData metaData, long bytes) {
        this.realTask.notifyRollbackProgressComplete(action, metaData, bytes);
    }

    @Override
    public void notifyProgressStart(String description) {
        this.realTask.notifyProgressStart(description);
    }

    @Override
    public void notifyRollbackProgressStart(String description) {
        this.realTask.notifyRollbackProgressStart(description);
    }

    @Override
    public void notifyProgressStart(String action, EntryData metaData) {
        this.realTask.notifyProgressStart(action, metaData);
    }

    @Override
    public void notifyProgressFailure(String action, EntryData metaData) {
        this.realTask.notifyProgressFailure(action, metaData);
    }

    @Override
    public void streamDataWithNotifications(InputStream is, OutputStream os, boolean rollback) throws IOException {
        this.realTask.streamDataWithNotifications(is, os, rollback);
    }

    @Override
    public void notifyRollbackProgressStart(String action, EntryData metaData) {
        this.realTask.notifyRollbackProgressStart(action, metaData);
    }

    @Override
    public void notifyBytesMoved(long bytes) {
        this.realTask.notifyBytesMoved(bytes);
    }

    @Override
    public void notifyRollbackBytesMoved(long bytes) {
        this.realTask.notifyRollbackBytesMoved(bytes);
    }

    @Override
    public void notifyReboot(String description) {
        this.realTask.notifyReboot(description);
    }

    @Override
    public String getBackupKey() {
        return this.realTask.getBackupKey();
    }

    @Override
    public void setBackupKey(String backupKey) {
        this.realTask.setBackupKey(backupKey);
    }

    @Override
    public boolean isUndo() {
        return this.realTask.isUndo();
    }

    @Override
    public void setUndo(boolean undo) {
        this.realTask.setUndo(undo);
    }

    @Override
    public HashMap<String, Long> getFilesToAdd() {
        return this.realTask.getFilesToAdd();
    }

    @Override
    public void setFilesToAdd(HashMap<String, Long> filesToAdd) {
        this.realTask.setFilesToAdd(filesToAdd);
    }

    @Override
    public HashMap<String, Long> getFilesToChange() {
        return this.realTask.getFilesToChange();
    }

    @Override
    public void setFilesToChange(HashMap<String, Long> filesToChange) {
        this.realTask.setFilesToChange(filesToChange);
    }

    @Override
    public HashMap<String, Long> getFilesToRemove() {
        return this.realTask.getFilesToRemove();
    }

    @Override
    public void setFilesToRemove(HashMap<String, Long> filesToRemove) {
        this.realTask.setFilesToRemove(filesToRemove);
    }

    @Override
    public HashMap<String, Long> getFilesToCheck() {
        return this.realTask.getFilesToCheck();
    }

    @Override
    public void setFilesToCheck(HashMap<String, Long> filesToCheck) {
        this.realTask.setFilesToCheck(filesToCheck);
    }

    @Override
    public String getFailureAction() {
        return this.realTask.getFailureAction();
    }

    @Override
    public void setFailureAction(String failureAction) {
        this.realTask.setFailureAction(failureAction);
    }

    @Override
    public HostList getHostList() {
        return this.realTask.getHostList();
    }

    @Override
    public void setHostList(HostList hostList) {
        this.realTask.setHostList(hostList);
    }

    @Override
    public SSNResource getBundle() {
        return this.realTask.getBundle();
    }

    @Override
    public void setBundle(SSNResource bundle) {
        this.realTask.setBundle(bundle);
    }

    @Override
    public SSNResource getEnBundle() {
        return this.realTask.getEnBundle();
    }

    @Override
    public void setEnBundle(SSNResource enBundle) {
        this.realTask.setEnBundle(enBundle);
    }

    @Override
    public Controller getController() {
        return this.realTask.getController();
    }

    @Override
    public void setController(Controller controller) {
        this.realTask.setController(controller);
    }

    @Override
    public String getDescription() {
        return this.realTask.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.realTask.setDescription(description);
    }

    @Override
    public int getFileCount() {
        return this.realTask.getFileCount();
    }

    @Override
    public void setFileCount(int fileCount) {
        this.realTask.setFileCount(fileCount);
    }

    @Override
    public File getSASConfigFile(String lang) {
        return this.realTask.getSASConfigFile(lang);
    }

    @Override
    public InstallationTask.UninstallTarget getUninstallTarget() {
        return this.realTask.getUninstallTarget();
    }

    @Override
    public boolean isConstraintMet() {
        return this.realTask.isConstraintMet();
    }
}

