/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.ExecutionProgressInterface;
import com.sas.tools.installs.it.InstallationContext;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.listener.InstallationCompletionListener;
import com.sas.tools.installs.it.listener.RollbackProgressListener;
import com.sas.tools.installs.it.listener.WarningListener;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.view.SSNResource;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class ExecutionThread
extends Thread
implements RollbackProgressListener,
InstallationCompletionListener,
WarningListener {
    protected Logger log = (Logger)LogManager.getLogger((String)this.getClass().getName());
    private SSNResource _bundle;
    private SSNResource _enBundle;
    protected Controller _controller;
    protected ExecutionProgressInterface _interface;
    private boolean _rollbackOccurred = false;
    private boolean _rollbackFailed = false;
    private boolean success = false;
    private boolean warning = false;

    private ExecutionThread() {
        this.setBundle(new SSNResource(this.getClass()));
        this.setEnBundle(SSNResource.EnglishResource(this.getClass()));
    }

    public ExecutionThread(Controller controller, ExecutionProgressInterface progressInterface) {
        this();
        this.setController(controller);
        this.setInterface(progressInterface);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            int installIndex;
            int numInstalls = this.getController().getAltSkus().size();
            for (installIndex = 0; installIndex < numInstalls; ++installIndex) {
                String altSku = this.getController().getAltSkus().get(installIndex);
                InstallationContext context = this.getController().getInstallContexts().get(altSku);
                if (context.getUninstallableReason() != null) {
                    this.log.info("skipping build file at index " + installIndex + " because " + context.getUninstallableReason());
                    continue;
                }
                this.getController().switchToAltSkuAtIndex(installIndex);
                if (this.getInterface() != null) {
                    this.getInterface().beginInstallAtIndex(installIndex);
                }
                this.log.info("beginning install of " + this.getController().getAltSku());
                this.getController().executeScript();
                if (this.getController().isInstallCancelled()) {
                    this.log.info("install cancelled.  Bypassing the rest of the installs in the chain");
                    --installIndex;
                    break;
                }
                this.log.info(this.getController().getAltSku() + " install complete");
            }
            if (this._rollbackOccurred) {
                int n = installIndex = installIndex >= numInstalls ? numInstalls - 1 : installIndex;
                while (installIndex >= 0) {
                    if (this.getController().getCurrentContext().getUninstallableReason() == null) {
                        this.getController().switchToAltSkuAtIndex(installIndex);
                        if (this.getInterface() != null) {
                            this.getInterface().beginRollbackAtIndex(installIndex);
                        }
                        this.log.info("beginning rollback of " + this.getController().getAltSku());
                        Vector<InstallationTask> tasks = this.getController().getInstallTasksPerAltSku().get(this.getController().getAltSku());
                        this.getController().rollbackStartingWithTask(tasks.lastElement());
                        this.log.info(this.getController().getAltSku() + " rollback complete");
                    }
                    --installIndex;
                }
                if (!this.getController().isHotfix()) return;
                if (this.getInterface() != null) {
                    this.getInterface().allRollbackComplete();
                }
            } else {
                if (this.getController().isHotfix()) {
                    if (this.success) {
                        this.getController().maintenanceCleanup();
                    }
                } else if (this.success) {
                    this.getController().installCleanup();
                }
                if (this.getInterface() != null) {
                    this.getInterface().buildFinished();
                }
            }
        }
        catch (SecurityException f) {
            this.log.info("SecurityException in ExecutionThread run:  " + f);
            throw f;
        }
        catch (Exception e) {
            this.log.info("Exception in ExecutionThread run:  " + e);
            try {
                this.getController().getView().applicationFailure(e);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        this.log.info("ExecutionThread run complete");
    }

    public boolean isWarning() {
        return this.warning;
    }

    public boolean isRolledBack() {
        return this._rollbackOccurred;
    }

    public boolean isRollbackFailed() {
        return this._rollbackFailed;
    }

    @Override
    public void warningAction(String decription) {
        this.warning = true;
    }

    @Override
    public void rollbackProgressBeginningAction(String description) {
        this._rollbackOccurred = true;
    }

    @Override
    public void allRollbackCompleteAction() {
        this._rollbackOccurred = true;
    }

    @Override
    public void rollbackProgressCompleteAction(String action, EntryData metaData) {
        this._rollbackOccurred = true;
    }

    @Override
    public void rollbackProgressCompleteAction(String description) {
        this._rollbackOccurred = true;
    }

    @Override
    public void rollbackBytesMoved(long numBytes) {
        this._rollbackOccurred = true;
    }

    @Override
    public void rollbackFailure(String description) {
        this._rollbackFailed = true;
    }

    @Override
    public void rollbackProgressBeginningAction(String action, EntryData metaData) {
        this._rollbackOccurred = true;
    }

    public Controller getController() {
        return this._controller;
    }

    private void setController(Controller controller) {
        this._controller = controller;
        NotificationHandler.defaultHandler().addRollbackProgressListener(this);
        controller.getNotifier().addCompletionListener(this);
        controller.getNotifier().addWarningListener(this);
    }

    public ExecutionProgressInterface getInterface() {
        return this._interface;
    }

    public void setInterface(ExecutionProgressInterface interface1) {
        this._interface = interface1;
    }

    public SSNResource getBundle() {
        return this._bundle;
    }

    public void setBundle(SSNResource bundle) {
        this._bundle = bundle;
    }

    public SSNResource getEnBundle() {
        return this._enBundle;
    }

    public void setEnBundle(SSNResource enBundle) {
        this._enBundle = enBundle;
    }

    @Override
    public void installationCancelled() {
    }

    @Override
    public void installationComplete() {
        this.success = true;
    }

    @Override
    public void installationFailure(String description) {
    }
}

