/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.schema.ittasks.Hotfix;
import com.sas.tools.installs.schema.ittasks.InstallType;
import com.sas.tools.installs.schema.ittasks.ItTasks;
import com.sas.tools.installs.schema.ittasks.LocaleType;
import com.sas.tools.installs.schema.ittasks.LocalesForHostType;
import com.sas.tools.installs.schema.ittasks.LocalesType;
import com.sas.tools.installs.schema.ittasks.LocalizationType;
import com.sas.tools.installs.schema.ittasks.LocalizationsType;
import com.sas.tools.installs.schema.ittasks.Max;
import com.sas.tools.installs.schema.ittasks.Version;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;

public class DeploymentXMLReader {
    private ItTasks tasks;

    public DeploymentXMLReader(File deploymentFile) throws JAXBException {
        this.tasks = SchemaUtils.unmarshal(deploymentFile, ItTasks.class);
    }

    public DeploymentXMLReader(InputStream inputStream) throws JAXBException {
        this.tasks = SchemaUtils.unmarshal(inputStream, ItTasks.class);
    }

    public boolean isSysReq() {
        return this.tasks.getFalseSkus() != null;
    }

    public LocalesForHostType getLocalesForHost(String host, String two_byte) {
        if (host.equalsIgnoreCase("mvs") && two_byte == null || host.equalsIgnoreCase("mvs") && two_byte.length() != 2) {
            return null;
        }
        List<LocalesForHostType> locales = this.tasks.getLocales().getLocalesForHost();
        for (LocalesForHostType l : locales) {
            if (!l.getHost().equalsIgnoreCase(host)) continue;
            if (host.equalsIgnoreCase("mvs")) {
                if (!l.getTwoByte().equalsIgnoreCase(two_byte)) continue;
                return l;
            }
            return l;
        }
        return null;
    }

    public LocaleType getDefaultLocaleForMVSEncoding(String two_byte) {
        if (two_byte == null || two_byte.length() != 2) {
            return null;
        }
        List<LocalesForHostType> locales = this.tasks.getLocales().getLocalesForHost();
        for (LocalesForHostType lfh : locales) {
            if (!lfh.getHost().equalsIgnoreCase("mvs") || !lfh.getTwoByte().equalsIgnoreCase(two_byte)) continue;
            for (LocaleType l : lfh.getLocale()) {
                if (!l.isDefault().booleanValue()) continue;
                return l;
            }
        }
        return null;
    }

    public LocaleType getLocaleForMVSEncodingAndName(String two_byte, String localeName) {
        if (two_byte == null || two_byte.length() != 2 || localeName == null || localeName.length() != 5) {
            return null;
        }
        List<LocalesForHostType> locales = this.tasks.getLocales().getLocalesForHost();
        for (LocalesForHostType lfh : locales) {
            if (!lfh.getHost().equalsIgnoreCase("mvs") || !lfh.getTwoByte().equalsIgnoreCase(two_byte)) continue;
            for (LocaleType l : lfh.getLocale()) {
                if (!l.getName().equalsIgnoreCase(localeName)) continue;
                return l;
            }
        }
        return null;
    }

    public boolean isTargetByBaseHost() {
        if (this.tasks.getInstall() != null && this.tasks.getInstall().isTargetByBaseHost() != null) {
            return this.tasks.getInstall().isTargetByBaseHost();
        }
        return false;
    }

    public String getHotFixName() {
        if (this.tasks.getInstall() != null && this.tasks.getInstall().getHotfix() != null) {
            return this.tasks.getInstall().getHotfix().getName();
        }
        return null;
    }

    public boolean isHotFix() {
        String hotFixName = this.getHotFixName();
        return hotFixName != null && !hotFixName.equals("");
    }

    public boolean isToolingRestartRequiredBeforeApplying() {
        if (this.tasks.getInstall() != null && this.tasks.getInstall().getHotfix() != null) {
            return this.tasks.getInstall().getHotfix().isToolingRestartRequiredBeforeApplying();
        }
        return false;
    }

    public String getDescription() {
        return this.tasks.getDescription();
    }

    public String getHotFixMinMaintVersion() {
        String minVersion = null;
        if (this.getHotFixVersion() != null && this.getHotFixVersion().getMin() != null) {
            minVersion = this.getHotFixVersion().getMin().getValue();
        }
        return minVersion;
    }

    public String getHotFixMaxMaintVersion() {
        String maxVersion = null;
        if (this.getHotFixMaxVersion() != null) {
            maxVersion = this.getHotFixMaxVersion().getValue();
        }
        return maxVersion;
    }

    public boolean isHotFixMaintVersionExclusive() {
        boolean exclusive = true;
        if (this.getHotFixMaxVersion() != null) {
            exclusive = this.getHotFixMaxVersion().isExclusive();
        }
        return exclusive;
    }

    public boolean getHotFixSecurityFix() {
        Hotfix hf;
        InstallType task = this.tasks.getInstall();
        if (task != null && (hf = task.getHotfix()) != null) {
            return hf.getSecurityFix();
        }
        return false;
    }

    public int getHotFixSecuritySequence() {
        Hotfix hf;
        InstallType task = this.tasks.getInstall();
        if (task != null && (hf = task.getHotfix()) != null) {
            return hf.getSecuritySequence();
        }
        return 0;
    }

    private Version getHotFixVersion() {
        Version hotFixVersion = null;
        if (this.tasks.getInstall() != null && this.tasks.getInstall().getHotfix() != null) {
            hotFixVersion = this.tasks.getInstall().getHotfix().getVersion();
        }
        return hotFixVersion;
    }

    private Max getHotFixMaxVersion() {
        Max maxVersion = null;
        if (this.getHotFixVersion() != null) {
            maxVersion = this.getHotFixVersion().getMax();
        }
        return maxVersion;
    }

    public List<String> getLocalizationLanguages(String locale) {
        LocalizationsType localizations;
        ArrayList<String> langs = new ArrayList<String>();
        LocalesType locales = this.tasks.getLocales();
        if (locales != null && (localizations = locales.getLocalizations()) != null) {
            for (LocalizationType localization : localizations.getLocalization()) {
                if (!localization.getLocaleRef().equals(locale)) continue;
                langs.addAll(localization.getLanguage());
                break;
            }
        }
        return langs;
    }
}

