/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.view.SSNResource;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class AltskuProperties {
    private static Logger log = (Logger)LogManager.getLogger(AltskuProperties.class);
    private static SSNResource bundle = new SSNResource(AltskuProperties.class);
    private static SSNResource enBundle = SSNResource.EnglishResource(AltskuProperties.class);
    final Controller controller;
    final String altsku;

    public AltskuProperties(Controller controller, String altsku) {
        this.controller = controller;
        this.altsku = altsku;
    }

    public String resolve(String value) {
        this.restoreContext();
        Pattern p = Pattern.compile("\\$\\{([^\\}]*)\\}");
        Matcher m = p.matcher(value);
        StringBuffer resolvedValue = new StringBuffer();
        boolean symbolFound = false;
        boolean resolvedProdHomeInfo = true;
        while (m.find()) {
            symbolFound = true;
            String symbolValue = m.group(1);
            Pattern methodPattern = Pattern.compile("([^(]+)\\(([^)]+)\\)");
            Matcher methodMatcher = methodPattern.matcher(symbolValue);
            if (methodMatcher.matches()) {
                String methodName = methodMatcher.group(1);
                String methodParams = methodMatcher.group(2);
                String[] params = methodParams.split(",");
                if (!methodName.equals("PRODUCTHOME")) continue;
                if (params.length != 2 && this.getProperty(symbolValue) == null) {
                    throw new InstallException(2, null, bundle.messageString("InstallationTask.PropertyNotSet", this.getClass().getName(), symbolValue), enBundle.messageString("InstallationTask.PropertyNotSet", this.getClass().getName(), symbolValue), null);
                }
                String productHome = this.controller.getSASController().getProductHome(params[0], params[1]);
                if (productHome == null) {
                    throw new InstallException(2, null, bundle.messageString("InstallationTask.PropertyNotSet", this.getClass().getName(), symbolValue), enBundle.messageString("InstallationTask.PropertyNotSet", this.getClass().getName(), symbolValue), null);
                }
                m.appendReplacement(resolvedValue, productHome.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
                continue;
            }
            if (this.getProperty(symbolValue) == null) {
                String[] twelveBytes;
                for (String t : twelveBytes = new String[]{"platfmltypes", "mgmtconsole", "databuilder", "eguide", "msofficeint", "eguide_wx6"}) {
                    try {
                        if (symbolValue.contains(t + "Home")) {
                            String home = this.controller.getProductHomeInfo().get(t + "Home");
                            if (home != null) {
                                m.appendReplacement(resolvedValue, home.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
                                continue;
                            }
                            resolvedProdHomeInfo = false;
                            log.info("Unable to resolve ${" + t + "Home} in " + value);
                            continue;
                        }
                        log.info("symbolValue does NOT contain " + t + "Home");
                    }
                    catch (Exception e) {
                        log.info("Unable to resolve ${" + t + "Home} in " + value);
                    }
                }
                if (resolvedProdHomeInfo || this.controller.getProperty("12ByteCode").equalsIgnoreCase("itrmeg")) continue;
                throw new InstallException(2, null, bundle.messageString("InstallationTask.PropertyNotSet", this.getClass().getName(), symbolValue), enBundle.messageString("InstallationTask.PropertyNotSet", this.getClass().getName(), symbolValue), null);
            }
            m.appendReplacement(resolvedValue, this.getProperty(m.group(1)).replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        }
        if (symbolFound) {
            m.appendTail(resolvedValue);
        } else {
            resolvedValue.append(value);
        }
        return resolvedValue.toString();
    }

    public String getProperty(String key) {
        return this.controller.getProperty(this.altsku, key);
    }

    private void restoreContext() {
        Vector<String> altskus = new Vector<String>();
        altskus.add(this.altsku);
        this.controller.setAltSkus(altskus);
        this.controller.setAltSku(this.altsku);
    }
}

