/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parsing;

import MITI.EtlBridgeLib.DesignTreeProcessor;
import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRConnectionManager;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.parsers.ParserBase;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.StatementMetaInfo;
import MITI.messages.MIREtlBridgeLib.ETLLIB;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRConnectedTransformation;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDelimitedFileDescriptor;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIREmbeddedCallTransformation;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStructuralFeature;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIRTransformationDataAttribute;
import MITI.sdk.MIRTransformationDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class EtlSqlParser
extends ParserBase {
    private static final String BRIDGE_SQL_CONDITION = "SQL CONDITION";
    private static final String SP_RETURNVALUE = "ReturnValue";
    private DesignTreeProcessor imvTreeProcessor;
    private DesignTreeProcessor.ModelProcessor imvModelProcessor;
    protected MIRConnectedTransformation imvParsingInTransformation;
    private String imvDefaultConnectionName;
    private boolean imvParsingOutputIsPositionBased;
    private int imvParsingInParameterPosition;
    private MIRElement imvTransformationOwner;
    private String imvStoreSystemType;
    private DesignTreeProcessor.CallStackEntry imvCallStack;
    private int imvExpressionCount;
    private String imvExpressionText;
    protected MIRClassifierMap imvFirstClassifierMap;
    protected LinkedList<MIRClassifierMap> additionClassifierMaps = new LinkedList();
    private MIRConnectionDataPackage sourceFileDataPackage;
    private TreeSet<MIRClassifier> imvFlatFileSet = new TreeSet();

    public EtlSqlParser(DesignTreeProcessor designTreeProcessor, DesignTreeProcessor.ModelProcessor modelProcessor, int n, int n2, MIRConnectedTransformation mIRConnectedTransformation, String string, String string2, boolean bl, DesignTreeProcessor.CallStackEntry callStackEntry) {
        super(designTreeProcessor.imvLog, null, n, n2);
        this.imvTreeProcessor = designTreeProcessor;
        this.imvModelProcessor = modelProcessor;
        if (mIRConnectedTransformation != null) {
            this.setTransformation(mIRConnectedTransformation, string, bl, callStackEntry);
        }
        this.imvStoreSystemType = string2;
    }

    public EtlSqlParser(DesignTreeProcessor designTreeProcessor, DesignTreeProcessor.ModelProcessor modelProcessor, int n, int n2, String string) {
        this(designTreeProcessor, modelProcessor, n, n2, null, "", string, false, null);
    }

    public void setTransformation(MIRConnectedTransformation mIRConnectedTransformation, String string, boolean bl, DesignTreeProcessor.CallStackEntry callStackEntry) {
        this.imvParsingInTransformation = mIRConnectedTransformation;
        this.imvDefaultConnectionName = string;
        this.imvParsingInParameterPosition = 0;
        this.imvTransformationOwner = this.imvParsingInTransformation.getDiModel();
        if (this.imvTransformationOwner == null) {
            this.imvTransformationOwner = this.imvParsingInTransformation.getEmbeddedCallTransformation();
        }
        this.additionClassifierMaps.clear();
        this.imvCallStack = callStackEntry;
        assert (this.imvTransformationOwner != null);
        this.imvExpressionCount = 0;
        this.imvExpressionText = "";
        this.imvFirstClassifierMap = null;
        this.sourceFileDataPackage = null;
    }

    public void setSourceFileDataPackage(MIRConnectionDataPackage mIRConnectionDataPackage) {
        this.sourceFileDataPackage = mIRConnectionDataPackage;
    }

    public LinkedList<MIRClassifierMap> getAdditionClassifierMaps() {
        return this.additionClassifierMaps;
    }

    @Override
    public boolean isMultiStatement() {
        return this.imvTreeProcessor.isMultiStatement(this.imvFirstClassifierMap);
    }

    @Override
    public boolean isMultiStatementQuery() {
        return this.imvTreeProcessor.isMultiStatementQuery(this.imvFirstClassifierMap);
    }

    @Override
    public boolean parse(MIRClassifierMap mIRClassifierMap) throws MIRException {
        this.imvFirstClassifierMap = mIRClassifierMap;
        boolean bl = super.parse(mIRClassifierMap);
        if (this.isMultiStatement()) {
            for (MIRClassifierMap mIRClassifierMap2 : this.imvParsingInTransformation.getClassifierMaps().toArray(new MIRClassifierMap[this.imvParsingInTransformation.getClassifierMapCount()])) {
                if (mIRClassifierMap2 == this.imvFirstClassifierMap) continue;
                this.mergeClassifierMap(mIRClassifierMap2);
            }
        }
        return bl;
    }

    protected boolean canMergeClassifierMap(MIRClassifierMap mIRClassifierMap) {
        boolean bl = false;
        if (mIRClassifierMap.getExpression() != null && mIRClassifierMap.getExpression().getStatementNodeCount() == 1) {
            MIRObject mIRObject;
            MIRClassifierMap mIRClassifierMap2 = null;
            MIRStatementNode mIRStatementNode = mIRClassifierMap.getExpression().getStatementNodes().first();
            if (mIRStatementNode != null && mIRStatementNode.getReferencedExpressionNodeCount() == 1 && (mIRObject = mIRStatementNode.getReferencedExpressionNodes().first().getParent()) != null && mIRObject.isInstanceOf((short)112) && (mIRClassifierMap2 = ((MIRExpression)mIRObject).getClassifierMap()) != null && (mIRClassifierMap.getDestinationClassifier() == null || mIRClassifierMap.getDestinationClassifier() == mIRClassifierMap2.getDestinationClassifier())) {
                bl = true;
            }
        }
        return bl;
    }

    protected void mergeClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (!this.canMergeClassifierMap(mIRClassifierMap)) {
            return;
        }
        MIRClassifierMap mIRClassifierMap2 = ((MIRExpression)mIRClassifierMap.getExpression().getStatementNodes().first().getReferencedExpressionNodes().first().getParent()).getClassifierMap();
        for (MIRFeatureMap mIRFeatureMap : mIRClassifierMap.getFeatureMaps().toArray(new MIRFeatureMap[mIRClassifierMap.getFeatureMapCount()])) {
            mIRFeatureMap.removeClassifierMap();
            mIRClassifierMap2.addFeatureMap(mIRFeatureMap);
        }
        for (MIRClassifier mIRClassifier : mIRClassifierMap.getSourceClassifiers()) {
            if (mIRClassifierMap2.containsSourceClassifier(mIRClassifier)) continue;
            mIRClassifierMap2.addSourceClassifier(mIRClassifier);
        }
        for (MIRClassifier mIRClassifier : mIRClassifierMap.getControlClassifiers()) {
            if (mIRClassifierMap2.containsControlClassifier(mIRClassifier)) continue;
            mIRClassifierMap2.addControlClassifier(mIRClassifier);
        }
        if (mIRClassifierMap2.getDestinationClassifier() == null && mIRClassifierMap.getDestinationClassifier() != null) {
            mIRClassifierMap2.addDestinationClassifier(mIRClassifierMap.getDestinationClassifier());
        }
        mIRClassifierMap.delete();
    }

    private MIRClassifier getTextFlatFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        string = MIRConnectionManager.getInstance().mapPath(string, false);
        boolean bl = false;
        while (string.endsWith("\\") || string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        MIRConnectionNamespace mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(this.cm.getRootModel(), string, stringBuilder);
        String string2 = stringBuilder.toString();
        MIRStoreConnection mIRStoreConnection = MIRBridgeLib.getStoreConnection(mIRConnectionNamespace);
        try {
            this.imvModelProcessor.getStoreModel(mIRStoreConnection.getModel().getContent(), mIRStoreConnection.getName(), mIRStoreConnection.getName(), false, this.imvParsingInTransformation, this.imvCallStack);
        }
        catch (MIRException mIRException) {
            mIRException.printStackTrace();
        }
        MIRClassifier mIRClassifier = mIRConnectionNamespace.getClassifier(string2);
        if (!this.imvParsingInTransformation.getConnectionDataSets().contains(mIRClassifier)) {
            mIRClassifier = null;
        }
        if (mIRClassifier == null && this.imvParsingInTransformation != null) {
            mIRClassifier = new MIRConnectionDataSet();
            mIRClassifier.setName(string2);
            mIRConnectionNamespace.addClassifier(mIRClassifier);
            this.imvParsingInTransformation.addConnectionDataSet((MIRConnectionDataSet)mIRClassifier);
            if (this.imvParsingInTransformation.getFlatFileDescriptor() == null) {
                this.imvParsingInTransformation.addFlatFileDescriptor(new MIRDelimitedFileDescriptor());
            }
        }
        if (mIRClassifier != null && bl) {
            mIRClassifier.setLineageOption(16384);
        }
        return mIRClassifier;
    }

    @Override
    public void setBuiltinOperation(MIROperationNode mIROperationNode) {
        if (this.getDatabaseType() == 21 && "UNLOAD".equalsIgnoreCase(mIROperationNode.getOriginalText())) {
            if (this.additionClassifierMaps == null) {
                this.additionClassifierMaps = new LinkedList();
            }
            MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
            MIRExpressionNode mIRExpressionNode = this.getParameter(mIROperationNode, "SELECT", 0);
            MIRExpressionNode mIRExpressionNode2 = this.getParameter(mIROperationNode, "TO", 1);
            if (mIRExpressionNode == null || mIRExpressionNode2 == null || mIRExpressionNode.getOriginalText().length() < 3 || mIRExpressionNode2.getOriginalText().length() < 3) {
                return;
            }
            mIRClassifierMap.setOperation(mIRExpressionNode.getOriginalText().substring(1, mIRExpressionNode.getOriginalText().length() - 1).replace("\\", ""));
            MIRClassifier mIRClassifier = this.getTextFlatFile(mIRExpressionNode2.getOriginalText().substring(1, mIRExpressionNode2.getOriginalText().length() - 1));
            if (mIRClassifier != null && !mIRClassifierMap.getOperation().isEmpty() && this.cm.getTransformation() != null) {
                this.additionClassifierMaps.add(mIRClassifierMap);
                this.cm.getTransformation().addClassifierMap(mIRClassifierMap);
                mIRClassifierMap.addDestinationClassifier(mIRClassifier);
            }
            return;
        }
    }

    @Override
    public void getSrcElements(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        this.getSrcElements(new LookupOptions(mIRElementNode, false), collection, collection2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void getSrcElements(LookupOptions lookupOptions, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        boolean bl;
        MIRElementNode mIRElementNode = lookupOptions.getNode();
        if (this.imvTreeProcessor.ignoreElementNode(mIRElementNode)) {
            return;
        }
        MIRDiModel mIRDiModel = (MIRDiModel)mIRElementNode.getRootModel();
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        boolean bl2 = bl = mIRElementNamePart != null && mIRElementNamePart.getQuoted();
        if (mIRElementNode.getDestinationElementType() == 75) {
            MIRConnectionDataSet mIRConnectionDataSet = null;
            try {
                if (this.sourceFileDataPackage != null) {
                    mIRConnectionDataSet = this.getDataSet(this.sourceFileDataPackage, mIRElementNamePart.getName(), false);
                    if (!this.imvParsingInTransformation.getPositionBasedQuery()) {
                        mIRConnectionDataSet.setLineageOption(8192);
                    }
                } else {
                    mIRConnectionDataSet = this.getDataSet(mIRElementNode, (byte)0);
                }
            }
            catch (MIRException mIRException) {
                ETLLIB.ERR_ENCOUNTERED_EXCEPTION.log(mIRException.getMessage());
            }
            if (mIRConnectionDataSet == null || mIRConnectionDataSet.getName().isEmpty()) {
                ETLLIB.WRN_CLASSIFIER_NAME_EMPTY.log(this.cm.getPath(true), this.cm.getOperation());
                this.fail();
                if (mIRConnectionDataSet != null) {
                    mIRConnectionDataSet.delete();
                }
                return;
            }
            this.setCollationLineageOption(mIRConnectionDataSet, bl);
            collection2.add(mIRConnectionDataSet);
        } else if (mIRElementNode.getDestinationElementType() == 209) {
            String string = lookupOptions.getName();
            MIRClassifier mIRClassifier2 = this.getTextFlatFile(string);
            if (mIRClassifier2 != null) {
                this.imvFlatFileSet.add(mIRClassifier2);
                collection2.add(mIRClassifier2);
            }
        } else if (mIRElementNode.getDestinationElementType() == 77) {
            Object object;
            boolean bl3 = !collection.isEmpty();
            for (MIRClassifier linkedList2 : collection) {
                bl3 &= this.imvFlatFileSet.contains(linkedList2);
            }
            if (bl3) {
                object = MIRExpressionAnalyzerHelper.getCanonicalName(lookupOptions.getName(), lookupOptions.isQuoted(), this.getDatabaseType());
                LinkedList<MIRFeature> linkedList = new LinkedList<MIRFeature>();
                if (lookupOptions.hasStar()) {
                    block12: for (MIRClassifier mIRClassifier2 : collection) {
                        for (MIRFeature mIRFeature : mIRClassifier2.getFeatures()) {
                            if (!mIRFeature.hasLineageOption(256)) continue;
                            linkedList.add(mIRFeature);
                            continue block12;
                        }
                    }
                } else if (lookupOptions.isPositionBased()) {
                    for (MIRClassifier mIRClassifier3 : collection) {
                        MIRFeature mIRFeature = this.getFeatureByPosition(mIRClassifier3, lookupOptions.getPosition());
                        if (mIRFeature == null) continue;
                        linkedList.add(mIRFeature);
                    }
                } else {
                    linkedList.addAll(this.getFeatures((String)object, lookupOptions.isQuoted(), collection));
                }
                if (linkedList.isEmpty()) {
                    if (((String)object).isEmpty()) {
                        object = String.format("%03d", lookupOptions.getPosition());
                    }
                    boolean bl4 = collection.stream().filter(mIRClassifier -> mIRClassifier.isInstanceOf((short)254)).count() > 1L;
                    for (MIRClassifier mIRClassifier4 : collection) {
                        MIRFeature mIRFeature;
                        mIRFeature = new MIRConnectionDataAttribute();
                        mIRFeature.setLineageOption(512);
                        mIRFeature.addType(MIRTypeLib.getUndefinedBaseType(mIRDiModel));
                        mIRFeature.setPosition((short)lookupOptions.getPosition());
                        mIRFeature.setName((String)object);
                        mIRClassifier4.addFeatureUniqueName(mIRFeature);
                        this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                        if (bl4) {
                            mIRFeature.setLineageOption(1);
                        }
                        linkedList.add(mIRFeature);
                    }
                }
                collection2.addAll(linkedList);
            } else {
                object = mIRElementNode.getName();
                String string = this.imvTreeProcessor.getTransformationTaskVariableName(this.imvTransformationOwner, (String)object);
                String string2 = this.imvTreeProcessor.getQueryParameterName((String)object);
                int n = this.imvTreeProcessor.getQueryParameterByPosition((String)object, this.imvParsingInParameterPosition);
                if (!string.isEmpty()) {
                    if (this.imvTransformationOwner.isInstanceOf((short)258)) {
                        void var14_33;
                        MIRConnectionDataSet mIRConnectionDataSet = ((MIRDiModel)this.imvTransformationOwner).getVariableConnectionDataSet();
                        if (mIRConnectionDataSet == null) {
                            MIRClassifier mIRClassifier5 = this.imvTreeProcessor.getVariableDataSet(this.imvTransformationOwner);
                        }
                        if (var14_33 != null) {
                            void var15_49 = var14_33;
                            synchronized (var15_49) {
                                MIRConnectionDataAttribute mIRConnectionDataAttribute = (MIRConnectionDataAttribute)var14_33.getFeature(string);
                                if (mIRConnectionDataAttribute == null) {
                                    mIRConnectionDataAttribute = new MIRConnectionDataAttribute();
                                    mIRConnectionDataAttribute.setName(string);
                                    var14_33.addFeature(mIRConnectionDataAttribute);
                                }
                                assert (mIRConnectionDataAttribute != null);
                                this.setCollationLineageOption(mIRConnectionDataAttribute, bl);
                                collection2.add(mIRConnectionDataAttribute);
                            }
                        }
                    } else if (this.imvTransformationOwner.isInstanceOf((short)320)) {
                        void var14_36;
                        MIRTransformationDataSet mIRTransformationDataSet = ((MIREmbeddedCallTransformation)this.imvTransformationOwner).getVariableTransformationDataSet();
                        if (mIRTransformationDataSet == null) {
                            MIRClassifier mIRClassifier6 = this.imvTreeProcessor.getVariableDataSet(this.imvTransformationOwner);
                        }
                        void var15_50 = var14_36;
                        synchronized (var15_50) {
                            MIRTransformationDataAttribute mIRTransformationDataAttribute = (MIRTransformationDataAttribute)var14_36.getFeature(string);
                            if (mIRTransformationDataAttribute == null) {
                                mIRTransformationDataAttribute = new MIRTransformationDataAttribute();
                                mIRTransformationDataAttribute.setName(string);
                                var14_36.addFeature(mIRTransformationDataAttribute);
                            }
                            assert (mIRTransformationDataAttribute != null);
                            this.setCollationLineageOption(mIRTransformationDataAttribute, bl);
                            collection2.add(mIRTransformationDataAttribute);
                        }
                    }
                } else if (n >= 0) {
                    this.imvParsingInParameterPosition = n;
                    for (MIRClassifier mIRClassifier7 : this.cm.getSourceClassifiers()) {
                        MIRFeature mIRFeature;
                        List<MIRFeature> list2;
                        MIRTransformationDataSet mIRTransformationDataSet;
                        if (!mIRClassifier7.isInstanceOf((short)256) || (mIRTransformationDataSet = (MIRTransformationDataSet)mIRClassifier7).getParent() != this.imvParsingInTransformation || this.imvParsingInParameterPosition >= (list2 = mIRTransformationDataSet.getFeatureByPosition()).size() || (mIRFeature = list2.get(this.imvParsingInParameterPosition)) == null) continue;
                        this.setCollationLineageOption(mIRFeature, bl);
                        collection2.add(mIRFeature);
                    }
                    ++this.imvParsingInParameterPosition;
                } else if (!string2.isEmpty()) {
                    boolean bl5;
                    MIRTransformationDataSet mIRTransformationDataSet;
                    boolean bl6 = false;
                    for (MIRClassifier mIRClassifier8 : this.cm.getControlClassifiers()) {
                        MIRFeature mIRFeature;
                        if (!mIRClassifier8.isInstanceOf((short)256) || (mIRTransformationDataSet = (MIRTransformationDataSet)mIRClassifier8).getParent() != this.imvParsingInTransformation || (mIRFeature = mIRTransformationDataSet.getFeature(string2)) == null) continue;
                        this.setCollationLineageOption(mIRFeature, bl);
                        collection2.add(mIRFeature);
                        bl5 = true;
                        break;
                    }
                    if (!bl5) {
                        for (MIRClassifier mIRClassifier8 : this.cm.getSourceClassifiers()) {
                            MIRFeature mIRFeature;
                            if (!mIRClassifier8.isInstanceOf((short)256) || (mIRTransformationDataSet = (MIRTransformationDataSet)mIRClassifier8).getParent() != this.imvParsingInTransformation || (mIRFeature = mIRTransformationDataSet.getFeature(string2)) == null) continue;
                            this.setCollationLineageOption(mIRFeature, bl);
                            collection2.add(mIRFeature);
                            boolean bl7 = true;
                            break;
                        }
                    }
                } else {
                    void var14_47;
                    void var14_45;
                    int n2;
                    String string3 = list.get(list.size() - 1).getName();
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        MIRElementNamePart mIRElementNamePart2 = list.get(n2);
                        if (mIRElementNamePart2.getSourceElementType() != 77) continue;
                        String string4 = mIRElementNamePart2.getName();
                        break;
                    }
                    if (mIRElementNode.getParent().isInstanceOf((short)107) && mIRElementNode.getParent().getName().equals("*")) {
                        void var14_43;
                        String string5 = this.imvTreeProcessor.getStarFeatureName(this.cm, (String)var14_43);
                    }
                    n2 = 0;
                    if (var14_45.isEmpty() && lookupOptions.isPositionBased()) {
                        String string6 = String.format("%03d", lookupOptions.getPosition());
                        n2 = 1;
                    }
                    if (var14_47.isEmpty()) {
                        ETLLIB.WRN_UNSUPPORTED_SOURCE_COLUMN.log(this.imvTreeProcessor.imvLog, var14_47, this.imvParsingInTransformation.getPath());
                    } else {
                        MIRModelObject mIRModelObject;
                        Object object2;
                        MIRFeature mIRFeature;
                        boolean bl8 = false;
                        if (!bl8 && this.imvTreeProcessor != null && this.cm != null && collection != null && (this.cm.getOperation().toUpperCase().trim().startsWith("UPDATE") || this.cm.getOperation().toUpperCase().trim().startsWith("INSERT")) && collection.size() == 1 && this.cm.getSourceClassifierCount() == 1 && this.imvTreeProcessor.getClass().getName().contains("IbmDataStageImport") && list.size() == 2 && list.get(0).toString().startsWith("ORCHESTRATE") && (mIRFeature = ((MIRClassifier)(object2 = this.cm.getSourceClassifiers().first())).getFeature((String)var14_47)) != null) {
                            this.setCollationLineageOption(mIRFeature, bl);
                            collection2.add(mIRFeature);
                            bl8 = true;
                        }
                        if (!bl8) {
                            for (MIRClassifier mIRClassifier9 : collection) {
                                MIRFeature mIRFeature2 = this.getItem((String)var14_47, bl, mIRClassifier9.getFeatures());
                                if (mIRFeature2 == null) continue;
                                bl8 = true;
                                this.setCollationLineageOption(mIRFeature2, bl);
                                collection2.add(mIRFeature2);
                            }
                        }
                        if (!bl8) {
                            boolean bl9 = collection.stream().filter(mIRClassifier -> mIRClassifier.isInstanceOf((short)254)).count() > 1L;
                            Iterator<MIRClassifier> iterator = collection.iterator();
                            while (iterator.hasNext()) {
                                MIRClassifier mIRClassifier10;
                                mIRModelObject = mIRClassifier10 = iterator.next();
                                synchronized (mIRModelObject) {
                                    Object object3;
                                    if (mIRClassifier10.getNativeType().equals("Stored Procedure")) {
                                        object3 = mIRClassifier10.getFeatures().toArray();
                                        int n3 = ((Object[])object3).length;
                                        for (int i = 0; i < n3; ++i) {
                                            Object object4 = object3[i];
                                            MIRFeature mIRFeature3 = (MIRFeature)object4;
                                            if (!mIRFeature3.hasLineageOption(512)) continue;
                                            mIRFeature3.delete();
                                        }
                                    }
                                    if ((object3 = this.getItem((String)var14_47, bl, mIRClassifier10.getFeatures())) == null) {
                                        if (mIRClassifier10.isInstanceOf((short)254)) {
                                            object3 = new MIRConnectionDataAttribute();
                                            ((MIRObject)object3).setName((String)var14_47);
                                            if (bl9) {
                                                ((MIRFeature)object3).setLineageOption(1);
                                            }
                                            if (this.sourceFileDataPackage != null && ((MIRConnectionDataSet)mIRClassifier10).getConnectionDataPackage() == this.sourceFileDataPackage) {
                                                if (((MIRConnectionDataSet)mIRClassifier10).hasLineageOption(8192)) {
                                                    ((MIRFeature)object3).setLineageOption(8192);
                                                }
                                                ((MIRFeature)object3).setPosition((short)lookupOptions.getPosition());
                                            } else if (lookupOptions.isPositionBased() && n2 != 0) {
                                                ((MIRFeature)object3).setPosition((short)lookupOptions.getPosition());
                                                ((MIRFeature)object3).setLineageOption(512);
                                            }
                                            mIRClassifier10.addFeature((MIRFeature)object3);
                                            bl8 = true;
                                            this.setCollationLineageOption((MIRObject)object3, bl);
                                            collection2.add((MIRElement)object3);
                                        } else if (collection.size() == 1) {
                                            ETLLIB.WRN_UNSUPPORTED_SOURCE_COLUMN.log(this.imvTreeProcessor.imvLog, var14_47, this.imvParsingInTransformation.getPath());
                                        }
                                    }
                                }
                            }
                        }
                        if (!bl8) {
                            for (MIRClassifier mIRClassifier11 : this.cm.getSourceClassifiers()) {
                                MIRTransformationDataSet mIRTransformationDataSet;
                                if (!mIRClassifier11.isInstanceOf((short)256) || (mIRTransformationDataSet = (MIRTransformationDataSet)mIRClassifier11).getParent() != this.imvParsingInTransformation || (mIRModelObject = mIRTransformationDataSet.getFeature((String)var14_47)) == null) continue;
                                this.setCollationLineageOption(mIRModelObject, bl);
                                collection2.add(mIRModelObject);
                                bl8 = true;
                                break;
                            }
                        }
                    }
                }
            }
        } else if (mIRElementNode.getDestinationElementType() != 24) assert (false);
    }

    private MIRStoreConnection getFileConnection(MIRDiModel mIRDiModel, String string) {
        MIRStoreConnection mIRStoreConnection = mIRDiModel.getStoreConnection(string);
        if (mIRStoreConnection == null) {
            mIRStoreConnection = new MIRStoreConnection();
            mIRStoreConnection.setName(string);
            mIRDiModel.addStoreConnection(mIRStoreConnection);
        }
        mIRStoreConnection.setStoreType((byte)2);
        mIRStoreConnection.setSystemType("FILE");
        if (mIRStoreConnection.getSourceOfMappingModel() == null) {
            mIRDiModel.addSourceStoreConnection(mIRStoreConnection);
        }
        return mIRStoreConnection;
    }

    private MIRFeature getFeatureByPosition(MIRClassifier mIRClassifier, int n) {
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (!mIRFeature.hasLineageOption(512) || mIRFeature.getPosition() != n) continue;
            return mIRFeature;
        }
        return null;
    }

    @Override
    public void setUnknownOperation(MIROperationNode mIROperationNode) {
        if (mIROperationNode != null) {
            this.imvTreeProcessor.startParsingUnknownOperation(mIROperationNode);
        }
        super.setUnknownOperation(mIROperationNode);
    }

    public MIRExpressionNode getParameter(MIROperationNode mIROperationNode, String string, int n) {
        int n2 = 0;
        boolean bl = false;
        MIRExpressionNode[] mIRExpressionNodeArray = new MIRExpressionNode[mIROperationNode.getExpressionNodeCount()];
        for (MIRExpressionNode mIRExpressionNode : mIROperationNode.getExpressionNodeByPosition()) {
            if (mIRExpressionNode instanceof MIROperatorNode && "=".equals(mIRExpressionNode.getName())) {
                MIRExpressionNode mIRExpressionNode2;
                MIRExpressionNode mIRExpressionNode3 = ((MIROperatorNode)mIRExpressionNode).getRightExpressionNode();
                if (mIRExpressionNode3 instanceof MIRConstantNode || mIRExpressionNode3 instanceof MIRElementNode) {
                    mIRExpressionNodeArray[n2] = mIRExpressionNode3;
                }
                if ((mIRExpressionNode2 = ((MIROperatorNode)mIRExpressionNode).getLeftExpressionNode()) != null && !mIRExpressionNode2.getName().isEmpty()) {
                    if (mIRExpressionNode2.getName().equals(string)) {
                        return mIRExpressionNodeArray[n2];
                    }
                    bl = true;
                }
            }
            ++n2;
        }
        return !bl && n >= 0 && mIRExpressionNodeArray.length > n ? mIRExpressionNodeArray[n] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSrcElements(MIROperationNode mIROperationNode, Collection<MIRElement> collection) {
        if (mIROperationNode != null) {
            this.imvTreeProcessor.stopParsingOperation(mIROperationNode);
            if (this.getDatabaseType() != 2) {
                return;
            }
            try {
                MIRConnectionDataSet mIRConnectionDataSet;
                StringBuilder stringBuilder = new StringBuilder();
                MIRConnectionPackage mIRConnectionPackage = this.getDataSetSchema(mIROperationNode, stringBuilder, (byte)1);
                MIRConnectionDataSet mIRConnectionDataSet2 = mIRConnectionDataSet = this.getDataSet(mIRConnectionPackage, stringBuilder.toString(), true);
                synchronized (mIRConnectionDataSet2) {
                    boolean bl;
                    collection.add(mIRConnectionDataSet);
                    MIRClassifier mIRClassifier = this.cm.getDestinationClassifier();
                    if (!this.cm.containsSourceClassifier(mIRConnectionDataSet)) {
                        this.cm.addSourceClassifier(mIRConnectionDataSet);
                    }
                    boolean bl2 = bl = MIRExpressionAnalyzerHelper.isInClassifierContext(mIROperationNode) || MIRExpressionAnalyzerHelper.isInCallContext(mIROperationNode);
                    if (!bl) {
                        MIRFeature mIRFeature = mIRConnectionDataSet.getFeature(SP_RETURNVALUE);
                        if (mIRFeature == null) {
                            mIRFeature = new MIRConnectionDataAttribute();
                            mIRFeature.setName(SP_RETURNVALUE);
                            mIRFeature.setPosition((short)1);
                            mIRFeature.setLineageOption(512);
                            mIRConnectionDataSet.addFeatureUniqueName(mIRFeature);
                        }
                        collection.clear();
                        collection.add(mIRFeature);
                    } else {
                        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                            if (mIRFeature.getDestinationOfFeatureMap() != null) continue;
                            MIRConnectionDataAttribute mIRConnectionDataAttribute = new MIRConnectionDataAttribute();
                            ((MIRFeature)mIRConnectionDataAttribute).setFrom(mIRFeature);
                            mIRConnectionDataSet.addFeatureUniqueName(mIRConnectionDataAttribute);
                            MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
                            if (mIRFeatureMap == null) {
                                mIRFeatureMap = new MIRFeatureMap();
                                mIRFeatureMap.addDestinationFeature(mIRFeature);
                                mIRFeatureMap.addSourceFeature(mIRConnectionDataAttribute);
                                this.cm.addFeatureMap(mIRFeatureMap);
                                continue;
                            }
                            if (mIRFeatureMap.containsSourceFeature(mIRConnectionDataAttribute)) continue;
                            mIRFeatureMap.addSourceFeature(mIRConnectionDataAttribute);
                        }
                    }
                }
            }
            catch (MIRException mIRException) {
                BLIB.DBG_DEBUG.log(mIRException, "Fail to processing operation node");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MIRFeature getDstCondition(MIRClassifier mIRClassifier) {
        MIRClassifier mIRClassifier2 = mIRClassifier;
        synchronized (mIRClassifier2) {
            MIRCondition mIRCondition = new MIRCondition();
            mIRCondition.setName(BRIDGE_SQL_CONDITION);
            mIRClassifier.addFeatureUniqueName(mIRCondition, '_');
            return mIRCondition;
        }
    }

    @Override
    public MIRClassifierMap getOutput(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, byte by) {
        MIRClassifierMap mIRClassifierMap = null;
        if (by == 2) {
            mIRClassifierMap = new MIRClassifierMap();
            this.imvParsingInTransformation.addClassifierMap(mIRClassifierMap);
            if (!(this.cm.getDestinationClassifier() == null || this.cm != this.imvFirstClassifierMap && this.cm.getDestinationClassifier().isInstanceOf((short)254))) {
                mIRClassifierMap.addDestinationClassifier(this.cm.getDestinationClassifier());
            }
            for (MIRClassifier mIRClassifier : this.imvFirstClassifierMap.getSourceClassifiers()) {
                mIRClassifierMap.addSourceClassifier(mIRClassifier);
            }
            for (MIRClassifier mIRClassifier : this.imvFirstClassifierMap.getControlClassifiers()) {
                mIRClassifierMap.addControlClassifier(mIRClassifier);
            }
            this.cm = mIRClassifierMap;
            this.setDstClassifier(mIRElementNode);
            StatementMetaInfo statementMetaInfo = this.getStatementMetaInfo(mIRElementNode);
            this.cm.setOperation(statementMetaInfo.getText());
        }
        return mIRClassifierMap;
    }

    @Override
    public void setDstClassifier(MIRElementNode mIRElementNode) {
        try {
            Object object;
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder("");
            MIRConnectionPackage mIRConnectionPackage = this.getDataSetSchema(mIRElementNode, stringBuilder, (byte)1);
            MIRClassifier mIRClassifier = this.cm.getDestinationClassifier();
            List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
            MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
            boolean bl2 = bl = mIRElementNamePart != null && mIRElementNamePart.getQuoted();
            if (mIRClassifier != null && mIRClassifier.isInstanceOf((short)254)) {
                if (stringBuilder.toString().isEmpty()) {
                    ETLLIB.WRN_CLASSIFIER_NAME_EMPTY.log(this.cm.getPath(true), this.cm.getOperation());
                    this.fail();
                    return;
                }
                mIRClassifier.setName(stringBuilder.toString());
                mIRClassifier.setPhysicalName("");
                if (((MIRConnectionDataSet)mIRClassifier).getConnectionDataPackage() == null && mIRConnectionPackage != null) {
                    mIRConnectionPackage.addClassifier(mIRClassifier);
                }
                this.setCollationLineageOption(mIRClassifier, bl);
            } else {
                object = this.getDataSet(mIRElementNode, (byte)1);
                if (object != null) {
                    if (object != mIRClassifier && mIRClassifier != null) {
                        this.cm.removeDestinationClassifier();
                    }
                    mIRClassifier = object;
                    this.cm.addDestinationClassifier((MIRClassifier)object);
                    this.setCollationLineageOption((MIRObject)object, bl);
                }
            }
            if (mIRClassifier != null && MIRExpressionAnalyzerHelper.isDropTable(mIRElementNode)) {
                mIRClassifier.setLineageOption(1024);
            }
            object = this.getStatementMetaInfo(mIRElementNode);
            if (!this.isMultiStatement() && !this.imvExpressionText.equals(((StatementMetaInfo)object).getText()) && this.imvExpressionCount > 0) {
                String string = ((StatementMetaInfo)object).getText();
                ETLLIB.WRN_MULTISTATEMENT_QUERY.log(this.imvParsingInTransformation.getPath(false), string);
            }
            this.imvExpressionText = ((StatementMetaInfo)object).getText();
            ++this.imvExpressionCount;
        }
        catch (MIRException mIRException) {
            ETLLIB.ERR_ENCOUNTERED_EXCEPTION.log(mIRException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MIRFeature getDstFeature(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
        MIRClassifier mIRClassifier2 = mIRClassifier;
        synchronized (mIRClassifier2) {
            String string = lookupOptions.getName();
            int n = lookupOptions.getPosition();
            if (lookupOptions.hasStar()) {
                MIRFeature mIRFeature = null;
                string = lookupOptions.getName() != null && !lookupOptions.getName().isEmpty() ? lookupOptions.getName() : "*";
                for (MIRFeature mIRFeature2 : mIRClassifier.getFeatures()) {
                    if (mIRFeature2.getPosition() != n && !mIRFeature2.hasLineageOption(256)) continue;
                    mIRFeature = mIRFeature2;
                    break;
                }
                if (mIRFeature == null && !mIRClassifier.isInstanceOf((short)256)) {
                    mIRFeature = new MIRConnectionDataAttribute();
                    mIRFeature.setName(string);
                    mIRFeature.setLineageOption(256);
                    mIRClassifier.addFeatureUniqueName(mIRFeature);
                }
                return mIRFeature;
            }
            if (this.imvTransformationOwner != null && this.imvTransformationOwner.isInstanceOf((short)238) ? lookupOptions.isPositionBased() : this.imvParsingOutputIsPositionBased) {
                for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                    if (mIRFeature.getPosition() != n) continue;
                    return mIRFeature;
                }
                if (!mIRClassifier.isInstanceOf((short)254)) {
                    return null;
                }
                for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                    if (!MIRBridgeLib.getPhysicalName(mIRFeature).equals(string)) continue;
                    return mIRFeature;
                }
                MIRConnectionDataAttribute mIRConnectionDataAttribute = new MIRConnectionDataAttribute();
                mIRConnectionDataAttribute.setPosition((short)n);
                if (lookupOptions.isPositionBased()) {
                    mIRConnectionDataAttribute.setLineageOption(512);
                    string = ":" + n;
                }
                mIRConnectionDataAttribute.setName(string);
                mIRClassifier.addFeature(mIRConnectionDataAttribute);
                return mIRConnectionDataAttribute;
            }
            MIRFeature mIRFeature = this.getItem(string, lookupOptions.isQuoted(), mIRClassifier.getFeatures());
            if (mIRFeature == null) {
                if (!mIRClassifier.isInstanceOf((short)254)) {
                    return mIRFeature;
                }
                mIRFeature = new MIRConnectionDataAttribute();
                mIRFeature.setPosition((short)n);
                if (lookupOptions.isPositionBased()) {
                    mIRFeature.setLineageOption(512);
                    string = ":" + n;
                    MIRFeature mIRFeature3 = MIRBridgeLib.getFeatureByPosition(mIRClassifier, mIRFeature.getPosition());
                    if (mIRFeature3 != null) {
                        return mIRFeature3;
                    }
                }
                mIRFeature.setName(string);
                if (lookupOptions.isPositionBased()) {
                    mIRClassifier.addFeatureUniqueName(mIRFeature);
                } else {
                    mIRClassifier.addFeature(mIRFeature);
                }
                this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
            }
            return mIRFeature;
        }
    }

    private boolean isPositionBased(MIRFeature mIRFeature) {
        return (mIRFeature.getLineageOptions() & 0x200) == 512;
    }

    @Override
    public boolean isClassifierDefined(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            return false;
        }
        if (mIRClassifier.getFeatureCount() == 0 && !this.cm.getParent().isInstanceOf((short)238)) {
            return false;
        }
        if (this.cm.getDestinationClassifier() == mIRClassifier) {
            return true;
        }
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (!this.isPositionBased(mIRFeature) && !mIRFeature.hasLineageOption(256)) continue;
            return true;
        }
        MIRStructuralFeature mIRStructuralFeature = mIRClassifier instanceof MIRQueryTable ? new MIRQueryColumn() : new MIRConnectionDataAttribute();
        mIRStructuralFeature.setName("*");
        mIRStructuralFeature.setLineageOption(256);
        mIRClassifier.addFeature(mIRStructuralFeature);
        return true;
    }

    @Override
    public boolean startStatement(MIRStatementNode mIRStatementNode) {
        this.imvTreeProcessor.startStatement(mIRStatementNode);
        this.imvParsingOutputIsPositionBased = this.imvParsingInTransformation.getPositionBasedQuery();
        this.imvFlatFileSet.clear();
        return super.startStatement(mIRStatementNode);
    }

    @Override
    public boolean isStarCandidate(MIRFeature mIRFeature, boolean bl) {
        return !mIRFeature.isInstanceOf((short)84);
    }

    @Override
    public void setParsingError(String string, String string2, String string3) {
        String string4 = this.cm.getOperation();
        String string5 = this.cm.getDescription();
        MIRContent mIRContent = this.imvTransformationOwner.getRootModel().getContent();
        if (mIRContent != null && mIRContent.isInstanceOf((short)278)) {
            this.imvTreeProcessor.printFailedToParseDesignExpression(string, string2, string3, this.cm);
            return;
        }
        super.setParsingError(string, string2, string3);
        if (!string4.equals(string5) && !string5.isEmpty()) {
            ETLLIB.MSG_ORIGINAL_EXPRESSION_TEXT.log(this.imvTreeProcessor.imvLog, string5);
        }
        this.imvTreeProcessor.storeParseErrorEntry(this.imvDefaultConnectionName, this.imvStoreSystemType);
    }

    private MIRConnectionPackage getDataSetSchema(MIRExpressionNode mIRExpressionNode, StringBuilder stringBuilder, byte by) throws MIRException {
        MIRObject mIRObject;
        Object object;
        Object object2;
        int n;
        List<MIRElementNamePart> list = null;
        if (mIRExpressionNode instanceof MIRElementNode) {
            list = ((MIRElementNode)mIRExpressionNode).getElementNamePartByPosition();
        } else if (mIRExpressionNode instanceof MIROperationNode) {
            list = ((MIROperationNode)mIRExpressionNode).getElementNamePartByPosition();
        } else {
            throw new IllegalArgumentException();
        }
        String string = this.imvDefaultConnectionName;
        if (list.size() > 1) {
            int n2 = n = this.getDatabaseType() == 1 && list.get(0).getName().startsWith("@") ? 1 : 0;
            if (n != 0) {
                string = string + list.get(0).getName();
                list.remove(0);
            }
        }
        n = list.size() - 1;
        MIRDiModel mIRDiModel = (MIRDiModel)mIRExpressionNode.getRootModel();
        MIRElementNamePart mIRElementNamePart = list.get(n--);
        String string2 = MIRExpressionAnalyzerHelper.getCanonicalName(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), this.getDatabaseType());
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        if (n >= 0) {
            object2 = list.get(n--);
            string3 = ((MIRObject)object2).getName();
            bl = ((MIRElementNamePart)object2).getQuoted();
            if (n >= 0) {
                string4 = list.get(n--).getName();
            }
        }
        if (this.getDatabaseType() == 1 && this.getParserType() == 10) {
            int n3;
            n = list.size() - 1;
            if ((n3 = ((String)(object = ((MIRObject)(object2 = list.get(n--))).getName())).indexOf(64)) > 0) {
                string2 = ((String)object).substring(0, n3);
                string2 = MIRExpressionAnalyzerHelper.getCanonicalName(string2, ((MIRElementNamePart)object2).getQuoted(), this.getDatabaseType());
                string = string + ((String)object).substring(n3);
                if (n >= 0) {
                    mIRObject = list.get(n--);
                    string3 = mIRObject.getName();
                    bl = ((MIRElementNamePart)mIRObject).getQuoted();
                }
            }
        }
        object2 = this.imvTreeProcessor.overrideSchemaName(string3, this.imvParsingInTransformation);
        if (string3 != null && !string3.equals(object2) && ((NameParser.NamePart[])(object = NameParser.parse((String)object2))).length > 0) {
            string3 = ((NameParser.NamePart)object[0]).name;
            bl = ((NameParser.NamePart)object[0]).quoted;
        }
        object = new StringBuilder(string3);
        MIRStoreConnection mIRStoreConnection = this.imvModelProcessor.getStoreConnection(mIRDiModel, string4, string, (StringBuilder)object, true, by, this.imvParsingInTransformation, this.imvCallStack);
        if (!string.equals(this.imvDefaultConnectionName) && mIRStoreConnection.getSystemType().equals(this.imvModelProcessor.getDefaultRelationalStoreType())) {
            MIRStoreContent mIRStoreContent;
            mIRObject = mIRDiModel.getStoreConnection(this.imvDefaultConnectionName);
            if (mIRObject != null) {
                MIRStoreContent mIRStoreContent2 = mIRStoreContent = mIRDiModel.getContent().getClientOfConnection(this.imvDefaultConnectionName) == null ? null : mIRDiModel.getContent().getClientOfConnection(this.imvDefaultConnectionName).getSupplierStoreContent();
                if (mIRStoreConnection.getNativeType().isEmpty()) {
                    if (mIRStoreContent != null && !mIRStoreContent.getNativeType().isEmpty()) {
                        mIRStoreConnection.setNativeType(mIRStoreContent.getNativeType());
                    } else {
                        mIRStoreConnection.setNativeType(((MIRElement)mIRObject).getNativeType());
                    }
                }
                mIRStoreConnection.setSystemType(((MIRSystemPackage)mIRObject).getSystemType());
            } else {
                mIRStoreConnection.setSystemType(this.imvStoreSystemType);
                mIRStoreConnection.setStoreType((byte)0);
            }
            if (mIRDiModel.getContent().getClientOfConnection(mIRStoreConnection.getName()) != null && (mIRStoreContent = mIRDiModel.getContent().getClientOfConnection(mIRStoreConnection.getName()).getSupplierStoreContent()) != null) {
                ((MIRStoreModel)mIRStoreContent.getModel()).setSystemType(mIRStoreConnection.getSystemType());
                ((MIRStoreModel)mIRStoreContent.getModel()).setStoreType(mIRStoreConnection.getStoreType());
                if (((MIRStoreModel)mIRStoreContent.getModel()).getNativeType().isEmpty()) {
                    ((MIRStoreModel)mIRStoreContent.getModel()).setNativeType(mIRStoreConnection.getNativeType());
                }
                if (mIRStoreContent.getNativeType().isEmpty()) {
                    mIRStoreContent.setNativeType(mIRStoreConnection.getNativeType());
                }
            }
        }
        stringBuilder.replace(0, stringBuilder.length(), string2);
        return this.getConnectionPackage(mIRStoreConnection, string3, bl);
    }

    private MIRConnectionDataSet getDataSet(MIRElementNode mIRElementNode, byte by) throws MIRException {
        StringBuilder stringBuilder = new StringBuilder();
        MIRConnectionPackage mIRConnectionPackage = this.getDataSetSchema(mIRElementNode, stringBuilder, by);
        return this.getDataSet(mIRConnectionPackage, stringBuilder.toString(), false);
    }

    public MIRConnectionPackage getDataSetSchema(MIRDiModel mIRDiModel, String string, StringBuilder stringBuilder, AtomicBoolean atomicBoolean, byte by) throws MIRException {
        Object object;
        Object object2;
        NameParser.NamePart[] namePartArray = NameParser.parse(string);
        int n = namePartArray.length - 1;
        NameParser.NamePart namePart = namePartArray[n--];
        if (!atomicBoolean.get()) {
            atomicBoolean.set(namePart.quoted);
        }
        String string2 = MIRExpressionAnalyzerHelper.getCanonicalName(namePart.name, atomicBoolean.get(), this.getDatabaseType());
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        String string5 = this.imvDefaultConnectionName;
        if (n >= 0) {
            object2 = namePartArray[n--];
            string3 = ((NameParser.NamePart)object2).name;
            bl = ((NameParser.NamePart)object2).quoted;
            if (n >= 0) {
                string4 = namePartArray[n--].name;
            }
        }
        if (this.getDatabaseType() == 1) {
            n = namePartArray.length - 2;
            int n2 = namePart.name.indexOf(64);
            if (n2 > 0) {
                string5 = string5 + namePart.name.substring(n2);
                string2 = string2.substring(0, n2);
                if (n >= 0) {
                    object = namePartArray[n--];
                    string3 = object.name;
                    bl = object.quoted;
                }
            }
        }
        object2 = this.imvTreeProcessor.overrideSchemaName(string3, this.imvParsingInTransformation);
        if (string3 != null && !string3.equals(object2) && ((NameParser.NamePart[])(object = NameParser.parse((String)object2))).length > 0) {
            string3 = object[0].name;
            bl = object[0].quoted;
        }
        object = new StringBuilder(string3);
        MIRStoreConnection mIRStoreConnection = this.imvModelProcessor.getStoreConnection(mIRDiModel, string4, string5, (StringBuilder)object, true, by, this.imvParsingInTransformation, this.imvCallStack);
        stringBuilder.replace(0, stringBuilder.length(), string2);
        return this.getConnectionPackage(mIRStoreConnection, string3, bl);
    }

    public MIRConnectionDataSet getDataSet(MIRConnectionDataPackage mIRConnectionDataPackage, String string, boolean bl) {
        for (MIRConnectionDataSet mIRConnectionDataSet : this.imvParsingInTransformation.getConnectionDataSets()) {
            if (!mIRConnectionDataSet.getName().equals(string) || mIRConnectionDataSet.getConnectionDataPackage() != mIRConnectionDataPackage) continue;
            return mIRConnectionDataSet;
        }
        MIRConnectionDataSet mIRConnectionDataSet = new MIRConnectionDataSet();
        mIRConnectionDataSet.setName(string);
        mIRConnectionDataSet.setNativeType(bl ? "Stored Procedure" : "");
        this.imvParsingInTransformation.addConnectionDataSet(mIRConnectionDataSet);
        mIRConnectionDataPackage.addClassifier(mIRConnectionDataSet);
        return mIRConnectionDataSet;
    }

    private MIRConnectionPackage getConnectionPackage(MIRStoreConnection mIRStoreConnection, String string, boolean bl) {
        MIRConnectionPackage mIRConnectionPackage = mIRStoreConnection.getConnectionPackage(string = MIRExpressionAnalyzerHelper.getCanonicalName(string, bl, this.getDatabaseType()));
        if (mIRConnectionPackage == null) {
            mIRConnectionPackage = new MIRConnectionPackage();
            mIRConnectionPackage.setName(string);
            mIRStoreConnection.addConnectionPackage(mIRConnectionPackage);
        }
        return mIRConnectionPackage;
    }

    @Override
    protected MIRDataPackage getDataPackage(ParserBase.QualifiedName qualifiedName, boolean bl) {
        return null;
    }

    @Override
    public void setCollationLineageOption(MIRObject mIRObject, boolean bl) {
        super.setCollationLineageOption(mIRObject, bl);
    }

    public static class NameParser {
        private static final char[] openQuotes = new char[]{'\"', '\'', '[', '`'};
        private static final char[] closingQuotes = new char[]{'\"', '\'', ']', '`'};
        private static final char delimiter = '.';

        public static NamePart[] parse(String string) {
            if (string == null) {
                return null;
            }
            ArrayList<NamePart> arrayList = new ArrayList<NamePart>();
            int n = 0;
            char c = '\u0000';
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c2 = cArray[i];
                if (n == i) {
                    if (c2 < ' ') {
                        ++n;
                        continue;
                    }
                    c = NameParser.getClosingQuote(c2);
                    if (c > '\u0000') continue;
                }
                if (c > '\u0000' && c2 == c) {
                    c = '\u0000';
                }
                if (c2 != '.' || c != '\u0000') continue;
                arrayList.add(NameParser.getNamePart(string, n, i));
                n = i + 1;
            }
            if (n < string.length()) {
                arrayList.add(NameParser.getNamePart(string, n, string.length()));
            }
            return arrayList.toArray(new NamePart[arrayList.size()]);
        }

        private static NamePart getNamePart(String string, int n, int n2) {
            char c;
            String string2 = string.substring(n, n2);
            if ((string2 = string2.trim()).length() > 0 && (c = NameParser.getClosingQuote(string2.charAt(0))) > '\u0000' && string2.charAt(string2.length() - 1) == c && string2.length() > 1) {
                return new NamePart(string2.substring(1, string2.length() - 1), true);
            }
            return new NamePart(string2, false);
        }

        private static char getClosingQuote(char c) {
            for (int i = 0; i < openQuotes.length; ++i) {
                if (c != openQuotes[i]) continue;
                return closingQuotes[i];
            }
            return '\u0000';
        }

        public static class NamePart {
            final String name;
            final boolean quoted;

            private NamePart(String string, boolean bl) {
                this.name = string;
                this.quoted = bl;
            }

            public String toString() {
                return "NamePart [name=" + this.name + ", quoted=" + this.quoted + "]";
            }
        }
    }
}

