/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parameterProcessor;

import MITI.EtlBridgeLib.parameterProcessor.IDomain;
import MITI.EtlBridgeLib.parameterProcessor.IParameter;
import MITI.EtlBridgeLib.parameterProcessor.IParameterFile;
import MITI.EtlBridgeLib.parameterProcessor.IParameterModel;
import MITI.util.file.FileUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class JsonParameterFile
implements IParameterFile {
    private static final String VALUE = "value";
    private static final String DESCRIPTION = "description";
    private static final String PARAMETERS = "parameters";
    private static final String DOMAINS = "domains";

    @Override
    public void write(IParameterModel iParameterModel, OutputStream outputStream) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = new JsonObject();
        IDomain iDomain = iParameterModel.getDomain("");
        if (iDomain != null) {
            jsonObject = this.writeParameters(iDomain.getParameters());
            jsonObject2.add(PARAMETERS, (JsonElement)jsonObject);
        }
        jsonObject = new JsonObject();
        for (IDomain iDomain2 : iParameterModel.getDomains()) {
            if (iDomain2 == iDomain) continue;
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty(DESCRIPTION, iDomain2.getDescription());
            jsonObject.add(iDomain2.getName(), (JsonElement)jsonObject3);
            JsonObject jsonObject4 = this.writeParameters(iDomain2.getParameters());
            jsonObject3.add(PARAMETERS, (JsonElement)jsonObject4);
        }
        jsonObject2.add(DOMAINS, (JsonElement)jsonObject);
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.write(jsonObject2.toString());
        printWriter.flush();
    }

    @Override
    public void read(InputStream inputStream, IParameterModel iParameterModel) {
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(FileUtil.readContent(inputStream, StandardCharsets.UTF_8), JsonObject.class);
        if (jsonObject.get(PARAMETERS) != null && jsonObject.get(PARAMETERS).isJsonObject()) {
            for (IParameter object : this.readParameters(jsonObject.get(PARAMETERS).getAsJsonObject(), iParameterModel)) {
                iParameterModel.addParameter(object);
            }
        }
        if (jsonObject.get(DOMAINS) != null && jsonObject.get(DOMAINS).isJsonObject()) {
            for (Map.Entry entry : jsonObject.get(DOMAINS).getAsJsonObject().entrySet()) {
                if (entry.getValue() == null || !((JsonElement)entry.getValue()).isJsonObject()) continue;
                String string = (String)entry.getKey();
                JsonObject jsonObject2 = ((JsonElement)entry.getValue()).getAsJsonObject();
                IDomain iDomain = iParameterModel.getDomain(string);
                if (iDomain == null) {
                    String string2 = this.getStringValue(jsonObject2, DESCRIPTION);
                    iDomain = iParameterModel.createDomain(string, string2);
                    iParameterModel.addDomain(iDomain);
                }
                if (jsonObject2.get(PARAMETERS) == null || !jsonObject2.get(PARAMETERS).isJsonObject()) continue;
                for (IParameter iParameter : this.readParameters(jsonObject2.get(PARAMETERS).getAsJsonObject(), iParameterModel)) {
                    iDomain.addParameter(iParameter);
                }
            }
        }
    }

    private JsonObject writeParameters(Collection<IParameter> collection) {
        JsonObject jsonObject = new JsonObject();
        for (IParameter iParameter : collection) {
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty(VALUE, iParameter.getValue());
            jsonObject2.addProperty(DESCRIPTION, iParameter.getDescription());
            jsonObject.add(iParameter.getName(), (JsonElement)jsonObject2);
        }
        return jsonObject;
    }

    private Collection<IParameter> readParameters(JsonObject jsonObject, IParameterModel iParameterModel) {
        ArrayList<IParameter> arrayList = new ArrayList<IParameter>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string;
            JsonObject jsonObject2;
            String string2;
            String string3;
            IParameter iParameter;
            if (entry.getValue() == null || !((JsonElement)entry.getValue()).isJsonObject() || (iParameter = iParameterModel.createParameter(string3 = (String)entry.getKey(), string2 = this.getStringValue(jsonObject2 = ((JsonElement)entry.getValue()).getAsJsonObject(), VALUE), string = this.getStringValue(jsonObject2, DESCRIPTION))) == null) continue;
            arrayList.add(iParameter);
        }
        return arrayList;
    }

    private String getStringValue(JsonObject jsonObject, String string) {
        String string2 = "";
        if (jsonObject.get(string) != null && !jsonObject.get(string).isJsonNull()) {
            string2 = jsonObject.get(string).isJsonPrimitive() ? jsonObject.get(string).getAsString() : jsonObject.get(string).toString();
        }
        return string2;
    }
}

