/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parameterProcessor;

import MITI.EtlBridgeLib.parameterProcessor.MIRSimpleParameterFinder;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRParameterDefinition;
import MITI.sdk.MIRReaderTransformation;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRWriterTransformation;
import java.util.Arrays;
import java.util.stream.Collectors;

public class InternalParameterFinder
extends MIRSimpleParameterFinder {
    public static final String PREFIX = "[$MITI.";
    public static final String SUFIX = "]";
    public static final String NON_NAME_CHARS = ",[]/|\\\"'!`~%^&#?<>\t\n\r";
    public static final String PARAM_TYPE_CONNECTION = "Connection";
    public static final String PARAM_TYPE_QUERY = "Query";
    public static final String PARAM_TYPE_SCHEMA = "Schema";
    public static final String PARAM_TYPE_TABLE = "Table";
    public static final String INSTANCE_TYPE_READER = "Reader";
    public static final String INSTANCE_TYPE_WRITER = "Writer";

    public InternalParameterFinder() {
        super(PREFIX, SUFIX, NON_NAME_CHARS);
    }

    public InternalParameterFinder(String string) {
        super(PREFIX, SUFIX, string);
    }

    public String getInternalParameterName(MIRTransformation mIRTransformation, String string, String string2, String string3) {
        String string4 = string3;
        if (mIRTransformation != null && mIRTransformation.getDiModel() != null && string2 != null && !string2.isEmpty()) {
            if (string == null) {
                string = this.defineInstanceType(mIRTransformation);
            }
            String string5 = this.createParameterName(mIRTransformation.getName(), string, string2);
            MIRParameterDefinition mIRParameterDefinition = null;
            if (string5 != null && !string5.isEmpty()) {
                mIRParameterDefinition = this.createInternalParameter(mIRTransformation.getDiModel(), string5, string3);
            }
            if (mIRParameterDefinition != null) {
                string4 = string5;
            }
        }
        return string4;
    }

    public MIRParameterDefinition createInternalParameter(MIRDiModel mIRDiModel, String string, String string2) {
        MIRParameterDefinition mIRParameterDefinition = null;
        if (mIRDiModel != null && string != null && !string.isEmpty()) {
            if (!string.startsWith(this.imvPrefix) && !string.endsWith(this.imvSuffix)) {
                string = this.imvPrefix + string + this.imvSuffix;
            }
            if ((mIRParameterDefinition = mIRDiModel.getParameterDefinition(string)) == null) {
                mIRParameterDefinition = new MIRParameterDefinition();
                mIRParameterDefinition.setName(string);
                mIRDiModel.addParameterDefinition(mIRParameterDefinition);
            }
            mIRParameterDefinition.setValue(string2);
        }
        return mIRParameterDefinition;
    }

    public String defineInstanceType(MIRTransformation mIRTransformation) {
        String string = null;
        if (mIRTransformation instanceof MIRWriterTransformation) {
            string = INSTANCE_TYPE_WRITER;
        } else if (mIRTransformation instanceof MIRReaderTransformation) {
            string = INSTANCE_TYPE_READER;
        }
        return string;
    }

    public String createParameterName(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && string2 != null && string3 != null && (string4 = this._createParameterName(string, string2, string3)) != null && !string4.isEmpty()) {
            string4 = this.imvPrefix + string4 + this.imvSuffix;
        }
        return string4;
    }

    protected String _createParameterName(String ... stringArray) {
        return Arrays.stream(stringArray).filter(string -> string != null && !string.isEmpty()).collect(Collectors.joining("."));
    }
}

