/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parameterProcessor;

import MITI.EtlBridgeLib.parameterProcessor.IDomain;
import MITI.EtlBridgeLib.parameterProcessor.IParameter;
import MITI.EtlBridgeLib.parameterProcessor.IParameterModel;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class BasicParameterFile {
    public void write(IParameterModel iParameterModel, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        IDomain iDomain = iParameterModel.getDomain("");
        if (iDomain != null) {
            this.printParagraphDescription(printWriter, iDomain.getDescription());
            for (IParameter iNode : iDomain.getParameters()) {
                this.printParameter(iNode, printWriter, 0);
            }
        }
        for (IDomain iDomain2 : iParameterModel.getDomains()) {
            if (iDomain2 == iDomain) continue;
            String string = iDomain2.getName();
            this.printParagraphDescription(printWriter, iDomain2.getDescription());
            this.printDomainName(printWriter, string);
            for (IParameter iParameter : iDomain2.getParameters()) {
                this.printParameter(iParameter, printWriter, 1);
            }
        }
        printWriter.flush();
    }

    protected abstract void printDomainName(PrintWriter var1, String var2);

    protected abstract void printParameterName(PrintWriter var1, String var2);

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    protected void printParagraphDescription(PrintWriter printWriter, String string) {
        if (!BasicParameterFile.isNullOrEmpty(string)) {
            printWriter.println("#");
            this.printDescription(printWriter, string, 0);
            printWriter.println("#");
        }
    }

    protected static String getIndentString(int n) {
        String string = "";
        while (n-- > 0) {
            string = string + "  ";
        }
        return string;
    }

    protected void printDescription(PrintWriter printWriter, String string, int n) {
        String string2 = BasicParameterFile.getIndentString(n);
        if (!BasicParameterFile.isNullOrEmpty(string)) {
            String string3 = string2 + "#\t";
            string = string3 + string.replaceAll(System.lineSeparator(), string3 + System.lineSeparator());
            printWriter.println(string);
        }
    }

    protected void printParameter(IParameter iParameter, PrintWriter printWriter, int n) {
        String string = iParameter.getDescription();
        String string2 = BasicParameterFile.getIndentString(n);
        this.printDescription(printWriter, string, n);
        printWriter.print(string2);
        this.printParameterName(printWriter, iParameter.getName());
        printWriter.println(this.printValue(iParameter.getValue(), n));
    }

    protected abstract String printValue(String var1, int var2);
}

