/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib;

import MITI.EtlBridgeLib.DesignTreeEmbedding;
import MITI.EtlBridgeLib.HierarchicalMetadataProcessor;
import MITI.EtlBridgeLib.RuntimeCreator;
import MITI.EtlBridgeLib.TreeProcessor;
import MITI.EtlBridgeLib.parameterProcessor.MIRParameterFinder;
import MITI.EtlBridgeLib.parsing.EtlFeatureExpressionParser;
import MITI.EtlBridgeLib.parsing.EtlSqlParser;
import MITI.EtlBridgeLib.parsing.MappingExpressionParser;
import MITI.EtlBridgeLib.parsing.SqlQueryClassifierMapParser;
import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRConnectionManager;
import MITI.bridges.bridgelib.MIRConnectionSummarizer;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.bridges.bridgelib.parsers.SQLViewParser;
import MITI.bridges.javabridge.JavaBridge;
import MITI.bridges.profiles.ProfileIds;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.converter.MIRExpressionConverter;
import MITI.messages.MIREtlBridgeLib.ETLLIB;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRActivityStep;
import MITI.sdk.MIRAggregationTransformation;
import MITI.sdk.MIRCallTransformation;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRConnectedTransformation;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionElement;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRContainerStep;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDate;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDiDesignContent;
import MITI.sdk.MIRDiEmbedding;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRDiRuntimeContent;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIREmbeddedCallStep;
import MITI.sdk.MIREmbeddedCallTransformation;
import MITI.sdk.MIREmbeddedTransformation;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionTransformation;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFileDirectory;
import MITI.sdk.MIRFilteringTransformation;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRGenericConnectedTransformation;
import MITI.sdk.MIRJoinCondition;
import MITI.sdk.MIRJoinRelationship;
import MITI.sdk.MIRJoinTransformation;
import MITI.sdk.MIRLookupTransformation;
import MITI.sdk.MIRMappingModel;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRParameterContext;
import MITI.sdk.MIRParameterDefinition;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryFilter;
import MITI.sdk.MIRQueryGroupBy;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRReaderTransformation;
import MITI.sdk.MIRRepositoryObject;
import MITI.sdk.MIRSortingTransformation;
import MITI.sdk.MIRSqlQuery;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoreType;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRTransformationDataSet;
import MITI.sdk.MIRType;
import MITI.sdk.MIRUsedParameter;
import MITI.sdk.MIRWriterTransformation;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.util.ObjectCollector;
import MITI.statistics.Statistics;
import MITI.summary.EtlSummarizer;
import MITI.util.EscapedStringTokenizer;
import MITI.util.MiscParams;
import MITI.util.StringDigest;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import MITI.util.thread.SimpleTask;
import MITI.util.thread.SimpleThreadPool;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DesignTreeProcessor
extends TreeProcessor {
    public static final String UDP_TEMPORARY_SOURCE = "TemporarySource";
    public static final String UDP_HIERARCHICAL_QUERY = "HierarchicalQuery";
    public static final String UDP_FILE_OPERATION_SOURCE_PATH = "FileOperationSourcePath";
    public static final String DESIGN_TAG = "{DESIGN}";
    public static final String RUNTIME_TAG = "{RUNTIME}";
    public static final String OPTIONAL_PARAMETER_TAG = "OptionalParameter";
    public static final String VSAM_STORE = "VSAM";
    public static final String LOOKUP_SUMMARY_MAP_TAG = "Data";
    protected JavaBridge imvBridge;
    protected MIRMixManager imvMixManager;
    protected DesignTreeEmbedding imvEmbedder;
    protected int imvParserType;
    protected MIRDirectoryStructureModel imvDirectory;
    public ArrayList<MIRParameterFinder> imvParameterFinder = new ArrayList();
    protected TreeMap<MIRDiRuntimeContent, ArrayList<ParamValue>> imvRuntimeParameters = new TreeMap();
    protected boolean imvDoNativeIdClean = true;
    protected String imvMiscellaneous;
    protected Statistics etlStat = null;
    protected String etlStatFile;
    protected String imvFileDirectory;
    protected MiscParams imvArgs = null;
    long imvDsgnProcTime;
    long imvRntmProcTime;
    long imvOnRntmCompTime;
    protected boolean imvBuildUltimateSummary;
    protected boolean imvHierarchicalMetadataKeepSource;
    protected boolean imvHierarchicalMetadataDisable;
    protected boolean imvBuildRuntimeSummary;
    protected boolean imvUseMultithreading;
    protected boolean imvDisablePostProcessor;
    protected boolean imvPrintFullyQualifiedNames;
    protected boolean imvExecuteEmptyDesigns;
    private boolean imvSummaryProfile;
    protected boolean imvRemoveInput;
    protected SqlOverrideType imvSqlOverrideType = SqlOverrideType.UNDEFINED;
    private static Map<String, String> miscKeyTable = new HashMap<String, String>(){
        {
            this.put("-ppus", "-etl.summary.add.ultimate");
            this.put("-ppsp", "-etl.summary.only.ultimate");
            this.put("-pppd", "-etl.connections.add.internal.design");
            this.put("-ri", "-etl.connections.remove.input");
            this.put("-ppd", "-etl.debug.disable.processing");
            this.put("-ppmt", "-etl.debug.set.multithreaded");
            this.put("-pps", "-etl.debug.save.cache ");
            this.put("-ppl", "-etl.debug.load.cache");
            this.put("-pp_hierarchical_metadata_keep_source", "-etl.debug.retain.connections.hierarchical.original");
            this.put("-pp_hierarchical_metadata_disable", "-etl.debug.disable.connections.hierarchical.parsing");
            this.put("-fd", "-etl.debug.set.file.directory");
        }
    };
    static AtomicInteger smvCntLoadModel = new AtomicInteger();
    static AtomicInteger smvTimeLoadModel = new AtomicInteger();
    static AtomicInteger smvCntLoadModelDiDesign = new AtomicInteger();
    static AtomicInteger smvCntLoadModelDiRuntime = new AtomicInteger();
    static AtomicInteger smvCntLoadModelStore = new AtomicInteger();
    static AtomicInteger smvCntLoadModelNoCache = new AtomicInteger();
    static AtomicInteger smvTimeLoadModelNoCache = new AtomicInteger();
    static AtomicInteger smvCntSaveModel = new AtomicInteger();
    static AtomicInteger smvTimeSaveModel = new AtomicInteger();
    static AtomicInteger smvCntSaveModelDiDesign = new AtomicInteger();
    static AtomicInteger smvCntSaveModelDiRuntime = new AtomicInteger();
    static AtomicInteger smvCntSaveModelStore = new AtomicInteger();
    static AtomicInteger smvCntSavePartialModel = new AtomicInteger();
    static AtomicInteger smvTimeSavePartialModel = new AtomicInteger();
    static AtomicInteger smvStatisticRuntimeCount = new AtomicInteger();
    static AtomicInteger smvStatisticRuntimeReusedCount = new AtomicInteger();
    static AtomicInteger smvStatisticRuntimeEmbeddingCount = new AtomicInteger();
    protected ArrayList<ParseErrorEntry> imvParseErrorEntries = new ArrayList();
    protected TreeMap<String, MIRStoreModel> imvDesignConnections = new TreeMap();
    private MappingExpressionParser imvMapParser;
    protected TreeMap<String, ArrayList<String>> gsvLoggedEmptyParams = new TreeMap();
    int imvThreadsCount = 64;
    int imvExecCnt = 0;
    int lclCnt = 0;
    int lclCntCrnt = 0;

    public DesignTreeProcessor(JavaBridge javaBridge, MIRLogger mIRLogger, MIRMixManager mIRMixManager, ArrayList<MIRParameterFinder> arrayList, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, String string, SqlOverrideType sqlOverrideType) {
        this(javaBridge, mIRLogger, mIRMixManager, arrayList, n, mIRDirectoryStructureModel, string, new DesignTreeEmbedding(mIRMixManager));
        this.imvMiscellaneous = string;
        this.imvSqlOverrideType = sqlOverrideType;
        StringBuilder stringBuilder = new StringBuilder();
        if (Statistics.isStatisticsOn(this.imvMiscellaneous, stringBuilder)) {
            this.etlStatFile = stringBuilder.toString();
            String string2 = "";
            MIRMetadataOrigin mIRMetadataOrigin = mIRDirectoryStructureModel.getMetadataOrigin();
            if (mIRMetadataOrigin != null) {
                string2 = mIRMetadataOrigin.getDescription();
            }
            this.etlStat = new Statistics(string2);
        }
    }

    public DesignTreeProcessor(JavaBridge javaBridge, MIRLogger mIRLogger, MIRMixManager mIRMixManager, ArrayList<MIRParameterFinder> arrayList, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, String string) {
        this(javaBridge, mIRLogger, mIRMixManager, arrayList, n, mIRDirectoryStructureModel, string, SqlOverrideType.UNDEFINED);
        this.imvBuildRuntimeSummary = true;
    }

    public DesignTreeProcessor(JavaBridge javaBridge, MIRLogger mIRLogger, MIRMixManager mIRMixManager, ArrayList<MIRParameterFinder> arrayList, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel) {
        this(javaBridge, mIRLogger, mIRMixManager, arrayList, n, mIRDirectoryStructureModel, "", new DesignTreeEmbedding(mIRMixManager));
        this.imvBuildRuntimeSummary = true;
    }

    public DesignTreeProcessor(JavaBridge javaBridge, MIRLogger mIRLogger, MIRMixManager mIRMixManager, ArrayList<MIRParameterFinder> arrayList, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, boolean bl) {
        this(javaBridge, mIRLogger, mIRMixManager, arrayList, n, mIRDirectoryStructureModel, "", new DesignTreeEmbedding(mIRMixManager));
        this.imvPrintFullyQualifiedNames = bl;
    }

    public DesignTreeProcessor(JavaBridge javaBridge, MIRLogger mIRLogger, MIRMixManager mIRMixManager, ArrayList<MIRParameterFinder> arrayList, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, String string, DesignTreeEmbedding designTreeEmbedding) {
        super(mIRLogger);
        this.imvBridge = javaBridge;
        this.imvMiscellaneous = string;
        this.imvEmbedder = designTreeEmbedding;
        this.imvMixManager = mIRMixManager;
        this.imvParameterFinder = arrayList;
        this.imvParserType = n;
        this.imvDirectory = mIRDirectoryStructureModel;
        this.imvBuildRuntimeSummary = true;
        this.imvArgs = MiscParams.parse(string);
        this.imvBuildUltimateSummary = this.containsMiscellaneousKey("-ppus");
        this.imvHierarchicalMetadataKeepSource = this.containsMiscellaneousKey("-pp_hierarchical_metadata_keep_source");
        this.imvHierarchicalMetadataDisable = this.containsMiscellaneousKey("-pp_hierarchical_metadata_disable");
        this.imvBuildRuntimeSummary = true;
        this.imvUseMultithreading = this.containsMiscellaneousKey("-ppmt");
        this.imvSummaryProfile = this.containsMiscellaneousKey("-ppsp");
        this.imvRemoveInput = !this.containsMiscellaneousKey("-ri");
        this.imvDisablePostProcessor = this.containsMiscellaneousKey("-ppd");
        this.imvFileDirectory = this.getMiscellaneousValue("-fd");
        if (this.imvFileDirectory != null && !this.imvFileDirectory.isEmpty()) {
            this.imvFileDirectory = this.imvFileDirectory.equals("\\") ? "\\\\" : "/";
        }
        MIRConnectionManager.init(string);
    }

    private boolean containsMiscellaneousKey(String string) {
        boolean bl = this.imvArgs.contains(string);
        if (!bl && miscKeyTable.containsKey(string)) {
            bl = this.imvArgs.contains(miscKeyTable.get(string));
        }
        return bl;
    }

    private String getMiscellaneousValue(String string) {
        String string2 = this.imvArgs.getValue(string);
        if ((string2 == null || string2.isEmpty()) && miscKeyTable.containsKey(string)) {
            string2 = this.imvArgs.getValue(miscKeyTable.get(string));
        }
        return string2;
    }

    protected int calcFeaturesCount(MIRModel mIRModel) throws MIRException {
        class Counter
        implements MIR_Object.MIRTraversalOperation {
            public int imvCnt;

            Counter() {
            }

            @Override
            public boolean traverse(MIRObject mIRObject) throws MIRException {
                return true;
            }

            @Override
            public void pre_process(MIRObject mIRObject, boolean bl) {
                if (mIRObject.isInstanceOf((short)77)) {
                    ++this.imvCnt;
                }
            }

            @Override
            public void post_process(MIRObject mIRObject) {
            }
        }
        Counter counter = new Counter();
        mIRModel.depthTraversal(counter);
        return counter.imvCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIRModel loadModel(MIRContent mIRContent) throws MIRException {
        smvCntLoadModel.incrementAndGet();
        MIRContent mIRContent2 = mIRContent;
        synchronized (mIRContent2) {
            if (mIRContent.isInstanceOf((short)278)) {
                smvCntLoadModelDiDesign.incrementAndGet();
            } else if (mIRContent.isInstanceOf((short)283)) {
                smvCntLoadModelDiRuntime.incrementAndGet();
            } else if (mIRContent.isInstanceOf((short)295)) {
                smvCntLoadModelStore.incrementAndGet();
            }
            int n = (int)new Date().getTime();
            MIRModel mIRModel = this.imvMixManager.loadModel(mIRContent);
            smvTimeLoadModel.addAndGet((int)(new Date().getTime() - (long)n));
            return mIRModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIRModel loadModelNoCache(MIRContent mIRContent) throws MIRException {
        smvCntLoadModelNoCache.incrementAndGet();
        MIRContent mIRContent2 = mIRContent;
        synchronized (mIRContent2) {
            Date date = new Date();
            MIRModel mIRModel = new MIRMixManager().readFile(this.imvMixManager.getFile(mIRContent));
            smvTimeLoadModelNoCache.addAndGet((int)(new Date().getTime() - date.getTime()));
            return mIRModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveModel(MIRContent mIRContent) throws MIRException {
        smvCntSaveModel.incrementAndGet();
        MIRContent mIRContent2 = mIRContent;
        synchronized (mIRContent2) {
            if (mIRContent.isInstanceOf((short)278)) {
                smvCntSaveModelDiDesign.incrementAndGet();
            } else if (mIRContent.isInstanceOf((short)283)) {
                smvCntSaveModelDiRuntime.incrementAndGet();
            } else if (mIRContent.isInstanceOf((short)295)) {
                smvCntSaveModelStore.incrementAndGet();
            }
            Date date = new Date();
            this.imvMixManager.saveModel(mIRContent);
            smvTimeSaveModel.addAndGet((int)(new Date().getTime() - date.getTime()));
            String string = String.format("Checksums: %s[%s] %s\r\n", mIRContent.getModel().getPath(false), MIRElementType.getName(mIRContent.getModel().getElementType()), mIRContent.getModel().getContent() != null ? mIRContent.getModel().getContent().getModelKey() : "...");
            BLIB.DBG_DEBUG.log(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePartialModel(MIRContent mIRContent) throws MIRException {
        smvCntSavePartialModel.incrementAndGet();
        MIRContent mIRContent2 = mIRContent;
        synchronized (mIRContent2) {
            Date date = new Date();
            this.imvMixManager.savePartialModel(mIRContent);
            smvTimeLoadModelNoCache.addAndGet((int)(new Date().getTime() - date.getTime()));
        }
    }

    protected boolean isParametersEqual(MIRDiRuntimeContent mIRDiRuntimeContent, MIRDiRuntimeContent mIRDiRuntimeContent2, String string) {
        return true;
    }

    public SqlOverrideType getSqlOverrideType() {
        return this.imvSqlOverrideType;
    }

    public void getFunctionUpdateArguments(MIRTransformation mIRTransformation, MIROperationNode mIROperationNode, ArrayList<MIRFeature> arrayList) {
    }

    public int getQueryParameterByPosition(String string, int n) {
        if (string.equals("?")) {
            return n;
        }
        return -1;
    }

    public String getQueryParameterName(String string) {
        if (string.length() > 2 && string.startsWith("?") && string.endsWith("?")) {
            return string.substring(1, string.length() - 1);
        }
        return "";
    }

    public String getStarFeatureName(MIRClassifierMap mIRClassifierMap, String string) {
        return string;
    }

    public void customizeOperationNode(MIROperationNode mIROperationNode) {
    }

    public void storeParseErrorEntry(String string, String string2) {
        for (ParseErrorEntry parseErrorEntry : this.imvParseErrorEntries) {
            if (!parseErrorEntry.imvConnectionName.equals(string)) continue;
            ++parseErrorEntry.imvErrorCount;
            return;
        }
        ParseErrorEntry parseErrorEntry = new ParseErrorEntry();
        parseErrorEntry.imvConnectionName = string;
        parseErrorEntry.imvStoreSystemType = string2;
        parseErrorEntry.imvErrorCount = 1;
        this.imvParseErrorEntries.add(parseErrorEntry);
    }

    protected int getModelProfileId(MIRModel mIRModel) {
        return ProfileIds.META_INTEGRATION;
    }

    protected void updateNewRuntimeContent(MIRDiRuntimeContent mIRDiRuntimeContent, MIRDiEmbedding mIRDiEmbedding) {
    }

    private void loadConnectionModels(MIRFolderContent mIRFolderContent) throws MIRException {
        if (mIRFolderContent.isInstanceOf((short)295)) {
            MIRStoreContent mIRStoreContent = (MIRStoreContent)mIRFolderContent;
            MIRModel mIRModel = this.loadModel(mIRStoreContent);
            if (!mIRModel.isInstanceOf((short)2)) {
                throw new MIRException(ETLLIB.ERR_UNSUPPORTED_MODEL_TYPE.getMessage(mIRStoreContent.getPath()));
            }
            mIRModel.setSystemType(MIRConnectionManager.getInstance().getType(mIRModel.getName(), mIRModel.getSystemType()));
            MIRMetadataOrigin mIRMetadataOrigin = mIRModel.getMetadataOrigin();
            if (mIRMetadataOrigin != null && mIRMetadataOrigin.getProfileId() <= 0) {
                mIRMetadataOrigin.setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__DATA_STORE);
            }
            SQLViewParser.processSqlViewAssociations(this.imvLog, (MIRStoreModel)mIRModel, true, false, false, this.imvParserType, 0);
            if (mIRStoreContent.getConnectionOfDirectoryStructureModel() == null) {
                this.imvDesignConnections.put(mIRModel.getName(), (MIRStoreModel)mIRModel);
            }
            if (((MIRStoreModel)mIRModel).getStoreType() == 2) {
                this.processFileStoreModel((MIRStoreModel)mIRModel);
            }
        } else if (mIRFolderContent.isInstanceOf((short)157)) {
            for (MIRFolderContent mIRFolderContent2 : ((MIRFolder)mIRFolderContent).getFolderContents()) {
                this.loadConnectionModels(mIRFolderContent2);
            }
        }
    }

    public void loadConnectionModels() throws MIRException {
        for (MIRStoreContent mIRFolderContent : this.imvDirectory.getConnectionStoreContents()) {
            this.loadConnectionModels(mIRFolderContent);
        }
        for (MIRFolderContent mIRFolderContent : this.imvDirectory.getFolderContents()) {
            this.loadConnectionModels(mIRFolderContent);
        }
    }

    private void removeNotSummaryProfileContents(MIRFolderContent mIRFolderContent) throws MIRException {
        if (mIRFolderContent.isInstanceOf((short)157)) {
            MIRFolder mIRFolder = (MIRFolder)mIRFolderContent;
            for (Object object : mIRFolder.getFolderContents().toArray()) {
                MIRFolderContent mIRFolderContent2 = (MIRFolderContent)object;
                this.removeNotSummaryProfileContents(mIRFolderContent2);
            }
            if (mIRFolder.getFolderContentCount() == 0) {
                mIRFolder.delete();
            }
        } else if (mIRFolderContent.isInstanceOf((short)295)) {
            MIRStoreContent mIRStoreContent = (MIRStoreContent)mIRFolderContent;
            if (mIRStoreContent.getConnectionOfDirectoryStructureModel() == null) {
                for (Object object : mIRStoreContent.getSupplierOfConnections().toArray()) {
                    ((MIRConnection)object).delete();
                }
                mIRStoreContent.delete();
            }
        } else if (mIRFolderContent.isInstanceOf((short)278)) {
            MIRDiDesignContent mIRDiDesignContent = (MIRDiDesignContent)mIRFolderContent;
            if (mIRDiDesignContent.getDiRuntimeContentCount() == 0) {
                for (Object object : mIRDiDesignContent.getClientOfDiEmbeddings().toArray()) {
                    ((MIRDiEmbedding)object).delete();
                }
                for (Object object : mIRDiDesignContent.getSupplierOfDiEmbeddings().toArray()) {
                    ((MIRDiEmbedding)object).delete();
                }
                mIRDiDesignContent.delete();
            }
        } else if (!mIRFolderContent.isInstanceOf((short)343)) {
            mIRFolderContent.delete();
        }
    }

    protected MappingExpressionParser getMappingExpressionParser(MIRFeatureMap mIRFeatureMap) {
        if (this.imvMapParser == null) {
            this.imvMapParser = new MappingExpressionParser(this, this.imvParserType, this.getTransformationExpressionDbType(mIRFeatureMap));
        }
        return this.imvMapParser;
    }

    public void startParsingUnknownOperation(MIROperationNode mIROperationNode) {
    }

    public void stopParsingOperation(MIROperationNode mIROperationNode) {
    }

    public boolean ignoreElementNode(MIRElementNode mIRElementNode) {
        return false;
    }

    public boolean isNamespaceName(MIRElementNode mIRElementNode) {
        return false;
    }

    protected MIRParameterDefinition resolveParameter(String string, CallStackEntry callStackEntry, SearchParamScope searchParamScope) throws MIRException {
        MIRParameterDefinition mIRParameterDefinition = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        CallStackEntry callStackEntry2 = callStackEntry;
        while (callStackEntry2 != null) {
            int n4 = n3;
            MIRDiModel mIRDiModel = callStackEntry2.getModel();
            Iterator iterator = null;
            if (callStackEntry2.getEmbedding() != null) {
                iterator = callStackEntry2.getEmbedding().getParameterDiDesignContents().iterator();
                if (!iterator.hasNext()) {
                    iterator = null;
                } else {
                    bl = true;
                }
            }
            if (iterator == null) {
                iterator = ((MIRDiDesignContent)mIRDiModel.getContent()).getParameterDiDesignContents().iterator();
                bl = false;
            }
            MIRDiDesignContent mIRDiDesignContent = iterator.hasNext() ? (MIRDiDesignContent)iterator.next() : null;
            do {
                switch (searchParamScope) {
                    case SPS_DESIGN: {
                        mIRDiModel = mIRDiDesignContent != null && mIRDiDesignContent.getNativeType().contains(DESIGN_TAG) ? (MIRDiModel)this.loadModel(mIRDiDesignContent) : null;
                        break;
                    }
                    case SPS_RUNTIME: {
                        mIRDiModel = mIRDiDesignContent != null && (mIRDiDesignContent.getNativeType().contains(RUNTIME_TAG) || !mIRDiDesignContent.getNativeType().contains(RUNTIME_TAG) && !mIRDiDesignContent.getNativeType().contains(DESIGN_TAG)) ? (MIRDiModel)this.loadModel(mIRDiDesignContent) : null;
                        break;
                    }
                    case SPS_MAPPINGS: {
                        break;
                    }
                    case SPS_UNDEFINED: {
                        mIRDiModel = null;
                    }
                }
                if (mIRDiModel != null) {
                    MIRParameterDefinition mIRParameterDefinition2 = this.getParameterDefinition(string, callStackEntry, mIRDiModel);
                    if (mIRParameterDefinition2 != null && mIRParameterDefinition == null) {
                        mIRParameterDefinition = mIRParameterDefinition2;
                        n = n3;
                        n2 = n4;
                    }
                    MIRParameterContext mIRParameterContext = null;
                    for (CallStackEntry callStackEntry3 = callStackEntry2.getNext(); callStackEntry3 != null; callStackEntry3 = callStackEntry3.getNext()) {
                        String string2 = callStackEntry3.getEmbedding().getName();
                        MIRParameterContext mIRParameterContext2 = mIRParameterContext = mIRParameterContext == null ? mIRDiModel.getParameterContext(string2) : mIRParameterContext.getChildParameterContext(string2);
                        if (mIRParameterContext == null) {
                            string2 = string2 + "." + callStackEntry3.getModel().getContent().getName();
                            MIRParameterContext mIRParameterContext3 = mIRParameterContext = mIRParameterContext == null ? mIRDiModel.getParameterContext(string2) : mIRParameterContext.getChildParameterContext(string2);
                            if (mIRParameterContext != null) {
                                BLIB.DBG_DEBUG.log("Depricated context name " + string2);
                            }
                        }
                        if (mIRParameterContext == null) break;
                        mIRParameterDefinition2 = mIRParameterContext.getParameterDefinition(string);
                        if (mIRParameterDefinition2 == null || mIRParameterDefinition != null && --n4 >= n2 && (n4 != n2 || n3 <= n)) continue;
                        mIRParameterDefinition = mIRParameterDefinition2;
                        n = n3;
                        n2 = n4;
                    }
                }
                if (mIRParameterDefinition != null) break;
                MIRDiDesignContent mIRDiDesignContent2 = mIRDiDesignContent = iterator.hasNext() ? (MIRDiDesignContent)iterator.next() : null;
                if (mIRDiDesignContent != null || !bl) continue;
                iterator = ((MIRDiDesignContent)callStackEntry2.getModel().getContent()).getParameterDiDesignContents().iterator();
                mIRDiDesignContent = iterator.hasNext() ? (MIRDiDesignContent)iterator.next() : null;
                bl = false;
            } while (mIRDiDesignContent != null);
            callStackEntry2 = callStackEntry2.getPrev();
            ++n3;
        }
        return mIRParameterDefinition;
    }

    protected MIRParameterDefinition getParameterDefinition(String string, CallStackEntry callStackEntry, MIRDiModel mIRDiModel) {
        return mIRDiModel.getParameterDefinition(string);
    }

    protected MIRParameterDefinition resolveDesignParameter(MIRElement mIRElement, String string, CallStackEntry callStackEntry) throws MIRException {
        MIRParameterDefinition mIRParameterDefinition = this.resolveParameter(string, callStackEntry, SearchParamScope.SPS_DESIGN);
        if (mIRParameterDefinition == null) {
            mIRParameterDefinition = this.resolveParameter(string, callStackEntry, SearchParamScope.SPS_MAPPINGS);
        }
        return mIRParameterDefinition;
    }

    protected MIRParameterDefinition resolveRuntimeParameter(MIRElement mIRElement, String string, CallStackEntry callStackEntry) throws MIRException {
        return this.resolveParameter(string, callStackEntry, SearchParamScope.SPS_RUNTIME);
    }

    protected String getParameterValue(MIRElement mIRElement, MIRParameterDefinition mIRParameterDefinition, MIRParameterDefinition mIRParameterDefinition2) {
        return mIRParameterDefinition != null ? mIRParameterDefinition.getValue() : (mIRParameterDefinition2 != null ? mIRParameterDefinition2.getValue() : "");
    }

    protected String getUsedParameterValue(MIRElement mIRElement, MIRUsedParameter mIRUsedParameter) {
        return mIRUsedParameter.getValue();
    }

    public String getDefaultRelationalStoreType() {
        return "ODBC";
    }

    public String getRelationalStoreType(MIRConnectedTransformation mIRConnectedTransformation) {
        return this.getDefaultRelationalStoreType();
    }

    public String getRelationalStoreType(MIRSqlQuery mIRSqlQuery) {
        return this.getDefaultRelationalStoreType();
    }

    public String processFlatFileQuery(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap.getTransformation().isInstanceOf((short)220) && ((MIRConnectedTransformation)mIRClassifierMap.getTransformation()).getFlatFileDescriptor() != null) {
            return mIRClassifierMap.getOperation();
        }
        return "";
    }

    public static MIRFeatureMap linkWriterAttributes(MIRFeature mIRFeature, String string, MIRClassifierMap mIRClassifierMap) {
        MIRFeatureMap mIRFeatureMap;
        MIRConnectionDataAttribute mIRConnectionDataAttribute;
        MIRClassifier mIRClassifier = mIRFeature.getClassifier();
        MIRConnectionDataSet mIRConnectionDataSet = null;
        MIRConnectedTransformation mIRConnectedTransformation = (MIRConnectedTransformation)mIRFeature.getParent().getParent();
        if (mIRClassifierMap == null) {
            mIRClassifierMap = mIRClassifier.getSourceOfClassifierMaps().first();
        }
        if (mIRClassifierMap != null) {
            mIRConnectionDataSet = (MIRConnectionDataSet)mIRClassifierMap.getDestinationClassifier();
        }
        if (mIRConnectionDataSet == null) {
            mIRConnectionDataSet = new MIRConnectionDataSet();
            mIRConnectionDataSet.setName("Table");
            mIRConnectedTransformation.addConnectionDataSet(mIRConnectionDataSet);
        }
        if (mIRClassifierMap == null) {
            mIRClassifierMap = new MIRClassifierMap();
            mIRClassifierMap.addSourceClassifier(mIRClassifier);
            mIRConnectedTransformation.addClassifierMap(mIRClassifierMap);
        }
        if (mIRClassifierMap.getDestinationClassifier() == null) {
            mIRClassifierMap.addDestinationClassifier(mIRConnectionDataSet);
        }
        if ((mIRConnectionDataAttribute = (MIRConnectionDataAttribute)mIRConnectionDataSet.getFeature(string)) == null) {
            mIRConnectionDataAttribute = new MIRConnectionDataAttribute();
            mIRConnectionDataAttribute.setName(string);
            mIRConnectionDataSet.addFeature(mIRConnectionDataAttribute);
        }
        if ((mIRFeatureMap = mIRConnectionDataAttribute.getDestinationOfFeatureMap()) != null) {
            mIRFeatureMap.addDestinationFeature(mIRConnectionDataAttribute);
            return mIRFeatureMap;
        }
        mIRFeatureMap = new MIRFeatureMap();
        mIRFeatureMap.addSourceFeature(mIRFeature);
        mIRFeatureMap.addDestinationFeature(mIRConnectionDataAttribute);
        mIRClassifierMap.addFeatureMap(mIRFeatureMap);
        return mIRFeatureMap;
    }

    /*
     * WARNING - void declaration
     */
    public static MIRFeatureMap linkReaderAttributes(String string, String string2, MIRFeature mIRFeature) {
        void var8_11;
        MIRClassifier mIRClassifier = mIRFeature.getClassifier();
        MIRClassifierMap mIRClassifierMap = mIRClassifier.getDestinationOfClassifierMap();
        MIRConnectionDataSet mIRConnectionDataSet = null;
        MIRConnectedTransformation mIRConnectedTransformation = (MIRConnectedTransformation)mIRFeature.getParent().getParent();
        if (mIRClassifierMap != null) {
            for (MIRClassifier mIRModelObject2 : mIRClassifierMap.getSourceClassifiers()) {
                if (!mIRModelObject2.isInstanceOf((short)254) || !string.isEmpty() && !string.equals(mIRModelObject2.getName())) continue;
                mIRConnectionDataSet = (MIRConnectionDataSet)mIRModelObject2;
                break;
            }
        }
        if (mIRConnectionDataSet == null) {
            mIRConnectionDataSet = new MIRConnectionDataSet();
            mIRConnectionDataSet.setName(string.isEmpty() ? "Table" : string);
            mIRConnectedTransformation.addConnectionDataSet(mIRConnectionDataSet);
        }
        if (mIRClassifierMap == null) {
            mIRClassifierMap = new MIRClassifierMap();
            mIRClassifierMap.addDestinationClassifier(mIRClassifier);
            mIRConnectedTransformation.addClassifierMap(mIRClassifierMap);
        }
        if (!mIRClassifierMap.containsSourceClassifier(mIRConnectionDataSet)) {
            mIRClassifierMap.addSourceClassifier(mIRConnectionDataSet);
        }
        Object object = mIRFeature.getDestinationOfFeatureMap();
        MIRConnectionDataAttribute mIRConnectionDataAttribute = (MIRConnectionDataAttribute)mIRConnectionDataSet.getFeature(string2);
        if (mIRConnectionDataAttribute == null) {
            MIRConnectionDataAttribute mIRConnectionDataAttribute2 = new MIRConnectionDataAttribute();
            mIRConnectionDataAttribute2.setName(string2);
            mIRConnectionDataSet.addFeature(mIRConnectionDataAttribute2);
        }
        if (object != null) {
            ((MIRFeatureMap)object).addSourceFeature((MIRFeature)var8_11);
            return object;
        }
        object = new MIRFeatureMap();
        ((MIRFeatureMap)object).addSourceFeature((MIRFeature)var8_11);
        ((MIRFeatureMap)object).addDestinationFeature(mIRFeature);
        mIRClassifierMap.addFeatureMap((MIRFeatureMap)object);
        return object;
    }

    public static MIRFeatureMap linkReaderAttributes(String string, MIRFeature mIRFeature) {
        return DesignTreeProcessor.linkReaderAttributes("", string, mIRFeature);
    }

    public static MIRFeatureMap linkAttributes(MIRFeature mIRFeature, MIRFeature mIRFeature2, MIRClassifierMap mIRClassifierMap) {
        Object object;
        if (mIRClassifierMap == null) {
            object = mIRFeature.getClassifier();
            MIRClassifier mIRElement = mIRFeature2.getClassifier();
            mIRClassifierMap = mIRElement.getDestinationOfClassifierMap();
            if (mIRClassifierMap != null) {
                if (!mIRClassifierMap.containsSourceClassifier((MIRClassifier)object)) {
                    mIRClassifierMap.addSourceClassifier((MIRClassifier)object);
                }
            } else {
                mIRClassifierMap = new MIRClassifierMap();
                mIRClassifierMap.addSourceClassifier((MIRClassifier)object);
                mIRClassifierMap.addDestinationClassifier(mIRElement);
                MIRObject mIRObject = ((MIRClassifier)object).getParent();
                MIRObject mIRObject2 = mIRElement.getParent();
                if (mIRObject.isInstanceOf((short)79) && mIRObject2.isInstanceOf((short)79)) {
                    if (mIRObject == mIRObject2) {
                        ((MIRTransformation)mIRObject).addClassifierMap(mIRClassifierMap);
                    } else {
                        ((MIRTransformation)mIRObject).getDiModel().addClassifierMap(mIRClassifierMap);
                    }
                } else if (mIRObject.isInstanceOf((short)258)) {
                    ((MIRDiModel)mIRObject).addClassifierMap(mIRClassifierMap);
                } else if (mIRObject2.isInstanceOf((short)258)) {
                    ((MIRDiModel)mIRObject2).addClassifierMap(mIRClassifierMap);
                } else assert (false);
            }
        }
        for (MIRFeatureMap mIRFeatureMap : mIRFeature2.getDestinationOfFeatureMaps()) {
            if (mIRFeatureMap.getClassifierMap() != mIRClassifierMap) continue;
            if (mIRFeatureMap.containsSourceFeature(mIRFeature)) {
                return mIRFeatureMap;
            }
            mIRFeatureMap.addSourceFeature(mIRFeature);
            return mIRFeatureMap;
        }
        object = new MIRFeatureMap();
        ((MIRFeatureMap)object).addSourceFeature(mIRFeature);
        ((MIRFeatureMap)object).addDestinationFeature(mIRFeature2);
        mIRClassifierMap.addFeatureMap((MIRFeatureMap)object);
        return object;
    }

    protected static void processUsage(MIRMappingModel mIRMappingModel) throws MIRException {
        MIRDirectoryStructureModel mIRDirectoryStructureModel = mIRMappingModel.getContent() == null ? null : (MIRDirectoryStructureModel)mIRMappingModel.getContent().getRootModel();
        for (MIRStoreConnection mIRStoreConnection : mIRMappingModel.getStoreConnections()) {
            int n = EtlSummarizer.detectUsage(mIRStoreConnection);
            if (n == -1 && (mIRDirectoryStructureModel == null || mIRDirectoryStructureModel.getConnectionStoreContent(mIRStoreConnection.getName()) != null)) {
                BLIB.DBG_DEBUG.log(String.format("Usage detection failed for connection '%s'", mIRStoreConnection.getPath(false)));
                n = 2;
            }
            EtlSummarizer.ensureUsage(mIRStoreConnection, (byte)n);
        }
    }

    public void onRuntimeModelCreated(MIRModel mIRModel, CallStackEntry callStackEntry) {
    }

    public void onRuntimeCompleted(MIRModel mIRModel, CallStackEntry callStackEntry) {
    }

    public void onRuntimeSummarized(MIRModel mIRModel, CallStackEntry callStackEntry) {
    }

    public void startStatement(MIRStatementNode mIRStatementNode) {
    }

    public String overrideSchemaName(String string, MIRConnectedTransformation mIRConnectedTransformation) {
        return string;
    }

    public HierarchicalMetadataProcessor createHierarchicalMetadataProcessor() {
        return null;
    }

    protected static void logUndefinedParameters(MIRDiModel mIRDiModel) {
        boolean bl = true;
        for (MIRUsedParameter mIRUsedParameter : mIRDiModel.getUsedParameters()) {
            if (mIRUsedParameter.getResolved()) continue;
            if (bl) {
                bl = false;
                String string = "";
                for (MIRObject mIRObject = mIRDiModel.getContent(); mIRObject != null && !mIRObject.isInstanceOf((short)286); mIRObject = ((MIR_Object)mIRObject).getParent()) {
                    string = mIRObject.getName() + (string.isEmpty() ? "" : "/") + string;
                }
                ETLLIB.MSG_UNDEFINED_VARIABLES.log(MIRLogger.getLogger(), string);
            }
            ETLLIB.MSG_UNDEFINED_VARIABLE.log(MIRLogger.getLogger(), mIRUsedParameter.getName());
        }
    }

    public int getTransformationExpressionDbType(MIRFeatureMap mIRFeatureMap) {
        return 0;
    }

    public int getTransformationExpressionDbType(MIRClassifierMap mIRClassifierMap) {
        return 0;
    }

    private void pickupFeaturesForCleanUp(MIRClassifier mIRClassifier, ArrayList<MIRFeature> arrayList, ArrayList<MIRClassifier> arrayList2) {
        boolean bl = false;
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (!mIRFeature.isInstanceOf((short)337)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            arrayList2.add(mIRClassifier);
            for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                arrayList.add(mIRFeature);
            }
        }
    }

    void cleanUpUnusedFeatures(MIRMappingModel mIRMappingModel) {
        if (mIRMappingModel != null) {
            Object object;
            ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
            ArrayList<MIRClassifier> arrayList2 = new ArrayList<MIRClassifier>();
            ArrayList<MIRConnectionElement> arrayList3 = new ArrayList<MIRConnectionElement>();
            ArrayList<MIRConnectionPackage> arrayList4 = new ArrayList<MIRConnectionPackage>();
            ArrayList<MIRStoreConnection> arrayList5 = new ArrayList<MIRStoreConnection>();
            for (MIRStoreConnection mIRElement : mIRMappingModel.getStoreConnections()) {
                arrayList5.add(mIRElement);
                for (MIRConnectionElement mIRConnectionElement : mIRElement.getConnectionElements()) {
                    arrayList3.add(mIRConnectionElement);
                    for (MIRElement mIRElement2 : mIRConnectionElement.getDefinedElements()) {
                        if (!mIRElement2.isInstanceOf((short)75)) continue;
                        this.pickupFeaturesForCleanUp((MIRClassifier)mIRElement2, arrayList, arrayList2);
                    }
                }
                object = mIRElement.getConnectionPackages().iterator();
                while (object.hasNext()) {
                    MIRConnectionPackage mIRConnectionPackage = (MIRConnectionPackage)object.next();
                    arrayList4.add(mIRConnectionPackage);
                    for (MIRClassifier mIRClassifier : mIRConnectionPackage.getClassifiers()) {
                        this.pickupFeaturesForCleanUp(mIRClassifier, arrayList, arrayList2);
                    }
                    for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionPackage.getImportedNamespaceElements()) {
                        if (!mIRNamespaceElement.isInstanceOf((short)75)) continue;
                        this.pickupFeaturesForCleanUp((MIRClassifier)mIRNamespaceElement, arrayList, arrayList2);
                    }
                    for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionPackage.getNamespaceElements()) {
                        if (!mIRNamespaceElement.isInstanceOf((short)75)) continue;
                        this.pickupFeaturesForCleanUp((MIRClassifier)mIRNamespaceElement, arrayList, arrayList2);
                    }
                }
            }
            for (MIRFeature mIRFeature : arrayList) {
                MIRFeatureMap mIRFeatureMap;
                if (!mIRFeature.isInstanceOf((short)242) || ((MIRFeature)(object = (MIRQueryColumn)mIRFeature)).getSourceOfFeatureMapCount() != 0 || ((MIRFeature)object).getControlOfFeatureMapCount() != 0 || ((MIRQueryColumn)object).getQueryGroupBy() != null || ((MIRQueryColumn)object).getQuerySortItemCount() != 0 || (mIRFeatureMap = ((MIRFeature)object).getDestinationOfFeatureMap()) != null && (mIRFeatureMap.getSourceFeatureCount() != 0 || !mIRFeatureMap.getOperation().isEmpty())) continue;
                if (mIRFeatureMap != null) {
                    mIRFeatureMap.delete();
                }
                ((MIRFeature)object).removeClassifier();
                ((MIR_Object)object).delete();
            }
            for (MIRClassifier mIRClassifier : arrayList2) {
                if (mIRClassifier.getFeatureCount() != 0) continue;
                object = mIRClassifier.getDestinationOfClassifierMap();
                if (object != null) {
                    ((MIR_Object)object).delete();
                }
                mIRClassifier.removeDefinedByConnectionElement();
                mIRClassifier.delete();
            }
            for (MIRConnectionElement mIRConnectionElement : arrayList3) {
                if (mIRConnectionElement.getDefinedElementCount() != 0) continue;
                mIRConnectionElement.removeStoreConnection();
                mIRConnectionElement.delete();
            }
            for (MIRConnectionPackage mIRConnectionPackage : arrayList4) {
                if (mIRConnectionPackage.getClassifierCount() != 0 || mIRConnectionPackage.getImportedNamespaceElementCount() != 0 || mIRConnectionPackage.getNamespaceElementCount() != 0) continue;
                mIRConnectionPackage.removeStoreConnection();
                mIRConnectionPackage.delete();
            }
            for (MIRStoreConnection mIRStoreConnection : arrayList5) {
                MIRConnection mIRConnection;
                if (mIRStoreConnection.getConnectionElementCount() != 0 || mIRStoreConnection.getConnectionClassifierCount() != 0 || mIRStoreConnection.getConnectionPackageCount() != 0) continue;
                object = mIRMappingModel.getContent();
                if (object != null && (mIRConnection = ((MIRContent)object).getClientOfConnection(mIRStoreConnection.getName())) != null) {
                    mIRConnection.delete();
                }
                mIRStoreConnection.removeModel();
                mIRStoreConnection.delete();
            }
        }
    }

    protected static void setLastModificationTime(MIRDirectoryStructureModel mIRDirectoryStructureModel, MIRRepositoryObject mIRRepositoryObject, MIRRepositoryObject mIRRepositoryObject2) {
        MIRDate mIRDate = mIRRepositoryObject2.getLastModificationTime();
        if (mIRDate != null && !mIRDate.isNull()) {
            MIRDate mIRDate2;
            if (mIRRepositoryObject != null && (mIRDate2 = mIRRepositoryObject.getLastModificationTime()) != null && !mIRDate2.isNull() && mIRRepositoryObject2.getLastModificationTime().compareTo(mIRDate) < 0) {
                mIRRepositoryObject2.setLastModificationTime(mIRDate2);
            }
        } else {
            MIRDate mIRDate3;
            MIRDate mIRDate4 = mIRDate3 = mIRRepositoryObject != null ? mIRRepositoryObject.getLastModificationTime() : null;
            if (mIRDate3 != null && !mIRDate3.isNull()) {
                mIRRepositoryObject2.setLastModificationTime(mIRDate3);
            } else {
                MIRObject mIRObject = mIRRepositoryObject2.getParent();
                if (mIRObject != null && mIRObject.isInstanceOf((short)58)) {
                    MIRRepositoryObject mIRRepositoryObject3 = (MIRRepositoryObject)mIRObject;
                    mIRDate3 = mIRRepositoryObject3.getLastModificationTime();
                    if (mIRDate3 == null || mIRDate3.isNull()) {
                        DesignTreeProcessor.setLastModificationTime(mIRDirectoryStructureModel, null, mIRRepositoryObject3);
                    }
                    if ((mIRDate3 = mIRRepositoryObject3.getLastModificationTime()) != null && !mIRDate3.isNull()) {
                        mIRRepositoryObject2.setLastModificationTime(mIRRepositoryObject3.getLastModificationTime());
                    }
                }
                if (mIRDirectoryStructureModel.getModificationTime() != null) {
                    mIRRepositoryObject2.setLastModificationTime(new MIRDate(0L));
                }
            }
        }
    }

    private boolean isNamespaceElementEmpty(MIRNamespaceElement mIRNamespaceElement) {
        boolean bl = true;
        if (mIRNamespaceElement.isInstanceOf((short)207)) {
            MIRNamespaceElement mIRNamespaceElement2;
            Iterator iterator = ((MIRFileDirectory)mIRNamespaceElement).getNamespaceElements().iterator();
            while (iterator.hasNext() && (bl = this.isNamespaceElementEmpty(mIRNamespaceElement2 = (MIRNamespaceElement)iterator.next()))) {
            }
        } else {
            bl = mIRNamespaceElement.isInstanceOf((short)75) ? ((MIRClassifier)mIRNamespaceElement).getFeatureCount() == 0 : !mIRNamespaceElement.isInstanceOf((short)67);
        }
        return bl;
    }

    MIRFileDirectory getFileDirectory(MIRStoreModel mIRStoreModel, String string) {
        String[] stringArray;
        MIRFileDirectory mIRFileDirectory = null;
        if (!string.isEmpty()) {
            for (String string2 : stringArray = string.split(this.imvFileDirectory == null ? "[/\\\\]" : this.imvFileDirectory)) {
                MIRNamespaceElement mIRNamespaceElement;
                if (string2.isEmpty() || string2.contains(":")) continue;
                MIRNamespaceElement mIRNamespaceElement2 = mIRNamespaceElement = mIRFileDirectory == null ? mIRStoreModel.getDataPackage(string2) : mIRFileDirectory.getNamespaceElement(string2);
                if (mIRNamespaceElement == null) {
                    if (mIRFileDirectory == null && string2.endsWith(":")) {
                        string2 = string2 + "\\";
                    }
                    MIRFileDirectory mIRFileDirectory2 = new MIRFileDirectory();
                    mIRFileDirectory2.setName(string2);
                    if (mIRFileDirectory == null) {
                        mIRStoreModel.addDataPackage(mIRFileDirectory2);
                    } else {
                        mIRFileDirectory.addNamespaceElement(mIRFileDirectory2);
                    }
                    mIRFileDirectory = mIRFileDirectory2;
                    continue;
                }
                if (!mIRNamespaceElement.isInstanceOf((short)207)) continue;
                mIRFileDirectory = (MIRFileDirectory)mIRNamespaceElement;
            }
        }
        if (mIRFileDirectory == null) {
            stringArray = mIRStoreModel.getDataPackage("");
            if (stringArray != null && stringArray.isInstanceOf((short)207)) {
                mIRFileDirectory = (MIRFileDirectory)stringArray;
            }
            if (mIRFileDirectory == null) {
                mIRFileDirectory = new MIRFileDirectory();
                mIRStoreModel.addDataPackageUniqueName(mIRFileDirectory);
            }
        }
        return mIRFileDirectory;
    }

    protected void processFileStoreModel(MIRStoreModel mIRStoreModel) throws MIRException {
        if (this.imvFileDirectory != null && this.imvFileDirectory.isEmpty()) {
            return;
        }
        for (Object object : mIRStoreModel.getDataPackages().toArray()) {
            MIRDataPackage mIRDataPackage = (MIRDataPackage)object;
            if (mIRDataPackage instanceof MIRFileDirectory) continue;
            mIRDataPackage.removeStoreModel();
            for (Object object2 : mIRDataPackage.getNamespaceElements().toArray()) {
                boolean bl;
                if (!((MIRNamespaceElement)object2).isInstanceOf((short)75)) continue;
                Object object3 = (MIRClassifier)object2;
                boolean bl2 = bl = ((MIRObject)object3).getName().contains("\\") || ((MIRObject)object3).getName().contains("/");
                if (!bl) continue;
                int n = Math.max(((MIRObject)object3).getName().lastIndexOf("/"), ((MIRObject)object3).getName().lastIndexOf("\\"));
                String string = ((MIRObject)object3).getName().substring(n + 1);
                MIRFileDirectory mIRFileDirectory = this.getFileDirectory(mIRStoreModel, ((MIRObject)object3).getName().substring(0, n));
                if (mIRFileDirectory == null) continue;
                ((MIRNamespaceElement)object3).removeNamespace();
                ((MIRObject)object3).setName(string);
                mIRFileDirectory.addNamespaceElement((MIRNamespaceElement)object3);
            }
            MIRFileDirectory mIRFileDirectory = this.getFileDirectory(mIRStoreModel, mIRDataPackage.getName());
            if (mIRFileDirectory != mIRDataPackage) {
                for (Object object3 : mIRDataPackage.getNamespaceElements().toArray()) {
                    if (!((MIRNamespaceElement)object3).isInstanceOf((short)75)) continue;
                    MIRClassifier mIRClassifier = (MIRClassifier)object3;
                    mIRClassifier.removeNamespace();
                    mIRFileDirectory.addNamespaceElementUniqueName(mIRClassifier);
                }
            }
            mIRDataPackage.delete();
        }
    }

    protected boolean processStoreModel(MIRStoreModel mIRStoreModel) throws MIRException {
        boolean bl = true;
        ArrayList<MIRDataPackage> arrayList = new ArrayList<MIRDataPackage>();
        for (MIRDataPackage object : mIRStoreModel.getDataPackages()) {
            for (Object object2 : object.getNamespaceElements().toArray()) {
                if (!this.isNamespaceElementEmpty((MIRNamespaceElement)object2)) continue;
                object.removeNamespaceElement((MIRNamespaceElement)object2);
            }
            for (Object object2 : object.getNamespaceElements().toArray()) {
                if (!this.isNamespaceElementEmpty((MIRNamespaceElement)object2)) continue;
                object.removeImportedNamespaceElement((MIRNamespaceElement)object2);
            }
        }
        for (MIRDataPackage mIRDataPackage : mIRStoreModel.getDataPackages()) {
            if (mIRDataPackage.getNamespaceElementCount() != 0 || mIRDataPackage.getImportedNamespaceElementCount() != 0) continue;
            arrayList.add(mIRDataPackage);
        }
        for (MIRDataPackage mIRDataPackage : arrayList) {
            mIRStoreModel.removeDataPackage(mIRDataPackage);
            mIRDataPackage.delete();
        }
        if (mIRStoreModel.getDataPackageCount() != 0 || mIRStoreModel.getDesignPackageCount() != 0) {
            MIRTypeLib.factorizeTypes(mIRStoreModel);
            MIRMetadataOrigin mIRMetadataOrigin = mIRStoreModel.getMetadataOrigin();
            if (mIRMetadataOrigin != null && (mIRMetadataOrigin.getProfileId() <= 0 || this.isSummaryProfile())) {
                mIRMetadataOrigin.setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__DATA_STORE);
            }
            if (this.etlStat != null) {
                switch (mIRStoreModel.getStoreType()) {
                    case 0: {
                        ObjectCollector objectCollector = new ObjectCollector(new short[]{13});
                        Object object = new ObjectCollector(new short[]{77});
                        objectCollector.collect(mIRStoreModel);
                        ((ObjectCollector)object).collect(mIRStoreModel);
                        this.etlStat.incModelCounter("", mIRStoreModel.getName(), (short)5, objectCollector.getObjects().size());
                        this.etlStat.incModelCounter("", mIRStoreModel.getName(), (short)4, ((ObjectCollector)object).getObjects().size());
                        break;
                    }
                    case 2: {
                        ObjectCollector objectCollector = new ObjectCollector(new short[]{209});
                        Object object = new ObjectCollector(new short[]{77});
                        objectCollector.collect(mIRStoreModel);
                        ((ObjectCollector)object).collect(mIRStoreModel);
                        this.etlStat.incModelCounter("", mIRStoreModel.getName(), (short)5, objectCollector.getObjects().size());
                        this.etlStat.incModelCounter("", mIRStoreModel.getName(), (short)4, ((ObjectCollector)object).getObjects().size());
                        break;
                    }
                }
            }
            bl = false;
        }
        return bl;
    }

    protected DesignProcessor createDesignProcessor(DesignTreeProcessor designTreeProcessor, DesignTreeEmbedding designTreeEmbedding, TreeMap<MIRDiRuntimeContent, ArrayList<ParamValue>> treeMap, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, TreeMap<String, MIRStoreModel> treeMap2, MIRDiModel mIRDiModel, CallStackEntry callStackEntry) {
        return new DesignProcessor(designTreeProcessor, designTreeEmbedding, treeMap, n, mIRDirectoryStructureModel, treeMap2, mIRDiModel, callStackEntry);
    }

    protected RuntimeProcessor createRuntimeProcessor(DesignTreeProcessor designTreeProcessor, DesignTreeEmbedding designTreeEmbedding, TreeMap<MIRDiRuntimeContent, ArrayList<ParamValue>> treeMap, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, TreeMap<String, MIRStoreModel> treeMap2, MIRDiDesignContent mIRDiDesignContent, CallStackEntry callStackEntry) {
        return new RuntimeProcessor(designTreeProcessor, designTreeEmbedding, treeMap, n, mIRDirectoryStructureModel, treeMap2, mIRDiDesignContent, callStackEntry);
    }

    private void processRuntimes() throws MIRException {
        Date date = new Date();
        this.lclCnt = 0;
        this.lclCntCrnt = 0;
        ObjectCollector objectCollector = new ObjectCollector(new short[]{278});
        objectCollector.collect(this.imvDirectory);
        SimpleThreadPool simpleThreadPool = this.imvUseMultithreading ? new SimpleThreadPool("Post-processor thread", this.imvThreadsCount) : null;
        ArrayList<Future<Boolean>> arrayList = new ArrayList<Future<Boolean>>();
        for (MIRDiDesignContent mIRDiDesignContent : DesignTreeProcessor.sortObjectsByPath(objectCollector.getObjects())) {
            DesignTreeProcessor.setLastModificationTime(this.imvDirectory, null, mIRDiDesignContent);
            if (!mIRDiDesignContent.getExecutable()) continue;
            ++this.imvExecCnt;
            MIRDiModel mIRDiModel = (MIRDiModel)this.loadModel(mIRDiDesignContent);
            RuntimeProcessor object = this.createRuntimeProcessor(this, this.imvEmbedder, this.imvRuntimeParameters, this.imvParserType, this.imvDirectory, this.imvDesignConnections, mIRDiDesignContent, new CallStackEntry(mIRDiModel, null, null));
            if (simpleThreadPool != null) {
                arrayList.add(simpleThreadPool.submit(object));
            } else {
                object.internalCall();
            }
            ++this.lclCnt;
            ++this.lclCntCrnt;
            if (this.lclCnt < 100) continue;
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("[" + Thread.currentThread().getName() + "]\t\tRuntime = " + (new Date().getTime() - date.getTime()) + "sek #" + this.lclCntCrnt + " of " + objectCollector.getObjects().size() + " - " + mIRDiDesignContent.getPath());
            }
            date = new Date();
            this.lclCnt = 0;
        }
        if (simpleThreadPool != null) {
            simpleThreadPool.shutdown();
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("service.shutdown()!");
            }
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("lclFutures.size()=" + arrayList.size());
            }
            try {
                Date date2 = new Date();
                while (!simpleThreadPool.awaitTermination(1L, TimeUnit.MINUTES)) {
                    int n = 0;
                    for (Future future : arrayList) {
                        if (future.isDone()) continue;
                        ++n;
                    }
                    if (!this.imvUseMultithreading) continue;
                    BLIB.DBG_DEBUG.log("Processed: " + (arrayList.size() - n) + " of " + arrayList.size() + " Pending: " + n + " Time: " + (new Date().getTime() - date2.getTime()) / 60000L + "min./" + (new Date().getTime() - date2.getTime()) + "sec.");
                }
                if (this.imvUseMultithreading) {
                    BLIB.DBG_DEBUG.log("Runtime threads completed");
                }
            }
            catch (InterruptedException interruptedException) {
                BLIB.DBG_DEBUG.log(interruptedException, "Fail to process runtime");
            }
        }
    }

    private void processDesigns() throws MIRException {
        Date date = new Date();
        this.lclCnt = 0;
        this.lclCntCrnt = 0;
        ObjectCollector objectCollector = new ObjectCollector(new short[]{278});
        objectCollector.collect(this.imvDirectory);
        SimpleThreadPool simpleThreadPool = this.imvUseMultithreading ? new SimpleThreadPool("Post-processor thread", this.imvThreadsCount) : null;
        for (MIRDiDesignContent mIRDiDesignContent : objectCollector.getObjects()) {
            ETLLIB.MSG_PROCESS_DESIGN_TASK.log(mIRDiDesignContent.getPath());
            MIRDiModel mIRDiModel = (MIRDiModel)this.loadModel(mIRDiDesignContent);
            DesignProcessor designProcessor = this.createDesignProcessor(this, this.imvEmbedder, this.imvRuntimeParameters, this.imvParserType, this.imvDirectory, this.imvDesignConnections, mIRDiModel, new CallStackEntry(mIRDiModel, null, null));
            if (simpleThreadPool != null) {
                simpleThreadPool.submit(designProcessor);
            } else {
                designProcessor.internalCall();
            }
            ++this.lclCnt;
            ++this.lclCntCrnt;
            if (this.lclCnt < 100) continue;
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("\t\tDesign = " + (new Date().getTime() - date.getTime()) + "sek #" + this.lclCntCrnt + " of " + objectCollector.getObjects().size() + " - " + mIRDiDesignContent.getPath());
            }
            date = new Date();
            this.lclCnt = 0;
        }
        if (simpleThreadPool != null) {
            simpleThreadPool.shutdown();
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("!!!!!!!!!!!!!!!!service.shutdown()!!!!!!!!!!!!!!!!!!!!!");
            }
            try {
                boolean bl = simpleThreadPool.awaitTermination(10L, TimeUnit.MINUTES);
                if (this.imvUseMultithreading) {
                    BLIB.DBG_DEBUG.log("awaitTermination = " + bl);
                }
            }
            catch (InterruptedException interruptedException) {
                BLIB.DBG_DEBUG.log(interruptedException, "Fail to process design");
            }
        }
    }

    public static void mergeTransformationDataSet(MIRTransformationDataSet mIRTransformationDataSet) {
        MIRClassifier mIRClassifier;
        MIRElement mIRElement;
        MIRElement mIRElement2;
        if (mIRTransformationDataSet == null) {
            return;
        }
        MIRClassifierMap mIRClassifierMap = mIRTransformationDataSet.getDestinationOfClassifierMap();
        if (mIRClassifierMap == null) {
            return;
        }
        if (!mIRClassifierMap.getOperation().isEmpty() && mIRTransformationDataSet.getSourceOfClassifierMapCount() > 1) {
            return;
        }
        if (mIRTransformationDataSet.isInstanceOf((short)243) && (((MIRQueryTable)mIRTransformationDataSet).getLeftOfQueryJoin() != null || ((MIRQueryTable)mIRTransformationDataSet).getRightOfQueryJoin() != null)) {
            return;
        }
        if (mIRClassifierMap.getSourceClassifierCount() > 1 && (mIRTransformationDataSet.getLeftOfJoinRelationshipCount() > 0 || mIRTransformationDataSet.getRightOfJoinRelationshipCount() > 0)) {
            return;
        }
        if (mIRTransformationDataSet.getFeatureCount() == 0) {
            return;
        }
        for (MIRFeature mIRFeature : mIRTransformationDataSet.getFeatures()) {
            MIRClassifier object5;
            MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
            Object object2 = null;
            if (mIRTransformationDataSet.getSourceOfClassifierMapCount() == 1 && (object5 = mIRTransformationDataSet.getSourceOfClassifierMaps().first().getDestinationClassifier()) != null) {
                object2 = object5.getDestinationOfClassifierMap();
            }
            if (mIRFeature.getSourceOfFeatureMapCount() != 0 || mIRFeatureMap == null || object2 == null || ((MIRClassifierMap)object2).getParent() != mIRTransformationDataSet.getParent() || mIRFeature.getClassifier().getElementType() == ((MIRClassifierMap)object2).getDestinationClassifier().getElementType()) continue;
            return;
        }
        for (Object object2 : mIRTransformationDataSet.getFeatures().toArray()) {
            MIRFeature mIRFeature = (MIRFeature)object2;
            if (mIRFeature.getDestinationOfFeatureMapCount() > 1) {
                return;
            }
            mIRElement2 = mIRFeature.getDestinationOfFeatureMap();
            mIRElement = null;
            if (mIRElement2 == null) continue;
            if (!((MIRFeatureMap)mIRElement2).getOperation().isEmpty()) {
                for (MIRFeatureMap mIRFeatureMap : mIRFeature.getSourceOfFeatureMaps()) {
                    if (mIRFeatureMap.getOperation().isEmpty()) continue;
                    return;
                }
            }
            if (((MIRFeatureMap)mIRElement2).getSourceFeatureCount() > 1 && mIRFeature.getSourceOfFeatureMapCount() != 0) {
                return;
            }
            for (MIRFeatureMap mIRFeatureMap : mIRFeature.getSourceOfFeatureMaps()) {
                if (((MIRFeatureMap)mIRElement2).getSourceFeatureCount() != 1) {
                    return;
                }
                mIRElement = ((MIRFeatureMap)mIRElement2).getSourceFeatures().first();
                if (mIRFeatureMap.getOperation().isEmpty() || mIRElement.getName().equals(mIRFeature.getName())) continue;
                return;
            }
        }
        Object object4 = null;
        if (mIRTransformationDataSet.getSourceOfClassifierMapCount() == 1 && (mIRClassifier = mIRTransformationDataSet.getSourceOfClassifierMaps().first().getDestinationClassifier()) != null && mIRClassifier.getDestinationOfClassifierMap() != null) {
            object4 = mIRClassifier.getDestinationOfClassifierMap();
        }
        for (Object object : mIRTransformationDataSet.getFeatures().toArray()) {
            int n;
            MIRObject mIRObject;
            mIRElement2 = (MIRFeature)object;
            mIRElement = ((MIRFeature)mIRElement2).getDestinationOfFeatureMap();
            Object object2 = null;
            if (mIRElement != null) {
                object2 = ((MIRFeatureMap)mIRElement).getSourceFeatures().first();
            }
            if (object2 != null && mIRElement != null) {
                for (MIRElementNamePart mIRElementNamePart : mIRElement2.getReferencedByElementNameParts()) {
                    ((MIRElement)object2).addReferencedByElementNamePart(mIRElementNamePart);
                }
                for (Object object3 : ((MIRFeature)mIRElement2).getLeftOfJoinConditions().toArray()) {
                    mIRObject = (MIRJoinCondition)object3;
                    ((MIRJoinCondition)mIRObject).removeLeftFeature();
                    ((MIRJoinCondition)mIRObject).addLeftFeature((MIRFeature)object2);
                    if (((MIRJoinCondition)mIRObject).getJoinRelationship().getLeftClassifier() == ((MIRFeature)object2).getClassifier()) continue;
                    ((MIRJoinCondition)mIRObject).getJoinRelationship().removeLeftClassifier();
                    ((MIRJoinCondition)mIRObject).getJoinRelationship().addLeftClassifier(((MIRFeature)object2).getClassifier());
                }
                Object[] objectArray = ((MIRFeature)mIRElement2).getRightOfJoinConditions().toArray();
                int n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    Object object5 = objectArray[n];
                    mIRObject = (MIRJoinCondition)object5;
                    ((MIRJoinCondition)mIRObject).removeRightFeature();
                    ((MIRJoinCondition)mIRObject).addRightFeature((MIRFeature)object2);
                    if (((MIRJoinCondition)mIRObject).getJoinRelationship().getRightClassifier() == ((MIRFeature)object2).getClassifier()) continue;
                    ((MIRJoinCondition)mIRObject).getJoinRelationship().removeRightClassifier();
                    ((MIRJoinCondition)mIRObject).getJoinRelationship().addRightClassifier(((MIRFeature)object2).getClassifier());
                }
            }
            if (((MIRFeature)mIRElement2).getSourceOfFeatureMapCount() == 0 && ((MIRFeature)mIRElement2).getControlOfFeatureMapCount() == 0 && mIRElement != null) {
                if (object4 != null && ((MIRClassifierMap)object4).getParent() == mIRTransformationDataSet.getParent()) {
                    ((MIRFeature)mIRElement2).removeClassifier();
                    ((MIRClassifierMap)object4).getDestinationClassifier().addFeatureUniqueName((MIRFeature)mIRElement2);
                    ((MIRFeatureMap)mIRElement).removeClassifierMap();
                    ((MIRClassifierMap)object4).addFeatureMap((MIRFeatureMap)mIRElement);
                    for (MIRFeature mIRFeature : ((MIRFeatureMap)mIRElement).getSourceFeatures()) {
                        if (!((MIRClassifierMap)object4).containsSourceClassifier(mIRFeature.getClassifier())) {
                            ((MIRClassifierMap)object4).addSourceClassifier(mIRFeature.getClassifier());
                        }
                        if (((MIRClassifierMap)object4).containsControlClassifier(mIRFeature.getClassifier())) continue;
                        ((MIRClassifierMap)object4).addControlClassifier(mIRFeature.getClassifier());
                    }
                } else {
                    mIRElement.delete();
                }
            } else {
                for (Object object6 : ((MIRFeature)mIRElement2).getSourceOfFeatureMaps().toArray()) {
                    mIRObject = (MIRFeatureMap)object6;
                    if (object2 == null || mIRElement == null) continue;
                    ((MIRFeatureMap)mIRObject).removeSourceFeature((MIRFeature)mIRElement2);
                    if (((MIRFeatureMap)mIRObject).containsSourceFeature((MIRFeature)object2)) continue;
                    if (!((MIRFeatureMap)mIRElement).getOperation().isEmpty()) {
                        ((MIRFeatureMap)mIRObject).setOperation(((MIRFeatureMap)mIRElement).getOperation());
                    }
                    ((MIRFeatureMap)mIRObject).addSourceFeature((MIRFeature)object2);
                    if (((MIRFeatureMap)mIRObject).getClassifierMap().containsSourceClassifier(((MIRFeature)object2).getClassifier())) continue;
                    ((MIRFeatureMap)mIRObject).getClassifierMap().addSourceClassifier(((MIRFeature)object2).getClassifier());
                }
                for (Object object7 : ((MIRFeature)mIRElement2).getControlOfFeatureMaps().toArray()) {
                    mIRObject = (MIRFeatureMap)object7;
                    if (object2 == null) continue;
                    ((MIRFeatureMap)mIRObject).removeControlFeature((MIRFeature)mIRElement2);
                    if (((MIRFeatureMap)mIRObject).containsControlFeature((MIRFeature)object2)) continue;
                    ((MIRFeatureMap)mIRObject).addControlFeature((MIRFeature)object2);
                    if (((MIRFeatureMap)mIRObject).getClassifierMap().containsControlClassifier(((MIRFeature)object2).getClassifier())) continue;
                    ((MIRFeatureMap)mIRObject).getClassifierMap().addControlClassifier(((MIRFeature)object2).getClassifier());
                }
                Object[] objectArray = ((MIRFeature)mIRElement2).getDestinationOfFeatureMaps().toArray();
                int n3 = objectArray.length;
                for (n = 0; n < n3; ++n) {
                    Object object8 = objectArray[n];
                    mIRObject = (MIRFeatureMap)object8;
                    mIRObject.delete();
                }
            }
            MIRClassifierMap mIRClassifierMap2 = mIRTransformationDataSet.getDestinationOfClassifierMap();
            if (mIRClassifierMap2 == null || mIRClassifierMap2.getFeatureMapCount() != 0) continue;
            if (object4 != null) {
                MIRExpression mIRExpression = mIRClassifierMap2.getExpression();
                if (mIRExpression != null) {
                    mIRExpression.removeClassifierMap();
                    ((MIRClassifierMap)object4).addExpression(mIRExpression);
                }
                if (!mIRClassifierMap2.getDescription().isEmpty() && ((MIRElement)object4).getDescription().isEmpty()) {
                    ((MIRElement)object4).setDescription(mIRClassifierMap2.getDescription());
                }
                if (!mIRClassifierMap2.getNativeType().isEmpty() && ((MIRElement)object4).getNativeType().isEmpty()) {
                    ((MIRElement)object4).setNativeType(mIRClassifierMap2.getNativeType());
                }
                if (!mIRClassifierMap2.getOperation().isEmpty() && ((MIRClassifierMap)object4).getOperation().isEmpty()) {
                    ((MIRClassifierMap)object4).setOperation(mIRClassifierMap2.getOperation());
                }
                for (MIRUsedParameter mIRUsedParameter : mIRClassifierMap2.getUsesUsedParameters()) {
                    if (((MIRElement)object4).containsUsesUsedParameter(mIRUsedParameter)) continue;
                    ((MIRElement)object4).addUsesUsedParameter(mIRUsedParameter);
                }
            }
            mIRClassifierMap2.delete();
        }
        for (MIRJoinRelationship mIRJoinRelationship : mIRTransformationDataSet.getLeftOfJoinRelationships().toArray(new MIRJoinRelationship[mIRTransformationDataSet.getLeftOfJoinRelationshipCount()])) {
            mIRJoinRelationship.delete();
        }
        for (MIRJoinRelationship mIRJoinRelationship : mIRTransformationDataSet.getRightOfJoinRelationships().toArray(new MIRJoinRelationship[mIRTransformationDataSet.getRightOfJoinRelationshipCount()])) {
            mIRJoinRelationship.delete();
        }
        mIRTransformationDataSet.delete();
    }

    public static void cleanupUnsuedTypes(MIRDiModel mIRDiModel) {
        TreeSet<MIRType> treeSet = new TreeSet<MIRType>();
        for (MIRType mIRType : mIRDiModel.getTypes()) {
            if (!mIRType.isInstanceOf((short)5) || mIRType.getFeatureCount() != 0) continue;
            treeSet.add(mIRType);
        }
        for (MIRType mIRType : treeSet) {
            MIRConcreteType mIRConcreteType;
            mIRDiModel.removeType(mIRType);
            if (mIRType.isInstanceOf((short)5) && (mIRConcreteType = ((MIRDerivedType)mIRType).getDerivedFromConcreteType()) != null && mIRConcreteType.getFeatureCount() == 0 && mIRConcreteType.getDerivedTypeCount() == 1) {
                mIRConcreteType.delete();
            }
            mIRType.delete();
        }
    }

    public static MIRClassifier getConnectedTransformationClassifier(MIRClassifierMap mIRClassifierMap, MIRConnectedTransformation mIRConnectedTransformation) {
        MIRClassifier mIRClassifier = null;
        if (mIRConnectedTransformation.isInstanceOf((short)251) || mIRConnectedTransformation.isInstanceOf((short)241)) {
            mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        } else if (mIRConnectedTransformation.isInstanceOf((short)260)) {
            mIRClassifier = mIRClassifierMap.getSourceClassifiers().first();
        } else if (mIRClassifierMap.getSourceClassifierCount() == 0) {
            mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        } else if (mIRClassifierMap.getSourceClassifierCount() == 1 && (mIRClassifier = mIRClassifierMap.getSourceClassifiers().first()).isInstanceOf((short)254) && mIRClassifierMap.getDestinationClassifier() != null) {
            mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        }
        return mIRClassifier;
    }

    public static void removeInputs(MIRElement mIRElement) throws MIRException {
        MIRDiModel mIRDiModel = (MIRDiModel)mIRElement.getRootModel();
        SortedSet<MIRTransformation> sortedSet = null;
        if (mIRElement.isInstanceOf((short)258)) {
            sortedSet = mIRDiModel.getTransformations();
        } else if (mIRElement.isInstanceOf((short)320)) {
            sortedSet = ((MIREmbeddedCallTransformation)mIRElement).getTransformations();
        }
        if (sortedSet == null) {
            return;
        }
        for (MIRTransformation mIRTransformation : sortedSet) {
            boolean bl = true;
            if (mIRTransformation.isInstanceOf((short)260) || mIRTransformation.getInputTransformationDataSets().toArray() == null || mIRTransformation.isInstanceOf((short)238) && mIRTransformation.getOutputTransformationDataSetCount() == 0 && mIRTransformation.getErrorTransformationDataSet() == null || mIRTransformation.getOutputTransformationDataSetCount() > 1 && !mIRTransformation.isInstanceOf((short)320)) continue;
            block1: for (Object object : mIRTransformation.getInputTransformationDataSets().toArray()) {
                MIRTransformationDataSet mIRTransformationDataSet = (MIRTransformationDataSet)object;
                for (MIRClassifierMap mIRClassifierMap : mIRTransformationDataSet.getSourceOfClassifierMaps()) {
                    if (mIRTransformation.isInstanceOf((short)241) && ((MIRLookupTransformation)mIRTransformation).getDataTransformationDataSet() == mIRClassifierMap.getDestinationClassifier() || mIRTransformation.isInstanceOf((short)320) && ((MIREmbeddedCallTransformation)mIRTransformation).getTransformationCount() == 1 || mIRClassifierMap.getOperation().isEmpty()) continue;
                    bl = false;
                    break block1;
                }
            }
            if (!bl) continue;
            if (mIRTransformation.isInstanceOf((short)320)) {
                DesignTreeProcessor.removeInputs(mIRTransformation);
                if (mIRTransformation.getOutputTransformationDataSets() != null) {
                    for (Object object : mIRTransformation.getOutputTransformationDataSets().toArray()) {
                        DesignTreeProcessor.mergeTransformationDataSet((MIRTransformationDataSet)object);
                    }
                }
            }
            if (mIRTransformation.isInstanceOf((short)241)) {
                DesignTreeProcessor.mergeTransformationDataSet(((MIRLookupTransformation)mIRTransformation).getDataTransformationDataSet());
            }
            for (Object object : mIRTransformation.getInputTransformationDataSets().toArray()) {
                DesignTreeProcessor.mergeTransformationDataSet((MIRTransformationDataSet)object);
            }
        }
    }

    public void processStoreModels() throws MIRException {
        Cloneable cloneable;
        ObjectCollector objectCollector = new ObjectCollector(new short[]{295});
        objectCollector.collect(this.imvDirectory);
        ArrayList<MIRStoreContent> arrayList = new ArrayList<MIRStoreContent>();
        List list = objectCollector.getObjects().stream().sorted((mIRStoreContent, mIRStoreContent2) -> mIRStoreContent.getName().compareTo(mIRStoreContent2.getName())).collect(Collectors.toList());
        for (MIRStoreContent mIRStoreContent3 : list) {
            DesignTreeProcessor.setLastModificationTime(this.imvDirectory, null, mIRStoreContent3);
            if (mIRStoreContent3.getSupplierOfConnectionCount() != 0) {
                cloneable = (MIRStoreModel)this.loadModel(mIRStoreContent3);
                if (!this.processStoreModel((MIRStoreModel)cloneable)) {
                    if (((MIRStoreModel)cloneable).getStoreType() == 2 && MIRObjectCollections.__getSdkCaseSensitive()) {
                        ((MIRSystemPackage)cloneable).setSystemCase((byte)1);
                    }
                    if (mIRStoreContent3.getConnectionOfDirectoryStructureModel() != null && !this.containsMiscellaneousKey("-Informatica")) {
                        ((MIRModel)cloneable).getMetadataOrigin().setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__DATA_STORE);
                    }
                    this.saveModel(mIRStoreContent3);
                    if (MIRConnectionManager.getInstance().isMergeQuestion()) {
                        ETLLIB.MSG_CONNECTION_DETAILS.log(mIRStoreContent3.getName(), MIRStoreType.toString(((MIRStoreModel)cloneable).getStoreType()), ((MIRSystemPackage)cloneable).getSystemType());
                    }
                } else {
                    arrayList.add(mIRStoreContent3);
                }
                ((MIR_Object)cloneable).delete();
                continue;
            }
            if (mIRStoreContent3.getFolder() != null) continue;
            arrayList.add(mIRStoreContent3);
        }
        for (MIRStoreContent mIRStoreContent3 : arrayList) {
            cloneable = new ArrayList();
            for (MIRConnection mIRConnection : mIRStoreContent3.getSupplierOfConnections()) {
                ((ArrayList)cloneable).add(mIRConnection);
            }
            Iterator iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                MIRConnection mIRConnection;
                mIRConnection = (MIRConnection)iterator.next();
                mIRConnection.delete();
            }
            mIRStoreContent3.delete();
        }
    }

    protected String resolveParameters(MIRElement mIRElement, String string, CallStackEntry callStackEntry, String string2) throws MIRException {
        if (mIRElement == null || this.imvParameterFinder == null || this.imvParameterFinder.size() == 0 || string.isEmpty()) {
            return string;
        }
        MIRModel mIRModel = mIRElement.getRootModel();
        boolean bl = mIRModel.getContent().isInstanceOf((short)283);
        MIRParameterFinder.Positions positions = new MIRParameterFinder.Positions(0, 0);
        boolean bl2 = true;
        block0: for (int i = 0; i < 1000 && bl2; ++i) {
            bl2 = false;
            for (int j = 0; j < this.imvParameterFinder.size(); ++j) {
                String string3;
                MIRParameterFinder mIRParameterFinder = this.imvParameterFinder.get(j);
                String string4 = string3 = string.isEmpty() ? "" : mIRParameterFinder.findParameter(string, positions, mIRElement, callStackEntry);
                if (string3.isEmpty()) continue;
                bl2 = true;
                if (string3.equals(string2)) {
                    ETLLIB.MSG_DBG.log("Referring the same parameter '" + string2 + "' in its expression is not supported");
                    return string2;
                }
                MIRUsedParameter mIRUsedParameter = this.getParameterValue(mIRElement, string3, callStackEntry);
                if (mIRUsedParameter != null && mIRUsedParameter.getResolved()) {
                    String string5;
                    String string6 = mIRUsedParameter.getValue();
                    if (!mIRUsedParameter.getValue().equals(string)) {
                        string6 = this.getUsedParameterValue(mIRElement, mIRUsedParameter);
                        if (!string6.equals(string)) {
                            string6 = this.resolveParameters(mIRElement, string6, callStackEntry, string3);
                        }
                    } else {
                        ETLLIB.MSG_DBG.log(String.format("There is a recursive reference for Parameter: '%s'. Empty value was applied.", string));
                        string6 = "";
                    }
                    if (string6.isEmpty() && !this.gsvLoggedEmptyParams.containsKey(string3)) {
                        boolean bl3;
                        boolean bl4 = bl3 = !mIRUsedParameter.getNativeType().equals(OPTIONAL_PARAMETER_TAG);
                        if (bl3) {
                            if (!bl) {
                                ETLLIB.MSG_EMPTY_DESIGN_VARIABLE_VALUE.log(MIRLogger.getLogger(), string3);
                            } else {
                                ETLLIB.MSG_EMPTY_VARIABLE_VALUE.log(MIRLogger.getLogger(), string3);
                            }
                        }
                        this.gsvLoggedEmptyParams.put(string3, null);
                    }
                    string = string5 = string.substring(0, positions.imvStartPos) + string6 + string.substring(Math.min(positions.imvEndPos + 1, string.length()));
                    positions.imvEndPos = 0;
                    positions.imvStartPos = 0;
                    continue block0;
                }
                --j;
                positions.imvStartPos = positions.imvEndPos + 1;
            }
        }
        return string;
    }

    private MIRUsedParameter getParameterValue(MIRElement mIRElement, String string, CallStackEntry callStackEntry) throws MIRException {
        MIRUsedParameter mIRUsedParameter = null;
        MIRModel mIRModel = mIRElement.getRootModel();
        if (mIRModel != null && mIRModel.isInstanceOf((short)258)) {
            MIRDiModel mIRDiModel = (MIRDiModel)mIRModel;
            MIRDiModel mIRDiModel2 = callStackEntry.getModel();
            mIRUsedParameter = mIRDiModel.getUsedParameter(string);
            if (mIRUsedParameter == null) {
                mIRUsedParameter = new MIRUsedParameter();
                mIRUsedParameter.setValue("");
                mIRUsedParameter.setDefaultValue("");
                mIRUsedParameter.setName(string);
                mIRUsedParameter.setResolved(false);
                mIRDiModel.addUsedParameter(mIRUsedParameter);
                MIRParameterDefinition mIRParameterDefinition = null;
                if (mIRDiModel == mIRDiModel2) {
                    mIRParameterDefinition = this.resolveDesignParameter(mIRElement, string, callStackEntry);
                    if (mIRParameterDefinition == null) {
                        mIRParameterDefinition = this.resolveRuntimeParameter(mIRElement, string, callStackEntry);
                    }
                } else {
                    mIRParameterDefinition = this.resolveRuntimeParameter(mIRElement, string, callStackEntry);
                    if (mIRParameterDefinition == null) {
                        mIRParameterDefinition = this.resolveDesignParameter(mIRElement, string, callStackEntry);
                    }
                }
                if (mIRParameterDefinition != null) {
                    mIRUsedParameter.setValue(this.getParameterValue(mIRElement, mIRParameterDefinition, mIRParameterDefinition));
                    mIRUsedParameter.setDefaultValue(this.getParameterValue(mIRElement, mIRParameterDefinition, mIRParameterDefinition));
                    mIRUsedParameter.setNativeType(mIRParameterDefinition.getNativeType());
                    mIRUsedParameter.setDefinitionSource(mIRParameterDefinition.getPath());
                    mIRUsedParameter.setResolved(true);
                }
            }
            if (!mIRElement.containsUsesUsedParameter(mIRUsedParameter)) {
                mIRElement.addUsesUsedParameter(mIRUsedParameter);
            }
        }
        return mIRUsedParameter;
    }

    public MIRDirectoryStructureModel startPostProcessor() throws MIRException {
        String string = this.getMiscellaneousValue("-ppl");
        if (string != null) {
            string = string.replaceAll("^\"|\"$", "");
        }
        if (string != null && !string.isEmpty() && new File(string).isDirectory()) {
            File file = this.imvMixManager.getMultiModelFile().getParentFile();
            FileUtil.copy(new File(string), file);
            this.imvDirectory = this.imvMixManager.loadDirectoryStructure();
            this.execute();
            return this.imvDirectory;
        }
        return null;
    }

    public void execute() throws MIRException {
        MIRObjectCollections.__setSdkCaseSensitive(true);
        String string = this.getMiscellaneousValue("-pps");
        if (string != null && !string.isEmpty() && new File(string).isDirectory()) {
            string = string.replaceAll("^\"|\"$", "");
            this.imvMixManager.saveDirectoryStructure(this.imvDirectory);
            FileUtil.copy(this.imvMixManager.getMultiModelFile().getParentFile(), new File(string));
        }
        if (this.imvDisablePostProcessor) {
            this.imvMixManager.saveDirectoryStructure(this.imvDirectory);
            return;
        }
        Date date = new Date();
        ETLLIB.MSG_STARTED_POST_PROCESSOR.log(this.imvLog, new Object[0]);
        this.imvDirectory.setType((byte)0);
        if (this.imvDirectory.getModificationTime().isNull()) {
            this.imvDirectory.setModificationTime(MIRDate.getCurrentDate());
        }
        if (this.imvDirectory.getFolderContentCount() > 0) {
            Object object;
            Date date2 = new Date();
            ETLLIB.LOADING_CONNECTION_MODELS.log(new Object[0]);
            this.loadConnectionModels();
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("\tloadConnectionModels = " + (new Date().getTime() - date2.getTime()));
            }
            date2 = new Date();
            ETLLIB.MSG_GENERATE_RT_TREE.log(new Object[0]);
            long l = System.currentTimeMillis();
            this.processRuntimes();
            this.imvRntmProcTime = System.currentTimeMillis() - l;
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("\tprocessRuntimes = " + (new Date().getTime() - date2.getTime()));
            }
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("\tsmvRntmCounter = " + RuntimeProcessor.smvRntmCounter);
            }
            date2 = new Date();
            ETLLIB.MSG_PROCESS_TRANSFORMATION_TASKS.log(new Object[0]);
            if (this.containsMiscellaneousKey("-pppd")) {
                l = System.currentTimeMillis();
                this.processDesigns();
                this.imvDsgnProcTime = System.currentTimeMillis() - l;
            }
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("\tprocessDesigns = " + (new Date().getTime() - date2.getTime()));
            }
            date2 = new Date();
            ETLLIB.MSG_SAVE_CONNECTION_MODELS.log(this.imvLog, new Object[0]);
            this.processStoreModels();
            if (this.imvUseMultithreading) {
                BLIB.DBG_DEBUG.log("\tprocessStoreModels = " + (new Date().getTime() - date2.getTime()));
            }
            date2 = new Date();
            if (this.imvBuildUltimateSummary) {
                ETLLIB.MSG_SUMMARIZE_ACTIVITIES.log(this.imvLog, new Object[0]);
                object = new EtlSummarizer(new MIRMixCache(this.imvMixManager), true);
                ((EtlSummarizer)object).summarizeDirectoryStructure(this.imvDirectory);
                object = null;
                if (this.imvUseMultithreading) {
                    BLIB.DBG_DEBUG.log("\tlclSummarizer.summarizeDirectoryStructure = " + (new Date().getTime() - date2.getTime()));
                }
            }
            object = new ObjectCollector(new short[]{159});
            this.imvDirectory.depthTraversal(object);
            for (MIRContent mIRContent : ((ObjectCollector)object).getObjects()) {
                mIRContent.removeModel();
            }
            if (this.isSummaryProfile()) {
                for (Object object2 : this.imvDirectory.getFolderContents().toArray()) {
                    this.removeNotSummaryProfileContents((MIRFolderContent)object2);
                }
            }
            boolean bl = true;
            while (bl) {
                bl = false;
                ObjectCollector objectCollector = new ObjectCollector(new short[]{157});
                objectCollector.collect(this.imvDirectory);
                for (Object object2 : objectCollector.getObjects()) {
                    if (((MIRFolder)object2).getFolderContentCount() != 0 || ((MIRFolder)object2).getReferencedFolderContentCount() != 0 || ((MIRElement)object2).getReferencedByElementNamePartCount() != 0 || ((MIRFolderContent)object2).getReferencedByFolderCount() != 0 || ((MIRElement)object2).getReferencedByOperationNodeCount() != 0) continue;
                    ((MIR_Object)object2).delete();
                    bl = true;
                }
            }
        }
        MIRBridgeLib.setStoreConnectionsModelKey(this.imvDirectory);
        if (this.imvDirectory.getImportDate().isNull()) {
            this.imvDirectory.setImportDate(MIRDate.getCurrentDate());
        }
        if (this.isSummaryProfile() && this.imvDirectory.getMetadataOrigin() != null) {
            this.imvDirectory.getMetadataOrigin().setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        }
        int n = smvStatisticRuntimeCount.get() + smvStatisticRuntimeEmbeddingCount.get();
        BLIB.DBG_DEBUG.log(String.format("Created %s runtimes - models: %s embeddings: %s reused: %s", String.valueOf(n), String.valueOf(smvStatisticRuntimeCount.get()), String.valueOf(smvStatisticRuntimeEmbeddingCount.get()), String.valueOf(smvStatisticRuntimeReusedCount.get())));
        if (this.imvUseMultithreading) {
            BLIB.DBG_DEBUG.log("Total execute = " + (new Date().getTime() - date.getTime()));
        }
        if (this.imvUseMultithreading) {
            BLIB.DBG_DEBUG.log("\n\t\tsmvCntLoadModel         =" + smvCntLoadModel.intValue() + "\\" + smvTimeLoadModel.intValue() + "\n\t\t\tsmvCntLoadModelDiDesign =" + smvCntLoadModelDiDesign + "\n\t\t\tsmvCntLoadModelDiRuntime=" + smvCntLoadModelDiRuntime + "\n\t\t\tsmvCntLoadModelStore    =" + smvCntLoadModelStore + "\n\t\tsmvCntLoadModelNoCache  =" + smvCntLoadModelNoCache.intValue() + "\\" + smvTimeLoadModelNoCache.intValue() + "\n\t\tsmvCntSaveModel         =" + smvCntSaveModel.intValue() + "\\" + smvTimeSaveModel.intValue() + "\n\t\t\tsmvCntSaveModelDiDesign =" + smvCntSaveModelDiDesign + "\n\t\t\tsmvCntSaveModelDiRuntime=" + smvCntSaveModelDiRuntime + "\n\t\t\tsmvCntSaveModelStore    =" + smvCntSaveModelStore + "\n\t\tsmvCntSavePartialModel  =" + smvCntSavePartialModel.intValue() + "\\" + smvTimeSavePartialModel.intValue());
        }
        BLIB.DBG_DEBUG.log("Design processing: " + this.imvDsgnProcTime + " \tRuntime processing: " + this.imvRntmProcTime + " \tOn Runtime completed: " + this.imvOnRntmCompTime + "");
    }

    public boolean isSummaryProfile() {
        return this.imvSummaryProfile;
    }

    public static <T extends MIRObject> List<T> sortObjectsByPath(Set<T> set) {
        return set.stream().sorted(new Comparator<MIRObject>(){

            @Override
            public int compare(MIRObject mIRObject, MIRObject mIRObject2) {
                int n = mIRObject.getPath().compareTo(mIRObject2.getPath());
                if (n == 0) {
                    n = mIRObject.getName().compareTo(mIRObject2.getName());
                }
                return n;
            }
        }).collect(Collectors.toList());
    }

    public boolean isMultiStatement(MIRClassifierMap mIRClassifierMap) {
        return false;
    }

    public boolean isMultiStatementQuery(MIRClassifierMap mIRClassifierMap) {
        MIRTransformation mIRTransformation = mIRClassifierMap.getTransformation();
        return mIRTransformation == null || !mIRTransformation.isInstanceOf((short)260);
    }

    public boolean isOperationTableName(MIRClassifierMap mIRClassifierMap) {
        boolean bl = false;
        MIRConnectedTransformation mIRConnectedTransformation = (MIRConnectedTransformation)mIRClassifierMap.getTransformation();
        boolean bl2 = mIRConnectedTransformation.isInstanceOf((short)251) || mIRConnectedTransformation.isInstanceOf((short)260) || mIRConnectedTransformation.isInstanceOf((short)241) || mIRConnectedTransformation.isInstanceOf((short)238);
        bl = !mIRConnectedTransformation.getUserDefinedQuery() && bl2;
        bl = bl && (this.getSqlOverrideType() == SqlOverrideType.TABLE || this.getSqlOverrideType() == SqlOverrideType.BOTH);
        return bl;
    }

    public static class DesignProcessor
    extends ModelProcessor {
        protected MIRDiModel imvDiModel;
        protected CallStackEntry imvCallStack;

        public DesignProcessor(DesignTreeProcessor designTreeProcessor, DesignTreeEmbedding designTreeEmbedding, TreeMap<MIRDiRuntimeContent, ArrayList<ParamValue>> treeMap, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, TreeMap<String, MIRStoreModel> treeMap2, MIRDiModel mIRDiModel, CallStackEntry callStackEntry) {
            super(designTreeProcessor, treeMap, n, mIRDirectoryStructureModel, treeMap2);
            this.imvDiModel = mIRDiModel;
            this.imvCallStack = callStackEntry;
        }

        @Override
        protected Boolean internalCall() {
            try {
                this.processModel();
            }
            catch (MIRException mIRException) {
                BLIB.DBG_DEBUG.log(mIRException, "Fail to process model");
                return false;
            }
            return true;
        }

        private void processModel() throws MIRException {
            this.processTransformationTask(this.imvDiModel, this.imvCallStack);
            this.updateConnectedStores(this.imvDiModel);
            DesignTreeProcessor.processUsage(this.imvDiModel);
            this.imvProcessor.saveModel(this.imvDiModel.getContent());
            this.imvDiModel.delete();
        }
    }

    public static class RuntimeProcessor
    extends ModelProcessor {
        protected DesignTreeEmbedding imvEmbedder;
        protected MIRDiDesignContent imvExecDsgnContent;
        protected CallStackEntry imvCallStack;
        protected EtlSummarizer imvSummarizer;
        static int smvRntmCounter = 0;

        public RuntimeProcessor(DesignTreeProcessor designTreeProcessor, DesignTreeEmbedding designTreeEmbedding, TreeMap<MIRDiRuntimeContent, ArrayList<ParamValue>> treeMap, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, TreeMap<String, MIRStoreModel> treeMap2, MIRDiDesignContent mIRDiDesignContent, CallStackEntry callStackEntry) {
            super(designTreeProcessor, treeMap, n, mIRDirectoryStructureModel, treeMap2);
            this.imvEmbedder = designTreeEmbedding;
            this.imvExecDsgnContent = mIRDiDesignContent;
            this.imvCallStack = callStackEntry;
            this.imvSummarizer = new EtlSummarizer(new MIRMixCache(designTreeProcessor.imvMixManager), true);
        }

        @Override
        protected Boolean internalCall() {
            try {
                this.processRuntime(0, this.imvExecDsgnContent, this.imvCallStack);
            }
            catch (MIRException mIRException) {
                BLIB.DBG_DEBUG.log(mIRException, "Fail to process runtime model");
                return false;
            }
            return true;
        }

        private MIREmbeddedCallStep getCallStep(MIRDiModel mIRDiModel, MIRDiEmbedding mIRDiEmbedding) {
            MIREmbeddedCallStep mIREmbeddedCallStep = null;
            MIRContainerStep mIRContainerStep = null;
            EscapedStringTokenizer escapedStringTokenizer = new EscapedStringTokenizer(mIRDiEmbedding.getName(), '/', '\\');
            String string = escapedStringTokenizer.getNextToken();
            while (string != null) {
                MIRActivityStep mIRActivityStep;
                if (mIRContainerStep == null) {
                    mIRActivityStep = mIRDiModel.getActivityStep(string);
                    if (mIRActivityStep == null) break;
                    if (mIRActivityStep.isInstanceOf((short)315)) {
                        mIRContainerStep = (MIRContainerStep)mIRActivityStep;
                    } else if (mIRActivityStep.isInstanceOf((short)313)) {
                        mIREmbeddedCallStep = (MIREmbeddedCallStep)mIRActivityStep;
                        break;
                    }
                } else {
                    mIRActivityStep = mIRContainerStep.getActivityStep(string);
                    if (mIRActivityStep == null) break;
                    if (mIRActivityStep.isInstanceOf((short)315)) {
                        mIRContainerStep = (MIRContainerStep)mIRActivityStep;
                    } else if (mIRActivityStep.isInstanceOf((short)313)) {
                        mIREmbeddedCallStep = (MIREmbeddedCallStep)mIRActivityStep;
                        break;
                    }
                }
                string = escapedStringTokenizer.getNextToken();
            }
            return mIREmbeddedCallStep;
        }

        private MIRCallTransformation getCallTransformation(MIRDiModel mIRDiModel, MIRDiEmbedding mIRDiEmbedding) {
            MIRCallTransformation mIRCallTransformation = null;
            MIREmbeddedCallTransformation mIREmbeddedCallTransformation = null;
            EscapedStringTokenizer escapedStringTokenizer = new EscapedStringTokenizer(mIRDiEmbedding.getName(), '/', '\\');
            String string = escapedStringTokenizer.getNextToken();
            while (string != null) {
                MIRTransformation mIRTransformation;
                if (mIREmbeddedCallTransformation == null) {
                    mIRTransformation = mIRDiModel.getTransformation(string);
                    if (mIRTransformation == null) break;
                    if (mIRTransformation.isInstanceOf((short)320)) {
                        mIREmbeddedCallTransformation = (MIREmbeddedCallTransformation)mIRTransformation;
                    } else if (mIRTransformation.isInstanceOf((short)257)) {
                        mIRCallTransformation = (MIRCallTransformation)mIRTransformation;
                        break;
                    }
                } else {
                    mIRTransformation = mIREmbeddedCallTransformation.getTransformation(string);
                    if (mIRTransformation == null) break;
                    if (mIRTransformation.isInstanceOf((short)320)) {
                        mIREmbeddedCallTransformation = (MIREmbeddedCallTransformation)mIRTransformation;
                    } else if (mIRTransformation.isInstanceOf((short)257)) {
                        mIRCallTransformation = (MIRCallTransformation)mIRTransformation;
                        break;
                    }
                }
                string = escapedStringTokenizer.getNextToken();
            }
            return mIRCallTransformation;
        }

        private MIRQueryTable getCallQueryTable(MIRDiModel mIRDiModel, MIRDiEmbedding mIRDiEmbedding) {
            MIRQueryTable mIRQueryTable = null;
            MIRTransformation mIRTransformation = null;
            EscapedStringTokenizer escapedStringTokenizer = new EscapedStringTokenizer(mIRDiEmbedding.getName(), '.', '\\');
            String string = escapedStringTokenizer.getNextToken();
            while (string != null) {
                MIRTransformation mIRTransformation2;
                if (mIRTransformation == null) {
                    mIRTransformation2 = mIRDiModel.getTransformation(string);
                    if (mIRTransformation2 == null || !mIRTransformation2.isInstanceOf((short)318)) break;
                    mIRTransformation = (MIRSqlQuery)mIRTransformation2;
                } else {
                    mIRTransformation2 = mIRTransformation.getSubSqlQuery(string);
                    if (mIRTransformation2 == null) {
                        mIRQueryTable = mIRTransformation.getCallQueryTable(string);
                        break;
                    }
                    mIRTransformation = mIRTransformation2;
                }
                string = escapedStringTokenizer.getNextToken();
            }
            return mIRQueryTable;
        }

        private MIRSqlQuery getCallSqlQuery(MIRDiModel mIRDiModel, MIRDiEmbedding mIRDiEmbedding) {
            MIRElement mIRElement = null;
            EscapedStringTokenizer escapedStringTokenizer = new EscapedStringTokenizer(mIRDiEmbedding.getName(), '.', '\\');
            String string = escapedStringTokenizer.getNextToken();
            while (string != null) {
                MIRTransformation mIRTransformation;
                if (mIRElement == null) {
                    mIRTransformation = mIRDiModel.getTransformation(string);
                    if (mIRTransformation == null || !mIRTransformation.isInstanceOf((short)318)) break;
                    mIRElement = (MIRSqlQuery)mIRTransformation;
                } else {
                    mIRTransformation = ((MIRSqlQuery)mIRElement).getSubSqlQuery(string);
                    if (mIRTransformation == null) break;
                    mIRElement = mIRTransformation;
                }
                string = escapedStringTokenizer.getNextToken();
            }
            if (mIRElement != null && !mIRElement.getNativeType().equals("REUSABLEMAPPING")) {
                mIRElement = null;
            }
            return mIRElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processRuntimeWithEmbedding(MIRDiRuntimeContent mIRDiRuntimeContent, MIRDiEmbedding mIRDiEmbedding, CallStackEntry callStackEntry) throws MIRException {
            MIRDiDesignContent mIRDiDesignContent = mIRDiEmbedding.getSupplierDiDesignContent();
            MIRDiModel mIRDiModel = (MIRDiModel)this.imvProcessor.loadModel(mIRDiDesignContent);
            if (callStackEntry.findByModel(mIRDiModel) == null) {
                long l = System.currentTimeMillis();
                long l2 = this.imvProcessor.imvOnRntmCompTime;
                ETLLIB.MSG_PROCESS_EMBEDDING_TASK.log(mIRDiEmbedding.getName(), mIRDiEmbedding.getSupplierDiDesignContent().getPath());
                MIRDiRuntimeContent mIRDiRuntimeContent2 = this.createRuntime(new CallStackEntry(mIRDiModel, mIRDiEmbedding, callStackEntry));
                smvStatisticRuntimeEmbeddingCount.incrementAndGet();
                try {
                    MIRElement mIRElement2;
                    MIRDiModel mIRDiModel2 = (MIRDiModel)this.imvProcessor.loadModel(mIRDiRuntimeContent);
                    for (MIRElement mIRElement2 : mIRDiDesignContent.getClientOfDiEmbeddings()) {
                        if (this.getCallTransformation(mIRDiModel2, mIRDiEmbedding) == null && this.getCallQueryTable(mIRDiModel2, mIRDiEmbedding) == null && this.getCallSqlQuery(mIRDiModel, (MIRDiEmbedding)mIRElement2) == null) continue;
                        this.processRuntimeWithEmbedding(mIRDiRuntimeContent2, (MIRDiEmbedding)mIRElement2, new CallStackEntry(mIRDiModel, mIRDiEmbedding, callStackEntry));
                    }
                    MIRCallTransformation mIRCallTransformation = this.getCallTransformation(mIRDiModel2, mIRDiEmbedding);
                    mIRElement2 = this.getCallQueryTable(mIRDiModel2, mIRDiEmbedding);
                    MIRSqlQuery mIRSqlQuery = this.getCallSqlQuery(mIRDiModel2, mIRDiEmbedding);
                    if (mIRCallTransformation != null) {
                        this.imvEmbedder.embedRuntime(mIRDiRuntimeContent, mIRDiRuntimeContent2, mIRCallTransformation);
                    } else if (mIRElement2 != null) {
                        this.imvEmbedder.embedRuntime(mIRDiRuntimeContent, mIRDiRuntimeContent2, (MIRQueryTable)mIRElement2);
                    } else if (mIRSqlQuery != null) {
                        this.imvEmbedder.embedRuntime(mIRDiRuntimeContent, mIRDiRuntimeContent2, mIRSqlQuery);
                    } else {
                        ETLLIB.ERR_UNSUPPORTED_EMBEDDING.log(mIRDiEmbedding.getPath());
                    }
                    BLIB.DBG_DEBUG.log("Runtime completed: " + mIRDiRuntimeContent2.getPath() + " \tFeatures: " + this.imvProcessor.calcFeaturesCount(mIRDiRuntimeContent2.getModel()) + " \tTotal duration: " + (System.currentTimeMillis() - l) + " \tOnRuntimeCompleted duration: " + (this.imvProcessor.imvOnRntmCompTime - l2));
                }
                finally {
                    if (mIRDiRuntimeContent2 != null) {
                        if (mIRDiRuntimeContent2.getModel() != null) {
                            mIRDiRuntimeContent2.getModel().delete();
                        }
                        mIRDiRuntimeContent2.removeDiDesignContent();
                        mIRDiRuntimeContent2.delete();
                    }
                }
            }
        }

        private MIRDiRuntimeContent createRuntime(CallStackEntry callStackEntry) throws MIRException {
            ++smvRntmCounter;
            MIRDiDesignContent mIRDiDesignContent = (MIRDiDesignContent)callStackEntry.getModel().getContent();
            MIRDiRuntimeContent mIRDiRuntimeContent = new MIRDiRuntimeContent();
            mIRDiRuntimeContent.setName(callStackEntry.getPathByEmbedding());
            DesignTreeProcessor.setLastModificationTime(this.imvDirectory, mIRDiDesignContent, mIRDiRuntimeContent);
            if (!mIRDiDesignContent.getNativeType().isEmpty()) {
                mIRDiRuntimeContent.setNativeType(mIRDiDesignContent.getNativeType() + " execution");
            }
            mIRDiDesignContent.addDiRuntimeContent(mIRDiRuntimeContent);
            try {
                Object object;
                MIRDiModel mIRDiModel = (MIRDiModel)this.imvProcessor.loadModelNoCache(mIRDiDesignContent);
                MIRDiModel mIRDiModel2 = RuntimeCreator.createRuntime(mIRDiModel);
                mIRDiModel.delete();
                if (mIRDiModel2 == null) {
                    return mIRDiRuntimeContent;
                }
                mIRDiModel2.setName(mIRDiRuntimeContent.getName());
                mIRDiRuntimeContent.addModel(mIRDiModel2);
                MIRMetadataOrigin mIRMetadataOrigin = mIRDiModel2.getMetadataOrigin();
                if (mIRMetadataOrigin != null) {
                    if (this.imvProcessor.isSummaryProfile()) {
                        mIRMetadataOrigin.setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__RUNTIME_SUMMARY);
                    } else {
                        int n = this.getModelProfileId(mIRDiModel2);
                        if (n >= 0) {
                            mIRMetadataOrigin.setProfileId(n);
                        }
                    }
                }
                if (this.imvProcessor.imvDoNativeIdClean) {
                    class ResetNativeIds
                    implements MIR_Object.MIRTraversalOperation {
                        ResetNativeIds() {
                        }

                        @Override
                        public boolean traverse(MIRObject mIRObject) throws MIRException {
                            return true;
                        }

                        @Override
                        public void pre_process(MIRObject mIRObject, boolean bl) {
                            if (mIRObject.isInstanceOf((short)0)) {
                                ((MIRElement)mIRObject).setNativeId("");
                            }
                        }

                        @Override
                        public void post_process(MIRObject mIRObject) {
                        }
                    }
                    ResetNativeIds resetNativeIds = new ResetNativeIds();
                    mIRDiModel2.depthTraversal(resetNativeIds);
                }
                for (MIRConnection mIRConnection : mIRDiDesignContent.getClientOfConnections()) {
                    object = new MIRConnection(mIRConnection);
                    String string = ((MIRObject)object).getName();
                    ((MIRObject)object).setName(string);
                    ((MIRConnection)object).addClientContent(mIRDiRuntimeContent);
                    ((MIRConnection)object).addSupplierStoreContent(mIRConnection.getSupplierStoreContent());
                }
                this.imvProcessor.onRuntimeModelCreated(mIRDiModel2, callStackEntry);
                this.processTransformationTask(mIRDiModel2, callStackEntry);
                long l = System.currentTimeMillis();
                this.imvProcessor.onRuntimeCompleted(mIRDiModel2, callStackEntry);
                this.imvProcessor.imvOnRntmCompTime += System.currentTimeMillis() - l;
                this.processEmbeddedTransformationConnections(mIRDiModel2.getContent(), null, callStackEntry);
                if (this.imvProcessor.imvMiscellaneous.contains("-etl.transformations.enable.xml") && (object = this.imvProcessor.createHierarchicalMetadataProcessor()) != null) {
                    ((HierarchicalMetadataProcessor)object).processModel(mIRDiModel2);
                }
                this.updateConnectedStores(mIRDiModel2);
                this.cleanUpUnusedColumns(mIRDiModel2);
                DesignTreeProcessor.logUndefinedParameters(mIRDiModel2);
                DesignTreeProcessor.processUsage(mIRDiModel2);
            }
            catch (Exception exception) {
                mIRDiRuntimeContent.delete();
                throw exception;
            }
            return mIRDiRuntimeContent;
        }

        protected static int compHierarchyLex(MIRObject mIRObject, MIRObject mIRObject2) {
            int n = 0;
            if (mIRObject != null && mIRObject2 != null) {
                n = RuntimeProcessor.compHierarchyLex(mIRObject.getParent(), mIRObject2.getParent());
                if (n == 0) {
                    n = mIRObject.getName().compareTo(mIRObject2.getName());
                }
            } else {
                n = mIRObject == mIRObject2 ? 0 : (mIRObject != null ? 1 : -1);
            }
            return n;
        }

        protected static void calcStringDigest(StringDigest stringDigest, MIRObject mIRObject) {
            if (mIRObject != null && !mIRObject.isInstanceOf((short)218)) {
                if (mIRObject.isInstanceOf((short)0)) {
                    stringDigest.update(((MIRElement)mIRObject).getDescription());
                }
                stringDigest.update(mIRObject.getName());
                RuntimeProcessor.calcStringDigest(stringDigest, mIRObject.getParent());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRuntime(int n, MIRDiDesignContent mIRDiDesignContent, CallStackEntry callStackEntry) throws MIRException {
            MIRDiDesignContent mIRDiDesignContent2;
            MIRElement mIRElement = null;
            MIRDiModel mIRDiModel = callStackEntry.getModel();
            MIRDiDesignContent mIRDiDesignContent3 = mIRDiDesignContent2 = (MIRDiDesignContent)mIRDiModel.getContent();
            synchronized (mIRDiDesignContent3) {
                Cloneable cloneable;
                if (this.imvProcessor.imvExecuteEmptyDesigns || mIRDiModel.getTransformationCount() > 0) {
                    Object object;
                    boolean bl = false;
                    for (MIRDiEmbedding mIRDiEmbedding : mIRDiDesignContent2.getClientOfDiEmbeddings()) {
                        if (this.getCallTransformation(mIRDiModel, mIRDiEmbedding) == null && this.getCallQueryTable(mIRDiModel, mIRDiEmbedding) == null && this.getCallSqlQuery(mIRDiModel, mIRDiEmbedding) == null) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        for (MIRDiRuntimeContent mIRDiRuntimeContent : mIRDiDesignContent2.getDiRuntimeContents()) {
                            cloneable = (ArrayList)this.imvRuntimeParameters.get(mIRDiRuntimeContent);
                            boolean bl2 = false;
                            if (cloneable != null) {
                                for (ParamValue paramValue : cloneable) {
                                    String string = "";
                                    MIRParameterDefinition mIRParameterDefinition = this.imvProcessor.resolveRuntimeParameter(mIRDiModel, paramValue.getName(), callStackEntry);
                                    object = this.imvProcessor.resolveDesignParameter(mIRDiModel, paramValue.getName(), callStackEntry);
                                    if (mIRParameterDefinition != null) {
                                        string = this.getParameterValue(mIRDiModel, mIRParameterDefinition, (MIRParameterDefinition)object);
                                    } else if (object != null) {
                                        string = this.getParameterValue(mIRDiModel, (MIRParameterDefinition)object, (MIRParameterDefinition)object);
                                    }
                                    if (!(bl2 = !paramValue.getValue().equals(string))) continue;
                                    BLIB.DBG_DEBUG.log(String.format("Parameter differences found in existing runtime content '%s': name '%s', value '%s', new value '%s'. The content can't be reused.", mIRDiRuntimeContent.getName(), paramValue.getName(), string, paramValue.getValue()));
                                    break;
                                }
                            }
                            if (bl2) continue;
                            mIRElement = mIRDiRuntimeContent;
                            ETLLIB.MSG_REUSE_RUNTIME.log(callStackEntry.getPathByEmbedding(), mIRDiRuntimeContent.getName());
                            smvStatisticRuntimeReusedCount.incrementAndGet();
                            break;
                        }
                    }
                    if (mIRElement == null) {
                        Object object2;
                        long l = System.currentTimeMillis();
                        long l2 = this.imvProcessor.imvOnRntmCompTime;
                        long l3 = 0L;
                        long l4 = 0L;
                        ETLLIB.MSG_PROCESS_RT_TASK.log(callStackEntry.getEmbedding() != null ? callStackEntry.getEmbedding().getName() : mIRDiDesignContent2.getName(), mIRDiDesignContent2.getPath());
                        mIRElement = this.createRuntime(callStackEntry);
                        smvStatisticRuntimeCount.incrementAndGet();
                        try {
                            for (MIRDiEmbedding mIRDiEmbedding : mIRDiDesignContent2.getClientOfDiEmbeddings()) {
                                if (this.getCallTransformation(mIRDiModel, mIRDiEmbedding) == null && this.getCallQueryTable(mIRDiModel, mIRDiEmbedding) == null && this.getCallSqlQuery(mIRDiModel, mIRDiEmbedding) == null) continue;
                                try {
                                    this.processRuntimeWithEmbedding((MIRDiRuntimeContent)mIRElement, mIRDiEmbedding, callStackEntry);
                                }
                                catch (Exception exception) {
                                    throw new MIRException(ETLLIB.ERR_EMBEDING_PROCESS.getMessage(mIRDiEmbedding.getPath(false), exception.getMessage()), exception);
                                }
                            }
                            object = (MIRDiModel)((MIRContent)mIRElement).getModel();
                            if (((MIRContent)mIRElement).getModel() != null && this.imvProcessor.imvBuildRuntimeSummary) {
                                long l5 = System.currentTimeMillis();
                                this.imvSummarizer.buildSummaryLinks((MIRDiModel)object, this.imvProcessor.imvPrintFullyQualifiedNames);
                                l3 = System.currentTimeMillis() - l5;
                                l5 = System.currentTimeMillis();
                                this.imvSummarizer.processJoinRelationship((MIRMappingModel)object);
                                l4 = System.currentTimeMillis() - l5;
                            }
                            this.imvProcessor.onRuntimeSummarized((MIRModel)object, callStackEntry);
                            object2 = new ArrayList();
                            for (MIRUsedParameter mIRUsedParameter : ((MIRDiModel)object).getUsedParameters()) {
                                ((ArrayList)object2).add(new ParamValue(mIRUsedParameter.getName(), mIRUsedParameter.getValue()));
                            }
                            this.imvRuntimeParameters.put(mIRElement, object2);
                            String string = callStackEntry.getPathByEmbedding();
                            if (string.compareTo(mIRElement.getName()) < 0) {
                                mIRElement.setName(string);
                            }
                            if (this.imvProcessor.imvRemoveInput) {
                                DesignTreeProcessor.removeInputs((MIRElement)object);
                                DesignTreeProcessor.cleanupUnsuedTypes((MIRDiModel)object);
                            }
                            mIRElement.setNativeId(StringDigest.getMd5().update(mIRElement.getPath()).toString());
                            BLIB.DBG_DEBUG.log("Runtime completed: " + mIRElement.getPath() + " \tFeatures: " + this.imvProcessor.calcFeaturesCount(((MIRContent)mIRElement).getModel()) + " \tTotal duration: " + (System.currentTimeMillis() - l) + " \tOnRuntimeCompleted duration: " + (this.imvProcessor.imvOnRntmCompTime - l2) + " \tSummary duration: " + l3 + "," + l4);
                            this.imvProcessor.saveModel((MIRContent)mIRElement);
                            ((MIRContent)mIRElement).getModel().delete();
                        }
                        catch (Exception exception) {
                            object2 = callStackEntry.getPathByEmbedding();
                            if (mIRElement != null) {
                                object2 = mIRElement.getName();
                                mIRElement.delete();
                                mIRElement = null;
                            }
                            ETLLIB.ERR_RUNTIME_PROCESS.log(exception, object2, callStackEntry.getEmbedding() != null ? callStackEntry.getEmbedding().getPath(false) : "no embedding");
                        }
                    }
                    if (mIRElement != null && !mIRDiDesignContent.containsExecutedDiRuntimeContent((MIRDiRuntimeContent)mIRElement)) {
                        mIRDiDesignContent.addExecutedDiRuntimeContent((MIRDiRuntimeContent)mIRElement);
                        StringBuilder stringBuilder = new StringBuilder(mIRElement.getNativeId());
                        stringBuilder.append(StringDigest.getMd5().update(mIRDiDesignContent.getPath()).toString());
                        mIRElement.setNativeId(stringBuilder.toString());
                    }
                } else if (mIRDiDesignContent2.getExecutable()) {
                    ETLLIB.MSG_PROCESS_ACTIVITY_TASK.log(mIRDiDesignContent2.getPath(false));
                }
                for (MIRDiEmbedding mIRDiEmbedding : mIRDiDesignContent2.getClientOfDiEmbeddings()) {
                    MIRDiDesignContent mIRDiDesignContent4;
                    if (this.getCallStep(mIRDiModel, mIRDiEmbedding) != null) {
                        MIRDiDesignContent mIRDiDesignContent5 = mIRDiEmbedding.getSupplierDiDesignContent();
                        cloneable = (MIRDiModel)this.imvProcessor.loadModel(mIRDiDesignContent5);
                        if (callStackEntry.findByModel((MIRDiModel)cloneable) != null) continue;
                        this.processRuntime(n++, mIRDiDesignContent, new CallStackEntry((MIRDiModel)cloneable, mIRDiEmbedding, callStackEntry));
                        continue;
                    }
                    if (mIRDiEmbedding.getParameterDiDesignContentCount() <= 0 || callStackEntry.findByModel((MIRDiModel)(cloneable = (MIRDiModel)this.imvProcessor.loadModel(mIRDiDesignContent4 = mIRDiEmbedding.getSupplierDiDesignContent()))) != null) continue;
                    this.processRuntime(n++, mIRDiDesignContent, new CallStackEntry((MIRDiModel)cloneable, mIRDiEmbedding, callStackEntry));
                }
            }
        }
    }

    public static abstract class ModelProcessor
    extends SimpleTask {
        protected DesignTreeProcessor imvProcessor;
        protected TreeMap<MIRDiRuntimeContent, ArrayList<ParamValue>> imvRuntimeParameters;
        protected int imvParserType;
        protected TreeMap<String, MIRStoreModel> imvDesignConnections;
        protected MIRDirectoryStructureModel imvDirectory;
        protected MIRElement imvParsedMap;
        private HashMap<Integer, EtlFeatureExpressionParser> imvEtlParsers;
        private HashMap<Integer, EtlSqlParser> imvSqlParsers;
        private SqlQueryClassifierMapParser imvSqlQueryClassMapParser;

        public ModelProcessor(DesignTreeProcessor designTreeProcessor, TreeMap<MIRDiRuntimeContent, ArrayList<ParamValue>> treeMap, int n, MIRDirectoryStructureModel mIRDirectoryStructureModel, TreeMap<String, MIRStoreModel> treeMap2) {
            this.imvProcessor = designTreeProcessor;
            this.imvRuntimeParameters = treeMap;
            this.imvParserType = n;
            this.imvDirectory = mIRDirectoryStructureModel;
            this.imvDesignConnections = treeMap2;
        }

        /*
         * WARNING - void declaration
         */
        protected void ensureTransformationClassifierMaps(MIRDiModel mIRDiModel) {
            for (MIRTransformation mIRTransformation : mIRDiModel.getTransformations()) {
                void var6_14;
                MIRClassifierMap mIRClassifierMap;
                Object object;
                MIRTransformationDataSet mIRTransformationDataSet;
                if (mIRTransformation.isInstanceOf((short)236)) {
                    mIRTransformationDataSet = ((MIRExpressionTransformation)mIRTransformation).getInputTransformationDataSet();
                    object = ((MIRExpressionTransformation)mIRTransformation).getOutputTransformationDataSet();
                    MIRTransformationDataSet mIRTransformationDataSet2 = ((MIRExpressionTransformation)mIRTransformation).getVariableTransformationDataSet();
                    if (object != null && (mIRTransformationDataSet != null || mIRTransformationDataSet2 != null)) {
                        mIRClassifierMap = ((MIRClassifier)object).getDestinationOfClassifierMap();
                        if (mIRClassifierMap == null) {
                            mIRClassifierMap = new MIRClassifierMap();
                            mIRTransformation.addClassifierMap(mIRClassifierMap);
                            mIRClassifierMap.addDestinationClassifier((MIRClassifier)object);
                        }
                        if (mIRTransformationDataSet != null && !mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet)) {
                            mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
                        }
                        if (mIRTransformationDataSet2 != null && !mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet2)) {
                            mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet2);
                        }
                    }
                    if (mIRTransformationDataSet2 == null || mIRTransformationDataSet == null) continue;
                    mIRClassifierMap = mIRTransformationDataSet2.getDestinationOfClassifierMap();
                    if (mIRClassifierMap == null) {
                        mIRClassifierMap = new MIRClassifierMap();
                        mIRTransformation.addClassifierMap(mIRClassifierMap);
                        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
                    }
                    if (mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet)) continue;
                    mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
                    continue;
                }
                if (mIRTransformation.isInstanceOf((short)219)) {
                    mIRTransformationDataSet = ((MIRAggregationTransformation)mIRTransformation).getInputTransformationDataSet();
                    object = ((MIRAggregationTransformation)mIRTransformation).getOutputTransformationDataSet();
                    MIRTransformationDataSet mIRTransformationDataSet3 = ((MIRAggregationTransformation)mIRTransformation).getVariableTransformationDataSet();
                    if (object != null && (mIRTransformationDataSet != null || mIRTransformationDataSet3 != null)) {
                        mIRClassifierMap = ((MIRClassifier)object).getDestinationOfClassifierMap();
                        if (mIRClassifierMap == null) {
                            mIRClassifierMap = new MIRClassifierMap();
                            mIRTransformation.addClassifierMap(mIRClassifierMap);
                            mIRClassifierMap.addDestinationClassifier((MIRClassifier)object);
                        }
                        if (mIRTransformationDataSet != null && !mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet)) {
                            mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
                        }
                        if (mIRTransformationDataSet3 != null && !mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet3)) {
                            mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet3);
                        }
                    }
                    if (mIRTransformationDataSet3 == null || mIRTransformationDataSet == null) continue;
                    mIRClassifierMap = mIRTransformationDataSet3.getDestinationOfClassifierMap();
                    if (mIRClassifierMap == null) {
                        mIRClassifierMap = new MIRClassifierMap();
                        mIRTransformation.addClassifierMap(mIRClassifierMap);
                        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet3);
                    }
                    if (mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet)) continue;
                    mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
                    continue;
                }
                if (mIRTransformation.isInstanceOf((short)240)) {
                    mIRTransformationDataSet = ((MIRJoinTransformation)mIRTransformation).getLeftTransformationDataSet();
                    object = ((MIRJoinTransformation)mIRTransformation).getRightTransformationDataSet();
                    MIRTransformationDataSet mIRTransformationDataSet4 = ((MIRJoinTransformation)mIRTransformation).getOutputTransformationDataSet();
                    if (mIRTransformationDataSet4 == null || mIRTransformationDataSet == null && object == null) continue;
                    mIRClassifierMap = mIRTransformationDataSet4.getDestinationOfClassifierMap();
                    if (mIRClassifierMap == null) {
                        mIRClassifierMap = new MIRClassifierMap();
                        mIRTransformation.addClassifierMap(mIRClassifierMap);
                        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet4);
                    }
                    if (mIRTransformationDataSet != null && !mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet)) {
                        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
                    }
                    if (object == null || mIRClassifierMap.containsSourceClassifier((MIRClassifier)object)) continue;
                    mIRClassifierMap.addSourceClassifier((MIRClassifier)object);
                    continue;
                }
                if (mIRTransformation.isInstanceOf((short)241)) {
                    mIRTransformationDataSet = ((MIRLookupTransformation)mIRTransformation).getControlTransformationDataSet();
                    object = ((MIRLookupTransformation)mIRTransformation).getDataTransformationDataSet();
                    MIRTransformationDataSet mIRTransformationDataSet5 = ((MIRLookupTransformation)mIRTransformation).getOutputTransformationDataSet();
                    if (mIRTransformationDataSet5 != null && (mIRTransformationDataSet != null || object != null)) {
                        mIRClassifierMap = mIRTransformationDataSet5.getDestinationOfClassifierMap();
                        if (mIRClassifierMap == null) {
                            mIRClassifierMap = new MIRClassifierMap();
                            mIRTransformation.addClassifierMap(mIRClassifierMap);
                            mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet5);
                        }
                        if (mIRTransformationDataSet != null && !mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet)) {
                            mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
                        }
                        if (object != null && !mIRClassifierMap.containsSourceClassifier((MIRClassifier)object)) {
                            mIRClassifierMap.addSourceClassifier((MIRClassifier)object);
                        }
                    }
                    if (mIRTransformationDataSet == null || object == null) continue;
                    mIRClassifierMap = ((MIRClassifier)object).getDestinationOfClassifierMap();
                    if (mIRClassifierMap == null) {
                        mIRClassifierMap = new MIRClassifierMap();
                        mIRTransformation.addClassifierMap(mIRClassifierMap);
                        mIRClassifierMap.addDestinationClassifier((MIRClassifier)object);
                    }
                    if (mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet)) continue;
                    mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
                    continue;
                }
                if (mIRTransformation.isInstanceOf((short)237)) {
                    mIRTransformationDataSet = ((MIRFilteringTransformation)mIRTransformation).getInputTransformationDataSet();
                    if (mIRTransformationDataSet == null) continue;
                    for (MIRTransformationDataSet mIRTransformationDataSet6 : ((MIRFilteringTransformation)mIRTransformation).getOutputTransformationDataSets()) {
                        mIRClassifierMap = mIRTransformationDataSet6.getDestinationOfClassifierMap();
                        if (mIRClassifierMap == null) {
                            mIRClassifierMap = new MIRClassifierMap();
                            mIRTransformation.addClassifierMap(mIRClassifierMap);
                            mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet6);
                        }
                        if (mIRClassifierMap.containsSourceClassifier(mIRTransformationDataSet)) continue;
                        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
                    }
                    continue;
                }
                if (!mIRTransformation.isInstanceOf((short)253)) continue;
                mIRTransformationDataSet = ((MIRSortingTransformation)mIRTransformation).getInputTransformationDataSet();
                object = ((MIRSortingTransformation)mIRTransformation).getOutputTransformationDataSet();
                if (object == null || mIRTransformationDataSet == null) continue;
                MIRClassifierMap mIRClassifierMap2 = ((MIRClassifier)object).getDestinationOfClassifierMap();
                if (mIRClassifierMap2 == null) {
                    MIRClassifierMap mIRClassifierMap3 = new MIRClassifierMap();
                    mIRTransformation.addClassifierMap(mIRClassifierMap3);
                    mIRClassifierMap3.addDestinationClassifier((MIRClassifier)object);
                }
                if (var6_14.containsSourceClassifier(mIRTransformationDataSet)) continue;
                var6_14.addSourceClassifier(mIRTransformationDataSet);
            }
        }

        public void implementGroupBy(MIRLogger mIRLogger, MIRSqlQuery mIRSqlQuery) {
            for (MIRTransformationDataSet mIRTransformationDataSet : mIRSqlQuery.getOutputTransformationDataSets()) {
                if (mIRTransformationDataSet == null || !mIRTransformationDataSet.isInstanceOf((short)243)) continue;
                MIRQueryTable mIRQueryTable = (MIRQueryTable)mIRTransformationDataSet;
                ArrayList<MIRQueryColumn> arrayList = new ArrayList<MIRQueryColumn>();
                boolean bl = false;
                Object object = mIRQueryTable.getFeatures().iterator();
                while (object.hasNext()) {
                    MIRQueryColumn mIRQueryColumn;
                    MIRFeatureMap mIRFeatureMap;
                    MIRFeature mIRFeature = (MIRFeature)object.next();
                    if (!mIRFeature.isInstanceOf((short)242) || (mIRFeatureMap = (mIRQueryColumn = (MIRQueryColumn)mIRFeature).getDestinationOfFeatureMap()) == null) continue;
                    AggExpressionPrinter aggExpressionPrinter = new AggExpressionPrinter(0, this.imvParserType);
                    aggExpressionPrinter.convertExpression(mIRFeatureMap);
                    if (!aggExpressionPrinter.imvIsAggregation) {
                        arrayList.add((MIRQueryColumn)mIRFeature);
                        continue;
                    }
                    bl = true;
                }
                if (!bl || (object = mIRQueryTable.getQueryGroupBy()) != null) continue;
                object = new MIRQueryGroupBy();
                for (MIRQueryColumn mIRQueryColumn : arrayList) {
                    ((MIRQueryGroupBy)object).addQueryColumn(mIRQueryColumn);
                }
                mIRQueryTable.addQueryGroupBy((MIRQueryGroupBy)object);
            }
        }

        protected void cleanUpUnusedColumns(MIRDiModel mIRDiModel) {
            ObjectCollector objectCollector = new ObjectCollector(new short[]{318});
            objectCollector.collect(mIRDiModel);
            for (MIRSqlQuery mIRSqlQuery : objectCollector.getObjects()) {
                Cloneable cloneable;
                Object object5;
                Object object2;
                Object object3;
                Object object42;
                this.implementGroupBy(MIRLogger.getLogger(), mIRSqlQuery);
                ObjectCollector objectCollector2 = new ObjectCollector(new short[]{335});
                objectCollector2.collect(mIRSqlQuery);
                for (Object object42 : objectCollector2.getObjects()) {
                    object3 = new ObjectCollector(new short[]{242});
                    ((ObjectCollector)object3).collect((MIRObject)object42);
                    object2 = new ArrayList();
                    for (Object object5 : ((ObjectCollector)object3).getObjects()) {
                        if (((MIRFeature)object5).getSourceOfFeatureMapCount() != 0 || ((MIRFeature)object5).getControlOfFeatureMapCount() != 0 || ((MIRQueryColumn)object5).getQueryGroupBy() != null || ((MIRQueryColumn)object5).getQuerySortItemCount() != 0) continue;
                        ((ArrayList)object2).add(object5);
                    }
                    for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                        object5 = (MIRQueryColumn)((ArrayList)object2).get(i);
                        cloneable = ((MIRFeature)object5).getDestinationOfFeatureMap();
                        if (cloneable != null) {
                            ((MIR_Object)cloneable).delete();
                        }
                        ((MIR_Object)object5).delete();
                    }
                }
                ObjectCollector objectCollector3 = new ObjectCollector(new short[]{243});
                objectCollector3.collect(mIRSqlQuery);
                object42 = objectCollector3.getObjects().iterator();
                while (object42.hasNext()) {
                    object3 = (MIRQueryTable)object42.next();
                    object2 = new ObjectCollector(new short[]{333});
                    ((ObjectCollector)object2).collect((MIRObject)object3);
                    if (((ObjectCollector)object2).getObjects().size() != 0) continue;
                    ObjectCollector objectCollector4 = new ObjectCollector(new short[]{242});
                    objectCollector4.collect((MIRObject)object3);
                    object5 = new ObjectCollector(new short[]{337});
                    ((ObjectCollector)object5).collect((MIRObject)object3);
                    if (((ObjectCollector)object5).getObjects().size() != 0) continue;
                    cloneable = new ArrayList();
                    for (MIRQueryColumn mIRQueryColumn : objectCollector4.getObjects()) {
                        if (mIRQueryColumn.getSourceOfFeatureMapCount() != 0 || mIRQueryColumn.getDestinationOfFeatureMap() != null || mIRQueryColumn.getControlOfFeatureMapCount() != 0 || mIRQueryColumn.getQueryGroupBy() != null || mIRQueryColumn.getQuerySortItemCount() != 0) continue;
                        ((ArrayList)cloneable).add(mIRQueryColumn);
                    }
                    for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                        ((MIRQueryColumn)((ArrayList)cloneable).get(i)).delete();
                    }
                }
            }
        }

        protected String getParameterValue(MIRElement mIRElement, MIRParameterDefinition mIRParameterDefinition, MIRParameterDefinition mIRParameterDefinition2) {
            return this.imvProcessor.getParameterValue(mIRElement, mIRParameterDefinition, mIRParameterDefinition2);
        }

        public String getTransformationTaskVariableName(MIRElement mIRElement, String string) {
            return this.imvProcessor.getTransformationTaskVariableName(mIRElement, string);
        }

        protected String resolveParameters(MIRElement mIRElement, String string, CallStackEntry callStackEntry) throws MIRException {
            return this.imvProcessor.resolveParameters(mIRElement, string, callStackEntry, null);
        }

        public int getTransformationExpressionDbType(MIRFeatureMap mIRFeatureMap) {
            return this.imvProcessor.getTransformationExpressionDbType(mIRFeatureMap);
        }

        public int getTransformationExpressionDbType(MIRClassifierMap mIRClassifierMap) {
            return this.imvProcessor.getTransformationExpressionDbType(mIRClassifierMap);
        }

        private EtlFeatureExpressionParser getEtlFeatureExpressionParser(int n) {
            EtlFeatureExpressionParser etlFeatureExpressionParser;
            if (this.imvEtlParsers == null) {
                this.imvEtlParsers = new HashMap();
            }
            if ((etlFeatureExpressionParser = this.imvEtlParsers.get(n)) == null) {
                etlFeatureExpressionParser = this.createEltExpressionParser(n);
                this.imvEtlParsers.put(n, etlFeatureExpressionParser);
            }
            return etlFeatureExpressionParser;
        }

        protected EtlFeatureExpressionParser createEltExpressionParser(int n) {
            return new EtlFeatureExpressionParser(this.imvProcessor, this.imvParserType, n);
        }

        private EtlSqlParser getSqlExpressionParser(int n, String string) {
            EtlSqlParser etlSqlParser;
            if (this.imvSqlParsers == null) {
                this.imvSqlParsers = new HashMap();
            }
            if ((etlSqlParser = this.imvSqlParsers.get(n)) == null) {
                etlSqlParser = this.createEtlSqlParser(n, string);
                this.imvSqlParsers.put(n, etlSqlParser);
            }
            return etlSqlParser;
        }

        protected EtlSqlParser createEtlSqlParser(int n, String string) {
            return new EtlSqlParser(this.imvProcessor, this, this.imvParserType, n, string);
        }

        protected MappingExpressionParser getMappingExpressionParser(MIRFeatureMap mIRFeatureMap) {
            return this.imvProcessor.getMappingExpressionParser(mIRFeatureMap);
        }

        protected SqlQueryClassifierMapParser SqlQueryClassifierMapParser(MIRClassifierMap mIRClassifierMap) throws MIRException {
            MIRModel mIRModel = mIRClassifierMap.getRootModel();
            if (!(mIRModel instanceof MIRDiModel)) {
                throw new MIRException("Di model is expected.");
            }
            if (this.imvSqlQueryClassMapParser == null) {
                this.imvSqlQueryClassMapParser = new SqlQueryClassifierMapParser((MIRDiModel)mIRModel, this.imvParserType, this.getTransformationExpressionDbType(mIRClassifierMap));
            } else {
                this.imvSqlQueryClassMapParser.init((MIRDiModel)mIRModel, null);
            }
            return this.imvSqlQueryClassMapParser;
        }

        public String getDefaultRelationalStoreType() {
            return this.imvProcessor.getDefaultRelationalStoreType();
        }

        public String getRelationalStoreType(MIRConnectedTransformation mIRConnectedTransformation) {
            return this.imvProcessor.getRelationalStoreType(mIRConnectedTransformation);
        }

        public String getRelationalStoreType(MIRSqlQuery mIRSqlQuery) {
            return this.imvProcessor.getRelationalStoreType(mIRSqlQuery);
        }

        protected int getModelProfileId(MIRModel mIRModel) {
            return this.imvProcessor.getModelProfileId(mIRModel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MIRStoreModel getStoreModel(MIRContent mIRContent, String string, String string2, boolean bl, MIRTransformation mIRTransformation, CallStackEntry callStackEntry) throws MIRException {
            MIRDirectoryStructureModel mIRDirectoryStructureModel = this.imvDirectory;
            synchronized (mIRDirectoryStructureModel) {
                Object object;
                MIRStoreContent mIRStoreContent;
                Object object2;
                Object object32;
                Object object5;
                if (mIRContent.isInstanceOf((short)278)) {
                    object5 = this.imvDesignConnections.get(string);
                    if (object5 != null) {
                        return object5;
                    }
                } else {
                    object5 = this.imvDirectory.getConnectionStoreContent(string);
                    if (object5 != null) {
                        return (MIRStoreModel)this.imvProcessor.loadModel((MIRContent)object5);
                    }
                }
                if (mIRContent.isInstanceOf((short)278)) {
                    object5 = this.imvDirectory.getConnectionStoreContent(string);
                    if (object5 != null) {
                        return (MIRStoreModel)this.imvProcessor.loadModel((MIRContent)object5);
                    }
                } else if (mIRContent.isInstanceOf((short)283)) {
                    for (MIRStoreContent object42 : this.imvDirectory.getConnectionStoreContents()) {
                        object32 = this.resolveParameters(mIRTransformation, object42.getName(), callStackEntry);
                        if (!((String)object32).equals(string)) continue;
                        MIRStoreContent mIRStoreContent2 = this.imvDirectory.getConnectionStoreContent((String)object32);
                        if (mIRStoreContent2 != null) {
                            MIRStoreModel mIRStoreModel = (MIRStoreModel)this.imvProcessor.loadModel(mIRStoreContent2);
                            return mIRStoreModel;
                        }
                        MIRStoreModel mIRStoreModel = (MIRStoreModel)this.imvProcessor.loadModel(object42);
                        mIRStoreModel.setDescription(mIRStoreModel.getName());
                        mIRStoreModel.setName((String)object32);
                        mIRStoreModel.setSystemType(MIRConnectionManager.getInstance().getType(mIRStoreModel.getName(), mIRStoreModel.getSystemType()));
                        object42.setName((String)object32);
                        return mIRStoreModel;
                    }
                    for (MIRStoreContent mIRStoreContent3 : this.imvDirectory.getConnectionStoreContents()) {
                        object32 = (MIRStoreModel)this.imvProcessor.loadModel(mIRStoreContent3);
                        object2 = ((MIRElement)object32).getDescription();
                        if (((String)object2).isEmpty() || !((String)(object2 = this.resolveParameters((MIRElement)object32, (String)object2, callStackEntry))).equals(string)) continue;
                        MIRStoreContent mIRStoreContent4 = this.imvDirectory.getConnectionStoreContent((String)object2);
                        if (mIRStoreContent4 != null) {
                            MIRStoreModel mIRStoreModel = (MIRStoreModel)this.imvProcessor.loadModel(mIRStoreContent4);
                            return mIRStoreModel;
                        }
                        MIRStoreContent mIRStoreContent5 = new MIRStoreContent();
                        mIRStoreContent5.setName((String)object2);
                        this.imvDirectory.addConnectionStoreContent(mIRStoreContent5);
                        MIRStoreModel mIRStoreModel = new MIRStoreModel((MIRStoreModel)object32);
                        mIRStoreModel.setName((String)object2);
                        mIRStoreModel.setFrom((MIR_Object)object32);
                        mIRStoreModel.setDesignLevel((byte)2);
                        mIRStoreContent5.addModel(mIRStoreModel);
                        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
                        mIRStoreModel.addMetadataOrigin(mIRMetadataOrigin);
                        if (((MIRModel)object32).getMetadataOrigin() != null) {
                            mIRMetadataOrigin.setFrom(((MIRModel)object32).getMetadataOrigin());
                        } else if (this.imvDirectory.getMetadataOrigin() != null) {
                            mIRMetadataOrigin.setFrom(this.imvDirectory.getMetadataOrigin());
                        }
                        int n = this.getModelProfileId((MIRModel)object32);
                        if (n >= 0) {
                            mIRMetadataOrigin.setProfileId(n);
                        }
                        mIRStoreModel.setSystemType(MIRConnectionManager.getInstance().getType(mIRStoreModel.getName(), mIRStoreModel.getSystemType()));
                        return mIRStoreModel;
                    }
                }
                object5 = null;
                if (!string2.isEmpty()) {
                    for (Object object32 : this.imvDirectory.getConnectionStoreContents()) {
                        if (!((MIRObject)object32).getName().equals(string2)) continue;
                        object5 = object2 = (MIRStoreModel)this.imvProcessor.loadModel((MIRContent)object32);
                        break;
                    }
                }
                if ((mIRStoreContent = this.imvDirectory.getConnectionStoreContent(string)) != null) {
                    object32 = (MIRStoreModel)this.imvProcessor.loadModel(mIRStoreContent);
                    return object32;
                }
                object32 = new MIRStoreContent();
                ((MIRObject)object32).setName(string);
                object2 = new MIRStoreModel();
                ((MIRContent)object32).addModel((MIRModel)object2);
                MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
                ((MIRModel)object2).addMetadataOrigin(mIRMetadataOrigin);
                if (object5 != null) {
                    ((MIRStoreModel)object2).setFrom((MIR_Object)object5);
                    ((MIRObject)object2).setName(string);
                    if (((MIRModel)object5).getMetadataOrigin() != null) {
                        mIRMetadataOrigin.setFrom(((MIRModel)object5).getMetadataOrigin());
                    } else if (this.imvDirectory.getMetadataOrigin() != null) {
                        mIRMetadataOrigin.setFrom(this.imvDirectory.getMetadataOrigin());
                    }
                    object = ((MIRModel)object5).getContent();
                    if (mIRContent.isInstanceOf((short)278) && this.imvDesignConnections.size() > 0) {
                        if (((MIRFolderContent)object).getFolder() != null) {
                            ((MIRFolderContent)object).getFolder().addFolderContentUniqueName((MIRFolderContent)object32);
                        } else {
                            this.imvDirectory.addFolderContentUniqueName((MIRFolderContent)object32);
                        }
                    } else {
                        this.imvDirectory.addConnectionStoreContent((MIRStoreContent)object32);
                    }
                } else {
                    ((MIRObject)object2).setName(string);
                    if (bl) {
                        object = this.getDefaultRelationalStoreType();
                        ((MIRStoreModel)object2).setStoreType((byte)0);
                        if (mIRTransformation != null && mIRTransformation.isInstanceOf((short)220)) {
                            object = this.getRelationalStoreType((MIRConnectedTransformation)mIRTransformation);
                        } else if (mIRTransformation != null && mIRTransformation.isInstanceOf((short)318)) {
                            object = this.getRelationalStoreType((MIRSqlQuery)mIRTransformation);
                        }
                        MIRStoreConnection mIRStoreConnection = mIRTransformation.getDiModel().getStoreConnection(string);
                        if (mIRStoreConnection != null && ((String)object).equals(this.getDefaultRelationalStoreType()) && !mIRStoreConnection.getSystemType().isEmpty()) {
                            object = mIRStoreConnection.getSystemType();
                        }
                        ((MIRSystemPackage)object2).setSystemType((String)object);
                    } else {
                        ((MIRStoreModel)object2).setStoreType((byte)2);
                        ((MIRSystemPackage)object2).setSystemType("FILE");
                    }
                    if (this.imvDirectory.getMetadataOrigin() != null) {
                        mIRMetadataOrigin.setFrom(this.imvDirectory.getMetadataOrigin());
                    }
                    if (mIRContent.isInstanceOf((short)278) && this.imvDesignConnections.size() > 0) {
                        this.imvDirectory.addFolderContentUniqueName((MIRFolderContent)object32);
                        this.imvDesignConnections.put(((MIRObject)object2).getName(), (MIRStoreModel)object2);
                    } else {
                        this.imvDirectory.addConnectionStoreContent((MIRStoreContent)object32);
                    }
                }
                int n = this.getModelProfileId((MIRModel)object2);
                if (n >= 0) {
                    mIRMetadataOrigin.setProfileId(n);
                }
                ((MIRModelObject)object2).setDesignLevel((byte)2);
                ((MIRSystemPackage)object2).setSystemType(MIRConnectionManager.getInstance().getType(((MIRObject)object2).getName(), ((MIRSystemPackage)object2).getSystemType()));
                return object2;
            }
        }

        public MIRStoreConnection getStoreConnection(MIRDiModel mIRDiModel, String string, String string2, StringBuilder stringBuilder, boolean bl, byte by, MIRConnectedTransformation mIRConnectedTransformation, CallStackEntry callStackEntry) throws MIRException {
            MIRObject mIRObject;
            MIRContent mIRContent = mIRDiModel.getContent();
            String string3 = string2;
            String string4 = string2;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            MIRStoreConnection mIRStoreConnection = mIRDiModel.getStoreConnection(string2);
            MIRStoreConnection mIRStoreConnection2 = null;
            if (mIRStoreConnection != null) {
                string6 = MIRConnectionManager.getConnectionName(mIRStoreConnection);
                string8 = MIRConnectionManager.getServerName(mIRStoreConnection);
                string5 = MIRConnectionManager.getCatalogName(mIRStoreConnection);
                string7 = MIRConnectionManager.getSchemaName(mIRStoreConnection);
            }
            if (bl) {
                string3 = string6 == null || string6.isEmpty() ? string2 : string6;
                string4 = string3 = MIRConnectionManager.getInstance().getFormattedConnectionName(string.isEmpty() && string5 != null ? string5 : string, stringBuilder.toString(), string3, false);
            }
            if ((mIRStoreConnection2 = mIRDiModel.getStoreConnection(string3)) == null) {
                MIRConnection mIRConnection;
                MIRContent mIRContent2;
                mIRStoreConnection2 = new MIRStoreConnection();
                mIRStoreConnection2.setName(string3);
                mIRDiModel.addStoreConnection(mIRStoreConnection2);
                mIRObject = this.getStoreModel(mIRContent, string4, string2, bl, mIRConnectedTransformation, callStackEntry);
                mIRStoreConnection2.setStoreType(((MIRStoreModel)mIRObject).getStoreType());
                mIRStoreConnection2.setSystemType(MIRConnectionManager.getInstance().getType(mIRStoreConnection2.getName(), ((MIRSystemPackage)mIRObject).getSystemType()));
                if (mIRStoreConnection != null) {
                    ModelProcessor.copyConnectionProperties(mIRStoreConnection, mIRStoreConnection2, true);
                }
                if (string6 != null && !string6.isEmpty()) {
                    MIRConnectionManager.setConnectionName(mIRStoreConnection2, string6);
                } else {
                    MIRConnectionManager.setConnectionName(mIRStoreConnection2, string2);
                }
                ModelProcessor.synchronizeConnectionProperties(mIRStoreConnection2, (MIRSystemPackage)mIRObject);
                if (string != null && string.length() > 0) {
                    MIRConnectionManager.setCatalogName(mIRStoreConnection2, string.toString());
                }
                if (stringBuilder != null && stringBuilder.length() > 0) {
                    MIRConnectionManager.setSchemaName(mIRStoreConnection2, stringBuilder.toString());
                }
                if ((mIRContent2 = mIRDiModel.getContent()) != null && ((mIRConnection = mIRContent2.getClientOfConnection(string3)) == null || mIRConnection.getClientContent() != mIRContent2)) {
                    MIRStoreContent mIRStoreContent = (MIRStoreContent)((MIRModel)mIRObject).getContent();
                    assert (mIRStoreContent != null);
                    assert (mIRStoreContent.isInstanceOf((short)295));
                    MIRConnection mIRConnection2 = new MIRConnection();
                    mIRConnection2.addClientContent(mIRContent2);
                    mIRConnection2.addSupplierStoreContent(mIRStoreContent);
                    mIRConnection2.setName(string3);
                }
            }
            assert (mIRStoreConnection2 != null);
            mIRObject = mIRContent.getClientOfConnection(string3);
            if (mIRObject != null && by != ((MIRConnection)mIRObject).getUsage() && ((MIRConnection)mIRObject).getUsage() != 2) {
                ((MIRConnection)mIRObject).setUsage((byte)2);
            }
            return mIRStoreConnection2;
        }

        public String processFlatFileQuery(MIRClassifierMap mIRClassifierMap) {
            return this.imvProcessor.processFlatFileQuery(mIRClassifierMap);
        }

        public static void synchronizeConnectionProperties(MIRSystemPackage mIRSystemPackage, MIRSystemPackage mIRSystemPackage2) {
            ModelProcessor.copyConnectionProperties(mIRSystemPackage, mIRSystemPackage2, true);
            ModelProcessor.copyConnectionProperties(mIRSystemPackage2, mIRSystemPackage, true);
        }

        public static void copyConnectionProperties(MIRSystemPackage mIRSystemPackage, MIRSystemPackage mIRSystemPackage2, boolean bl) {
            String string = MIRConnectionManager.getConnectionName(mIRSystemPackage);
            String string2 = MIRConnectionManager.getServerName(mIRSystemPackage);
            String string3 = MIRConnectionManager.getCatalogName(mIRSystemPackage);
            String string4 = MIRConnectionManager.getSchemaName(mIRSystemPackage);
            String string5 = MIRConnectionManager.getConnectionName(mIRSystemPackage2);
            String string6 = MIRConnectionManager.getServerName(mIRSystemPackage2);
            String string7 = MIRConnectionManager.getCatalogName(mIRSystemPackage2);
            String string8 = MIRConnectionManager.getSchemaName(mIRSystemPackage2);
            if (string != null && (string5 == null || bl && string5.isEmpty())) {
                MIRConnectionManager.setConnectionName(mIRSystemPackage2, string);
            }
            if (string2 != null && (string6 == null || bl && string6.isEmpty())) {
                MIRConnectionManager.getInstance().setServerName(mIRSystemPackage2, string2);
            }
            if (string3 != null && (string7 == null || bl && string7.isEmpty())) {
                MIRConnectionManager.setCatalogName(mIRSystemPackage2, string3);
            }
            if (string4 != null && (string8 == null || bl && string8.isEmpty())) {
                MIRConnectionManager.setSchemaName(mIRSystemPackage2, string4);
            }
        }

        private MIRConnectionDataSet getConnectionDataSet(MIRClassifierMap mIRClassifierMap) {
            MIRConnectedTransformation mIRConnectedTransformation = (MIRConnectedTransformation)mIRClassifierMap.getTransformation();
            SortedSet<MIRClassifier> sortedSet = null;
            MIRConnectionDataSet mIRConnectionDataSet = null;
            if (mIRConnectedTransformation.isInstanceOf((short)260)) {
                if (mIRClassifierMap.getDestinationClassifier() != null && mIRClassifierMap.getDestinationClassifier().isInstanceOf((short)254)) {
                    mIRConnectionDataSet = (MIRConnectionDataSet)mIRClassifierMap.getDestinationClassifier();
                }
            } else if (mIRConnectedTransformation.isInstanceOf((short)241)) {
                if (((MIRLookupTransformation)mIRConnectedTransformation).getDataTransformationDataSet() != null) {
                    MIRClassifierMap mIRClassifierMap2 = ((MIRLookupTransformation)mIRConnectedTransformation).getDataTransformationDataSet().getDestinationOfClassifierMap();
                    if (mIRClassifierMap2 != null) {
                        sortedSet = mIRClassifierMap2.getSourceClassifiers();
                    }
                } else if (((MIRLookupTransformation)mIRConnectedTransformation).getConnectionDataSets() != null) {
                    mIRConnectionDataSet = ((MIRLookupTransformation)mIRConnectedTransformation).getConnectionDataSets().first();
                }
            } else {
                sortedSet = mIRClassifierMap.getSourceClassifiers();
            }
            if (sortedSet != null) {
                for (MIRClassifier mIRClassifier : sortedSet) {
                    if (!mIRClassifier.isInstanceOf((short)254)) continue;
                    mIRConnectionDataSet = (MIRConnectionDataSet)mIRClassifier;
                    break;
                }
            }
            if (mIRConnectionDataSet == null && mIRConnectedTransformation.isInstanceOf((short)238)) {
                mIRConnectionDataSet = (MIRConnectionDataSet)mIRClassifierMap.getDestinationClassifier();
            }
            return mIRConnectionDataSet;
        }

        private void parseTableNameExpression(MIRClassifierMap mIRClassifierMap, MIRContent mIRContent, String string, CallStackEntry callStackEntry) throws MIRException {
            MIRConnectionDataSet mIRConnectionDataSet;
            MIRDiModel mIRDiModel = (MIRDiModel)mIRClassifierMap.getRootModel();
            MIRConnectedTransformation mIRConnectedTransformation = (MIRConnectedTransformation)mIRClassifierMap.getTransformation();
            String string2 = string;
            MIRStoreModel mIRStoreModel = this.getStoreModel(mIRContent, string2, "", true, mIRConnectedTransformation, callStackEntry);
            String string3 = mIRStoreModel.getSystemType();
            EtlSqlParser etlSqlParser = this.getSqlExpressionParser(MIRExpressionAnalyzer.getExpressionDatabaseType(string3), string3);
            assert (etlSqlParser.getParserType() == this.imvParserType);
            boolean bl = false;
            if (mIRConnectedTransformation.isInstanceOf((short)220)) {
                bl = mIRConnectedTransformation.getPositionBasedQuery();
            }
            etlSqlParser.setTransformation(mIRConnectedTransformation, string2, bl, callStackEntry);
            boolean bl2 = true;
            if (mIRConnectedTransformation.isInstanceOf((short)260)) {
                bl2 = false;
            } else if (mIRConnectedTransformation.isInstanceOf((short)238)) {
                mIRConnectionDataSet = this.getConnectionDataSet(mIRClassifierMap);
                if (mIRConnectionDataSet != null) {
                    bl2 = mIRClassifierMap.getSourceClassifier(mIRConnectionDataSet.getName()) != null;
                } else if (mIRClassifierMap.getSourceClassifierCount() == 0 && mIRClassifierMap.getSourceClassifierCount() == 0) {
                    bl2 = false;
                }
            }
            mIRConnectionDataSet = this.getConnectionDataSet(mIRClassifierMap);
            String string4 = mIRClassifierMap.getOperation();
            StringBuilder stringBuilder = new StringBuilder();
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            MIRConnectionPackage mIRConnectionPackage = etlSqlParser.getDataSetSchema(mIRDiModel, string4, stringBuilder, atomicBoolean, bl2 ? (byte)0 : 1);
            MIRConnectionDataSet mIRConnectionDataSet2 = null;
            if (mIRConnectionDataSet == null) {
                mIRConnectionDataSet2 = etlSqlParser.getDataSet(mIRConnectionPackage, stringBuilder.toString(), false);
                if (bl2) {
                    mIRClassifierMap.addSourceClassifier(mIRConnectionDataSet2);
                } else {
                    mIRClassifierMap.addDestinationClassifier(mIRConnectionDataSet2);
                }
            } else {
                if (!bl2 && stringBuilder.toString().isEmpty()) {
                    ETLLIB.WRN_CLASSIFIER_NAME_EMPTY.log(mIRClassifierMap.getPath(true), mIRClassifierMap.getOperation());
                    return;
                }
                mIRConnectionDataSet2 = mIRConnectionDataSet;
                mIRConnectionDataSet.setName(stringBuilder.toString());
                mIRConnectionDataSet.setPhysicalName("");
            }
            if (mIRConnectionPackage != null && mIRConnectionDataSet != null && mIRConnectionDataSet.getConnectionDataPackage() == null) {
                mIRConnectionPackage.addClassifier(mIRConnectionDataSet);
                if (mIRClassifierMap.containsSourceClassifier(mIRConnectionDataSet)) {
                    for (MIRClassifier mIRClassifier : mIRClassifierMap.getSourceClassifiers()) {
                        if (!mIRClassifier.isInstanceOf((short)254) || ((MIRConnectionDataSet)mIRClassifier).getConnectionDataPackage() != null) continue;
                        mIRConnectionPackage.addClassifier(mIRClassifier);
                    }
                }
            }
            if (mIRConnectionDataSet2 != null) {
                etlSqlParser.setCollationLineageOption(mIRConnectionDataSet2, atomicBoolean.get());
            }
        }

        private void printMissedParamters(MIRElement mIRElement) {
            for (MIRUsedParameter mIRUsedParameter : mIRElement.getUsesUsedParameters()) {
                if (!mIRUsedParameter.getValue().isEmpty()) continue;
                String string = mIRUsedParameter.getName();
                ETLLIB.WRN_CANT_PARSE_EMPTY_PARAM.log(MIRLogger.getLogger(), mIRUsedParameter.getName());
                ArrayList<String> arrayList = this.imvProcessor.gsvLoggedEmptyParams.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.imvProcessor.gsvLoggedEmptyParams.put(string, arrayList);
                }
                if (mIRUsedParameter.getNativeType().equals(DesignTreeProcessor.OPTIONAL_PARAMETER_TAG)) continue;
                arrayList.add(mIRElement.getPath());
            }
        }

        boolean updateUserDefinedQuery(MIRClassifierMap mIRClassifierMap, MIRContent mIRContent) {
            boolean bl = false;
            MIRConnectedTransformation mIRConnectedTransformation = (MIRConnectedTransformation)mIRClassifierMap.getTransformation();
            if ((this.imvProcessor.getSqlOverrideType() == SqlOverrideType.SQL || this.imvProcessor.getSqlOverrideType() == SqlOverrideType.BOTH) && !mIRConnectedTransformation.getUserDefinedQuery() && mIRContent.isInstanceOf((short)283)) {
                String string = !mIRClassifierMap.getDescription().isEmpty() ? mIRClassifierMap.getDescription() : mIRClassifierMap.getOperation();
                MIRUsedParameter mIRUsedParameter = mIRClassifierMap.getUsesUsedParameter(string);
                MIRParameterDefinition mIRParameterDefinition = mIRConnectedTransformation.getDiModel().getParameterDefinition(string);
                if (mIRUsedParameter != null && mIRParameterDefinition != null && !mIRUsedParameter.getValue().equals(mIRParameterDefinition.getValue())) {
                    mIRConnectedTransformation.setUserDefinedQuery(true);
                    bl = true;
                    MIRConnectionDataSet mIRConnectionDataSet = this.getConnectionDataSet(mIRClassifierMap);
                    if (mIRConnectionDataSet != null) {
                        for (MIRFeature mIRFeature : mIRConnectionDataSet.getFeatures()) {
                            if (mIRFeature.getDestinationOfFeatureMap() == null) continue;
                            mIRFeature.getDestinationOfFeatureMap().delete();
                        }
                        mIRConnectionDataSet.delete();
                    }
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void parseExpression(MIRClassifierMap mIRClassifierMap, MIRContent mIRContent, String string, CallStackEntry callStackEntry) throws MIRException {
            boolean bl;
            this.imvParsedMap = mIRClassifierMap;
            MIRDiModel mIRDiModel = (MIRDiModel)mIRClassifierMap.getRootModel();
            MIRConnectedTransformation mIRConnectedTransformation = (MIRConnectedTransformation)mIRClassifierMap.getTransformation();
            String string2 = string;
            boolean bl2 = true;
            MIRConnectionNamespace mIRConnectionNamespace = null;
            String string3 = this.processFlatFileQuery(mIRClassifierMap);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            if (mIRConnectedTransformation.getFlatFileDescriptor() != null) {
                bl2 = false;
                if (string3 != null && !string.equals(string3) && (string.endsWith("\\") || string.endsWith("/"))) {
                    string = string + string3;
                }
                string = MIRConnectionManager.getInstance().mapPath(string, false);
                while (string.endsWith("\\") || string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                    bl3 = true;
                }
                mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(mIRDiModel, string, stringBuilder);
                if (mIRConnectionNamespace != null) {
                    string2 = MIRBridgeLib.getStoreConnection(mIRConnectionNamespace).getName();
                    if (stringBuilder.length() == 0 && string3 != null) {
                        stringBuilder.append(string3);
                    }
                }
            }
            MIRStoreModel mIRStoreModel = this.getStoreModel(mIRContent, string2, "", bl2, mIRConnectedTransformation, callStackEntry);
            String string4 = mIRStoreModel.getSystemType();
            boolean bl4 = bl = ((MIRConnectedTransformation)mIRClassifierMap.getTransformation()).getUserDefinedQuery() && mIRConnectionNamespace != null;
            if (bl || mIRConnectedTransformation.getFlatFileDescriptor() == null && !string4.toUpperCase().endsWith("FILE")) {
                this.updateUserDefinedQuery(mIRClassifierMap, mIRContent);
                boolean bl5 = this.imvProcessor.isOperationTableName(mIRClassifierMap);
                if (bl5) {
                    this.parseTableNameExpression(mIRClassifierMap, mIRContent, string, callStackEntry);
                    mIRClassifierMap.setDescription("");
                    mIRClassifierMap.setOperation("");
                    return;
                }
                MIRClassifier mIRClassifier = mIRClassifierMap.getDestinationClassifier();
                if (mIRClassifier == null) {
                    if (mIRConnectedTransformation.isInstanceOf((short)260)) {
                        mIRClassifier = new MIRConnectionDataSet();
                        mIRClassifier.setName(mIRConnectedTransformation.getName());
                        ((MIRWriterTransformation)mIRConnectedTransformation).addConnectionDataSet((MIRConnectionDataSet)mIRClassifier);
                    } else if (mIRConnectedTransformation.isInstanceOf((short)238)) {
                        mIRClassifier = new MIRConnectionDataSet();
                        mIRClassifier.setName(mIRConnectedTransformation.getName());
                        ((MIRGenericConnectedTransformation)mIRConnectedTransformation).addConnectionDataSet((MIRConnectionDataSet)mIRClassifier);
                    } else {
                        throw new MIRException(ETLLIB.ERR_UNSUPPORTED_OPERATION_IN_TRANSFORMATION.getMessage(mIRConnectedTransformation.getPath()));
                    }
                    mIRClassifierMap.addDestinationClassifier(mIRClassifier);
                }
                boolean bl6 = false;
                if (mIRConnectedTransformation.isInstanceOf((short)220)) {
                    bl6 = mIRConnectedTransformation.getPositionBasedQuery();
                }
                EtlSqlParser etlSqlParser = this.getSqlExpressionParser(MIRExpressionAnalyzer.getExpressionDatabaseType(string4), string4);
                assert (etlSqlParser.getParserType() == this.imvParserType);
                etlSqlParser.setTransformation(mIRConnectedTransformation, string2, bl6, callStackEntry);
                if (mIRConnectionNamespace != null) {
                    etlSqlParser.setSourceFileDataPackage(mIRConnectionNamespace);
                }
                if (!etlSqlParser.parse(mIRClassifierMap) && mIRContent.isInstanceOf((short)283)) {
                    this.printMissedParamters(mIRClassifierMap);
                }
                if (etlSqlParser.getAdditionClassifierMaps() != null) {
                    for (MIRClassifierMap mIRClassifierMap2 : etlSqlParser.getAdditionClassifierMaps()) {
                        if (etlSqlParser.parse(mIRClassifierMap2) || !mIRContent.isInstanceOf((short)283)) continue;
                        this.printMissedParamters(mIRClassifierMap2);
                    }
                }
            } else {
                boolean bl7;
                MIRTransformation mIRTransformation = mIRClassifierMap.getTransformation();
                if (!mIRTransformation.isInstanceOf((short)220)) {
                    throw new MIRException(ETLLIB.ERR_UNSUPPORTED_OPERATION_IN_TRANSFORMATION.getMessage(mIRTransformation.getPath()));
                }
                MIRConnectedTransformation mIRConnectedTransformation2 = (MIRConnectedTransformation)mIRTransformation;
                MIRClassifier mIRClassifier = DesignTreeProcessor.getConnectedTransformationClassifier(mIRClassifierMap, mIRConnectedTransformation2);
                boolean bl5 = bl7 = mIRClassifierMap.getDestinationClassifier() == mIRClassifier;
                if (mIRClassifier != null && mIRConnectionNamespace != null) {
                    MIRClassifier mIRClassifier2;
                    MIRConnectionDataSet mIRConnectionDataSet = null;
                    if (bl7) {
                        mIRClassifier2 = null;
                        for (MIRClassifier mIRClassifier3 : mIRClassifierMap.getSourceClassifiers()) {
                            if (!mIRClassifier3.isInstanceOf((short)254) || mIRClassifier2 != null && mIRClassifier3.getParent() != mIRClassifierMap.getParent()) continue;
                            mIRClassifier2 = mIRClassifier3;
                        }
                        if (mIRClassifier2 == null || !mIRClassifier2.isInstanceOf((short)254)) {
                            mIRConnectionDataSet = new MIRConnectionDataSet();
                            mIRClassifierMap.addSourceClassifier(mIRConnectionDataSet);
                            mIRConnectedTransformation2.addConnectionDataSet(mIRConnectionDataSet);
                        } else {
                            mIRConnectionDataSet = (MIRConnectionDataSet)mIRClassifier2;
                        }
                    } else {
                        mIRClassifier2 = mIRClassifierMap.getDestinationClassifier();
                        if (mIRClassifier2 == null || !mIRClassifier2.isInstanceOf((short)254)) {
                            mIRConnectionDataSet = new MIRConnectionDataSet();
                            mIRClassifierMap.addDestinationClassifier(mIRConnectionDataSet);
                            mIRConnectedTransformation2.addConnectionDataSet(mIRConnectionDataSet);
                        } else {
                            mIRConnectionDataSet = (MIRConnectionDataSet)mIRClassifier2;
                        }
                    }
                    mIRClassifier2 = mIRConnectionDataSet;
                    synchronized (mIRClassifier2) {
                        byte by;
                        mIRConnectionDataSet.setName(stringBuilder.toString());
                        mIRConnectionDataSet.setPhysicalName(stringBuilder.toString());
                        if (mIRConnectionDataSet.getName().isEmpty()) {
                            mIRConnectionDataSet.setName("?");
                        }
                        if (bl3) {
                            mIRConnectionDataSet.setLineageOption(16384);
                        }
                        if (mIRConnectionDataSet.getImportedByPackageCount() == 0 && !mIRConnectionNamespace.containsClassifier(mIRConnectionDataSet)) {
                            mIRConnectionNamespace.addClassifier(mIRConnectionDataSet);
                        }
                        MIRConnection mIRConnection = mIRDiModel.getContent().getClientOfConnection(string2);
                        byte by2 = by = bl7 ? (byte)0 : 1;
                        if (mIRConnection != null && by != mIRConnection.getUsage() && mIRConnection.getUsage() != 2) {
                            mIRConnection.setUsage((byte)2);
                        }
                        boolean bl9 = false;
                        for (MIRFeature mIRFeature : mIRConnectionDataSet.getFeatures()) {
                            if (!bl7 && mIRFeature.getDestinationOfFeatureMap() != null) {
                                bl9 = true;
                            } else if (bl7 && mIRFeature.getSourceOfFeatureMapCount() > 0) {
                                for (MIRFeatureMap mIRElement : mIRFeature.getSourceOfFeatureMaps()) {
                                    if (mIRElement.getDestinationFeature().getClassifier() != mIRClassifier) continue;
                                    bl9 = true;
                                    break;
                                }
                            }
                            if (!bl9) continue;
                            break;
                        }
                        List<MIRFeature> list = mIRClassifier.getFeatureByPosition();
                        short s = 1;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            boolean bl6;
                            MIRFeature mIRFeature = (MIRFeature)iterator.next();
                            if (mIRFeature.isInstanceOf((short)84) || mIRFeature.getPosition() < 0) continue;
                            MIRConnectionDataAttribute mIRConnectionDataAttribute = (MIRConnectionDataAttribute)mIRConnectionDataSet.getFeature(MIRBridgeLib.getPhysicalName(mIRFeature));
                            if (mIRConnectionDataAttribute == null) {
                                if (bl9) continue;
                                mIRConnectionDataAttribute = new MIRConnectionDataAttribute();
                                mIRConnectionDataAttribute.setName(MIRBridgeLib.getPhysicalName(mIRFeature));
                                mIRConnectionDataAttribute.setLineageOption(mIRFeature.getLineageOptions());
                                for (MIRPropertyValue mIRPropertyValue : mIRFeature.getPropertyValues()) {
                                    MIRPropertyType mIRPropertyType = mIRPropertyValue.getPropertyType();
                                    if (mIRPropertyValue.getPropertyType() == null) continue;
                                    MIRPropertyType mIRPropertyType2 = MIRUdpLib.fetchPropertyType(mIRDiModel, mIRConnectionDataAttribute.getElementType(), mIRPropertyValue.getName(), mIRPropertyType.getDesignLevel(), mIRPropertyType.getUsage(), mIRPropertyType.getGroup(), mIRPropertyType.getDataType(), true);
                                    MIRUdpLib.setPropertyValue(mIRPropertyType2, mIRPropertyValue.getValue(), mIRConnectionDataAttribute);
                                    mIRPropertyType2.setInitialValue(mIRPropertyType.getInitialValue());
                                }
                                mIRConnectionDataSet.addFeature(mIRConnectionDataAttribute);
                            }
                            boolean bl8 = bl6 = mIRConnectedTransformation.getFlatFileDescriptor() != null && mIRConnectedTransformation.getFlatFileDescriptor().isInstanceOf((short)325);
                            if (bl6) {
                                if (mIRConnectionDataAttribute.hasLineageOption(256)) {
                                    mIRConnectionDataAttribute.setLineageOption(0);
                                } else if (mIRConnectionDataAttribute.getPosition() < 1) {
                                    short s2 = s;
                                    s = (short)(s + 1);
                                    mIRConnectionDataAttribute.setPosition(s2);
                                }
                            } else {
                                mIRConnectionDataAttribute.setPosition(mIRFeature.getPosition());
                            }
                            if (bl9) continue;
                            if (mIRFeature.getType() != null && mIRConnectionDataAttribute.getType() == null) {
                                mIRConnectionDataAttribute.addType(mIRFeature.getType());
                            }
                            if (bl7) {
                                DesignTreeProcessor.linkAttributes(mIRConnectionDataAttribute, mIRFeature, mIRClassifierMap);
                                continue;
                            }
                            DesignTreeProcessor.linkAttributes(mIRFeature, mIRConnectionDataAttribute, mIRClassifierMap);
                        }
                    }
                }
            }
            this.imvParsedMap = null;
        }

        private void parseExpression(MIRFeatureMap mIRFeatureMap) throws MIRException {
            MIRModel mIRModel;
            MIRContent mIRContent;
            this.imvParsedMap = mIRFeatureMap;
            EtlFeatureExpressionParser etlFeatureExpressionParser = this.getEtlFeatureExpressionParser(this.getTransformationExpressionDbType(mIRFeatureMap));
            assert (etlFeatureExpressionParser.getParserType() == this.imvParserType);
            etlFeatureExpressionParser.setTransfomation(mIRFeatureMap.getClassifierMap().getTransformation());
            if (!etlFeatureExpressionParser.parse(mIRFeatureMap) && (mIRContent = (mIRModel = mIRFeatureMap.getRootModel()).getContent()).isInstanceOf((short)283)) {
                this.printMissedParamters(mIRFeatureMap);
            }
            this.imvParsedMap = null;
        }

        protected void parseMappingExpression(MIRFeatureMap mIRFeatureMap) throws MIRException {
            MIRModel mIRModel;
            MIRContent mIRContent;
            this.imvParsedMap = mIRFeatureMap;
            MappingExpressionParser mappingExpressionParser = this.getMappingExpressionParser(mIRFeatureMap);
            if (!mappingExpressionParser.parse(mIRFeatureMap) && (mIRContent = (mIRModel = mIRFeatureMap.getRootModel()).getContent()).isInstanceOf((short)283)) {
                this.printMissedParamters(mIRFeatureMap);
            }
            this.imvParsedMap = null;
        }

        private void parseSqlQueryClassMap(MIRClassifierMap mIRClassifierMap) throws MIRException {
            SqlQueryClassifierMapParser sqlQueryClassifierMapParser = this.SqlQueryClassifierMapParser(mIRClassifierMap);
            sqlQueryClassifierMapParser.parse(mIRClassifierMap);
        }

        protected MIRCondition findCondition(MIRClassifier mIRClassifier) {
            for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                if (!mIRFeature.isInstanceOf((short)84)) continue;
                return (MIRCondition)mIRFeature;
            }
            return null;
        }

        protected void processEmbeddedTransformationConnections(MIRContent mIRContent, MIREmbeddedTransformation mIREmbeddedTransformation, CallStackEntry callStackEntry) throws MIRException {
            MIRModel mIRModel = mIRContent.getModel();
            if (mIRModel != null) {
                for (MIRStoreConnection mIRStoreConnection : mIRModel.getStoreConnections()) {
                    String string = TreeProcessor.getStoreConnectionReference(mIRStoreConnection);
                    if (mIRContent.getClientOfConnection(string) != null) continue;
                    String string2 = mIRStoreConnection.getName();
                    string2 = this.resolveParameters(mIRModel, string2, callStackEntry);
                    MIRStoreModel mIRStoreModel = this.getStoreModel(mIRContent, string2, "", mIRStoreConnection.getStoreType() == 0, mIREmbeddedTransformation, callStackEntry);
                    MIRStoreContent mIRStoreContent = (MIRStoreContent)mIRStoreModel.getContent();
                    if ((mIRStoreModel.getSystemType().isEmpty() || mIRStoreModel.getSystemType().equals("ODBC")) && !mIRStoreConnection.getSystemType().isEmpty()) {
                        mIRStoreModel.setSystemType(MIRConnectionManager.getInstance().getType(mIRStoreModel.getName(), mIRStoreConnection.getSystemType()));
                    }
                    MIRConnection mIRConnection = new MIRConnection();
                    mIRConnection.setName(string);
                    mIRContent.addClientOfConnection(mIRConnection);
                    mIRStoreContent.addSupplierOfConnection(mIRConnection);
                }
            }
        }

        private void processEmbeddedTransformationTask(MIRContent mIRContent, MIREmbeddedCallTransformation mIREmbeddedCallTransformation, CallStackEntry callStackEntry) throws MIRException {
            this.processEmbeddedTransformationConnections(mIRContent, mIREmbeddedCallTransformation, callStackEntry);
            for (MIRTransformation mIRTransformation : mIREmbeddedCallTransformation.getTransformations()) {
                this.processTransformationExpressions(mIRContent, mIRTransformation, callStackEntry);
            }
        }

        protected void processDataMapping(MIRContent mIRContent, MIRSqlQuery mIRSqlQuery, CallStackEntry callStackEntry) throws MIRException {
            Object object22;
            ObjectCollector objectCollector = new ObjectCollector(new short[]{78});
            objectCollector.collect(mIRSqlQuery);
            for (Object object22 : objectCollector.getObjects()) {
                if (((MIRFeatureMap)object22).getOperation().isEmpty() || ((MIRFeatureMap)object22).getExpression() != null || ((MIRFeatureMap)object22).getDestinationFeature() == null || ((MIRFeatureMap)object22).getDestinationFeature().getClassifier() == null || ((MIRFeatureMap)object22).getDestinationFeature().getClassifier().isInstanceOf((short)335) || ((MIRFeatureMap)object22).getDestinationFeature().getClassifier().isInstanceOf((short)333)) continue;
                Object object3 = ((MIRFeatureMap)object22).getOperation();
                if (!((String)(object3 = this.resolveParameters((MIRElement)object22, (String)object3, callStackEntry))).equals(((MIRFeatureMap)object22).getOperation())) {
                    ((MIRElement)object22).setDescription(((MIRFeatureMap)object22).getOperation());
                    ((MIRFeatureMap)object22).setOperation((String)object3);
                }
                this.parseMappingExpression((MIRFeatureMap)object22);
            }
            ObjectCollector objectCollector2 = new ObjectCollector(new short[]{335});
            objectCollector2.collect(mIRSqlQuery);
            for (Object object3 : objectCollector2.getObjects()) {
                MIRFeatureMap mIRElement = ((MIRFeature)object3).getDestinationOfFeatureMap();
                if (mIRElement == null || mIRElement.getOperation().isEmpty() || mIRElement.getExpression() != null) continue;
                this.parseMappingExpression(mIRElement);
            }
            object22 = new ObjectCollector(new short[]{333});
            ((ObjectCollector)object22).collect(mIRSqlQuery);
            for (MIRQueryFilter mIRQueryFilter : ((ObjectCollector)object22).getObjects()) {
                MIRFeatureMap mIRFeatureMap = mIRQueryFilter.getDestinationOfFeatureMap();
                if (mIRFeatureMap == null || mIRFeatureMap.getOperation().isEmpty() || mIRFeatureMap.getExpression() != null) continue;
                this.parseMappingExpression(mIRFeatureMap);
            }
            for (MIRClassifierMap mIRClassifierMap : mIRSqlQuery.getClassifierMaps()) {
                if (mIRClassifierMap.getExpression() != null) continue;
                this.parseSqlQueryClassMap(mIRClassifierMap);
            }
        }

        private boolean isUsedFeature(MIRFeature mIRFeature, MIRTransformation mIRTransformation, ArrayList<MIRFeature> arrayList) {
            MIRFeature mIRFeature2;
            if (arrayList.contains(mIRFeature)) {
                return false;
            }
            arrayList.add(mIRFeature);
            if (mIRFeature.getClassifier().getParent() != mIRTransformation) {
                return true;
            }
            if (mIRFeature.isInstanceOf((short)84)) {
                return true;
            }
            for (MIRFeatureMap mIRFeatureMap : mIRFeature.getSourceOfFeatureMaps()) {
                mIRFeature2 = mIRFeatureMap.getDestinationFeature();
                if (mIRFeature2 == null || !this.isUsedFeature(mIRFeature2, mIRTransformation, arrayList)) continue;
                return true;
            }
            for (MIRFeatureMap mIRFeatureMap : mIRFeature.getControlOfFeatureMaps()) {
                mIRFeature2 = mIRFeatureMap.getDestinationFeature();
                if (mIRFeature2 == null || !this.isUsedFeature(mIRFeature2, mIRTransformation, arrayList)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private void processTransformationExpressions(MIRContent mIRContent, MIRTransformation mIRTransformation, CallStackEntry callStackEntry) throws MIRException {
            Object object;
            Object object2;
            MIRElement mIRElement;
            if (mIRTransformation.isInstanceOf((short)220)) {
                MIRContent mIRContent2;
                mIRElement = (MIRConnectedTransformation)mIRTransformation;
                object2 = ((MIRConnectedTransformation)mIRElement).getConnectionName();
                object2 = this.resolveParameters(mIRElement, (String)object2, callStackEntry);
                boolean bl = false;
                MIRModel mIRModelObject = mIRTransformation.getRootModel();
                if (mIRModelObject != null && (mIRContent2 = mIRModelObject.getContent()) != null && mIRContent2.isInstanceOf((short)278)) {
                    bl = true;
                }
                if (!((String)object2).isEmpty()) {
                    String string = ((MIRConnectedTransformation)mIRElement).getConnectionName();
                    ((MIRConnectedTransformation)mIRElement).setConnectionName((String)object2);
                    for (MIRClassifierMap mIRClassifierMap2 : ((MIRTransformation)mIRElement).getClassifierMaps().toArray(new MIRClassifierMap[((MIRTransformation)mIRElement).getClassifierMapCount()])) {
                        if (!mIRClassifierMap2.getOperation().isEmpty()) {
                            object = mIRClassifierMap2.getOperation();
                            this.imvParsedMap = mIRClassifierMap2;
                            object = this.resolveParameters(mIRClassifierMap2, (String)object, callStackEntry);
                            this.imvParsedMap = null;
                            boolean bl2 = false;
                            if (!((String)object).equals(mIRClassifierMap2.getOperation())) {
                                mIRClassifierMap2.setDescription(mIRClassifierMap2.getOperation());
                                mIRClassifierMap2.setOperation((String)object);
                                bl2 = true;
                            }
                            if (!mIRClassifierMap2.getOperation().isEmpty()) {
                                this.parseExpression(mIRClassifierMap2, mIRContent, (String)object2, callStackEntry);
                            }
                            if (bl2) {
                                object = mIRClassifierMap2.getDescription();
                                mIRClassifierMap2.setDescription(mIRClassifierMap2.getOperation());
                                mIRClassifierMap2.setOperation((String)object);
                            } else {
                                mIRClassifierMap2.setDescription((String)object);
                            }
                        }
                        if ((object = mIRClassifierMap2.getExpression()) == null || !bl) continue;
                        mIRClassifierMap2.removeExpression();
                        ((MIR_Object)object).delete();
                    }
                    if (bl) {
                        ((MIRConnectedTransformation)mIRElement).setConnectionName(string);
                    }
                }
            }
            mIRElement = null;
            if (mIRTransformation.isInstanceOf((short)237) && (object2 = ((MIRFilteringTransformation)mIRTransformation).getDefaultOutputTransformationDataSet()) != null && ((MIRClassifier)object2).getDestinationOfClassifierMap() != null && ((MIRClassifier)object2).getFeatureCount() > 0) {
                MIRCondition mIRCondition = this.findCondition((MIRClassifier)object2);
                if (mIRCondition == null) {
                    mIRCondition = new MIRCondition();
                    mIRCondition.setName("FILTER CONDITION");
                    ((MIRClassifier)object2).addFeatureUniqueName(mIRCondition);
                }
                if ((mIRElement = mIRCondition.getDestinationOfFeatureMap()) == null) {
                    mIRElement = new MIRFeatureMap();
                    ((MIRFeatureMap)mIRElement).addDestinationFeature(mIRCondition);
                    ((MIRClassifier)object2).getDestinationOfClassifierMap().addFeatureMap((MIRFeatureMap)mIRElement);
                }
            }
            if (mIRTransformation.isInstanceOf((short)320)) {
                this.processEmbeddedTransformationTask(mIRContent, (MIREmbeddedCallTransformation)mIRTransformation, callStackEntry);
            } else if (mIRTransformation.isInstanceOf((short)318)) {
                this.processDataMapping(mIRContent, (MIRSqlQuery)mIRTransformation, callStackEntry);
                object2 = mIRTransformation.getRootModel();
                if (((MIR_Object)object2).isInstanceOf((short)258) && ((MIRDiModel)object2).getSqlQuery() == mIRTransformation) {
                    this.processEmbeddedTransformationConnections(mIRContent, (MIRSqlQuery)mIRTransformation, callStackEntry);
                }
            } else {
                void var7_12;
                object2 = mIRTransformation.getClassifierMaps().toArray(new MIRClassifierMap[mIRTransformation.getClassifierMapCount()]);
                int n = ((MIRClassifierMap[])object2).length;
                boolean bl = false;
                while (var7_12 < n) {
                    Object object3 = object2[var7_12];
                    for (Object object4 : ((MIRClassifierMap)object3).getFeatureMaps().toArray()) {
                        object = (MIRFeatureMap)object4;
                        if (((MIRFeatureMap)object).getSourceFeatureCount() == 0 && !((MIRFeatureMap)object).getOperation().isEmpty() && ((MIRFeatureMap)object).getExpression() == null) {
                            Object object5 = ((MIRFeatureMap)object).getOperation();
                            this.imvParsedMap = object;
                            object5 = this.resolveParameters((MIRElement)object, (String)object5, callStackEntry);
                            this.imvParsedMap = null;
                            if (!((String)object5).equals(((MIRFeatureMap)object).getOperation())) {
                                ((MIRElement)object).setDescription(((MIRFeatureMap)object).getOperation());
                                ((MIRFeatureMap)object).setOperation((String)object5);
                            }
                            if (!((MIRFeatureMap)object).getOperation().isEmpty()) {
                                this.parseExpression((MIRFeatureMap)object);
                            }
                        }
                        if (((MIRFeatureMap)object).getDestinationFeature() == null || !((MIRFeatureMap)object).getDestinationFeature().isInstanceOf((short)84) || mIRElement == null) continue;
                        for (MIRFeature mIRFeature : ((MIRFeatureMap)object).getSourceFeatures()) {
                            MIRBridgeLib.addSourceFeature((MIRFeatureMap)mIRElement, mIRFeature);
                        }
                    }
                    ++var7_12;
                }
            }
            if (mIRElement != null && ((MIRFeatureMap)mIRElement).getSourceFeatureCount() == 0) {
                mIRElement.delete();
            }
            if (mIRTransformation.isInstanceOf((short)220)) {
                object2 = (MIRConnectedTransformation)mIRTransformation;
                ((MIRTransformation)object2).getClassifierMaps().forEach(mIRClassifierMap -> {
                    if (null != mIRClassifierMap.getPropertyValue(DesignTreeProcessor.UDP_TEMPORARY_SOURCE)) {
                        mIRClassifierMap.getSourceClassifiers().stream().filter(mIRClassifier -> mIRClassifier.isInstanceOf((short)254)).forEach(mIRClassifier -> mIRClassifier.setLineageOption(1024));
                    }
                });
                for (MIRConnectionDataSet mIRConnectionDataSet : ((MIRConnectedTransformation)object2).getConnectionDataSets()) {
                    if (mIRConnectionDataSet.getDestinationOfClassifierMap() != null) continue;
                    for (MIRFeature mIRFeature : mIRConnectionDataSet.getFeatures()) {
                        ArrayList<MIRFeature> arrayList;
                        if (this.isUsedFeature(mIRFeature, mIRTransformation, arrayList = new ArrayList<MIRFeature>())) continue;
                        mIRFeature.setLineageOption(1);
                    }
                }
            }
        }

        private void updateParserTransformationStore(MIRStoreConnection mIRStoreConnection) throws MIRException {
            MIRObject mIRObject;
            MIRElement mIRElement;
            MIRModelObject mIRModelObject;
            MIRClassifier mIRClassifier;
            MIRConnectionPackage mIRConnectionPackage;
            MIRContent mIRContent = mIRStoreConnection.getRootModel().getContent();
            MIRStoreModel mIRStoreModel = null;
            MIRConnectionPackage mIRConnectionPackage2 = mIRConnectionPackage = mIRStoreConnection.getConnectionPackageCount() > 0 ? mIRStoreConnection.getConnectionPackages().first() : null;
            if (mIRConnectionPackage == null) {
                return;
            }
            MIRClassifier mIRClassifier2 = mIRClassifier = mIRConnectionPackage.getClassifierCount() > 0 ? mIRConnectionPackage.getClassifiers().first() : null;
            if (mIRClassifier == null) {
                return;
            }
            if (!mIRClassifier.getParent().isInstanceOf((short)220)) {
                return;
            }
            MIRConnectedTransformation mIRConnectedTransformation = (MIRConnectedTransformation)mIRClassifier.getParent();
            MIRConnectedTransformation mIRConnectedTransformation2 = null;
            if (mIRStoreConnection.getNativeType().equals("__MITI_BRIDGE_TRANSPORT_READER_CONNECTION__")) {
                mIRModelObject = mIRConnectedTransformation.getInputTransformationDataSets().first();
                if (mIRModelObject != null) {
                    mIRElement = mIRModelObject.getDestinationOfClassifierMap();
                    while (mIRElement != null && (mIRObject = ((MIRClassifierMap)mIRElement).getSourceClassifiers().first()) != null) {
                        if (((MIRClassifier)mIRObject).getParent().isInstanceOf((short)251)) {
                            mIRConnectedTransformation2 = (MIRReaderTransformation)((MIRClassifier)mIRObject).getParent();
                            break;
                        }
                        mIRElement = ((MIRClassifier)mIRObject).getDestinationOfClassifierMap();
                    }
                }
            } else if (mIRStoreConnection.getNativeType().equals("__MITI_BRIDGE_TRANSPORT_WRITER_CONNECTION__") && (mIRModelObject = mIRConnectedTransformation.getOutputTransformationDataSets().first()) != null) {
                mIRElement = mIRModelObject.getSourceOfClassifierMaps().first();
                while (mIRElement != null && (mIRObject = ((MIRClassifierMap)mIRElement).getDestinationClassifier()) != null) {
                    if (((MIRClassifier)mIRObject).getParent().isInstanceOf((short)260)) {
                        mIRConnectedTransformation2 = (MIRWriterTransformation)((MIRClassifier)mIRObject).getParent();
                        break;
                    }
                    mIRElement = ((MIRClassifier)mIRObject).getSourceOfClassifierMaps().first();
                }
            }
            if (mIRConnectedTransformation2 != null) {
                MIRStoreContent mIRStoreContent;
                mIRModelObject = null;
                mIRElement = mIRConnectedTransformation2.getConnectionDataSets().first();
                if (mIRElement != null && (mIRObject = ((MIRClassifier)mIRElement).getConnectionDataPackage()) != null) {
                    mIRModelObject = MIRBridgeLib.getStoreConnection((MIRConnectionDataPackage)mIRObject);
                }
                if (mIRModelObject != null && (mIRObject = mIRContent.getClientOfConnection(TreeProcessor.getStoreConnectionReference((MIRStoreConnection)mIRModelObject))) != null && (mIRStoreContent = ((MIRConnection)mIRObject).getSupplierStoreContent()) != null) {
                    mIRStoreModel = (MIRStoreModel)mIRStoreContent.getModel();
                }
                if (mIRStoreModel != null) {
                    mIRStoreConnection.setNativeType("");
                    MIRConnectionSummarizer.updateConnectedStore(mIRStoreConnection, mIRStoreModel, true);
                }
            }
        }

        protected void updateConnectedStores(MIRModel mIRModel) throws MIRException {
            ArrayList arrayList = new ArrayList();
            MIRConnectionSummarizer.summarizeConnections(mIRModel, mIRStoreConnection -> {
                MIRConnection mIRConnection = mIRStoreConnection.getRootModel().getContent().getClientOfConnection(MIRBridgeLib.getPhysicalName(mIRStoreConnection));
                if (mIRConnection != null && mIRConnection.getSupplierStoreContent() != null) {
                    if (mIRConnection.getSupplierStoreContent().getConnectionOfDirectoryStructureModel() == null) {
                        try {
                            MIRConnectionSummarizer.updateConnectedStore(mIRStoreConnection, (MIRStoreModel)mIRConnection.getSupplierStoreContent().getModel(), true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return false;
                    }
                    if (mIRStoreConnection.getNativeType().equals("__MITI_BRIDGE_TRANSPORT_READER_CONNECTION__") || mIRStoreConnection.getNativeType().equals("__MITI_BRIDGE_TRANSPORT_WRITER_CONNECTION__")) {
                        arrayList.add(mIRStoreConnection);
                        return false;
                    }
                    return ((MIRStoreModel)mIRConnection.getSupplierStoreContent().getModel()).getStoreType() != 2 || mIRModel.getContent().isInstanceOf((short)283);
                }
                return false;
            }, true);
            for (MIRStoreConnection mIRStoreConnection2 : arrayList) {
                this.updateParserTransformationStore(mIRStoreConnection2);
            }
        }

        private void cleanUpEmptyErrorDataSets(MIRElement mIRElement) {
            MIRDiModel mIRDiModel = (MIRDiModel)mIRElement.getRootModel();
            SortedSet<MIRTransformation> sortedSet = null;
            if (mIRElement.isInstanceOf((short)258)) {
                sortedSet = mIRDiModel.getTransformations();
            } else if (mIRElement.isInstanceOf((short)320)) {
                sortedSet = ((MIREmbeddedCallTransformation)mIRElement).getTransformations();
            }
            if (sortedSet != null) {
                for (MIRTransformation mIRTransformation : sortedSet) {
                    if (mIRTransformation.getErrorTransformationDataSet() != null && mIRTransformation.getErrorTransformationDataSet().getSourceOfClassifierMapCount() == 0) {
                        MIRClassifierMap mIRClassifierMap = mIRTransformation.getErrorTransformationDataSet().getDestinationOfClassifierMap();
                        if (mIRClassifierMap != null) {
                            mIRClassifierMap.delete();
                        }
                        mIRTransformation.getErrorTransformationDataSet().delete();
                    }
                    if (!mIRTransformation.isInstanceOf((short)320)) continue;
                    this.cleanUpEmptyErrorDataSets(mIRTransformation);
                }
            }
        }

        private void cleanUpEmptyStoreConnections(MIRModel mIRModel) {
            ArrayList<MIRObject> arrayList = new ArrayList<MIRObject>();
            MIRContent mIRContent = mIRModel.getRootModel().getContent();
            for (MIRStoreConnection mIR_Object : mIRModel.getStoreConnections()) {
                for (Object object : mIR_Object.getConnectionPackages().toArray()) {
                    MIRConnectionPackage mIRConnectionPackage = (MIRConnectionPackage)object;
                    if (mIRConnectionPackage.getClassifierCount() + mIRConnectionPackage.getNamespaceElementCount() + mIRConnectionPackage.getImportedNamespaceElementCount() != 0) continue;
                    mIRConnectionPackage.delete();
                }
                boolean bl = mIR_Object.getStereotype().equals("Empty");
                if (mIR_Object.getStoreType() != 2 && mIR_Object.getStoreType() != 5 && mIR_Object.getConnectionPackageCount() == 0 && mIR_Object.getConnectionElementCount() == 0 || mIR_Object.getStoreType() == 2 && mIR_Object.getConnectionNamespaceCount() == 0 || mIR_Object.getStoreType() == 5 && mIR_Object.getConnectionNamespaceCount() == 0) {
                    if (bl && mIRContent.isInstanceOf((short)278)) continue;
                    String string = TreeProcessor.getStoreConnectionReference(mIR_Object);
                    MIRConnection mIRConnection = mIRContent.getClientOfConnection(string);
                    arrayList.add(mIRConnection);
                    arrayList.add(mIR_Object);
                    continue;
                }
                if (!bl) continue;
                mIR_Object.setStereotype("");
            }
            for (MIR_Object mIR_Object : arrayList) {
                if (mIR_Object == null) continue;
                mIR_Object.delete();
            }
        }

        public void processTransformationTask(MIRDiModel mIRDiModel, CallStackEntry callStackEntry) throws MIRException {
            MIRContent mIRContent = mIRDiModel.getContent();
            this.ensureTransformationClassifierMaps(mIRDiModel);
            ObjectCollector objectCollector = new ObjectCollector(new short[]{79});
            objectCollector.collect(mIRDiModel);
            for (MIRTransformation mIRTransformation : DesignTreeProcessor.sortObjectsByPath(objectCollector.getObjects())) {
                ObjectCollector objectCollector2 = new ObjectCollector(new short[]{71});
                objectCollector2.collect(mIRTransformation);
                for (MIRPropertyValue mIRPropertyValue : objectCollector2.getObjects()) {
                    String string;
                    if (mIRPropertyValue.getValue().isEmpty() || mIRPropertyValue.getValue().isEmpty() || (string = this.resolveParameters(mIRTransformation, mIRPropertyValue.getValue(), callStackEntry)).equals(mIRPropertyValue.getValue())) continue;
                    mIRPropertyValue.setValue(string);
                }
                this.processTransformationExpressions(mIRContent, mIRTransformation, callStackEntry);
            }
            this.cleanUpEmptyStoreConnections(mIRDiModel);
            this.cleanUpEmptyErrorDataSets(mIRDiModel);
        }
    }

    public static class AggExpressionPrinter
    extends MIRExpressionConverter {
        public boolean imvIsAggregation = false;

        public AggExpressionPrinter(int n, int n2) {
            super(n, n2);
        }

        @Override
        protected String getElementName(MIRElement mIRElement) {
            return mIRElement.getName();
        }

        @Override
        protected void printOperationNode(MIROperationNode mIROperationNode) {
            String string = mIROperationNode.getName();
            int n = mIROperationNode.getExpressionNodeCount();
            this.imvIsAggregation |= this.getFunctions().isAggregation(string, n);
            super.printOperationNode(mIROperationNode);
        }
    }

    public static class ParseErrorEntry {
        public String imvConnectionName;
        public String imvStoreSystemType;
        public int imvErrorCount;
    }

    public static class ParamValue {
        private String imvName;
        private String imvValue;

        public ParamValue(String string, String string2) {
            this.imvName = string;
            this.imvValue = string2;
        }

        public String getName() {
            return this.imvName;
        }

        public String getValue() {
            return this.imvValue;
        }
    }

    public static class CallStackEntry {
        private CallStackEntry imvPrev;
        private CallStackEntry imvNext;
        private MIRDiModel imvModel;
        private MIRDiEmbedding imvEmbedding;

        public CallStackEntry(MIRDiModel mIRDiModel, MIRDiEmbedding mIRDiEmbedding, CallStackEntry callStackEntry) {
            this.imvPrev = callStackEntry;
            if (this.imvPrev != null) {
                this.imvPrev.imvNext = this;
            }
            this.imvModel = mIRDiModel;
            this.imvEmbedding = mIRDiEmbedding;
        }

        public CallStackEntry getPrev() {
            return this.imvPrev;
        }

        public CallStackEntry getNext() {
            return this.imvNext;
        }

        public MIRDiModel getModel() {
            return this.imvModel;
        }

        public MIRDiEmbedding getEmbedding() {
            return this.imvEmbedding;
        }

        public CallStackEntry findByModel(MIRDiModel mIRDiModel) {
            return this.imvModel == mIRDiModel ? this : (this.imvPrev != null ? this.imvPrev.findByModel(mIRDiModel) : null);
        }

        public String getPath() {
            return this.imvPrev != null ? this.imvPrev.getPath() + "." + this.imvModel.getName() : this.imvModel.getName();
        }

        public String getPathByEmbedding() {
            return this.imvPrev != null ? this.imvPrev.getPathByEmbedding() + "." + this.imvEmbedding.getName() : this.imvModel.getName();
        }
    }

    public static enum SqlOverrideType {
        UNDEFINED,
        SQL,
        TABLE,
        BOTH,
        NONE;

    }

    protected static enum SearchParamScope {
        SPS_UNDEFINED,
        SPS_DESIGN,
        SPS_RUNTIME,
        SPS_MAPPINGS;

    }
}

