/*
 * Decompiled with CFR 0.152.
 */
package MITI.processor.subset;

import MITI.MIRException;
import MITI.messages.MIRModelProcessor.MPROC;
import MITI.processor.Processor;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRSQLViewAssociation;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRType;
import MITI.sdk.mix.MIRMIXImport;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.mix.MIRMixIdMap;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;

public class SubsetProcessor
extends Processor {
    @Override
    protected void run() throws MIRException {
        File file = new File((String)this.options.get(MPROC.BP_SUBSET_FILE.getParameterId()));
        SubsetCache subsetCache = new SubsetCache(this.cache, this.srcFile.getName());
        MIRModel mIRModel = subsetCache.readFile(this.srcFile);
        if (mIRModel instanceof MIRStoreModel) {
            MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRModel;
            MIRObject mIRObject = subsetCache.readFragment(file);
            if (mIRObject != null && mIRObject.getElementType() == 9) {
                MIRDesignPackage mIRDesignPackage = (MIRDesignPackage)mIRObject;
                if (mIRDesignPackage.getParent() == null) {
                    mIRStoreModel.addDesignPackage(mIRDesignPackage);
                }
                this.subset(mIRStoreModel, mIRDesignPackage);
                subsetCache.writeFile(this.dstFile, mIRStoreModel);
            }
        }
    }

    private void subset(MIRStoreModel mIRStoreModel, MIRDesignPackage mIRDesignPackage) {
        MPROC.STS_SUBSETTING_MODEL.log(new Object[0]);
        if (mIRDesignPackage == null) {
            return;
        }
        mIRDesignPackage.setUserDefined(true);
        HashSet<MIRNamespaceElement> hashSet = new HashSet<MIRNamespaceElement>(mIRDesignPackage.getImportedNamespaceElements());
        for (MIRNamespaceElement object2 : hashSet) {
            object2.removeNamespace();
            object2.removeImportedByPackages();
            mIRDesignPackage.addNamespaceElementUniqueName(object2);
        }
        for (MIRNamespaceElement mIRNamespaceElement : hashSet) {
            if (mIRNamespaceElement.getElementType() == 13) {
                this.processClass(mIRStoreModel, (MIRClass)mIRNamespaceElement, mIRDesignPackage);
                continue;
            }
            if (mIRNamespaceElement.getElementType() != 25) continue;
            this.processView(mIRStoreModel, (MIRSQLViewEntity)mIRNamespaceElement, mIRDesignPackage);
        }
        HashSet<MIRDesignPackage> hashSet2 = new HashSet<MIRDesignPackage>(mIRStoreModel.getDesignPackages());
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            MIRDesignPackage mIRDesignPackage2 = (MIRDesignPackage)iterator.next();
            if (mIRDesignPackage2 == mIRDesignPackage) continue;
            mIRStoreModel.removeDesignPackage(mIRDesignPackage2);
        }
        for (MIRType mIRType : mIRStoreModel.getTypes()) {
            HashSet<MIRFeature> hashSet3 = new HashSet<MIRFeature>(mIRType.getFeatures());
            for (MIRFeature mIRFeature : hashSet3) {
                if (mIRFeature.getClassifier().getNamespace() == mIRDesignPackage) continue;
                mIRType.removeFeature(mIRFeature);
            }
            mIRType.removeImportedByPackages();
            if (!(mIRType instanceof MIRConcreteType)) continue;
            MIRConcreteType mIRConcreteType = (MIRConcreteType)mIRType;
            HashSet<MIRDerivedType> hashSet4 = new HashSet<MIRDerivedType>(mIRConcreteType.getDerivedTypes());
            for (MIRDerivedType mIRDerivedType : hashSet4) {
                if (mIRDerivedType.getModel() != null) continue;
                mIRConcreteType.removeDerivedType(mIRDerivedType);
            }
        }
        mIRStoreModel.removePropertyElementTypeScopes();
        MPROC.STS_DELETING_OBJECTS.log(new Object[0]);
        MPROC.STS_SUBSETTING_COMPLETED.log(new Object[0]);
    }

    private Set<MIRAssociation> getRelatedAssociations(MIRClass mIRClass) {
        HashSet<MIRAssociation> hashSet = new HashSet<MIRAssociation>();
        for (MIRAssociationRole mIRAssociationRole : mIRClass.getAssociationRoles()) {
            hashSet.add(mIRAssociationRole.getAssociation());
        }
        return hashSet;
    }

    private Set<MIRJoin> getRelatedJoins(MIRClass mIRClass) {
        HashSet<MIRJoin> hashSet = new HashSet<MIRJoin>();
        for (MIRJoinRole mIRJoinRole : mIRClass.getAssociatedJoinRoles()) {
            hashSet.add(mIRJoinRole.getJoin());
        }
        return hashSet;
    }

    private void processView(MIRStoreModel mIRStoreModel, MIRSQLViewEntity mIRSQLViewEntity, MIRDesignPackage mIRDesignPackage) {
        HashSet<MIRSQLViewAssociation> hashSet = new HashSet<MIRSQLViewAssociation>();
        hashSet.addAll(mIRSQLViewEntity.getDestinationOfSQLViewAssociations());
        hashSet.addAll(mIRSQLViewEntity.getSourceOfSQLViewAssociations());
        for (MIRSQLViewAssociation mIRSQLViewAssociation : hashSet) {
            this.processViewAssociation(mIRStoreModel, mIRSQLViewAssociation, mIRDesignPackage);
        }
        this.processClassifier(mIRStoreModel, mIRSQLViewEntity, mIRDesignPackage);
    }

    private void processClassifier(MIRStoreModel mIRStoreModel, MIRClassifier mIRClassifier, MIRDesignPackage mIRDesignPackage) {
        MIRElement mIRElement2;
        SortedSet<MIRFeature> sortedSet = mIRClassifier.getFeatures();
        for (MIRElement mIRElement2 : sortedSet) {
            this.processFeature(mIRStoreModel, (MIRFeature)mIRElement2, mIRDesignPackage);
        }
        HashSet hashSet = new HashSet();
        mIRElement2 = mIRClassifier.getDestinationOfClassifierMap();
        if (mIRElement2 != null) {
            hashSet.add(mIRElement2);
        }
        hashSet.addAll(mIRClassifier.getSourceOfClassifierMaps());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            MIRClassifierMap mIRClassifierMap = (MIRClassifierMap)iterator.next();
            this.processClassifierMap(mIRStoreModel, mIRClassifierMap, mIRDesignPackage);
        }
        this.processModelElement(mIRStoreModel, mIRClassifier);
    }

    private void processClassifierMap(MIRStoreModel mIRStoreModel, MIRClassifierMap mIRClassifierMap, MIRDesignPackage mIRDesignPackage) {
        boolean bl = true;
        for (MIRClassifier mIRClassifier : mIRClassifierMap.getSourceClassifiers()) {
            if (mIRClassifier.getNamespace() == mIRDesignPackage) continue;
            bl = false;
            break;
        }
        if (mIRClassifierMap.getClassifier().getNamespace() != mIRDesignPackage) {
            bl = false;
        }
        if (!bl) {
            mIRClassifierMap.removeSourceClassifiers();
            mIRClassifierMap.removeClassifier();
            mIRClassifierMap.removeDestinationClassifier();
        }
    }

    private void processModelElement(MIRStoreModel mIRStoreModel, MIRModelElement mIRModelElement) {
        mIRModelElement.removeDiagrams();
        this.processModelObject(mIRStoreModel, mIRModelElement);
    }

    private void processModelObject(MIRStoreModel mIRStoreModel, MIRModelObject mIRModelObject) {
        mIRModelObject.removePropertyValues();
    }

    private void processClass(MIRStoreModel mIRStoreModel, MIRClass mIRClass, MIRDesignPackage mIRDesignPackage) {
        Set<MIRAssociation> set = this.getRelatedAssociations(mIRClass);
        for (MIRAssociation hashSet2 : set) {
            this.processAssociation(mIRStoreModel, hashSet2, mIRDesignPackage);
        }
        Set<MIRJoin> set2 = this.getRelatedJoins(mIRClass);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            MIRJoin mIRJoin = (MIRJoin)iterator.next();
            this.processJoin(mIRStoreModel, mIRJoin, mIRDesignPackage);
        }
        HashSet<MIRSQLViewAssociation> hashSet = new HashSet<MIRSQLViewAssociation>(mIRClass.getSourceOfSQLViewAssociations());
        for (MIRSQLViewAssociation mIRSQLViewAssociation : hashSet) {
            this.processViewAssociation(mIRStoreModel, mIRSQLViewAssociation, mIRDesignPackage);
        }
        this.processClassifier(mIRStoreModel, mIRClass, mIRDesignPackage);
    }

    private void processFeature(MIRStoreModel mIRStoreModel, MIRFeature mIRFeature, MIRDesignPackage mIRDesignPackage) {
        this.processDerivedType(mIRStoreModel, mIRDesignPackage, mIRFeature.getType());
        HashSet<MIRFeatureMap> hashSet = new HashSet<MIRFeatureMap>();
        MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
        if (mIRFeatureMap != null) {
            hashSet.add(mIRFeatureMap);
        }
        hashSet.addAll(mIRFeature.getSourceOfFeatureMaps());
        HashSet<MIRSQLViewAttribute> hashSet2 = hashSet.iterator();
        while (hashSet2.hasNext()) {
            MIRFeatureMap mIRFeatureMap2 = (MIRFeatureMap)hashSet2.next();
            this.processFeatureMap(mIRStoreModel, mIRFeatureMap2, mIRDesignPackage);
        }
        if (mIRFeature instanceof MIRSQLViewAttribute && ((MIRSQLViewAttribute)((Object)(hashSet2 = (MIRSQLViewAttribute)mIRFeature))).getSourceFeature().getClassifier().getNamespace() != mIRDesignPackage) {
            ((MIRSQLViewAttribute)((Object)hashSet2)).removeSourceFeature();
        }
        hashSet2 = new HashSet<MIRSQLViewAttribute>(mIRFeature.getSourceOfSQLViewAttributes());
        for (MIRSQLViewAttribute mIRSQLViewAttribute : hashSet2) {
            if (mIRSQLViewAttribute.getClassifier().getNamespace() == mIRDesignPackage) continue;
            mIRFeature.removeSourceOfSQLViewAttribute(mIRSQLViewAttribute);
        }
        this.processModelObject(mIRStoreModel, mIRFeature);
    }

    private void processFeatureMap(MIRStoreModel mIRStoreModel, MIRFeatureMap mIRFeatureMap, MIRDesignPackage mIRDesignPackage) {
        boolean bl = true;
        for (MIRFeature mIRFeature : mIRFeatureMap.getSourceFeatures()) {
            if (mIRFeature.getClassifier().getNamespace() == mIRDesignPackage) continue;
            bl = false;
            break;
        }
        if (mIRFeatureMap.getDestinationFeature().getClassifier().getNamespace() != mIRDesignPackage) {
            bl = false;
        }
        if (!bl) {
            mIRFeatureMap.removeClassifierMap();
            mIRFeatureMap.removeSourceFeatures();
            mIRFeatureMap.removeDestinationFeature();
        }
    }

    private void processAssociation(MIRStoreModel mIRStoreModel, MIRAssociation mIRAssociation, MIRDesignPackage mIRDesignPackage) {
        SortedSet<MIRAssociationRole> sortedSet = mIRAssociation.getAssociationRoles();
        boolean bl = true;
        for (MIRAssociationRole mIRAssociationRole : sortedSet) {
            if (mIRAssociationRole.getAssociatedClass().getNamespace() == mIRDesignPackage) continue;
            bl = false;
            break;
        }
        if (bl) {
            mIRAssociation.removeNamespace();
            mIRDesignPackage.addNamespaceElement(mIRAssociation);
        } else {
            for (MIRAssociationRole mIRAssociationRole : sortedSet) {
                mIRAssociationRole.removeAssociatedClass();
                MIRForeignKey mIRForeignKey = mIRAssociationRole.getForeignKey();
                if (mIRForeignKey == null) continue;
                mIRForeignKey.removeAssociatedClass();
                mIRForeignKey.delete();
            }
        }
        this.processModelElement(mIRStoreModel, mIRAssociation);
    }

    private void processJoin(MIRStoreModel mIRStoreModel, MIRJoin mIRJoin, MIRDesignPackage mIRDesignPackage) {
        SortedSet<MIRJoinRole> sortedSet = mIRJoin.getJoinRoles();
        boolean bl = true;
        for (MIRJoinRole mIRJoinRole : sortedSet) {
            if (mIRJoinRole.getClassifier().getNamespace() == mIRDesignPackage) continue;
            bl = false;
            break;
        }
        if (bl) {
            mIRJoin.removeNamespace();
            mIRDesignPackage.addNamespaceElement(mIRJoin);
        } else {
            for (MIRJoinRole mIRJoinRole : sortedSet) {
                mIRJoinRole.removeClassifier();
            }
        }
        this.processClassifier(mIRStoreModel, mIRJoin, mIRDesignPackage);
    }

    private void processViewAssociation(MIRStoreModel mIRStoreModel, MIRSQLViewAssociation mIRSQLViewAssociation, MIRDesignPackage mIRDesignPackage) {
        boolean bl = true;
        if (mIRSQLViewAssociation.getDestinationSQLViewEntity().getNamespace() != mIRDesignPackage || mIRSQLViewAssociation.getSourceClassifier().getNamespace() != mIRDesignPackage) {
            bl = false;
        }
        if (bl) {
            mIRSQLViewAssociation.removeNamespace();
            mIRDesignPackage.addNamespaceElement(mIRSQLViewAssociation);
        } else {
            mIRSQLViewAssociation.removeDestinationSQLViewEntity();
            mIRSQLViewAssociation.removeSourceClassifier();
        }
        this.processModelElement(mIRStoreModel, mIRSQLViewAssociation);
    }

    private void processDerivedType(MIRStoreModel mIRStoreModel, MIRDesignPackage mIRDesignPackage, MIRType mIRType) {
        if (mIRType == null || mIRType.getElementType() != 5) {
            return;
        }
        MIRDerivedType mIRDerivedType = (MIRDerivedType)mIRType;
        MIRNamespace mIRNamespace = mIRDerivedType.getNamespace();
        if (mIRNamespace != null && mIRNamespace != mIRDesignPackage) {
            mIRDerivedType.removeNamespace();
            mIRStoreModel.addType(mIRDerivedType);
            this.processDerivedType(mIRStoreModel, mIRDesignPackage, mIRDerivedType.getDerivedFromConcreteType());
        }
        this.processModelObject(mIRStoreModel, mIRType);
    }

    class SubsetCache
    extends MIRMixCache {
        private SubsetImport importer;

        private SubsetCache(MIRMixCache mIRMixCache, String string) {
            super(mIRMixCache);
            this.importer = new SubsetImport(string);
        }

        private MIRObject readFragment(File file) throws MIRException {
            return this.importer.run(file, MIRLogger.getLogger(), this.ids);
        }
    }

    class SubsetImport
    extends MIRMIXImport {
        private String docId;

        private SubsetImport(String string) {
            this.docId = string;
        }

        private MIRObject run(File file, MIRLogger mIRLogger, MIRMixIdMap mIRMixIdMap) throws MIRException {
            return this.run(file, mIRMixIdMap, null);
        }

        @Override
        protected Object read(InputStream inputStream, String string, short[] sArray) throws MIRException {
            return super.read(inputStream, this.docId, sArray);
        }

        @Override
        public void processLink(Object object, MIRMetaLink mIRMetaLink, Object object2) {
            if (!mIRMetaLink.contains((MIRObject)object, (MIRObject)object2)) {
                super.processLink(object, mIRMetaLink, object2);
            }
        }
    }
}

