/*
 * Decompiled with CFR 0.152.
 */
package MITI.processor;

import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.processor.Processor;
import MITI.sdk.MIRObject;
import MITI.util.MachineInfo;
import MITI.util.VersionInfo;
import MITI.util.VersionNumber;
import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.MandatoryOption;
import MITI.util.cmd.TypedOption;
import MITI.util.log.MIRLogger;
import MITI.util.log.XmlLogEventHandler;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class JavaModelProcessor {
    private static HelpOption helpOption = new HelpOption();
    private static MandatoryOption mimbXmlOption = new MandatoryOption(new String[]{"-r", "--runXml"}, MBCM.PARAM_DESCR_R.toString(), TypedOption.Type.FILE);
    private static CommandLineOption[] options = new CommandLineOption[]{helpOption, mimbXmlOption};

    private static void printUsage() {
        System.out.println(MBCM.TITLE1.toString());
        System.out.println(MBCM.TITLE2.toString());
        CommandLineParser.printUsage(options, System.out);
    }

    private static void printJavaInfo(VersionNumber versionNumber) {
        MBCM.MSG_STARTING_JVM.log(MachineInfo.getJavaVersion(), MachineInfo.getJavaHome(), MachineInfo.getJavaMemory(), MachineInfo.getJavaOptions());
        VersionNumber versionNumber2 = VersionNumber.parse(System.getProperty("java.version"));
        if (versionNumber2.compareTo(versionNumber) < 0) {
            MBCM.MINIMUM_JAVA_VERSION_ERROR.log(versionNumber2.toString(), versionNumber.toString());
            System.exit(1);
        }
    }

    private static void printVersionInfo(Class<?>[] classArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Class<?> clazz : classArray) {
            String string;
            VersionInfo versionInfo = VersionInfo.loadMitiJar(clazz);
            if (versionInfo == null || versionInfo.getComponent() == null) continue;
            String string2 = versionInfo.getComponent() + ".jar";
            String string3 = "";
            if (versionInfo.getVersionString() != null) {
                string3 = string3 + versionInfo.getVersionString();
                if (versionInfo.getDate() != null) {
                    string3 = string3 + " - " + versionInfo.getDate().substring(0, versionInfo.getDate().length() - 9);
                }
            }
            string = (string = (String)treeMap.get(string3)) == null ? string2 : string + ", " + string2;
            treeMap.put(string3, string);
        }
        for (String string : treeMap.keySet()) {
            String string4 = (String)treeMap.get(string);
            if (string.isEmpty()) {
                BLIB.MITI_COMPONENT_EMPTY_BUILD_VERSION.log(string4);
                continue;
            }
            BLIB.MITI_COMPONENT_BUILD_VERSION.log(string, string4);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Class[] classArray;
        Object object2;
        MIRLogger.init(new XmlLogEventHandler(System.err));
        String string = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file = null;
        File file2 = null;
        VersionNumber versionNumber = VersionNumber.parse("1.5");
        try {
            CommandLineParser.process(stringArray, 0, options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            JavaModelProcessor.printJavaInfo(versionNumber);
            JavaModelProcessor.printUsage();
            System.exit(1);
        }
        if (helpOption.isSet()) {
            JavaModelProcessor.printUsage();
            System.exit(0);
        }
        try {
            object2 = DocumentBuilderFactory.newInstance();
            classArray = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object = classArray.parse(mimbXmlOption.getFileValue());
            Element element = object.getDocumentElement();
            string = element.getAttribute("processor").replace("/", ".");
            file = new File(element.getAttribute("srcFile"));
            file2 = new File(element.getAttribute("dstFile"));
            versionNumber = VersionNumber.parse(element.getAttribute("javaVersion"));
            NodeList nodeList = element.getElementsByTagName("ProcessorParameter");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                String string3;
                block13: {
                    Element element2 = (Element)nodeList.item(i);
                    string3 = element2.getAttribute("name");
                    string2 = null;
                    try {
                        string2 = element2.getTextContent();
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        Node node = element2.getFirstChild();
                        if (node == null) break block13;
                        string2 = node.getNodeValue();
                    }
                }
                hashMap.put(string3, string2);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new IllegalArgumentException(exception);
        }
        if (string == null) {
            MBCM.ERR_MISSING_REQUIRED_PARAMETER.log("bridgeClass");
            System.exit(-1);
        }
        JavaModelProcessor.printJavaInfo(versionNumber);
        object2 = null;
        try {
            MBCM.DBG_LOADING_JAVA_BRIDGE_CLASS.log(string);
            object2 = Class.forName(string);
            try {
                classArray = new Class[]{Processor.class, MIRObject.class, VersionInfo.class};
                JavaModelProcessor.printVersionInfo(classArray);
                object = (Processor)((Class)object2).newInstance();
                ((Processor)object).process(file, file2, hashMap);
            }
            catch (Error | Exception throwable) {
                MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.log(throwable, throwable.toString());
                System.exit(1);
            }
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            MBCM.COULD_NOT_LOAD_JAVA_CLASS.log(string);
            MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.log(throwable, throwable.toString());
            System.exit(1);
        }
        System.exit(0);
    }
}

