/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.Converter;
import com.sas.metadata.MapPool;
import com.sas.metadata.MdObjectAttribute;
import com.sas.metadata.MdObjectAttributePool;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdServerStore;
import com.sas.metadata.MdStore;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MdStoreUtil {
    public static void copyMetaObject(MdServerStore sourceStore, MdObjectStore targetStore, String objectID) {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject != null) {
            MdStoreUtil.refreshMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        outObject = MdObjectFactory.createComplexMetadataObjectStoreOnly(targetStore, inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
        if (!targetStore.getIsObjectCopiedFromParentOnCreation()) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.instance();
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.instance();
        MapPool.returnMap(inAssocs);
        inAssocs = null;
    }

    public static void copyMetaObject(MdObjectStore sourceStore, MdServerStore targetStore, String objectID) {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject != null) {
            MdStoreUtil.refreshMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        outObject = MdObjectFactory.createComplexMetadataObjectServerStoreOnly(inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.instance();
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.instance();
        MapPool.returnMap(inAssocs);
        inAssocs = null;
    }

    public static void copyMetaObject(MdObjectStore sourceStore, MdObjectStore targetStore, String objectID) {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject != null) {
            MdStoreUtil.refreshMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        outObject = MdObjectFactory.createComplexMetadataObjectStoreOnly(targetStore, inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
        if (targetStore.getOwningStore().equals(sourceStore) && !targetStore.getIsObjectCopiedFromParentOnCreation()) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.instance();
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        MapPool.instance();
        MapPool.returnMap(inAssocs);
        inAssocs = null;
        inObject = null;
        outObject = null;
    }

    public static void copyMetaObject(MdStore sourceStore, MdStore targetStore, String objectID) {
        if (sourceStore.getStoreType() == 0 && targetStore.getStoreType() == 1) {
            MdStoreUtil.copyMetaObject((MdServerStore)sourceStore, (MdObjectStore)targetStore, objectID);
        } else if (sourceStore.getStoreType() == 1 && targetStore.getStoreType() == 0) {
            MdStoreUtil.copyMetaObject((MdObjectStore)sourceStore, (MdServerStore)targetStore, objectID);
        } else if (sourceStore.getStoreType() == 1 && targetStore.getStoreType() == 1) {
            MdStoreUtil.copyMetaObject((MdObjectStore)sourceStore, (MdObjectStore)targetStore, objectID);
        }
    }

    public static void refreshMetaObject(MdStore sourceStore, MdStore targetStore, String objectID) {
        if (sourceStore.getStoreType() == 0 && targetStore.getStoreType() == 1) {
            MdStoreUtil.refreshMetaObject((MdServerStore)sourceStore, (MdObjectStore)targetStore, objectID);
        } else if (sourceStore.getStoreType() == 1 && targetStore.getStoreType() == 0) {
            MdStoreUtil.refreshMetaObject((MdObjectStore)sourceStore, (MdServerStore)targetStore, objectID);
        } else if (sourceStore.getStoreType() == 1 && targetStore.getStoreType() == 1) {
            MdStoreUtil.refreshMetaObject((MdObjectStore)sourceStore, (MdObjectStore)targetStore, objectID);
        }
    }

    public static void refreshMetaObject(MdServerStore sourceStore, MdObjectStore targetStore, String objectID) {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject == null) {
            if (targetStore.getDeletedObjects().containsKey(objectID)) {
                return;
            }
            MdStoreUtil.copyMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.instance();
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.instance();
        MapPool.returnMap(inAssocs);
        inAssocs = null;
        inObject = null;
        outObject = null;
    }

    public static void refreshMetaObject(MdObjectStore sourceStore, MdObjectStore targetStore, String objectID) {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject == null) {
            if (targetStore.getDeletedObjects().containsKey(objectID)) {
                return;
            }
            MdStoreUtil.copyMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.instance();
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.instance();
        MapPool.returnMap(inAssocs);
        inAssocs = null;
        inObject = null;
        outObject = null;
    }

    public static void refreshMetaObject(MdObjectStore sourceStore, MdServerStore targetStore, String objectID) {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject == null) {
            MdStoreUtil.copyMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.instance();
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.instance();
        MapPool.returnMap(inAssocs);
        inAssocs = null;
        inObject = null;
        outObject = null;
    }

    private static void refreshMetaObject(MdStore sourceStore, MdObjectStore targetStore, String objectID, boolean deepCopy) {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject == null) {
            if (targetStore.getDeletedObjects().containsKey(objectID)) {
                return;
            }
            MdStoreUtil.copyMetaObject(sourceStore, targetStore, objectID, deepCopy);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.instance();
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        if (deepCopy) {
            Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
            MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
            MapPool.instance();
            MapPool.returnMap(inAssocs);
            inAssocs = null;
        }
        inObject = null;
        outObject = null;
    }

    private static void copyMetaObject(MdStore sourceStore, MdObjectStore targetStore, String objectID, boolean deepCopy) {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject != null) {
            MdStoreUtil.refreshMetaObject(sourceStore, targetStore, objectID, deepCopy);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        outObject = MdObjectFactory.createComplexMetadataObjectStoreOnly(targetStore, inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
        if (targetStore.getOwningStore().equals(sourceStore) && !targetStore.getIsObjectCopiedFromParentOnCreation()) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        if (deepCopy) {
            Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
            MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
            MapPool.instance();
            MapPool.returnMap(inAttrs);
            inAttrs = null;
            MapPool.instance();
            MapPool.returnMap(inAssocs);
            inAssocs = null;
        }
        inObject = null;
        outObject = null;
    }

    public static void setMetaObjectAttributes(CMetadata sourceObject, CMetadata targetObject, Map attributes) {
        MapPool.instance();
        HashMap setAttrs = MapPool.getMap();
        Map<String, Integer> attrStates = sourceObject.getAttrsStates();
        for (String attrName : attributes.keySet()) {
            Integer attrState = attrStates.get(attrName);
            if (attrState == null || attrState == 0) continue;
            String attrValue = (String)attributes.get(attrName);
            MdObjectAttribute attribute = MdObjectAttributePool.instance().getMdObjectAttribute();
            attribute.setAttributeName(attrName);
            attribute.setAttributeValue(attrValue);
            attribute.setAttributeState(attrState);
            setAttrs.put(attrName, attribute);
        }
        targetObject.setAttrs(setAttrs);
        MdObjectAttributePool.instance().returnMapOfMdObjectAttributes(setAttrs);
        MapPool.instance();
        MapPool.returnMap(setAttrs);
        setAttrs = null;
        MapPool.instance();
        MapPool.returnMap(attrStates);
        attrStates = null;
    }

    public static void setMetaObjectAttributes(CMetadata sourceObject, CMetadata targetObject, Map attributes, int AttrValueState) {
        MapPool.instance();
        HashMap setAttrs = MapPool.getMap();
        for (String AttrName : attributes.keySet()) {
            String AttrValue = (String)attributes.get(AttrName);
            MdObjectAttribute attribute = MdObjectAttributePool.instance().getMdObjectAttribute();
            attribute.setAttributeName(AttrName);
            attribute.setAttributeValue(AttrValue);
            attribute.setAttributeState(AttrValueState);
            setAttrs.put(AttrName, attribute);
        }
        targetObject.setAttrs(setAttrs);
        MdObjectAttributePool.instance().returnMapOfMdObjectAttributes(setAttrs);
        MapPool.instance();
        MapPool.returnMap(setAttrs);
        setAttrs = null;
    }

    public static void setMetaObjectAssociations(CMetadata sourceObject, CMetadata targetObject, Map associations) {
        Map<String, AssociationList> targetAssocs = targetObject.getAssocsWA();
        for (String assnName : associations.keySet()) {
            AssociationList assnValue = (AssociationList)associations.get(assnName);
            if (assnValue == null) continue;
            MdStoreUtil.setMetaObjectAssociation(sourceObject, targetObject, assnValue, targetAssocs);
        }
        MapPool.instance();
        MapPool.returnMap(targetAssocs);
        targetAssocs = null;
    }

    public static void setMetaObjectAssociation(CMetadata sourceObject, CMetadata targetObject, AssociationList assocValue, Map targetAssociations) {
        List deletedObjects;
        if (assocValue == null) {
            return;
        }
        AssociationList targetObjectList = null;
        String assocName = assocValue.getAssociationName();
        targetObjectList = (AssociationList)targetAssociations.get(assocName);
        if (targetObjectList == null) {
            targetObjectList = new AssociationList(assocName);
            targetObject.setMdObjectAssociation(targetObjectList);
        }
        if ((deletedObjects = assocValue.getDeletedItems()) != null && deletedObjects.size() > 0) {
            for (int i = 0; i < deletedObjects.size(); ++i) {
                targetObjectList._addDeletedItem(deletedObjects.get(i), false);
            }
        }
        Vector ids = assocValue.getObjectIDs();
        targetObjectList.setObjectIDs(ids);
        boolean processOtherSide = false;
        MdStore targetStore = targetObject.getObjectStore();
        if (targetStore.getStoreType() == 1) {
            MdObjectStore store = (MdObjectStore)targetStore;
            boolean deepCopy = store.isDeepCopyObjects();
            for (String id : ids) {
                CMetadata otherObject = store.getObject(id, true);
                if (!(otherObject != null || store.getDeletedObjects() != null && store.getDeletedObjects().containsKey(id))) {
                    processOtherSide = true;
                    MdStoreUtil.refreshMetaObject(sourceObject.getObjectStore(), store, id, deepCopy);
                }
                otherObject = null;
            }
        }
        if (processOtherSide) {
            targetObjectList.updateOppositeSideAssn();
        }
        targetObjectList.setState(assocValue.getState(), false);
        targetObjectList = null;
    }

    public static void setMetaObjectAssociation(CMetadata inObject, String AssociationName, AssociationList AssociationValue, int AssociationState, Map assocs) {
        AssociationList inObjectList = null;
        inObjectList = (AssociationList)assocs.get(AssociationName);
        if (inObjectList == null) {
            inObjectList = new AssociationList(AssociationValue.getAssociationName());
            inObject.setMdObjectAssociation(inObjectList);
        }
        if (AssociationValue != null) {
            Vector ids = AssociationValue.getObjectIDs();
            inObjectList.setObjectIDs(ids);
            List deletedObjects = AssociationValue.getDeletedItems();
            if (deletedObjects != null && deletedObjects.size() > 0) {
                for (int i = 0; i < deletedObjects.size(); ++i) {
                    inObjectList._addDeletedItem(deletedObjects.get(i), false);
                }
            }
            MdStore inStore = inObject.getObjectStore();
            boolean processOtherSide = false;
            for (String id : ids) {
                if (inStore.getStoreType() != 1) continue;
                CMetadata otherObject = ((MdObjectStore)inStore).getObject(id, true);
                if (!(otherObject != null || ((MdObjectStore)inStore).getDeletedObjects() != null && ((MdObjectStore)inStore).getDeletedObjects().containsKey(id))) {
                    processOtherSide = true;
                    MdStoreUtil.refreshMetaObject(inStore.getOwningStore(), inStore, id);
                }
                otherObject = null;
            }
            if (processOtherSide) {
                inObjectList.updateOppositeSideAssn();
            }
            inObjectList.setState(AssociationState, false);
        }
        inObjectList = null;
    }

    public static void setMetaObjectAssociation(CMetadata inObject, String AssociationName, AssociationList AssociationValue, int AssociationState) {
        AssociationList inObjectList = null;
        Map<String, AssociationList> assocs = inObject.getAssocsWA();
        inObjectList = assocs.get(AssociationName);
        if (inObjectList == null) {
            inObjectList = new AssociationList(AssociationValue.getAssociationName());
            inObject.setMdObjectAssociation(inObjectList);
        }
        if (AssociationValue != null) {
            Vector ids = AssociationValue.getObjectIDs();
            inObjectList.setObjectIDs(ids);
            List deletedObjects = AssociationValue.getDeletedItems();
            if (deletedObjects != null && deletedObjects.size() > 0) {
                for (int i = 0; i < deletedObjects.size(); ++i) {
                    inObjectList._addDeletedItem(deletedObjects.get(i), false);
                }
            }
            MdStore inStore = inObject.getObjectStore();
            boolean processOtherSide = false;
            for (String id : ids) {
                if (inStore.getStoreType() != 1) continue;
                CMetadata otherObject = ((MdObjectStore)inStore).getObject(id, true);
                if (!(otherObject != null || ((MdObjectStore)inStore).getDeletedObjects() != null && ((MdObjectStore)inStore).getDeletedObjects().containsKey(id))) {
                    processOtherSide = true;
                    MdStoreUtil.refreshMetaObject(inStore.getOwningStore(), inStore, id);
                }
                otherObject = null;
            }
            if (processOtherSide) {
                inObjectList.updateOppositeSideAssn();
            }
            inObjectList.setState(AssociationState, false);
        }
        inObjectList = null;
        MapPool.instance();
        MapPool.returnMap(assocs);
        assocs = null;
    }

    public static void setMetaObjectAttribute(CMetadata targetObject, String AttributeName, String AttributeValue, int AttributeValueState) {
        Class[] attr_classes = new Class[]{String.class, Integer.TYPE};
        try {
            StringBuffer strTemp = new StringBuffer("set");
            strTemp.append(AttributeName);
            Object[] args = new Object[]{AttributeValue, Converter.toInteger(AttributeValueState)};
            Method method = targetObject.getClass().getMethod(strTemp.toString(), attr_classes);
            method.invoke((Object)targetObject, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getMetaObjectAttributeState(CMetadata inObject, String AttributeName) {
        int returnvalue = 0;
        try {
            Map<String, Integer> stateMap = inObject.getAttrsStates();
            Integer returnInt = stateMap.get(AttributeName);
            MapPool.instance();
            MapPool.returnMap(stateMap);
            stateMap = null;
            returnvalue = returnInt;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnvalue;
    }

    public static int getMetaObjectAssociationState(CMetadata inObject, String AssociationName) {
        int returnvalue = 0;
        Map<String, AssociationList> myAssocs = inObject.getAssocs();
        AssociationList myList = myAssocs.get(AssociationName);
        if (myList != null) {
            returnvalue = myList.getState();
        }
        MapPool.instance();
        MapPool.returnMap(myAssocs);
        myAssocs = null;
        return returnvalue;
    }

    public static void copyObjectAttributes(CMetadata sourceObject, CMetadata targetObject) {
        MdStoreUtil.copyObjectAttributes(sourceObject, targetObject, 1);
    }

    public static void copyObjectAttributes(CMetadata sourceObject, CMetadata targetObject, int State2) {
        Map<String, String> sourceAttrs = sourceObject.getAttrs();
        sourceAttrs.remove("Id");
        sourceAttrs.remove("ChangeState");
        sourceAttrs.remove("LockedBy");
        MdStoreUtil.setMetaObjectAttributes(sourceObject, targetObject, sourceAttrs, State2);
        MapPool.instance();
        MapPool.returnMap(sourceAttrs);
        sourceAttrs = null;
    }
}

