/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.MapPool;
import com.sas.metadata.MdEvent;
import com.sas.metadata.MdException;
import com.sas.metadata.MdFactory;
import com.sas.metadata.MdFactoryEvent;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectListener;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MdStoreIDChangeListener;
import com.sas.metadata.MdStoreListener;
import com.sas.metadata.MetadataObjects;
import com.sas.metadata.Util;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class MdServerStore
implements MdStore,
MdStoreListener,
MetadataObjects,
MdObjectListener {
    protected static Map simpleObjectMap;
    protected EventListenerList MdStoreListenerList = new EventListenerList();
    protected EventListenerList MdObjectListenerList = new EventListenerList();
    protected EventListenerList MdStoreIDChangeListenerList = new EventListenerList();
    private static MdServerStore m_MdServerStoreInstance;
    protected MdFactory m_factory = null;
    protected boolean goToServerForMetadata = true;
    protected List childStores = Collections.synchronizedList(new ArrayList(5));
    private InternalObjectStore _objectStore;

    public MdServerStore(MdFactory owningFactory) {
        this(owningFactory, null);
    }

    private MdServerStore(MdFactory owningFactory, String nullParameter) {
        simpleObjectMap = new HashMap(10);
        simpleObjectMap = Collections.synchronizedMap(simpleObjectMap);
        m_MdServerStoreInstance = this;
        this.m_factory = owningFactory;
        this._objectStore = new InternalObjectStore(m_MdServerStoreInstance, this.m_factory);
    }

    public static MdServerStore getInstance() {
        return MdServerStore.getServerStoreInstance();
    }

    protected static MdServerStore getServerStoreInstance() {
        if (m_MdServerStoreInstance == null) {
            m_MdServerStoreInstance = new MdServerStore(MdObjectFactory.getInstance(), null);
        }
        return m_MdServerStoreInstance;
    }

    @Override
    public MdFactory getFactory() {
        return this.m_factory;
    }

    @Override
    public void setOwningStore(MdStore parent) {
    }

    @Override
    public int getStoreType() {
        return 0;
    }

    @Override
    public void updatedMetadataAll() throws MdException {
        throw new MdException(MdObjectFactory.getBundle().getString("MdServerStore.NoUpdatedMetadataAll.txt"));
    }

    @Override
    public boolean getIsGoToServerForMetadata() {
        return this.goToServerForMetadata;
    }

    @Override
    public void setIsGotToServerForMetadata(boolean goToServer) {
    }

    @Override
    public void setGoToServerForMetadata(boolean goToServer) {
    }

    @Override
    public boolean isGoToServerForMetadata() {
        return this.goToServerForMetadata;
    }

    @Override
    public boolean isDisposed() {
        return this._objectStore.getDetailObjectMap() == null && this.m_factory == null;
    }

    @Override
    public MdStore getOwningStore() {
        return null;
    }

    @Override
    public Map getDetailObjectMap() {
        return this._objectStore.getDetailObjectMap();
    }

    public static Map getSimpleObjectMap() {
        return simpleObjectMap;
    }

    @Override
    public boolean deleteObject(CMetadata inObject) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjectFromStores(String strFQID) {
        CMetadata object = this._objectStore.getObjectFromMap(strFQID);
        if (object != null) {
            Map<String, AssociationList> assns = object.getPopulatedAssocs();
            for (String assnName : assns.keySet()) {
                AssociationList assn = assns.get(assnName);
                if (assn == null) continue;
                assn.removeAllElements();
            }
            MapPool.instance();
            MapPool.returnMap(assns);
            assns = null;
            this._objectStore.removeObjectFromMap(strFQID);
            object = null;
        }
        List list = this.childStores;
        synchronized (list) {
            for (MdStore child : this.childStores) {
                if (child.getStoreType() != 1) continue;
                ((MdObjectStore)child).deleteObjectFromStore(strFQID);
            }
        }
    }

    @Override
    public String makeID(String shortID) {
        return MdObjectFactory.makeID(shortID);
    }

    @Override
    public CMetadata restoreObject(String objectID) {
        return null;
    }

    public void deleteComplexMetadataObject(CMetadata oDelete) {
    }

    @Override
    public void resetStates(List items) {
    }

    public void deleteDetailMetadataObject(String strFQID) {
        CMetadata delobject = this._objectStore.getObjectFromMap(strFQID);
        if (delobject != null) {
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            MdEvent removedEvent = new MdEvent(delobject, this);
            this.fireMdObjectsRemoved(removedEvent, items);
            removedEvent = null;
            items.clear();
            items = null;
            delobject.dispose();
            this._objectStore.addObjectToMap(strFQID, null);
            this._objectStore.removeObjectFromMap(strFQID);
            delobject = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDetailHashMap() {
        if (this.m_factory.getDebug()) {
            Map objectMap;
            Map map = objectMap = this._objectStore.getDetailObjectMap();
            synchronized (map) {
                Vector values = new Vector(objectMap.values());
                if (values.size() == 0) {
                    Util.printOutputln("DEBUG GOOD NEWS:  Server Store map is empty");
                    return;
                }
                Util.printOutputln("DEBUG BAD NEWS:  Server Store map is not empty!");
                for (int i = 0; i < values.size(); ++i) {
                    Util.printOutputln("  Object type=" + ((CMetadata)values.elementAt(i)).getCMetadataType() + " id=" + ((CMetadata)values.elementAt(i)).getFQID());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpDetailAllHashMaps() {
        if (this.m_factory.getDebug()) {
            this.dumpDetailHashMap();
            List list = this.childStores;
            synchronized (list) {
                for (MdStore cStore : this.childStores) {
                    if (cStore.getStoreType() != 1) continue;
                    ((MdObjectStore)cStore).dumpDetailHashMap();
                }
            }
        }
    }

    public CMetadata getObject(String strFQID, boolean hashonly) {
        CMetadata meta = this._objectStore.getObjectFromMap(strFQID);
        if (meta == null) {
            meta = this.getObjectInChildStore(strFQID);
        }
        return meta;
    }

    @Override
    public CMetadata getObject(String strFQID) {
        return this.getObject(strFQID, true);
    }

    protected CMetadata getObjectFromServerStoreOnly(String objectID) {
        return this._objectStore.getObjectFromMap(objectID);
    }

    protected boolean isObjectInServerStore(String objectID) {
        CMetadata meta = this._objectStore.getObjectFromMap(objectID);
        return meta != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void changeHashKey(String strOldId, String strNewId) {
        Object removedEvent;
        CMetadata object = this._objectStore.getObjectFromMap(strOldId);
        ArrayList<String> itemsOld = null;
        ArrayList<String> itemsNew = null;
        if (object != null) {
            itemsOld = new ArrayList<String>(1);
            itemsNew = new ArrayList<String>(1);
            this._objectStore.removeObjectFromMap(strOldId);
            itemsOld.add(strOldId);
            removedEvent = new MdEvent(this, this);
            this.fireMdObjectsRemoved((MdEvent)removedEvent, itemsOld);
            removedEvent = null;
            itemsNew.add(strNewId);
            this._objectStore.addObjectToMap(strNewId, object);
            MdEvent addedEvent = new MdEvent(this, this);
            this.fireMdObjectsAdded(addedEvent, itemsNew);
            addedEvent = null;
            if (object.getFQID().equalsIgnoreCase(strOldId)) {
                object.setFQID(strNewId);
            }
            object.updateAssnsIds(strOldId, strNewId);
        }
        removedEvent = this.childStores;
        synchronized (removedEvent) {
            for (MdStore cStore : this.childStores) {
                cStore.changeHashKey(strOldId, strNewId);
            }
        }
        if (object != null && itemsOld != null) {
            MdEvent idEvent = new MdEvent(this, this);
            this.fireMdStoreIDChange(idEvent, itemsOld, itemsNew);
            idEvent = null;
            itemsOld.clear();
            itemsOld = null;
            itemsNew.clear();
            itemsNew = null;
        }
    }

    @Override
    public void createExternalIdentityObject(CMetadata owningObject) {
    }

    @Override
    public void flushUpdates(List updatedItems) {
        this.flushUpdates(this, updatedItems);
    }

    protected void flushUpdates(MdStore owningStore, List updatedItems) {
        int nItems = updatedItems.size();
        ArrayList<String> idList = new ArrayList<String>(nItems);
        LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>(nItems);
        for (int iItem = 0; iItem < nItems; ++iItem) {
            CMetadata meta = (CMetadata)updatedItems.get(iItem);
            String id = meta.getFQID();
            idList.add(meta.getFQID());
            objectMap.put(id, meta.getCMetadataType());
        }
        MdEvent modifiedEvent = new MdEvent(this, owningStore);
        this.fireMdObjectsModified(modifiedEvent, idList);
        modifiedEvent = null;
        MdFactoryEvent event = new MdFactoryEvent(this.m_factory, objectMap);
        MdObjectFactory.fireMdObjectsModified(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map objectMap;
        Map map = objectMap = this._objectStore.getDetailObjectMap();
        synchronized (map) {
            Object[] objects = objectMap.keySet().toArray();
            for (int i = 0; objects != null && i < objects.length; ++i) {
                String id = (String)objects[i];
                if (this.isChildUsingObject(id)) continue;
                this.deleteDetailMetadataObject(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAllStoresAndExit() {
        if (this.isDisposed()) {
            Util.printOutputln("DEBUG NOTE: MdServerStore already disposed...");
            return;
        }
        Object object = this.childStores;
        synchronized (object) {
            for (int i = this.childStores.size(); i > 0; --i) {
                MdStore cStore = (MdStore)this.childStores.get(i - 1);
                if (cStore == null) continue;
                cStore.dispose();
            }
        }
        this.MdStoreListenerList = null;
        this._objectStore.dispose();
        this.m_factory = null;
        this.MdObjectListenerList = null;
        this.MdStoreIDChangeListenerList = null;
        m_MdServerStoreInstance = null;
        object = simpleObjectMap;
        synchronized (object) {
            Object[] simples = simpleObjectMap.keySet().toArray();
            for (int j = 0; j < simples.length; ++j) {
                CMetadata simpleObject = (CMetadata)simpleObjectMap.get(simples[j]);
                if (simpleObject != null) {
                    simpleObject.dispose();
                }
                simpleObject = null;
            }
            Object var2_3 = null;
        }
    }

    public void removeStore(MdStore childStore) {
        this.removeChildStore(childStore);
        if (childStore.getStoreType() == 1) {
            Map objectMap = ((MdObjectStore)childStore).getDetailObjectMap();
            if (objectMap != null) {
                Object[] detailObjects = objectMap.keySet().toArray();
                for (int i = 0; i < detailObjects.length; ++i) {
                    String id = (String)detailObjects[i];
                    if (!this.isChildUsingObject(id)) {
                        this.deleteDetailMetadataObject(id);
                    }
                    ((MdObjectStore)childStore).deleteDetailMetadataObject(id);
                }
            }
            childStore = null;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChildUsingObject(String objectID) {
        List list = this.childStores;
        synchronized (list) {
            for (MdStore child : this.childStores) {
                CMetadata metaObject;
                if (child.getStoreType() != 1 || (metaObject = ((MdObjectStore)child).getObject(objectID, true)) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMetadata getObjectInChildStore(String objectID) {
        List list = this.childStores;
        synchronized (list) {
            for (MdStore child : this.childStores) {
                CMetadata metaObject;
                if (child.getStoreType() != 1 || (metaObject = ((MdObjectStore)child).getObject(objectID, true)) == null) continue;
                return metaObject;
            }
        }
        return null;
    }

    @Override
    public List getChangedObjects() {
        return new ArrayList();
    }

    @Override
    public void MdObjectModified(MdEvent e) {
    }

    @Override
    public void MdObjectsAdded(MdEvent e, List items) {
    }

    @Override
    public void MdObjectsRemoved(MdEvent e, List items) {
    }

    @Override
    public void MdObjectsModified(MdEvent e, List items) {
    }

    public void addMdObjectListener(MdObjectListener l) {
        this.MdObjectListenerList.add(MdObjectListener.class, l);
    }

    public void removeMdObjectListener(MdObjectListener l) {
        this.MdObjectListenerList.remove(MdObjectListener.class, l);
    }

    public void addMdStoreIDChangeListener(MdStoreIDChangeListener l) {
        this.MdStoreIDChangeListenerList.add(MdStoreIDChangeListener.class, l);
        this.MdStoreListenerList.add(MdStoreListener.class, l);
    }

    public void removeMdStoreIDChangeListener(MdStoreIDChangeListener l) {
        this.MdStoreIDChangeListenerList.remove(MdStoreIDChangeListener.class, l);
        this.MdStoreListenerList.remove(MdStoreListener.class, l);
    }

    @Override
    public void addMdStoreListener(MdStoreListener l) {
        this.MdStoreListenerList.add(MdStoreListener.class, l);
    }

    @Override
    public void removeMdStoreListener(MdStoreListener l) {
        this.MdStoreListenerList.remove(MdStoreListener.class, l);
    }

    public synchronized void fireMdObjectModified(MdEvent e) {
        Object[] listeners = this.MdObjectListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectListener.class) continue;
            ((MdObjectListener)listeners[i + 1]).MdObjectModified(e);
        }
    }

    @Override
    public synchronized void fireMdObjectsModified(MdEvent e, List items) {
        Object[] listeners = this.MdStoreListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreListener.class) continue;
            ((MdStoreListener)listeners[i + 1]).MdObjectsModified(e, items);
        }
    }

    public synchronized void fireMdStoreIDChange(MdEvent e, List idsOld, List idsNew) {
        Object[] listeners = this.MdStoreIDChangeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreIDChangeListener.class) continue;
            ((MdStoreIDChangeListener)listeners[i + 1]).MdStoreIDChange(e, idsOld, idsNew);
        }
    }

    @Override
    public synchronized void fireMdObjectsAdded(MdEvent e, List ids) {
        Object[] listeners = this.MdStoreListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreListener.class) continue;
            ((MdStoreListener)listeners[i + 1]).MdObjectsAdded(e, ids);
        }
    }

    @Override
    public synchronized void fireMdObjectsRemoved(MdEvent e, List ids) {
        Object[] listeners = this.MdStoreListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreListener.class) continue;
            ((MdStoreListener)listeners[i + 1]).MdObjectsRemoved(e, ids);
        }
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener l) {
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener l) {
    }

    @Override
    public void updateChangeListObjectIDs(String OldReposID, String NewReposID) {
    }

    @Override
    public void updateChangeListObjectIDs(String OldReposID, String NewReposID, String targetReposID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearObjectsFromStore() {
        Map objectMap;
        ArrayList objects = new ArrayList();
        Map map = objectMap = this._objectStore.getDetailObjectMap();
        synchronized (map) {
            Iterator keyI = objectMap.keySet().iterator();
            while (keyI.hasNext()) {
                objects.add(keyI.next());
            }
        }
        for (String id : objects) {
            if (id == null) continue;
            this.deleteDetailMetadataObject(id);
        }
    }

    @Override
    public List getCreatedItemsList() {
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCreatedItemsList(List items) {
        List list = this.childStores;
        synchronized (list) {
            for (MdStore cStore : this.childStores) {
                cStore.updateCreatedItemsList(items);
            }
        }
    }

    @Override
    public void addChildStore(MdStore inStore) {
        if (!this.childStores.contains(inStore)) {
            this.childStores.add(inStore);
        }
    }

    @Override
    public void removeChildStore(MdStore inStore) {
        if (this.childStores.contains(inStore)) {
            this.childStores.remove(inStore);
        }
    }

    static {
        m_MdServerStoreInstance = null;
    }

    private class InternalObjectStore
    extends MdObjectStore {
        public InternalObjectStore(MdServerStore serverStore, MdFactory factory) {
            super(serverStore, factory, "ServerStore");
            serverStore.removeChildStore(this);
            serverStore.removeMdStoreListener(this);
        }

        public CMetadata getObjectFromMap(String objectID) {
            return (CMetadata)this.ObjectMap.get(objectID);
        }

        public void addObjectToMap(String id, Object meta) {
            this.ObjectMap.put(id, meta);
        }

        public void removeObjectFromMap(String id) {
            this.ObjectMap.remove(id);
        }

        @Override
        public void addChildStore(MdStore inStore) {
            throw new UnsupportedOperationException("Cannot create child stores");
        }

        @Override
        public void updatedMetadataAll() throws MdException {
            throw new MdException(MdObjectFactory.getBundle().getString("MdServerStore.NoUpdatedMetadataAll.txt"));
        }
    }
}

