/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.AssociationList;
import com.sas.metadata.AuthenticationDomain;
import com.sas.metadata.DatabaseSchema;
import com.sas.metadata.DeployedDataPackage;
import com.sas.metadata.Directory;
import com.sas.metadata.File;
import com.sas.metadata.Identity;
import com.sas.metadata.LogicalServer;
import com.sas.metadata.Login;
import com.sas.metadata.MdException;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MetadataResource;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.Property;
import com.sas.metadata.Root;
import com.sas.metadata.SASClientConnection;
import com.sas.metadata.SASLibrary;
import com.sas.metadata.SASPassword;
import com.sas.metadata.ServerComponent;
import com.sas.metadata.TCPIPConnection;
import com.sas.metadata.Util;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MdModelUtil {
    static String m_OverrideLibref;
    static boolean m_bIsRemote;
    protected static MetadataResource bundle;

    public static String accessPath(SASLibrary iMeta) throws MdException {
        return MdModelUtil.accessPath(iMeta, false);
    }

    public static String accessPath(SASLibrary iMeta, String sLibref) throws MdException {
        return MdModelUtil.accessPath(iMeta, sLibref, false);
    }

    public static String accessPath(SASLibrary iMeta, String sLibref, boolean b_encodePassword) throws MdException {
        return MdModelUtil.accessPath(iMeta, sLibref, b_encodePassword, true);
    }

    public static String accessPath(SASLibrary iMeta, String sLibref, boolean b_encodePassword, boolean genFileNameForXML) throws MdException {
        m_OverrideLibref = sLibref;
        String path = MdModelUtil.accessPath(iMeta, b_encodePassword, genFileNameForXML);
        m_OverrideLibref = null;
        return path;
    }

    public static String accessPath(SASLibrary iMeta, boolean b_encodePassword) throws MdException {
        return MdModelUtil.accessPath(iMeta, b_encodePassword, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String accessPath(SASLibrary iMeta, boolean b_encodePassword, boolean genFileNameForXML) throws MdException {
        ServerComponent iContentServer;
        AssociationList lContentServers;
        StringBuffer libref = new StringBuffer();
        m_bIsRemote = iMeta.getEngine().toUpperCase().startsWith("REMOTE") && iMeta.getIsDBMSLibname() > 0;
        File xmlMapFile = null;
        File xmlFile = null;
        if (!m_bIsRemote) {
            for (int i = 0; i < iMeta.getUsingPackages().size(); ++i) {
                DeployedDataPackage iDDP = (DeployedDataPackage)iMeta.getUsingPackages().get(i);
                if (iDDP instanceof SASLibrary) {
                    libref.append(MdModelUtil.accessPath((SASLibrary)iDDP));
                    continue;
                }
                if (!(iDDP instanceof File) || !iMeta.getEngine().equalsIgnoreCase("XML") || !genFileNameForXML) continue;
                File tempfile = (File)iDDP;
                if (tempfile.getTextRole().equalsIgnoreCase("XMLLibraryFile")) {
                    xmlFile = tempfile;
                    if ("".equals(iMeta.getLibref().trim())) throw new MdException(bundle.getString("MdModelUtil.noLibref.msg.txt"));
                    libref.append("filename ");
                    libref.append(m_OverrideLibref == null ? iMeta.getLibref() : m_OverrideLibref);
                    libref.append(" ").append(MdModelUtil.processPath(xmlFile)).append(";\n");
                    continue;
                }
                if (!tempfile.getTextRole().equalsIgnoreCase("XMLLibraryMap")) continue;
                xmlMapFile = tempfile;
            }
        }
        boolean m_bHasContentServer = false;
        AssociationList lDDP = iMeta.getUsingPackages();
        if (lDDP.size() > 0 && (lContentServers = ((DeployedDataPackage)lDDP.get(0)).getDeployedComponents()).size() > 0 && ((iContentServer = (ServerComponent)lContentServers.get(0)).getProductName().equals("Http Server") || iContentServer.getProductName().equals("Ftp Server"))) {
            m_bHasContentServer = true;
        }
        if (iMeta != null) {
            if (iMeta.getIsPreassigned() == 0) {
                libref.append("LIBNAME ");
                String temp = "";
                if (m_OverrideLibref == null) {
                    if (iMeta.getLibref().trim().compareTo("") == 0) throw new MdException(bundle.getString("MdModelUtil.noLibref.msg.txt"));
                    temp = temp + iMeta.getLibref() + " ";
                } else {
                    temp = temp + m_OverrideLibref + " ";
                }
                if (iMeta.getEngine().trim().compareTo("") != 0) {
                    temp = temp + iMeta.getEngine() + " ";
                }
                if (iMeta.getIsDBMSLibname() == 0 && xmlFile == null) {
                    temp = m_bHasContentServer ? temp + MdModelUtil.processContentServerPath(iMeta, b_encodePassword) : temp + MdModelUtil.processPath(iMeta);
                }
                libref.append(temp);
                boolean isSPDS = false;
                boolean isTKTS = false;
                if (iMeta.getEngine().equalsIgnoreCase("SASSPDS")) {
                    isSPDS = true;
                } else if (iMeta.getEngine().equalsIgnoreCase("SASTS")) {
                    isTKTS = true;
                } else if (xmlMapFile != null) {
                    libref.append("xmlmap=").append(MdModelUtil.processPath(xmlMapFile)).append(" ");
                }
                if (iMeta.getProperties().size() > 0 && !isTKTS) {
                    libref.append(MdModelUtil.processProperties(iMeta.getProperties()));
                }
                if (iMeta.getIsDBMSLibname() > 0) {
                    String strRetValue;
                    boolean useLogin = true;
                    SASClientConnection iDbms = iMeta.getLibraryConnection();
                    if (iDbms == null) {
                        throw new MdException(bundle.getString("MdModelUtil.ConnectionRequired.msg.txt"));
                    }
                    if (iMeta.getEngine().equalsIgnoreCase("SASTS") && iDbms.getProperties().size() == 0) {
                        libref.append(MdModelUtil.getConnectionOptions(iMeta));
                    }
                    if (iDbms.getProperties().size() > 0 && (strRetValue = MdModelUtil.getConnectionOptions(iMeta)) != null && strRetValue.length() > 0) {
                        libref.append(MdModelUtil.getConnectionOptions(iMeta));
                    }
                    if (iMeta.getEngine().equalsIgnoreCase("SASIOIME")) {
                        useLogin = false;
                        libref.append(MdModelUtil.processInfomapProperties(iMeta, b_encodePassword));
                    }
                    DeployedDataPackage iPkg = null;
                    if (iMeta.getUsingPackages().size() <= 0) {
                        throw new MdException(bundle.getString("MdModelUtil.NoAssociatedDataPackages.msg.txt"));
                    }
                    iPkg = (DeployedDataPackage)iMeta.getUsingPackages().get(0);
                    DatabaseSchema iSchema = null;
                    SASLibrary iServerLibrary = null;
                    if (iPkg instanceof DatabaseSchema) {
                        iSchema = (DatabaseSchema)iPkg;
                    } else {
                        if (!(iPkg instanceof SASLibrary) || !m_bIsRemote) throw new MdException(bundle.getString("MdModelUtil.InvalidDataPackageType.msg.txt"));
                        iServerLibrary = (SASLibrary)iPkg;
                    }
                    if (iSchema != null && iSchema.getSchemaName() != null && iSchema.getSchemaName().length() > 0 && !isSPDS) {
                        libref.append(" SCHEMA=").append(iSchema.getSchemaName()).append(" ");
                    }
                    if (iServerLibrary != null) {
                        libref.append("slibref=").append(iServerLibrary.getLibref()).append(" ");
                    }
                    if (m_bIsRemote) {
                        String pw;
                        useLogin = false;
                        SASPassword sapw = iDbms.getSAPW();
                        if (sapw != null && (pw = sapw.getPassword()) != null && pw.compareTo("") != 0) {
                            if (b_encodePassword) {
                                pw = MdModelUtil.encodePassword(pw);
                            }
                            libref.append("sapw=\"").append(pw).append("\" ");
                        }
                    } else {
                        Login bestLogin;
                        try {
                            SASClientConnection scc;
                            ServerComponent dbms;
                            String productName;
                            if (iMeta.getIsDBMSLibname() > 0 && (productName = (dbms = (ServerComponent)(scc = iMeta.getLibraryConnection()).getSource()).getProductName()).equals("DB2OS390")) {
                                useLogin = false;
                            }
                        }
                        catch (Exception e) {
                            useLogin = false;
                        }
                        if (useLogin && !isSPDS && !isTKTS) {
                            bestLogin = MdModelUtil.getBestLogin(iMeta);
                            libref.append(MdModelUtil.getBestLoginString(bestLogin, b_encodePassword));
                        } else if (useLogin && isTKTS) {
                            bestLogin = MdModelUtil.getBestLogin(iMeta);
                            boolean b_quotePassword = true;
                            libref.append(MdModelUtil.getBestLoginString(bestLogin, b_encodePassword, b_quotePassword));
                        }
                    }
                }
                libref.append(";\n");
            } else {
                libref.append("libname ").append(iMeta.getLibref()).append(" list;");
            }
        }
        if (libref.toString().length() <= 256) return libref.toString();
        String[] parts = libref.toString().split(" ");
        StringBuffer libBuffer = new StringBuffer();
        int lcount = 0;
        int x = 0;
        for (int i = 0; i < parts.length; ++i) {
            x = parts[i].length();
            if (x > 255) {
                String[] sub = parts[i].split(";");
                if (sub.length > 0) {
                    libBuffer.append(sub[0]);
                    libBuffer.append(";");
                    libBuffer.append("\n");
                    for (int j = 1; j < sub.length; ++j) {
                        libBuffer.append(sub[j]);
                        libBuffer.append(";");
                    }
                    libBuffer.append("\n");
                }
                lcount = 0;
                continue;
            }
            if (x + lcount > 255) {
                libBuffer.append("\n");
                lcount = 0;
            }
            libBuffer.append(parts[i]).append(" ");
            lcount += x + 1;
        }
        return libBuffer.toString();
    }

    private static StringBuffer processPath(File file) {
        StringBuffer returnStr = new StringBuffer();
        String path = file.getFileName();
        if (!path.startsWith("\"")) {
            returnStr.append("\"");
        }
        returnStr.append(path);
        if (!path.endsWith("\"")) {
            returnStr.append("\" ");
        }
        return returnStr;
    }

    protected static String processProperties(List lProps) {
        String retStr = "";
        for (int i = 0; i < lProps.size(); ++i) {
            Property iProp = (Property)lProps.get(i);
            if (iProp.getUseValueOnly() != 0) {
                retStr = retStr + " " + iProp.getDefaultValue() + " ";
                continue;
            }
            if (iProp.getDefaultValue() == null || iProp.getDefaultValue().length() == 0) continue;
            retStr = retStr + " " + iProp.getPropertyName() + iProp.getDelimiter() + iProp.getDefaultValue() + " ";
        }
        return retStr;
    }

    private static String processPath(SASLibrary iLib) throws MdException {
        String returnStr = "";
        AssociationList packages = iLib.getUsingPackages();
        int packagesFound = 0;
        for (int i = 0; i < packages.size(); ++i) {
            DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
            if (iDDP instanceof SASLibrary) {
                returnStr = returnStr + ((SASLibrary)iDDP).getLibref() + " ";
                ++packagesFound;
                continue;
            }
            if (!(iDDP instanceof Directory)) continue;
            String path = ((Directory)iDDP).getDirectoryName();
            if (!path.startsWith("\"")) {
                returnStr = returnStr + "\"";
            }
            returnStr = returnStr + path;
            if (!path.endsWith("\"")) {
                returnStr = returnStr + "\" ";
            }
            ++packagesFound;
        }
        if (packagesFound > 1) {
            returnStr = "(" + returnStr + ")";
        }
        return returnStr;
    }

    private static String processContentServerPath(SASLibrary iLib, boolean b_encodePassword) throws MdException {
        String returnStr = new String();
        AssociationList packages = iLib.getUsingPackages();
        if (packages.size() > 1) {
            returnStr = returnStr + "(";
        }
        DeployedDataPackage temp = (DeployedDataPackage)iLib.getUsingPackages().get(0);
        Directory iDir = null;
        if (!(temp instanceof Directory)) {
            throw new MdException(bundle.getString("MdModelUtil.WebDAVPath.msg.txt"));
        }
        iDir = (Directory)temp;
        ServerComponent iContentServer = (ServerComponent)iDir.getDeployedComponents().get(0);
        TCPIPConnection iConn = (TCPIPConnection)iContentServer.getSourceConnections().get(0);
        String sHostName = iConn.getHostName();
        String sAppProtocol = iConn.getApplicationProtocol();
        int sPort = iConn.getPort();
        boolean supportsDAV = false;
        for (int i = 0; i < packages.size(); ++i) {
            iDir = (Directory)packages.get(i);
            AssociationList props = iDir.getProperties();
            for (int j = 0; j < props.size(); ++j) {
                Property iProp = (Property)props.get(j);
                if (!iProp.getPropertyName().equals("SupportsWebDAV") || !iProp.getDefaultValue().equals("1")) continue;
                supportsDAV = true;
            }
            if (!supportsDAV) {
                throw new MdException(bundle.getString("MdModelUtil.WebDAVPathType.msg.txt"));
            }
            String path = sAppProtocol + "://" + sHostName + ":" + sPort + iDir.getDirectoryName();
            if (!path.startsWith("\"")) {
                returnStr = returnStr + "\"";
            }
            returnStr = returnStr + path;
            if (path.endsWith("\"")) continue;
            returnStr = returnStr + "\" ";
        }
        if (packages.size() > 1) {
            returnStr = returnStr + ")";
        }
        if (supportsDAV) {
            returnStr = returnStr + " WEBDAV ";
        }
        AuthenticationDomain iDom = iConn.getDomain();
        PasswordAuthentication pw = null;
        if (iDom != null) {
            IOMI mdconn = MetadataWorkspace.getWorkspace().getCMRHandle();
            pw = MdModelUtil.getCredential(mdconn, iDom.getName(), MdModelUtil.getReposID(iLib.getId()));
        }
        if (pw != null) {
            String password = new String(pw.getPassword());
            if (b_encodePassword) {
                password = MdModelUtil.encodePassword(password);
            }
            returnStr = returnStr + "USER=\"" + pw.getUserName() + "\" PASSWORD=\"" + password + "\"";
        }
        return returnStr;
    }

    private static String processInfomapProperties(SASLibrary iLib, boolean bEncode) throws MdException {
        String returnStr = new String();
        SASClientConnection iConn = iLib.getLibraryConnection();
        String host = iConn.getRemoteAddress();
        int port = iConn.getPort();
        String reposName = "";
        List lRepos = MetadataUtil.getRepositories();
        for (int i = 0; i < lRepos.size(); ++i) {
            String libReposID;
            String reposID = ((Root)lRepos.get(i)).getId();
            if (reposID.compareToIgnoreCase(libReposID = MdModelUtil.getReposID(iLib.getId())) != 0) continue;
            reposName = ((Root)lRepos.get(i)).getName();
            break;
        }
        Login iLogin = MdModelUtil.getBestLogin(iLib);
        if (host != null) {
            returnStr = returnStr + "MetaServer=\"" + host + "\" ";
        }
        if (port != 0) {
            returnStr = returnStr + "MetaPort=" + port + " ";
        }
        if (reposName != null) {
            returnStr = returnStr + "MetaRepository=\"" + reposName + "\" ";
        }
        if (iLogin != null) {
            returnStr = returnStr + "MetaUser=\"" + iLogin.getUserID() + "\" ";
            String pw = iLogin.getPassword();
            if (pw != null && pw.length() > 0) {
                if (bEncode) {
                    pw = MdModelUtil.encodePassword(pw);
                }
                returnStr = returnStr + "MetaPass=\"" + pw + "\" ";
            }
        }
        return returnStr;
    }

    private static String processTableConnectionProperties(SASClientConnection conn) throws MdException {
        String retString = "";
        if (!conn.getApplicationProtocol().equalsIgnoreCase("TKTS")) {
            return retString;
        }
        if (conn.getCommunicationProtocol().equalsIgnoreCase("LOCAL")) {
            retString = retString.concat("TSID=\"" + conn.getSource().getFQID() + "\" ");
            return retString;
        }
        if (conn.getCommunicationProtocol().equalsIgnoreCase("TCP")) {
            retString = retString.concat("PROTOCOL=BRIDGE ");
        } else if (conn.getCommunicationProtocol().equalsIgnoreCase("COM")) {
            retString = retString.concat("PROTOCOL=COM ");
        }
        retString = retString.concat("SERVER=\"" + conn.getRemoteAddress() + "\" ");
        if (conn.getCommunicationProtocol().equalsIgnoreCase("TCP")) {
            retString = retString.concat("PORT=" + String.valueOf(conn.getPort()) + " ");
        }
        if (conn.getService().length() > 0) {
            retString = retString.concat("SERVICE=" + conn.getService() + " ");
        }
        return retString;
    }

    public static String getConnectionOptions(SASLibrary iMeta) throws MdException {
        String retString = "";
        if (iMeta.getEngine().equals("SASSPDS")) {
            DatabaseSchema iSchema = (DatabaseSchema)iMeta.getUsingPackages().get(0);
            retString = retString.concat(" schema=\"").concat(iSchema.getSchemaName()).concat("\"");
            Login iLogin = MdModelUtil.getBestLogin(iMeta);
            String loginStr = "";
            if (iLogin != null) {
                if (iLogin.getUserID() != null && iLogin.getUserID().length() != 0) {
                    loginStr = loginStr.concat(" USER=\"" + iLogin.getUserID() + "\"");
                }
                if (iLogin.getPassword() != null && iLogin.getPassword().length() != 0) {
                    String pass = iLogin.getPassword();
                    pass = MdModelUtil.encodePassword(pass);
                    loginStr = loginStr.concat(" PASSWORD=\"" + pass + "\" ");
                }
                retString = retString.concat(loginStr);
            }
        }
        SASClientConnection iDbms = iMeta.getLibraryConnection();
        if (iMeta.getEngine().equalsIgnoreCase("SASTS")) {
            retString = retString.concat(MdModelUtil.processProperties(iMeta.getProperties()));
            if (iDbms != null) {
                retString = retString.concat(MdModelUtil.processTableConnectionProperties(iDbms));
            }
        }
        if (iDbms != null && iDbms.getProperties().size() > 0) {
            retString = retString.concat(MdModelUtil.processProperties(iDbms.getProperties()));
        }
        return retString;
    }

    public static Login getBestLogin(SASLibrary iMeta) throws MdException {
        AuthenticationDomain iDom;
        AssociationList lLogins = iMeta.getDefaultLogins(true);
        if (lLogins.size() > 0) {
            return (Login)lLogins.get(0);
        }
        SASClientConnection iDbms = iMeta.getLibraryConnection();
        if (iDbms != null && (iDom = iDbms.getDomain()) != null) {
            IOMI mdconn = MetadataWorkspace.getWorkspace().getCMRHandle();
            Login login = MdModelUtil.getLogin(mdconn, iDom, iDom.getName());
            return login;
        }
        return null;
    }

    public static String getBestLoginString(Login iLogin, boolean b_encodePassword, boolean b_quotePassword) throws MdException {
        String strBestLogin = new String("");
        if (iLogin != null) {
            if (iLogin.getUserID() != null && iLogin.getUserID().length() != 0) {
                strBestLogin = " USER=" + iLogin.getUserID() + " ";
                if (b_quotePassword) {
                    strBestLogin = " USER=\"" + iLogin.getUserID() + "\" ";
                }
            }
            if (iLogin.getPassword() != null && iLogin.getPassword().length() != 0) {
                String pw = iLogin.getPassword();
                if (b_encodePassword) {
                    pw = MdModelUtil.encodePassword(pw);
                }
                strBestLogin = strBestLogin + " PASSWORD=\"" + pw + "\" ";
            }
        }
        return strBestLogin;
    }

    public static String getBestLoginString(Login iLogin, boolean b_encodePassword) throws MdException {
        return MdModelUtil.getBestLoginString(iLogin, b_encodePassword, false);
    }

    public static String getBestLoginString(Login iLogin) throws MdException {
        return MdModelUtil.getBestLoginString(iLogin, false);
    }

    public static PasswordAuthentication getPasswordAuthentication(String strUserID, String strPassword) {
        PasswordAuthentication credentials = new PasswordAuthentication(strUserID, strPassword.toCharArray());
        return credentials;
    }

    public static PasswordAuthentication getCredential(IOMI metaConn, String strAuthDomain, String strReposID) throws MdException {
        String metadataDomain;
        PasswordAuthentication credentials = null;
        MetadataWorkspace mws = MetadataWorkspace.getWorkspace();
        Map credMap = mws.getCredentialMap();
        if (credMap != null && (metadataDomain = (String)credMap.get("AuthenticationDomain")) != null && metadataDomain.toUpperCase().compareTo(strAuthDomain.toUpperCase()) == 0) {
            String userid = (String)credMap.get("Username");
            String password = (String)credMap.get("Password");
            credentials = new PasswordAuthentication(userid, password.toCharArray());
            MdModelUtil.produceLogMessage("DEBUG NOTE: Reusing cached metadata credentials - " + userid);
            return credentials;
        }
        MdObjectStore store = MdObjectFactory.createObjectStore(null, "Temporary Credential Store");
        Identity iIdentity = null;
        try {
            iIdentity = MdModelUtil.populateStoreWithIdentity(metaConn, store);
        }
        catch (Exception e) {
            MdModelUtil.produceLogMessage("DEBUG NOTE: The following exception occurred retriving metadata. No credentials can be found.");
            Util.printStackTrace(e);
            return null;
        }
        AuthenticationDomain domain = null;
        if (strAuthDomain != null && strAuthDomain.length() > 0) {
            domain = MdModelUtil.getAuthDom(metaConn, store, strAuthDomain, strReposID);
        }
        if (domain == null) {
            MdModelUtil.produceLogMessage("DEBUG NOTE: No AuthenticationDomain so no credentials can be found");
            return null;
        }
        AssociationList lLogins = domain.getLogins(false);
        Vector<Login> listOfLogins = new Vector<Login>();
        for (int i = 0; i < lLogins.size(); ++i) {
            Login iLogin = (Login)lLogins.get(i);
            String password = iLogin.getPassword();
            if (password != null && password.trim().compareTo("") != 0 && password.compareTo("********") != 0) {
                listOfLogins.add(iLogin);
                continue;
            }
            MdModelUtil.produceLogMessage("DEBUG NOTE: The following Login contains an invalid password: " + iLogin.getName());
        }
        if (listOfLogins.size() == 1) {
            Login iLogin = (Login)listOfLogins.get(0);
            credentials = MdModelUtil.getPasswordAuthentication(iLogin.getUserID(), iLogin.getPassword());
            MdModelUtil.produceLogMessage("DEBUG NOTE: The following Login was found in metadata: " + iLogin.getName());
        } else if (listOfLogins.size() > 1) {
            if (iIdentity == null) {
                MdModelUtil.produceLogMessage("DEBUG NOTE: More than one Login found in " + domain.getName() + " and no Identity exists, so none will be used");
            } else {
                MdModelUtil.produceLogMessage("DEBUG NOTE: More than one Login found in " + domain.getName() + " for " + iIdentity.getName() + " so none will be used");
            }
        }
        if (credentials == null) {
            MdModelUtil.produceLogMessage("DEBUG NOTE: No Login chosen in AuthDom: " + domain.getName());
        }
        store.dispose();
        return credentials;
    }

    public static String getReposID(String strObjectID) {
        return "A0000001." + strObjectID.substring(0, 8);
    }

    public static Login getLogin(IOMI iOMI, Root obj, String domainName) throws MdException {
        PasswordAuthentication pw = MdModelUtil.getCredential(iOMI, domainName, MdModelUtil.getReposID(obj.getId()));
        if (pw == null) {
            return null;
        }
        MdObjectStore store = (MdObjectStore)obj.getObjectStore();
        Login iLogin = (Login)MdObjectFactory.createComplexMetadataObject(store, null, "", "Login", "");
        iLogin.setUserID(pw.getUserName());
        iLogin.setPassword(new String(pw.getPassword()));
        store.removeElementFromChangeList(iLogin);
        return iLogin;
    }

    public static Login getLogin(IOMI iOMI, LogicalServer ls, String domainName) throws MdException {
        return MdModelUtil.getLogin(iOMI, (Root)ls, domainName);
    }

    private static AuthenticationDomain getAuthDom(IOMI metaConn, MdObjectStore store, String strAuthDomain, String strReposID) throws MdException {
        int domainIndex = 0;
        String strType = "AuthenticationDomain";
        int flags = 8320;
        String strXMLSelect = "<XMLSELECT search=\"AuthenticationDomain[@Name='" + strAuthDomain + "']\" />";
        List authDomainsList = MetadataUtil.getMetadataObjectsSubset(metaConn, store, strReposID, strType, flags, strXMLSelect, true);
        if (domainIndex < authDomainsList.size()) {
            return (AuthenticationDomain)authDomainsList.get(domainIndex);
        }
        return null;
    }

    protected static Identity populateStoreWithIdentity(IOMI metaConn, MdObjectStore store) throws MdException {
        ISecurity_1_1 iSec = null;
        if (metaConn != null) {
            try {
                iSec = MetadataWorkspace.getWorkspace().MakeISecurityConnection(metaConn);
            }
            catch (RemoteException exc) {
                throw new MdException(exc.getLocalizedMessage());
            }
        }
        StringHolder returnStrHolder = new StringHolder();
        try {
            iSec.GetIdentity("", returnStrHolder);
        }
        catch (Exception exc) {
            throw new MdException(exc);
        }
        Identity iIdentity = null;
        String retValue = returnStrHolder.value;
        if (retValue != null && !retValue.startsWith("UNKNOWN:") && retValue.startsWith("OMSOBJ:")) {
            String objid = returnStrHolder.value.substring(returnStrHolder.value.lastIndexOf(47) + 1);
            String strType = returnStrHolder.value.substring(returnStrHolder.value.lastIndexOf(58) + 1, returnStrHolder.value.lastIndexOf(47));
            String strTemplate = "<TEMPLATES><Person><IdentityGroups/><Logins/></Person><IdentityGroup><IdentityGroups/><Logins/></IdentityGroup><Login><Domain/></Login></TEMPLATES>";
            int flags = 8348;
            Vector inSimpleAttr = new Vector();
            Vector inComplexAttr = new Vector();
            iIdentity = (Identity)MetadataUtil.getMetadataAllDepths(store, strType, objid, inSimpleAttr, inComplexAttr, strTemplate, flags);
        }
        String strOptions = "<XMLSELECT Search=\"*[@name='PUBLIC'";
        if (iIdentity != null) {
            strOptions = strOptions + " OR @name='SASUSERS'";
        }
        strOptions = strOptions + "]\"/>";
        String strTemplate = "<TEMPLATES><IdentityGroup><Logins/></IdentityGroup><Login><Domain/></Login></TEMPLATES>";
        int flags = 8588;
        MetadataUtil.getMetadataObjectsSubset(store, MdModelUtil.getFoundationReposID(metaConn), "IdentityGroup", flags, strOptions + strTemplate);
        return iIdentity;
    }

    private static void produceLogMessage(String message) {
        Util.printOutputln(message);
    }

    private static String getFoundationReposID(IOMI mdconn) throws MdException {
        String repositoryID;
        block4: {
            repositoryID = "";
            StringHolder outXML = new StringHolder();
            String options = "<XMLSELECT search=\"@RepositoryType='FOUNDATION'\"/>";
            int flags = 392;
            try {
                mdconn.GetMetadataObjects("A0000001.A0000001", "RepositoryBase", outXML, "REPOS", flags, options);
                String outXMLString = outXML.value.toString();
                Document mainDoc = MetadataUtil.parseXML(outXMLString);
                if (mainDoc == null) break block4;
                Node firstNode = mainDoc.getFirstChild();
                NodeList nodeList = firstNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NamedNodeMap nodeMap = currentNode.getAttributes();
                    if (nodeMap.getNamedItem("Id") == null) continue;
                    repositoryID = nodeMap.getNamedItem("Id").getNodeValue();
                    break;
                }
            }
            catch (Exception e) {
                MdModelUtil.produceLogMessage("Result of getRepositoryType:" + e.getMessage());
                throw new MdException(e);
            }
        }
        if (repositoryID.equals("")) {
            throw new MdException("Unable to find the Foundation repository");
        }
        return repositoryID;
    }

    private static String encodePassword(String strPassword) {
        SasPasswordString sasPwString = new SasPasswordString();
        String strNewPwString = strPassword;
        try {
            strNewPwString = SasPasswordString.encode((String)"sas001", (String)strPassword);
        }
        catch (SasPasswordEncodingException sasPasswordEncodingException) {
            // empty catch block
        }
        return strNewPwString;
    }

    static {
        m_bIsRemote = false;
        bundle = new MetadataResource(MdModelUtil.class);
    }
}

