/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.authentication.helper.CachedCredentials;
import com.sas.svcs.authentication.helper.CredentialCacheManager;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserContextIdentityInterceptor
implements MethodInterceptor {
    private static final Logger logger = LogManager.getLogger(UserContextIdentityInterceptor.class);
    private final CredentialCacheManager cacheManager;
    private final String id;
    private Set<UserIdentityInterface> cachedIdentities;
    private final UserContextInterface userContext;

    public UserContextIdentityInterceptor(CredentialCacheManager cacheManager, UserContextInterface userContext) throws ServiceException, RemoteException {
        this.cacheManager = cacheManager;
        this.userContext = userContext;
        this.id = userContext.getResolvedUserId();
    }

    private void addIdentities(Collection<UserIdentityInterface> identities) {
        boolean isDebug = logger.isDebugEnabled();
        if (isDebug) {
            logger.debug("Attempting to add " + identities.size() + " identities for cached context");
        }
        if (null == this.cachedIdentities) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating new cached identities set");
            }
            this.cachedIdentities = new HashSet<UserIdentityInterface>();
        }
        for (UserIdentityInterface id : identities) {
            try {
                if (isDebug) {
                    logger.debug("Adding identity " + id.getPrincipal().toString() + " to cached context");
                }
                this.userContext.addIdentity(id);
                this.cachedIdentities.add(id);
            }
            catch (RemoteException e) {
                logger.error("Unable to add identity " + id.getResolvedUserName(), (Throwable)e);
            }
        }
    }

    private void processDifferences(Collection<UserIdentityInterface> ids) {
        boolean isDebug = logger.isDebugEnabled();
        if (isDebug) {
            logger.debug("Processing differences between cached identities and supplied identities");
        }
        Iterator<UserIdentityInterface> iter = this.cachedIdentities.iterator();
        while (iter.hasNext()) {
            UserIdentityInterface identity = iter.next();
            if (isDebug) {
                logger.debug("Processing differences for identity " + identity.getPrincipal().toString() + "@" + identity.getDomain());
            }
            if (!ids.remove(identity)) {
                if (isDebug) {
                    logger.debug("Local cached identity " + identity.getPrincipal().toString() + "@" + identity.getDomain() + " does not exist in new identity list, removing from local cache");
                }
                try {
                    this.userContext.removeIdentity(identity);
                    iter.remove();
                }
                catch (RemoteException e) {
                    logger.error("Could not remove identity " + identity.getResolvedUserName() + " for user " + this.id);
                }
                continue;
            }
            if (!isDebug) continue;
            logger.debug("Local cached identity " + identity.getPrincipal().toString() + "@" + identity.getDomain() + " was present in new identity list, keeping it in the local cache");
        }
        this.addIdentities(ids);
    }

    public synchronized Object invoke(MethodInvocation mi) throws Throwable {
        boolean isDebug = logger.isDebugEnabled();
        if (isDebug) {
            logger.debug("Processing intercepted method " + mi.toString());
        }
        try {
            CachedCredentials cached = this.cacheManager.getCurrent();
            Set<UserIdentityInterface> creds = cached.getCredentials();
            if (isDebug) {
                logger.debug("For session " + cached.getKey() + ", got " + (null == creds ? " 0(null)" : Integer.valueOf(creds.size())) + " credentials from distributed cache for processing");
            }
            if (null != creds) {
                if (null == this.cachedIdentities) {
                    this.addIdentities(creds);
                } else {
                    this.processDifferences(creds);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Error on dynamic identity lookup for method invocation " + mi.getMethod().getName() + " for user " + this.id);
        }
        return mi.proceed();
    }
}

