/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class UserContextFactoryBean
implements FactoryBean<UserContextInterface>,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LogManager.getLogger(UserContextFactoryBean.class);
    private UserServiceInterface userService;
    private SessionServiceInterface sessionService;
    private String userid;
    private String password;
    private String domain;
    private boolean systemUser = true;
    private UserContextInterface user;

    public void setUserService(UserServiceInterface u) {
        this.userService = u;
    }

    public void setSessionService(SessionServiceInterface s) {
        this.sessionService = s;
    }

    public void setDomain(String d) {
        this.domain = d;
    }

    public void setUserid(String u) {
        this.userid = u;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setSystemUser(boolean systemUser) {
        this.systemUser = systemUser;
    }

    public UserContextInterface getObject() throws Exception {
        return this.user;
    }

    public Class<UserContextInterface> getObjectType() {
        return UserContextInterface.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.userid || this.userid.length() == 0) {
            throw new IllegalStateException("No userid specified.");
        }
        if (null == this.password || this.password.length() == 0) {
            throw new IllegalStateException("No password specified.");
        }
        if (null == this.domain || this.domain.length() == 0) {
            throw new IllegalStateException("No domain specified.");
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Creating user with id: " + this.userid + " password: ****** domain: " + this.domain);
            }
            this.user = this.userService.newUser(this.userid, this.password, this.domain);
            if (null != this.sessionService) {
                SessionContextInterface sci = this.sessionService.newSessionContext(this.user);
                if (this.systemUser) {
                    sci.setAttribute("__sas__system__user__", (Object)Boolean.TRUE);
                    sci.setTimeoutDisabled(true);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Unable to initialize user.");
        }
    }

    public void destroy() throws Exception {
        try {
            if (null != this.user) {
                this.user.destroy();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("User " + this.userid + " destroyed.");
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred destroying user, " + this.userid + ". The Platform Services VM should be restarted.");
        }
    }
}

