/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.svcs.authentication.helper.TrustedAuthenticationException;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class TrustedSubjectFactory {
    String domain;
    String loginContextName;

    public TrustedSubjectFactory(String domain, String loginContextName) {
        this.setDomain(domain);
        this.setLoginContextName(loginContextName);
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setLoginContextName(String loginContextName) {
        this.loginContextName = loginContextName;
    }

    public Subject create(String userid) throws TrustedAuthenticationException {
        Subject s;
        try {
            LoginContext ctx = new LoginContext(this.loginContextName, new CallbackHandler(userid, "trustedauthentication"));
            ctx.login();
            s = ctx.getSubject();
        }
        catch (LoginException e) {
            throw new TrustedAuthenticationException(e);
        }
        return s;
    }

    static class CallbackHandler
    implements javax.security.auth.callback.CallbackHandler {
        String userid;
        String password;

        public CallbackHandler() {
        }

        public CallbackHandler(String userid, String password) {
            this.userid = userid;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.userid);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

