/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.Environment;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.JAASUtil;
import com.sas.svcs.authentication.helper.LazySpringSecurityContext;
import java.rmi.RemoteException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SpringSecurityContextFactory {
    private static final Logger logger = LogManager.getLogger(SpringSecurityContextFactory.class);
    private static final long DEFAULT_INTERVAL_CHECK = 15000L;
    private long intervalCheck = 15000L;
    private AuthenticationManager authenticationManager;
    private UserDetailsService userDetailsService;
    private AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource;
    private volatile UserContextInterface trustedUserContext;
    private volatile UserServiceInterface userService;
    private volatile AuthenticationServiceInterface authenticationService;
    private final Object serviceDiscoveryLock = new Object();
    private static final ServiceAuthenticationDetails DEFAULT_DETAILS = new ServiceAuthenticationDetails(){
        private static final long serialVersionUID = 1L;

        public String getServiceUrl() {
            return "http://com.sas.svcs.authentication.helper.SpringSecurityContextFactory";
        }
    };

    @Deprecated
    public void setLoginIdUserDetailsService(UserDetailsService loginIdUserDetailsService) {
        this.userDetailsService = loginIdUserDetailsService;
    }

    @Deprecated
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @Autowired(required=false)
    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    @Autowired(required=false)
    public void setUserService(UserServiceInterface userService) {
        this.userService = userService;
    }

    @Autowired(required=false)
    public void setTrustedUserContext(@Qualifier(value="metadataUser") UserContextInterface trustedUserContext) {
        this.trustedUserContext = trustedUserContext;
    }

    @Autowired(required=false)
    public void setAuthenticationService(AuthenticationServiceInterface authenticationService) {
        this.authenticationService = authenticationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationServiceInterface getAuthenticationService() {
        if (null == this.authenticationService) {
            Object object = this.serviceDiscoveryLock;
            synchronized (object) {
                if (null == this.authenticationService) {
                    LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
                    Class[] authServiceClassArr = new Class[]{AuthenticationServiceInterface.class};
                    try {
                        ServiceTemplate serviceTemplate = new ServiceTemplate(authServiceClassArr);
                        this.authenticationService = (AuthenticationServiceInterface)discoveryService.findService(serviceTemplate);
                    }
                    catch (InitializationException e) {
                        logger.warn("Could not initialize platform service to find AuthenticationService for OTP generation.", (Throwable)e);
                    }
                    catch (ServiceNotAvailableException e) {
                        logger.warn("Could not find AuthenticationService for OTP generation.", (Throwable)e);
                    }
                    catch (RemoteException e) {
                        logger.warn("Could not find AuthenticationService for OTP generation.", (Throwable)e);
                    }
                    catch (ServiceException e) {
                        logger.warn("Could not find AuthenticationService for OTP generation.", (Throwable)e);
                    }
                }
            }
        }
        return this.authenticationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserContextInterface getTrustedUserContext() {
        if (null == this.trustedUserContext) {
            Object object = this.serviceDiscoveryLock;
            synchronized (object) {
                block12: {
                    if (null == this.trustedUserContext) {
                        logger.warn("No trusted user context set, trying UserService to create trusted context");
                        if (null != this.userService) {
                            AuthenticationServiceInterface authenticationService = this.getAuthenticationService();
                            if (null != authenticationService) {
                                try {
                                    String trustedUsername = JAASUtil.getJAASOption((Environment)this.userService.getServiceConfiguration().getEnvironment(), (String)authenticationService.getLoginConfigAppName(), (String)"trusteduser");
                                    if (null != trustedUsername) {
                                        this.trustedUserContext = this.userService.getUser(trustedUsername);
                                        break block12;
                                    }
                                    logger.warn("Could not find trusted username in JAAS config.");
                                }
                                catch (RemoteException e) {
                                    logger.warn("Could not create UserContext for sastrust@saspw, giving up", (Throwable)e);
                                }
                            } else {
                                logger.warn("No authentication service set and could not discover it");
                            }
                        } else {
                            logger.warn("No local UserService set, giving up");
                        }
                    }
                }
            }
        }
        return this.trustedUserContext;
    }

    public void setIntervalCheck(long intervalCheck) {
        this.intervalCheck = intervalCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static SecurityContext newSecurityContext(String userid, AuthenticationUserDetailsService<Authentication> authenticationUserDetailsService) {
        UserDetails userDetails;
        Assert.notNull((Object)userid, (String)"Userid is required.");
        Assert.notNull(authenticationUserDetailsService, (String)"AuthenticationUserDetailsService is required.");
        String credentials = UUID.randomUUID().toString();
        UsernamePasswordAuthenticationToken preAuthToken = new UsernamePasswordAuthenticationToken((Object)userid, (Object)credentials);
        Authentication authBefore = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication((Authentication)preAuthToken);
        try {
            userDetails = authenticationUserDetailsService.loadUserDetails((Authentication)preAuthToken);
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(authBefore);
        }
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)credentials, userDetails.getAuthorities());
        SecurityContextImpl ctx = new SecurityContextImpl();
        ctx.setAuthentication((Authentication)authToken);
        return ctx;
    }

    @Deprecated
    public SecurityContext newSecurityContextWithLoginId(String loginId) {
        Assert.notNull((Object)loginId, (String)"loginId is required.");
        return new LazySpringSecurityContext(this.authenticationDetailsSource, loginId, this.userDetailsService);
    }

    public SecurityContext newSecurityContextWithLoginId(String loginId, boolean lazy) {
        Assert.notNull((Object)loginId, (String)"loginId is required.");
        UserContextInterface trustedUser = this.getTrustedUserContext();
        String failureMessage = "Could not generate OTP for " + loginId;
        if (null != trustedUser) {
            if (lazy) {
                return new LazySpringSecurityContext(this.authenticationDetailsSource, loginId, trustedUser, this.authenticationManager, this.intervalCheck, this.userDetailsService);
            }
            try {
                UserIdentityInterface userId = this.trustedUserContext.getAuthServer().generatePassword(loginId);
                return SpringSecurityContextFactory.newAuthenticatedSecurityContext(userId.getPrincipal().toString(), userId.getCredential().toString(), this.authenticationManager, this.authenticationDetailsSource);
            }
            catch (ServiceException e) {
                logger.error(failureMessage, (Throwable)e);
                throw new RuntimeException(failureMessage);
            }
            catch (RemoteException e) {
                logger.error(failureMessage, (Throwable)e);
                throw new RuntimeException(failureMessage);
            }
        }
        failureMessage = failureMessage + ". No trusted user set for SecurityContext generation.";
        logger.error(failureMessage);
        throw new RuntimeException(failureMessage);
    }

    public SecurityContext newSecurityContext(String loginId, String password) {
        return this.newSecurityContext(loginId, password, true);
    }

    public static SecurityContext newAuthenticatedSecurityContext(String loginId, String password, AuthenticationManager authenticationManager, AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource) throws AuthenticationException {
        UsernamePasswordAuthenticationToken upAuth = new UsernamePasswordAuthenticationToken((Object)loginId, (Object)password);
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        ServiceAuthenticationDetails details = null;
        details = attributes instanceof ServletRequestAttributes ? (ServiceAuthenticationDetails)authenticationDetailsSource.buildDetails((Object)((ServletRequestAttributes)attributes).getRequest()) : DEFAULT_DETAILS;
        upAuth.setDetails((Object)details);
        Authentication auth = authenticationManager.authenticate((Authentication)upAuth);
        if (auth instanceof AbstractAuthenticationToken && DEFAULT_DETAILS.equals(auth.getDetails())) {
            ((AbstractAuthenticationToken)auth).setDetails(null);
        }
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication(auth);
        return sc;
    }

    public SecurityContext newSecurityContext(String loginId, String password, boolean lazy) {
        Assert.notNull((Object)loginId, (String)"loginId is required.");
        Assert.notNull((Object)password, (String)"password is required.");
        if (lazy) {
            return new LazySpringSecurityContext(this.authenticationDetailsSource, loginId, password, this.authenticationManager, this.intervalCheck);
        }
        return SpringSecurityContextFactory.newAuthenticatedSecurityContext(loginId, password, this.authenticationManager, this.authenticationDetailsSource);
    }
}

