/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.security.ApplicationAuthorization;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.authentication.client.SecurityContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextImpl;

public class SecurityContextFactory {
    public static final String AUTHENTICATION_TOKEN_KEY = SecurityContextFactory.class.getName() + ".authenticationToken";

    public static SecurityContext newSecurityContext(SessionContextInterface sessionContext) throws RemoteException, ServiceException {
        return SecurityContextFactory.newSecurityContext(sessionContext, sessionContext.getUserContext());
    }

    public static SecurityContext newSecurityContext(UserContextInterface userContext) throws RemoteException, ServiceException {
        return SecurityContextFactory.newSecurityContext(userContext.getSessionContext(), userContext);
    }

    private static SecurityContext newSecurityContext(SessionContextInterface sessionContext, UserContextInterface userContext) throws RemoteException, ServiceException {
        String key = sessionContext.getEntityKey();
        List roles = userContext.getRoles();
        List groups = userContext.getGroups();
        IdentityInterface identity = userContext.getPerson();
        String id = null;
        String name = null;
        if (null != identity) {
            id = identity.getName();
            name = identity.getDisplayName();
            if (null == name || "".equals(name.trim())) {
                name = identity.getDescription();
            }
        } else {
            id = userContext.getUniqueId();
            name = userContext.getName();
        }
        SecurityContext ctx = new SecurityContext(key, id, name, roles, groups);
        ArrayList<String> allowedCapabilities = new ArrayList<String>();
        ArrayList<String> deniedCapabilities = new ArrayList<String>();
        ArrayList authorizations = new ArrayList();
        authorizations.addAll(userContext.getActions(ClientApplicationNameHolder.getName()));
        authorizations.addAll(userContext.getActions("SAS Application Infrastructure"));
        for (ApplicationAuthorization authorization : authorizations) {
            String actionIdentifier = authorization.getActionIdentifier();
            if (authorization.isGranted()) {
                allowedCapabilities.add(actionIdentifier);
                continue;
            }
            deniedCapabilities.add(actionIdentifier);
        }
        ctx.setAllowedCapabilities(allowedCapabilities);
        ctx.setDeniedCapabilities(deniedCapabilities);
        Authentication token = (Authentication)sessionContext.getAttribute(AUTHENTICATION_TOKEN_KEY);
        if (null != token) {
            SecurityContextImpl springCtx = new SecurityContextImpl();
            springCtx.setAuthentication(token);
            ctx.setSpringSecurityContext((org.springframework.security.core.context.SecurityContext)springCtx);
        }
        return ctx;
    }
}

