/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.framework.commons.holders.PublicUserPolicyHolder;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.svcs.config.client.ApplicationNotFoundException;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class PublicUserHelper {
    public static final String PUBLIC_USER_ROLE = "ROLE_PUBLIC";
    public static final String BEAN_NAME = "publicUserHelper";
    public static final String PUBLIC_USER_SETTING_NAME = "App.PublicIdAllowed";
    private static final Logger logger = LogManager.getLogger(PublicUserHelper.class);
    private ConfigurationServiceInterface configService;

    public static UserContextInterface handlePublicUser(UserInitializationException e, ConfigurationServiceInterface configurationService, String domain) {
        return PublicUserHelper.handlePublicUser(e, configurationService, domain, PublicUserPolicyHolder.getAllowsPublicUsers());
    }

    public static UserContextInterface handlePublicUser(UserInitializationException e, ConfigurationServiceInterface configurationService, String domain, Boolean allowsPublic) {
        PublicUserStatus status = new PublicUserStatus();
        if (null != allowsPublic) {
            status.allowed = allowsPublic;
        } else {
            status = PublicUserHelper.doesCurrentAppAllowPublicUsers(configurationService);
        }
        UserContextInterface publicUser = e.getUser();
        if (status.allowed) {
            try {
                publicUser.enableLocalAdminMode(domain);
            }
            catch (Exception e1) {
                PublicUserHelper.cleanUpUser(publicUser);
                String message = "Error initializing public user";
                logger.error("Error initializing public user", (Throwable)e1);
                throw new InsufficientAuthenticationException("Error initializing public user");
            }
        } else {
            PublicUserHelper.cleanUpUser(publicUser);
            if (null == status.reasonNotAllowed) {
                status.reasonNotAllowed = "Caller indicated public users are not allowed";
            }
            logger.warn(status.reasonNotAllowed);
            throw new InsufficientAuthenticationException(status.reasonNotAllowed);
        }
        return publicUser;
    }

    private static void cleanUpUser(UserContextInterface uci) {
        if (null != uci) {
            try {
                uci.destroy();
            }
            catch (Throwable t) {
                logger.warn("Error destroying public user", t);
            }
        }
    }

    private static PublicUserStatus doesCurrentAppAllowPublicUsers(ConfigurationServiceInterface configurationService) {
        String applicationName = ClientApplicationNameHolder.get();
        PublicUserStatus status = new PublicUserStatus();
        if (null == configurationService || null == applicationName) {
            status.reasonNotAllowed = "No configuration service or application name available to check for public user support";
            return status;
        }
        try {
            Properties settings = configurationService.getSettings(applicationName);
            if (null != settings) {
                String allowPublic = settings.getProperty(PUBLIC_USER_SETTING_NAME);
                status.allowed = Boolean.parseBoolean(allowPublic);
            }
            if (!status.allowed) {
                status.reasonNotAllowed = "Application " + applicationName + " does not allow public users";
            }
        }
        catch (ApplicationNotFoundException anf) {
            status.reasonNotAllowed = "Could not find application '" + applicationName + "' to check for public user support";
        }
        return status;
    }

    @Autowired
    public void setConfigService(ConfigurationServiceInterface configService) {
        this.configService = configService;
    }

    public boolean isCurrentUserNonPublicOrAllowed() {
        return this.isAuthenticationNonPublicOrAllowed(SecurityContextHolder.getContext().getAuthentication());
    }

    public boolean isAuthenticationNonPublicOrAllowed(Authentication authentication) {
        if (PublicUserHelper.isAuthenticationPublic(authentication)) {
            return PublicUserHelper.doesCurrentAppAllowPublicUsers((ConfigurationServiceInterface)this.configService).allowed;
        }
        return true;
    }

    public static boolean isCurrentUserPublic() {
        return PublicUserHelper.isAuthenticationPublic(SecurityContextHolder.getContext().getAuthentication());
    }

    public static boolean isAuthenticationPublic(Authentication authentication) {
        if (null != authentication) {
            for (GrantedAuthority ga : authentication.getAuthorities()) {
                if (!PUBLIC_USER_ROLE.equals(ga.getAuthority())) continue;
                return true;
            }
        }
        return false;
    }

    private static final class PublicUserStatus {
        boolean allowed;
        String reasonNotAllowed;

        private PublicUserStatus() {
        }
    }
}

